/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evaluaobject.validate;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessGroupApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.common.utils.activity.EvalObjectUtils;

public class JoinObjFromNotJoinValidator
extends AbstractValidator {
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final AssessGroupApplicationService ASSESS_GROUP_APPLICATION_SERVICE = AssessGroupApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final AssessObjectApplicationService ASSESS_OBJECT_APPLICATION_SERVICE = AssessObjectApplicationService.getInstance();
    private final long activityId;

    public JoinObjFromNotJoinValidator(Long actId) {
        this.activityId = actId;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Object[] objIds = Arrays.stream(dataEntities).map(ExtendedDataEntity::getBillPkId).toArray();
        DynamicObject[] assessObj = ASSESS_OBJECT_APPLICATION_SERVICE.loadDynamicObjectArrayByIds(objIds);
        List perffileIds = Arrays.stream(assessObj).map(obj -> obj.getDynamicObject("perfile").getLong("id")).collect(Collectors.toList());
        DynamicObject curActivity = this.getCurActivity();
        DynamicObjectCollection assGroupsEntry = curActivity.getDynamicObjectCollection("assgroupentry");
        Set actGroupIdSet = assGroupsEntry.stream().map(group -> group.getDynamicObject("assgroup").getLong("id")).collect(Collectors.toSet());
        Set<Long> scopeGroupsIds = this.getScopeGroupsByAct(curActivity);
        Set<Long> joinedObjIds = this.getJoinedObjIdsByAct(curActivity);
        Map existedEvaMap = EVALUATION_OBJECT_APPLICATION_SERVICE.queryExistEvalObjectByPerfIds(curActivity.getString("period"), perffileIds);
        String period = curActivity.getString("period");
        long schemeId = curActivity.getDynamicObject("scheme").getLong("id");
        HashSet leftTag = new HashSet(16);
        HashSet rightTag = new HashSet(16);
        if (period.charAt(4) == 'M') {
            DynamicObject scheme = ASSESS_SCHEME_APPLICATION_SERVICE.queryCycleInfoById(Long.valueOf(schemeId));
            EvalObjectUtils.getSchemeMonthPeriodStr((DynamicObject)scheme, (String)period, leftTag, rightTag);
        }
        Date actStart = curActivity.getDate("periodstartdate");
        Date actEnd = curActivity.getDate("periodenddate");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long groupId = dataEntity.getDataEntity().getDynamicObject("assgroup").getLong("id");
            long perffileId = dataEntity.getDataEntity().getLong("perfile.id");
            if (!actGroupIdSet.contains(groupId)) {
                this.recordGroupValidateMessage(dataEntity);
                continue;
            }
            Date perfStartDate = dataEntity.getDataEntity().getDate("perfile.startdate");
            Date perfEndDate = dataEntity.getDataEntity().getDate("perfile.enddate");
            if (perfStartDate != null && perfEndDate != null && (perfEndDate.compareTo(actStart) < 0 || perfStartDate.compareTo(actEnd) > 0)) {
                this.recordPerfTimeValidateMessage(dataEntity);
                continue;
            }
            String startCycle = dataEntity.getDataEntity().getString("startcycle");
            String endCycle = dataEntity.getDataEntity().getString("endcycle");
            boolean notContainsMonthPeriod = false;
            boolean notContainsOtherPeriod = false;
            if (StringUtils.isEmpty((CharSequence)endCycle)) {
                notContainsMonthPeriod = period.charAt(4) == 'M' && !leftTag.contains(startCycle);
                notContainsOtherPeriod = period.charAt(4) != 'M' && period.compareTo(startCycle) < 0;
            } else {
                notContainsMonthPeriod = rightTag.isEmpty() ? period.charAt(4) == 'M' && !leftTag.contains(startCycle) : period.charAt(4) == 'M' && (!leftTag.contains(startCycle) || !rightTag.contains(endCycle));
                notContainsOtherPeriod = period.charAt(4) != 'M' && (period.compareTo(startCycle) < 0 || period.compareTo(endCycle) > 0);
            }
            boolean notContainsScopeGroup = !scopeGroupsIds.contains(groupId);
            boolean joinedObj = joinedObjIds.contains(perffileId);
            if (notContainsMonthPeriod || notContainsOtherPeriod || notContainsScopeGroup || joinedObj) {
                this.recordNotExistValidateMessage(dataEntity);
                continue;
            }
            if (!existedEvaMap.containsKey(perffileId)) continue;
            this.recordPartInValidateMessage(dataEntity, (DynamicObject)existedEvaMap.get(perffileId));
        }
    }

    private void recordGroupValidateMessage(ExtendedDataEntity dataEntity) {
        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}-{1}\uff1a\u8003\u6838\u6d3b\u52a8\u4e2d\u4e0d\u5b58\u5728\u8003\u6838\u7ec4-{2}", (String)"JoinObjFromNotJoinValidator_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{dataEntity.getDataEntity().getDynamicObject("person").getString("name"), dataEntity.getDataEntity().getDynamicObject("person").getString("number"), dataEntity.getDataEntity().getDynamicObject("assgroup").getString("name")}));
    }

    private void recordNotExistValidateMessage(ExtendedDataEntity dataEntity) {
        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}-{1}\uff1a\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u52a0\u5165\u8003\u6838\u6d3b\u52a8", (String)"JoinObjFromNotJoinValidator_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{dataEntity.getDataEntity().getDynamicObject("person").getString("name"), dataEntity.getDataEntity().getDynamicObject("person").getString("number")}));
    }

    private void recordPartInValidateMessage(ExtendedDataEntity dataEntity, DynamicObject curActivity) {
        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}-{1}\uff1a\u5df2\u5728{2}\u4e2d\u53c2\u4e0e\u8003\u6838", (String)"JoinObjFromNotJoinValidator_2", (String)"opmc-epa-opplugin", (Object[])new Object[]{dataEntity.getDataEntity().getDynamicObject("person").getString("name"), dataEntity.getDataEntity().getDynamicObject("person").getString("number"), curActivity.getString("name")}));
    }

    private void recordPerfTimeValidateMessage(ExtendedDataEntity dataEntity) {
        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}-{1}\uff1a\u6863\u6848\u6709\u6548\u671f\u95f4\u4e0d\u5728\u8003\u6838\u5468\u671f\u8d77\u6b62\u65e5\u671f\u5185", (String)"JoinObjFromNotJoinValidator_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{dataEntity.getDataEntity().getDynamicObject("person").getString("name"), dataEntity.getDataEntity().getDynamicObject("person").getString("number")}));
    }

    private Set<Long> getScopeGroupsByAct(DynamicObject activity) {
        DynamicObject executeScheme = activity.getDynamicObject("executescheme");
        Long assessScopeId = executeScheme.getDynamicObject("assessscope").getLong("id");
        DynamicObject[] assessGroups = ASSESS_GROUP_APPLICATION_SERVICE.queryListByScopeId(true, assessScopeId);
        return Arrays.stream(assessGroups).map(group -> group.getLong("id")).collect(Collectors.toSet());
    }

    private Set<Long> getJoinedObjIdsByAct(DynamicObject activity) {
        DynamicObject[] evaluationObject = EVALUATION_OBJECT_APPLICATION_SERVICE.queryEvaluationObjectByActId((Long)activity.getPkValue());
        return Arrays.stream(evaluationObject).map(obj -> obj.getLong("perffile.id")).collect(Collectors.toSet());
    }

    private DynamicObject getCurActivity() {
        return ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)this.activityId);
    }
}

