/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.formulateschedule;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowCooperatorEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.common.utils.CommonResultBo;

public class FormulateAdjustCooperatorOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(FormulateAdjustCooperatorOp.class);
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final ActEvalObjDetailApplicationService ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE = ActEvalObjDetailApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("flowruproc");
        evt.getFieldKeys().add("taskstatus");
        evt.getFieldKeys().add("handler");
        evt.getFieldKeys().add("flowrunode");
        evt.getFieldKeys().add("flowrurole");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator(new AbstractValidator(){

            public void validate() {
                CommonResultBo commonResultBo;
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List objIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("flowruproc.actevalobj")).collect(Collectors.toList());
                Map objMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(objIds);
                HashSet<Long> passIds = new HashSet<Long>();
                String returnStr = this.getOption().getVariableValue("return_str");
                Map handlerInfo = (Map)SerializationUtils.deSerializeFromBase64((String)returnStr);
                List mainTaskIds = (List)handlerInfo.get("selectIds");
                List handlers = (List)handlerInfo.get("handlers");
                for (ExtendedDataEntity task2 : dataEntities) {
                    long objId = task2.getDataEntity().getLong("flowruproc.actevalobj");
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    String taskStatus = task2.getDataEntity().getString("taskstatus");
                    String handlerNameStr = task2.getDataEntity().getString("handler.name");
                    Long handlerId = task2.getDataEntity().getLong("handler.id");
                    String handlerName = HRStringUtils.isEmpty((String)handlerNameStr) ? "" : handlerNameStr;
                    String desc = objDy.getString("person.name") + " " + objDy.getString("person.number");
                    if (!HRStringUtils.equals((String)objDy.getString("nodestatus"), (String)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus()) || !HRStringUtils.equals((String)objDy.getString("assessnode.id"), (String)ProcessManageApEnum.TARGET_FORMULATING.getLabId()) || objDy.getLong("nodeindex") != AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId().longValue()) {
                        this.addErrorMessage(task2, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0} {1}\uff1a\u5236\u5b9a\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u5236\u5b9a\u4e2d\u201d\uff0c\u4e0d\u80fd\u8c03\u6574\u534f\u529e\u4eba\u3002", (String)"FormulateAdjustCooperatorOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")})));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.PROCESSED.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task2, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u5904\u7406\u201d\u4e0d\u80fd\u8c03\u6574\u534f\u529e\u4eba\u3002", (String)"FormulateAdjustCooperatorOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName})));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task2, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u5931\u6548\u201d\u4e0d\u80fd\u8c03\u6574\u534f\u529e\u4eba\u3002", (String)"FormulateAdjustCooperatorOp_2", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName})));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task2, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u9000\u56de\u201d\u4e0d\u80fd\u8c03\u6574\u534f\u529e\u4eba\u3002", (String)"FormulateAdjustCooperatorOp_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName})));
                        continue;
                    }
                    if (handlers != null && handlers.contains(handlerId)) {
                        this.addErrorMessage(task2, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff1a\u4efb\u52a1\u7684\u534f\u529e\u4eba\u4e0d\u80fd\u4e3a\u8be5\u4efb\u52a1\u7684\u5236\u5b9a\u4eba{1}\u3002", (String)"FormulateAdjustCooperatorOp_4", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName})));
                        continue;
                    }
                    passIds.add(task2.getDataEntity().getLong("id"));
                }
                List taskEntities = Arrays.stream(dataEntities).filter(task -> passIds.contains(task.getDataEntity().getLong("id"))).collect(Collectors.toList());
                if (ObjectUtils.isEmpty(taskEntities)) {
                    return;
                }
                HashMap<Long, List<Long>> cooperatorMap = new HashMap<Long, List<Long>>(16);
                try {
                    for (Long mainTaskId : mainTaskIds) {
                        cooperatorMap.put(mainTaskId, handlers);
                    }
                    commonResultBo = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.setCooperator(cooperatorMap, FlowCooperatorEnum.ADJUST_COOPERATOR);
                }
                catch (Exception e) {
                    try {
                        for (ExtendedDataEntity dataEntity2 : taskEntities) {
                            long objId = dataEntity2.getDataEntity().getLong("flowruproc.actevalobj");
                            DynamicObject objDy = (DynamicObject)objMap.get(objId);
                            this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"{0} {1}:\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"FormulateAdjustCooperatorOp_5", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                        }
                    }
                    catch (Exception exception) {
                        this.addErrorMessage((ExtendedDataEntity)taskEntities.get(0), ResManager.loadKDString((String)"\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"FormulateAdjustCooperatorOp_6", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    return;
                }
                LOG.info("commonResultBo: {}", (Object)commonResultBo);
                this.handlerResult(dataEntities, handlers, commonResultBo, cooperatorMap);
            }

            private void handlerResult(ExtendedDataEntity[] dataEntities, List<Long> handlers, CommonResultBo commonResultBo, Map<Long, List<Long>> cooperatorMap) {
                block7: {
                    if (commonResultBo == null) break block7;
                    if (commonResultBo.getCode() == 1) {
                        Map idUserMap = new HashMap(16);
                        if (handlers != null) {
                            idUserMap = BusinessDataServiceHelper.loadFromCache((Object[])handlers.toArray(), (String)"bos_user");
                        }
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            Long taskId = dataEntity.getDataEntity().getLong("id");
                            Map errorMsgMap = commonResultBo.getErroMsgMap();
                            if (errorMsgMap == null || cooperatorMap.get(taskId) == null) continue;
                            Map cooperatorMsg = (Map)errorMsgMap.get(taskId);
                            List<Long> cooperator = cooperatorMap.get(taskId);
                            String msgDesc = "";
                            for (Long cooperatorId : cooperator) {
                                if (idUserMap != null && !HRObjectUtils.isEmpty(idUserMap.get(cooperatorId))) {
                                    DynamicObject dynamicObject = (DynamicObject)idUserMap.get(cooperatorId);
                                    msgDesc = MessageFormat.format("{0} {1}:", dynamicObject.getString("name"), dynamicObject.getString("number"));
                                }
                                if (cooperatorMsg.get(cooperatorId) == null) continue;
                                this.addErrorMessage(dataEntity, msgDesc + (String)cooperatorMsg.get(cooperatorId));
                            }
                        }
                    } else {
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            this.addErrorMessage(dataEntity, commonResultBo.getSumResult());
                        }
                    }
                }
            }
        });
    }
}

