/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.formulateschedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.vo.ReminderVO;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;

public class FormulateTaskPushOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("person.number");
        evt.getFieldKeys().add("person.name");
        evt.getFieldKeys().add("nodestatus");
        evt.getFieldKeys().add("assessnode.id");
        evt.getFieldKeys().add("nodeindex");
        evt.getFieldKeys().add("formulateflowins");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashMap<Long, Long> objIdProcMap = new HashMap<Long, Long>(16);
                ArrayList<Long> procIds = new ArrayList<Long>(10);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject objDy = dataEntity.getDataEntity();
                    if (!HRStringUtils.equals((String)objDy.getString("nodestatus"), (String)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus()) || !HRStringUtils.equals((String)objDy.getString("assessnode.id"), (String)ProcessManageApEnum.TARGET_FORMULATING.getLabId()) || objDy.getLong("nodeindex") != AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId().longValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"{0} {1}\uff1a\u5236\u5b9a\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u5236\u5b9a\u4e2d\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"FormulateTaskPushOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                        continue;
                    }
                    procIds.add(objDy.getLong("formulateflowins.id"));
                    objIdProcMap.put(objDy.getLong("id"), objDy.getLong("formulateflowins.id"));
                }
                if (HRObjectUtils.isEmpty(procIds)) {
                    return;
                }
                DynamicObject[] procs = FLOW_RU_PROC_APPLICATION_SERVICE.queryProcByProcIds(procIds);
                HashMap<Long, DynamicObject> curNodeMap = new HashMap<Long, DynamicObject>(procs.length);
                for (DynamicObject proc : procs) {
                    curNodeMap.put(proc.getLong("id"), proc.getDynamicObject("currentnode"));
                }
                List curNodeIds = Arrays.stream(procs).filter(x -> x.getLong("currentnode.id") != 0L).map(x -> x.getLong("currentnode.id")).collect(Collectors.toList());
                if (HRObjectUtils.isEmpty(curNodeIds)) {
                    return;
                }
                Map curTaskMap = FLOW_RU_PROC_APPLICATION_SERVICE.queryTaskByNodeIds(curNodeIds);
                DynamicObject[] taskArr = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByNodeIds(curNodeIds);
                List taskIds = Arrays.stream(taskArr).filter(task -> {
                    FlowRuTaskStatusEnum status = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)task.getString("taskstatus"));
                    return status == FlowRuTaskStatusEnum.NOT_ACTIVE || status == FlowRuTaskStatusEnum.WAITING || status == FlowRuTaskStatusEnum.PROCESSING || status == FlowRuTaskStatusEnum.BE_WAITTING || status == FlowRuTaskStatusEnum.RETURNED || status == FlowRuTaskStatusEnum.PENDING;
                }).map(task -> task.getLong("id")).collect(Collectors.toList());
                Map resultMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.pushTask(taskIds);
                for (ExtendedDataEntity evalObjEntity : dataEntities) {
                    boolean isPushSuccess;
                    List tasks;
                    DynamicObject objDy = evalObjEntity.getDataEntity();
                    Long objProcId = (Long)objIdProcMap.get(objDy.getLong("id"));
                    DynamicObject currentNode = (DynamicObject)curNodeMap.get(objProcId);
                    if (HRObjectUtils.isEmpty((Object)currentNode) || HRObjectUtils.isEmpty(tasks = ((List)curTaskMap.get(currentNode.getLong("id"))).stream().filter(task -> {
                        FlowRuTaskStatusEnum status = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)task.getString("taskstatus"));
                        return status == FlowRuTaskStatusEnum.NOT_ACTIVE || status == FlowRuTaskStatusEnum.WAITING || status == FlowRuTaskStatusEnum.PROCESSING || status == FlowRuTaskStatusEnum.BE_WAITTING || status == FlowRuTaskStatusEnum.RETURNED || status == FlowRuTaskStatusEnum.PENDING;
                    }).collect(Collectors.toList())) || (isPushSuccess = tasks.stream().anyMatch(task -> {
                        ReminderVO reminderVO = (ReminderVO)resultMap.get(task.getLong("id"));
                        return reminderVO == null || reminderVO.isSucess();
                    }))) continue;
                    for (DynamicObject task2 : tasks) {
                        String taskStatus = task2.getString("taskstatus");
                        String taskStatusStr = EntityMetaDataUtils.getEntityComboFieldItemName((String)"epa_formulateflowrutask", (String)"taskstatus", (String)taskStatus);
                        ReminderVO reminderVO = (ReminderVO)resultMap.get(task2.getLong("id"));
                        if (reminderVO == null || reminderVO.isSucess()) continue;
                        if (reminderVO.getErrorType() == 2) {
                            this.addErrorMessage(evalObjEntity, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61-{0} {1}\uff1a\u5236\u5b9a\u4eba-{2}\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u4e3a\u201c\u5df2\u6302\u8d77\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"FormulateTaskPushOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), task2.getString("handler.name")})));
                            continue;
                        }
                        if (!taskIds.contains(task2.getLong("id"))) continue;
                        this.addErrorMessage(evalObjEntity, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61-{0} {1}\uff1a\u5236\u5b9a\u4eba-{2}\u5728\u5f53\u524d\u8282\u70b9\u7684\u5236\u5b9a\u4efb\u52a1\u5904\u5728\u201c{3}\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"FormulateTaskPushOp_2", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), task2.getString("handler.name"), taskStatusStr})));
                    }
                }
            }
        });
    }
}

