/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.formulateschedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskTypeEnum;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;

public class ResetFormulateOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(ResetFormulateOp.class);
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("person.number");
        evt.getFieldKeys().add("person.name");
        evt.getFieldKeys().add("nodestatus");
        evt.getFieldKeys().add("assessnode.id");
        evt.getFieldKeys().add("nodeindex");
        evt.getFieldKeys().add("formulateflowins");
        evt.getFieldKeys().add("assessstaus");
        evt.getFieldKeys().add("formulateflow");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                long startMillis = System.currentTimeMillis();
                Object[] evalObjEntities = this.getDataEntities();
                if (ObjectUtils.isEmpty((Object[])evalObjEntities)) {
                    return;
                }
                ArrayList<Long> objIds = new ArrayList<Long>(10);
                ArrayList<Long> notPreCreateObjIds = new ArrayList<Long>(10);
                OperateOption option = this.getOption();
                boolean isFormulatingForm = this.isTargetFormulatingForm(option);
                ArrayList<Long> evalObjectIds = new ArrayList<Long>(10);
                for (Object dataEntity : evalObjEntities) {
                    evalObjectIds.add(dataEntity.getDataEntity().getLong("id"));
                }
                List cannotStartEvaObjList = BatchStartEvalEntityService.getInstance().getActevaobjUnCompletedTask(evalObjectIds, TaskTypeEnum.INDICATOR_START.getValue());
                for (Object dataEntity : evalObjEntities) {
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    if (isFormulatingForm) {
                        if (!HRStringUtils.equals((String)dynamicObject.getString("nodestatus"), (String)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus()) || !HRStringUtils.equals((String)dynamicObject.getString("assessnode.id"), (String)ProcessManageApEnum.TARGET_FORMULATING.getLabId()) || dynamicObject.getLong("nodeindex") != AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId().longValue()) {
                            this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"{0} {1}\uff1a\u5236\u5b9a\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u5236\u5b9a\u4e2d\u201d\uff0c\u4e0d\u80fd\u91cd\u7f6e\u6d41\u7a0b\u3002", (String)"ResetFormulateOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{dynamicObject.getString("person.name"), dynamicObject.getString("person.number")}));
                            continue;
                        }
                        if (cannotStartEvaObjList.contains(dynamicObject.getLong("id"))) {
                            this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"{0} {1}\uff1a\u5236\u5b9a\u5bf9\u8c61\u7684\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\u6b63\u5728\u201c\u542f\u52a8\u4e2d\u201d\uff0c\u4e0d\u80fd\u91cd\u7f6e\u6d41\u7a0b\u3002", (String)"ResetFormulateOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{dynamicObject.getString("person.name"), dynamicObject.getString("person.number")}));
                            continue;
                        }
                    } else if (this.isTargetFormulatedForm(option)) {
                        if (!HRStringUtils.equals((String)dynamicObject.getString("nodestatus"), (String)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus()) || !HRStringUtils.equals((String)dynamicObject.getString("assessnode.id"), (String)ProcessManageApEnum.TARGET_FORMULATED.getLabId()) || dynamicObject.getLong("nodeindex") != AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId().longValue()) {
                            this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"{0} {1}\uff1a\u5236\u5b9a\u5bf9\u8c61\u5df2\u4e0d\u5728\u6307\u6807\u5236\u5b9a\u201c\u5df2\u5b8c\u6210\u201d\u72b6\u6001\uff0c\u65e0\u6cd5\u91cd\u7f6e\u3002", (String)"ResetFormulateOp_2", (String)"opmc-epa-opplugin", (Object[])new Object[]{dynamicObject.getString("person.name"), dynamicObject.getString("person.number")}));
                            continue;
                        }
                        if (HRStringUtils.equals((String)dynamicObject.getString("assessstaus"), (String)AssessStausEnum.COMPLETED.getStatus())) {
                            this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"{0} {1}\uff1a\u5236\u5b9a\u5bf9\u8c61\u5df2\u7ecf\u5b8c\u6210\u8003\u6838\uff0c\u65e0\u6cd5\u91cd\u7f6e\u3002", (String)"ResetFormulateOp_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{dynamicObject.getString("person.name"), dynamicObject.getString("person.number")}));
                            continue;
                        }
                    }
                    if (!ObjectUtils.isEmpty((Object)dynamicObject.getDynamicObject("formulateflow"))) {
                        objIds.add(dataEntity.getDataEntity().getLong("id"));
                        continue;
                    }
                    notPreCreateObjIds.add(dataEntity.getDataEntity().getLong("id"));
                }
                LOG.info("ResetFormulateOp formulate check use time:{}", (Object)(System.currentTimeMillis() - startMillis));
                try {
                    long resetProcsStartMillis = System.currentTimeMillis();
                    HashMap<Boolean, ArrayList<Long>> actEvalObjIdMap = new HashMap<Boolean, ArrayList<Long>>(16);
                    actEvalObjIdMap.put(Boolean.TRUE, objIds);
                    actEvalObjIdMap.put(Boolean.FALSE, notPreCreateObjIds);
                    FlowValidateResultBo resultBo = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.resetFormulate(actEvalObjIdMap);
                    Map map = resultBo.getValidateMap();
                    if (!ObjectUtils.isEmpty((Object)map)) {
                        for (Object objDy : evalObjEntities) {
                            long objId = objDy.getDataEntity().getLong("id");
                            String objRet = (String)map.get(objId);
                            if (!HRStringUtils.isNotEmpty((String)objRet)) continue;
                            this.addErrorMessage((ExtendedDataEntity)objDy, ResManager.loadKDString((String)objRet, (String)"ResetFormulateOp_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getDataEntity().getString("person.name"), objDy.getDataEntity().getString("person.number")}));
                        }
                    }
                    LOG.info("ResetFormulateOp invoke workflow use time:{}", (Object)(System.currentTimeMillis() - resetProcsStartMillis));
                    Map ruProcIdMap = resultBo.getRuProcIdMap();
                    if (!ObjectUtils.isEmpty((Object)ruProcIdMap)) {
                        long afterResetStartTime = System.currentTimeMillis();
                        ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.dealWithAfterResetFormulate(ruProcIdMap, isFormulatingForm);
                        LOG.info("ResetFormulateOp dealWithAfterResetFormulate use time:{}", (Object)(System.currentTimeMillis() - afterResetStartTime));
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    try {
                        for (Object object : evalObjEntities) {
                            this.addErrorMessage((ExtendedDataEntity)object, ResManager.loadKDString((String)"{0} {1}:\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"ResetFormulateOp_6", (String)"opmc-epa-opplugin", (Object[])new Object[]{object.getDataEntity().getString("person.name"), object.getDataEntity().getString("person.number")}));
                        }
                    }
                    catch (Exception exception) {
                        this.addErrorMessage((ExtendedDataEntity)evalObjEntities[0], ResManager.loadKDString((String)"\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"ResetFormulateOp_5", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
                    }
                }
            }

            private boolean isTargetFormulatingForm(OperateOption option) {
                return ProcessManageApEnum.TARGET_FORMULATING.getFormId().equals(option.getVariableValue("OP_SOURCE"));
            }

            private boolean isTargetFormulatedForm(OperateOption option) {
                return ProcessManageApEnum.TARGET_FORMULATED.getFormId().equals(option.getVariableValue("OP_SOURCE"));
            }
        });
    }
}

