/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.interview;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.application.service.interview.InterviewObjApplication;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.vo.AssignHandlerVO;

public class InterviewAdjustOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final ActEvalObjDetailApplicationService ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final InterviewObjApplication INTERVIEW_OBJ_APPLICATION = InterviewObjApplication.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("flowruproc");
        evt.getFieldKeys().add("taskstatus");
        evt.getFieldKeys().add("handler");
        evt.getFieldKeys().add("flowrunode");
        evt.getFieldKeys().add("flowrurole");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator(new AbstractValidator(){

            public void validate() {
                List assignHandlerVOS;
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List objIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("flowruproc.actevalobj")).collect(Collectors.toList());
                Map objMap = INTERVIEW_OBJ_APPLICATION.queryEvalObjById(objIds);
                Map curNodeTaskMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.validateTaskOfSameHandler(dataEntities);
                HashSet<Long> passIds = new HashSet<Long>();
                String selectSize = this.getOption().getVariableValue("select_size");
                for (ExtendedDataEntity task3 : dataEntities) {
                    long ruNodeId = task3.getDataEntity().getLong("flowrunode.id");
                    long objId = task3.getDataEntity().getLong("flowruproc.actevalobj");
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    String taskStatus = task3.getDataEntity().getString("taskstatus");
                    String handlerNameStr = task3.getDataEntity().getString("handler.name");
                    String handlerName = HRStringUtils.isEmpty((String)handlerNameStr) ? "" : handlerNameStr;
                    String desc = objDy.getString("person.name") + " " + objDy.getString("person.number");
                    String activityStatus = objDy.getString("interstatus");
                    if (!HRStringUtils.equals((String)ActivityStatusEnum.TO_BE_EXECUTE.getValue(), (String)activityStatus)) {
                        this.addErrorMessage(task3, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0} {1}\uff1a\u9762\u8c08\u5bf9\u8c61\u5f53\u524d\u9762\u8c08\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u9762\u8c08\u4e2d\u201d\uff0c\u4e0d\u80fd\u8c03\u6574\u5904\u7406\u4eba\u3002", (String)"InterviewAdjustOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")})));
                        continue;
                    }
                    if (this.isCanSet(curNodeTaskMap, selectSize, ruNodeId)) {
                        this.addErrorMessage(task3, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff1a\u4e0d\u80fd\u5c06\u540c\u4e00\u4e2a\u9762\u8c08\u5bf9\u8c61\u4e0b\u540c\u4e00\u4e2a\u89d2\u8272\u7684\u591a\u4e2a\u9762\u8c08\u4efb\u52a1\u7684\u5904\u7406\u4eba\u8c03\u6574\u4e3a\u540c\u4e00\u4e2a\u5904\u7406\u4eba\u3002", (String)"InterviewAdjustOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName})));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.PROCESSED.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task3, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u5904\u7406\u201d\u4e0d\u80fd\u8c03\u6574\u5904\u7406\u4eba\u3002", (String)"InterviewAdjustOp_2", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName})));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task3, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u5931\u6548\u201d\u4e0d\u80fd\u8c03\u6574\u5904\u7406\u4eba\u3002", (String)"InterviewAdjustOp_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName})));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task3, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u9000\u56de\u201d\u4e0d\u80fd\u8c03\u6574\u5904\u7406\u4eba\u3002", (String)"InterviewAdjustOp_4", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName})));
                        continue;
                    }
                    passIds.add(task3.getDataEntity().getLong("id"));
                }
                List taskEntities = Arrays.stream(dataEntities).filter(task -> passIds.contains(task.getDataEntity().getLong("id"))).collect(Collectors.toList());
                if (ObjectUtils.isEmpty(taskEntities)) {
                    return;
                }
                String returnStr = this.getOption().getVariableValue("return_str");
                Map handlerInfo = (Map)SerializationUtils.deSerializeFromBase64((String)returnStr);
                try {
                    assignHandlerVOS = INTERVIEW_OBJ_APPLICATION.modifyHandlerAfterStartProcess(taskEntities, handlerInfo);
                }
                catch (Exception e) {
                    try {
                        for (ExtendedDataEntity dataEntity2 : taskEntities) {
                            long objId = dataEntity2.getDataEntity().getLong("flowruproc.actevalobj");
                            DynamicObject objDy = (DynamicObject)objMap.get(objId);
                            this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"{0} {1}:\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"InterviewAdjustOp_5", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                        }
                    }
                    catch (Exception exception) {
                        this.addErrorMessage((ExtendedDataEntity)taskEntities.get(0), ResManager.loadKDString((String)"\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"InterviewAdjustOp_6", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    return;
                }
                Map<Long, Tuple> resMap = assignHandlerVOS.stream().collect(Collectors.toMap(AssignHandlerVO::getTaskId, task2 -> new Tuple((Object)task2.isSucess(), (Object)task2.getErrorMessage()), (task, task2) -> task2));
                for (ExtendedDataEntity dataEntity3 : taskEntities) {
                    long objId = dataEntity3.getDataEntity().getLong("flowruproc.actevalobj");
                    long handlerId = dataEntity3.getDataEntity().getLong("handler.id");
                    long taskId = dataEntity3.getDataEntity().getLong("id");
                    ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.releaseViewLock(Long.valueOf(taskId), Long.valueOf(handlerId));
                    Tuple taskRet = resMap.get(dataEntity3.getBillPkId());
                    if (taskRet == null || ((Boolean)taskRet.item1).booleanValue()) continue;
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    this.addErrorMessage(dataEntity3, ResManager.loadKDString((String)((String)taskRet.item2), (String)"InterviewAdjustOp_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                }
            }

            private boolean isCanSet(Map<Long, List<DynamicObject>> curNodeTaskMap, String selectSize, long ruNodeId) {
                return !ObjectUtils.isEmpty(curNodeTaskMap) && !ObjectUtils.isEmpty(curNodeTaskMap.get(ruNodeId)) && curNodeTaskMap.get(ruNodeId).size() > 1 && Integer.parseInt(selectSize) > 1;
            }
        });
    }
}

