/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.interview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.application.service.interview.InterviewObjApplication;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;

public class InterviewReturnOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(InterviewReturnOp.class);
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final InterviewObjApplication INTERVIEW_OBJ_APPLICATION = InterviewObjApplication.getInstance();
    private static final ActEvalObjDetailApplicationService ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE = ActEvalObjDetailApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("flowruproc");
        evt.getFieldKeys().add("taskstatus");
        evt.getFieldKeys().add("handler");
        evt.getFieldKeys().add("flowrunode");
        evt.getFieldKeys().add("flowrurole");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List objIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("flowruproc.actevalobj")).collect(Collectors.toList());
                Map objMap = INTERVIEW_OBJ_APPLICATION.queryEvalObjById(objIds);
                Map<Long, Long> taskRoleMap = Arrays.stream(dataEntities).collect(Collectors.toMap(task -> task.getDataEntity().getLong("id"), task -> task.getDataEntity().getLong("flowrurole.id")));
                if (ObjectUtils.isEmpty(taskRoleMap)) {
                    return;
                }
                ArrayList request = new ArrayList(10);
                String reason = this.getOption().getVariableValue("reason", "");
                for (ExtendedDataEntity task2 : dataEntities) {
                    long objId = task2.getDataEntity().getLong("flowruproc.actevalobj");
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    String taskStatus = task2.getDataEntity().getString("taskstatus");
                    String handlerNameStr = task2.getDataEntity().getString("handler.name");
                    String handlerName = HRStringUtils.isEmpty((String)handlerNameStr) ? "" : handlerNameStr;
                    String desc = objDy.getString("person.name") + " " + objDy.getString("person.number");
                    String activityStatus = objDy.getString("interstatus");
                    if (!HRStringUtils.equals((String)ActivityStatusEnum.TO_BE_EXECUTE.getValue(), (String)activityStatus)) {
                        this.addErrorMessage(task2, ResManager.loadKDString((String)"{0} {1}\uff1a\u9762\u8c08\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u9762\u8c08\u4e2d\u201d\uff0c\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewReturnOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.PENDING.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task2, ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u6302\u8d77\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewReturnOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task2, ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u5931\u6548\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewReturnOp_2", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task2, ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u9000\u56de\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewReturnOp_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.PROCESSING.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task2, ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5904\u7406\u4e2d\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewReturnOp_4", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.NOT_ACTIVE.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task2, ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u672a\u6fc0\u6d3b\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewReturnOp_5", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.BE_WAITTING.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task2, ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u7b49\u5f85\u4e2d\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewReturnOp_6", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus)) {
                        this.addErrorMessage(task2, ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5f85\u5904\u7406\u201d\u4e0d\u80fd\u9000\u56de\u3002", (String)"InterviewReturnOp_7", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName}));
                        continue;
                    }
                    InterviewReturnOp.this.addPassTask(request, reason, task2, objDy);
                }
                if (HRCollUtil.isEmpty(request)) {
                    return;
                }
                try {
                    FlowValidateResultBo resultBo = INTERVIEW_OBJ_APPLICATION.rollbackTask(request);
                    Map validateMap = resultBo.getValidateMap();
                    ArrayList<Long> allObjList = new ArrayList<Long>(10);
                    ArrayList<Long> failObjList = new ArrayList<Long>(10);
                    ArrayList<Long> successObjList = new ArrayList<Long>(10);
                    if (!HRStringUtils.equals((String)resultBo.getCode(), (String)"1") && !ObjectUtils.isEmpty((Object)validateMap)) {
                        for (Object task3 : dataEntities) {
                            long taskId = task3.getDataEntity().getLong("id");
                            long objId = task3.getDataEntity().getLong("flowruproc.actevalobj");
                            allObjList.add(objId);
                            DynamicObject objDy = (DynamicObject)objMap.get(objId);
                            String taskRet = (String)validateMap.get(taskId);
                            if (!HRStringUtils.isNotEmpty((String)taskRet)) continue;
                            failObjList.add(objId);
                            this.addErrorMessage((ExtendedDataEntity)task3, ResManager.loadKDString((String)taskRet, (String)"InterviewReturnOp_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                        }
                        for (Long objId : allObjList) {
                            if (failObjList.contains(objId)) continue;
                            successObjList.add(objId);
                        }
                    }
                    if (HRStringUtils.equals((String)resultBo.getCode(), (String)"1")) {
                        for (Object task3 : dataEntities) {
                            long objId = task3.getDataEntity().getLong("flowruproc.actevalobj");
                            successObjList.add(objId);
                            long handlerId = task3.getDataEntity().getLong("handler.id");
                            long taskId = task3.getDataEntity().getLong("id");
                            ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.releaseViewLock(Long.valueOf(taskId), Long.valueOf(handlerId));
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    try {
                        for (ExtendedDataEntity task4 : dataEntities) {
                            long objId = task4.getDataEntity().getLong("flowruproc.actevalobj");
                            DynamicObject objDy = (DynamicObject)objMap.get(objId);
                            this.addErrorMessage(task4, ResManager.loadKDString((String)"{0} {1}:\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"InterviewReturnOp_9", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                        }
                    }
                    catch (Exception exception) {
                        this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"InterviewReturnOp_10", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    private void addPassTask(List<RollbackParamBo> request, String reason, ExtendedDataEntity task, DynamicObject objDy) {
        RollbackParamBo tmp = new RollbackParamBo();
        tmp.setActivityId(Long.valueOf(objDy.getDynamicObject("interact").getLong("id")));
        tmp.setActevalobjId(Long.valueOf(objDy.getLong("id")));
        tmp.setRuProcId(Long.valueOf(task.getDataEntity().getLong("flowruproc.id")));
        tmp.setRuNodeId(Long.valueOf(task.getDataEntity().getLong("flowrunode.id")));
        tmp.setRuTaskId(Long.valueOf(task.getDataEntity().getLong("id")));
        tmp.setRollbackType("3");
        tmp.setReason(reason);
        request.add(tmp);
    }
}

