/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.interview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.interview.InterviewObjApplication;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.vo.ReminderVO;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;

public class InterviewTaskPushOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final InterviewObjApplication INTERVIEW_OBJ_APPLICATION = InterviewObjApplication.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("flowruproc");
        e.getFieldKeys().add("taskstatus");
        e.getFieldKeys().add("handler");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List objIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("flowruproc.actevalobj")).collect(Collectors.toList());
                Map objMap = INTERVIEW_OBJ_APPLICATION.queryEvalObjById(objIds);
                if (ObjectUtils.isEmpty((Object)objMap)) {
                    return;
                }
                ArrayList<Long> taskIds = new ArrayList<Long>(10);
                for (ExtendedDataEntity dataEntity2 : dataEntities) {
                    long objId = dataEntity2.getDataEntity().getLong("flowruproc.actevalobj");
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    String activityStatus = objDy.getString("interstatus");
                    if (!HRStringUtils.equals((String)ActivityStatusEnum.TO_BE_EXECUTE.getValue(), (String)activityStatus)) {
                        this.addErrorMessage(dataEntity2, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0} {1}\uff1a\u9762\u8c08\u5bf9\u8c61\u5f53\u524d\u9762\u8c08\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u9762\u8c08\u4e2d\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"InterviewTaskPushOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")})));
                        continue;
                    }
                    long taskId = (Long)dataEntity2.getDataEntity().getPkValue();
                    taskIds.add(taskId);
                }
                Map resultMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.pushTask(taskIds);
                for (ExtendedDataEntity dataEntity3 : dataEntities) {
                    long objId = dataEntity3.getDataEntity().getLong("flowruproc.actevalobj");
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    ReminderVO reminderVO = (ReminderVO)resultMap.get((Long)dataEntity3.getBillPkId());
                    if (reminderVO != null && reminderVO.isSucess()) continue;
                    String taskStatus = dataEntity3.getDataEntity().getString("taskstatus");
                    String taskStatusStr = EntityMetaDataUtils.getEntityComboFieldItemName((String)"epa_interflowrutask", (String)"taskstatus", (String)taskStatus);
                    if (reminderVO != null && reminderVO.getErrorType() == 2) {
                        this.addErrorMessage(dataEntity3, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u9762\u8c08\u5bf9\u8c61-{0} {1}\uff1a\u5904\u7406\u4eba-{2}\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u4e3a\u201c\u5df2\u6302\u8d77\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"InterviewTaskPushOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), dataEntity3.getDataEntity().getString("handler.name")})));
                        continue;
                    }
                    long taskId = (Long)dataEntity3.getDataEntity().getPkValue();
                    if (!taskIds.contains(taskId)) continue;
                    this.addErrorMessage(dataEntity3, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u9762\u8c08\u5bf9\u8c61-{0} {1}\uff1a\u5904\u7406\u4eba-{2}\u5728\u5f53\u524d\u8282\u70b9\u7684\u9762\u8c08\u4efb\u52a1\u5904\u5728\u201c{3}\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"InterviewTaskPushOp_2", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), dataEntity3.getDataEntity().getString("handler.name"), taskStatusStr})));
                }
            }
        });
    }
}

