/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.assessform;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.opplugin.web.assessform.validator.AssessFormArithmeticSumValidator;
import kd.opmc.epa.opplugin.web.assessform.validator.SumModeNormalScoreValidator;

public class AssessFormSaveOp
extends HRDataBaseOp {
    private static final AssessRuleApplicationService ASSESS_RULE_APPLICATION_SERVICE = AssessRuleApplicationService.getInstance();

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AssessFormArithmeticSumValidator());
        e.addValidator((AbstractValidator)new SumModeNormalScoreValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            String consistentWithArea = dataEntity.getString("consistentwitharea");
            String scoreCalcWay = dataEntity.getString("scorecalcway");
            if (!ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) continue;
            long scoreSystemId = dataEntity.getLong("scoresystem.id");
            DynamicObjectCollection coll = dataEntity.getDynamicObjectCollection("areaconfentry");
            Set normalAreaConfIdSet = coll.stream().filter(dynObj -> AssessRuleConstants.NORM_INDCTR_AREA_PK.longValue() == dynObj.getLong("areareg.id")).map(dynObj -> dynObj.getLong("areaconf")).collect(Collectors.toSet());
            DynamicObject[] normalConfDynObjArr = ASSESS_RULE_APPLICATION_SERVICE.queryNormalConfigByIds(normalAreaConfIdSet);
            ArrayList<DynamicObject> needUpdateScoreSystemList = new ArrayList<DynamicObject>(10);
            for (DynamicObject normalConfDynObj : normalConfDynObjArr) {
                long areaScoreSystemId = normalConfDynObj.getLong("scoresystem.id");
                if (!"1".equals(consistentWithArea) || scoreSystemId == areaScoreSystemId) continue;
                normalConfDynObj.set("scoresystem", (Object)scoreSystemId);
                needUpdateScoreSystemList.add(normalConfDynObj);
            }
            ASSESS_RULE_APPLICATION_SERVICE.updateNormalConfigArr(needUpdateScoreSystemList.toArray(new DynamicObject[0]));
        }
    }
}

