/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.assessform.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;

public class SingleNormalScoreValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        OperateOption option = this.getOption();
        String scoreCalcWay = option.getVariableValue("scorecalcway");
        String limitMaxRatioStr = option.getVariableValue("limitmaxratio");
        String numAccuracyStr = option.getVariableValue("numaccuracy");
        String evaSumLimitStr = option.getVariableValue("evasumlimit");
        for (ExtendedDataEntity extendDataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dataEntity = extendDataEntity.getDataEntity();
            if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
                BigDecimal maxScore = new BigDecimal(option.getVariableValue("maxScore"));
                BigDecimal areaConfigScore = dataEntity.getBigDecimal("areascore");
                if (areaConfigScore.compareTo(maxScore) <= 0) continue;
                this.addErrorMessage(extendDataEntity, ResManager.loadKDString((String)"\u533a\u57df\u5206\u503c\u9700\u8981\u5c0f\u4e8e\u7b49\u4e8e\u8bc4\u5206\u5206\u5236\u57fa\u51c6\u6700\u9ad8\u5206\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u533a\u57df\u5206\u503c\u3002", (String)"SingleNormalScoreValidator_0", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) continue;
            BigDecimal areaConfigWeight = dataEntity.getBigDecimal("weight");
            if (evaSumLimitStr != null && EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimitStr)) {
                BigDecimal limitMaxRatioBD = new BigDecimal(100);
                if (limitMaxRatioStr != null) {
                    int numAccuracy = 4;
                    limitMaxRatioBD = new BigDecimal(limitMaxRatioStr);
                    if (numAccuracyStr != null) {
                        try {
                            numAccuracy = Integer.parseInt(numAccuracyStr);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        limitMaxRatioBD = limitMaxRatioBD.setScale(numAccuracy);
                    }
                }
                if (areaConfigWeight.compareTo(limitMaxRatioBD) <= 0) continue;
                this.addErrorMessage(extendDataEntity, ResManager.loadKDString((String)"\u533a\u57df\u6743\u91cd\u5df2\u8d85\u8fc7{0}%\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u8be5\u533a\u57df\u6743\u91cd\u503c\u3002", (String)"SingleNormalScoreValidator_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{limitMaxRatioBD}));
                continue;
            }
            if (areaConfigWeight.compareTo(new BigDecimal("100.0")) <= 0) continue;
            this.addErrorMessage(extendDataEntity, ResManager.loadKDString((String)"\u533a\u57df\u6743\u91cd\u4e0d\u80fd\u8d85\u8fc7100%\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SingleNormalScoreValidator_2", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
        }
    }
}

