/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.assessform.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;

public class SumModeNormalScoreValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(SumModeNormalScoreValidator.class);
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity extendDataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dataEntity = extendDataEntity.getDataEntity();
            String scoreCalcWay = dataEntity.getString("scorecalcway");
            DynamicObjectCollection areaConfColl = dataEntity.getDynamicObjectCollection("areaconfentry");
            HashSet<Long> areaConfIdSet = new HashSet<Long>(16);
            for (DynamicObject areaConf : areaConfColl) {
                String areaRegNumber = areaConf.getString("areareg.number");
                if (!"epa_normindctrarea".equals(areaRegNumber)) continue;
                Long l = areaConf.getLong("areaconfnew") == 0L ? areaConf.getLong("areaconf") : areaConf.getLong("areaconfnew");
                areaConfIdSet.add(l);
            }
            DynamicObject[] normalConfigDynObjArr = ASSESS_RULE_APP_SERVICE.queryNormalConfigByIds(areaConfIdSet);
            if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
                if (areaConfIdSet.isEmpty()) continue;
                BigDecimal maxScore = dataEntity.getBigDecimal("scoresystem.maxscore");
                BigDecimal areaConfigScore = BigDecimal.ZERO;
                for (DynamicObject normalConfigDynObj : normalConfigDynObjArr) {
                    areaConfigScore = areaConfigScore.add(normalConfigDynObj.getBigDecimal("areascore"));
                }
                if (areaConfigScore.compareTo(maxScore) == 0) continue;
                this.addFatalErrorMessage(extendDataEntity, ResManager.loadKDString((String)"\u6574\u5355\u5206\u503c\u548c\u9700\u8981\u7b49\u4e8e\u8bc4\u5206\u5206\u5236\u57fa\u51c6\u6700\u9ad8\u5206\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u533a\u57df\u5206\u503c\u3002", (String)"SumModeNormalScoreValidator_0", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) continue;
            BigDecimal areaConfigWeight = BigDecimal.ZERO;
            String consistentWithArea = dataEntity.getString("consistentwitharea");
            for (DynamicObject normalConfigDynObj : normalConfigDynObjArr) {
                areaConfigWeight = areaConfigWeight.add(normalConfigDynObj.getBigDecimal("weight"));
                if (!"0".equals(consistentWithArea) || normalConfigDynObj.get("scoresystem") != null) continue;
                String scoreSystemName = EntityMetadataCache.getDataEntityType((String)"epa_assessform").getProperty("scoresystem").getDisplayName().toString();
                LOG.info("sum mode score system name: " + scoreSystemName);
                String tips = ResManager.loadKDString((String)"\u8bf7\u586b\u5199%1$s\u7684%2$s\u3002", (String)"SumModeNormalScoreValidator_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{normalConfigDynObj.getString("areacustname"), scoreSystemName});
                LOG.info("sum mode validate tips: " + tips);
                this.addFatalErrorMessage(extendDataEntity, tips);
            }
            if (EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(extendDataEntity.getDataEntity().getString("evasumlimit"))) {
                BigDecimal bigDecimal = dataEntity.getBigDecimal("limitmaxratio");
                if (areaConfigWeight.compareTo(bigDecimal) <= 0 && areaConfigWeight.compareTo(new BigDecimal(100)) >= 0) continue;
                int scale = 0;
                try {
                    String scaleStr = extendDataEntity.getDataEntity().getString("numaccuracy");
                    scale = Integer.parseInt(scaleStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.addFatalErrorMessage(extendDataEntity, ResManager.loadKDString((String)"\u6574\u5355\u533a\u57df\u6743\u91cd\u548c\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u8bc4\u4f30\u8868\u5355\u5236\u5b9a\u6743\u91cd\u9650\u5236\u6700\u9ad8\u6bd4\u4f8b\u201d\uff1a{0}\uff0c\u5927\u4e8e\u7b49\u4e8e{1}\u3002", (String)"SumModeNormalScoreValidator_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{bigDecimal.setScale(scale).toString(), new BigDecimal(100).setScale(scale).toString()}));
                continue;
            }
            if (areaConfigWeight.compareTo(new BigDecimal("100.0")) == 0) continue;
            this.addFatalErrorMessage(extendDataEntity, ResManager.loadKDString((String)"\u6574\u5355\u533a\u57df\u6743\u91cd\u548c\u9700\u4e3a100%\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u533a\u57df\u6743\u91cd\u3002", (String)"SumModeNormalScoreValidator_4", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
        }
    }
}

