/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.interview;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.application.service.interview.InterviewObjApplication;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.vo.AssignHandlerVO;

public class InterviewDelFormulatorOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final InterviewObjApplication INTERVIEW_OBJ_APPLICATION = InterviewObjApplication.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final ActEvalObjDetailApplicationService ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE = ActEvalObjDetailApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("flowruproc");
        evt.getFieldKeys().add("taskstatus");
        evt.getFieldKeys().add("handler");
        evt.getFieldKeys().add("flowrunode");
        evt.getFieldKeys().add("flowrurole");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator(new AbstractValidator(){

            public void validate() {
                List assignHandlerVOS;
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List objIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("flowruproc.actevalobj")).collect(Collectors.toList());
                Map objMap = INTERVIEW_OBJ_APPLICATION.queryEvalObjById(objIds);
                Map<Long, Long> taskRoleMap = Arrays.stream(dataEntities).collect(Collectors.toMap(task -> task.getDataEntity().getLong("id"), task -> task.getDataEntity().getLong("flowrurole.id")));
                if (ObjectUtils.isEmpty(taskRoleMap)) {
                    return;
                }
                List roleIds = Arrays.stream(dataEntities).map(task -> task.getDataEntity().getLong("flowrurole.id")).collect(Collectors.toList());
                Object[] taskDys = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByRunRoleIds(roleIds);
                HashSet<Long> passIds = new HashSet<Long>();
                for (ExtendedDataEntity task3 : dataEntities) {
                    long objId = task3.getDataEntity().getLong("flowruproc.actevalobj");
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    String roleStatus = task3.getDataEntity().getString("flowrurole.rolestatus");
                    String taskStatus = task3.getDataEntity().getString("taskstatus");
                    String handlerNameStr = task3.getDataEntity().getString("handler.name");
                    String handlerNumberStr = task3.getDataEntity().getString("handler.number");
                    String handlerName = HRStringUtils.isEmpty((String)handlerNameStr) ? "" : handlerNameStr;
                    String handlerNumber = HRStringUtils.isEmpty((String)handlerNumberStr) ? "" : handlerNumberStr;
                    String handler = handlerName + " " + handlerNumber;
                    String desc = objDy.getString("person.name") + " " + objDy.getString("person.number");
                    String activityStatus = objDy.getString("interstatus");
                    if (!HRStringUtils.equals((String)ActivityStatusEnum.TO_BE_EXECUTE.getValue(), (String)activityStatus)) {
                        this.addErrorMessage(task3, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff1a\u9762\u8c08\u5bf9\u8c61\u5f53\u524d\u9762\u8c08\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u9762\u8c08\u4e2d\u201d\uff0c\u4e0d\u53ef\u5220\u9664\u5904\u7406\u4eba\u3002", (String)"InterviewDelFormulatorOp_7", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc})));
                        continue;
                    }
                    if (InterviewDelFormulatorOp.this.getCanRoleStatus().contains(roleStatus)) {
                        String text = FlowRuRoleStatusEnum.getFlowRuRoleStatusByCode((String)roleStatus).getText();
                        this.addErrorMessage(task3, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff1a\u5904\u7406\u4eba-{1}\u5728\u5f53\u524d\u4efb\u52a1\u5bf9\u5e94\u7684\u89d2\u8272\u72b6\u6001\u4e3a\u201c{2}\u201d\uff0c\u4e0d\u53ef\u5220\u9664\u5904\u7406\u4eba\u3002", (String)"InterviewDelFormulatorOp_8", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handler, text})));
                        continue;
                    }
                    if (InterviewDelFormulatorOp.this.getCanTaskStatus().contains(taskStatus)) {
                        String taskStatusStr = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatus).getText();
                        this.addErrorMessage(task3, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff1a\u5904\u7406\u4eba-{1}\u5f53\u524d\u9762\u8c08\u4efb\u52a1\u72b6\u6001\u4e3a\u201c{2}\u201c\uff0c\u4e0d\u53ef\u5220\u9664\u5904\u7406\u4eba\u3002", (String)"InterviewDelFormulatorOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handler, taskStatusStr})));
                        continue;
                    }
                    if (ObjectUtils.isEmpty((Object[])taskDys) || taskDys.length <= 1) {
                        this.addErrorMessage(task3, ResManager.loadKDString((String)"{0}\uff1a\u5904\u7406\u4eba-{1}\u4e3a\u5f53\u524d\u89d2\u8272\u4e0b\u9762\u8c08\u4efb\u52a1\u7684\u60df\u4e00\u6709\u6548\u5904\u7406\u4eba\uff0c\u4e0d\u53ef\u5220\u9664\u5904\u7406\u4eba\u3002", (String)"InterviewDelFormulatorOp_4", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handler}));
                        continue;
                    }
                    passIds.add(task3.getDataEntity().getLong("id"));
                }
                List taskEntities = Arrays.stream(dataEntities).filter(task -> passIds.contains(task.getDataEntity().getLong("id"))).collect(Collectors.toList());
                if (ObjectUtils.isEmpty(taskEntities)) {
                    return;
                }
                try {
                    assignHandlerVOS = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.deleteHandlerAfterStartProcess(taskEntities, "3");
                }
                catch (Exception e) {
                    try {
                        for (ExtendedDataEntity dataEntity2 : taskEntities) {
                            long objId = dataEntity2.getDataEntity().getLong("flowruproc.actevalobj");
                            DynamicObject objDy = (DynamicObject)objMap.get(objId);
                            this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"{0} {1}:\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"InterviewDelFormulatorOp_6", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                        }
                    }
                    catch (Exception exception) {
                        this.addErrorMessage((ExtendedDataEntity)taskEntities.get(0), ResManager.loadKDString((String)"\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"InterviewDelFormulatorOp_5", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    return;
                }
                Map<Long, Tuple> resMap = assignHandlerVOS.stream().collect(Collectors.toMap(AssignHandlerVO::getTaskId, task2 -> new Tuple((Object)task2.isSucess(), (Object)task2.getErrorMessage()), (task, task2) -> task2));
                for (ExtendedDataEntity dataEntity3 : taskEntities) {
                    long handlerId = dataEntity3.getDataEntity().getLong("handler.id");
                    long taskId = dataEntity3.getDataEntity().getLong("id");
                    ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.releaseViewLock(Long.valueOf(taskId), Long.valueOf(handlerId));
                    long objId = dataEntity3.getDataEntity().getLong("flowruproc.actevalobj");
                    Tuple taskRet = resMap.get(dataEntity3.getBillPkId());
                    if (taskRet == null || ((Boolean)taskRet.item1).booleanValue()) continue;
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    this.addErrorMessage(dataEntity3, ResManager.loadKDString((String)((String)taskRet.item2), (String)"InterviewDelFormulatorOp_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                }
            }
        });
    }

    private HashSet<String> getCanRoleStatus() {
        return new HashSet<String>(Arrays.asList(FlowRuRoleStatusEnum.FINISHED.getCode(), FlowRuRoleStatusEnum.EXPIRED.getCode(), FlowRuRoleStatusEnum.RETURNED.getCode()));
    }

    private HashSet<String> getCanTaskStatus() {
        return new HashSet<String>(Arrays.asList(FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.EXPIRED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
    }
}

