/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.interview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.common.enums.interview.InterStatusEnum;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;

public class ResetInterviewProcessOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(ResetInterviewProcessOp.class);
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("interflow");
        evt.getFieldKeys().add("interflowins");
        evt.getFieldKeys().add("person.name");
        evt.getFieldKeys().add("person.number");
        evt.getFieldKeys().add("interstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            /*
             * WARNING - void declaration
             */
            public void validate() {
                Object[] evalObjEntities = this.getDataEntities();
                if (ObjectUtils.isEmpty((Object[])evalObjEntities)) {
                    return;
                }
                ArrayList<Long> objIds = new ArrayList<Long>(10);
                ArrayList<Long> notPreCreateObjIds = new ArrayList<Long>(10);
                OperateOption option = this.getOption();
                boolean isInterviewingForm = this.isInterviewingForm(option);
                ArrayList<Long> interFlowInsIdList = new ArrayList<Long>(10);
                for (Object dataEntity : evalObjEntities) {
                    DynamicObject objDy = dataEntity.getDataEntity();
                    interFlowInsIdList.add(objDy.getLong("interflowins.id"));
                }
                DynamicObject[] ruProDyns = FlowRuProcEntityService.getInstance().loadRuProcByIds(interFlowInsIdList);
                Map<Long, String> actEvaObjProcStatusMap = Arrays.stream(ruProDyns).collect(Collectors.toMap(k -> k.getLong("actevalobj"), v -> v.getString("procstatus")));
                for (Object object : evalObjEntities) {
                    DynamicObject dynamicObject = object.getDataEntity();
                    if (isInterviewingForm) {
                        if (!HRStringUtils.equals((String)dynamicObject.getString("interstatus"), (String)"20")) {
                            this.addErrorMessage((ExtendedDataEntity)object, ResManager.loadKDString((String)"{0} {1}\uff1a\u9762\u8c08\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u9762\u8c08\u4e2d\u201d\uff0c\u4e0d\u80fd\u91cd\u7f6e\u6d41\u7a0b\u3002", (String)"ResetInterviewProcessOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{dynamicObject.getString("person.name"), dynamicObject.getString("person.number")}));
                            continue;
                        }
                        if (FlowRuProcStatusEnum.NOTACTIVE.getCode().equals(actEvaObjProcStatusMap.get(dynamicObject.getLong("id")))) {
                            this.addErrorMessage((ExtendedDataEntity)object, ResManager.loadKDString((String)"{0} {1}\uff1a\u9762\u8c08\u5bf9\u8c61\u7684\u7ee9\u6548\u9762\u8c08\u6d41\u7a0b\u6b63\u5728\u201c\u542f\u52a8\u4e2d\u201d\uff0c\u4e0d\u80fd\u91cd\u7f6e\u6d41\u7a0b\u3002", (String)"ResetInterviewProcessOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{dynamicObject.getString("person.name"), dynamicObject.getString("person.number")}));
                            continue;
                        }
                    } else if (this.isInterviewedForm(option)) {
                        if (!HRStringUtils.equals((String)dynamicObject.getString("interstatus"), (String)"30") && !HRStringUtils.equals((String)dynamicObject.getString("interstatus"), (String)"50")) {
                            this.addErrorMessage((ExtendedDataEntity)object, ResManager.loadKDString((String)"{0} {1}\uff1a\u9762\u8c08\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c{2}\u201d\uff0c\u65e0\u6cd5\u91cd\u7f6e\u3002", (String)"ResetInterviewProcessOp_2", (String)"opmc-epa-opplugin", (Object[])new Object[]{dynamicObject.getString("person.name"), dynamicObject.getString("person.number"), InterStatusEnum.getText((String)dynamicObject.getString("interstatus"))}));
                            continue;
                        }
                        if (!FlowRuProcStatusEnum.FINISHED.getCode().equals(actEvaObjProcStatusMap.get(dynamicObject.getLong("id")))) {
                            this.addErrorMessage((ExtendedDataEntity)object, ResManager.loadKDString((String)"{0} {1}\uff1a\u9762\u8c08\u5bf9\u8c61\u7684\u9762\u8c08\u6d41\u7a0b\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u7ed3\u675f\u201d\uff0c\u4e0d\u80fd\u91cd\u7f6e\u6d41\u7a0b\u3002", (String)"ResetInterviewProcessOp_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{dynamicObject.getString("person.name"), dynamicObject.getString("person.number")}));
                            continue;
                        }
                    }
                    if (!ObjectUtils.isEmpty((Object)dynamicObject.getDynamicObject("interflow"))) {
                        objIds.add(object.getDataEntity().getLong("id"));
                        continue;
                    }
                    notPreCreateObjIds.add(object.getDataEntity().getLong("id"));
                }
                try {
                    Map map;
                    HashMap<Boolean, ArrayList<Long>> actEvalObjIdMap = new HashMap<Boolean, ArrayList<Long>>(16);
                    actEvalObjIdMap.put(Boolean.TRUE, objIds);
                    actEvalObjIdMap.put(Boolean.FALSE, notPreCreateObjIds);
                    FlowValidateResultBo resultBo = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.resetInterviewPro(actEvalObjIdMap);
                    Map validateMap = resultBo.getValidateMap();
                    if (!ObjectUtils.isEmpty((Object)validateMap)) {
                        for (Object objDy : evalObjEntities) {
                            long objId = objDy.getDataEntity().getLong("id");
                            String objRet = (String)validateMap.get(objId);
                            if (!HRStringUtils.isNotEmpty((String)objRet)) continue;
                            this.addErrorMessage((ExtendedDataEntity)objDy, ResManager.loadKDString((String)objRet, (String)"ResetInterviewProcessOp_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getDataEntity().getString("person.name"), objDy.getDataEntity().getString("person.number")}));
                        }
                    }
                    if (!ObjectUtils.isEmpty((Object)(map = resultBo.getRuProcIdMap()))) {
                        ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.dealWithAfterResetInterview(map);
                    }
                }
                catch (Exception e) {
                    try {
                        void var12_26;
                        Object[] resultBo = evalObjEntities;
                        int n = resultBo.length;
                        boolean bl = false;
                        while (var12_26 < n) {
                            Object object = resultBo[var12_26];
                            this.addErrorMessage((ExtendedDataEntity)object, ResManager.loadKDString((String)"{0} {1}:\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"ResetInterviewProcessOp_4", (String)"opmc-epa-opplugin", (Object[])new Object[]{object.getDataEntity().getString("person.name"), object.getDataEntity().getString("person.number")}));
                            ++var12_26;
                        }
                    }
                    catch (Exception exception) {
                        this.addErrorMessage((ExtendedDataEntity)evalObjEntities[0], ResManager.loadKDString((String)"\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"ResetInterviewProcessOp_6", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
                    }
                }
            }

            private boolean isInterviewingForm(OperateOption option) {
                return "epa_interviewingobj".equals(option.getVariableValue("OP_SOURCE"));
            }

            private boolean isInterviewedForm(OperateOption option) {
                return "epa_interviewedobj".equals(option.getVariableValue("OP_SOURCE"));
            }
        });
    }
}

