/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.perfresult;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.perfresult.PerfResultApplicationService;
import kd.opmc.epa.opplugin.web.perfresult.validator.PrefResultRequiredValidator;

public class PrefResultRequiredOp
extends HRDataBaseOp {
    private static final PerfResultApplicationService PERF_RESULT_APPLICATION_SERVICE = PerfResultApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("activity");
        args.getFieldKeys().add("score");
        args.getFieldKeys().add("perflevelf7");
        args.getFieldKeys().add("assesslevel");
        args.getFieldKeys().add("rankresultentity.rankdimension");
        args.getFieldKeys().add("rankresultentity.dimensionname");
        args.getFieldKeys().add("rankresultentity.ranking");
        args.getFieldKeys().add("rankresultentity.totalrankpeople");
        args.getFieldKeys().add("overallresultentity.roletype");
        args.getFieldKeys().add("overallresultentity.assessuser");
        args.getFieldKeys().add("overallresultentity.overall");
        args.getFieldKeys().add("schemef7");
        args.getFieldKeys().add("person");
        args.getFieldKeys().add("perffilef7");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new PrefResultRequiredValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            long cycleTypeId = dataEntity.getDynamicObject("schemef7").getDynamicObject("cycletype").getLong("id");
            Object year = dataEntity.getDynamicObject("activity").get("year");
            String assessPeriod = dataEntity.getDynamicObject("activity").getString("period");
            String activityName = dataEntity.getDynamicObject("activity").getString("name");
            String personNumber = dataEntity.getDynamicObject("person").getString("number");
            dataEntity.set("cycletype", (Object)cycleTypeId);
            dataEntity.set("year", year);
            dataEntity.set("assessperiod", (Object)assessPeriod);
            dataEntity.set("period", (Object)assessPeriod.substring(4));
            dataEntity.set("activityname", (Object)activityName);
            dataEntity.set("personNumber", (Object)personNumber);
            Long perfId = dataEntity.getDynamicObject("perffilef7").getLong("id");
            DynamicObject[] perfList = PERF_RESULT_APPLICATION_SERVICE.getPerffileListByIds(Collections.singletonList(perfId));
            DynamicObject empposrelObject = perfList[0].getDynamicObject("empposrel");
            dataEntity.set("adminorgname", (Object)empposrelObject.getString("adminorg.name"));
            dataEntity.set("companyname", (Object)empposrelObject.getString("company.name"));
            dataEntity.set("positionName", (Object)empposrelObject.getString("position.name"));
            dataEntity.set("jobname", (Object)empposrelObject.getString("job.name"));
        }
    }
}

