/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.perfsum;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumCalErrorInfo;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumCalResultBo;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;

public class ResetSumRulelOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("person");
        e.getFieldKeys().add("assessnode");
        e.getFieldKeys().add("nodestatus");
        e.getFieldKeys().add("nodeindex");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String prenode = this.getOption().getVariableValue("prenode", "");
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List objIds = Arrays.stream(dataEntities).filter(dataEntity -> {
                    boolean a;
                    DynamicObject objDy = dataEntity.getDataEntity();
                    long preNodeId = Long.parseLong(prenode);
                    if (preNodeId == 0L) {
                        a = objDy.getInt("nodeindex") == 0 && preNodeId == objDy.getLong("assessnode.id") && StringUtils.isBlank((CharSequence)objDy.getString("nodestatus"));
                    } else {
                        String lastNodeStatus = AssessNodeStatusEnum.getLastNodeStatus((Long)preNodeId).getStatus();
                        a = objDy.getInt("nodeindex") >= 1 && preNodeId == objDy.getLong("assessnode.id") && lastNodeStatus.equals(objDy.getString("nodestatus"));
                    }
                    List<String> statusList = Arrays.asList(AssessNodeStatusEnum.TO_BE_MP.getStatus(), AssessNodeStatusEnum.MPING.getStatus());
                    boolean b = NodeTabMapEnum.PERF_SUM.getNodeId().longValue() == objDy.getLong("assessnode.id") && statusList.contains(objDy.getString("nodestatus"));
                    return a || b;
                }).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
                PerfSumCalResultBo perfSumCalResultBo = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.resetDefaultRule(objIds);
                if ("0".equals(perfSumCalResultBo.getOperationType())) {
                    List errorInfoList = perfSumCalResultBo.getErrorInfoList();
                    Map<Long, String> resultMap = errorInfoList.stream().collect(Collectors.toMap(PerfSumCalErrorInfo::getEvalObjId, PerfSumCalErrorInfo::getErrorMsg));
                    for (ExtendedDataEntity dataEntity2 : dataEntities) {
                        String message;
                        boolean b;
                        boolean a;
                        DynamicObject objDy = dataEntity2.getDataEntity();
                        long preNodeId = Long.parseLong(prenode);
                        if (preNodeId == 0L) {
                            a = objDy.getInt("nodeindex") == 0 && preNodeId == objDy.getLong("assessnode.id") && StringUtils.isBlank((CharSequence)objDy.getString("nodestatus"));
                        } else {
                            String lastNodeStatus = AssessNodeStatusEnum.getLastNodeStatus((Long)preNodeId).getStatus();
                            a = objDy.getInt("nodeindex") >= 1 && preNodeId == objDy.getLong("assessnode.id") && lastNodeStatus.equals(objDy.getString("nodestatus"));
                        }
                        List<String> statusList = Arrays.asList(AssessNodeStatusEnum.TO_BE_MP.getStatus(), AssessNodeStatusEnum.MPING.getStatus());
                        boolean bl = b = NodeTabMapEnum.PERF_SUM.getNodeId().longValue() == objDy.getLong("assessnode.id") && statusList.contains(objDy.getString("nodestatus"));
                        if (!a && !b) {
                            this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u5df2\u4e0d\u5728\u7ed3\u679c\u6c47\u603b-\u5f85\u6c47\u603b\u72b6\u6001\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"ResetSumRulelOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{dataEntity2.getDataEntity().getString("person.name"), dataEntity2.getDataEntity().getString("person.number")}));
                            continue;
                        }
                        if (resultMap.isEmpty() || !StringUtils.isNotBlank((CharSequence)(message = resultMap.get((Long)dataEntity2.getBillPkId())))) continue;
                        this.addErrorMessage(dataEntity2, message);
                    }
                } else {
                    this.addMessage(dataEntities[0], ResManager.loadKDString((String)"\u8d85\u8fc7100\u6761\u6570\u636e\uff0c\u540e\u53f0\u5f02\u6b65\u5904\u7406\u4efb\u52a1\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u7ed3\u679c\u3002", (String)"ResetSumRulelOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
        });
    }
}

