/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.perfworkflow;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.dynpermission.DynPermissionConfigService;
import kd.opmc.epa.business.application.service.dynpermission.presetpermission.MapKeyUtils;
import kd.opmc.epa.business.application.service.dynpermission.presetpermission.PresetPermissionUtils;
import kd.opmc.epa.business.domain.activity.service.AssessActivityDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.permission.utils.PermissionAreaMap;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.vo.dynpermission.ContentAreaEntry;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.epa.opplugin.web.perfworkflow.PerfWorkFlowBaseOp;

public class ActivityPerfWorkFlowAuditOp
extends PerfWorkFlowBaseOp {
    private static final Log LOG = LogFactory.getLog(ActivityPerfWorkFlowAuditOp.class);
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final AssessActivityDomainService ASSESS_ACTIVITY_DOMAIN_SERVICE = AssessActivityDomainService.getInstance();
    public static final String DYNAMIC_PERMISSION_CACHE_KEY = "dynamic_permission_cache_key";
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        OperateOption operateOption = this.operateOption;
        operateOption.setVariableValue("operateType", "audit");
    }

    @Override
    public void confirmChangeNewVersion(DynamicObject flow, long activityId) {
        String entityName = flow.getDataEntityType().getName();
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)flow.get("flowentry");
        DynamicObjectCollection defaultFlows = dynamicObjects.stream().filter(flowEntry -> flowEntry.getBoolean("isdefaultflow") && !flowEntry.getBoolean("isdelete")).collect(Collectors.toCollection(DynamicObjectCollection::new));
        DynamicObjectCollection flowEntrys = dynamicObjects.stream().filter(flowEntry -> flowEntry.getBoolean("isdelete")).collect(Collectors.toCollection(DynamicObjectCollection::new));
        List<Long> deleteFlowIds = flowEntrys.stream().map(data -> data.getLong("flowid")).collect(Collectors.toList());
        if (!dynamicObjects.isEmpty()) {
            DynamicObjectCollection isModityFlowEntrys = dynamicObjects.stream().filter(flowEntry -> flowEntry.getBoolean("ischange")).collect(Collectors.toCollection(DynamicObjectCollection::new));
            DynamicObject[] publishFlows = Arrays.stream(this.getPublishFlows(isModityFlowEntrys)).collect(Collectors.toList()).toArray(new DynamicObject[0]);
            if (publishFlows.length > 0) {
                HisResponse response = WORK_FLOW_APPLICATION_SERVICE.hisVersionChange(publishFlows, "pbs_workflow", true);
                if (!EnumResponseCode.SUCCESS.getCode().equals(response.getCode())) {
                    String msg = ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u751f\u6210\u65b0\u5386\u53f2\u7248\u672c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002", (String)"ActivityPerfWorkFlowAuditOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
                    throw new RuntimeException(msg);
                }
                this.saveTempVersion(publishFlows);
                if ("epa_activity_perfworkflow".equals(entityName)) {
                    List<Long> boids = Arrays.stream(publishFlows).map(v -> v.getLong("boid")).collect(Collectors.toList());
                    boolean isAddFormulateNode = this.isAddFormulateNode(activityId);
                    if (isAddFormulateNode) {
                        this.rePreCreateProInstAndEvalObj4Formulate(deleteFlowIds, (HisResponse<VersionChangeRespData>)response, activityId);
                    } else {
                        this.rePreCreateProcessInstanceAndEvaObjFlowID(boids, deleteFlowIds, (HisResponse<VersionChangeRespData>)response);
                    }
                    this.rePreCreateProcessInstanceAndEvaObjByDefaultFlowID(deleteFlowIds, defaultFlows, (HisResponse<VersionChangeRespData>)response);
                }
            } else {
                this.rePreCreateProcessInstanceAndEvaObjByDefaultFlowID(deleteFlowIds, defaultFlows);
            }
        }
    }

    @Override
    protected void updateFlowEntry(DynamicObjectCollection updateFlows, DynamicObject flow, DynamicObject[] workflowDyns, DynamicObject viewFlow) {
        DynamicObjectCollection flowEntry = flow.getDynamicObjectCollection("flowentry");
        DynamicObjectCollection viewFlowEntry = viewFlow.getDynamicObjectCollection("flowentry");
        HashMap<Long, Boolean> isChangeMap = new HashMap<Long, Boolean>(viewFlowEntry.size());
        for (DynamicObject viewEntry : viewFlowEntry) {
            isChangeMap.put(viewEntry.getLong("flowid"), viewEntry.getBoolean("ischange"));
        }
        for (DynamicObject entry : flowEntry) {
            for (DynamicObject workflow : workflowDyns) {
                if (entry.getLong("flowid") != workflow.getLong("boid") || !isChangeMap.containsKey(entry.getLong("flowid")) || !((Boolean)isChangeMap.get(entry.getLong("flowid"))).booleanValue()) continue;
                long flowVid = workflow.getLong("sourcevid");
                if (flowVid == 0L) {
                    flowVid = entry.getLong("flowid");
                }
                entry.set("flowvid", (Object)flowVid);
            }
        }
        flow.set("flowentry", (Object)flowEntry);
        updateFlows.add((Object)flow);
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        for (DynamicObject flow : dataEntities = e.getDataEntities()) {
            long activityId = flow.getLong("activityid");
            if (activityId == 0L) continue;
            EVALUATION_OBJECT_DOMAIN_SERVICE.backCompletedEvalObjStatus(Long.valueOf(activityId));
            String assessFormId = this.operateOption.getVariableValue("assessFormId", "");
            if (HRStringUtils.isNotEmpty((String)assessFormId)) {
                EVALUATION_OBJECT_DOMAIN_SERVICE.preCreateProcessAndForm(Long.valueOf(activityId), assessFormId);
            }
            String haveChange = this.getOption().getVariableValue("haveChange");
            EVALUATION_OBJECT_DOMAIN_SERVICE.clearPerfSumData(activityId, Boolean.valueOf(haveChange));
            this.activityNodeHaveChange(activityId);
            ASSESS_ACTIVITY_DOMAIN_SERVICE.rebuildActivityTimeplanEntry(Long.valueOf(activityId));
            this.dynamicPermissionConfigSaveHandle(e, flow);
            this.flowEntryDeleteHandle(flow);
        }
    }

    private void activityNodeHaveChange(long activityId) {
        DynamicObject activityObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        DynamicObjectCollection perfWorkflowEntryEntity = activityObj.getDynamicObjectCollection("perfworkflow.entryentity");
        List perfWorkflowEntry = perfWorkflowEntryEntity.stream().filter(flow -> flow.getBoolean("isShow")).collect(Collectors.toList());
        DynamicObjectCollection timeplanentry = activityObj.getDynamicObjectCollection("timeplanentry");
        if (CollectionUtils.isNotEmpty(perfWorkflowEntry) && CollectionUtils.isNotEmpty((Collection)timeplanentry) && perfWorkflowEntry.size() != timeplanentry.size()) {
            this.operateOption.setVariableValue("activityNodeHaveChange", "true");
        }
    }

    private void dynamicPermissionConfigSaveHandle(EndOperationTransactionArgs e, DynamicObject flowObj) {
        DynamicPermissionConfigVO dynamicPermissionConfigVO;
        OperateOption operateOption = this.operateOption;
        String dynamicPermissionCacheKey = operateOption.getVariableValue(DYNAMIC_PERMISSION_CACHE_KEY);
        DistributeSessionlessCache commonRegionCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("commonRegion");
        String dynamicPermissionConfigVOJsonString = (String)commonRegionCache.get(dynamicPermissionCacheKey);
        if (HRStringUtils.isNotEmpty((String)dynamicPermissionCacheKey) && HRStringUtils.isNotEmpty((String)dynamicPermissionConfigVOJsonString)) {
            dynamicPermissionConfigVO = (DynamicPermissionConfigVO)JSON.parseObject((String)dynamicPermissionConfigVOJsonString, DynamicPermissionConfigVO.class);
            if (dynamicPermissionConfigVO == null) {
                LOG.error("dynamicPermissionConfigVO Serializable error," + dynamicPermissionConfigVOJsonString.length());
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u6216\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"ActivityPerfWorkFlowAuditOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
            }
        } else {
            LOG.error("dynamicPermissionConfigVO redisValue is  null");
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u6216\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"ActivityPerfWorkFlowAuditOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
        }
        DynPermissionConfigService dynPermissionConfigService = new DynPermissionConfigService();
        DynamicPermissionConfigVO dy = dynPermissionConfigService.getDynamicPermissions(dynamicPermissionConfigVO.getPermissionId(), null);
        dynamicPermissionConfigVO.setExcuteScheme(dy.getExcuteScheme());
        dynamicPermissionConfigVO.setPerfWorkflow(dy.getPerfWorkflow());
        dynamicPermissionConfigVO.setAssessForm(dy.getAssessForm());
        this.processSummaryInfo(dynamicPermissionConfigVO, flowObj, commonRegionCache, dynamicPermissionCacheKey);
        dynPermissionConfigService.updateDynamicPermission(dynamicPermissionConfigVO);
        dynamicPermissionConfigVO.setAssessForm(null);
        dynamicPermissionConfigVO.setExcuteScheme(null);
        dynamicPermissionConfigVO.setPerfWorkflow(null);
        commonRegionCache.put(dynamicPermissionCacheKey, (Object)JSON.toJSONString((Object)dynamicPermissionConfigVO), 1, TimeUnit.DAYS);
    }

    private void flowEntryDeleteHandle(DynamicObject flow) {
        DynamicObjectCollection flowEntrys;
        if (flow != null && CollectionUtils.isNotEmpty((Collection)(flowEntrys = flow.getDynamicObjectCollection("flowentry"))) && CollectionUtils.isNotEmpty((Collection)(flowEntrys = flowEntrys.stream().filter(flowEntry -> flowEntry.getBoolean("isdelete")).collect(Collectors.toCollection(DynamicObjectCollection::new))))) {
            ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(10);
            for (DynamicObject flowEntry2 : flowEntrys) {
                SqlParameter[] params = new SqlParameter[]{new SqlParameter("fflowid", -5, (Object)flowEntry2.getLong("flowid"))};
                paramsList.add(params);
            }
            String DELETEENTRY_SQL = "delete from  t_epa_perfworklowentry  where fflowid = ?";
            DB.executeBatch((DBRoute)new DBRoute("opmc"), (String)DELETEENTRY_SQL, paramsList);
        }
    }

    public void processSummaryInfo(DynamicPermissionConfigVO dynamicPermissionConfigVO, DynamicObject flowObj, DistributeSessionlessCache commonRegionCache, String dynamicPermissionCacheKey) {
        DynamicObjectCollection nodeDyns = flowObj.getDynamicObjectCollection("entryentity");
        HashMap<Long, Boolean> nodeSelectedFlag = new HashMap<Long, Boolean>(nodeDyns.size());
        for (DynamicObject nodeDyn : nodeDyns) {
            Long assessNodeId = nodeDyn.getDynamicObject("node").getLong("id");
            boolean isShow = nodeDyn.getBoolean("isshow");
            nodeSelectedFlag.put(assessNodeId, isShow);
        }
        boolean isExistNode = true;
        if (!nodeSelectedFlag.containsKey(1L) || !((Boolean)nodeSelectedFlag.get(1L)).booleanValue()) {
            isExistNode = false;
        }
        if (nodeSelectedFlag.containsKey(5L)) {
            if (((Boolean)nodeSelectedFlag.get(5L)).booleanValue()) {
                if (nodeSelectedFlag.containsKey(8L) && ((Boolean)nodeSelectedFlag.get(8L)).booleanValue()) {
                    this.processAreaEntries(dynamicPermissionConfigVO, isExistNode, 8L);
                }
                this.processAreaEntries(dynamicPermissionConfigVO, isExistNode, 1500000000000000000L);
            } else {
                if (nodeSelectedFlag.containsKey(8L) && ((Boolean)nodeSelectedFlag.get(8L)).booleanValue()) {
                    this.deleteSummaryArea(dynamicPermissionConfigVO, 8L);
                }
                this.deleteSummaryArea(dynamicPermissionConfigVO, 1500000000000000000L);
            }
        }
    }

    private void processAreaEntries(DynamicPermissionConfigVO dynamicPermissionConfigVO, boolean isExistNode, Long activityNodeId) {
        int i;
        boolean isExistSummary = false;
        List resultConfirmAreaEntries = (List)dynamicPermissionConfigVO.getContentAreaEntriesMap().get(activityNodeId);
        for (i = resultConfirmAreaEntries.size() - 1; i > -1; --i) {
            if (1960097310314606592L == ((ContentAreaEntry)resultConfirmAreaEntries.get(i)).getAreapageId()) {
                isExistSummary = true;
                continue;
            }
            if (isExistNode) continue;
            resultConfirmAreaEntries.remove(i);
        }
        if (!isExistSummary) {
            if (isExistNode) {
                for (i = resultConfirmAreaEntries.size() - 1; i > -1; --i) {
                    if (((ContentAreaEntry)resultConfirmAreaEntries.get(i)).getSeq() <= 1 || ((ContentAreaEntry)resultConfirmAreaEntries.get(i)).getSeq() >= 100) continue;
                    ((ContentAreaEntry)resultConfirmAreaEntries.get(i)).setSeq(Integer.valueOf(((ContentAreaEntry)resultConfirmAreaEntries.get(i)).getSeq() + 1));
                }
                this.addSummaryInfoArea(resultConfirmAreaEntries, 2, activityNodeId);
            } else {
                this.addSummaryInfoArea(resultConfirmAreaEntries, 1, activityNodeId);
            }
        }
        if (isExistNode && resultConfirmAreaEntries.size() == 1) {
            ((ContentAreaEntry)resultConfirmAreaEntries.get(0)).setSeq(Integer.valueOf(2));
            long assessFormId = dynamicPermissionConfigVO.getAssessForm().getLong("id");
            resultConfirmAreaEntries.addAll(PresetPermissionUtils.processResultAndCompleteContentAreaExcludeSummary((DynamicPermissionConfigVO)dynamicPermissionConfigVO, (Long)assessFormId, (Long)activityNodeId));
        }
    }

    private void addSummaryInfoArea(List<ContentAreaEntry> areaEntries, Integer seq, Long activityNodeId) {
        String areaName = ResManager.loadKDString((String)"\u6c47\u603b\u4fe1\u606f\u533a", (String)"ActivityPerfWorkFlowAuditOp_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        long areaRegId = 1960097310314606592L;
        String key = MapKeyUtils.getAreaCombineKey((Long)activityNodeId, (Long)0L, (Long)areaRegId, (Long)0L);
        ContentAreaEntry areaEntry = new ContentAreaEntry();
        areaEntry.setAreapageInsname(areaName);
        areaEntry.setAreapageInsId(Long.valueOf(areaRegId));
        areaEntry.setAreapageId(Long.valueOf(areaRegId));
        areaEntry.setSeq(seq);
        areaEntry.setAreaModify(PermissionAreaMap.getAreaUpdate((String)key));
        areaEntry.setAreaDisplay(PermissionAreaMap.getAreaDisplay((String)key));
        areaEntry.setAreaDisplaySetting(PermissionAreaMap.getAreaDisplayMapValue((String)key));
        areaEntry.setAreaUpdateSetting(PermissionAreaMap.getAreaUpdateMapValue((String)key));
        areaEntry.setFieldEntries(new ArrayList(10));
        areaEntries.add(areaEntry);
    }

    private void deleteSummaryArea(DynamicPermissionConfigVO dynamicPermissionConfigVO, Long activityNodeId) {
        List resultConfirmAreaEntries = (List)dynamicPermissionConfigVO.getContentAreaEntriesMap().get(activityNodeId);
        for (int i = resultConfirmAreaEntries.size() - 1; i > -1; --i) {
            if (1960097310314606592L != ((ContentAreaEntry)resultConfirmAreaEntries.get(i)).getAreapageId()) continue;
            for (int j = resultConfirmAreaEntries.size() - 1; j > -1; --j) {
                if (1960097310314606592L == ((ContentAreaEntry)resultConfirmAreaEntries.get(i)).getAreapageId() || ((ContentAreaEntry)resultConfirmAreaEntries.get(i)).getSeq() <= 1 || ((ContentAreaEntry)resultConfirmAreaEntries.get(i)).getSeq() >= 100) continue;
                ((ContentAreaEntry)resultConfirmAreaEntries.get(i)).setSeq(Integer.valueOf(((ContentAreaEntry)resultConfirmAreaEntries.get(i)).getSeq() - 1));
            }
            resultConfirmAreaEntries.remove(i);
            break;
        }
        if (dynamicPermissionConfigVO.getAssessForm() != null && resultConfirmAreaEntries.size() == 0) {
            long assessFormId = dynamicPermissionConfigVO.getAssessForm().getLong("id");
            resultConfirmAreaEntries.addAll(PresetPermissionUtils.processResultAndCompleteContentAreaExcludeSummary((DynamicPermissionConfigVO)dynamicPermissionConfigVO, (Long)assessFormId, (Long)activityNodeId));
        }
    }

    public boolean isAddFormulateNode(long activityId) {
        DynamicObject activityObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        DynamicObjectCollection perfWorkflowEntryEntity = activityObj.getDynamicObjectCollection("perfworkflow.entryentity");
        DynamicObjectCollection timeplanentry = activityObj.getDynamicObjectCollection("timeplanentry");
        if (CollectionUtils.isNotEmpty((Collection)perfWorkflowEntryEntity) && CollectionUtils.isNotEmpty((Collection)timeplanentry)) {
            DynamicObject tobeFormulate = perfWorkflowEntryEntity.stream().filter(obj -> obj.getDynamicObject("node").getLong("id") == AssessNodeStatusEnum.TO_BE_FORMULATED.getNodeId().longValue()).findAny().orElse(null);
            DynamicObject tobeFormulateOfObj = timeplanentry.stream().filter(obj -> obj.getDynamicObject("activity").getLong("id") == AssessNodeStatusEnum.TO_BE_FORMULATED.getNodeId().longValue()).findAny().orElse(null);
            if (!ObjectUtils.isEmpty((Object)tobeFormulate) && ObjectUtils.isEmpty((Object)tobeFormulateOfObj)) {
                return true;
            }
        }
        return false;
    }
}

