/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.perfworkflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.perfworkflow.entutyservice.PerfWorkFlowEntityService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.pbs.business.application.service.workflow.WorkFlowApplicationService;

public class PerfWorkFlowBaseOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(PerfWorkFlowBaseOp.class);
    protected static final WorkFlowApplicationService WORK_FLOW_APPLICATION_SERVICE = WorkFlowApplicationService.getInstance();
    protected static final PerfWorkFlowEntityService PERF_WORK_FLOW_ENTITY_SERVICE = PerfWorkFlowEntityService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("flowentry.flowid");
        args.getFieldKeys().add("flowentry.flowvid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operateType;
        super.beginOperationTransaction(e);
        OperateOption operateOption = this.operateOption;
        if (operateOption.containsVariable("operateType") && (HRStringUtils.equals((String)"confirmchange", (String)(operateType = operateOption.getVariableValue("operateType"))) || HRStringUtils.equals((String)"audit", (String)operateType))) {
            DynamicObject[] dataEntities;
            for (DynamicObject flow : dataEntities = e.getDataEntities()) {
                long activityId = flow.getLong("activityid");
                this.confirmChangeNewVersion(flow, activityId);
            }
        }
    }

    public void confirmChangeNewVersion(DynamicObject flow) {
        String entityName = flow.getDataEntityType().getName();
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)flow.get("flowentry");
        if (!dynamicObjects.isEmpty()) {
            DynamicObject[] publishFlows = this.getPublishFlows(dynamicObjects);
            List boids = Arrays.stream(publishFlows).map(v -> v.getLong("boid")).collect(Collectors.toList());
            if (publishFlows.length > 0) {
                HisResponse response = WORK_FLOW_APPLICATION_SERVICE.hisVersionChange(publishFlows, "pbs_workflow", true);
                if (EnumResponseCode.SUCCESS.getCode().equals(response.getCode())) {
                    this.saveTempVersion(publishFlows);
                } else {
                    String msg = ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u751f\u6210\u65b0\u5386\u53f2\u7248\u672c\u5931\u8d25\u3002", (String)"PerfWorkFlowBaseOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
                    throw new RuntimeException(msg);
                }
            }
        }
    }

    protected void rePreCreateProcessInstanceAndEvaObjFlowID(List<Long> boids, List<Long> deleteFlowIds, HisResponse<VersionChangeRespData> response) {
        DynamicObject[] newDynamicObjects;
        LOG.error("begin rePreCreateProcessInstanceAndEvaObjFlowID preCreateProcessInstanceNoTx,traceId is [{}]", (Object)RequestContext.get().getTraceId());
        HashMap<Long, Long> versionBoidMap = new HashMap<Long, Long>(16);
        for (DynamicObject dyn : newDynamicObjects = ((VersionChangeRespData)response.getData()).getNewDynamicObjects()) {
            if (dyn.getLong("boid") == dyn.getLong("id") || deleteFlowIds.contains(dyn.getLong("boid"))) continue;
            LOG.error("begin rePreCreateProcessInstanceAndEvaObjFlowID preCreateProcessInstanceNoTx,key is [{}]  value is [{}]", (Object)dyn.getLong("boid"), (Object)dyn.getLong("id"));
            versionBoidMap.put(dyn.getLong("boid"), dyn.getLong("id"));
        }
        QFilter qFilter = new QFilter("evalflow.boid", "in", boids).or(new QFilter("formulateflow.boid", "in", boids));
        QFilter assessstausFilter = new QFilter("assessstaus", "in", (Object)new String[]{"20", "10"});
        QFilter assessnodeFilter = new QFilter("assessnode", "in", (Object)new Long[]{0L, 1L});
        qFilter.and(assessstausFilter).and(assessnodeFilter);
        DynamicObject[] evaluationObjects = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectByFilter(qFilter);
        List formalateDyns = Arrays.stream(evaluationObjects).filter(data -> "5".equals(data.getString("nodestatus")) || "10".equals(data.getString("assessstaus"))).collect(Collectors.toList());
        List evalDyns = Arrays.stream(evaluationObjects).filter(data -> data.getLong("assessnode.id") == 1L && "30".equals(data.getString("nodestatus"))).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> formalateDynsByVid = formalateDyns.stream().collect(Collectors.groupingBy(obj -> obj.getLong("formulateflow.boid")));
        Map<Long, List<DynamicObject>> evalDynsByVid = evalDyns.stream().collect(Collectors.groupingBy(obj -> obj.getLong("evalflow.boid")));
        ArrayList successObj = new ArrayList(16);
        if (formalateDynsByVid.size() > 0) {
            formalateDynsByVid.forEach((key, value) -> {
                Long flowvid = (Long)versionBoidMap.get(key);
                if (flowvid != null && flowvid != 0L) {
                    Map objRefProInstMap = EvalObjUtils.preCreateProcessInstanceNoTx((DynamicObject[])value.toArray(new DynamicObject[0]), (Long)flowvid, (String)"1", new HashMap());
                    for (DynamicObject evaluationObj : value) {
                        Object formulateFlowId = objRefProInstMap.get(evaluationObj.getLong("id"));
                        LOG.info("\u3010OPMC\u3011-rePreCreateProcessInstanceAndEvaObjFlowID formulateFlowId ,deal [{}] data, evaobjid [{}],flowvid is [{}] ", new Object[]{formulateFlowId, evaluationObj.getLong("id"), flowvid});
                        if (!ObjectUtils.isEmpty(formulateFlowId)) {
                            evaluationObj.set("formulateflow", (Object)flowvid);
                            evaluationObj.set("formulateflowins", formulateFlowId);
                        }
                        successObj.add(evaluationObj);
                    }
                }
            });
        }
        if (evalDynsByVid.size() > 0) {
            evalDynsByVid.forEach((key, value) -> {
                Long flowvid = (Long)versionBoidMap.get(key);
                if (flowvid != null && flowvid != 0L) {
                    Map objRefProInstMap = EvalObjUtils.preCreateProcessInstanceNoTx((DynamicObject[])value.toArray(new DynamicObject[0]), (Long)flowvid, (String)"2", new HashMap());
                    for (DynamicObject evaluationObj : value) {
                        Object formulateFlowId = objRefProInstMap.get(evaluationObj.getLong("id"));
                        LOG.info("\u3010OPMC\u3011-rePreCreateProcessInstanceAndEvaObjFlowID evalflow ,deal [{}] data, evaobjid [{}],flowvid is [{}] ", new Object[]{formulateFlowId, evaluationObj.getLong("id"), flowvid});
                        if (!ObjectUtils.isEmpty(formulateFlowId)) {
                            evaluationObj.set("evalflow", (Object)flowvid);
                            evaluationObj.set("evalflowins", formulateFlowId);
                        }
                        successObj.add(evaluationObj);
                    }
                }
            });
        }
        if (successObj.size() > 0) {
            ACTIVITY_EVALUATION_OBJECT_ENTITY.save(successObj.toArray(new DynamicObject[0]));
        }
        LOG.info("\u3010OPMC\u3011- end rePreCreateProcessInstanceAndEvaObjFlowID preCreateProcessInstanceNoTx");
    }

    protected void rePreCreateProcessInstanceAndEvaObjByDefaultFlowID(List<Long> boids, DynamicObjectCollection defaultFlows, HisResponse<VersionChangeRespData> response) {
        DynamicObject[] newDynamicObjects;
        LOG.error("begin rePreCreateProcessInstanceAndEvaObjByDefaultFlowID preCreateProcessInstanceNoTx,traceId is [{}]", (Object)RequestContext.get().getTraceId());
        Map<Long, Long> defaultBoidMap = defaultFlows.stream().collect(Collectors.toMap(k -> k.getLong("flowid"), v -> v.getLong("passnode"), (key1, key2) -> key1));
        Map<Long, Long> versionBoidMap = defaultFlows.stream().collect(Collectors.toMap(k -> k.getLong("passnode"), v -> v.getLong("flowid"), (key1, key2) -> key1));
        for (DynamicObject dyn : newDynamicObjects = ((VersionChangeRespData)response.getData()).getNewDynamicObjects()) {
            if (dyn.getLong("boid") == dyn.getLong("id") || boids.contains(dyn.getLong("boid")) || defaultBoidMap.get(dyn.getLong("boid")) == null || defaultBoidMap.get(dyn.getLong("boid")) == 0L) continue;
            LOG.error("begin rePreCreateProcessInstanceAndEvaObjByDefaultFlowID preCreateProcessInstanceNoTx,key is [{}]  value is [{}]", (Object)defaultBoidMap.get(dyn.getLong("boid")), (Object)dyn.getLong("id"));
            versionBoidMap.put(defaultBoidMap.get(dyn.getLong("boid")), dyn.getLong("id"));
        }
        QFilter qFilter = new QFilter("evalflow.boid", "in", boids).or(new QFilter("formulateflow.boid", "in", boids));
        QFilter assessstausFilter = new QFilter("assessstaus", "in", (Object)new String[]{"20", "10"});
        QFilter assessnodeFilter = new QFilter("assessnode", "in", (Object)new Long[]{0L, 1L});
        qFilter.and(assessstausFilter).and(assessnodeFilter);
        DynamicObject[] evaluationObjects = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectByFilter(qFilter);
        List formalateDyns = Arrays.stream(evaluationObjects).filter(data -> "5".equals(data.getString("nodestatus")) || "10".equals(data.getString("nodestatus")) || "10".equals(data.getString("assessstaus"))).collect(Collectors.toList());
        List evalDyns = Arrays.stream(evaluationObjects).filter(data -> data.getLong("assessnode.id") == 1L && "30".equals(data.getString("nodestatus"))).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> formalateDynsByVid = formalateDyns.stream().collect(Collectors.groupingBy(obj -> obj.getLong("formulateflow.boid")));
        Map<Long, List<DynamicObject>> evalDynsByVid = evalDyns.stream().collect(Collectors.groupingBy(obj -> obj.getLong("evalflow.boid")));
        ArrayList successObj = new ArrayList(16);
        if (formalateDynsByVid.size() > 0) {
            formalateDynsByVid.forEach((key, value) -> {
                Long flowvid = (Long)versionBoidMap.get(1L);
                if (flowvid != null && flowvid != 0L) {
                    Map objRefProInstMap = EvalObjUtils.preCreateProcessInstanceNoTx((DynamicObject[])value.toArray(new DynamicObject[0]), (Long)flowvid, (String)"1", new HashMap());
                    for (DynamicObject evaluationObj : value) {
                        Object formulateFlowId = objRefProInstMap.get(evaluationObj.getLong("id"));
                        LOG.info("\u3010OPMC\u3011-rePreCreateProcessInstanceAndEvaObjByDefaultFlowID formulateFlowId ,deal [{}] data, evaobjid [{}],flowvid is [{}] ", new Object[]{formulateFlowId, evaluationObj.getLong("id"), flowvid});
                        if (!ObjectUtils.isEmpty(formulateFlowId)) {
                            evaluationObj.set("formulateflow", (Object)flowvid);
                            evaluationObj.set("formulateflowins", formulateFlowId);
                        }
                        successObj.add(evaluationObj);
                    }
                }
            });
        }
        if (evalDynsByVid.size() > 0) {
            evalDynsByVid.forEach((key, value) -> {
                Long flowvid = (Long)versionBoidMap.get(4L);
                if (flowvid != null && flowvid != 0L) {
                    Map objRefProInstMap = EvalObjUtils.preCreateProcessInstanceNoTx((DynamicObject[])value.toArray(new DynamicObject[0]), (Long)flowvid, (String)"2", new HashMap());
                    for (DynamicObject evaluationObj : value) {
                        Object formulateFlowId = objRefProInstMap.get(evaluationObj.getLong("id"));
                        LOG.info("\u3010OPMC\u3011-rePreCreateProcessInstanceAndEvaObjByDefaultFlowID evalflow ,deal [{}] data, evaobjid [{}],flowvid is [{}] ", new Object[]{formulateFlowId, evaluationObj.getLong("id"), flowvid});
                        if (!ObjectUtils.isEmpty(formulateFlowId)) {
                            evaluationObj.set("evalflow", (Object)flowvid);
                            evaluationObj.set("evalflowins", formulateFlowId);
                        }
                        successObj.add(evaluationObj);
                    }
                }
            });
        }
        if (successObj.size() > 0) {
            ACTIVITY_EVALUATION_OBJECT_ENTITY.save(successObj.toArray(new DynamicObject[0]));
        }
        LOG.info("\u3010OPMC\u3011- end rePreCreateProcessInstanceAndEvaObjByDefaultFlowID preCreateProcessInstanceNoTx");
    }

    protected void rePreCreateProcessInstanceAndEvaObjByDefaultFlowID(List<Long> boids, DynamicObjectCollection defaultFlows) {
        LOG.error("begin PreCreateProcessInstanceAndEvaObjByDefaultFlowID preCreateProcessInstanceNoTx,traceId is [{}]", (Object)RequestContext.get().getTraceId());
        Map<Long, Long> versionBoidMap = defaultFlows.stream().collect(Collectors.toMap(k -> k.getLong("passnode"), v -> v.getLong("flowid"), (key1, key2) -> key1));
        QFilter qFilter = new QFilter("evalflow.boid", "in", boids).or(new QFilter("formulateflow.boid", "in", boids));
        QFilter assessstausFilter = new QFilter("assessstaus", "in", (Object)new String[]{"20", "10"});
        QFilter assessnodeFilter = new QFilter("assessnode", "in", (Object)new Long[]{0L, 1L});
        qFilter.and(assessstausFilter).and(assessnodeFilter);
        DynamicObject[] evaluationObjects = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectByFilter(qFilter);
        List formalateDyns = Arrays.stream(evaluationObjects).filter(data -> "5".equals(data.getString("nodestatus")) || "10".equals(data.getString("nodestatus")) || "10".equals(data.getString("assessstaus"))).collect(Collectors.toList());
        List evalDyns = Arrays.stream(evaluationObjects).filter(data -> data.getLong("assessnode.id") == 1L && "30".equals(data.getString("nodestatus"))).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> formalateDynsByVid = formalateDyns.stream().collect(Collectors.groupingBy(obj -> obj.getLong("formulateflow.boid")));
        Map<Long, List<DynamicObject>> evalDynsByVid = evalDyns.stream().collect(Collectors.groupingBy(obj -> obj.getLong("evalflow.boid")));
        ArrayList successObj = new ArrayList(16);
        if (formalateDynsByVid.size() > 0) {
            formalateDynsByVid.forEach((key, value) -> {
                Long flowvid = (Long)versionBoidMap.get(1L);
                if (flowvid != null && flowvid != 0L) {
                    Map objRefProInstMap = EvalObjUtils.preCreateProcessInstanceNoTx((DynamicObject[])value.toArray(new DynamicObject[0]), (Long)flowvid, (String)"1", new HashMap());
                    for (DynamicObject evaluationObj : value) {
                        Object formulateFlowId = objRefProInstMap.get(evaluationObj.getLong("id"));
                        LOG.info("\u3010OPMC\u3011-PreCreateProcessInstanceAndEvaObjByDefaultFlowID evalflow ,deal [{}] data, evaobjid [{}],flowvid is [{}] ", new Object[]{formulateFlowId, evaluationObj.getLong("id"), flowvid});
                        if (!ObjectUtils.isEmpty(formulateFlowId)) {
                            evaluationObj.set("formulateflow", (Object)flowvid);
                            evaluationObj.set("formulateflowins", formulateFlowId);
                        }
                        successObj.add(evaluationObj);
                    }
                }
            });
        }
        if (evalDynsByVid.size() > 0) {
            evalDynsByVid.forEach((key, value) -> {
                Long flowvid = (Long)versionBoidMap.get(4L);
                if (flowvid != null && flowvid != 0L) {
                    Map objRefProInstMap = EvalObjUtils.preCreateProcessInstanceNoTx((DynamicObject[])value.toArray(new DynamicObject[0]), (Long)flowvid, (String)"2", new HashMap());
                    for (DynamicObject evaluationObj : value) {
                        Object formulateFlowId = objRefProInstMap.get(evaluationObj.getLong("id"));
                        LOG.info("\u3010OPMC\u3011-PreCreateProcessInstanceAndEvaObjByDefaultFlowID evalflow ,deal [{}] data, evaobjid [{}],flowvid is [{}] ", new Object[]{formulateFlowId, evaluationObj.getLong("id"), flowvid});
                        if (!ObjectUtils.isEmpty(formulateFlowId)) {
                            evaluationObj.set("evalflow", (Object)flowvid);
                            evaluationObj.set("evalflowins", formulateFlowId);
                        }
                        successObj.add(evaluationObj);
                    }
                }
            });
        }
        if (successObj.size() > 0) {
            ACTIVITY_EVALUATION_OBJECT_ENTITY.save(successObj.toArray(new DynamicObject[0]));
        }
        LOG.info("\u3010OPMC\u3011- end PreCreateProcessInstanceAndEvaObjByDefaultFlowID preCreateProcessInstanceNoTx");
    }

    protected DynamicObject[] getPublishFlows(DynamicObjectCollection dynamicObjects) {
        DynamicObject[] flows;
        List flowIds = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("flowid")).collect(Collectors.toList());
        for (DynamicObject dynamicObject2 : flows = WORK_FLOW_APPLICATION_SERVICE.getPublishFlows(flowIds)) {
            dynamicObject2.set("modifytime", (Object)new Date());
            dynamicObject2.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
            dynamicObject2.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        }
        return flows;
    }

    public void saveTempVersion(DynamicObject[] publishFlows) {
        List tempFlowIds;
        if (publishFlows.length > 0 && !(tempFlowIds = Arrays.stream(publishFlows).filter(dyn -> HRStringUtils.equals((String)"10", (String)dyn.getString("publishstatus"))).map(dym -> dym.getLong("boid")).collect(Collectors.toList())).isEmpty()) {
            DynamicObject[] workflows = WORK_FLOW_APPLICATION_SERVICE.getAllWorkflows(tempFlowIds);
            DynamicObjectCollection flowCollection = new DynamicObjectCollection();
            for (DynamicObject flow : workflows) {
                if (HRStringUtils.isEmpty((String)flow.getString("hisversion"))) {
                    flow.set("status", (Object)"A");
                    flow.set("datastatus", (Object)"-3");
                    flowCollection.add((Object)flow);
                    continue;
                }
                flow.set("datastatus", (Object)"-2");
                flowCollection.add((Object)flow);
            }
            WORK_FLOW_APPLICATION_SERVICE.save(flowCollection);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        OperateOption operateOption = this.operateOption;
        String operateType = operateOption.getVariableValue("operateType");
        if (HRStringUtils.equals((String)"confirmchange", (String)operateType) || HRStringUtils.equals((String)"audit", (String)operateType)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            DynamicObjectCollection updateFlows = new DynamicObjectCollection();
            for (DynamicObject flow : dataEntities) {
                String number = flow.getString("number");
                long orgId = flow.getDynamicObject("adminorg").getLong("id");
                DynamicObject[] currentPerfFlow = PERF_WORK_FLOW_ENTITY_SERVICE.getCurrentPerfFlow(number, orgId);
                DynamicObject[] workflows = this.getWorkflows(flow);
                for (DynamicObject perfFlow : currentPerfFlow) {
                    this.updateFlowEntry(updateFlows, perfFlow, workflows, flow);
                }
            }
            if (!updateFlows.isEmpty()) {
                PERF_WORK_FLOW_ENTITY_SERVICE.save(updateFlows);
            }
        }
    }

    protected void updateFlowEntry(DynamicObjectCollection updateFlows, DynamicObject flow, DynamicObject[] workflowDyns, DynamicObject viewFlow) {
        DynamicObjectCollection flowEntry = flow.getDynamicObjectCollection("flowentry");
        for (DynamicObject entry : flowEntry) {
            for (DynamicObject workflow : workflowDyns) {
                if (entry.getLong("flowid") != workflow.getLong("boid")) continue;
                entry.set("flowvid", (Object)workflow.getLong("sourcevid"));
            }
        }
        flow.set("flowentry", (Object)flowEntry);
        updateFlows.add((Object)flow);
    }

    protected DynamicObject[] getWorkflows(DynamicObject flow) {
        DynamicObjectCollection flowEntry = flow.getDynamicObjectCollection("flowentry");
        List flowIds = flowEntry.stream().map(dynamicObject -> dynamicObject.getLong("flowid")).collect(Collectors.toList());
        return WORK_FLOW_APPLICATION_SERVICE.getWorkflows(flowIds);
    }

    public void confirmChangeNewVersion(DynamicObject flow, long activityId) {
        String entityName = flow.getDataEntityType().getName();
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)flow.get("flowentry");
        if (!dynamicObjects.isEmpty()) {
            DynamicObject[] publishFlows = this.getPublishFlows(dynamicObjects);
            List boids = Arrays.stream(publishFlows).map(v -> v.getLong("boid")).collect(Collectors.toList());
            if (publishFlows.length > 0) {
                HisResponse response = WORK_FLOW_APPLICATION_SERVICE.hisVersionChange(publishFlows, "pbs_workflow", true);
                if (EnumResponseCode.SUCCESS.getCode().equals(response.getCode())) {
                    this.saveTempVersion(publishFlows);
                } else {
                    String msg = ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u751f\u6210\u65b0\u5386\u53f2\u7248\u672c\u5931\u8d25\u3002", (String)"PerfWorkFlowBaseOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
                    throw new RuntimeException(msg);
                }
            }
        }
    }

    protected void rePreCreateProInstAndEvalObj4Formulate(List<Long> deleteFlowIds, HisResponse<VersionChangeRespData> response, long activityId) {
        DynamicObject[] newDynamicObjects;
        LOG.error("begin rePreCreateProInstAndEvalObj4Formulate preCreateProcessInstanceNoTx,traceId is [{}]", (Object)RequestContext.get().getTraceId());
        HashMap<Long, Long> versionBoidMap = new HashMap<Long, Long>(16);
        for (DynamicObject dyn : newDynamicObjects = ((VersionChangeRespData)response.getData()).getNewDynamicObjects()) {
            if (dyn.getLong("boid") == dyn.getLong("id") || deleteFlowIds.contains(dyn.getLong("boid"))) continue;
            LOG.error("begin rePreCreateProcessInstanceAndEvaObjFlowID preCreateProcessInstanceNoTx,key is [{}]  value is [{}]", (Object)dyn.getLong("boid"), (Object)dyn.getLong("id"));
            versionBoidMap.put(dyn.getLong("boid"), dyn.getLong("id"));
        }
        QFilter qFilter = new QFilter("activity", "=", (Object)activityId);
        QFilter assessstausFilter = new QFilter("assessstaus", "in", (Object)new String[]{"20", "10"});
        QFilter assessnodeFilter = new QFilter("assessnode", "in", (Object)new Long[]{0L, 1L});
        qFilter.and(assessstausFilter).and(assessnodeFilter);
        DynamicObject[] evaluationObjects = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectByFilter(qFilter);
        List formalateDyns = Arrays.stream(evaluationObjects).filter(data -> "5".equals(data.getString("nodestatus")) || "10".equals(data.getString("nodestatus")) || "10".equals(data.getString("assessstaus"))).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> formalateDynsByVid = formalateDyns.stream().collect(Collectors.groupingBy(obj -> obj.getLong("formulateflow.boid")));
        ArrayList successObj = new ArrayList(16);
        if (formalateDynsByVid.size() > 0) {
            formalateDynsByVid.forEach((key, value) -> {
                Long flowvid = (Long)versionBoidMap.get(1L);
                if (flowvid != null && flowvid != 0L) {
                    Map objRefProInstMap = EvalObjUtils.preCreateProcessInstanceNoTx((DynamicObject[])value.toArray(new DynamicObject[0]), (Long)flowvid, (String)"1", new HashMap());
                    for (DynamicObject evaluationObj : value) {
                        Object formulateFlowId = objRefProInstMap.get(evaluationObj.getLong("id"));
                        LOG.info("\u3010OPMC\u3011-PreCreateProcessInstanceAndEvaObjByDefaultFlowID evalflow ,deal [{}] data, evaobjid [{}],flowvid is [{}] ", new Object[]{formulateFlowId, evaluationObj.getLong("id"), flowvid});
                        if (!ObjectUtils.isEmpty(formulateFlowId)) {
                            evaluationObj.set("formulateflow", (Object)flowvid);
                            evaluationObj.set("formulateflowins", formulateFlowId);
                        }
                        successObj.add(evaluationObj);
                    }
                }
            });
        }
        if (successObj.size() > 0) {
            ACTIVITY_EVALUATION_OBJECT_ENTITY.save(successObj.toArray(new DynamicObject[0]));
        }
        LOG.info("\u3010OPMC\u3011- end rePreCreateProInstAndEvalObj4Formulate preCreateProcessInstanceNoTx");
    }
}

