/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.perfworkflow;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.pbs.business.application.service.workflow.WorkFlowApplicationService;

public class PerfWorkFlowHisDeleteOp
extends HRDataBaseOp {
    private static final WorkFlowApplicationService WORK_FLOW_APPLICATION_SERVICE = WorkFlowApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("flowentry.flowid");
        args.getFieldKeys().add("flowentry.flowvid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject flow : dataEntities = e.getDataEntities()) {
            this.rollbackFlows(flow);
        }
    }

    private void rollbackFlows(DynamicObject flow) {
        DynamicObject[] copyTempWorkflow;
        DynamicObjectCollection dynamicObjects = flow.getDynamicObjectCollection("flowentry");
        List flowIds = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("flowid")).collect(Collectors.toList());
        if (!flowIds.isEmpty() && (copyTempWorkflow = WORK_FLOW_APPLICATION_SERVICE.getCurrentTempWorkflows(flowIds)).length > 0) {
            List hisVersionFlows = Arrays.stream(copyTempWorkflow).map(dynamicObject -> dynamicObject.getLong("sourcevid")).collect(Collectors.toList());
            DynamicObject[] allWorkFlows = WORK_FLOW_APPLICATION_SERVICE.getWorkflowsByVids(hisVersionFlows);
            DynamicObjectCollection collection = new DynamicObjectCollection();
            block0: for (DynamicObject backupFlow : allWorkFlows) {
                long backupBoId = backupFlow.getLong("boid");
                for (DynamicObject changeFlow : copyTempWorkflow) {
                    long changeBoId = changeFlow.getLong("boid");
                    if (backupBoId != changeBoId) continue;
                    Set ignoreFieldsAll = Stream.of("id", "masterid", "sourcevid", "boid", "iscurrentversion", "hisversion").collect(Collectors.toSet());
                    HRDynamicObjectUtils.copy((DynamicObject)backupFlow, (DynamicObject)changeFlow, ignoreFieldsAll, (boolean)true);
                    String publishStatus = backupFlow.getString("publishstatus");
                    if (HRStringUtils.equals((String)publishStatus, (String)"10")) {
                        changeFlow.set("status", (Object)"A");
                        changeFlow.set("datastatus", (Object)"-3");
                    }
                    collection.add((Object)changeFlow);
                    continue block0;
                }
            }
            WORK_FLOW_APPLICATION_SERVICE.save(collection);
        }
    }
}

