/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;

public class SchemeBaseInfoDeleteOp
extends HRDataBaseOp {
    private static final AssessSchemeApplicationService APP_SERVICE = AssessSchemeApplicationService.getInstance();

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                Object[] objects = Arrays.stream(dataEntities).map(dataEntity -> (Long)dataEntity.getBillPkId()).toArray();
                BasedataEntityType entityType = (BasedataEntityType)dataEntities[0].getDataEntity().getDataEntityType();
                Set ignoreRefEntityIds = Arrays.stream(new String[]{"epa_objectscope", "epa_assessgroup", "epa_activity", "epa_assignmanager", "epa_assessobject"}).collect(Collectors.toSet());
                Set checkRefEntityIds = Arrays.stream(new String[]{"epa_executescheme"}).collect(Collectors.toSet());
                Map refResultMap = BaseDataRefrenceHelper.checkRefrenced((BasedataEntityType)entityType, (Object[])objects, ignoreRefEntityIds, checkRefEntityIds, null);
                ArrayList<Long> deleteIdList = new ArrayList<Long>(10);
                for (ExtendedDataEntity dataEntity2 : dataEntities) {
                    BaseDataCheckRefrenceResult refResult = (BaseDataCheckRefrenceResult)refResultMap.get(dataEntity2.getBillPkId());
                    if (refResult != null && refResult.isRefence()) {
                        this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u5df2\u521b\u5efa\u8003\u6838\u5468\u671f\u6267\u884c\u8ba1\u5212\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"SchemeBaseInfoDeleteOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    deleteIdList.add((Long)dataEntity2.getBillPkId());
                }
                if (!ObjectUtils.isEmpty(deleteIdList)) {
                    APP_SERVICE.deleteSchemeInfoById(deleteIdList);
                }
            }
        });
    }
}

