/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.application.service.activity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.utils.ListUtils;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;

public class ActivityResultConfirmService {
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final Log log = LogFactory.getLog(ActivityResultConfirmService.class);

    public Map<Long, String> startUpHandle(List<Long> evaluationObjIds) {
        DynamicObject[] evaluationObjects = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(evaluationObjIds);
        Map<Long, String> validateMap = ListUtils.doStartConfirm(evaluationObjects, evalObj -> {
            if (evalObj.getLong("assessnode.id") == NodeTabMapEnum.EVAL_PROCESS.getNodeId().longValue() && evalObj.getDynamicObjectType().getProperties().containsKey((Object)"isincalc") && evalObj.getBoolean("isincalc")) {
                return ResManager.loadKDString((String)"\u5458\u5de5\u8003\u6838\u8bc4\u4f30\u91cd\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e\u542f\u52a8\u786e\u8ba4\u3002", (String)"ActivityResultConfirmService_0", (String)"opmc-epa-business", (Object[])new Object[0]);
            }
            return "";
        }, this::updateEvalObj);
        return validateMap;
    }

    public Map<Long, String> terminalHandle(List<Long> evaluationObjIds) {
        DynamicObject[] evaluationObjects = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(evaluationObjIds);
        HashMap<Long, String> validateMap = new HashMap<Long, String>();
        ArrayList<String> businessIds = new ArrayList<String>(evaluationObjIds.size());
        for (Long evaluationObjId : evaluationObjIds) {
            businessIds.add(String.valueOf(evaluationObjId));
        }
        this.workflowHandle(businessIds, validateMap);
        for (int i = evaluationObjIds.size() - 1; i > -1; --i) {
            if (!validateMap.containsKey(evaluationObjIds.get(i))) continue;
            evaluationObjIds.remove(i);
        }
        for (DynamicObject evalObj : evaluationObjects) {
            int nodeIndex = evalObj.getInt("nodeindex");
            long userId = UserServiceHelper.getCurrentUserId();
            Date now = new Date();
            try {
                this.updateEvalObj(nodeIndex, now, userId, evalObj);
                this.addActivityRecord(nodeIndex, evalObj, now, userId);
                EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject(new DynamicObject[]{evalObj});
            }
            catch (Exception e) {
                log.error((Throwable)e);
                validateMap.put(evalObj.getLong("id"), ResManager.loadKDString((String)"\u7ed3\u679c\u786e\u8ba4\u7ed3\u675f\u53d1\u751f\u5f02\u5e38\uff01", (String)"ActivityResultConfirmService_1", (String)"opmc-epa-business", (Object[])new Object[0]));
            }
        }
        return validateMap;
    }

    private void updateEvalObj(DynamicObject evaluationObj) {
        log.info(" ----------\u3010\u53d8\u66f4\u8bc4\u4f30\u5bf9\u8c61\u3011ASSESSNODE:{},NODEINDEX:{},NODESTATUS:{}----------", new Object[]{AssessNodeStatusEnum.CONFIRMING.getNodeId(), evaluationObj.getInt("nodeindex") + 1, AssessNodeStatusEnum.CONFIRMING.getStatus()});
        evaluationObj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        evaluationObj.set("modifytime", (Object)new Date());
        evaluationObj.set("assessnode", (Object)AssessNodeStatusEnum.CONFIRMING.getNodeId());
        evaluationObj.set("nodeindex", (Object)(evaluationObj.getInt("nodeindex") + 1));
        evaluationObj.set("nodestatus", (Object)AssessNodeStatusEnum.CONFIRMING.getStatus());
        evaluationObj.set(AssessScoreAbbrEnum.CFSOP.getCode(), evaluationObj.get(AssessScoreAbbrEnum.FSOP.getCode()));
        evaluationObj.set(AssessScoreAbbrEnum.CFLOP.getCode(), evaluationObj.get(AssessScoreAbbrEnum.FLOP.getCode()));
        evaluationObj.set("cfsopsource", evaluationObj.get("sopsource"));
    }

    protected void workflowHandle(List<String> workflowBusinessIdList, Map<Long, String> errorMap) {
        for (String businessKey : workflowBusinessIdList) {
            try {
                if (!WorkflowServiceHelper.inProcess((String)businessKey)) continue;
                WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                errorMap.put(Long.parseLong(businessKey), ResManager.loadKDString((String)"\u6d41\u7a0b\u7ec8\u6b62\u5931\u8d25\uff0c\u8bf7\u5230\u6d41\u7a0b\u670d\u52a1\u624b\u52a8\u7ec8\u6b62\uff0c\u672a\u7ec8\u6b62\u6d41\u7a0b\u4f1a\u5f71\u54cd\u540e\u7eed\u7ed3\u679c\u786e\u8ba4\u4e1a\u52a1\u3002", (String)"ActivityResultConfirmService_2", (String)"opmc-epa-business", (Object[])new Object[0]));
            }
        }
    }

    private void updateEvalObj(int nodeIndex, Date date, long userId, DynamicObject evaluationObj) {
        boolean isLastNode;
        log.info(" ----------\u3010\u53d8\u66f4\u8bc4\u4f30\u5bf9\u8c61\u3011ASSESSNODE:{},NODEINDEX:{},NODESTATUS:{}----------", new Object[]{AssessNodeStatusEnum.CONFIRMED.getNodeId(), nodeIndex, AssessNodeStatusEnum.CONFIRMED.getStatus()});
        evaluationObj.set("modifier", (Object)userId);
        evaluationObj.set("modifytime", (Object)date);
        evaluationObj.set("assessnode", (Object)AssessNodeStatusEnum.CONFIRMED.getNodeId());
        evaluationObj.set("nodeindex", (Object)nodeIndex);
        evaluationObj.set("nodestatus", (Object)AssessNodeStatusEnum.CONFIRMED.getStatus());
        DynamicObjectCollection timeplanEntry = evaluationObj.getDynamicObjectCollection("activity.timeplanentry");
        boolean bl = isLastNode = timeplanEntry.size() == nodeIndex;
        if (isLastNode) {
            evaluationObj.set("nodestatus", null);
            evaluationObj.set("assessstaus", (Object)AssessStausEnum.COMPLETED.getStatus());
            evaluationObj.set("assessnode", null);
            evaluationObj.set("nodeindex", null);
            evaluationObj.set("completetime", (Object)date);
        }
    }

    private void addActivityRecord(int nodeIndex, DynamicObject evaluationObj, Date date, long userId) {
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5f00\u59cb----------");
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.CONFIRMED.getNodeId());
        activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.CONFIRMED.getStatus());
        activityRecord.set("nodeindex", (Object)nodeIndex);
        activityRecord.set("endtime", (Object)date);
        activityRecord.set("starttype", (Object)"20");
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        activityRecord.set("activity", (Object)evaluationObj.getLong("activity.id"));
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("ose", evaluationObj.get("fsop"));
        activityRecord.set("ole", evaluationObj.get("flop"));
        activityRecord.set("creator", (Object)userId);
        activityRecord.set("createtime", (Object)date);
        activityRecord.set("modifier", (Object)userId);
        activityRecord.set("modifytime", (Object)date);
        ACTIVITY_RECORD_ENTITY.saveOne(activityRecord);
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5b8c\u6210----------");
    }
}

