/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.application.service.activity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.evalback.entity.EvalBackInfoResult;
import kd.opmc.epa.business.domain.evalback.entity.EvalBatchBackDto;
import kd.opmc.epa.business.domain.evalback.entity.EvalBatchBackResult;
import kd.opmc.epa.business.domain.evalback.entity.EvalObjResetAndRollBackReqVO;
import kd.opmc.epa.business.domain.evalback.service.ActEvalObjBackDomainService;
import kd.opmc.epa.business.domain.evalback.service.ActEvalObjConfirmBackDomainService;
import kd.opmc.epa.business.domain.indicator.service.IndicatorObjDomainService;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumDomainService;
import kd.opmc.epa.business.utils.ResetEvalUtil;

public class AssessActivityAggregationInterfaceService {
    private static final HRBaseServiceHelper evalObjService = new HRBaseServiceHelper("epa_actevalobj");
    private static Log LOGGER = LogFactory.getLog(AssessActivityAggregationInterfaceService.class);
    IndicatorObjDomainService INDICATOROBJDOMAINSERVICE = new IndicatorObjDomainService();
    ActEvalObjBackDomainService ACTEVALOBJBACKDOMAINSERVICE = new ActEvalObjBackDomainService();
    ActEvalObjConfirmBackDomainService ACTEVALOBJCONFIRMBACKDOMAINSERVICE = new ActEvalObjConfirmBackDomainService();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final PerfSumDomainService PERF_SUM_DOMAIN_SERVICE = PerfSumDomainService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();

    public EvalBatchBackResult evalObjResetAndRollBack(List<EvalObjResetAndRollBackReqVO> objs) {
        EvalBatchBackResult evalBatchBackResultOfAll = new EvalBatchBackResult();
        if (objs == null || objs.size() < 1) {
            return evalBatchBackResultOfAll;
        }
        Set<Long> nodeSet = this.getActivityNodeIdSet(objs);
        HashMap<Long, Set<EvalBatchBackDto>> evalObjRollBackMapByType = new HashMap<Long, Set<EvalBatchBackDto>>(16);
        HashMap<Long, EvalBatchBackDto> evalBatchBackDtoMap = new HashMap<Long, EvalBatchBackDto>(objs.size());
        TreeMap<Long, List<EvalBatchBackDto>> evalObjResetMapByType = new TreeMap<Long, List<EvalBatchBackDto>>(new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return (int)(o2 - o1);
            }
        });
        evalObjResetMapByType.put(1L, new ArrayList(10));
        evalObjResetMapByType.put(4L, new ArrayList(10));
        evalObjResetMapByType.put(5L, new ArrayList(10));
        evalObjResetMapByType.put(8L, new ArrayList(10));
        for (EvalObjResetAndRollBackReqVO obj : objs) {
            evalBatchBackDtoMap.put(obj.getEvalBatchBackDto().getEvalObjId(), obj.getEvalBatchBackDto());
            if (!evalObjRollBackMapByType.containsKey(obj.getBusinessType())) {
                evalObjRollBackMapByType.put(obj.getBusinessType(), new HashSet(10));
            }
            ((Set)evalObjRollBackMapByType.get(obj.getBusinessType())).add(obj.getEvalBatchBackDto());
        }
        this.validateEvalObj(evalObjRollBackMapByType, evalBatchBackResultOfAll, evalBatchBackDtoMap);
        DynamicObject[] evalObjs = evalObjService.loadDynamicObjectArray(evalBatchBackDtoMap.keySet().toArray());
        Long activityId = objs.get(0).getEvalBatchBackDto().getActivityId();
        DynamicObject activityDy = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(activityId);
        DynamicObjectCollection timeplanEntry = activityDy.getDynamicObjectCollection("timeplanentry");
        int size = timeplanEntry.size();
        for (DynamicObject evalObj : evalObjs) {
            if (evalObj.getLong("assessnode.id") == 1L || evalObj.getLong("assessnode.id") == 4L) {
                ((List)evalObjResetMapByType.get(evalObj.getLong("assessnode.id"))).add(evalBatchBackDtoMap.get(evalObj.getLong("id")));
                continue;
            }
            if (evalObj.getLong("assessnode.id") == 8L) {
                ((List)evalObjResetMapByType.get(8L)).add(evalBatchBackDtoMap.get(evalObj.getLong("id")));
                continue;
            }
            if (evalObj.getLong("assessnode.id") == 5L) {
                ((List)evalObjResetMapByType.get(5L)).add(evalBatchBackDtoMap.get(evalObj.getLong("id")));
                continue;
            }
            ((List)evalObjResetMapByType.get(((DynamicObject)timeplanEntry.get(size - 1)).getLong("activity.id"))).add(evalBatchBackDtoMap.get(evalObj.getLong("id")));
        }
        HashSet<Long> failEvalObjSet = new HashSet<Long>(16);
        Set<Long> longs = evalObjResetMapByType.keySet();
        ArrayList<Long> ids = new ArrayList<Long>(longs.size());
        for (Long id : longs) {
            ids.add(id);
        }
        for (Long businessType : ids) {
            if (!nodeSet.contains(businessType)) {
                Long preLevel = evalObjResetMapByType.ceilingKey(businessType - 1L);
                if (preLevel == null) continue;
                evalObjResetMapByType.get(preLevel).addAll((Collection<EvalBatchBackDto>)evalObjResetMapByType.get(businessType));
                continue;
            }
            this.processRollBack(businessType, evalObjResetMapByType, evalObjRollBackMapByType, evalBatchBackResultOfAll, failEvalObjSet);
            this.processReset(businessType, evalObjResetMapByType, evalBatchBackResultOfAll, failEvalObjSet);
        }
        return evalBatchBackResultOfAll;
    }

    private Set<Long> getActivityNodeIdSet(List<EvalObjResetAndRollBackReqVO> objs) {
        DynamicObject activity = BusinessDataServiceHelper.loadSingle((Object)objs.get(0).getEvalBatchBackDto().getActivityId(), (String)"epa_activity", (String)"executescheme,perfworkflow");
        HashSet<Long> nodeSet = new HashSet<Long>(16);
        DynamicObject perfworkflow = BusinessDataServiceHelper.loadSingle((Object)activity.getLong("perfworkflow.id"), (String)"epa_perfworkflow");
        if (perfworkflow == null) {
            perfworkflow = BusinessDataServiceHelper.loadSingle((Object)activity.getDynamicObject("executescheme").getLong("perfworkflow.id"), (String)"epa_perfworkflow");
        }
        DynamicObjectCollection flowentries = perfworkflow.getDynamicObjectCollection("entryentity");
        for (DynamicObject flowentry : flowentries) {
            if (!flowentry.getBoolean("isshow")) continue;
            nodeSet.add(flowentry.getLong("node.id"));
        }
        return nodeSet;
    }

    private void validateEvalObj(Map<Long, Set<EvalBatchBackDto>> evalObjRollBackMapByType, EvalBatchBackResult evalBatchBackResultOfAll, Map<Long, EvalBatchBackDto> evalBatchBackDtoMap) {
        EvalBatchBackResult checkResult = null;
        if (evalObjRollBackMapByType.containsKey(4L)) {
            checkResult = this.ACTEVALOBJBACKDOMAINSERVICE.validateEvalBatchBack(Arrays.asList(evalObjRollBackMapByType.get(4L).toArray(new EvalBatchBackDto[0])));
            this.fileterEvalObj(evalObjRollBackMapByType.get(4L), checkResult, evalBatchBackResultOfAll, evalBatchBackDtoMap);
        }
        if (evalObjRollBackMapByType.containsKey(1L)) {
            checkResult = this.INDICATOROBJDOMAINSERVICE.validateIndicatorRollBack(Arrays.asList(evalObjRollBackMapByType.get(1L).toArray(new EvalBatchBackDto[0])));
            this.fileterEvalObj(evalObjRollBackMapByType.get(1L), checkResult, evalBatchBackResultOfAll, evalBatchBackDtoMap);
        }
    }

    private void fileterEvalObj(Set<EvalBatchBackDto> evalBatchBackDtos, EvalBatchBackResult checkResult, EvalBatchBackResult evalBatchBackResultOfAll, Map<Long, EvalBatchBackDto> evalBatchBackDtoMap) {
        List<EvalBackInfoResult> failureBackInfoList = checkResult.getFailureBackInfoList();
        if (failureBackInfoList == null || failureBackInfoList.size() < 1) {
            return;
        }
        evalBatchBackResultOfAll.addFailureCount(checkResult.getFailureCount());
        evalBatchBackResultOfAll.setTotalCount(evalBatchBackResultOfAll.getTotalCount() + checkResult.getFailureCount());
        evalBatchBackResultOfAll.getFailureBackInfoList().addAll(failureBackInfoList);
        for (EvalBackInfoResult evalBackInfoResult : failureBackInfoList) {
            if (!evalBatchBackDtoMap.containsKey(evalBackInfoResult.getEvalObjId())) continue;
            evalBatchBackDtos.remove(evalBatchBackDtoMap.get(evalBackInfoResult.getEvalObjId()));
            evalBatchBackDtoMap.remove(evalBackInfoResult.getEvalObjId());
        }
    }

    private void processReset(Long businessType, TreeMap<Long, List<EvalBatchBackDto>> evalObjResetMapByType, EvalBatchBackResult evalBatchBackResultOfAll, Set<Long> failEvalObjSet) {
        if (!evalObjResetMapByType.containsKey(businessType) || evalObjResetMapByType.get(businessType).size() < 1) {
            return;
        }
        EvalBatchBackResult evalBatchBackResultOfType = new EvalBatchBackResult();
        if (businessType == 1L) {
            evalBatchBackResultOfType = this.INDICATOROBJDOMAINSERVICE.batchRollBack(evalObjResetMapByType.get(businessType));
        } else {
            this.evaluatedResetCheck(evalObjResetMapByType.get(businessType), evalBatchBackResultOfAll);
            if (businessType == 4L) {
                evalBatchBackResultOfType = this.evaluatedReset(evalObjResetMapByType.get(businessType));
            } else if (businessType == 8L) {
                evalBatchBackResultOfType = this.ACTEVALOBJCONFIRMBACKDOMAINSERVICE.evalBatchBack(evalObjResetMapByType.get(businessType));
            } else if (businessType == 5L) {
                if (CollectionUtils.isEmpty((Collection)evalObjResetMapByType.get(businessType))) {
                    evalBatchBackResultOfType = new EvalBatchBackResult();
                } else {
                    ArrayList<Long> actObjIds = new ArrayList<Long>(10);
                    for (EvalBatchBackDto evalBatchBackDto : evalObjResetMapByType.get(businessType)) {
                        actObjIds.add(evalBatchBackDto.getEvalObjId());
                    }
                    boolean result = PERF_SUM_DOMAIN_SERVICE.dealResetEvalSumByInter(actObjIds, evalObjResetMapByType.get(businessType).get(0).getActivityId());
                    HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
                    evalBatchBackResultOfType = this.buildEvalBatchBackResult(evalObjResetMapByType.get(businessType), errorMap, result);
                }
            }
        }
        this.processResetResult(evalBatchBackResultOfType, evalBatchBackResultOfAll, businessType, evalObjResetMapByType, failEvalObjSet);
    }

    protected EvalBatchBackResult buildEvalBatchBackResult(List<EvalBatchBackDto> evalBatchBackDtoList, Map<Long, String> errorMap, boolean isSuccess) {
        EvalBatchBackResult evalBatchBackResult = new EvalBatchBackResult();
        List<EvalBackInfoResult> failureBackInfoList = evalBatchBackResult.getFailureBackInfoList();
        List<EvalBackInfoResult> sucessBackInfoList = evalBatchBackResult.getSucessBackInfoList();
        for (EvalBatchBackDto evalBatchBackDto : evalBatchBackDtoList) {
            Long evalObjId = evalBatchBackDto.getEvalObjId();
            if (!HRStringUtils.isEmpty((String)errorMap.get(evalObjId))) {
                failureBackInfoList.add(new EvalBackInfoResult(evalObjId, errorMap.get(evalObjId)));
                continue;
            }
            if (!isSuccess) {
                failureBackInfoList.add(new EvalBackInfoResult(evalObjId, ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AssessActivityAggregationInterfaceService_0", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
                continue;
            }
            sucessBackInfoList.add(new EvalBackInfoResult(evalObjId, ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"AssessActivityAggregationInterfaceService_1", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        }
        evalBatchBackResult.setTotalCount(evalBatchBackDtoList.size());
        evalBatchBackResult.setSuccessCount(sucessBackInfoList.size());
        evalBatchBackResult.setFailureCount(failureBackInfoList.size());
        return evalBatchBackResult;
    }

    private void evaluatedResetCheck(List<EvalBatchBackDto> evalBatchBackDtos, EvalBatchBackResult evalBatchBackResultOfAll) {
        ArrayList<Long> ids = new ArrayList<Long>(evalBatchBackDtos.size());
        for (EvalBatchBackDto evalBatchBackDto : evalBatchBackDtos) {
            ids.add(evalBatchBackDto.getEvalObjId());
        }
        Map<Long, String> nopassidsByCheck = AssessActivityAggregationInterfaceService.checkEvalCompletedReset(ids, true);
        for (int i = evalBatchBackDtos.size() - 1; i > -1; --i) {
            if (!nopassidsByCheck.containsKey(evalBatchBackDtos.get(i))) continue;
            evalBatchBackDtos.remove(i);
        }
        int failCnt = nopassidsByCheck.size();
        evalBatchBackResultOfAll.setTotalCount(evalBatchBackResultOfAll.getTotalCount() + failCnt);
        evalBatchBackResultOfAll.setFailureCount(evalBatchBackResultOfAll.getFailureCount() + failCnt);
        ArrayList<EvalBackInfoResult> failList = new ArrayList<EvalBackInfoResult>(failCnt);
        Set<Long> longs = nopassidsByCheck.keySet();
        ArrayList<Long> objids = new ArrayList<Long>(longs.size());
        for (Long id : longs) {
            objids.add(id);
        }
        for (Long objId : objids) {
            failList.add(new EvalBackInfoResult(objId, nopassidsByCheck.get(objId)));
        }
        evalBatchBackResultOfAll.getFailureBackInfoList().addAll(failList);
    }

    public static Map<Long, String> checkEvalCompletedReset(List<Long> actObjIds, boolean isInterface) {
        DynamicObject[] actObjs;
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        for (DynamicObject obj : actObjs = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryByPkValues(actObjIds.toArray())) {
            String message;
            String ressyncstatus = obj.getString("ressyncstatus");
            String evalfinishtype = obj.getString("evalfinishtype");
            if ("20".equals(ressyncstatus)) {
                message = ResManager.loadKDString((String)"\u7ee9\u6548\u7ed3\u679c\u5df2\u5f52\u6863\uff0c\u4e0d\u53ef\u91cd\u7f6e\u3002", (String)"AssessActivityAggregationInterfaceService_2", (String)"opmc-epa-business", (Object[])new Object[]{obj.getString("person.name"), obj.getString("person.number")});
                resultMap.put(obj.getLong("id"), message);
                continue;
            }
            if (!"30".equals(evalfinishtype) || !isInterface) continue;
            message = ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u8bc4\u4f30\u5b8c\u6210\u65b9\u5f0f\u4e3a\u201c\u624b\u5de5\u5f55\u5165\u201d\uff0c\u4e0d\u53ef\u91cd\u7f6e\u3002", (String)"AssessActivityAggregationInterfaceService_3", (String)"opmc-epa-business", (Object[])new Object[0]);
            resultMap.put(obj.getLong("id"), message);
        }
        return resultMap;
    }

    private EvalBatchBackResult evaluatedReset(List<EvalBatchBackDto> evalBatchBackDtos) {
        EvalBatchBackResult evalBatchBackResultOfType = new EvalBatchBackResult();
        ArrayList<Long> ids = new ArrayList<Long>(evalBatchBackDtos.size());
        for (EvalBatchBackDto evalBatchBackDto : evalBatchBackDtos) {
            ids.add(evalBatchBackDto.getEvalObjId());
        }
        Map<Long, String> nopassidsByReset = ResetEvalUtil.resetEval(ids);
        Long size = ids.size();
        Long i = size - 1L;
        while (i > -1L) {
            if (nopassidsByReset.containsKey(i)) {
                ids.remove(i);
            }
            Long l = i;
            Long l2 = i = Long.valueOf(i - 1L);
        }
        int failCnt = nopassidsByReset.size();
        evalBatchBackResultOfType.setTotalCount(evalBatchBackResultOfType.getTotalCount() + failCnt);
        evalBatchBackResultOfType.setFailureCount(evalBatchBackResultOfType.getFailureCount() + failCnt);
        ArrayList<EvalBackInfoResult> failList = new ArrayList<EvalBackInfoResult>(failCnt);
        ArrayList<EvalBackInfoResult> successList = new ArrayList<EvalBackInfoResult>(evalBatchBackDtos.size() - failCnt);
        Set<Long> longs = nopassidsByReset.keySet();
        ArrayList<Long> objids = new ArrayList<Long>(longs.size());
        for (Long id : longs) {
            objids.add(id);
        }
        for (Long objId : objids) {
            failList.add(new EvalBackInfoResult(objId, nopassidsByReset.get(objId)));
        }
        for (Long objId : ids) {
            successList.add(new EvalBackInfoResult(objId, null));
        }
        evalBatchBackResultOfType.setFailureBackInfoList(failList);
        evalBatchBackResultOfType.setSuccessBackInfoList(successList);
        return evalBatchBackResultOfType;
    }

    private void processRollBack(Long businessType, Map<Long, List<EvalBatchBackDto>> evalObjResetMapByType, Map<Long, Set<EvalBatchBackDto>> evalObjRollBackMapByType, EvalBatchBackResult evalBatchBackResultOfAll, Set<Long> failEvalObjSet) {
        EvalBatchBackResult evalBatchBackResultOfType = null;
        if (!evalObjRollBackMapByType.containsKey(businessType) || evalObjRollBackMapByType.get(businessType).size() < 1) {
            return;
        }
        ArrayList<EvalBatchBackDto> evalBatchBackDtos = new ArrayList<EvalBatchBackDto>(evalObjRollBackMapByType.get(businessType).size());
        Iterator<EvalBatchBackDto> iterator = evalObjRollBackMapByType.get(businessType).iterator();
        while (iterator.hasNext()) {
            evalBatchBackDtos.add(iterator.next());
        }
        for (int i = evalBatchBackDtos.size() - 1; i > -1; --i) {
            if (!failEvalObjSet.contains(((EvalBatchBackDto)evalBatchBackDtos.get(i)).getEvalObjId())) continue;
            evalBatchBackDtos.remove(i);
        }
        if (businessType == 1L) {
            evalBatchBackResultOfType = this.INDICATOROBJDOMAINSERVICE.batchRollBack(evalBatchBackDtos);
        } else if (businessType == 4L) {
            evalBatchBackResultOfType = this.ACTEVALOBJBACKDOMAINSERVICE.evalBatchBack(evalBatchBackDtos);
        } else if (businessType == 5L) {
            if (CollectionUtils.isEmpty((Collection)evalObjResetMapByType.get(businessType))) {
                evalBatchBackResultOfType = new EvalBatchBackResult();
            } else {
                ArrayList<Long> actObjIds = new ArrayList<Long>(10);
                for (EvalBatchBackDto evalBatchBackDto : evalObjResetMapByType.get(businessType)) {
                    actObjIds.add(evalBatchBackDto.getEvalObjId());
                }
                boolean result = PERF_SUM_DOMAIN_SERVICE.dealResetEvalSumByInter(actObjIds, evalObjResetMapByType.get(businessType).get(0).getActivityId());
                HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
                evalBatchBackResultOfType = this.buildEvalBatchBackResult(evalObjResetMapByType.get(businessType), errorMap, result);
            }
        }
        this.processRollBackResult(evalBatchBackResultOfType, evalBatchBackResultOfAll, businessType, evalObjResetMapByType, evalObjRollBackMapByType);
    }

    private void processRollBackResult(EvalBatchBackResult evalBatchBackResultOfType, EvalBatchBackResult evalBatchBackResultOfAll, Long businessType, Map<Long, List<EvalBatchBackDto>> evalObjResetMapByType, Map<Long, Set<EvalBatchBackDto>> evalObjRollBackMapByType) {
        evalBatchBackResultOfAll.getFailureBackInfoList().addAll(evalBatchBackResultOfType.getFailureBackInfoList());
        evalBatchBackResultOfAll.getSucessBackInfoList().addAll(evalBatchBackResultOfType.getSucessBackInfoList());
        evalBatchBackResultOfAll.setFailureCount(evalBatchBackResultOfAll.getFailureCount() + evalBatchBackResultOfType.getFailureCount());
        evalBatchBackResultOfAll.setSuccessCount(evalBatchBackResultOfAll.getSuccessCount() + evalBatchBackResultOfType.getSuccessCount());
        evalBatchBackResultOfAll.setTotalCount(evalBatchBackResultOfAll.getTotalCount() + evalBatchBackResultOfType.getTotalCount());
        Set<EvalBatchBackDto> evalObjRollBackByType = evalObjRollBackMapByType.get(businessType);
        List<EvalBatchBackDto> evalObjResetByType = evalObjResetMapByType.get(businessType);
        for (int i = evalObjResetByType.size() - 1; i > -1; --i) {
            if (!evalObjRollBackByType.contains(evalObjResetByType.get(i))) continue;
            evalObjResetByType.remove(i);
        }
    }

    private void processResetResult(EvalBatchBackResult evalBatchBackResultOfType, EvalBatchBackResult evalBatchBackResultOfAll, Long businessType, TreeMap<Long, List<EvalBatchBackDto>> evalObjResetMapByType, Set<Long> failEvalObjSet) {
        List<EvalBackInfoResult> failureBackInfoList = evalBatchBackResultOfType.getFailureBackInfoList();
        HashSet<Long> failSet = new HashSet<Long>(failureBackInfoList.size());
        for (EvalBackInfoResult evalBackInfoResult : failureBackInfoList) {
            failEvalObjSet.add(evalBackInfoResult.getEvalObjId());
            failSet.add(evalBackInfoResult.getEvalObjId());
        }
        evalBatchBackResultOfAll.getFailureBackInfoList().addAll(failureBackInfoList);
        evalBatchBackResultOfAll.setFailureCount(evalBatchBackResultOfAll.getFailureCount() + evalBatchBackResultOfType.getFailureCount());
        evalBatchBackResultOfAll.setTotalCount(evalBatchBackResultOfAll.getTotalCount() + evalBatchBackResultOfType.getFailureCount());
        List<EvalBatchBackDto> evalBatchBackDtos = evalObjResetMapByType.get(businessType);
        for (int i = evalBatchBackDtos.size() - 1; i > -1; --i) {
            if (!failSet.contains(evalBatchBackDtos.get(i).getEvalObjId())) continue;
            evalBatchBackDtos.remove(i);
        }
        Long preLevel = evalObjResetMapByType.ceilingKey(businessType - 1L);
        if (preLevel == null) {
            return;
        }
        evalObjResetMapByType.get(preLevel).addAll(evalBatchBackDtos);
    }
}

