/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.application.service.dynpermission;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.opmc.epa.business.application.service.dynpermission.presetpermission.ContentAreaUtils;
import kd.opmc.epa.business.application.service.dynpermission.presetpermission.MapKeyUtils;
import kd.opmc.epa.business.application.service.dynpermission.presetpermission.PresetUtils;
import kd.opmc.epa.business.application.service.dynpermission.presetpermission.ScopeAreaUtils;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.business.domain.permission.utils.PermissionAreaMap;
import kd.opmc.epa.business.domain.permission.utils.PermissionShowAreaMap;
import kd.opmc.epa.common.bo.ContentAreaBo;
import kd.opmc.epa.common.bo.ContentFieldBo;
import kd.opmc.epa.common.bo.ScopeAreaBo;
import kd.opmc.epa.common.enums.per.PassessNodeEnum;
import kd.opmc.epa.common.vo.AreaCollBO;
import kd.opmc.epa.common.vo.EmpSumBO;
import kd.opmc.epa.common.vo.dynpermission.BatchPermissionProperInfo;
import kd.opmc.epa.common.vo.dynpermission.ContentAreaEntry;
import kd.opmc.epa.common.vo.dynpermission.ContentFieldEntry;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionBatchVo;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.epa.common.vo.dynpermission.ScopeAreaEntry;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService;

public class DynPermissionConfigService {
    private static final HRBaseServiceHelper permitService = new HRBaseServiceHelper("epa_processpermsetting");
    private static final HRBaseServiceHelper assessFormService = new HRBaseServiceHelper("epa_assessform");
    private static final HRBaseServiceHelper flowService = new HRBaseServiceHelper("epa_perfworkflow");
    private static final HRBaseServiceHelper subFlowService = new HRBaseServiceHelper("pbs_workflow");
    private static final HRBaseServiceHelper flowDefProcService = new HRBaseServiceHelper("pbs_flowdefproc");
    private static final HRBaseServiceHelper activityService = new HRBaseServiceHelper("epa_activity");
    private static final HRBaseServiceHelper dynPermitService = new HRBaseServiceHelper("epa_dynamicpermission");
    private static final AssessFormDomainService ASSESS_FORM_DOMAIN_SERVICE = AssessFormDomainService.getInstance();
    private static final FlowDefNodeEntityService FLOW_DEF_NODE_ENTITY_SERVICE = FlowDefNodeEntityService.getInstance();
    private static final String AFLOWDEFNODE = "aflowdefnode";
    private static final String PFLOWDEFNODE = "pflowdefnode";
    private static Log LOGGER = LogFactory.getLog(DynPermissionConfigService.class);

    public void migratePermissionData() {
        DynamicObject[] oldPerObjs;
        String perSelectProps = "number,name,assessform,id,perfworkflow.id,excutescheme,id,contentareaentry.id, contentareaentry.areapage, contentareaentry.areapageinsid, contentareaentry.areadisplayitem ,contentareaentry.areapageinsname,contentareaentry.areamodifyitem,contentareaentry.pflowdefnode,contentareaentry.fieldmustinputitem,contentareaentry.fielddissettings,contentareaentry.fieldupsettings,contentareaentry.requiredsettings,contentareaentry.displaysettings,contentareaentry.updatesettings,contentareaentry.contentfieldentry,contentfieldentry.areafield,contentareaentry.contentfieldentry,contentfieldentry.areafieldname,contentareaentry.fielddisplayitem,contentareaentry.fieldmodifyitem,contentareaentry.seq,contentareaentry.contentfieldentry.seq,scopeareaentry.scorecontent, scopeareaentry.scoreshowarea,scopeareaentry.aflowdefnode,scopeareaentry.seq";
        DynamicObject[] activities = activityService.query("processpermsetting.id", new QFilter[]{new QFilter("processpermsetting", "is not null", null)});
        HashSet<Long> permIdSet = new HashSet<Long>(activities.length);
        for (DynamicObject activity : activities) {
            permIdSet.add(activity.getLong("processpermsetting.id"));
        }
        for (DynamicObject oldPerObj : oldPerObjs = permitService.query("id", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1")})) {
            permIdSet.add(oldPerObj.getLong("id"));
        }
        ArrayList<Long> permIds = new ArrayList<Long>(permIdSet.size());
        for (Long permId : permIdSet) {
            permIds.add(permId);
        }
        int beginInd = 0;
        int endInd = 0;
        while (beginInd < permIds.size()) {
            endInd = beginInd + 500 > permIds.size() ? permIds.size() : beginInd + 500;
            this.doMigratePermissionData(perSelectProps, permIds.subList(beginInd, endInd));
            beginInd = endInd;
        }
    }

    private void doMigratePermissionData(String perSelectProps, List<Long> permIds) {
        DynamicObject[] oldPerObjs = permitService.query(perSelectProps, new QFilter[]{new QFilter("id", "in", permIds)});
        DynamicObject[] newPermObjs = new DynamicObject[oldPerObjs.length];
        for (int i = 0; i < oldPerObjs.length; ++i) {
            DynamicObjectCollection scopeareaentries = oldPerObjs[i].getDynamicObjectCollection("scopeareaentry");
            DynamicObjectCollection contentareaentries = oldPerObjs[i].getDynamicObjectCollection("contentareaentry");
            Map<Long, Map<Long, Long>> fieldInsIdMap = this.getFieldInsIdMapByAssessForm(oldPerObjs[i].getDynamicObject("assessform"));
            Map<Long, List<String>> scopeCollectionGroupByFlowNodeId = this.getScopeCollectionGroupByFlowNodeId(scopeareaentries);
            Map<Long, List<List<String>>> contentCollectionGroupByFlowNodeId = this.getContentCollectionGroupByFlowNodeId(contentareaentries, fieldInsIdMap);
            DynamicObject permobj = this.getNewDynPermConfigObj(oldPerObjs[i]);
            DynamicObjectCollection configEntries = permobj.getDynamicObjectCollection("perconfigentry");
            this.convertToCollectionWithOldPerm(configEntries, oldPerObjs[i].getDynamicObject("perfworkflow"), scopeCollectionGroupByFlowNodeId, contentCollectionGroupByFlowNodeId);
            newPermObjs[i] = permobj;
        }
        SaveServiceHelper.save((DynamicObject[])newPermObjs);
    }

    private DynamicObject getNewDynPermConfigObj(DynamicObject perobj) {
        DynamicObject permobj = BusinessDataServiceHelper.newDynamicObject((String)"epa_dynamicpermission");
        permobj.set("id", (Object)perobj.getLong("id"));
        permobj.set("number", (Object)perobj.getString("number"));
        permobj.set("name", (Object)perobj.getString("name"));
        permobj.set("assessform", (Object)perobj.getDynamicObject("assessform"));
        permobj.set("excutescheme", (Object)perobj.getDynamicObject("excutescheme"));
        permobj.set("perfworkflow", (Object)perobj.getDynamicObject("perfworkflow"));
        permobj.set("bindtype", (Object)"1");
        return permobj;
    }

    private Map<Long, Map<Long, Long>> getFieldInsIdMapByAssessForm(DynamicObject assessForm) {
        assessForm = assessFormService.loadSingle(assessForm.getPkValue());
        DynamicObjectCollection areaconfentries = assessForm.getDynamicObjectCollection("areaconfentry");
        HashMap<Long, Map<Long, Long>> fieldIdMap = new HashMap<Long, Map<Long, Long>>(areaconfentries.size());
        HashMap<String, HRBaseServiceHelper> serviceMap = new HashMap<String, HRBaseServiceHelper>(areaconfentries.size());
        Map<String, String> areaCofigNameMap = this.getAreaCofigNameByAreaConfigTypeMap();
        String entityName = "";
        this.processEmpInfoAndSumInfo(assessForm, fieldIdMap);
        for (DynamicObject areaconfentry : areaconfentries) {
            if (areaconfentry.getDynamicObject("areareg") == null || StringUtils.isBlank((CharSequence)(entityName = areaCofigNameMap.get(areaconfentry.getDynamicObject("areareg").getString("number"))))) continue;
            if (!serviceMap.containsKey(entityName)) {
                serviceMap.put(entityName, new HRBaseServiceHelper(entityName));
            }
            DynamicObject areaconf = null;
            try {
                areaconf = ((HRBaseServiceHelper)serviceMap.get(entityName)).loadSingle((Object)areaconfentry.getLong("areaconf"));
            }
            catch (KDException ex) {
                LOGGER.info(ex.getStackTraceMessage());
            }
            if (areaconf == null || !areaconf.containsProperty("entryentity") || areaconf.getDynamicObjectCollection("entryentity").size() < 1) continue;
            Long areaconfId = areaconf.getLong("id");
            if (!fieldIdMap.containsKey(areaconfId)) {
                fieldIdMap.put(areaconfId, new HashMap(areaconf.getDynamicObjectCollection("entryentity").size() * 2));
            }
            for (DynamicObject fieldEntry : areaconf.getDynamicObjectCollection("entryentity")) {
                ((Map)fieldIdMap.get(areaconfId)).put(fieldEntry.getLong("areafield.id"), fieldEntry.getLong("id"));
            }
        }
        return fieldIdMap;
    }

    private void processEmpInfoAndSumInfo(DynamicObject assessForm, Map<Long, Map<Long, Long>> fieldIdMap) {
        DynamicObject[] confs;
        DynamicObject empinfoconf = BusinessDataServiceHelper.loadSingle((Object)assessForm.getLong("empinfoconf"), (String)"epa_empinfoconf");
        DynamicObject sumconf = BusinessDataServiceHelper.loadSingle((Object)assessForm.getLong("sumconf"), (String)"epa_sumconf");
        for (DynamicObject areaconf : confs = new DynamicObject[]{empinfoconf, sumconf}) {
            if (areaconf == null || !areaconf.containsProperty("entryentity") || areaconf.getDynamicObjectCollection("entryentity").size() < 1) continue;
            Long areaconfId = areaconf.getLong("id");
            if (!fieldIdMap.containsKey(areaconfId)) {
                fieldIdMap.put(areaconfId, new HashMap(areaconf.getDynamicObjectCollection("entryentity").size() * 2));
            }
            for (DynamicObject fieldEntry : areaconf.getDynamicObjectCollection("entryentity")) {
                fieldIdMap.get(areaconfId).put(fieldEntry.getLong("areafield.id"), fieldEntry.getLong("id"));
            }
        }
    }

    private Map<String, String> getAreaCofigNameByAreaConfigTypeMap() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("epa_customarea", "epa_customareaconf");
        map.put("epa_empinfoarea", "epa_empinfoconf");
        map.put("epa_normindctrarea", "epa_normalconf");
        map.put("epa_plusminusarea", "epa_plusminusconf");
        map.put("epa_attacharea", "epa_sumconf");
        map.put("epa_sumarea", "epa_attachconf");
        return map;
    }

    public DynamicPermissionConfigVO getDynamicPermissions(Long id, List<Long> flownodeId) {
        DynamicPermissionConfigVO permissionConfigVO = new DynamicPermissionConfigVO();
        DynamicObject dynPermitObj = null;
        if (flownodeId == null || flownodeId.size() == 0) {
            dynPermitObj = dynPermitService.loadSingle((Object)id);
            permissionConfigVO.setAssessForm(dynPermitObj.getDynamicObject("assessform"));
            permissionConfigVO.setExcuteScheme(dynPermitObj.getDynamicObject("excutescheme"));
            permissionConfigVO.setPerfWorkflow(dynPermitObj.getDynamicObject("perfworkflow"));
            permissionConfigVO.setPermissionId(Long.valueOf(dynPermitObj.getLong("id")));
            permissionConfigVO.setPermissionName(dynPermitObj.getString("name"));
        } else {
            dynPermitObj = dynPermitService.loadDynamicObject(new QFilter("id", "=", (Object)id).and(new QFilter("perconfigentry.flowdefnodeid", "in", flownodeId)));
        }
        if (dynPermitObj == null) {
            return null;
        }
        permissionConfigVO.setEntriesGroupByNode(dynPermitObj.getDynamicObjectCollection("perconfigentry"));
        return permissionConfigVO;
    }

    public Object[] insertDynamicPermission(DynamicPermissionConfigVO[] permissionConfigs, String bindType) {
        DynamicObject[] dynPermitObjs = new DynamicObject[permissionConfigs.length];
        for (int i = 0; i < permissionConfigs.length; ++i) {
            dynPermitObjs[i] = this.convertToDynPermitObj(permissionConfigs[i], bindType);
        }
        Object[] datas = SaveServiceHelper.save((DynamicObject[])dynPermitObjs);
        return datas;
    }

    public Long insertDynamicPermission(DynamicPermissionConfigVO permissionConfig) {
        if (permissionConfig == null) {
            return 0L;
        }
        DynamicObject dynPermitObj = this.convertToDynPermitObj(permissionConfig, "1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynPermitObj});
        return dynPermitObj.getLong("id");
    }

    public Long insertDynamicPermission(DynamicPermissionConfigVO[] permissionConfigs) {
        if (permissionConfigs == null || permissionConfigs.length == 0) {
            return 0L;
        }
        DynamicObject[] dynPermitObjs = new DynamicObject[permissionConfigs.length];
        for (int i = 0; i < permissionConfigs.length; ++i) {
            dynPermitObjs[i] = this.convertToDynPermitObj(permissionConfigs[i], "1");
        }
        SaveServiceHelper.save((DynamicObject[])dynPermitObjs);
        return dynPermitObjs.length;
    }

    public void updateDynamicPermission(DynamicPermissionConfigVO permissionConfig) {
        if (permissionConfig == null) {
            return;
        }
        DynamicObject dynPermitObj = dynPermitService.loadSingle((Object)permissionConfig.getPermissionId());
        dynPermitObj.getDynamicObjectCollection("perconfigentry").clear();
        this.convertToCollection(dynPermitObj.getDynamicObjectCollection("perconfigentry"), permissionConfig);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynPermitObj});
    }

    public void batchSave(DynamicPermissionBatchVo batchVo) {
        if (batchVo == null || batchVo.getProperInfos() == null || batchVo.getProperInfos().size() < 1) {
            return;
        }
        List properInfos = batchVo.getProperInfos();
        DynamicPermissionConfigVO sourceConfigVO = batchVo.getPermissionConfigVO();
        int size = properInfos.size();
        DynamicObject[] dynPermitObjs = new DynamicObject[size];
        BatchPermissionProperInfo properInfo = null;
        DynamicObject dynPermitObj = this.convertToDynPermitObj(sourceConfigVO, "1");
        Map<Long, DynamicObject> existDynPermitObjMap = this.queryExistDynPermitObj(this.getExecuteSchemeIds(properInfos), sourceConfigVO.getAssessForm() != null ? sourceConfigVO.getAssessForm().getLong("id") : 0L, sourceConfigVO.getPerfWorkflow().getLong("id"));
        Long schemeId = 0L;
        DynamicObject[] saveObjs = new DynamicObject[size - existDynPermitObjMap.size()];
        DynamicObject[] updateObjs = new DynamicObject[existDynPermitObjMap.size()];
        int saveInd = 0;
        int updateInd = 0;
        for (int i = 0; i < size; ++i) {
            properInfo = (BatchPermissionProperInfo)properInfos.get(i);
            schemeId = properInfo.getExecuteScheme().getLong("id");
            if (existDynPermitObjMap.containsKey(schemeId)) {
                DynamicObject updateObj = existDynPermitObjMap.get(schemeId);
                DynamicObjectCollection perconfigentries = dynPermitObj.getDynamicObjectCollection("perconfigentry");
                this.clearEntryId(perconfigentries);
                updateObj.set("perconfigentry", (Object)dynPermitObj.getDynamicObjectCollection("perconfigentry"));
                updateObjs[updateInd++] = updateObj;
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updateObj});
                continue;
            }
            DynamicObject newDynPermitObj = BusinessDataServiceHelper.newDynamicObject((String)"epa_dynamicpermission");
            DynamicObjectUtils.copy((DynamicObject)dynPermitObj, (DynamicObject)newDynPermitObj);
            newDynPermitObj.set("excutescheme", (Object)properInfo.getExecuteScheme());
            newDynPermitObj.set("name", (Object)properInfo.getPermissionName());
            newDynPermitObj.set("number", (Object)properInfo.getPermissionNumber());
            saveObjs[saveInd++] = newDynPermitObj;
        }
    }

    private void clearEntryId(DynamicObjectCollection collection) {
        for (DynamicObject entry : collection) {
            entry.getDataEntityState().setDirtyFlags(new long[]{8191L});
            entry.getDataEntityState().setBizChangeFlags(new long[]{2047L});
            entry.set("id", null);
        }
    }

    public Long createNewObjFromSourceObj(Long sourceDynPermId) {
        DynamicObject sourceDynPerm = dynPermitService.loadSingle((Object)sourceDynPermId);
        DynamicObject targetDynPerm = BusinessDataServiceHelper.newDynamicObject((String)"epa_dynamicpermission");
        DynamicObjectUtils.copy((DynamicObject)sourceDynPerm, (DynamicObject)targetDynPerm);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{targetDynPerm});
        return targetDynPerm.getLong("id");
    }

    private List<Long> getExecuteSchemeIds(List<BatchPermissionProperInfo> properInfos) {
        ArrayList<Long> executeSchemeIds = new ArrayList<Long>(properInfos.size());
        for (BatchPermissionProperInfo properInfo : properInfos) {
            executeSchemeIds.add(properInfo.getExecuteScheme().getLong("id"));
        }
        return executeSchemeIds;
    }

    private Map<Long, DynamicObject> queryExistDynPermitObj(List<Long> executeSchemeIds, long assessFormId, long perfWorkflowId) {
        DynamicObject[] existObjs = dynPermitService.loadDynamicObjectArray(new QFilter[]{new QFilter("excutescheme.id", "in", executeSchemeIds).and(new QFilter("assessform.id", "=", (Object)assessFormId)).and(new QFilter("perfworkflow.id", "=", (Object)perfWorkflowId).and(new QFilter("bindtype", "=", (Object)"1")))});
        if (existObjs == null || existObjs.length == 0) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> existObjMap = new HashMap<Long, DynamicObject>(existObjs.length * 2);
        for (DynamicObject existObj : existObjs) {
            existObjMap.put(existObj.getLong("excutescheme.id"), existObj);
        }
        return existObjMap;
    }

    private List<Long> getDynPermitObjIds(DynamicObject[] dynPermitObjs) {
        ArrayList<Long> ids = new ArrayList<Long>(dynPermitObjs.length);
        for (DynamicObject dynPermitObj : dynPermitObjs) {
            ids.add(dynPermitObj.getLong("id"));
        }
        return ids;
    }

    private Map<Long, Long> getAssessnodeMap(DynamicObjectCollection assessEntries) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        Long nodeId = 0L;
        for (DynamicObject entry : assessEntries) {
            nodeId = entry.getLong("node.id");
            if (map.containsKey(nodeId)) continue;
            map.put(nodeId, (Long)entry.getPkValue());
        }
        return map;
    }

    private Map<Long, List<String>> getScopeCollectionGroupByFlowNodeId(DynamicObjectCollection entries) {
        HashMap<Long, List<String>> collmap = new HashMap<Long, List<String>>(16);
        for (DynamicObject entry : entries) {
            if (!collmap.containsKey(entry.getLong(AFLOWDEFNODE))) {
                collmap.put(entry.getLong(AFLOWDEFNODE), new ArrayList(10));
            }
            ((List)collmap.get(entry.getLong(AFLOWDEFNODE))).add(this.collmaptransferScopeAreaEntryToJson(entry));
        }
        return collmap;
    }

    private Map<Long, List<List<String>>> getContentCollectionGroupByFlowNodeId(DynamicObjectCollection entries, Map<Long, Map<Long, Long>> fieldMap) {
        HashMap<Long, List<List<String>>> collmap = new HashMap<Long, List<List<String>>>(16);
        for (DynamicObject entry : entries) {
            if (collmap.get(entry.getLong(PFLOWDEFNODE)) == null) {
                collmap.put(entry.getLong(PFLOWDEFNODE), new ArrayList(10));
            }
            ((List)collmap.get(entry.getLong(PFLOWDEFNODE))).add(this.collmaptransferContnetAreaEntryToJson(entry, fieldMap));
        }
        return collmap;
    }

    private String collmaptransferScopeAreaEntryToJson(DynamicObject entry) {
        if (entry == null) {
            return "";
        }
        ScopeAreaBo scopeAreaBo = new ScopeAreaBo();
        scopeAreaBo.setScoreContentId(Long.valueOf(entry.getLong("scorecontent.id")));
        scopeAreaBo.setScoreShowAreaId(Long.valueOf(entry.getLong("scoreshowarea.id")));
        scopeAreaBo.setSeq(Integer.valueOf(entry.getInt("seq")));
        return JSON.toJSONString((Object)scopeAreaBo);
    }

    private List<String> collmaptransferContnetAreaEntryToJson(DynamicObject entry, Map<Long, Map<Long, Long>> fieldMap) {
        if (entry == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(10);
        ContentAreaBo contentArea = new ContentAreaBo();
        contentArea.setAreapageInsname(entry.getString("areapageinsname"));
        contentArea.setAreapageInsId(Long.valueOf(entry.getLong("areapageinsid")));
        contentArea.setAreapageId(Long.valueOf(entry.getLong("areapage.id")));
        contentArea.setAreaModify(Boolean.valueOf(entry.getBoolean("areamodifyitem")));
        contentArea.setAreaDisplay(Boolean.valueOf(entry.getBoolean("areadisplayitem")));
        contentArea.setSeq(Integer.valueOf(entry.getInt("seq")));
        contentArea.setAreaDisplaySetting(entry.getString("displaysettings"));
        contentArea.setAreaUpdateSetting(entry.getString("updatesettings"));
        list.add(JSON.toJSONString((Object)contentArea));
        ArrayList<ContentFieldBo> fields = new ArrayList<ContentFieldBo>(entry.getDynamicObjectCollection("contentfieldentry").size());
        for (DynamicObject fieldObj : entry.getDynamicObjectCollection("contentfieldentry")) {
            ContentFieldBo fieldBo = new ContentFieldBo();
            fieldBo.setAreaFieldId(Long.valueOf(fieldObj.getLong("areafield.id")));
            if (fieldMap.containsKey(contentArea.getAreapageInsId()) && fieldMap.get(contentArea.getAreapageInsId()).containsKey(fieldBo.getAreaFieldId())) {
                fieldBo.setAreaFieldInsId(fieldMap.get(contentArea.getAreapageInsId()).get(fieldBo.getAreaFieldId()));
            } else {
                fieldBo.setAreaFieldName(fieldObj.getString("areafieldname"));
            }
            fieldBo.setSeq(Integer.valueOf(fieldObj.getInt("seq")));
            Integer buttonSets = 0;
            fieldBo.setButtonSets(Integer.valueOf(buttonSets | (fieldObj.getBoolean("fielddisplayitem") ? 1 : 0) | (fieldObj.getBoolean("fieldmodifyitem") ? 2 : 0) | (fieldObj.getBoolean("fieldmustinputitem") ? 4 : 0)));
            fieldBo.setViewSets(fieldObj.getString("fielddissettings") + fieldObj.getString("fieldupsettings") + fieldObj.getString("requiredsettings"));
            fields.add(fieldBo);
        }
        list.add(JSON.toJSONString(fields));
        return list;
    }

    private DynamicObject convertToDynPermitObj(DynamicPermissionConfigVO configVO, String bindType) {
        DynamicObject permobj = BusinessDataServiceHelper.newDynamicObject((String)"epa_dynamicpermission");
        permobj.set("id", (Object)configVO.getPermissionId());
        permobj.set("number", (Object)configVO.getPermissionNumber());
        permobj.set("name", (Object)configVO.getPermissionName());
        permobj.set("assessform", (Object)configVO.getAssessForm());
        permobj.set("excutescheme", (Object)configVO.getExcuteScheme());
        permobj.set("perfworkflow", (Object)configVO.getPerfWorkflow());
        permobj.set("bindtype", (Object)bindType);
        this.convertToCollection(permobj.getDynamicObjectCollection("perconfigentry"), configVO);
        return permobj;
    }

    private void convertToCollection(DynamicObjectCollection collection, DynamicPermissionConfigVO configVO) {
        Map scopeAreaEntriesMap = configVO.getScopeAreaEntriesMap();
        Map contentAreaEntriesMap = configVO.getContentAreaEntriesMap();
        DynamicObject perfWorkflow = configVO.getPerfWorkflow();
        perfWorkflow = flowService.loadSingle(perfWorkflow.getPkValue());
        DynamicObjectCollection assessNodeEntries = perfWorkflow.getDynamicObjectCollection("entryentity");
        Map<Long, Long> assessnodeMap = this.getAssessnodeMap(assessNodeEntries);
        DynamicObjectCollection flowentries = perfWorkflow.getDynamicObjectCollection("flowentry");
        Long passnodeId = 0L;
        Long passnodeInsId = 0L;
        Long flowdefprocId = 0L;
        Long procNodeId = 0L;
        for (DynamicObject flowEntry : flowentries) {
            passnodeId = flowEntry.getLong("passnode");
            passnodeInsId = assessnodeMap.get(passnodeId);
            DynamicObject subflow = subFlowService.loadSingle((Object)flowEntry.getLong("flowvid"));
            if (subflow.getDynamicObjectCollection("entryentity") == null) continue;
            for (DynamicObject flowProcDef : subflow.getDynamicObjectCollection("entryentity")) {
                DynamicObject flowdefproc = flowDefProcService.loadSingle((Object)flowProcDef.getLong("flowdefproc"));
                if (flowdefproc == null || flowdefproc.getDynamicObjectCollection("nodeentry").size() == 0) continue;
                for (DynamicObject procNode : flowdefproc.getDynamicObjectCollection("nodeentry")) {
                    DynamicObject dynPermitEntry;
                    procNodeId = procNode.getLong("id");
                    if (scopeAreaEntriesMap != null && scopeAreaEntriesMap.get(procNodeId) != null) {
                        for (ScopeAreaEntry scopeAreaEntry : (List)scopeAreaEntriesMap.get(procNodeId)) {
                            dynPermitEntry = collection.addNew();
                            dynPermitEntry.set("passnodeid", (Object)passnodeId);
                            dynPermitEntry.set("flowvid", (Object)subflow.getLong("id"));
                            dynPermitEntry.set("flowdefnodeid", (Object)procNodeId);
                            dynPermitEntry.set("mainconfiguration", (Object)JSON.toJSONString((Object)scopeAreaEntry));
                            dynPermitEntry.set("configtype", (Object)"1");
                        }
                    }
                    if (contentAreaEntriesMap == null || contentAreaEntriesMap.get(procNodeId) == null) continue;
                    for (ContentAreaEntry contentAreaEntry : (List)contentAreaEntriesMap.get(procNodeId)) {
                        dynPermitEntry = collection.addNew();
                        dynPermitEntry.getDataEntityState().setDirtyFlags(new long[]{8191L});
                        dynPermitEntry.getDataEntityState().setBizChangeFlags(new long[]{2047L});
                        dynPermitEntry.set("passnodeid", (Object)passnodeId);
                        dynPermitEntry.set("flowvid", (Object)subflow.getLong("id"));
                        dynPermitEntry.set("flowdefnodeid", (Object)procNodeId);
                        dynPermitEntry.set("mainconfiguration", (Object)this.getContentAreaInfo(contentAreaEntry));
                        dynPermitEntry.set("fieldconfiguration_tag", (Object)this.getContentFieldInfo(contentAreaEntry.getFieldEntries()));
                        dynPermitEntry.set("configtype", (Object)"2");
                    }
                }
            }
        }
        this.processCustomFlowDefNode(collection, scopeAreaEntriesMap, contentAreaEntriesMap, new Long[]{8L, 1500000000000000000L});
    }

    private void processCustomFlowDefNode(DynamicObjectCollection collection, Map<Long, List<ScopeAreaEntry>> scopeAreaEntriesMap, Map<Long, List<ContentAreaEntry>> contentAreaEntriesMap, Long[] customNodeIds) {
        for (Long customNodeId : customNodeIds) {
            DynamicObject dynPermitEntry;
            if (scopeAreaEntriesMap.get(customNodeId) != null) {
                for (ScopeAreaEntry scopeAreaEntry : scopeAreaEntriesMap.get(customNodeId)) {
                    dynPermitEntry = collection.addNew();
                    dynPermitEntry.getDataEntityState().setDirtyFlags(new long[]{8191L});
                    dynPermitEntry.getDataEntityState().setBizChangeFlags(new long[]{2047L});
                    dynPermitEntry.set("passnodeid", (Object)customNodeId);
                    dynPermitEntry.set("flowvid", (Object)0L);
                    dynPermitEntry.set("flowdefnodeid", (Object)customNodeId);
                    dynPermitEntry.set("mainconfiguration", (Object)JSON.toJSONString((Object)scopeAreaEntry));
                    dynPermitEntry.set("configtype", (Object)"1");
                }
            }
            if (contentAreaEntriesMap.get(customNodeId) == null) continue;
            for (ContentAreaEntry contentAreaEntry : contentAreaEntriesMap.get(customNodeId)) {
                dynPermitEntry = collection.addNew();
                dynPermitEntry.getDataEntityState().setDirtyFlags(new long[]{8191L});
                dynPermitEntry.getDataEntityState().setBizChangeFlags(new long[]{2047L});
                dynPermitEntry.set("passnodeid", (Object)customNodeId);
                dynPermitEntry.set("flowvid", (Object)0L);
                dynPermitEntry.set("flowdefnodeid", (Object)customNodeId);
                dynPermitEntry.set("mainconfiguration", (Object)this.getContentAreaInfo(contentAreaEntry));
                dynPermitEntry.set("fieldconfiguration_tag", (Object)this.getContentFieldInfo(contentAreaEntry.getFieldEntries()));
                dynPermitEntry.set("configtype", (Object)"2");
            }
        }
    }

    private void convertToCollectionWithOldPerm(DynamicObjectCollection collection, DynamicObject perfWorkflow, Map<Long, List<String>> scopeCollectionGroupByFlowNodeId, Map<Long, List<List<String>>> contentCollectionGroupByFlowNodeId) {
        perfWorkflow = flowService.loadSingle(perfWorkflow.getPkValue());
        DynamicObjectCollection flowentries = perfWorkflow.getDynamicObjectCollection("flowentry");
        Long passnodeId = 0L;
        Long procNodeId = 0L;
        for (DynamicObject flowEntry : flowentries) {
            passnodeId = flowEntry.getLong("passnode");
            DynamicObject subflow = subFlowService.loadSingle((Object)flowEntry.getLong("flowvid"));
            if (subflow.getDynamicObjectCollection("entryentity") == null) continue;
            for (DynamicObject flowProcDef : subflow.getDynamicObjectCollection("entryentity")) {
                DynamicObject flowdefproc = flowDefProcService.loadSingle((Object)flowProcDef.getLong("flowdefproc"));
                if (flowdefproc == null || flowdefproc.getDynamicObjectCollection("nodeentry").size() == 0) continue;
                for (DynamicObject procNode : flowdefproc.getDynamicObjectCollection("nodeentry")) {
                    DynamicObject dynPermitEntry;
                    procNodeId = procNode.getLong("id");
                    if (scopeCollectionGroupByFlowNodeId != null && scopeCollectionGroupByFlowNodeId.get(procNodeId) != null) {
                        for (String string : scopeCollectionGroupByFlowNodeId.get(procNodeId)) {
                            dynPermitEntry = collection.addNew();
                            dynPermitEntry.set("passnodeid", (Object)passnodeId);
                            dynPermitEntry.set("flowvid", (Object)subflow.getLong("id"));
                            dynPermitEntry.set("flowid", (Object)subflow.getLong("boid"));
                            dynPermitEntry.set("flowdefnodeid", (Object)procNodeId);
                            dynPermitEntry.set("mainconfiguration", (Object)string);
                            dynPermitEntry.set("configtype", (Object)"1");
                        }
                    }
                    if (contentCollectionGroupByFlowNodeId == null || contentCollectionGroupByFlowNodeId.get(procNodeId) == null) continue;
                    for (List list : contentCollectionGroupByFlowNodeId.get(procNodeId)) {
                        dynPermitEntry = collection.addNew();
                        dynPermitEntry.set("passnodeid", (Object)passnodeId);
                        dynPermitEntry.set("flowvid", (Object)subflow.getLong("id"));
                        dynPermitEntry.set("flowid", (Object)subflow.getLong("boid"));
                        dynPermitEntry.set("flowdefnodeid", (Object)procNodeId);
                        dynPermitEntry.set("mainconfiguration", list.get(0));
                        dynPermitEntry.set("fieldconfiguration_tag", list.get(1));
                        dynPermitEntry.set("configtype", (Object)"2");
                    }
                }
            }
        }
        if (contentCollectionGroupByFlowNodeId != null) {
            this.processCustomFlowDefNodeWithOldPerm(collection, scopeCollectionGroupByFlowNodeId, contentCollectionGroupByFlowNodeId, new Long[]{8L, 1500000000000000000L});
        }
    }

    private void processCustomFlowDefNodeWithOldPerm(DynamicObjectCollection collection, Map<Long, List<String>> scopeCollectionGroupByFlowNodeId, Map<Long, List<List<String>>> contentCollectionGroupByFlowNodeId, Long[] customNodeIds) {
        for (Long customNodeId : customNodeIds) {
            DynamicObject dynPermitEntry;
            if (scopeCollectionGroupByFlowNodeId.containsKey(customNodeId)) {
                for (String string : scopeCollectionGroupByFlowNodeId.get(customNodeId)) {
                    dynPermitEntry = collection.addNew();
                    dynPermitEntry.set("passnodeid", (Object)customNodeId);
                    dynPermitEntry.set("flowvid", (Object)0L);
                    dynPermitEntry.set("flowdefnodeid", (Object)customNodeId);
                    dynPermitEntry.set("mainconfiguration", (Object)string);
                    dynPermitEntry.set("configtype", (Object)"1");
                }
            }
            if (!contentCollectionGroupByFlowNodeId.containsKey(customNodeId)) continue;
            for (List list : contentCollectionGroupByFlowNodeId.get(customNodeId)) {
                dynPermitEntry = collection.addNew();
                dynPermitEntry.set("passnodeid", (Object)customNodeId);
                dynPermitEntry.set("flowvid", (Object)0L);
                dynPermitEntry.set("flowdefnodeid", (Object)customNodeId);
                dynPermitEntry.set("mainconfiguration", list.get(0));
                dynPermitEntry.set("fieldconfiguration_tag", list.get(1));
                dynPermitEntry.set("configtype", (Object)"2");
            }
        }
    }

    private String getContentAreaInfo(ContentAreaEntry contentAreaEntry) {
        ContentAreaBo areaBo = new ContentAreaBo();
        areaBo.copyProperties(contentAreaEntry);
        return JSON.toJSONString((Object)areaBo);
    }

    private String getContentFieldInfo(List<ContentFieldEntry> fieldEntries) {
        ArrayList<ContentFieldBo> fieldBos = new ArrayList<ContentFieldBo>(fieldEntries.size());
        ContentFieldBo contentFieldBo = null;
        for (int i = 0; i < fieldEntries.size(); ++i) {
            contentFieldBo = new ContentFieldBo();
            contentFieldBo.copyProperties(fieldEntries.get(i));
            fieldBos.add(contentFieldBo);
        }
        return JSON.toJSONString(fieldBos);
    }

    public DynamicPermissionConfigVO getDynamicPermissionsWithNode(String dynamicPermissionKey) {
        DistributeSessionlessCache commonRegionCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("commonRegion");
        String dynamicPermissionString = (String)commonRegionCache.get(dynamicPermissionKey);
        DynamicPermissionConfigVO dynamicPermissionConfigVO = (DynamicPermissionConfigVO)JSON.parseObject((String)dynamicPermissionString, DynamicPermissionConfigVO.class);
        Map contentAreaEntriesMap = dynamicPermissionConfigVO.getContentAreaEntriesMap();
        DynamicObject dynPermitObj = dynPermitService.queryOne("id,assessform,excutescheme,perfworkflow", new QFilter("id", "=", (Object)dynamicPermissionConfigVO.getPermissionId()));
        long assessFormId = dynPermitObj.getLong("assessform.id");
        DynamicObject areaForm = ASSESS_FORM_DOMAIN_SERVICE.queryScoreSystemByAssessForm(assessFormId);
        if (areaForm != null) {
            DynamicObjectCollection areColls = areaForm.getDynamicObjectCollection("areaconfentry");
            AreaCollBO areaCollBO = PresetUtils.getAreaCollBo(areColls);
            DynamicObject empAndSumForm = ASSESS_FORM_DOMAIN_SERVICE.queryAssessForm(assessFormId);
            EmpSumBO empSumBO = PresetUtils.setEmpAndSum(empAndSumForm);
            Set<Long> areaFieldNameSet = PresetUtils.getAreaFieldNameSet(areColls, empSumBO, areaCollBO);
            for (Map.Entry entry : contentAreaEntriesMap.entrySet()) {
                DynamicObject flowDefNodeObj;
                if (!HRObjectUtils.isEmpty(entry.getValue()) && ((List)entry.getValue()).size() != 0) continue;
                long flowdefnodeid = (Long)entry.getKey();
                if (dynamicPermissionConfigVO.getFlowNodeWithAssnodeMap().get(flowdefnodeid) == null) continue;
                long assessNodeId = (Long)dynamicPermissionConfigVO.getFlowNodeWithAssnodeMap().get(flowdefnodeid);
                if (assessNodeId == PassessNodeEnum.RESULT_CONFIRMATION.getValue()) {
                    List<ScopeAreaEntry> list = ScopeAreaUtils.processResultAndCompleteAreaEntry(areaFieldNameSet, PassessNodeEnum.RESULT_CONFIRMATION.getValue());
                    if (!list.isEmpty()) {
                        dynamicPermissionConfigVO.getScopeAreaEntriesMap().put(PassessNodeEnum.RESULT_CONFIRMATION.getValue(), list);
                    }
                    DynamicObject perfWorkflow = BusinessDataServiceHelper.loadSingle((Object)dynPermitObj.getLong("perfworkflow.id"), (String)"epa_perfworkflow");
                    List<ContentAreaEntry> contentAreaEntryList = ContentAreaUtils.processResultAndCompleteContentArea(areColls, empSumBO, PassessNodeEnum.RESULT_CONFIRMATION.getValue(), areaCollBO, perfWorkflow);
                    if (contentAreaEntryList.isEmpty()) continue;
                    dynamicPermissionConfigVO.getContentAreaEntriesMap().put(PassessNodeEnum.RESULT_CONFIRMATION.getValue(), contentAreaEntryList);
                    continue;
                }
                if (assessNodeId != PassessNodeEnum.INDICATOR_DEVELOPMENT.getValue() && assessNodeId != PassessNodeEnum.PERFORMANCE_EVALUATION.getValue() || HRObjectUtils.isEmpty((Object)(flowDefNodeObj = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(Long.valueOf(flowdefnodeid))))) continue;
                Long nodeTypeId = flowDefNodeObj.getLong("nodetype.id");
                ArrayList<ScopeAreaEntry> list = new ArrayList<ScopeAreaEntry>(areaFieldNameSet.size());
                for (Long areaFieldNameId : areaFieldNameSet) {
                    String key = MapKeyUtils.getShowAreaCombineKey(assessNodeId, nodeTypeId, areaFieldNameId, flowDefNodeObj.getLong("id"));
                    if (PermissionShowAreaMap.getAreaDisplayMapValue(key) == null) continue;
                    ScopeAreaEntry scopeAreaEntry = new ScopeAreaEntry();
                    scopeAreaEntry.setScoreContentId(areaFieldNameId);
                    scopeAreaEntry.setScoreShowAreaId(PermissionShowAreaMap.getAreaDisplayMapValue(key));
                    scopeAreaEntry.setSeq(PermissionShowAreaMap.getAreaSeqMapValue(areaFieldNameId));
                    list.add(scopeAreaEntry);
                }
                if (!list.isEmpty()) {
                    dynamicPermissionConfigVO.getScopeAreaEntriesMap().put(flowDefNodeObj.getLong("id"), list);
                }
                ArrayList<ContentAreaEntry> contentAreaEntryList = new ArrayList<ContentAreaEntry>();
                ContentAreaUtils.processEmpAndSumArea(contentAreaEntryList, empSumBO, assessNodeId, nodeTypeId, flowDefNodeObj.getLong("id"));
                ContentAreaUtils.processOthersArea(contentAreaEntryList, areColls, assessNodeId, areaCollBO, flowDefNodeObj.getLong("id"), nodeTypeId);
                if (contentAreaEntryList.isEmpty()) continue;
                dynamicPermissionConfigVO.getContentAreaEntriesMap().put(flowDefNodeObj.getLong("id"), contentAreaEntryList);
            }
        }
        commonRegionCache.put(dynamicPermissionKey, (Object)JSON.toJSONString((Object)dynamicPermissionConfigVO), 1, TimeUnit.DAYS);
        return dynamicPermissionConfigVO;
    }

    public DynamicPermissionConfigVO getDynamicPermissionsWithNode(String dynamicPermissionKey, String assessFormIdStr, Long activityNodeId) {
        DistributeSessionlessCache commonRegionCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("commonRegion");
        String dynamicPermissionString = (String)commonRegionCache.get(dynamicPermissionKey);
        DynamicPermissionConfigVO dynamicPermissionConfigVO = (DynamicPermissionConfigVO)JSON.parseObject((String)dynamicPermissionString, DynamicPermissionConfigVO.class);
        Map contentAreaEntriesMap = dynamicPermissionConfigVO.getContentAreaEntriesMap();
        DynamicObject dynPermitObj = dynPermitService.queryOne("id,assessform,excutescheme,perfworkflow", new QFilter("id", "=", (Object)dynamicPermissionConfigVO.getPermissionId()));
        if (StringUtils.isBlank((CharSequence)assessFormIdStr) && (dynPermitObj.getDynamicObject("assessform") == null || dynPermitObj.getLong("assessform.id") == 0L)) {
            this.addSummaryInfoArea((List)contentAreaEntriesMap.get(activityNodeId), 1, activityNodeId);
            commonRegionCache.put(dynamicPermissionKey, (Object)JSON.toJSONString((Object)dynamicPermissionConfigVO), 1, TimeUnit.DAYS);
            return dynamicPermissionConfigVO;
        }
        Long assessFormId = StringUtils.isNotBlank((CharSequence)assessFormIdStr) ? Long.parseLong(assessFormIdStr) : dynPermitObj.getLong("assessform.id");
        DynamicObject areaForm = ASSESS_FORM_DOMAIN_SERVICE.queryScoreSystemByAssessForm(assessFormId);
        if (areaForm != null) {
            DynamicObjectCollection areColls = areaForm.getDynamicObjectCollection("areaconfentry");
            AreaCollBO areaCollBO = PresetUtils.getAreaCollBo(areColls);
            DynamicObject empAndSumForm = ASSESS_FORM_DOMAIN_SERVICE.queryAssessForm(assessFormId);
            EmpSumBO empSumBO = PresetUtils.setEmpAndSum(empAndSumForm);
            Set<Long> areaFieldNameSet = PresetUtils.getAreaFieldNameSet(areColls, empSumBO, areaCollBO);
            for (Map.Entry entry : contentAreaEntriesMap.entrySet()) {
                DynamicObject flowDefNodeObj;
                if (!HRObjectUtils.isEmpty(entry.getValue()) && ((List)entry.getValue()).size() != 0) continue;
                long flowdefnodeid = (Long)entry.getKey();
                if (dynamicPermissionConfigVO.getFlowNodeWithAssnodeMap().get(flowdefnodeid) == null) continue;
                long assessNodeId = (Long)dynamicPermissionConfigVO.getFlowNodeWithAssnodeMap().get(flowdefnodeid);
                if (assessNodeId == PassessNodeEnum.RESULT_CONFIRMATION.getValue()) {
                    List<ScopeAreaEntry> list = ScopeAreaUtils.processResultAndCompleteAreaEntry(areaFieldNameSet, PassessNodeEnum.RESULT_CONFIRMATION.getValue());
                    if (!list.isEmpty()) {
                        dynamicPermissionConfigVO.getScopeAreaEntriesMap().put(PassessNodeEnum.RESULT_CONFIRMATION.getValue(), list);
                    }
                    DynamicObject perfWorkflow = BusinessDataServiceHelper.loadSingle((Object)dynPermitObj.getLong("perfworkflow.id"), (String)"epa_perfworkflow");
                    List<ContentAreaEntry> contentAreaEntryList = ContentAreaUtils.processResultAndCompleteContentArea(areColls, empSumBO, PassessNodeEnum.RESULT_CONFIRMATION.getValue(), areaCollBO, perfWorkflow);
                    if (contentAreaEntryList.isEmpty()) continue;
                    dynamicPermissionConfigVO.getContentAreaEntriesMap().put(PassessNodeEnum.RESULT_CONFIRMATION.getValue(), contentAreaEntryList);
                    continue;
                }
                if (assessNodeId != PassessNodeEnum.INDICATOR_DEVELOPMENT.getValue() && assessNodeId != PassessNodeEnum.PERFORMANCE_EVALUATION.getValue() || HRObjectUtils.isEmpty((Object)(flowDefNodeObj = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(Long.valueOf(flowdefnodeid))))) continue;
                Long nodeTypeId = flowDefNodeObj.getLong("nodetype.id");
                ArrayList<ScopeAreaEntry> list = new ArrayList<ScopeAreaEntry>(areaFieldNameSet.size());
                for (Long areaFieldNameId : areaFieldNameSet) {
                    String key = MapKeyUtils.getShowAreaCombineKey(assessNodeId, nodeTypeId, areaFieldNameId, flowDefNodeObj.getLong("id"));
                    if (PermissionShowAreaMap.getAreaDisplayMapValue(key) == null) continue;
                    ScopeAreaEntry scopeAreaEntry = new ScopeAreaEntry();
                    scopeAreaEntry.setScoreContentId(areaFieldNameId);
                    scopeAreaEntry.setScoreShowAreaId(PermissionShowAreaMap.getAreaDisplayMapValue(key));
                    scopeAreaEntry.setSeq(PermissionShowAreaMap.getAreaSeqMapValue(areaFieldNameId));
                    list.add(scopeAreaEntry);
                }
                if (!list.isEmpty()) {
                    dynamicPermissionConfigVO.getScopeAreaEntriesMap().put(flowDefNodeObj.getLong("id"), list);
                }
                ArrayList<ContentAreaEntry> contentAreaEntryList = new ArrayList<ContentAreaEntry>();
                ContentAreaUtils.processEmpAndSumArea(contentAreaEntryList, empSumBO, assessNodeId, nodeTypeId, flowDefNodeObj.getLong("id"));
                ContentAreaUtils.processOthersArea(contentAreaEntryList, areColls, assessNodeId, areaCollBO, flowDefNodeObj.getLong("id"), nodeTypeId);
                if (contentAreaEntryList.isEmpty()) continue;
                dynamicPermissionConfigVO.getContentAreaEntriesMap().put(flowDefNodeObj.getLong("id"), contentAreaEntryList);
            }
        }
        commonRegionCache.put(dynamicPermissionKey, (Object)JSON.toJSONString((Object)dynamicPermissionConfigVO), 1, TimeUnit.DAYS);
        return dynamicPermissionConfigVO;
    }

    private void addSummaryInfoArea(List<ContentAreaEntry> areaEntries, Integer seq, Long activityNodeId) {
        String areaName = ResManager.loadKDString((String)"\u6c47\u603b\u4fe1\u606f\u533a", (String)"DynPermissionConfigService_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        long areaRegId = 1960097310314606592L;
        String key = MapKeyUtils.getAreaCombineKey(activityNodeId, 0L, areaRegId, 0L);
        ContentAreaEntry areaEntry = new ContentAreaEntry();
        areaEntry.setAreapageInsname(areaName);
        areaEntry.setAreapageInsId(Long.valueOf(areaRegId));
        areaEntry.setAreapageId(Long.valueOf(areaRegId));
        areaEntry.setSeq(seq);
        areaEntry.setAreaModify(PermissionAreaMap.getAreaUpdate(key));
        areaEntry.setAreaDisplay(PermissionAreaMap.getAreaDisplay(key));
        areaEntry.setAreaDisplaySetting(PermissionAreaMap.getAreaDisplayMapValue(key));
        areaEntry.setAreaUpdateSetting(PermissionAreaMap.getAreaUpdateMapValue(key));
        areaEntry.setFieldEntries(new ArrayList(10));
        areaEntries.add(areaEntry);
    }
}

