/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.application.service.dynpermission;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.common.bo.ContentAreaBo;
import kd.opmc.epa.common.bo.ContentFieldBo;
import kd.opmc.epa.common.bo.ScopeAreaBo;
import kd.opmc.epa.common.enums.per.AllFieldEnum;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService;

public class MigrateDynPermissionConfigService {
    private static final HRBaseServiceHelper permitService = new HRBaseServiceHelper("epa_processpermsetting");
    private static final HRBaseServiceHelper assessFormService = new HRBaseServiceHelper("epa_assessform");
    private static final HRBaseServiceHelper flowService = new HRBaseServiceHelper("epa_perfworkflow");
    private static final HRBaseServiceHelper subFlowService = new HRBaseServiceHelper("pbs_workflow");
    private static final HRBaseServiceHelper flowDefProcService = new HRBaseServiceHelper("pbs_flowdefproc");
    private static final HRBaseServiceHelper activityService = new HRBaseServiceHelper("epa_activity");
    private static final HRBaseServiceHelper dynPermitService = new HRBaseServiceHelper("epa_dynamicpermission");
    private static final HRBaseServiceHelper updateLogService = new HRBaseServiceHelper("epa_dynpermupdaterecord");
    private static final AssessFormDomainService ASSESS_FORM_DOMAIN_SERVICE = AssessFormDomainService.getInstance();
    private static final FlowDefNodeEntityService FLOW_DEF_NODE_ENTITY_SERVICE = FlowDefNodeEntityService.getInstance();
    private static final String AFLOWDEFNODE = "aflowdefnode";
    private static final String PFLOWDEFNODE = "pflowdefnode";
    private static Log LOGGER = LogFactory.getLog(MigrateDynPermissionConfigService.class);

    public void migratePermissionData(DynamicObject flagLogObj) {
        DynamicObject[] oldPerObjs;
        String perSelectProps = "number,name,assessform,id,perfworkflow.id,excutescheme,id,createtime,modifytime,iscurrentversion,contentareaentry.id, contentareaentry.areapage, contentareaentry.areapageinsid, contentareaentry.areadisplayitem ,contentareaentry.areapageinsname,contentareaentry.areamodifyitem,contentareaentry.pflowdefnode,contentareaentry.fieldmustinputitem,contentareaentry.fielddissettings,contentareaentry.fieldupsettings,contentareaentry.requiredsettings,contentareaentry.displaysettings,contentareaentry.updatesettings,contentareaentry.contentfieldentry,contentfieldentry.areafield,contentareaentry.contentfieldentry,contentfieldentry.areafieldname,contentareaentry.fielddisplayitem,contentareaentry.fieldmodifyitem,contentareaentry.seq,contentareaentry.contentfieldentry.seq,scopeareaentry.scorecontent, scopeareaentry.scoreshowarea,scopeareaentry.aflowdefnode,scopeareaentry.seq";
        DynamicObject[] activities = activityService.query("processpermsetting.id,name", new QFilter[]{new QFilter("processpermsetting", "!=", (Object)0L)});
        DynamicObject[] hasMigratePerms = dynPermitService.queryOriginalArray("id", null);
        HashSet<Long> hasMigratePermIds = new HashSet<Long>(hasMigratePerms.length);
        for (DynamicObject hasMigratePerm : hasMigratePerms) {
            hasMigratePermIds.add(hasMigratePerm.getLong("id"));
        }
        HashSet<Long> permIdSet = new HashSet<Long>(activities.length);
        for (DynamicObject activity : activities) {
            if (hasMigratePermIds.contains(activity.getLong("processpermsetting.id"))) continue;
            permIdSet.add(activity.getLong("processpermsetting.id"));
        }
        LOGGER.info("\u52a8\u6001\u63a7\u6743\u8fc1\u79fb\uff0c\u8003\u6838\u6d3b\u52a8\u4f9d\u8d56\u7684\u6570\u636e\u6761\u76ee" + permIdSet.size());
        for (DynamicObject oldPerObj : oldPerObjs = permitService.query("id", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1")})) {
            if (hasMigratePermIds.contains(oldPerObj.getLong("id"))) continue;
            permIdSet.add(oldPerObj.getLong("id"));
        }
        ArrayList<Long> permIds = new ArrayList<Long>(permIdSet.size());
        for (Long permId : permIdSet) {
            permIds.add(permId);
        }
        LOGGER.info("\u52a8\u6001\u63a7\u6743\u8fc1\u79fb\uff0c\u5168\u90e8\u6570\u636e\u6761\u76ee" + permIds.size());
        int beginInd = 0;
        int endInd = 0;
        while (beginInd < permIds.size()) {
            endInd = beginInd + 50 > permIds.size() ? permIds.size() : beginInd + 50;
            LOGGER.info("\u52a8\u6001\u63a7\u6743\u8fc1\u79fb\u8fc1\u79fb\u5f00\u59cb\uff0c\u4ece" + beginInd + "\u5230" + endInd);
            this.doMigratePermissionData(perSelectProps, permIds.subList(beginInd, endInd), flagLogObj);
            beginInd = endInd;
        }
        if (!"-1".equals(flagLogObj.getString("status"))) {
            flagLogObj.set("status", (Object)"1");
            flagLogObj.set("exceptiondesc", (Object)"");
            flagLogObj.set("traceid", (Object)"");
        }
        updateLogService.saveOne(flagLogObj);
        LOGGER.info("\u52a8\u6001\u63a7\u6743\u8fc1\u79fb\u5b8c\u6210");
    }

    public void migratePermissionData(List<Long> oldPermIds, DynamicObject flagLogObj) {
        String perSelectProps = "number,name,assessform,id,perfworkflow.id,excutescheme,id,createtime,modifytime,iscurrentversion,contentareaentry.id, contentareaentry.areapage, contentareaentry.areapageinsid, contentareaentry.areadisplayitem ,contentareaentry.areapageinsname,contentareaentry.areamodifyitem,contentareaentry.pflowdefnode,contentareaentry.fieldmustinputitem,contentareaentry.fielddissettings,contentareaentry.fieldupsettings,contentareaentry.requiredsettings,contentareaentry.displaysettings,contentareaentry.updatesettings,contentareaentry.contentfieldentry,contentfieldentry.areafield,contentareaentry.contentfieldentry,contentfieldentry.areafieldname,contentareaentry.fielddisplayitem,contentareaentry.fieldmodifyitem,contentareaentry.seq,contentareaentry.contentfieldentry.seq,scopeareaentry.scorecontent, scopeareaentry.scoreshowarea,scopeareaentry.aflowdefnode,scopeareaentry.seq";
        DynamicObject[] oldPerObjs = permitService.query("id", new QFilter[]{new QFilter("id", "in", oldPermIds)});
        ArrayList<Long> permIdSet = new ArrayList<Long>(oldPerObjs.length);
        for (DynamicObject oldPerObj : oldPerObjs) {
            permIdSet.add(oldPerObj.getLong("id"));
        }
        ArrayList<Long> permIds = new ArrayList<Long>(permIdSet.size());
        for (Long permId : permIdSet) {
            permIds.add(permId);
        }
        LOGGER.info("\u52a8\u6001\u63a7\u6743\u8fc1\u79fb\uff0c\u5168\u90e8\u6570\u636e\u6761\u76ee" + permIds.size());
        int beginInd = 0;
        int endInd = 0;
        while (beginInd < permIds.size()) {
            endInd = beginInd + 500 > permIds.size() ? permIds.size() : beginInd + 500;
            LOGGER.info("\u52a8\u6001\u63a7\u6743\u8fc1\u79fb\u8fc1\u79fb\u5f00\u59cb\uff0c\u4ece" + beginInd + "\u5230" + endInd);
            this.doMigratePermissionData(perSelectProps, permIds.subList(beginInd, endInd), flagLogObj);
            beginInd = endInd;
        }
        if (!"-1".equals(flagLogObj.getString("status"))) {
            flagLogObj.set("status", (Object)"1");
            flagLogObj.set("exceptiondesc", (Object)"");
            flagLogObj.set("traceid", (Object)"");
        }
        updateLogService.saveOne(flagLogObj);
        LOGGER.info("\u52a8\u6001\u63a7\u6743\u8fc1\u79fb\u5b8c\u6210");
    }

    private void doMigratePermissionData(String perSelectProps, List<Long> permIds, DynamicObject flagLogObj) {
        try {
            DynamicObject[] oldPerObjs = permitService.query(perSelectProps, new QFilter[]{new QFilter("id", "in", permIds)});
            ArrayList<DynamicObject> newPermObjs = new ArrayList<DynamicObject>(oldPerObjs.length);
            DynamicObject[] logObjs = new DynamicObject[oldPerObjs.length];
            for (int i = 0; i < oldPerObjs.length; ++i) {
                DynamicObject oldPerObj = oldPerObjs[i];
                LOGGER.info("\u52a8\u6001\u63a7\u6743\u8fc1\u79fb\uff0c\u5f53\u524d\u8fc1\u79fb\u6570\u636e:" + oldPerObj.getLong("id"));
                try {
                    logObjs[i] = updateLogService.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)oldPerObj.getLong("id"))});
                    if (logObjs[i] == null) {
                        logObjs[i] = this.generateSimpleLogObj(oldPerObj.getLong("id"), oldPerObj.getString("excutescheme.name"), oldPerObj.getString("excutescheme.number"));
                    }
                    DynamicObjectCollection scopeareaentries = oldPerObj.getDynamicObjectCollection("scopeareaentry");
                    DynamicObjectCollection contentareaentries = oldPerObj.getDynamicObjectCollection("contentareaentry");
                    Map<Long, Map<Long, Long>> fieldInsIdMap = this.getFieldInsIdMapByAssessForm(oldPerObj.getDynamicObject("assessform"));
                    Map<Long, List<String>> scopeCollectionGroupByFlowNodeId = this.getScopeCollectionGroupByFlowNodeId(scopeareaentries);
                    Map<Long, List<List<String>>> contentCollectionGroupByFlowNodeId = this.getContentCollectionGroupByFlowNodeId(contentareaentries, fieldInsIdMap);
                    DynamicObject permobj = this.getNewDynPermConfigObj(oldPerObj);
                    DynamicObjectCollection configEntries = permobj.getDynamicObjectCollection("perconfigentry");
                    this.convertToCollectionWithOldPerm(configEntries, oldPerObj.getDynamicObject("perfworkflow"), scopeCollectionGroupByFlowNodeId, contentCollectionGroupByFlowNodeId);
                    newPermObjs.add(permobj);
                    logObjs[i].set("status", (Object)"1");
                    logObjs[i].set("exceptiondesc", (Object)"");
                    logObjs[i].set("traceid", (Object)"");
                    continue;
                }
                catch (Exception e) {
                    logObjs[i].set("status", (Object)"-1");
                    logObjs[i].set("traceid", (Object)RequestContext.get().getTraceId());
                    logObjs[i].set("exceptiondesc", (Object)(StringUtils.isNotBlank((CharSequence)e.getMessage()) ? (e.getMessage().length() > 1000 ? e.getMessage().substring(0, 1000) : e.getMessage()) : "error"));
                    flagLogObj.set("status", (Object)"-1");
                    flagLogObj.set("exceptiondesc", (Object)ResManager.loadKDString((String)"\u5b58\u5728\u8fc1\u79fb\u5931\u8d25\u6570\u636e", (String)"MigrateDynPermissionConfigService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
                    LOGGER.error("\u52a8\u6001\u6743\u9650\u8fc1\u79fb\u5f02\u5e38,\u6743\u9650id\uff1a" + oldPerObj.getLong("id") + "," + e.getMessage(), (Throwable)e);
                }
            }
            SaveServiceHelper.save((DynamicObject[])newPermObjs.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])logObjs);
        }
        catch (Exception e) {
            LOGGER.error("\u52a8\u6001\u6743\u9650\u8fc1\u79fb\u5f02\u5e38\uff01\uff01\uff01" + e.getMessage(), (Throwable)e);
            flagLogObj.set("status", (Object)"-1");
            flagLogObj.set("traceid", (Object)RequestContext.get().getTraceId());
            flagLogObj.set("exceptiondesc", (Object)(StringUtils.isNotBlank((CharSequence)e.getMessage()) ? (e.getMessage().length() > 1000 ? e.getMessage().substring(0, 1000) : e.getMessage()) : "error"));
        }
    }

    private DynamicObject getNewDynPermConfigObj(DynamicObject perobj) {
        DynamicObject permobj = BusinessDataServiceHelper.newDynamicObject((String)"epa_dynamicpermission");
        permobj.set("id", (Object)perobj.getLong("id"));
        permobj.set("number", (Object)perobj.getString("number"));
        permobj.set("name", (Object)perobj.getString("name"));
        permobj.set("assessform", (Object)perobj.getDynamicObject("assessform"));
        permobj.set("excutescheme", (Object)perobj.getDynamicObject("excutescheme"));
        permobj.set("perfworkflow", (Object)perobj.getDynamicObject("perfworkflow"));
        permobj.set("bindtype", (Object)"1");
        if ("1".equals(perobj.getString("iscurrentversion")) || "true".equals(perobj.getString("iscurrentversion"))) {
            permobj.set("createtime", perobj.get("modifytime"));
        } else {
            permobj.set("createtime", perobj.get("createtime"));
        }
        return permobj;
    }

    private Map<Long, Map<Long, Long>> getFieldInsIdMapByAssessForm(DynamicObject assessForm) {
        assessForm = assessFormService.loadSingle(assessForm.getPkValue());
        DynamicObjectCollection areaconfentries = assessForm.getDynamicObjectCollection("areaconfentry");
        HashMap<Long, Map<Long, Long>> fieldIdMap = new HashMap<Long, Map<Long, Long>>(areaconfentries.size());
        HashMap<String, HRBaseServiceHelper> serviceMap = new HashMap<String, HRBaseServiceHelper>(areaconfentries.size());
        Map<String, String> areaCofigNameMap = this.getAreaCofigNameByAreaConfigTypeMap();
        String entityName = "";
        this.processEmpInfoAndSumInfo(assessForm, fieldIdMap);
        for (DynamicObject areaconfentry : areaconfentries) {
            if (areaconfentry.getDynamicObject("areareg") == null || StringUtils.isBlank((CharSequence)(entityName = areaCofigNameMap.get(areaconfentry.getDynamicObject("areareg").getString("number"))))) continue;
            if (!serviceMap.containsKey(entityName)) {
                serviceMap.put(entityName, new HRBaseServiceHelper(entityName));
            }
            DynamicObject areaconf = null;
            try {
                areaconf = ((HRBaseServiceHelper)serviceMap.get(entityName)).loadSingle((Object)areaconfentry.getLong("areaconf"));
            }
            catch (KDException ex) {
                LOGGER.info(ex.getStackTraceMessage());
            }
            if (areaconf == null || !areaconf.containsProperty("entryentity") || areaconf.getDynamicObjectCollection("entryentity").size() < 1) continue;
            Long areaconfId = areaconf.getLong("id");
            if (!fieldIdMap.containsKey(areaconfId)) {
                fieldIdMap.put(areaconfId, new HashMap(areaconf.getDynamicObjectCollection("entryentity").size() * 2));
            }
            for (DynamicObject fieldEntry : areaconf.getDynamicObjectCollection("entryentity")) {
                ((Map)fieldIdMap.get(areaconfId)).put(fieldEntry.getLong("areafield.id"), fieldEntry.getLong("id"));
            }
        }
        return fieldIdMap;
    }

    private void processEmpInfoAndSumInfo(DynamicObject assessForm, Map<Long, Map<Long, Long>> fieldIdMap) {
        DynamicObject[] confs;
        DynamicObject empinfoconf = BusinessDataServiceHelper.loadSingle((Object)assessForm.getLong("empinfoconf"), (String)"epa_empinfoconf");
        DynamicObject sumconf = BusinessDataServiceHelper.loadSingle((Object)assessForm.getLong("sumconf"), (String)"epa_sumconf");
        for (DynamicObject areaconf : confs = new DynamicObject[]{empinfoconf, sumconf}) {
            if (areaconf == null || !areaconf.containsProperty("entryentity") || areaconf.getDynamicObjectCollection("entryentity").size() < 1) continue;
            Long areaconfId = areaconf.getLong("id");
            if (!fieldIdMap.containsKey(areaconfId)) {
                fieldIdMap.put(areaconfId, new HashMap(areaconf.getDynamicObjectCollection("entryentity").size() * 2));
            }
            for (DynamicObject fieldEntry : areaconf.getDynamicObjectCollection("entryentity")) {
                fieldIdMap.get(areaconfId).put(fieldEntry.getLong("areafield.id"), fieldEntry.getLong("id"));
            }
        }
    }

    private Map<String, String> getAreaCofigNameByAreaConfigTypeMap() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("epa_customarea", "epa_customareaconf");
        map.put("epa_empinfoarea", "epa_empinfoconf");
        map.put("epa_normindctrarea", "epa_normalconf");
        map.put("epa_plusminusarea", "epa_plusminusconf");
        map.put("epa_attacharea", "epa_attachconf");
        map.put("epa_sumarea", "epa_sumconf");
        return map;
    }

    private Map<Long, List<String>> getScopeCollectionGroupByFlowNodeId(DynamicObjectCollection entries) {
        HashMap<Long, List<String>> collmap = new HashMap<Long, List<String>>(16);
        for (DynamicObject entry : entries) {
            long flowdefnodeId = entry.getLong(AFLOWDEFNODE);
            if (!collmap.containsKey(flowdefnodeId)) {
                collmap.put(flowdefnodeId, new ArrayList(10));
            }
            if (flowdefnodeId != 8L && flowdefnodeId != 1500000000000000000L) {
                DynamicObject flowDefNode = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(Long.valueOf(flowdefnodeId));
                long scorecontentId = entry.getLong("scorecontent.id");
                if (flowDefNode == null || flowDefNode.getBoolean("crossscore") && (scorecontentId == 1807346111959176192L || scorecontentId == 1807346599211471872L || scorecontentId == 1807346239642178560L)) continue;
            }
            ((List)collmap.get(flowdefnodeId)).add(this.collmaptransferScopeAreaEntryToJson(entry));
        }
        return collmap;
    }

    private Map<Long, List<List<String>>> getContentCollectionGroupByFlowNodeId(DynamicObjectCollection entries, Map<Long, Map<Long, Long>> fieldMap) {
        HashMap<Long, List<List<String>>> collmap = new HashMap<Long, List<List<String>>>(16);
        for (DynamicObject entry : entries) {
            long flowdefnodeId = entry.getLong(PFLOWDEFNODE);
            LOGGER.info("\u52a8\u6001\u63a7\u6743\u8fc1\u79fb\uff0c\u5f53\u524d\u8fc1\u79fb\u6570\u636e\u7684\u6d41\u7a0b\u8282\u70b9\u5b9a\u4e49:" + flowdefnodeId);
            if (collmap.get(flowdefnodeId) == null) {
                collmap.put(flowdefnodeId, new ArrayList(10));
            }
            boolean iscross = false;
            boolean isbatchadjust = false;
            boolean isbatchscore = false;
            if (flowdefnodeId == 8L || flowdefnodeId == 1500000000000000000L) {
                this.collmaptransferContnetAreaEntryToJson(flowdefnodeId, entry, fieldMap, (List)collmap.get(flowdefnodeId), iscross, isbatchadjust, isbatchscore);
                continue;
            }
            DynamicObject flowDefNode = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(Long.valueOf(flowdefnodeId));
            if (flowDefNode == null) continue;
            if (flowDefNode != null && flowDefNode.getBoolean("crossscore")) {
                iscross = true;
            }
            this.collmaptransferContnetAreaEntryToJson(flowdefnodeId, entry, fieldMap, (List)collmap.get(flowdefnodeId), iscross, isbatchadjust, isbatchscore);
        }
        return collmap;
    }

    private String collmaptransferScopeAreaEntryToJson(DynamicObject entry) {
        if (entry == null) {
            return "";
        }
        ScopeAreaBo scopeAreaBo = new ScopeAreaBo();
        scopeAreaBo.setScoreContentId(Long.valueOf(entry.getLong("scorecontent.id")));
        scopeAreaBo.setScoreShowAreaId(Long.valueOf(entry.getLong("scoreshowarea.id")));
        scopeAreaBo.setSeq(Integer.valueOf(entry.getInt("seq")));
        return JSON.toJSONString((Object)scopeAreaBo);
    }

    private void collmaptransferContnetAreaEntryToJson(Long flowDefNodeId, DynamicObject entry, Map<Long, Map<Long, Long>> fieldMap, List<List<String>> nodelists, boolean iscross, boolean isbatchadjust, boolean isbatchscore) {
        if (entry == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(10);
        Long areapageId = entry.getLong("areapage.id");
        if (iscross && areapageId != 1L && areapageId != 2L) {
            return;
        }
        ContentAreaBo contentArea = new ContentAreaBo();
        contentArea.setAreapageInsname(entry.getString("areapageinsname"));
        contentArea.setAreapageInsId(Long.valueOf(entry.getLong("areapageinsid")));
        contentArea.setAreapageId(Long.valueOf(entry.getLong("areapage.id")));
        contentArea.setAreaDisplay(Boolean.valueOf(entry.getBoolean("areadisplayitem")));
        contentArea.setSeq(Integer.valueOf(entry.getInt("seq")));
        contentArea.setAreaDisplaySetting(entry.getString("displaysettings"));
        if (!isbatchadjust && !isbatchscore || isbatchadjust ^ isbatchscore && areapageId != 5L) {
            contentArea.setAreaUpdateSetting(entry.getString("updatesettings"));
            contentArea.setAreaModify(Boolean.valueOf(entry.getBoolean("areamodifyitem")));
        }
        list.add(JSON.toJSONString((Object)contentArea));
        ArrayList<ContentFieldBo> fields = new ArrayList<ContentFieldBo>(entry.getDynamicObjectCollection("contentfieldentry").size());
        for (DynamicObject fieldObj : entry.getDynamicObjectCollection("contentfieldentry")) {
            ContentFieldBo fieldBo = new ContentFieldBo();
            fieldBo.setAreaFieldId(Long.valueOf(fieldObj.getLong("areafield.id")));
            Integer buttonSets = 0;
            if (fieldMap.containsKey(contentArea.getAreapageInsId()) && fieldMap.get(contentArea.getAreapageInsId()).containsKey(fieldBo.getAreaFieldId())) {
                fieldBo.setAreaFieldInsId(fieldMap.get(contentArea.getAreapageInsId()).get(fieldBo.getAreaFieldId()));
                if (!isbatchscore || areapageId != 5L) {
                    fieldBo.setButtonSets(Integer.valueOf(buttonSets | (fieldObj.getBoolean("fielddisplayitem") ? 1 : 0) | (fieldObj.getBoolean("fieldmodifyitem") ? 2 : 0) | (fieldObj.getBoolean("fieldmustinputitem") ? 4 : 0)));
                    fieldBo.setViewSets(fieldObj.getString("fielddissettings") + fieldObj.getString("fieldupsettings") + fieldObj.getString("requiredsettings"));
                } else if (AllFieldEnum.SUM_OSE.getValue().longValue() == fieldObj.getLong("areafield.id")) {
                    fieldBo.setButtonSets(Integer.valueOf(buttonSets | 7));
                    fieldBo.setViewSets("101010");
                } else {
                    fieldBo.setButtonSets(Integer.valueOf(buttonSets | 3));
                    fieldBo.setViewSets("202050");
                }
            } else {
                fieldBo.setButtonSets(Integer.valueOf(buttonSets | (fieldObj.getBoolean("fielddisplayitem") ? 1 : 0) | (fieldObj.getBoolean("fieldmodifyitem") ? 2 : 0) | (fieldObj.getBoolean("fieldmustinputitem") ? 4 : 0)));
                fieldBo.setViewSets(fieldObj.getString("fielddissettings") + fieldObj.getString("fieldupsettings") + fieldObj.getString("requiredsettings"));
                String areafieldname = fieldObj.getString("areafieldname");
                long areaFieldId = fieldObj.getLong("areafield.id");
                if (areaFieldId == AllFieldEnum.SUM_ADJUSTSCORE.getValue()) {
                    fieldBo.setAreaFieldName(ResManager.loadKDString((String)"\u8c03\u6574\u5206:PermissionSettings_1", (String)"MigrateDynPermissionConfigService_1", (String)"opmc-epa-business", (Object[])new Object[0]));
                } else if (AllFieldEnum.SUM_ADJUSTRANK.getValue() == areaFieldId) {
                    fieldBo.setAreaFieldName(ResManager.loadKDString((String)"\u603b\u7b49\u7ea7:PermissionSettings_3", (String)"MigrateDynPermissionConfigService_2", (String)"opmc-epa-business", (Object[])new Object[0]));
                } else if (AllFieldEnum.SUM_ADJUSTSDESC.getValue() == areaFieldId) {
                    fieldBo.setAreaFieldName(ResManager.loadKDString((String)"\u8c03\u6574\u8bf4\u660e:PermissionSettings_2", (String)"MigrateDynPermissionConfigService_3", (String)"opmc-epa-business", (Object[])new Object[0]));
                } else {
                    fieldBo.setAreaFieldName(areafieldname);
                }
            }
            fieldBo.setSeq(Integer.valueOf(fieldObj.getInt("seq")));
            fields.add(fieldBo);
        }
        list.add(JSON.toJSONString(fields));
        nodelists.add(list);
    }

    private void convertToCollectionWithOldPerm(DynamicObjectCollection collection, DynamicObject perfWorkflow, Map<Long, List<String>> scopeCollectionGroupByFlowNodeId, Map<Long, List<List<String>>> contentCollectionGroupByFlowNodeId) {
        perfWorkflow = flowService.loadSingle(perfWorkflow.getPkValue());
        DynamicObjectCollection flowentries = perfWorkflow.getDynamicObjectCollection("flowentry");
        Long passnodeId = 0L;
        Long procNodeId = 0L;
        for (DynamicObject flowEntry : flowentries) {
            passnodeId = flowEntry.getLong("passnode");
            DynamicObject subflow = subFlowService.loadSingle((Object)flowEntry.getLong("flowvid"));
            if (subflow.getDynamicObjectCollection("entryentity") == null) continue;
            for (DynamicObject flowProcDef : subflow.getDynamicObjectCollection("entryentity")) {
                DynamicObject flowdefproc = flowDefProcService.loadSingle((Object)flowProcDef.getLong("flowdefproc"));
                if (flowdefproc == null || flowdefproc.getDynamicObjectCollection("nodeentry").size() == 0) continue;
                for (DynamicObject procNode : flowdefproc.getDynamicObjectCollection("nodeentry")) {
                    DynamicObject dynPermitEntry;
                    procNodeId = procNode.getLong("id");
                    if (scopeCollectionGroupByFlowNodeId != null && scopeCollectionGroupByFlowNodeId.get(procNodeId) != null) {
                        for (String string : scopeCollectionGroupByFlowNodeId.get(procNodeId)) {
                            dynPermitEntry = collection.addNew();
                            dynPermitEntry.set("passnodeid", (Object)passnodeId);
                            dynPermitEntry.set("flowvid", (Object)subflow.getLong("id"));
                            dynPermitEntry.set("flowid", (Object)subflow.getLong("boid"));
                            dynPermitEntry.set("flowdefnodeid", (Object)procNodeId);
                            dynPermitEntry.set("mainconfiguration", (Object)string);
                            dynPermitEntry.set("configtype", (Object)"1");
                        }
                    }
                    if (contentCollectionGroupByFlowNodeId == null || contentCollectionGroupByFlowNodeId.get(procNodeId) == null) continue;
                    for (List list : contentCollectionGroupByFlowNodeId.get(procNodeId)) {
                        dynPermitEntry = collection.addNew();
                        dynPermitEntry.set("passnodeid", (Object)passnodeId);
                        dynPermitEntry.set("flowvid", (Object)subflow.getLong("id"));
                        dynPermitEntry.set("flowid", (Object)subflow.getLong("boid"));
                        dynPermitEntry.set("flowdefnodeid", (Object)procNodeId);
                        dynPermitEntry.set("mainconfiguration", list.get(0));
                        dynPermitEntry.set("fieldconfiguration_tag", list.get(1));
                        dynPermitEntry.set("configtype", (Object)"2");
                    }
                }
            }
        }
        if (contentCollectionGroupByFlowNodeId != null) {
            this.processCustomFlowDefNodeWithOldPerm(collection, scopeCollectionGroupByFlowNodeId, contentCollectionGroupByFlowNodeId, new Long[]{8L, 1500000000000000000L});
        }
    }

    private void processCustomFlowDefNodeWithOldPerm(DynamicObjectCollection collection, Map<Long, List<String>> scopeCollectionGroupByFlowNodeId, Map<Long, List<List<String>>> contentCollectionGroupByFlowNodeId, Long[] customNodeIds) {
        for (Long customNodeId : customNodeIds) {
            DynamicObject dynPermitEntry;
            if (scopeCollectionGroupByFlowNodeId.containsKey(customNodeId)) {
                for (String string : scopeCollectionGroupByFlowNodeId.get(customNodeId)) {
                    dynPermitEntry = collection.addNew();
                    dynPermitEntry.set("passnodeid", (Object)customNodeId);
                    dynPermitEntry.set("flowvid", (Object)0L);
                    dynPermitEntry.set("flowdefnodeid", (Object)customNodeId);
                    dynPermitEntry.set("mainconfiguration", (Object)string);
                    dynPermitEntry.set("configtype", (Object)"1");
                }
            }
            if (!contentCollectionGroupByFlowNodeId.containsKey(customNodeId)) continue;
            for (List list : contentCollectionGroupByFlowNodeId.get(customNodeId)) {
                dynPermitEntry = collection.addNew();
                dynPermitEntry.set("passnodeid", (Object)customNodeId);
                dynPermitEntry.set("flowvid", (Object)0L);
                dynPermitEntry.set("flowdefnodeid", (Object)customNodeId);
                dynPermitEntry.set("mainconfiguration", list.get(0));
                dynPermitEntry.set("fieldconfiguration_tag", list.get(1));
                dynPermitEntry.set("configtype", (Object)"2");
            }
        }
    }

    private DynamicObject generateSimpleLogObj(Long id, String name, String number) {
        DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"epa_dynpermupdaterecord");
        logObj.set("id", (Object)id);
        logObj.set("name", (Object)name);
        logObj.set("number", (Object)number);
        return logObj;
    }
}

