/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.application.service.dynpermission.presetpermission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.opmc.epa.business.application.service.dynpermission.presetpermission.MapKeyUtils;
import kd.opmc.epa.business.domain.permission.utils.PermissionAreaMap;
import kd.opmc.epa.business.domain.permission.utils.PermissionFieldMap;
import kd.opmc.epa.common.enums.per.AllFieldEnum;
import kd.opmc.epa.common.enums.per.AreaEnum;
import kd.opmc.epa.common.enums.per.ContentFieldEntityNameEnum;
import kd.opmc.epa.common.enums.per.NodeTypeEnum;
import kd.opmc.epa.common.vo.AreaCollBO;
import kd.opmc.epa.common.vo.DynamicIdVo;
import kd.opmc.epa.common.vo.EmpSumBO;
import kd.opmc.epa.common.vo.dynpermission.ContentAreaEntry;
import kd.opmc.epa.common.vo.dynpermission.ContentFieldEntry;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;

public class ContentAreaUtils {
    private static final int EMP_SEQ = 1;
    private static final int SUM_SEQ = 100;
    private static final Map<Long, Function<AreaCollBO, DynamicObject[]>> AREA_TYPE_TO_HANDLER_MAP;

    public static void processContentArea(DynamicPermissionConfigVO dynamicPermissionConfigVO, DynamicObjectCollection areColls, EmpSumBO empSumBO, Long assessNodeId, DynamicObjectCollection flownodeIds, AreaCollBO areaCollBO) {
        for (DynamicObject flowNode : flownodeIds) {
            Long nodeTypeId = flowNode.getLong("nodetype.id");
            ArrayList<ContentAreaEntry> contentAreaEntryList = new ArrayList<ContentAreaEntry>();
            ContentAreaUtils.processEmpAndSumArea(contentAreaEntryList, empSumBO, assessNodeId, nodeTypeId, flowNode.getLong("id"));
            ContentAreaUtils.processOthersArea(contentAreaEntryList, areColls, assessNodeId, areaCollBO, flowNode.getLong("id"), nodeTypeId);
            if (contentAreaEntryList.isEmpty()) continue;
            dynamicPermissionConfigVO.getContentAreaEntriesMap().put(flowNode.getLong("id"), contentAreaEntryList);
        }
    }

    public static void processEmpAndSumArea(List<ContentAreaEntry> contentAreaEntryList, EmpSumBO empSumBO, Long assessNodeId, Long nodeTypeId, Long nodeId) {
        Long[] areaTypes;
        for (Long areaType : areaTypes = new Long[]{AreaEnum.EMPINFO.getValue(), AreaEnum.SUM.getValue()}) {
            DynamicObjectCollection colls;
            String key = MapKeyUtils.getAreaCombineKey(assessNodeId, nodeTypeId, areaType, nodeId);
            if (PermissionAreaMap.getAreaDisplayMapValue(key) == null) continue;
            ContentAreaEntry contentAreaEntry = new ContentAreaEntry();
            ContentAreaUtils.setEmpOrSumContentAreaVO(areaType, empSumBO, contentAreaEntry, key);
            ArrayList<ContentFieldEntry> contentFieldEntryList = new ArrayList<ContentFieldEntry>();
            if (areaType.equals(AreaEnum.EMPINFO.getValue())) {
                colls = empSumBO.getEmpConfDynamicObject().getDynamicObjectCollection("entryentity");
                ContentAreaUtils.setEmpContentField(contentFieldEntryList, assessNodeId, colls, nodeTypeId);
            } else {
                colls = empSumBO.getSumConfDynamicObject().getDynamicObjectCollection("entryentity");
                ContentAreaUtils.setSumContentField(contentFieldEntryList, assessNodeId, colls, nodeTypeId);
            }
            contentAreaEntry.setFieldEntries(contentFieldEntryList);
            contentAreaEntryList.add(contentAreaEntry);
        }
    }

    public static void processOthersArea(List<ContentAreaEntry> contentAreaEntryList, DynamicObjectCollection areColls, Long assessNodeId, AreaCollBO areaCollBO, Long flowNodeId, Long nodeTypeId) {
        int seq = 2;
        for (DynamicObject dynamicObject : areColls) {
            long areaConfId;
            Long areaRegId = dynamicObject.getLong("areareg_id");
            String key = MapKeyUtils.getAreaCombineKey(assessNodeId, nodeTypeId, areaRegId, flowNodeId, areaCollBO, areaConfId = dynamicObject.getLong("areaconf"));
            if (PermissionAreaMap.getAreaDisplayMapValue(key) == null) continue;
            ContentAreaEntry contentAreaEntry = new ContentAreaEntry();
            contentAreaEntry.setSeq(Integer.valueOf(seq++));
            ContentAreaUtils.setAreaEntry(contentAreaEntry, dynamicObject, key);
            DynamicIdVo dynamicIdVo = new DynamicIdVo(assessNodeId, nodeTypeId, areaRegId, flowNodeId);
            List<ContentFieldEntry> contentFieldEntryList = ContentAreaUtils.setOthersFieldAreaEntry(dynamicObject, dynamicIdVo, areaCollBO, contentAreaEntry);
            contentAreaEntry.setFieldEntries(contentFieldEntryList);
            contentAreaEntryList.add(contentAreaEntry);
        }
    }

    public static void processOthersArea(List<ContentAreaEntry> contentAreaEntryList, DynamicObjectCollection areColls, Long assessNodeId, AreaCollBO areaCollBO, Long flowNodeId, Long nodeTypeId, DynamicObject perfWorkFlow) {
        int seq = 2;
        DynamicObjectCollection nodeCols = perfWorkFlow.getDynamicObjectCollection("entryentity");
        Boolean haveSummary = nodeCols.stream().filter(dy -> dy.getDynamicObject("node").getLong("id") == NodeTabMapEnum.PERF_SUM.getNodeId().longValue()).map(dy -> dy.getBoolean("isshow")).findFirst().orElse(Boolean.FALSE);
        if (haveSummary.booleanValue()) {
            seq = ContentAreaUtils.processSummaryArea(contentAreaEntryList, assessNodeId, flowNodeId, nodeTypeId, seq);
        }
        for (DynamicObject dynamicObject : areColls) {
            Long areaRegId = dynamicObject.getLong("areareg_id");
            String key = MapKeyUtils.getAreaCombineKey(assessNodeId, nodeTypeId, areaRegId, flowNodeId);
            if (PermissionAreaMap.getAreaDisplayMapValue(key) == null) continue;
            ContentAreaEntry contentAreaEntry = new ContentAreaEntry();
            contentAreaEntry.setSeq(Integer.valueOf(seq++));
            ContentAreaUtils.setAreaEntry(contentAreaEntry, dynamicObject, key);
            DynamicIdVo dynamicIdVo = new DynamicIdVo(assessNodeId, nodeTypeId, areaRegId, flowNodeId);
            List<ContentFieldEntry> contentFieldEntryList = ContentAreaUtils.setOthersFieldAreaEntry(dynamicObject, dynamicIdVo, areaCollBO, contentAreaEntry);
            contentAreaEntry.setFieldEntries(contentFieldEntryList);
            contentAreaEntryList.add(contentAreaEntry);
        }
    }

    private static int processSummaryArea(List<ContentAreaEntry> contentAreaEntryList, Long assessNodeId, Long flowNodeId, Long nodeTypeId, int seq) {
        Long areaRegId = 1960097310314606592L;
        Long areaRegpageInsId = 1960097310314606592L;
        String key = MapKeyUtils.getAreaCombineKey(assessNodeId, nodeTypeId, areaRegId, flowNodeId);
        if (PermissionAreaMap.getAreaDisplayMapValue(key) != null) {
            String areaName = ResManager.loadKDString((String)"\u6c47\u603b\u4fe1\u606f\u533a", (String)"ContentAreaUtils_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            ContentAreaEntry contentAreaEntry = new ContentAreaEntry();
            contentAreaEntry.setSeq(Integer.valueOf(seq++));
            contentAreaEntry.setAreapageId(areaRegId);
            contentAreaEntry.setAreapageInsId(areaRegpageInsId);
            contentAreaEntry.setAreapageInsname(areaName);
            contentAreaEntry.setAreaDisplay(PermissionAreaMap.getAreaDisplay(key));
            contentAreaEntry.setAreaModify(PermissionAreaMap.getAreaUpdate(key));
            contentAreaEntry.setAreaDisplaySetting(PermissionAreaMap.getAreaDisplayMapValue(key));
            contentAreaEntry.setAreaUpdateSetting(PermissionAreaMap.getAreaUpdateMapValue(key));
            contentAreaEntry.setFieldEntries(new ArrayList(10));
            contentAreaEntryList.add(contentAreaEntry);
        }
        return seq;
    }

    public static List<ContentAreaEntry> processSummaryResultAndCompleteContentArea(Long assessNodeId, DynamicObject perfWorkFlow) {
        ArrayList<ContentAreaEntry> contentAreaEntryList = new ArrayList<ContentAreaEntry>();
        ContentAreaUtils.processSummaryArea(contentAreaEntryList, assessNodeId, 0L, 0L, 1);
        return contentAreaEntryList;
    }

    public static List<ContentAreaEntry> processResultAndCompleteContentArea(DynamicObjectCollection areColls, EmpSumBO empSumBO, Long assessNodeId, AreaCollBO areaCollBO, DynamicObject perfWorkFlow) {
        ArrayList<ContentAreaEntry> contentAreaEntryList = new ArrayList<ContentAreaEntry>();
        ContentAreaUtils.processEmpAndSumArea(contentAreaEntryList, empSumBO, assessNodeId, 0L, 0L);
        ContentAreaUtils.processOthersArea(contentAreaEntryList, areColls, assessNodeId, areaCollBO, 0L, 0L, perfWorkFlow);
        return contentAreaEntryList;
    }

    private static void setAreaEntry(ContentAreaEntry contentAreaEntry, DynamicObject dynamicObject, String key) {
        contentAreaEntry.setAreapageId(Long.valueOf(dynamicObject.getLong("areareg_id")));
        contentAreaEntry.setAreapageInsId(Long.valueOf(dynamicObject.getLong("areaconf")));
        contentAreaEntry.setAreaDisplay(PermissionAreaMap.getAreaDisplay(key));
        contentAreaEntry.setAreaModify(PermissionAreaMap.getAreaUpdate(key));
        contentAreaEntry.setAreaDisplaySetting(PermissionAreaMap.getAreaDisplayMapValue(key));
        contentAreaEntry.setAreaUpdateSetting(PermissionAreaMap.getAreaUpdateMapValue(key));
    }

    private static List<ContentFieldEntry> setOthersFieldAreaEntry(DynamicObject dynamicObject, DynamicIdVo dynamicIdVo, AreaCollBO areaCollBO, ContentAreaEntry contentAreaEntry) {
        ArrayList<ContentFieldEntry> contentFieldEntryList = new ArrayList<ContentFieldEntry>();
        Function<AreaCollBO, DynamicObject[]> handler = AREA_TYPE_TO_HANDLER_MAP.get(dynamicIdVo.getAreaRegId());
        if (handler == null) {
            return contentFieldEntryList;
        }
        DynamicObject[] dynamicObjects = handler.apply(areaCollBO);
        long areaConf = dynamicObject.getLong("areaconf");
        DynamicObject conf = Arrays.stream(dynamicObjects).filter(obj -> obj.getLong("id") == areaConf).findFirst().orElse(null);
        if (conf == null) {
            return contentFieldEntryList;
        }
        DynamicObjectCollection dynamicObjectCollection = conf.getDynamicObjectCollection("entryentity");
        contentAreaEntry.setAreapageInsname(conf.getString("areacustname"));
        String entityName = ContentFieldEntityNameEnum.fromAreaRegId((Long)dynamicIdVo.getAreaRegId());
        for (DynamicObject entry : dynamicObjectCollection) {
            Long areaField = entry.getLong("areafield.id");
            String fieldKey = MapKeyUtils.getFieldCombineKey(dynamicIdVo.getAssessNodeId(), dynamicIdVo.getNodeTypeId(), areaField, dynamicIdVo.getFlowNodeId());
            if (PermissionFieldMap.getAreaDisplayMapValue(fieldKey) == null) continue;
            ContentFieldEntry contentFieldEntry = new ContentFieldEntry();
            contentFieldEntry.setAreaFieldId(areaField);
            contentFieldEntry.setEntityName(entityName);
            ContentAreaUtils.setContentFieldEntry(contentFieldEntryList, entry, fieldKey, contentFieldEntry);
        }
        return contentFieldEntryList;
    }

    private static void setEmpOrSumContentAreaVO(Long areaPageId, EmpSumBO empSumBO, ContentAreaEntry contentAreaEntry, String key) {
        contentAreaEntry.setAreapageId(areaPageId);
        if (AreaEnum.EMPINFO.getValue().equals(areaPageId)) {
            contentAreaEntry.setAreapageInsId(Long.valueOf(empSumBO.getEmpConfDynamicObject().getLong("id")));
            contentAreaEntry.setAreapageInsname(empSumBO.getEmpDynamicObject().getString("name"));
            contentAreaEntry.setSeq(Integer.valueOf(1));
        } else {
            contentAreaEntry.setAreapageInsId(Long.valueOf(empSumBO.getSumConfDynamicObject().getLong("id")));
            contentAreaEntry.setAreapageInsname(empSumBO.getSumConfDynamicObject().getString("areacustname"));
            contentAreaEntry.setSeq(Integer.valueOf(100));
        }
        contentAreaEntry.setAreaDisplay(PermissionAreaMap.getAreaDisplay(key));
        contentAreaEntry.setAreaModify(PermissionAreaMap.getAreaUpdate(key));
        contentAreaEntry.setAreaDisplaySetting(PermissionAreaMap.getAreaDisplayMapValue(key));
        contentAreaEntry.setAreaUpdateSetting(PermissionAreaMap.getAreaUpdateMapValue(key));
    }

    private static void setEmpContentField(List<ContentFieldEntry> contentFieldEntryList, Long assessNodeId, DynamicObjectCollection empInfoColls, Long nodeTypeId) {
        for (DynamicObject empDynamicObject : empInfoColls) {
            if (!empDynamicObject.getBoolean("isshow")) continue;
            Long areaField = empDynamicObject.getLong("areafield.id");
            ContentAreaUtils.processEmpOrSumFieldList(contentFieldEntryList, assessNodeId, empDynamicObject, nodeTypeId, areaField, AreaEnum.EMPINFO.getValue());
        }
    }

    private static void setSumContentField(List<ContentFieldEntry> contentFieldEntryList, Long assessNodeId, DynamicObjectCollection sumConfDynamicObjectCollection, Long nodeTypeId) {
        for (DynamicObject sumDynamicObject : sumConfDynamicObjectCollection) {
            Long areaField = sumDynamicObject.getLong("areafield.id");
            if (!NodeTypeEnum.BATCH_ADJUST.getValue().equals(nodeTypeId) && !sumDynamicObject.getBoolean("isshow") || AllFieldEnum.SUM_ADJUSTSCORE.getValue().equals(areaField) || AllFieldEnum.SUM_ADJUSTRANK.getValue().equals(areaField) || AllFieldEnum.SUM_ADJUSTSDESC.getValue().equals(areaField)) continue;
            ContentAreaUtils.processEmpOrSumFieldList(contentFieldEntryList, assessNodeId, sumDynamicObject, nodeTypeId, areaField, AreaEnum.SUM.getValue());
        }
    }

    private static void processEmpOrSumFieldList(List<ContentFieldEntry> contentFieldEntryList, Long assessNodeId, DynamicObject dynamicObject, Long nodeTypeId, Long areaField, Long areaId) {
        String fieldKey = MapKeyUtils.getFieldCombineKey(assessNodeId, nodeTypeId, areaField, 0L);
        if (PermissionFieldMap.getAreaDisplayMapValue(fieldKey) != null) {
            ContentFieldEntry contentFieldEntry = new ContentFieldEntry();
            if (NodeTypeEnum.BATCH_ADJUST.getValue().equals(nodeTypeId) && AllFieldEnum.SUM_OSE.getValue().equals(areaField)) {
                contentFieldEntry.setAreaFieldId(AllFieldEnum.SUM_ADJUSTSCORE.getValue());
                StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"\u8c03\u6574\u5206", (String)"ContentAreaUtils_1", (String)"opmc-epa-business", (Object[])new Object[0]));
                contentFieldEntry.setAreaFieldName(builder.append(":PermissionSettings_1").toString());
            } else if (NodeTypeEnum.BATCH_ADJUST.getValue().equals(nodeTypeId) && AllFieldEnum.SUM_EVAL.getValue().equals(areaField)) {
                contentFieldEntry.setAreaFieldId(AllFieldEnum.SUM_ADJUSTSDESC.getValue());
                StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"\u8c03\u6574\u8bf4\u660e", (String)"ContentAreaUtils_2", (String)"opmc-epa-business", (Object[])new Object[0]));
                contentFieldEntry.setAreaFieldName(builder.append(":PermissionSettings_2").toString());
            } else if (NodeTypeEnum.BATCH_ADJUST.getValue().equals(nodeTypeId) && AllFieldEnum.SUM_OLE.getValue().equals(areaField)) {
                contentFieldEntry.setAreaFieldId(AllFieldEnum.SUM_ADJUSTRANK.getValue());
                StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"\u603b\u7b49\u7ea7", (String)"ContentAreaUtils_3", (String)"opmc-epa-business", (Object[])new Object[0]));
                contentFieldEntry.setAreaFieldName(builder.append(":PermissionSettings_3").toString());
            } else {
                contentFieldEntry.setAreaFieldId(areaField);
                if (areaId.equals(AreaEnum.SUM.getValue())) {
                    contentFieldEntry.setEntityName(ContentFieldEntityNameEnum.SUM.getValue());
                } else {
                    contentFieldEntry.setEntityName(ContentFieldEntityNameEnum.EMP.getValue());
                }
            }
            ContentAreaUtils.setContentFieldEntry(contentFieldEntryList, dynamicObject, fieldKey, contentFieldEntry);
        }
    }

    private static void setContentFieldEntry(List<ContentFieldEntry> contentFieldEntryList, DynamicObject dynamicObject, String fieldKey, ContentFieldEntry contentFieldEntry) {
        contentFieldEntry.setAreaFieldId(Long.valueOf(dynamicObject.getLong("areafield.id")));
        contentFieldEntry.setAreaFieldInsId(Long.valueOf(dynamicObject.getLong("id")));
        contentFieldEntry.setFieldDisplay(PermissionFieldMap.getAreaDisplay(fieldKey));
        contentFieldEntry.setFieldModify(PermissionFieldMap.getAreaUpdate(fieldKey));
        contentFieldEntry.setFieldMustInput(PermissionFieldMap.getAreaRequired(fieldKey));
        contentFieldEntry.setFieldDisplaySetting(PermissionFieldMap.getAreaDisplayMapValue(fieldKey));
        contentFieldEntry.setFieldUpdateSetting(PermissionFieldMap.getAreaUpdateMapValue(fieldKey));
        contentFieldEntry.setFieldRequiredSetting(PermissionFieldMap.getAreaRequiredMapValue(fieldKey));
        contentFieldEntry.setSeq(Integer.valueOf(contentFieldEntryList.size() + 1));
        contentFieldEntryList.add(contentFieldEntry);
    }

    public static void processEmpAndSumAreaExcludeSummary(List<ContentAreaEntry> contentAreaEntryList, EmpSumBO empSumBO, Long assessNodeId, Long nodeTypeId, Long nodeId) {
        Long[] areaTypes;
        for (Long areaType : areaTypes = new Long[]{AreaEnum.EMPINFO.getValue(), AreaEnum.SUM.getValue()}) {
            DynamicObjectCollection colls;
            String key = MapKeyUtils.getAreaCombineKey(assessNodeId, nodeTypeId, areaType, nodeId);
            if (PermissionAreaMap.getAreaDisplayMapValue(key) == null) continue;
            ContentAreaEntry contentAreaEntry = new ContentAreaEntry();
            ContentAreaUtils.setEmpOrSumContentAreaVO(areaType, empSumBO, contentAreaEntry, key);
            ArrayList<ContentFieldEntry> contentFieldEntryList = new ArrayList<ContentFieldEntry>();
            if (areaType.equals(AreaEnum.EMPINFO.getValue())) {
                colls = empSumBO.getEmpConfDynamicObject().getDynamicObjectCollection("entryentity");
                ContentAreaUtils.setEmpContentField(contentFieldEntryList, assessNodeId, colls, nodeTypeId);
            } else {
                colls = empSumBO.getSumConfDynamicObject().getDynamicObjectCollection("entryentity");
                ContentAreaUtils.setSumContentField(contentFieldEntryList, assessNodeId, colls, nodeTypeId);
            }
            contentAreaEntry.setFieldEntries(contentFieldEntryList);
            contentAreaEntryList.add(contentAreaEntry);
        }
    }

    public static void processOthersAreaExcludeSummary(List<ContentAreaEntry> contentAreaEntryList, DynamicObjectCollection areColls, Long assessNodeId, AreaCollBO areaCollBO, Long flowNodeId, Long nodeTypeId) {
        int seq = 3;
        for (DynamicObject dynamicObject : areColls) {
            long areaConfId;
            Long areaRegId = dynamicObject.getLong("areareg_id");
            String key = MapKeyUtils.getAreaCombineKey(assessNodeId, nodeTypeId, areaRegId, flowNodeId, areaCollBO, areaConfId = dynamicObject.getLong("areaconf"));
            if (PermissionAreaMap.getAreaDisplayMapValue(key) == null) continue;
            ContentAreaEntry contentAreaEntry = new ContentAreaEntry();
            contentAreaEntry.setSeq(Integer.valueOf(seq++));
            ContentAreaUtils.setAreaEntry(contentAreaEntry, dynamicObject, key);
            DynamicIdVo dynamicIdVo = new DynamicIdVo(assessNodeId, nodeTypeId, areaRegId, flowNodeId);
            List<ContentFieldEntry> contentFieldEntryList = ContentAreaUtils.setOthersFieldAreaEntry(dynamicObject, dynamicIdVo, areaCollBO, contentAreaEntry);
            contentAreaEntry.setFieldEntries(contentFieldEntryList);
            contentAreaEntryList.add(contentAreaEntry);
        }
    }

    static {
        HashMap<Long, Function<AreaCollBO, DynamicObject[]>> map = new HashMap<Long, Function<AreaCollBO, DynamicObject[]>>();
        map.put(AreaEnum.NORMINDCTR.getValue(), AreaCollBO::getNormalCollection);
        map.put(AreaEnum.PLUSMINUS.getValue(), AreaCollBO::getPlusCollection);
        map.put(AreaEnum.ATTACH.getValue(), AreaCollBO::getAttachCollection);
        map.put(AreaEnum.CUSTOM.getValue(), AreaCollBO::getCustomCollection);
        AREA_TYPE_TO_HANDLER_MAP = Collections.unmodifiableMap(map);
    }
}

