/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.application.service.dynpermission.presetpermission;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.opmc.epa.common.enums.per.AllFieldEnum;
import kd.opmc.epa.common.enums.per.NodeParameterEnum;
import kd.opmc.epa.common.enums.per.NodeTypeEnum;
import kd.opmc.epa.common.enums.per.PassessNodeEnum;
import kd.opmc.epa.common.vo.AreaCollBO;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefRoleEntityService;

public class MapKeyUtils {
    private static final FlowDefRoleEntityService FLOW_DEF_ROLE_ENTITY_SERVICE = FlowDefRoleEntityService.getInstance();
    private static final FlowDefNodeEntityService FLOW_DEF_NODE_ENTITY_SERVICE = FlowDefNodeEntityService.getInstance();

    public static String getShowAreaCombineKey(Long activityId, Long nodeTypeId, Long scoreContentId, Long flowNodeId) {
        return MapKeyUtils.getCombineKey(activityId, nodeTypeId, scoreContentId, flowNodeId);
    }

    public static String getAreaCombineKey(Long activityId, Long nodeTypeId, Long areaRegId, Long flowNodeId, AreaCollBO areaCollBo, long areaConfId) {
        return MapKeyUtils.getCombineKey(activityId, nodeTypeId, areaRegId, flowNodeId, areaCollBo, areaConfId);
    }

    public static String getAreaCombineKey(Long activityId, Long nodeTypeId, Long areaRegId, Long flowNodeId) {
        return MapKeyUtils.getCombineKey(activityId, nodeTypeId, areaRegId, flowNodeId);
    }

    public static String getFieldCombineKey(Long activityId, Long nodeTypeId, Long fieldId, Long flowNodeId) {
        return MapKeyUtils.getCombineKey(activityId, nodeTypeId, fieldId, flowNodeId);
    }

    private static String getCombineKey(Long activityId, Long nodeTypeId, Long fieldId, Long flowNodeId) {
        StringBuilder stringBuilder = new StringBuilder();
        String returnData = "";
        returnData = PassessNodeEnum.RESULT_CONFIRMATION.getValue().equals(activityId) ? stringBuilder.append(activityId).append("-").append(0).append("-").append(NodeParameterEnum.EMPLOYEE_CONFIRMATION.getValue()).append("-").append(fieldId).toString() : (PassessNodeEnum.COMPLETE_CHECK.getValue().equals(activityId) ? stringBuilder.append(activityId).append("-").append(0).append("-").append(NodeParameterEnum.FINISH_EVALUATION.getValue()).append("-").append(fieldId).toString() : (PassessNodeEnum.INDICATOR_DEVELOPMENT.getValue().equals(activityId) ? MapKeyUtils.getIndicatorDevelopmentKey(activityId, nodeTypeId, fieldId, flowNodeId, stringBuilder) : (PassessNodeEnum.PERFORMANCE_EVALUATION.getValue().equals(activityId) ? MapKeyUtils.getPerformaceEvaluationKey(activityId, nodeTypeId, fieldId, stringBuilder, flowNodeId) : stringBuilder.append(activityId).append("-").append(nodeTypeId).append("-").append(NodeParameterEnum.DEFAULT.getValue()).append("-").append(fieldId).toString())));
        return returnData;
    }

    private static String getCombineKey(Long activityId, Long nodeTypeId, Long fieldId, Long flowNodeId, AreaCollBO areaCollBo, long areaConfId) {
        StringBuilder stringBuilder = new StringBuilder();
        String returnData = "";
        returnData = PassessNodeEnum.RESULT_CONFIRMATION.getValue().equals(activityId) ? stringBuilder.append(activityId).append("-").append(0).append("-").append(NodeParameterEnum.EMPLOYEE_CONFIRMATION.getValue()).append("-").append(fieldId).toString() : (PassessNodeEnum.COMPLETE_CHECK.getValue().equals(activityId) ? stringBuilder.append(activityId).append("-").append(0).append("-").append(NodeParameterEnum.FINISH_EVALUATION.getValue()).append("-").append(fieldId).toString() : (PassessNodeEnum.INDICATOR_DEVELOPMENT.getValue().equals(activityId) ? MapKeyUtils.getIndicatorDevelopmentKey(activityId, nodeTypeId, fieldId, flowNodeId, stringBuilder) : (PassessNodeEnum.PERFORMANCE_EVALUATION.getValue().equals(activityId) ? MapKeyUtils.getPerformanceEvaluationKey(activityId, nodeTypeId, fieldId, stringBuilder, flowNodeId, areaCollBo, areaConfId) : stringBuilder.append(activityId).append("-").append(nodeTypeId).append("-").append(NodeParameterEnum.DEFAULT.getValue()).append("-").append(fieldId).toString())));
        return returnData;
    }

    private static String getPerformanceEvaluationKey(Long activityId, Long nodeTypeId, Long fieldId, StringBuilder stringBuilder, Long flowNodeId, AreaCollBO areaCollBO, long areaConfId) {
        String returnData = "";
        String nodeParameter = NodeParameterEnum.DEFAULT.getValue();
        if (NodeTypeEnum.EVALUATION.getValue().equals(nodeTypeId)) {
            DynamicObject flowDefNode = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(flowNodeId);
            if (flowDefNode != null && flowDefNode.getBoolean("crossscore")) {
                nodeParameter = NodeParameterEnum.CROSS_VALIDATION.getValue();
                Map<Long, DynamicObject> plusMinusIdDynObjMap = Arrays.stream(areaCollBO.getPlusCollection()).collect(Collectors.toMap(plusMinusDynObj -> plusMinusDynObj.getLong("id"), plusMinusDynObj -> plusMinusDynObj));
                DynamicObject plusMinusDynObj2 = plusMinusIdDynObjMap.get(areaConfId);
                if (plusMinusDynObj2 != null && !plusMinusDynObj2.getBoolean("iscrossscore")) {
                    nodeParameter = "";
                }
            }
        } else if (NodeTypeEnum.BATCH_ADJUST.getValue().equals(nodeTypeId)) {
            if (AllFieldEnum.SUM_OSE.getValue().equals(fieldId)) {
                fieldId = AllFieldEnum.SUM_ADJUSTSCORE.getValue();
            }
            if (AllFieldEnum.SUM_OLE.getValue().equals(fieldId)) {
                fieldId = AllFieldEnum.SUM_ADJUSTRANK.getValue();
            }
            if (AllFieldEnum.SUM_EVAL.getValue().equals(fieldId)) {
                fieldId = AllFieldEnum.SUM_ADJUSTSDESC.getValue();
            }
        }
        returnData = stringBuilder.append(activityId).append("-").append(nodeTypeId).append("-").append(nodeParameter).append("-").append(fieldId).toString();
        return returnData;
    }

    private static String getPerformaceEvaluationKey(Long activityId, Long nodeTypeId, Long fieldId, StringBuilder stringBuilder, Long flowNodeId) {
        String returnData = "";
        String nodeParamter = NodeParameterEnum.DEFAULT.getValue();
        if (NodeTypeEnum.EVALUATION.getValue().equals(nodeTypeId)) {
            DynamicObject flowDefNode = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(flowNodeId);
            if (flowDefNode != null && flowDefNode.getBoolean("crossscore")) {
                nodeParamter = NodeParameterEnum.CROSS_VALIDATION.getValue();
            }
        } else if (NodeTypeEnum.BATCH_ADJUST.getValue().equals(nodeTypeId)) {
            if (AllFieldEnum.SUM_OSE.getValue().equals(fieldId)) {
                fieldId = AllFieldEnum.SUM_ADJUSTSCORE.getValue();
            }
            if (AllFieldEnum.SUM_OLE.getValue().equals(fieldId)) {
                fieldId = AllFieldEnum.SUM_ADJUSTRANK.getValue();
            }
            if (AllFieldEnum.SUM_EVAL.getValue().equals(fieldId)) {
                fieldId = AllFieldEnum.SUM_ADJUSTSDESC.getValue();
            }
        }
        returnData = stringBuilder.append(activityId).append("-").append(nodeTypeId).append("-").append(nodeParamter).append("-").append(fieldId).toString();
        return returnData;
    }

    private static String getIndicatorDevelopmentKey(Long activityId, Long nodeTypeId, Long fieldId, Long flowNodeId, StringBuilder stringBuilder) {
        String returnData = "";
        String nodeParameter = NodeParameterEnum.DEFAULT.getValue();
        if (NodeTypeEnum.AUDIT_FORMULATE.getValue().equals(nodeTypeId)) {
            DynamicObject[] defRoleByDefNodeId = FLOW_DEF_ROLE_ENTITY_SERVICE.getDefRoleByDefNodeId(flowNodeId);
            nodeParameter = defRoleByDefNodeId != null && defRoleByDefNodeId.length > 0 && defRoleByDefNodeId[0].getBoolean("reviewercanedit") ? NodeParameterEnum.APPROVER_CAN_EDIT.getValue() : NodeParameterEnum.APPROVER_CAN_NOT_EDIT.getValue();
        }
        returnData = stringBuilder.append(activityId).append("-").append(nodeTypeId).append("-").append(nodeParameter).append("-").append(fieldId).toString();
        return returnData;
    }
}

