/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.application.service.dynpermission.presetpermission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.opmc.epa.business.application.service.dynpermission.presetpermission.ContentAreaUtils;
import kd.opmc.epa.business.application.service.dynpermission.presetpermission.PresetUtils;
import kd.opmc.epa.business.application.service.dynpermission.presetpermission.ScopeAreaUtils;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.common.enums.per.PassessNodeEnum;
import kd.opmc.epa.common.vo.AreaCollBO;
import kd.opmc.epa.common.vo.EmpSumBO;
import kd.opmc.epa.common.vo.dynpermission.ContentAreaEntry;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.epa.common.vo.dynpermission.ScopeAreaEntry;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import org.apache.commons.lang3.RandomStringUtils;

public class PresetPermissionUtils {
    private static final AssessFormDomainService ASSESS_FORM_DOMAIN_SERVICE = AssessFormDomainService.getInstance();
    private static final FlowDefProcDomainService FLOWDEFPROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();

    private PresetPermissionUtils() {
    }

    public static DynamicPermissionConfigVO setDynamicPermissionConfigVO(DynamicObject executeScheme, Long perfWorkFlowId, Long assessFormId) {
        DynamicObject perfWorkflow = BusinessDataServiceHelper.loadSingle((Object)perfWorkFlowId, (String)"epa_perfworkflow");
        return PresetPermissionUtils.getDynamicPermissionConfigVO(executeScheme, perfWorkflow, assessFormId);
    }

    public static DynamicPermissionConfigVO setDynamicPermissionConfigVO(DynamicObject executeScheme) {
        Long perfWorkFlowId = executeScheme.get("perfworkflow") instanceof Long ? executeScheme.getLong("perfworkflow") : executeScheme.getLong("perfworkflow.id");
        DynamicObject perfWorkflow = BusinessDataServiceHelper.loadSingle((Object)perfWorkFlowId, (String)"epa_perfworkflow");
        Long assessFormId = executeScheme.get("assessform") instanceof Long ? executeScheme.getLong("assessform") : executeScheme.getLong("assessform.id");
        return PresetPermissionUtils.getDynamicPermissionConfigVO(executeScheme, perfWorkflow, assessFormId);
    }

    private static DynamicPermissionConfigVO getDynamicPermissionConfigVO(DynamicObject executeScheme, DynamicObject perfWorkflow, Long assessFormId) {
        DynamicPermissionConfigVO dynamicPermissionConfigVO = new DynamicPermissionConfigVO();
        dynamicPermissionConfigVO.setPerfWorkflow(perfWorkflow);
        HashMap scopeAreaEntriesMap = new HashMap(16);
        HashMap contentAreaEntriesMap = new HashMap(16);
        dynamicPermissionConfigVO.setExcuteScheme(executeScheme);
        dynamicPermissionConfigVO.setPermissionName(executeScheme.getString("name"));
        dynamicPermissionConfigVO.setPermissionNumber(executeScheme.getString("id") + "-" + "1" + "-" + RandomStringUtils.randomAlphanumeric((int)6));
        if (assessFormId != 0L) {
            DynamicObject assessForm = BusinessDataServiceHelper.loadSingle((Object)assessFormId, (String)"epa_assessform");
            dynamicPermissionConfigVO.setAssessForm(assessForm);
        }
        dynamicPermissionConfigVO.setScopeAreaEntriesMap(scopeAreaEntriesMap);
        dynamicPermissionConfigVO.setContentAreaEntriesMap(contentAreaEntriesMap);
        DynamicObjectCollection flowEntries = perfWorkflow.getDynamicObjectCollection("flowentry");
        Long resultConfirmationCount = perfWorkflow.getDynamicObjectCollection("entryentity").stream().filter(dynamicObject -> PassessNodeEnum.RESULT_CONFIRMATION.getValue().equals(dynamicObject.getLong("node.id"))).filter(dynamicObject -> dynamicObject.getBoolean("isshow")).count();
        Boolean haveTarOrEval = perfWorkflow.getDynamicObjectCollection("entryentity").stream().filter(dy -> dy.getDynamicObject("node").getLong("id") == NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId().longValue()).map(dy -> dy.getBoolean("isshow")).findFirst().orElse(Boolean.FALSE);
        if (haveTarOrEval.booleanValue()) {
            PresetPermissionUtils.setScopeAreaEntriesMap(dynamicPermissionConfigVO, assessFormId, flowEntries, resultConfirmationCount);
            PresetPermissionUtils.setFieldAreaEntriesMap(dynamicPermissionConfigVO, assessFormId, flowEntries, resultConfirmationCount);
        } else {
            PresetPermissionUtils.setSummaryFieldAreaEntriesMap(dynamicPermissionConfigVO, resultConfirmationCount);
        }
        return dynamicPermissionConfigVO;
    }

    private static void setSummaryFieldAreaEntriesMap(DynamicPermissionConfigVO dynamicPermissionConfigVO, Long resultConfirmationCount) {
        List<ContentAreaEntry> contentAreaEntryList;
        if (resultConfirmationCount > 0L && !(contentAreaEntryList = ContentAreaUtils.processSummaryResultAndCompleteContentArea(PassessNodeEnum.RESULT_CONFIRMATION.getValue(), dynamicPermissionConfigVO.getPerfWorkflow())).isEmpty()) {
            dynamicPermissionConfigVO.getContentAreaEntriesMap().put(PassessNodeEnum.RESULT_CONFIRMATION.getValue(), contentAreaEntryList);
        }
        if (!(contentAreaEntryList = ContentAreaUtils.processSummaryResultAndCompleteContentArea(PassessNodeEnum.COMPLETE_CHECK.getValue(), dynamicPermissionConfigVO.getPerfWorkflow())).isEmpty()) {
            dynamicPermissionConfigVO.getContentAreaEntriesMap().put(PassessNodeEnum.COMPLETE_CHECK.getValue(), contentAreaEntryList);
        }
    }

    private static void setScopeAreaEntriesMap(DynamicPermissionConfigVO dynamicPermissionConfigVO, Long assessFormId, DynamicObjectCollection flowEntries, Long resultConfirmationCount) {
        List<ScopeAreaEntry> list;
        DynamicObject areaForm = ASSESS_FORM_DOMAIN_SERVICE.queryScoreSystemByAssessForm(assessFormId);
        DynamicObjectCollection areColls = areaForm.getDynamicObjectCollection("areaconfentry");
        AreaCollBO areaCollBO = PresetUtils.getAreaCollBo(areColls);
        DynamicObject empAndSumForm = ASSESS_FORM_DOMAIN_SERVICE.queryAssessForm(assessFormId);
        EmpSumBO empSumBO = PresetUtils.setEmpAndSum(empAndSumForm);
        Set<Long> areaFieldNameSet = PresetUtils.getAreaFieldNameSet(areColls, empSumBO, areaCollBO);
        for (DynamicObject entry : flowEntries) {
            Long assessNodeId = entry.getLong("passnode");
            Long workflowId = entry.getLong("flowvid");
            DynamicObjectCollection allNodeDefByWorkflowIds = FLOWDEFPROC_DOMAIN_SERVICE.getAllNodeDefByWorkflowId(workflowId);
            ScopeAreaUtils.processScopeAreaEntry(areaFieldNameSet, assessNodeId, allNodeDefByWorkflowIds, dynamicPermissionConfigVO);
        }
        if (resultConfirmationCount > 0L && !(list = ScopeAreaUtils.processResultAndCompleteAreaEntry(areaFieldNameSet, PassessNodeEnum.RESULT_CONFIRMATION.getValue())).isEmpty()) {
            dynamicPermissionConfigVO.getScopeAreaEntriesMap().put(PassessNodeEnum.RESULT_CONFIRMATION.getValue(), list);
        }
        if (!(list = ScopeAreaUtils.processResultAndCompleteAreaEntry(areaFieldNameSet, PassessNodeEnum.COMPLETE_CHECK.getValue())).isEmpty()) {
            dynamicPermissionConfigVO.getScopeAreaEntriesMap().put(PassessNodeEnum.COMPLETE_CHECK.getValue(), list);
        }
    }

    private static void setFieldAreaEntriesMap(DynamicPermissionConfigVO dynamicPermissionConfigVO, Long assessFormId, DynamicObjectCollection flowEntries, Long resultConfirmationCount) {
        List<ContentAreaEntry> contentAreaEntryList;
        DynamicObject areaForm = ASSESS_FORM_DOMAIN_SERVICE.queryScoreSystemByAssessForm(assessFormId);
        DynamicObjectCollection areColls = areaForm.getDynamicObjectCollection("areaconfentry");
        AreaCollBO areaCollBO = PresetUtils.getAreaCollBo(areColls);
        DynamicObject empAndSumForm = ASSESS_FORM_DOMAIN_SERVICE.queryAssessForm(assessFormId);
        EmpSumBO empSumBO = PresetUtils.setEmpAndSum(empAndSumForm);
        for (DynamicObject entry : flowEntries) {
            Long assessNodeId = entry.getLong("passnode");
            Long workflowId = entry.getLong("flowvid");
            DynamicObjectCollection allNodeDefByWorkflowIds = FLOWDEFPROC_DOMAIN_SERVICE.getAllNodeDefByWorkflowId(workflowId);
            ContentAreaUtils.processContentArea(dynamicPermissionConfigVO, areColls, empSumBO, assessNodeId, allNodeDefByWorkflowIds, areaCollBO);
        }
        if (resultConfirmationCount > 0L && !(contentAreaEntryList = ContentAreaUtils.processResultAndCompleteContentArea(areColls, empSumBO, PassessNodeEnum.RESULT_CONFIRMATION.getValue(), areaCollBO, dynamicPermissionConfigVO.getPerfWorkflow())).isEmpty()) {
            dynamicPermissionConfigVO.getContentAreaEntriesMap().put(PassessNodeEnum.RESULT_CONFIRMATION.getValue(), contentAreaEntryList);
        }
        if (!(contentAreaEntryList = ContentAreaUtils.processResultAndCompleteContentArea(areColls, empSumBO, PassessNodeEnum.COMPLETE_CHECK.getValue(), areaCollBO, dynamicPermissionConfigVO.getPerfWorkflow())).isEmpty()) {
            dynamicPermissionConfigVO.getContentAreaEntriesMap().put(PassessNodeEnum.COMPLETE_CHECK.getValue(), contentAreaEntryList);
        }
    }

    public static List<ContentAreaEntry> processResultAndCompleteContentAreaExcludeSummary(DynamicPermissionConfigVO dynamicPermissionConfigVO, Long assessFormId, Long assessNodeId) {
        Set<Long> areaFieldNameSet;
        List<ScopeAreaEntry> list;
        ArrayList<ContentAreaEntry> contentAreaEntryList = new ArrayList<ContentAreaEntry>();
        DynamicObject areaForm = ASSESS_FORM_DOMAIN_SERVICE.queryScoreSystemByAssessForm(assessFormId);
        DynamicObjectCollection areColls = areaForm.getDynamicObjectCollection("areaconfentry");
        AreaCollBO areaCollBO = PresetUtils.getAreaCollBo(areColls);
        DynamicObject empAndSumForm = ASSESS_FORM_DOMAIN_SERVICE.queryAssessForm(assessFormId);
        EmpSumBO empSumBO = PresetUtils.setEmpAndSum(empAndSumForm);
        ContentAreaUtils.processEmpAndSumAreaExcludeSummary(contentAreaEntryList, empSumBO, assessNodeId, 0L, 0L);
        ContentAreaUtils.processOthersAreaExcludeSummary(contentAreaEntryList, areColls, assessNodeId, areaCollBO, 0L, 0L);
        if (!(dynamicPermissionConfigVO.getScopeAreaEntriesMap().containsKey(assessNodeId) && dynamicPermissionConfigVO.getScopeAreaEntriesMap().get(assessNodeId) != null && ((List)dynamicPermissionConfigVO.getScopeAreaEntriesMap().get(assessNodeId)).size() >= 1 || (list = ScopeAreaUtils.processResultAndCompleteAreaEntry(areaFieldNameSet = PresetUtils.getAreaFieldNameSet(areColls, empSumBO, areaCollBO), assessNodeId)).isEmpty())) {
            dynamicPermissionConfigVO.getScopeAreaEntriesMap().put(assessNodeId, list);
        }
        return contentAreaEntryList;
    }
}

