/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.application.service.dynpermission.presetpermission;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.opmc.epa.business.domain.assessrule.entityservice.AreaRegEntityService;
import kd.opmc.epa.common.enums.per.AreaEnum;
import kd.opmc.epa.common.enums.per.FieldEnum;
import kd.opmc.epa.common.enums.per.ScoreContentEnum;
import kd.opmc.epa.common.vo.AreaCollBO;
import kd.opmc.epa.common.vo.EmpSumBO;

public class PresetUtils {
    private static final AreaRegEntityService AREA_REGENTITY_SERVICE = AreaRegEntityService.getInstance();

    public static AreaCollBO getAreaCollBo(DynamicObjectCollection areColls) {
        List normalIdList = areColls.stream().filter(dynamicObject -> dynamicObject.getLong("areareg_id") == AreaEnum.NORMINDCTR.getValue().longValue()).map(dynamicObject -> dynamicObject.getLong("areaconf")).collect(Collectors.toList());
        MainEntityType normalType = EntityMetadataCache.getDataEntityType((String)"epa_normalconf");
        DynamicObject[] norConfArray = BusinessDataServiceHelper.load((Object[])normalIdList.toArray(), (DynamicObjectType)normalType);
        List plusIdList = areColls.stream().filter(dynamicObject -> dynamicObject.getLong("areareg_id") == AreaEnum.PLUSMINUS.getValue().longValue()).map(dynamicObject -> dynamicObject.getLong("areaconf")).collect(Collectors.toList());
        MainEntityType plusType = EntityMetadataCache.getDataEntityType((String)"epa_plusminusconf");
        DynamicObject[] plusConfArray = BusinessDataServiceHelper.load((Object[])plusIdList.toArray(), (DynamicObjectType)plusType);
        List customIdList = areColls.stream().filter(dynamicObject -> dynamicObject.getLong("areareg_id") == AreaEnum.CUSTOM.getValue().longValue()).map(dynamicObject -> dynamicObject.getLong("areaconf")).collect(Collectors.toList());
        MainEntityType customType = EntityMetadataCache.getDataEntityType((String)"epa_customareaconf");
        DynamicObject[] customConfArray = BusinessDataServiceHelper.load((Object[])customIdList.toArray(), (DynamicObjectType)customType);
        List attachIdList = areColls.stream().filter(dynamicObject -> dynamicObject.getLong("areareg_id") == AreaEnum.ATTACH.getValue().longValue()).map(dynamicObject -> dynamicObject.getLong("areaconf")).collect(Collectors.toList());
        MainEntityType attachType = EntityMetadataCache.getDataEntityType((String)"epa_attachconf");
        DynamicObject[] attachArray = BusinessDataServiceHelper.load((Object[])attachIdList.toArray(), (DynamicObjectType)attachType);
        return new AreaCollBO(norConfArray, attachArray, plusConfArray, customConfArray);
    }

    public static EmpSumBO setEmpAndSum(DynamicObject empAndSumForm) {
        DynamicObject empInfConf = BusinessDataServiceHelper.loadSingle((Object)empAndSumForm.getLong("empinfoconf"), (String)"epa_empinfoconf");
        DynamicObject areaPage = AREA_REGENTITY_SERVICE.queryOne(AreaEnum.EMPINFO.getValue());
        DynamicObject sumConf = BusinessDataServiceHelper.loadSingle((Object)empAndSumForm.getLong("sumconf"), (String)"epa_sumconf");
        return new EmpSumBO(empInfConf, areaPage, sumConf);
    }

    public static Set<Long> getAreaFieldNameSet(DynamicObjectCollection areColls, EmpSumBO empSumBO, AreaCollBO areaCollBO) {
        HashSet<Long> areaSet = new HashSet<Long>();
        areaSet.add(ScoreContentEnum.OTHER_EVA.getValue());
        DynamicObject[] normalCollection = areaCollBO.getNormalCollection();
        DynamicObject[] plusCollection = areaCollBO.getPlusCollection();
        Map<Long, DynamicObject> normalConfMap = PresetUtils.convertToArrayMap(normalCollection);
        Map<Long, DynamicObject> plusConfMap = PresetUtils.convertToArrayMap(plusCollection);
        for (DynamicObject coll : areColls) {
            DynamicObject plusConf;
            Long areaId = coll.getLong("areareg.id");
            Long areaConf = coll.getLong("areaconf");
            if (AreaEnum.NORMINDCTR.getValue().equals(areaId)) {
                DynamicObject normalConf = normalConfMap.get(areaConf);
                if (normalConf == null) continue;
                PresetUtils.addNormalFieldSet(areaSet, normalConf);
                continue;
            }
            if (!AreaEnum.PLUSMINUS.getValue().equals(areaId) || (plusConf = plusConfMap.get(areaConf)) == null) continue;
            PresetUtils.addPlusFieldSet(areaSet, plusConf);
        }
        for (DynamicObject entity : empSumBO.getSumConfDynamicObject().getDynamicObjectCollection("entryentity")) {
            if (!entity.getBoolean("isshow")) continue;
            if (FieldEnum.OLE.getValue().equals(entity.getLong("areafield.id"))) {
                areaSet.add(ScoreContentEnum.OLE.getValue());
                continue;
            }
            if (FieldEnum.OSE.getValue().equals(entity.getLong("areafield.id"))) {
                areaSet.add(ScoreContentEnum.OSE.getValue());
                continue;
            }
            if (!FieldEnum.EVAL.getValue().equals(entity.getLong("areafield.id"))) continue;
            areaSet.add(ScoreContentEnum.EVAL.getValue());
        }
        return areaSet;
    }

    private static Map<Long, DynamicObject> convertToArrayMap(DynamicObject[] array) {
        return Arrays.stream(array).collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity()));
    }

    private static void addPlusFieldSet(Set<Long> areaSet, DynamicObject plusConf) {
        for (DynamicObject entity : plusConf.getDynamicObjectCollection("entryentity")) {
            if (FieldEnum.PLUSEVALSCORE.getValue().equals(entity.getLong("areafield.id"))) {
                areaSet.add(ScoreContentEnum.EVALSCORE.getValue());
                continue;
            }
            if (!FieldEnum.PLUSEVALDESC.getValue().equals(entity.getLong("areafield.id"))) continue;
            areaSet.add(ScoreContentEnum.EVALDESC.getValue());
        }
    }

    private static void addNormalFieldSet(Set<Long> areaSet, DynamicObject normalConf) {
        for (DynamicObject entity : normalConf.getDynamicObjectCollection("entryentity")) {
            if (FieldEnum.EVALSCORE.getValue().equals(entity.getLong("areafield.id"))) {
                areaSet.add(ScoreContentEnum.EVALSCORE.getValue());
                continue;
            }
            if (FieldEnum.EVALDESC.getValue().equals(entity.getLong("areafield.id"))) {
                areaSet.add(ScoreContentEnum.EVALDESC.getValue());
                continue;
            }
            if (!FieldEnum.WEIGHT.getValue().equals(entity.getLong("areafield.id"))) continue;
            areaSet.add(ScoreContentEnum.WEIGHT.getValue());
        }
    }
}

