/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.application.service.interview;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.interview.service.InterviewObjDomainService;
import kd.opmc.epa.business.domain.perfresult.entityservice.PerfResultEntityService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;
import kd.opmc.pbs.business.domain.workflow.vo.AssignHandlerVO;

public class InterviewObjApplication {
    private static final InterviewObjDomainService INTERVIEW_OBJ_DOMAIN_SERVICE = InterviewObjDomainService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final PerfResultEntityService PERF_RESULT_ENTITY_SERVICE = PerfResultEntityService.getInstance();
    private static final ActEvalObjDetailApplicationService ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE = ActEvalObjDetailApplicationService.getInstance();

    public static InterviewObjApplication getInstance() {
        return ServiceFactory.getService(InterviewObjApplication.class);
    }

    public Map<Object, Long> queryInterviewFlowsMap(Long activityId) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.queryInterviewFlowsMap(activityId);
    }

    public DynamicObject[] queryFlowByPkValue(Set<Object> objects) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.queryFlowByPkValue(objects);
    }

    public DynamicObject queryFlowProcPkValue(Long flowProcId) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.queryFlowProcPkValue(flowProcId);
    }

    public Map<Long, DynamicObject> queryEvalObjById(List<Long> objIds) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.queryEvalObjById(objIds);
    }

    public Map<Long, String> queryHandler(List<Long> roleIds) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.queryHandler(roleIds);
    }

    public void finishIntview(List<Long> intObjIds) {
        INTERVIEW_OBJ_DOMAIN_SERVICE.finishIntview(intObjIds);
    }

    public FlowValidateResultBo rollbackTask(List<RollbackParamBo> rollbackParamBos) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.rollbackTask(rollbackParamBos);
    }

    public boolean isExistsTobeInterObjByActId(Long activityId) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.isExistsTobeInterObjByActId(activityId);
    }

    public void deleteInterObj(DynamicObject[] interObj) {
        INTERVIEW_OBJ_DOMAIN_SERVICE.deleteInterObj(interObj);
    }

    public List<Long> queryFormulatorByListDefaultFilter(Long activityId, Object seq, long flowId) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.queryFormulatorByListDefaultFilter(activityId, seq, flowId);
    }

    public List<AssignHandlerVO> modifyHandlerAfterStartProcess(List<ExtendedDataEntity> dataEntities, Map<String, List<Long>> handlerInfo) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.modifyHandlerAfterStartProcess(dataEntities, handlerInfo);
    }

    public Map<Long, String> getFlowInfoByObjIds(List<Long> objIds) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.getFlowInfoByObjIds(objIds);
    }

    public String getAuditedEvaResultByPerffileAndActivity(Long activityId, Long perffileId) {
        if (activityId == null || perffileId == null) {
            return "";
        }
        DynamicObject activity = ACTIVITY_ENTITY_SERVICE.queryOriginalOne("assessform.id", activityId);
        if (activity == null) {
            return "";
        }
        QFilter filter = new QFilter("perffilef7", "=", (Object)perffileId);
        filter.and(new QFilter("activity", "=", (Object)activityId));
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject evaResultDy = PERF_RESULT_ENTITY_SERVICE.queryOriginalOne("score,assessleveltext", new QFilter[]{filter});
        if (evaResultDy != null) {
            Object score = evaResultDy.get("score");
            String assessleveltext = evaResultDy.getString("assessleveltext");
            StringBuilder evaResultSb = new StringBuilder();
            if (score != null) {
                DynamicObject assessformDy = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryExecuteAssessForm(activity.getLong("assessform.id"));
                int numAccuracy = 2;
                int roundingMode = ScalaTypeEnum.ROUND_HALF_UP.getType();
                if (assessformDy != null) {
                    numAccuracy = assessformDy.getInt("numaccuracy");
                    roundingMode = ScalaTypeEnum.get(assessformDy.getString("scaletype")).getType();
                }
                BigDecimal scoreBig = (BigDecimal)score;
                scoreBig = scoreBig.setScale(numAccuracy, roundingMode);
                evaResultSb.append(scoreBig.toPlainString());
            }
            if (HRStringUtils.isNotEmpty((String)assessleveltext)) {
                if (evaResultSb.length() > 0) {
                    evaResultSb.append("/");
                }
                evaResultSb.append(assessleveltext);
            }
            return evaResultSb.toString();
        }
        return "";
    }

    public DynamicObject[] queryFLowRuRoleById(Long[] roleIdList) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.queryFLowRuRoleById(roleIdList);
    }
}

