/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.application.service.mqmanage.prefsumcal.publisher;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumCalDomainService;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskStatusEnum;
import org.apache.commons.collections.CollectionUtils;

public class PerfSumCalPublisher {
    private static final Log LOGGER = LogFactory.getLog(PerfSumCalPublisher.class);
    private static final PerfSumCalDomainService PERF_SUM_CAL_DOMAIN_SERVICE = PerfSumCalDomainService.getInstance();

    public static void publish(List<Long> batchTaskIdList) {
        if (CollectionUtils.isEmpty(batchTaskIdList)) {
            return;
        }
        LOGGER.info("\u3010OPMC\u3011-begin PerfSumCal publish");
        MessagePublisher pub = MQFactory.get().createSimplePublisher("opmc", "kd.opmc.epa.opmc_epa_perfsumcal_queue");
        try {
            JSONObject paramJsonObject = new JSONObject();
            paramJsonObject.put("batchTaskIdList", batchTaskIdList);
            paramJsonObject.put("pushTime", (Object)System.currentTimeMillis());
            PERF_SUM_CAL_DOMAIN_SERVICE.updateBatchTaskStatus(batchTaskIdList, TaskStatusEnum.PUSHED);
            pub.publish(HRJSONUtils.toString((Object)paramJsonObject));
        }
        catch (Exception e) {
            PERF_SUM_CAL_DOMAIN_SERVICE.updateBatchTaskStatus(batchTaskIdList, TaskStatusEnum.UNPROCESS);
            LOGGER.error("\u3010OPMC\u3011-PerfSumCalPublisher publish error,message : {0}", (Object)e.getMessage());
        }
        finally {
            pub.close();
            LOGGER.info("PerfSumCalPublisher.close");
        }
        LOGGER.info("\u3010OPMC\u3011-end PerfSumCal publish");
    }
}

