/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.application.service.scheme;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.scheme.entityservice.AssessGroupEntityService;
import kd.opmc.epa.business.domain.scheme.service.AssessObjectDomainService;

public class AssessObjectApplicationService {
    private static final AssessObjectDomainService DOMAIN_SERVICE = AssessObjectDomainService.getInstance();
    private static final AssessGroupEntityService ASSESS_GROUP_ENTITY_SERVICE = AssessGroupEntityService.getInstance();

    public static AssessObjectApplicationService getInstance() {
        return ServiceFactory.getService(AssessObjectApplicationService.class);
    }

    public void save(DynamicObject[] dataEntities) {
        DOMAIN_SERVICE.save(dataEntities);
    }

    public DynamicObject[] saveAssessObject(Long schemeId, DynamicObjectCollection assessObject, DynamicObject activity) {
        return DOMAIN_SERVICE.saveAssessObject(schemeId, assessObject, activity);
    }

    public DynamicObject[] saveAssessObjectWithInput(Long schemeId, DynamicObjectCollection assessObject, DynamicObject activity) {
        return DOMAIN_SERVICE.saveAssessObjectWithInput(schemeId, assessObject, activity);
    }

    public DynamicObject[] queryListByActivity(DynamicObject activityDynObj) {
        long schemeId = activityDynObj.getLong("scheme.id");
        long executeSchemeAssessScopeId = activityDynObj.getLong("executescheme.assessscope.id");
        DynamicObject[] assessGroupArr = ASSESS_GROUP_ENTITY_SERVICE.queryAssessGroupArr(schemeId, executeSchemeAssessScopeId);
        List<Long> assessGroupIdList = Arrays.stream(assessGroupArr).map(assessGroupDynObj -> assessGroupDynObj.getLong("id")).collect(Collectors.toList());
        return DOMAIN_SERVICE.queryListByAssessGroupIdList(assessGroupIdList);
    }

    public DynamicObject[] queryPerffileBySchemeId(Long schemeId) {
        return DOMAIN_SERVICE.queryPerffileBySchemeId(schemeId);
    }

    public DynamicObject[] getPerffileListByIds(List<Long> ids) {
        return DOMAIN_SERVICE.getPerffileListByIds(ids);
    }

    public DynamicObject generateEmpty() {
        return DOMAIN_SERVICE.generateEmpty();
    }

    public DynamicObject[] loadDynamicObjectArrayByIds(Object[] ids) {
        return DOMAIN_SERVICE.loadDynamicObjectArrayByIds(ids);
    }

    public List<Map<String, Object>> batchGetAllSubOrg(List<Long> orgIdList, Date date) {
        return DOMAIN_SERVICE.batchGetAllSubOrg(orgIdList, date);
    }

    public DynamicObject[] queryListByIds(List<Long> ids) {
        return DOMAIN_SERVICE.queryListByIds(ids);
    }

    public void deleteAssObjByOrgNSchemeId(long schemeId, Map<Long, Boolean> delOrg) {
        DOMAIN_SERVICE.deleteAssObjByOrgNSchemeId(schemeId, delOrg);
    }

    public void deleteOrgLowerAssObjByOrgNSchemeId(Long schemeId, Map<Long, Boolean> orgMap) {
        DOMAIN_SERVICE.deleteOrgLowerAssObjByOrgNSchemeId(schemeId, orgMap);
    }

    public DynamicObject[] queryAllObjByIds(List<Long> ids) {
        return DOMAIN_SERVICE.queryAllObjByIds(ids);
    }

    public int countNoJoinObj(List<QFilter> dataFilters) {
        return DOMAIN_SERVICE.countNoJoinObj(dataFilters);
    }

    public int countJoinObj(List<QFilter> dataFilters) {
        return DOMAIN_SERVICE.countJoinObj(dataFilters);
    }

    public void deleteAssessObjectByPerfFileIdList(long schemeId, List<Long> perfFileIdList) {
        DOMAIN_SERVICE.deleteAssessObjectByPerfFileIdList(schemeId, perfFileIdList);
    }

    public DynamicObject[] queryByFilters(QFilter[] qFilters) {
        return DOMAIN_SERVICE.queryByFilters(qFilters);
    }
}

