/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.application.service.scheme;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.scheme.service.ExecuteSchemeDomainService;
import kd.opmc.epa.business.domain.scheme.service.SchemeBaseInfoDomainService;

public class ExecuteSchemeApplicationService {
    private static final ExecuteSchemeDomainService DOMAIN_SERVICE = ExecuteSchemeDomainService.getInstance();
    private static final SchemeBaseInfoDomainService SCHEME_BASE_INFO_DOMAIN_SERVICE = SchemeBaseInfoDomainService.getInstance();

    public static ExecuteSchemeApplicationService getInstance() {
        return ServiceFactory.getService(ExecuteSchemeApplicationService.class);
    }

    public DynamicObject[] queryScopeList(QFilter[] qFilters) {
        return DOMAIN_SERVICE.queryListByFilters("assessscope", qFilters);
    }

    public DynamicObject[] queryListBySchemeId(Long schemeId, String searchText) {
        return DOMAIN_SERVICE.queryListBySchemeId(schemeId, searchText);
    }

    public DynamicObject[] queryListBySchemeId(Long schemeId) {
        return DOMAIN_SERVICE.queryListBySchemeId(schemeId);
    }

    public DynamicObject queryBySchemeId(Long schemeId) {
        return DOMAIN_SERVICE.queryBySchemeId(schemeId);
    }

    public void deleteById(Long id) {
        DOMAIN_SERVICE.deleteById(id);
    }

    public void deleteByFilter(QFilter[] qFilters) {
        DOMAIN_SERVICE.deleteByFilter(qFilters);
    }

    public DynamicObject generateEmpty() {
        return DOMAIN_SERVICE.generateEmpty();
    }

    public void batchSave(DynamicObjectCollection cols) {
        DOMAIN_SERVICE.batchSave(cols);
    }

    public DynamicObject[] query(String selectors, QFilter[] queryFilters, String order) {
        return DOMAIN_SERVICE.query(selectors, queryFilters, order);
    }

    public DynamicObject queryOne(String selectors, Long schemeId) {
        return DOMAIN_SERVICE.queryOne(selectors, schemeId);
    }

    public int count(QFilter[] qFilters) {
        return DOMAIN_SERVICE.count(qFilters);
    }

    public boolean isSameTopCycleType(long schemeId, long executeSchemeId) {
        DynamicObject cycleTypeDynObj;
        DynamicObject schemeDynObj = SCHEME_BASE_INFO_DOMAIN_SERVICE.queryCycleInfoById(schemeId);
        DynamicObject executeSchemeCycleType = DOMAIN_SERVICE.queryExecuteSchemeCycleType(executeSchemeId);
        if (schemeDynObj.getBoolean("isperiodassess")) {
            DynamicObjectCollection periodConfEntry = schemeDynObj.getDynamicObjectCollection("periodconfentity");
            cycleTypeDynObj = ((DynamicObject)periodConfEntry.get(0)).getDynamicObject("pcycletype");
        } else {
            cycleTypeDynObj = schemeDynObj.getDynamicObject("cycletype");
        }
        return executeSchemeCycleType.getLong("timetag.cycletype.id") == cycleTypeDynObj.getLong("id");
    }
}

