/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.activity.entityservice;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.pbs.business.domain.OpmcEntityService;

public class AssessActivityEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("epa_activity");

    public static AssessActivityEntityService getInstance() {
        return ServiceFactory.getService(AssessActivityEntityService.class);
    }

    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject queryOne(Object pk) {
        return HELPER.queryOne(pk);
    }

    public DynamicObject[] queryByIds(List<Long> ids) {
        String selectFields = "executescheme,activitystatus";
        QFilter filter = new QFilter("id", "in", ids);
        return HELPER.query(selectFields, new QFilter[]{filter});
    }

    public DynamicObject queryActivityPAssessNode(Long id) {
        String selectFields = "id, activitystatus, timeplanentry, activity.index, assessform.id, perfworkflow.id";
        QFilter filter = new QFilter("id", "=", (Object)id);
        return HELPER.queryOne(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryByExecuteScheme(Object executeId) {
        String selectFields = "id, period";
        QFilter filter = new QFilter("executescheme", "=", executeId);
        return HELPER.query(selectFields, new QFilter[]{filter});
    }

    public DynamicObjectCollection queryExecuteSchemeByPeriod(String assessYear) {
        QFilter periodFilter = new QFilter("period", "like", (Object)(assessYear + "%"));
        return HELPER.queryOriginalCollection("executescheme.id", periodFilter.toArray());
    }

    public DynamicObject queryAssessFormByActivity(Long id) {
        String selectFields = "id, activitystatus, assessform.id,executescheme.id";
        QFilter filter = new QFilter("id", "=", (Object)id);
        return HELPER.queryOne(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryAssessFormByActivity(List<Long> ids) {
        String selectFields = "id,assessform";
        QFilter filter = new QFilter("id", "in", ids);
        return HELPER.query(selectFields, new QFilter[]{filter});
    }

    public DynamicObject queryScoreAndLevelConfigByActivity(Long activityId) {
        String selectFields = "id, activitystatus, assessform.id, timeplanentry.activity, perfworkflow.id";
        QFilter filter = new QFilter("id", "=", (Object)activityId);
        return HELPER.queryOne(selectFields, new QFilter[]{filter});
    }

    public DynamicObject queryAssessFormByActivityNumber(String number) {
        String selectFields = "id, activitystatus, assessform.id,executescheme.id";
        QFilter filter = new QFilter("number", "=", (Object)number);
        return HELPER.queryOne(selectFields, new QFilter[]{filter});
    }

    public boolean isExistActivityByExecuteSchemeId(long executeSchemeId, Date year, long activityId) {
        QFilter executeSchemeFilter = new QFilter("executescheme", "=", (Object)executeSchemeId);
        executeSchemeFilter.and("year", "=", (Object)year);
        executeSchemeFilter.and("activitystatus", "!=", (Object)ActivityStatusEnum.COMPLETED.getValue());
        if (activityId != 0L) {
            executeSchemeFilter.and("id", "!=", (Object)activityId);
        }
        return HELPER.isExists(executeSchemeFilter);
    }

    public DynamicObject[] queryActivityByExecuteSchemeIdList(List<Long> executeSchemeIdList, Date year) {
        QFilter executeSchemeFilter = new QFilter("executescheme", "in", executeSchemeIdList);
        executeSchemeFilter.and("year", "=", (Object)year);
        executeSchemeFilter.and("activitystatus", "!=", (Object)ActivityStatusEnum.COMPLETED.getValue());
        return HELPER.query("executescheme", executeSchemeFilter.toArray());
    }

    public DynamicObject[] queryActivityByIdList(List<Long> activityIdList) {
        QFilter filter = new QFilter("id", "in", activityIdList);
        return HELPER.query("id,scheme.id,executescheme.assessscope.id", filter.toArray());
    }
}

