/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.activity.service;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activity.entityservice.AddSubAreaInsEntityService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessSchemeEntityService;
import kd.opmc.epa.business.domain.activity.entityservice.AttachAreaInsEntityService;
import kd.opmc.epa.business.domain.activity.entityservice.GenAreaIndicatorReqEntityService;
import kd.opmc.epa.business.domain.activity.entityservice.GenAreaInstanceEntityService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.domain.activity.enums.AssGroupStatus;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessrule.service.AssessRuleDomainService;
import kd.opmc.epa.business.domain.perfresult.service.PerfResultDomainService;
import kd.opmc.epa.business.domain.perfworkflow.entutyservice.PerfWorkFlowEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.AssessGroupEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.domain.scheme.service.AssessGroupDomainService;
import kd.opmc.epa.business.domain.scheme.service.SchemeBaseInfoDomainService;
import kd.opmc.epa.business.task.StartActivitySelfFillingTask;
import kd.opmc.epa.business.task.StartActivityUnifiedReleaseTask;
import kd.opmc.epa.business.utils.ActivityPermissionUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.CycleSchemeEntityService;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.ScoreSystemEntityService;
import kd.opmc.pbs.business.domain.timetag.entityservice.TimeTagEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import kd.opmc.pbs.business.external.hrcs.IHRCSTipService;
import kd.opmc.pmd.business.domain.perffile.service.PerffileDomainService;

public class AssessActivityDomainService {
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY = AssessActivityEntityService.getInstance();
    private static final CycleSchemeEntityService CYCLE_SCHEME_ENTITY = CycleSchemeEntityService.getInstance();
    private static final ScoreSystemEntityService SCORE_SYSTEM_ENTITY = ScoreSystemEntityService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY = PerfLevelEntityService.getInstance();
    private static final GenAreaInstanceEntityService GEN_AREA_INSTANCE_ENTITY = GenAreaInstanceEntityService.getInstance();
    private static final AddSubAreaInsEntityService ADD_SUB_AREA_INS_ENTITY = AddSubAreaInsEntityService.getInstance();
    private static final AttachAreaInsEntityService ATTACH_AREA_INS_ENTITY = AttachAreaInsEntityService.getInstance();
    private static final GenAreaIndicatorReqEntityService GEN_AREA_INDICATOR_REQ_ENTITY = GenAreaIndicatorReqEntityService.getInstance();
    private static final AssessGroupDomainService ASSESS_GROUP_DOMAIN = AssessGroupDomainService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY = ExecuteSchemeEntityService.getInstance();
    private static final TimeTagEntityService TIME_TAG_ENTITY = TimeTagEntityService.getInstance();
    private static final IHRCSTipService IHRCS_TIP_SERVICE = IHRCSTipService.getInstance();
    private static final AssessRuleDomainService ASSESS_RULE_DOMAIN_SERVICE = AssessRuleDomainService.getInstance();
    private static final PerffileDomainService PERFFILE_DOMAIN_SERVICE = PerffileDomainService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService EPA_ACTEVALOBJ = ActivityEvaluationObjectEntityService.getInstance();
    private static final FlowDefProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final FlowDefProcEntityService FLOW_DEF_PROC_ENTITY_SERVICE = FlowDefProcEntityService.getInstance();
    private static final ActivityEvaluationObjectDomainService ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final AssessGroupEntityService ASSESS_GROUP_ENTITY_SERVICE = AssessGroupEntityService.getInstance();
    private static final SchemeBaseInfoDomainService ASSESS_SCHEME_DOMAIN_SERVICE = SchemeBaseInfoDomainService.getInstance();
    private static final AssessSchemeEntityService ASSESS_SCHEME_ENTITY_SERVICE = AssessSchemeEntityService.getInstance();
    private static final PerfWorkFlowEntityService PERF_WORK_FLOW_ENTITY_SERVICE = PerfWorkFlowEntityService.getInstance();
    private static final FlowDefNodeEntityService FLOW_DEF_NODE_ENTITY_SERVICE = FlowDefNodeEntityService.getInstance();
    private static final HRBaseServiceHelper dynamixcPermitService = new HRBaseServiceHelper("epa_dynamicpermission");
    private static final Log LOGGER = LogFactory.getLog(AssessActivityDomainService.class);
    private static final long MP_CONFAREA = 1960097310314606592L;
    private static final long EMP_CONFAREA = 1L;
    private static final long SUM_CONFAREA = 5L;

    public DynamicObject queryOne(Object pk) {
        return ACTIVITY_ENTITY.queryOne(pk);
    }

    public DynamicObject loadSingle(Object pk) {
        return ACTIVITY_ENTITY.loadSingle(pk);
    }

    public Object updateActivityDynObj(DynamicObject activityDynObj) {
        return ACTIVITY_ENTITY.updateOne(activityDynObj);
    }

    public DynamicObject[] queryByIds(List<Long> ids) {
        return ACTIVITY_ENTITY.queryByIds(ids);
    }

    public static AssessActivityDomainService getInstance() {
        return ServiceFactory.getService(AssessActivityDomainService.class);
    }

    public DynamicObject queryCycleScheme(long cycleSchemeId) {
        return CYCLE_SCHEME_ENTITY.loadSingle((Object)cycleSchemeId);
    }

    public DynamicObject queryScoreSystemById(Long scoreSystemId) {
        return SCORE_SYSTEM_ENTITY.queryOne((Object)scoreSystemId);
    }

    public DynamicObject queryPerfLevelById(Long perfLevelById) {
        return PERF_LEVEL_ENTITY.queryOne((Object)perfLevelById);
    }

    private Long createAssessTableInstance(OpmcEntityService entityService, DynamicObject dynamicObject) {
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObject assessTableDy = (DynamicObject)entityService.saveOne(dynamicObject);
        return assessTableDy.getLong("id");
    }

    public String validateAssessTableIndicatorReq(Long instanceId, DynamicObject indicatorType) {
        String indicatorTypeName = ObjectUtils.isEmpty((Object)indicatorType) ? "" : indicatorType.getString("name");
        DynamicObject[] indicatorReqs = GEN_AREA_INDICATOR_REQ_ENTITY.queryByInstanceId(instanceId);
        boolean indicatorTypeRepeat = Arrays.stream(indicatorReqs).anyMatch(indicatorReq -> indicatorReq.getLong("indicatortype.id") == indicatorType.getLong("id"));
        if (indicatorTypeRepeat) {
            return ResManager.loadKDString((String)"\u533a\u57df\u4e2d\u5df2\u8bbe\u7f6e\u4e86{0}\u7684\u8981\u6c42\uff0c\u65e0\u9700\u91cd\u590d\u8bbe\u7f6e", (String)"AssessActivityDomainService_0", (String)"opmc-epa-business", (Object[])new Object[]{indicatorTypeName});
        }
        return null;
    }

    public String[] getBatchNumber(int size) {
        return CodeRuleServiceHelper.getBatchNumber((String)"epa_activity", (DynamicObject)ACTIVITY_ENTITY.generateEmptyDynamicObject(), null, (int)size);
    }

    public OperationResult initActivity(DynamicObjectCollection activityEntry, Date year, DynamicObject timeTag) {
        DynamicObject[] activityDys = new DynamicObject[activityEntry.size()];
        for (int i = 0; i < activityEntry.size(); ++i) {
            DynamicObject activityInfo = (DynamicObject)activityEntry.get(i);
            DynamicObject activityDy = ACTIVITY_ENTITY.generateEmptyDynamicObject();
            activityDy.set("name", activityInfo.get("name"));
            activityDy.set("year", (Object)year);
            int yearInt = HRDateTimeUtils.getYear((Date)year);
            String period = yearInt + timeTag.getString("name");
            activityDy.set("period", (Object)period);
            activityDy.set("periodname", (Object)period);
            DynamicObject executeScheme = activityInfo.getDynamicObject("executescheme");
            activityDy.set("executescheme", (Object)executeScheme);
            activityDy.set("scheme", (Object)executeScheme.getDynamicObject("scheme"));
            activityDy.set("activitystatus", (Object)ActivityStatusEnum.STAGING.getValue());
            activityDy.set("rule", (Object)executeScheme.getDynamicObject("assessrule"));
            activityDy.set("status", (Object)"C");
            activityDy.set("enable", (Object)"1");
            activityDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            activityDy.set("createtime", (Object)new Date());
            activityDy.set("periodstartdate", (Object)new Date());
            activityDy.set("periodenddate", (Object)new Date());
            activityDy.set("planstarttime", (Object)new Date());
            activityDy.set("planendtime", (Object)new Date());
            activityDys[i] = activityDy;
        }
        OperateOption option = OperateOption.create();
        return OperationServiceHelper.executeOperate((String)"save", (String)"epa_activity", (DynamicObject[])activityDys, (OperateOption)option);
    }

    public void saveActivity(DynamicObject[] dys) {
        ACTIVITY_ENTITY.save(dys);
    }

    public List<Long> queryAssessGroupId(long scopeId) {
        DynamicObject[] scopeDys = ASSESS_GROUP_DOMAIN.queryListByScopeId(false, scopeId);
        return Arrays.stream(scopeDys).map(scopeDy -> scopeDy.getLong("id")).collect(Collectors.toList());
    }

    public String getTips(String formId, String key, DynamicObject dy) {
        List tips = IHRCS_TIP_SERVICE.getTips(formId, key, dy);
        if (!ObjectUtils.isEmpty((Object)tips)) {
            return (String)tips.get(0);
        }
        return "";
    }

    public void deleteActivity(List<Object> pkIds) {
        ACTIVITY_ENTITY.delete(pkIds.toArray(new Object[0]));
    }

    public DynamicObject[] queryAreaAssessTable(Long areaRegId, List<Long> instanceIds) {
        if (areaRegId == null || areaRegId == 0L) {
            return new DynamicObject[0];
        }
        Object[] instanceId = instanceIds.toArray(new Long[0]);
        if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            return GEN_AREA_INSTANCE_ENTITY.loadDynamicObjectArray(instanceId);
        }
        if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            return ADD_SUB_AREA_INS_ENTITY.loadDynamicObjectArray(instanceId);
        }
        if (areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) {
            return ATTACH_AREA_INS_ENTITY.loadDynamicObjectArray(instanceId);
        }
        return new DynamicObject[0];
    }

    public DynamicObject queryActivity(long pkId) {
        return ACTIVITY_ENTITY.loadSingle(pkId);
    }

    public DynamicObject queryTimmTag(long pkId) {
        return TIME_TAG_ENTITY.loadSingle((Object)pkId);
    }

    public DynamicObject[] queryTimeTagArr(List<Long> timeTagIdList) {
        return TIME_TAG_ENTITY.query("number,name,cycletype", new QFilter("id", "in", timeTagIdList).toArray());
    }

    public DynamicObject[] queryActivityBySchemeId(Long schemeId) {
        QFilter[] filters = new QFilter[]{new QFilter("scheme", "=", (Object)schemeId)};
        return ACTIVITY_ENTITY.query("id,executescheme", filters);
    }

    public DynamicObject[] queryActivityArrBySchemeId(long schemeId, long assessScopeId) {
        QFilter schemeFilter = new QFilter("scheme", "=", (Object)schemeId);
        schemeFilter.and("executescheme.assessscope.id", "=", (Object)assessScopeId);
        return ACTIVITY_ENTITY.query("period,periodstartdate,periodenddate", schemeFilter.toArray());
    }

    public DynamicObject[] queryGenInstance(Set<Long> areaInstanceIds) {
        QFilter idFilter = new QFilter("id", "in", areaInstanceIds);
        return GEN_AREA_INSTANCE_ENTITY.query("areascore, areaweight, forcedtype, entryentity.indctrscore, entryentity.weight", new QFilter[]{idFilter});
    }

    public DynamicObject[] getPerffileListByIds(List<Long> ids) {
        String selectFields = "id,person,empposrel,employee,org,affiliateadminorg,depemp";
        return PERFFILE_DOMAIN_SERVICE.getPerffileListByIds(selectFields, ids);
    }

    public DynamicObject queryActivityAbstractInfo(Long activityId) {
        return ACTIVITY_ENTITY.queryOne("name, scheme.assesstype, periodname, assgroupentry.assgroup, rule.targetmodel", activityId);
    }

    public Map<Long, String> queryActivityNameByIds(List<Long> activityIds) {
        QFilter idFilter = new QFilter("id", "in", activityIds);
        DynamicObject[] activity = ACTIVITY_ENTITY.query("id,name", new QFilter[]{idFilter});
        return Arrays.stream(activity).collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString("name")));
    }

    public Tuple<String, String> startActivityUnifiedRelease(Long activityId, List<DynamicObject> joinActivityEvaluation, StartActivityUnifiedReleaseTask task) {
        ArrayList<String> failMessage = new ArrayList<String>(16);
        DynamicObject activityDy = this.queryActivity(activityId);
        String desc = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u8bf7\u52ff\u9000\u51fa\u9875\u9762\uff0c\u6216\u6267\u884c\u4fdd\u5b58\u7b49\u64cd\u4f5c", (String)"AssessActivityDomainService_15", (String)"opmc-epa-business", (Object[])new Object[0]);
        task.feedbackProgress(50, desc);
        DynamicObjectCollection assGroupDys = activityDy.getDynamicObjectCollection("assgroupentry");
        List<DynamicObject> assGroupsOfTableRequire = assGroupDys.stream().filter(assGroup -> assGroup.getBoolean("isasstablerequire")).collect(Collectors.toList());
        List assGroupsOfTableClose = assGroupDys.stream().filter(assGroup -> !assGroup.getBoolean("isasstablerequire")).collect(Collectors.toList());
        DynamicObject dynamicObject = this.queryScoreSystemById(activityDy.getLong("rule.scoresystem.id"));
        BigDecimal maxScore = dynamicObject.getBigDecimal("maxscore");
        List<DynamicObject> checkIndctrScoreSumFail = this.checkIndctrScoreSum(maxScore, assGroupsOfTableRequire);
        Set longSet = joinActivityEvaluation.stream().map(joinActivity -> joinActivity.getLong("assgroup.id")).collect(Collectors.toSet());
        task.feedbackProgress(55, desc);
        for (DynamicObject closeObj : assGroupsOfTableClose) {
            if (!longSet.contains(closeObj.getLong("assgroup.id"))) continue;
            failMessage.add(MessageFormat.format(ResManager.loadKDString((String)"{0}: \u8003\u6838\u7ec4\u6ca1\u6709\u7edf\u4e00\u8bbe\u7f6e\u6307\u6807", (String)"AssessActivityDomainService_5", (String)"opmc-epa-business", (Object[])new Object[0]), closeObj.getString("assgroup.name")));
        }
        for (DynamicObject indctrScoreSum : checkIndctrScoreSumFail) {
            if (!longSet.contains(indctrScoreSum.getLong("assgroup.id"))) continue;
            failMessage.add(MessageFormat.format(ResManager.loadKDString((String)"{0}: \u8003\u6838\u7ec4\u8bc4\u4f30\u8868\u8981\u6c42\u8bbe\u7f6e\u4e2d\u6307\u6807\u5206\u503c\u4e4b\u548c\u6ca1\u6709\u8fbe\u5230\u8bc4\u5206\u5206\u5236\u7684\u57fa\u51c6\u6700\u9ad8\u5206", (String)"AssessActivityDomainService_6", (String)"opmc-epa-business", (Object[])new Object[0]), indctrScoreSum.getString("assgroup.name")));
        }
        assGroupsOfTableClose.addAll(checkIndctrScoreSumFail);
        Set failGroupIds = assGroupsOfTableClose.stream().map(assGroupDy -> assGroupDy.getLong("assgroup.id")).collect(Collectors.toSet());
        ArrayList<DynamicObject> successActivityEvaluation = new ArrayList<DynamicObject>(16);
        for (DynamicObject joinActivity2 : joinActivityEvaluation) {
            if (failGroupIds.contains(joinActivity2.getLong("assgroup.id"))) continue;
            successActivityEvaluation.add(joinActivity2);
        }
        task.feedbackProgress(60, desc);
        if (successActivityEvaluation.size() > 0) {
            this.changeStartUpActivityUnifiedRelease(activityDy, successActivityEvaluation);
        }
        task.feedbackProgress(80, desc);
        String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u542f\u52a8\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"AssessActivityDomainService_7", (String)"opmc-epa-business", (Object[])new Object[0]), joinActivityEvaluation.size(), successActivityEvaluation.size(), joinActivityEvaluation.size() - successActivityEvaluation.size());
        return Tuple.create((Object)title, (Object)String.join((CharSequence)"\n", failMessage));
    }

    private void changeStartUpActivityUnifiedRelease(DynamicObject activityDy, List<DynamicObject> successActivityEvaluation) {
        this.changeActivityEvaluation(successActivityEvaluation);
        this.activityRecordObjects(activityDy, successActivityEvaluation, true);
        ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject(successActivityEvaluation.toArray(new DynamicObject[0]));
        activityDy.set("activitystatus", (Object)ActivityStatusEnum.EXECUTING.getValue());
        Set startGroupIds = successActivityEvaluation.stream().map(assGroupDy -> assGroupDy.getLong("assgroup.id")).collect(Collectors.toSet());
        ArrayList<DynamicObject> successAssGroupDys = new ArrayList<DynamicObject>(16);
        for (DynamicObject assGroupDy2 : activityDy.getDynamicObjectCollection("assgroupentry")) {
            if (!startGroupIds.contains(assGroupDy2.getLong("assgroup.id"))) continue;
            assGroupDy2.set("assgroupstatus", (Object)AssGroupStatus.STARTED.getStatus());
            successAssGroupDys.add(assGroupDy2);
        }
        this.saveActivity(new DynamicObject[]{activityDy});
        Long[] evalObjIds = (Long[])successActivityEvaluation.stream().map(joinActivity -> joinActivity.getLong("id")).toArray(Long[]::new);
        DynamicObject[] evalObjDys = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.loadDynamicObjectArray(evalObjIds);
        ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.initEvalObjAssessTableInfoForActivity(successAssGroupDys, evalObjDys);
        this.recordPerfActive(activityDy, evalObjDys);
    }

    private void changeActivityEvaluation(List<DynamicObject> assGroupsOfTable) {
        assGroupsOfTable.forEach(activityEvaluation -> {
            activityEvaluation.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
            activityEvaluation.set("assessnode", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
            activityEvaluation.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus());
            activityEvaluation.set("nodeindex", (Object)1);
        });
    }

    private void activityRecordObjects(DynamicObject activityDy, List<DynamicObject> assGroupsOfTable, boolean isUnified) {
        ArrayList activityRecordList = new ArrayList(16);
        assGroupsOfTable.forEach(activityEvaluation -> {
            DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
            activityRecord.set("actevalobj", (Object)activityEvaluation.getLong("id"));
            activityRecord.set("nodeindex", activityEvaluation.get("nodeindex"));
            if (isUnified) {
                activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId());
                activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus());
                activityRecord.set("endtime", (Object)new Date());
            } else {
                activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
                activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus());
            }
            activityRecord.set("starttype", (Object)"20");
            activityRecord.set("assessperiod", activityDy.get("period"));
            activityRecord.set("assessyear", activityEvaluation.get("assessyear"));
            activityRecord.set("activity", activityDy.get("id"));
            activityRecord.set("perforg", activityEvaluation.get("assgroup.id"));
            long currUserId = RequestContext.get().getCurrUserId();
            activityRecord.set("creator", (Object)currUserId);
            activityRecordList.add(activityRecord);
        });
        ACTIVITY_RECORD_ENTITY.save(activityRecordList.toArray(new DynamicObject[0]));
    }

    public boolean startActivitySelfFilling(DynamicObject assessActivity, List<DynamicObject> joinActivityEvaluation, StartActivitySelfFillingTask task) {
        try {
            String desc = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u8bf7\u52ff\u9000\u51fa\u9875\u9762\uff0c\u6216\u6267\u884c\u4fdd\u5b58\u7b49\u64cd\u4f5c", (String)"AssessActivityDomainService_15", (String)"opmc-epa-business", (Object[])new Object[0]);
            ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.changeJoinActivity(assessActivity, joinActivityEvaluation);
            task.feedbackProgress(50, desc);
            ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject(joinActivityEvaluation.toArray(new DynamicObject[0]));
            this.activityRecordObjects(assessActivity, joinActivityEvaluation, false);
            Set startAssGroup = joinActivityEvaluation.stream().map(joinActivity -> joinActivity.getLong("assgroup.id")).collect(Collectors.toSet());
            assessActivity.set("activitystatus", (Object)ActivityStatusEnum.EXECUTING.getValue());
            for (DynamicObject assGroupDy : assessActivity.getDynamicObjectCollection("assgroupentry")) {
                if (!startAssGroup.contains(assGroupDy.getLong("assgroup.id"))) continue;
                assGroupDy.set("assgroupstatus", (Object)AssGroupStatus.STARTED.getStatus());
            }
            this.saveActivity(new DynamicObject[]{assessActivity});
            task.feedbackProgress(60, desc);
            Long[] ids = (Long[])joinActivityEvaluation.stream().map(joinActivity -> joinActivity.getLong("id")).toArray(Long[]::new);
            ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.initEvalObjAssessTableInfo(ids);
            this.recordPerfActive(assessActivity, joinActivityEvaluation.toArray(new DynamicObject[0]));
            task.feedbackProgress(80, desc);
            return true;
        }
        catch (Exception exception) {
            LOGGER.error("startActivityselfFilling", (Throwable)exception);
            return false;
        }
    }

    private void recordPerfActive(DynamicObject activityDy, DynamicObject[] evalObjDys) {
        DynamicObject[] dynamicObjects;
        List perFileSourceVIds = Arrays.stream(evalObjDys).map(evalObjDy -> evalObjDy.getLong("perffile.id")).collect(Collectors.toList());
        Map<Long, Long> objectMap = Arrays.stream(evalObjDys).collect(Collectors.toMap(evalObjDy -> evalObjDy.getLong("perffile.id"), evalObjDy -> evalObjDy.getLong("id"), (key1, key2) -> key2));
        ArrayList<DynamicObject> batchDyc = new ArrayList<DynamicObject>(16);
        for (DynamicObject dynamicObject : dynamicObjects = PERFFILE_DOMAIN_SERVICE.loadDynamicObjectArray(perFileSourceVIds)) {
            DynamicObject generatePerf = PERFFILE_DOMAIN_SERVICE.generateEmpty();
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)generatePerf);
            DynamicObjectCollection resultentryentity = generatePerf.getDynamicObjectCollection("activityentryentity");
            DynamicObject addNew = resultentryentity.addNew();
            addNew.set("activity", (Object)activityDy.getLong("id"));
            addNew.set("actevalobj", (Object)objectMap.get(dynamicObject.getLong("id")));
            batchDyc.add(generatePerf);
        }
        DynamicObject[] dycs = batchDyc.toArray(new DynamicObject[0]);
        if (HRObjectUtils.isEmpty((Object)dycs) || dycs.length == 0) {
            return;
        }
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(true);
        hisVersionParamBo.setAtomicTrans(true);
        hisVersionParamBo.setEntityNumber("pmd_perffile");
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(dycs);
        HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
    }

    public List<DynamicObject> checkIndctrScoreSum(BigDecimal maxScore, List<DynamicObject> assGroupsOfTableRequire) {
        ArrayList<DynamicObject> failAssGroups = new ArrayList<DynamicObject>(16);
        for (DynamicObject assGroupsOfTable : assGroupsOfTableRequire) {
            DynamicObject[] normIndctrArea;
            BigDecimal scoreSum = BigDecimal.ZERO;
            for (DynamicObject dynamicObject : normIndctrArea = this.querySingleGroupNormIndctrArea(assGroupsOfTable)) {
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    BigDecimal entryBigDecimal = entry.getBigDecimal("indctrscore");
                    scoreSum = scoreSum.add(entryBigDecimal);
                }
            }
            if (maxScore.compareTo(scoreSum) == 0) continue;
            failAssGroups.add(assGroupsOfTable);
        }
        return failAssGroups;
    }

    public DynamicObject[] querySingleGroupNormIndctrArea(DynamicObject assGroupsOfTable) {
        ArrayList<Long> areaInsIds = new ArrayList<Long>(16);
        for (DynamicObject assTableConf : assGroupsOfTable.getDynamicObjectCollection("asstableconfentry")) {
            Long areaRegId = assTableConf.getDynamicObject("area").getLong("id");
            boolean isNormIndecrArea = AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaRegId);
            if (!isNormIndecrArea) continue;
            areaInsIds.add(assTableConf.getLong("areainstance"));
        }
        return this.queryAreaAssessTable(AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId(), areaInsIds);
    }

    public boolean checkEndAssessStatus(Long activityId) {
        return ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.isExistsInProgress(activityId);
    }

    public void endActivity(Long activityId) {
        DynamicObject activityDy = this.queryActivity(activityId);
        activityDy.set("activitystatus", (Object)ActivityStatusEnum.COMPLETED.getValue());
        activityDy.set("enddate", (Object)new Date());
        this.saveActivity(new DynamicObject[]{activityDy});
    }

    public void fileActivity(DynamicObject[] dynamicObjects, Long activityId) {
        List objIds = Arrays.stream(dynamicObjects).map(dy -> dy.getPkValue()).collect(Collectors.toList());
        LOGGER.info("AssessActivityDomainService.fileActivity,activityId:{},objIds:{}", (Object)activityId, objIds);
        try (TXHandle txHandle = TX.requiresNew();){
            if (ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.isExistsEvalObj(activityId)) {
                PerfResultDomainService PERF_RESULT_DOMAIN_SERVICE = new PerfResultDomainService();
                PERF_RESULT_DOMAIN_SERVICE.savePerfResult(dynamicObjects, activityId);
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("ressyncstatus", (Object)"20");
            }
            ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject(dynamicObjects);
        }
    }

    public Map<String, Object> genAssessActivity(Date year, Date start, Date end, Long executeSchemeId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ArrayList data = new ArrayList(16);
        resultMap.put("data", data);
        resultMap.put("success", true);
        resultMap.put("errorCode", "success");
        if (year == null || start == null || end == null || executeSchemeId == null) {
            String errorMsg = ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u53ef\u751f\u6210\u8003\u6838\u6d3b\u52a8", (String)"AssessActivityDomainService_8", (String)"opmc-epa-business", (Object[])new Object[0]);
            resultMap.put("data", errorMsg);
            resultMap.put("success", false);
            resultMap.put("errorCode", "failed");
            return resultMap;
        }
        if (end.compareTo(start) > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u53ef\u751f\u6210\u8003\u6838\u6d3b\u52a8", (String)"AssessActivityDomainService_8", (String)"opmc-epa-business", (Object[])new Object[0]);
            resultMap.put("data", errorMsg);
            resultMap.put("success", false);
            resultMap.put("errorCode", "failed");
            return resultMap;
        }
        int yearInt = HRDateTimeUtils.getYear((Date)year);
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject executeSchemeDynObj = EXECUTE_SCHEME_ENTITY.loadSingle(executeSchemeId);
        DynamicObject[] schemeDynObjArr = ASSESS_SCHEME_DOMAIN_SERVICE.getSchemeArrBySchemeIdList(Collections.singletonList(executeSchemeDynObj.getLong("scheme.id")));
        List schemeStoppedNameList = Arrays.stream(schemeDynObjArr).filter(schemeDynObj -> HRStringUtils.equals((String)schemeDynObj.getString("schstatus"), (String)"20")).map(schemeDynObj -> schemeDynObj.getString("name")).collect(Collectors.toList());
        if (!schemeStoppedNameList.isEmpty()) {
            String schemeStoppedName = String.join((CharSequence)",", schemeStoppedNameList);
            String errorMsg = String.format(ResManager.loadKDString((String)"%s\u8003\u6838\u8ba1\u5212\u5df2\u7ec8\u6b62\uff0c\u4e0d\u53ef\u751f\u6210\u8003\u6838\u6d3b\u52a8", (String)"AssessActivityDomainService_9", (String)"opmc-epa-business", (Object[])new Object[0]), schemeStoppedName);
            resultMap.put("data", errorMsg);
            resultMap.put("success", false);
            resultMap.put("errorCode", "failed");
            return resultMap;
        }
        DynamicObject[] activityDynObjArr = this.queryActivityByExecuteSchemeIdList(Collections.singletonList(executeSchemeId), year);
        Map<Long, DynamicObject> executeSchemeActivityMap = Arrays.stream(activityDynObjArr).collect(Collectors.toMap(activityDynObj -> activityDynObj.getLong("executescheme.id"), activityDynObj -> activityDynObj));
        ArrayList<String> existActivityExecuteSchemeList = new ArrayList<String>(executeSchemeActivityMap.size());
        long executeId = executeSchemeDynObj.getLong("id");
        DynamicObject activityDynObj2 = executeSchemeActivityMap.get(executeId);
        if (activityDynObj2 != null) {
            existActivityExecuteSchemeList.add(executeSchemeDynObj.getString("name"));
        }
        if (!existActivityExecuteSchemeList.isEmpty()) {
            String joinStr = String.join((CharSequence)"\u3001", existActivityExecuteSchemeList);
            String errorMsg = String.format(ResManager.loadKDString((String)"%s-\u5df2\u751f\u6210\u8003\u6838\u6d3b\u52a8\u3002", (String)"AssessActivityDomainService_10", (String)"opmc-epa-business", (Object[])new Object[0]), joinStr);
            resultMap.put("data", errorMsg);
            resultMap.put("success", false);
            resultMap.put("errorCode", "failed");
            return resultMap;
        }
        String[] batchNumber = this.getBatchNumber(1);
        DynamicObject[] needSaveActivityDynObjArr = new DynamicObject[1];
        Map<Long, DynamicObject> timeTagIdDynObjMap = this.getTimeTagIdDynObjMap(Collections.singletonList(executeSchemeDynObj.getLong("timetag.id")));
        Map<Long, DynamicObject> workFlowIdDynObjMap = this.getWorkFlowDynObjMap(Collections.singletonList(executeSchemeDynObj.getLong("perfworkflow.id")));
        Map<Long, List<DynamicObject>> assessGroupIdMap = this.getAssessGroupIdDynObjMap(Collections.singletonList(executeSchemeDynObj.getLong("assessscope.id")));
        Map<Long, Long> passNodeMap = this.getPassNodeSettingValue(Collections.singletonList(executeSchemeDynObj.getLong("id")));
        DynamicObject emptyAssessActivityDynObj = this.setEmptyAssessActivityByExecuteScheme(year, start, end, yearInt, batchNumber[0], currUserId, timeTagIdDynObjMap, executeSchemeDynObj);
        this.setTimePlanEntry(workFlowIdDynObjMap, executeSchemeDynObj, emptyAssessActivityDynObj);
        this.setAssessGroupEntry(assessGroupIdMap, executeSchemeDynObj, emptyAssessActivityDynObj);
        emptyAssessActivityDynObj.set("processpermsetting", (Object)passNodeMap.get(executeSchemeDynObj.getLong("id")));
        needSaveActivityDynObjArr[0] = emptyAssessActivityDynObj;
        ActivityPermissionUtils.setActivityAndCopyFlow(needSaveActivityDynObjArr);
        this.saveActivity(needSaveActivityDynObjArr);
        return resultMap;
    }

    private Map<Long, Long> getPassNodeSettingValue(List<Long> excuteSchemeIds) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"0");
        filter.and(new QFilter("excutescheme", "in", excuteSchemeIds));
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"epa_processpermsetting", (String)"id,excutescheme.id", (QFilter[])new QFilter[]{filter}, (String)"createtime desc");
        if (datas.length > 0) {
            return Arrays.stream(datas).collect(Collectors.toMap(DynamicObject2 -> DynamicObject2.getLong("excutescheme.id"), DynamicObject2 -> DynamicObject2.getLong("id"), (key1, key2) -> key1, HashMap::new));
        }
        return new HashMap<Long, Long>();
    }

    public DynamicObject[] queryWorkFlowArr(List<Long> workFlowIdList) {
        return PERF_WORK_FLOW_ENTITY_SERVICE.query("entryentity,entryentity.node,entryentity.isshow", new QFilter("id", "in", workFlowIdList).toArray());
    }

    private Map<Long, DynamicObject> getWorkFlowDynObjMap(List<Long> workFlowIdList) {
        DynamicObject[] workFlowArr = this.queryWorkFlowArr(workFlowIdList);
        return Arrays.stream(workFlowArr).collect(Collectors.toMap(workFlowDynObj -> workFlowDynObj.getLong("id"), workFlowDynObj -> workFlowDynObj));
    }

    private Map<Long, DynamicObject> getTimeTagIdDynObjMap(List<Long> timeTagIdList) {
        DynamicObject[] timeTagArr = this.queryTimeTagArr(timeTagIdList);
        return Arrays.stream(timeTagArr).collect(Collectors.toMap(timeTagDynObj -> timeTagDynObj.getLong("id"), timeTagDynObj -> timeTagDynObj));
    }

    private DynamicObject setEmptyAssessActivityByExecuteScheme(Date year, Date start, Date end, int yearInt, String number, long currUserId, Map<Long, DynamicObject> timeTagIdDynObjMap, DynamicObject executeSchemeDynObj) {
        DynamicObject emptyAssessActivityDynObj = this.genEmptyAssessActivityDynObj();
        emptyAssessActivityDynObj.set("year", (Object)year);
        emptyAssessActivityDynObj.set("executescheme", (Object)executeSchemeDynObj);
        emptyAssessActivityDynObj.set("scheme", (Object)executeSchemeDynObj.getLong("scheme.id"));
        long timeTagId = executeSchemeDynObj.getLong("timetag.id");
        DynamicObject timeTag = timeTagIdDynObjMap.get(timeTagId);
        String period = yearInt + timeTag.getString("name");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String activityName = String.format(ResManager.loadKDString((String)"{0}{1}{2}\u8003\u6838\u6d3b\u52a8", (String)"AssessActivityDomainService_14", (String)"opmc-epa-business", (Object[])new Object[0]), sdf.format(year), executeSchemeDynObj.getString("timetag.name"), executeSchemeDynObj.getString("assessscope.name"));
        emptyAssessActivityDynObj.set("period", (Object)period);
        emptyAssessActivityDynObj.set("periodname", (Object)period);
        emptyAssessActivityDynObj.set("name", (Object)activityName);
        emptyAssessActivityDynObj.set("number", (Object)number);
        emptyAssessActivityDynObj.set("activitystatus", (Object)ActivityStatusEnum.TO_BE_EXECUTE.getValue());
        emptyAssessActivityDynObj.set("status", (Object)"C");
        emptyAssessActivityDynObj.set("enable", (Object)"1");
        emptyAssessActivityDynObj.set("creator", (Object)currUserId);
        emptyAssessActivityDynObj.set("periodstartdate", (Object)start);
        emptyAssessActivityDynObj.set("periodenddate", (Object)end);
        return emptyAssessActivityDynObj;
    }

    private void setTimePlanEntry(Map<Long, DynamicObject> workFlowIdDynObjMap, DynamicObject executeSchemeDynObj, DynamicObject emptyAssessActivityDynObj) {
        long workFlowId = executeSchemeDynObj.getLong("perfworkflow.id");
        DynamicObject workFlowDynObj = workFlowIdDynObjMap.get(workFlowId);
        DynamicObjectCollection nodeSettingColl = workFlowDynObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection timePlanEntry = emptyAssessActivityDynObj.getDynamicObjectCollection("timeplanentry");
        for (int j = 0; j < nodeSettingColl.size(); ++j) {
            DynamicObject nodeSetting = (DynamicObject)nodeSettingColl.get(j);
            if (!nodeSetting.getBoolean("isshow")) continue;
            DynamicObject timePlan = timePlanEntry.addNew();
            timePlan.set("activity", (Object)nodeSetting.getLong("node.id"));
            timePlan.set("seq", (Object)j);
        }
    }

    private void setAssessGroupEntry(Map<Long, List<DynamicObject>> assessGroupIdMap, DynamicObject executeSchemeDynObj, DynamicObject emptyAssessActivityDynObj) {
        DynamicObjectCollection assessGroupEntry = emptyAssessActivityDynObj.getDynamicObjectCollection("assgroupentry");
        long assessScopeId = executeSchemeDynObj.getLong("assessscope.id");
        List<DynamicObject> assessGroupList = assessGroupIdMap.get(assessScopeId);
        for (int j = 0; j < assessGroupList.size(); ++j) {
            DynamicObject assessGroup = assessGroupList.get(j);
            DynamicObject newAssessGroup = assessGroupEntry.addNew();
            newAssessGroup.set("assgroup", (Object)assessGroup.getLong("id"));
            newAssessGroup.set("seq", (Object)j);
        }
    }

    private Map<Long, List<DynamicObject>> getAssessGroupIdDynObjMap(List<Long> executeSchemeAssessGroupIdList) {
        DynamicObject[] assessGroupArr = ASSESS_GROUP_ENTITY_SERVICE.queryListByScopeIdList(executeSchemeAssessGroupIdList);
        return Arrays.stream(assessGroupArr).collect(Collectors.groupingBy(assessGroupDynObj -> assessGroupDynObj.getLong("objectscope.id")));
    }

    public Long queryActivitySchemeCreator(Long activityId) {
        DynamicObject activity = ACTIVITY_ENTITY.queryOne("id, scheme.creator", activityId);
        return activity.getDynamicObject("scheme").getLong("creator.id");
    }

    public DynamicObject[] queryActivityByPeriod(String activityPeriod) {
        return ACTIVITY_ENTITY.query("id", new QFilter[]{new QFilter("period", "=", (Object)activityPeriod)});
    }

    public Map<Long, List<DynamicObject>> queryActRecordByActId(List<Long> actObjIds) {
        String selectProperties = "actevalobj, assessnode, nodestatus, nodeindex, endtime, activity, createtime";
        DynamicObject[] actRecords = ACTIVITY_RECORD_ENTITY.query(selectProperties, new QFilter[]{new QFilter("actevalobj", "in", actObjIds)});
        return Arrays.stream(actRecords).collect(Collectors.groupingBy(actRecord -> actRecord.getLong("actevalobj")));
    }

    public DynamicObjectCollection queryExecuteSchemeByPeriod(String assessYear) {
        return ACTIVITY_ENTITY.queryExecuteSchemeByPeriod(assessYear);
    }

    public DynamicObject getExecuteSchemeById(Long id) {
        DynamicObject dynamicObject = ACTIVITY_ENTITY.loadSingle(id);
        QFilter schemeFilter = new QFilter("id", "=", (Object)dynamicObject.getLong("executescheme.id"));
        return EXECUTE_SCHEME_ENTITY.loadDynamicObject(new QFilter[]{schemeFilter});
    }

    public DynamicObject getSchemeById(long schemeId) {
        return ASSESS_SCHEME_ENTITY_SERVICE.loadSingle(schemeId);
    }

    public DynamicObject genEmptyAssessActivityDynObj() {
        return ACTIVITY_ENTITY.generateEmptyDynamicObject();
    }

    public DynamicObject queryPerfWorkFlow(Long activityId) {
        DynamicObject activity = ACTIVITY_ENTITY.queryOne("perfworkflow, executescheme.perfworkflow", new QFilter[]{new QFilter("id", "=", (Object)activityId)});
        if (activity == null) {
            return null;
        }
        DynamicObject perfWorkFlow = activity.getDynamicObject("perfworkflow");
        if (perfWorkFlow == null) {
            perfWorkFlow = activity.getDynamicObject("executescheme.perfworkflow");
        }
        if (perfWorkFlow == null) {
            return null;
        }
        return PERF_WORK_FLOW_ENTITY_SERVICE.queryOne(perfWorkFlow.getPkValue());
    }

    public boolean isExistActivityByExecuteSchemeId(long executeSchemeId, Date year, long activityId) {
        return ACTIVITY_ENTITY.isExistActivityByExecuteSchemeId(executeSchemeId, year, activityId);
    }

    public DynamicObject[] queryActivityByExecuteSchemeIdList(List<Long> executeSchemeIdList, Date year) {
        return ACTIVITY_ENTITY.queryActivityByExecuteSchemeIdList(executeSchemeIdList, year);
    }

    public DynamicObject queryAssessFormByActId(Long activityId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)activityId)};
        DynamicObject activityDy = ACTIVITY_ENTITY.queryOne("id, assessform", qFilters);
        return ObjectUtils.isEmpty((Object)activityDy) ? null : activityDy.getDynamicObject("assessform");
    }

    public boolean checkSumRecord(Long activityId) {
        QFilter activityFilter = new QFilter("activity", "=", (Object)activityId);
        QFilter nodeFilter = new QFilter("assessnode", "=", (Object)NodeTabMapEnum.PERF_SUM.getNodeId());
        DynamicObject[] record = ACTIVITY_RECORD_ENTITY.query("actevalobj", new QFilter[]{activityFilter, nodeFilter});
        List actObjIds = Arrays.stream(record).map(dy -> dy.getLong("actevalobj")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", actObjIds);
        QFilter statusFilter = new QFilter("assessstaus", "!=", (Object)AssessStausEnum.Exited.getStatus());
        return EPA_ACTEVALOBJ.isExists(new QFilter[]{idFilter, statusFilter});
    }

    public DynamicObject queryAssessFormByActivityId(Long activityId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)activityId)};
        DynamicObject activityDy = ACTIVITY_ENTITY.queryOne("id, assessform.id", qFilters);
        return ASSESS_FORM_ENTITY_SERVICE.queryOne("id,evasumlimit,limitminratio,limitmaxratio,scorecalcway,numaccuracy", activityDy.getLong("assessform.id"));
    }

    public Long getMaxNodeIdByActivity(long activityId) {
        Long maxNodeId = 0L;
        DynamicObject activityObj = ACTIVITY_ENTITY.queryOne("timeplanentry,timeplanentry.activity", activityId);
        if (activityObj != null) {
            DynamicObjectCollection timeplanentry = activityObj.getDynamicObjectCollection("timeplanentry");
            maxNodeId = timeplanentry.stream().max(Comparator.comparing(obj -> obj.getDynamicObject("activity").getLong("id"))).map(obj -> obj.getDynamicObject("activity").getLong("id")).orElse(0L);
        }
        return maxNodeId;
    }

    public void rebuildActivityTimeplanEntry(Long activityId) {
        DynamicObject activityObj = ACTIVITY_ENTITY.queryOne(activityId);
        DynamicObjectCollection perfWorkflowEntryEntity = activityObj.getDynamicObjectCollection("perfworkflow.entryentity");
        if (CollectionUtils.isNotEmpty((Collection)perfWorkflowEntryEntity)) {
            DynamicObjectCollection timeplanEntry = activityObj.getDynamicObjectCollection("timeplanentry");
            timeplanEntry.clear();
            int i = 0;
            for (DynamicObject entry : perfWorkflowEntryEntity) {
                if (!entry.getBoolean("isshow")) continue;
                DynamicObject timeplanObj = timeplanEntry.addNew();
                timeplanObj.set("activity", entry.get("node"));
                timeplanObj.set("seq", (Object)i++);
            }
            activityObj.set("timeplanentry", (Object)timeplanEntry);
            ACTIVITY_ENTITY.saveOne(activityObj);
        }
    }

    public DynamicObject copyWorkFlow(DynamicObject perfWorkFlowDyn, Long activityId) {
        Long id = ORM.create().genLongId("epa_perfworkflow");
        DynamicObject newPerfWorkFlow = PERF_WORK_FLOW_ENTITY_SERVICE.generateEmptyDynamicObject();
        HashSet<String> ignoreKeys = new HashSet<String>(Collections.singletonList("id"));
        ignoreKeys.add("bsled");
        HRDynamicObjectUtils.copy((DynamicObject)perfWorkFlowDyn, (DynamicObject)newPerfWorkFlow, ignoreKeys);
        newPerfWorkFlow.set("id", (Object)id);
        newPerfWorkFlow.set("boid", (Object)id);
        LocalDateTime currentTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String currentTimeString = currentTime.format(formatter);
        String number = newPerfWorkFlow.getString("number") + currentTimeString;
        newPerfWorkFlow.set("number", (Object)number);
        newPerfWorkFlow.set("activityid", (Object)activityId);
        newPerfWorkFlow.set("iscurrentversion", (Object)1);
        DynamicObjectCollection flowEntrys = newPerfWorkFlow.getDynamicObjectCollection("flowentry");
        DynamicObjectCollection showNodes = perfWorkFlowDyn.getDynamicObjectCollection("entryentity");
        List nodes = showNodes.stream().filter(data -> data.getBoolean("isshow")).map(data -> data.getLong("node.id")).collect(Collectors.toList());
        flowEntrys.removeIf(e -> !e.getBoolean("isenable") || !nodes.contains(e.getLong("passnode")));
        Set workflowIds = flowEntrys.stream().map(p -> p.getLong("flowid")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"0").and("boid", "in", workflowIds).and(new QFilter("publishstatus", "=", (Object)"20"));
        DynamicObject[] oldWorkflows = WORK_FLOW_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{qFilter});
        Set copyFlowIds = Arrays.stream(oldWorkflows).map(e -> e.getLong("id")).collect(Collectors.toSet());
        flowEntrys.removeIf(e -> !copyFlowIds.contains(e.getLong("flowvid")));
        List procIds = new ArrayList(10);
        if (oldWorkflows.length > 0) {
            procIds = Arrays.stream(oldWorkflows).map(p -> p.getDynamicObjectCollection("entryentity").stream().map(q -> q.getLong("flowdefproc")).collect(Collectors.toList())).reduce((a, b) -> {
                a.addAll(b);
                return a;
            }).get();
            long[] oldDefIds = ORM.create().genLongIds("pbs_flowdefproc", oldWorkflows.length);
            DynamicObject[] oldFlowDefs = FLOW_DEF_PROC_DOMAIN_SERVICE.getFlowDefProc(procIds);
            FLOW_DEF_PROC_ENTITY_SERVICE.save(AssessActivityDomainService.copyFlowDefs(oldFlowDefs, oldDefIds));
            HashMap<Long, Long> oldNewDefIdMap = new HashMap<Long, Long>(oldFlowDefs.length);
            int k = 0;
            for (DynamicObject oldFlowDef : oldFlowDefs) {
                oldNewDefIdMap.put(oldFlowDef.getLong("id"), oldDefIds[k++]);
            }
            long[] newFlowIds = ORM.create().genLongIds("pbs_workflow", oldWorkflows.length);
            AssessActivityDomainService.saveHis(this.copyWorkFlows(oldWorkflows, newFlowIds, oldNewDefIdMap), "pbs_workflow");
            HashMap<Long, Long> oldNewFlowIdMap = new HashMap<Long, Long>(oldWorkflows.length);
            int i = 0;
            for (DynamicObject oldWorkFlow : oldWorkflows) {
                oldNewFlowIdMap.put(oldWorkFlow.getLong("id"), newFlowIds[i++]);
            }
            AssessActivityDomainService.updateWorkFlowEntryCache(flowEntrys, oldNewFlowIdMap);
        }
        AssessActivityDomainService.saveHis(new DynamicObject[]{newPerfWorkFlow}, "epa_perfworkflow");
        return newPerfWorkFlow;
    }

    protected static DynamicObject[] copyFlowDefs(DynamicObject[] flowDefProc, long[] defIds) {
        DynamicObject[] newFlowDefs = new DynamicObject[flowDefProc.length];
        int i = 0;
        for (DynamicObject oldFlowDef : flowDefProc) {
            DynamicObject newFlowDef = FLOW_DEF_PROC_ENTITY_SERVICE.generateEmptyDynamicObject();
            HashSet<String> ignoreKeys = new HashSet<String>(Collections.singletonList("id"));
            HRDynamicObjectUtils.copy((DynamicObject)oldFlowDef, (DynamicObject)newFlowDef, ignoreKeys);
            long id = defIds[i];
            newFlowDef.set("id", (Object)id);
            newFlowDefs[i] = newFlowDef;
            ++i;
        }
        return newFlowDefs;
    }

    public DynamicObject[] copyWorkFlows(DynamicObject[] workflows, long[] flowIds, Map<Long, Long> oldNewDefIdMap) {
        int flowEntrySize = Arrays.stream(workflows).mapToInt(p -> p.getDynamicObjectCollection("entryentity").size()).sum();
        long[] flowEntryIds = DBServiceHelper.genLongIds((String)"t_pbs_workflowentry", (int)flowEntrySize);
        DynamicObject[] newWorkflows = new DynamicObject[workflows.length];
        int i = 0;
        for (DynamicObject oldWorkFlow : workflows) {
            DynamicObject newWorkflow = WORK_FLOW_ENTITY_SERVICE.generateEmptyDynamicObject();
            HashSet<String> ignoreKeys = new HashSet<String>(Arrays.asList("id", "boid", "masterid", "entryboid", "bsled", "sourcevid"));
            HRDynamicObjectUtils.copy((DynamicObject)oldWorkFlow, (DynamicObject)newWorkflow, ignoreKeys);
            newWorkflows[i] = newWorkflow;
            long id = flowIds[i];
            newWorkflow.set("id", (Object)id);
            newWorkflow.set("boid", (Object)id);
            newWorkflow.set("iscurrentversion", (Object)"1");
            newWorkflow.set("sourceflowid", (Object)oldWorkFlow.getLong("id"));
            for (DynamicObject aFlowEntry : newWorkflow.getDynamicObjectCollection("entryentity")) {
                aFlowEntry.set("id", (Object)flowEntryIds[--flowEntrySize]);
                aFlowEntry.set("entryboid", (Object)flowEntryIds[flowEntrySize]);
                aFlowEntry.set("flowdefproc", (Object)oldNewDefIdMap.get(aFlowEntry.getLong("flowdefproc")));
            }
            ++i;
        }
        return newWorkflows;
    }

    protected static void updateWorkFlowEntryCache(DynamicObjectCollection flowEntrys, Map<Long, Long> oldNewFlowIdMap) {
        int i = 0;
        long[] newPerfFlowEntryIds = DBServiceHelper.genLongIds((String)"t_epa_perfworklowentry", (int)flowEntrys.size());
        for (DynamicObject entry : flowEntrys) {
            Long newFlowId = oldNewFlowIdMap.get(entry.getLong("flowvid"));
            entry.set("sourceentryid", (Object)entry.getLong("flowvid"));
            entry.set("flowid", (Object)newFlowId);
            entry.set("flowvid", (Object)newFlowId);
            long newPerfFlowEntryId = newPerfFlowEntryIds[i++];
            entry.set("entryboidflow", (Object)newPerfFlowEntryId);
            entry.set("id", (Object)newPerfFlowEntryId);
        }
    }

    public void deleteAssessTable(DynamicObject areaReg, long instanceId) {
        if (ObjectUtils.isEmpty((Object)areaReg)) {
            return;
        }
        Long areaRegId = areaReg.getLong("id");
        if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            GEN_AREA_INSTANCE_ENTITY.deleteOne(instanceId);
        } else if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            ADD_SUB_AREA_INS_ENTITY.deleteOne(instanceId);
        } else if (areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) {
            ATTACH_AREA_INS_ENTITY.deleteOne(instanceId);
        }
    }

    public static HisResponse<VersionChangeRespData> saveHis(DynamicObject[] hisDyns, String entityNumber) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(Boolean.TRUE.booleanValue());
        hisVersionParamBo.setAtomicTrans(Boolean.TRUE.booleanValue());
        hisVersionParamBo.setEntityNumber(entityNumber);
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(hisDyns);
        return HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
    }

    public Long copyDynamicpermission(Long processpermsetting, DynamicObject copyWorkFlow, DynamicObject copyAssessForm, Long assessFormId) {
        DynamicObject permDyn = dynamixcPermitService.queryOne((Object)processpermsetting);
        Long id = ORM.create().genLongId("epa_dynamicpermission");
        DynamicObject activityPermDyn = dynamixcPermitService.generateEmptyDynamicObject();
        HashSet<String> ignoreKeys = new HashSet<String>(Collections.singletonList("id"));
        ignoreKeys.add("assessform");
        ignoreKeys.add("perfworkflow");
        HRDynamicObjectUtils.copy((DynamicObject)permDyn, (DynamicObject)activityPermDyn, ignoreKeys);
        DynamicObjectCollection flowentries = copyWorkFlow.getDynamicObjectCollection("flowentry");
        Map<Long, DynamicObject> flowEntryMap = flowentries.stream().collect(Collectors.toMap(k -> k.getLong("sourceEntryId"), v -> v));
        DynamicObjectCollection perconfigentries = activityPermDyn.getDynamicObjectCollection("perconfigentry");
        activityPermDyn.set("assessform", (Object)copyAssessForm);
        activityPermDyn.set("perfworkflow", (Object)copyWorkFlow);
        activityPermDyn.set("bindtype", (Object)"2");
        HashMap<Long, Long> assessFormRelation = new HashMap<Long, Long>();
        if (copyAssessForm != null && assessFormId != 0L) {
            DynamicObject oldassessForm = ASSESS_FORM_ENTITY_SERVICE.loadSingle(assessFormId);
            DynamicObjectCollection areaConfEntries = copyAssessForm.getDynamicObjectCollection("areaconfentry");
            DynamicObjectCollection oldAreaConfEnties = oldassessForm.getDynamicObjectCollection("areaconfentry");
            for (DynamicObject oldAreaConfEntry : oldAreaConfEnties) {
                for (DynamicObject areaConfEntry : areaConfEntries) {
                    if (oldAreaConfEntry.getLong("areaconf") != areaConfEntry.getLong("source")) continue;
                    assessFormRelation.put(oldAreaConfEntry.getLong("areaconf"), areaConfEntry.getLong("areaconf"));
                }
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            HashMap<Long, Long> nodeDefRelation = new HashMap<Long, Long>();
            for (int i = 0; i < perconfigentries.size(); ++i) {
                long areapageId;
                DynamicObject perconfigentry = (DynamicObject)perconfigentries.get(i);
                String mainconfiguration = perconfigentry.getString("mainconfiguration");
                Map mainconfigurationMap = (Map)mapper.readValue(mainconfiguration, Map.class);
                if (perconfigentry.getLong("passnodeid") == 1L || perconfigentry.getLong("passnodeid") == 4L) {
                    DynamicObjectCollection nodeDefDyns = FLOW_DEF_NODE_ENTITY_SERVICE.getAllNodeDefByWorkflowId(Long.valueOf(perconfigentry.getLong("flowvid")));
                    if (flowEntryMap.get(perconfigentry.getLong("flowvid")) == null) {
                        perconfigentries.remove((Object)perconfigentry);
                        --i;
                        continue;
                    }
                    Long newFlowVid = flowEntryMap.get(perconfigentry.getLong("flowvid")).getLong("flowvid");
                    DynamicObjectCollection newnodeDefDyns = FLOW_DEF_NODE_ENTITY_SERVICE.getAllNodeDefByWorkflowId(newFlowVid);
                    if (nodeDefRelation.get(perconfigentry.getLong("flowdefnodeid")) == null) {
                        for (DynamicObject nodeDefDyn : nodeDefDyns) {
                            for (DynamicObject newnodeDefDyn : newnodeDefDyns) {
                                if (!newnodeDefDyn.getString("nodename").equals(nodeDefDyn.getString("nodename"))) continue;
                                nodeDefRelation.put(nodeDefDyn.getLong("id"), newnodeDefDyn.getLong("id"));
                            }
                        }
                    }
                    perconfigentry.set("flowvid", (Object)newFlowVid);
                    perconfigentry.set("flowdefnodeid", nodeDefRelation.get(perconfigentry.getLong("flowdefnodeid")));
                }
                if (assessFormRelation.size() <= 0 || mainconfigurationMap.get("areapageInsId") == null) continue;
                Object value = mainconfigurationMap.get("areapageId");
                long l = areapageId = value instanceof Integer ? ((Integer)value).longValue() : ((Long)value).longValue();
                if (areapageId == 1L) {
                    mainconfigurationMap.put("areapageInsId", copyAssessForm.getLong("empinfoconf"));
                } else if (areapageId == 5L) {
                    mainconfigurationMap.put("areapageInsId", copyAssessForm.getLong("sumconf"));
                } else if (areapageId == 1960097310314606592L) {
                    mainconfigurationMap.put("areapageInsId", 1960097310314606592L);
                    mainconfigurationMap.put("areapageId", 1960097310314606592L);
                } else {
                    mainconfigurationMap.put("areapageInsId", assessFormRelation.get(mainconfigurationMap.get("areapageInsId")));
                }
                perconfigentry.set("mainconfiguration", (Object)JSON.toJSONString((Object)mainconfigurationMap));
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error("update dynamicpermission failed " + (Object)((Object)e));
        }
        activityPermDyn.set("id", (Object)id);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{activityPermDyn});
        return id;
    }

    public DynamicObject copyAssessForm(Long assessFormId, Long activityId) {
        if (assessFormId == null || assessFormId == 0L) {
            return null;
        }
        DynamicObject newAessessForm = ASSESS_FORM_ENTITY_SERVICE.generateEmptyDynamicObject();
        Long id = ORM.create().genLongId("epa_assessform");
        DynamicObject oldassessForm = ASSESS_FORM_ENTITY_SERVICE.loadSingle(assessFormId);
        HashSet<String> ignoreKeys = new HashSet<String>(Collections.singletonList("id"));
        ignoreKeys.add("bsled");
        HRDynamicObjectUtils.copy((DynamicObject)oldassessForm, (DynamicObject)newAessessForm, ignoreKeys);
        newAessessForm.set("id", (Object)id);
        newAessessForm.set("boid", (Object)id);
        LocalDateTime currentTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String currentTimeString = currentTime.format(formatter);
        String number = newAessessForm.getString("number") + currentTimeString;
        newAessessForm.set("number", (Object)number);
        newAessessForm.set("activity", (Object)activityId);
        newAessessForm.set("iscurrentversion", (Object)1);
        DynamicObjectCollection areaConfEntryColl = new DynamicObjectCollection();
        DynamicObjectCollection oldareaConfEntryColl = oldassessForm.getDynamicObjectCollection("areaconfentry");
        HashMap<Long, Integer> normalAreaIdAndSeqMap = new HashMap<Long, Integer>(16);
        HashMap<Long, Integer> plusAreaIdAndSeqMap = new HashMap<Long, Integer>(16);
        HashMap<Long, Integer> customAreaIdAndSeqMap = new HashMap<Long, Integer>(16);
        HashMap<Long, Integer> attchAreaIdAndSeqMap = new HashMap<Long, Integer>(16);
        HashMap<Long, DynamicObject> arearegMap = new HashMap<Long, DynamicObject>(16);
        for (int seq = 0; seq < oldareaConfEntryColl.size(); ++seq) {
            DynamicObject areaConfDynObj = (DynamicObject)oldareaConfEntryColl.get(seq);
            String areaRegNumber = areaConfDynObj.getString("areareg.number");
            if ("epa_normindctrarea".equals(areaRegNumber)) {
                normalAreaIdAndSeqMap.put(areaConfDynObj.getLong("areaconf"), seq);
            } else if ("epa_plusminusarea".equals(areaRegNumber)) {
                plusAreaIdAndSeqMap.put(areaConfDynObj.getLong("areaconf"), seq);
            } else if ("epa_customarea".equals(areaRegNumber)) {
                customAreaIdAndSeqMap.put(areaConfDynObj.getLong("areaconf"), seq);
            } else if ("epa_attacharea".equals(areaRegNumber)) {
                attchAreaIdAndSeqMap.put(areaConfDynObj.getLong("areaconf"), seq);
            }
            arearegMap.put(areaConfDynObj.getLong("areaconf"), areaConfDynObj.getDynamicObject("areareg"));
        }
        this.copyNormalArea(areaConfEntryColl, normalAreaIdAndSeqMap, arearegMap, "epa_normalconf");
        this.copyPlusArea(areaConfEntryColl, plusAreaIdAndSeqMap, arearegMap, "epa_plusminusconf");
        this.copyCustomArea(areaConfEntryColl, customAreaIdAndSeqMap, arearegMap, "epa_customareaconf");
        this.copyAttchArea(areaConfEntryColl, attchAreaIdAndSeqMap, arearegMap, "epa_attachconf");
        newAessessForm.set("areaconfentry", (Object)areaConfEntryColl);
        this.copySumConfArea(newAessessForm);
        this.copyEmpConfArea(newAessessForm);
        AssessActivityDomainService.saveHis(new DynamicObject[]{newAessessForm}, "epa_assessform");
        return newAessessForm;
    }

    private void copyPlusArea(DynamicObjectCollection areaConfEntryColl, Map<Long, Integer> normalAreaIdAndSeqMap, Map<Long, DynamicObject> normalArearegMap, String entryNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entryNumber);
        this.saveEntryData(areaConfEntryColl, normalAreaIdAndSeqMap, normalArearegMap, serviceHelper);
    }

    private void copyAttchArea(DynamicObjectCollection areaConfEntryColl, Map<Long, Integer> normalAreaIdAndSeqMap, Map<Long, DynamicObject> normalArearegMap, String entryNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entryNumber);
        this.saveEntryData(areaConfEntryColl, normalAreaIdAndSeqMap, normalArearegMap, serviceHelper);
    }

    private void copyCustomArea(DynamicObjectCollection areaConfEntryColl, Map<Long, Integer> normalAreaIdAndSeqMap, Map<Long, DynamicObject> normalArearegMap, String entryNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entryNumber);
        this.saveEntryData(areaConfEntryColl, normalAreaIdAndSeqMap, normalArearegMap, serviceHelper);
    }

    private void copyNormalArea(DynamicObjectCollection areaConfEntryColl, Map<Long, Integer> normalAreaIdAndSeqMap, Map<Long, DynamicObject> normalArearegMap, String entryNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entryNumber);
        this.saveEntryData(areaConfEntryColl, normalAreaIdAndSeqMap, normalArearegMap, serviceHelper);
    }

    private void saveEntryData(DynamicObjectCollection areaConfEntryColl, Map<Long, Integer> normalAreaIdAndSeqMap, Map<Long, DynamicObject> normalArearegMap, HRBaseServiceHelper serviceHelper) {
        Object[] saveIdArr;
        DynamicObject[] areaFieldDynObjArr = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", normalAreaIdAndSeqMap.keySet())});
        HashMap<Long, Long> areaConfIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, DynamicObject> areaConfIdAndDynObjMap = new HashMap<Long, DynamicObject>(16);
        long[] normalAreaIdArr = DB.genGlobalLongIds((int)areaFieldDynObjArr.length);
        for (int i = 0; i < areaFieldDynObjArr.length; ++i) {
            DynamicObject areaFieldDynObj = areaFieldDynObjArr[i];
            DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
            HashSet<String> ignoreCopyFieldSet = new HashSet<String>(4);
            ignoreCopyFieldSet.add("id");
            HRDynamicObjectUtils.copy((DynamicObject)areaFieldDynObj, (DynamicObject)emptyDynamicObject, ignoreCopyFieldSet);
            emptyDynamicObject.set("id", (Object)normalAreaIdArr[i]);
            areaConfIdMap.put(emptyDynamicObject.getLong("id"), areaFieldDynObj.getLong("id"));
            areaConfIdAndDynObjMap.put(areaFieldDynObj.getLong("id"), emptyDynamicObject);
        }
        for (Object savedAreaConfDynObj : saveIdArr = serviceHelper.save(areaConfIdAndDynObjMap.values().toArray(new DynamicObject[0]))) {
            DynamicObject entrydyn = ASSESS_FORM_ENTITY_SERVICE.generateEmptyEntryDynamicObject("areaconfentry");
            DynamicObject dynObj = (DynamicObject)savedAreaConfDynObj;
            Long oldAreaConfId = (Long)areaConfIdMap.get(dynObj.getLong("id"));
            Integer seq = normalAreaIdAndSeqMap.get(oldAreaConfId);
            entrydyn.set("source", (Object)oldAreaConfId);
            entrydyn.set("areaconf", (Object)dynObj.getLong("id"));
            entrydyn.set("seq", (Object)(seq + 1));
            entrydyn.set("areareg", (Object)normalArearegMap.get(oldAreaConfId));
            areaConfEntryColl.add((Object)entrydyn);
        }
    }

    private void copySumConfArea(DynamicObject newAessessForm) {
        HRBaseServiceHelper sumServiceHelper = new HRBaseServiceHelper("epa_sumconf");
        long sumConfId = newAessessForm.getLong("sumconf");
        DynamicObject sumConfDynObj = sumServiceHelper.loadSingle((Object)sumConfId);
        DynamicObject emptySumConfDynObj = sumServiceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)sumConfDynObj, (DynamicObject)emptySumConfDynObj);
        Object sumPerfLevelObj = newAessessForm.get("sumperflevel");
        if (sumPerfLevelObj == null) {
            DynamicObjectCollection entryColl = emptySumConfDynObj.getDynamicObjectCollection("entryentity");
            entryColl.removeIf(next -> next.getLong("areafield.id") == 1539882034862772224L);
        }
        Object savedSumConfDynObj = sumServiceHelper.saveOne(emptySumConfDynObj);
        newAessessForm.set("sumconf", (Object)((DynamicObject)savedSumConfDynObj).getLong("id"));
    }

    private void copyEmpConfArea(DynamicObject newAessessForm) {
        HRBaseServiceHelper sumServiceHelper = new HRBaseServiceHelper("epa_empinfoconf");
        long empConfId = newAessessForm.getLong("empinfoconf");
        DynamicObject empConfDynObj = sumServiceHelper.loadSingle((Object)empConfId);
        DynamicObject emptyEmpConfDynObj = sumServiceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)empConfDynObj, (DynamicObject)emptyEmpConfDynObj);
        Object savedSumConfDynObj = sumServiceHelper.saveOne(emptyEmpConfDynObj);
        newAessessForm.set("empinfoconf", (Object)((DynamicObject)savedSumConfDynObj).getLong("id"));
    }

    public DynamicObject loadAssessFrom(Object pk) {
        return ASSESS_FORM_ENTITY_SERVICE.loadSingle(pk);
    }

    public Map<Long, DynamicObject> getAssessFromByActivityIds(List<Long> ids) {
        DynamicObject[] dynamicObjects = ACTIVITY_ENTITY.queryAssessFormByActivity(ids);
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dyx -> dyx.getLong("id"), dyx -> dyx.getDynamicObject("assessform")));
    }

    public Map<Long, Map<Long, Long>> queryAssessFormByActIds(List<Long> activitySubDynGroupIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", activitySubDynGroupIds)};
        DynamicObject[] activities = ACTIVITY_ENTITY.queryOriginalArray("id,assessform", qFilters);
        List assessformIds = Arrays.stream(activities).map(dyx -> dyx.getLong("assessform")).collect(Collectors.toList());
        Map<Long, Long> actFormMap = Arrays.stream(activities).collect(Collectors.toMap(act1 -> act1.getLong("id"), act2 -> act2.getLong("assessform"), (act1, act2) -> act1));
        QFilter qFilter = new QFilter("areaconfentry.source", "!=", (Object)0).and(new QFilter("id", "in", assessformIds));
        DynamicObject[] assessForm = ASSESS_FORM_ENTITY_SERVICE.queryOriginalArray("id, areaconfentry.areaconf, areaconfentry.source", new QFilter[]{qFilter});
        Map formAreaMap = Arrays.stream(assessForm).collect(Collectors.groupingBy(form -> form.getLong("id"), Collectors.toList()));
        HashMap ret = Maps.newHashMapWithExpectedSize((int)actFormMap.size());
        for (Map.Entry<Long, Long> entry : actFormMap.entrySet()) {
            List areaConfList = formAreaMap.get(entry.getValue());
            HashMap areaMap = Maps.newHashMapWithExpectedSize((int)areaConfList.size());
            for (DynamicObject area : areaConfList) {
                areaMap.put(area.getLong("areaconfentry.source"), area.getLong("areaconfentry.areaconf"));
            }
            ret.put(entry.getKey(), areaMap);
        }
        return ret;
    }

    public Map<String, Object> fileActivity(List<Long> evalObjIds, Long activityId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ArrayList data = new ArrayList(16);
        resultMap.put("data", data);
        resultMap.put("success", true);
        resultMap.put("errorCode", "success");
        DynamicObject[] dynamicObjects = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.loadDynamicObjectArray(evalObjIds.toArray(new Long[0]));
        ArrayList<DynamicObject> toFileList = new ArrayList<DynamicObject>(16);
        for (DynamicObject dynObj : dynamicObjects) {
            String assessStatus = dynObj.getString("assessstaus");
            String ressyncStatus = dynObj.getString("ressyncstatus");
            String personInfo = dynObj.getString("person.name") + " " + dynObj.getString("person.number");
            HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
            if (!AssessStausEnum.COMPLETED.getStatus().equals(assessStatus)) {
                errorMap.put(dynObj.getLong("id"), ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u201c{0}\u201d\uff1a\u5df2\u4e0d\u5728\u8003\u6838\u5b8c\u6210\u72b6\u6001", (String)"AssessActivityDomainService_12", (String)"opmc-epa-business", (Object[])new Object[]{personInfo}));
                data.add(errorMap);
                resultMap.put("success", false);
                resultMap.put("errorCode", "failed");
                continue;
            }
            if ("20".equals(ressyncStatus)) {
                errorMap.put(dynObj.getLong("id"), ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u201c{0}\u201d\uff1a\u7ed3\u679c\u5df2\u5f52\u6863", (String)"AssessActivityDomainService_13", (String)"opmc-epa-business", (Object[])new Object[]{personInfo}));
                data.add(errorMap);
                resultMap.put("success", false);
                resultMap.put("errorCode", "failed");
                continue;
            }
            toFileList.add(dynObj);
        }
        if (!toFileList.isEmpty()) {
            this.fileActivity(toFileList.toArray(new DynamicObject[0]), activityId);
        }
        return resultMap;
    }

    public void finishActivity(List<Long> activityIds) {
        Object[] dynamicObjects = ACTIVITY_ENTITY.loadDynamicObjectArray(activityIds.toArray(new Long[0]));
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        for (Object dynamicObject : dynamicObjects) {
            dynamicObject.set("activitystatus", (Object)ActivityStatusEnum.COMPLETED.getValue());
            dynamicObject.set("enddate", (Object)new Date());
        }
        ACTIVITY_ENTITY.save((DynamicObject[])dynamicObjects);
    }
}

