/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.activitymanage.entityservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.OpmcEntityService;

public class ActivityEvaluationObjectEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("epa_actevalobj");

    public static ActivityEvaluationObjectEntityService getInstance() {
        return ServiceFactory.getService(ActivityEvaluationObjectEntityService.class);
    }

    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject queryActivityEvaluationObjectById(Long actevalobjId) {
        return this.loadSingle(actevalobjId);
    }

    public DynamicObject[] queryActivityEvaluationObjectActivityId(String selectFields, Long activityId) {
        if (ObjectUtils.isEmpty((Object)activityId)) {
            return new DynamicObject[0];
        }
        if (HRStringUtils.isEmpty((String)selectFields)) {
            selectFields = "id";
        }
        return this.query(selectFields, new QFilter[]{new QFilter("activity.id", "=", (Object)activityId)});
    }

    public DynamicObject[] queryActivityEvaluationObjectById(String selectFields, List<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return new DynamicObject[0];
        }
        if (HRStringUtils.isEmpty((String)selectFields)) {
            selectFields = "id";
        }
        return this.query(selectFields, new QFilter[]{new QFilter("id", "in", ids)});
    }

    public DynamicObject[] listActObjStatusByActivityIds(List<Long> activityIds) {
        QFilter qFilter = new QFilter("activity.id", "in", activityIds).and("assessstaus", "!=", (Object)AssessStausEnum.Exited.getStatus());
        return this.queryOriginalArray("activity.id, assessstaus", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryListByActIdExceptExit(Long activityId) {
        String selectFields = "id, assessstaus, nodeindex, assessnode, nodestatus";
        QFilter filter = new QFilter("activity", "=", (Object)activityId);
        QFilter statusFilter = new QFilter("assessstaus", "!=", (Object)AssessStausEnum.Exited.getStatus());
        return this.queryOriginalArray(selectFields, new QFilter[]{filter, statusFilter});
    }

    public DynamicObject[] queryListByActId(Long activityId) {
        String selectFields = "id, assessstaus, nodeindex, assessnode, nodestatus, ressyncstatus, iscurperiod";
        QFilter filter = new QFilter("activity", "=", (Object)activityId);
        return this.queryOriginalArray(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryNodeStatusByActId(Long activityId, Integer nodeIndex) {
        String selectFields = "id, assessstaus, nodeindex, assessnode, nodestatus";
        ArrayList<Integer> nodeIndexList = new ArrayList<Integer>(2);
        nodeIndexList.add(nodeIndex);
        if (nodeIndex > 1) {
            nodeIndex = nodeIndex - 1;
            nodeIndexList.add(nodeIndex);
        }
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and("assessstaus", "=", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus()).and("nodeindex", "in", nodeIndexList);
        return this.queryOriginalArray(selectFields, new QFilter[]{filter});
    }

    public boolean queryAssFlowExistsByActivityId(Long activityId, Long groupId, Long flowId) {
        QFilter qFilter = new QFilter("activity.id", "=", (Object)activityId).and("assgroup.id", "=", (Object)groupId).and("evalflow", "=", (Object)flowId);
        return this.isExists(new QFilter[]{qFilter});
    }

    public boolean queryAssGroupEvaObjExistsByActivityId(Long activityId, Long groupId) {
        QFilter qFilter = new QFilter("activity.id", "=", (Object)activityId).and("assgroup.id", "=", (Object)groupId);
        return this.isExists(new QFilter[]{qFilter});
    }

    public Integer queryMaxProgressNodeStatusByActId(Long activityId, List<Integer> nodeIndexs) {
        if (this.isExists(new QFilter("activity", "=", (Object)activityId).and("assessstaus", "=", (Object)AssessStausEnum.COMPLETED.getStatus()))) {
            return Collections.max(nodeIndexs);
        }
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and("assessstaus", "=", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus()).and("nodeindex", "in", nodeIndexs);
        Object[] queryOriginalArray = this.queryOriginalArray("nodeindex", new QFilter[]{filter}, " nodeindex desc ");
        if (HRArrayUtils.isNotEmpty((Object[])queryOriginalArray)) {
            return queryOriginalArray[0].getInt("nodeindex");
        }
        return null;
    }

    public boolean isExistsInProgress(Long activityId) {
        ArrayList<String> inProgressStatus = new ArrayList<String>(2);
        inProgressStatus.add(AssessStausEnum.JOINED.getStatus());
        inProgressStatus.add(AssessStausEnum.HAVE_IN_HAND.getStatus());
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and("assessstaus", "in", inProgressStatus);
        return this.isExists(new QFilter[]{filter});
    }

    public boolean isExistsEvalObj(Long activityId) {
        QFilter filter = new QFilter("activity", "=", (Object)activityId);
        QFilter exitedFilter = new QFilter("assessstaus", "!=", (Object)AssessStausEnum.Exited.getStatus());
        return this.isExists(new QFilter[]{filter, exitedFilter});
    }

    public boolean queryExistsByActAndOrg(Set<Long> actIds, Set<Long> orgIds) {
        QFilter filter = new QFilter("activity", "in", actIds).and("affiliateadminorg", "in", orgIds);
        return this.isExists(filter);
    }

    public DynamicObject queryObjForCompleteEval(Long pkId) {
        String selectPro = "assessnode, nodestatus, assessstaus, nodeindex, activity.timeplanentry, modifier, modifytime, completetime, perffile.sourcevid, perffilev, evalfinishtype";
        return this.queryOne(selectPro, pkId);
    }

    public DynamicObject queryForCalcProcResult(Long pkId) {
        return this.queryOne("atcs, atcl, soat, leveloat, soatsource, soac, loac, sop, lop, sopsource, fsop, flop, fsopsource, modifier, modifytime, areaentry.areareg, areaentry.areains, activity.assessform, evalflowins, assessyear, assessperiod, activity, perforg, evalfinishtype,fsopscoresystem,floplevel", pkId);
    }

    public DynamicObject queryForCalcNodeResult(Long pkId) {
        return this.queryOne("activity.assessform, areaentry.areareg, areaentry.areains, evalflowins, assessyear, assessperiod, activity, perforg", pkId);
    }

    public DynamicObject[] queryEvaObjByActivityId(Long activityId) {
        String selectFields = "id, perffile";
        QFilter filter = new QFilter("activity", "=", (Object)activityId);
        return this.query(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryByPkValues(Object[] primaryKeyValues) {
        String selectFields = "id, assessstaus, assgroup, modifytime , modifier, evalflow, nodeindex, assessnode, nodestatus, person.number, person.name, evalflowins, activity, ressyncstatus, evalfinishtype";
        QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
        return this.query(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryAllFieldsByPkValues(Object[] primaryKeyValues) {
        QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
        return this.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public DynamicObject[] queryAreaByPkValues(Object[] primaryKeyValues) {
        String selectFields = "id, activity, employee , person,perffile, empposrel , areaentry.seq, areaentry.areareg, areaentry.areains, areaentry.areaconf";
        QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
        return this.query(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryActiviByPk(Object[] primaryKeyValues) {
        String selectFields = "id,activity";
        QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
        return this.query(selectFields, new QFilter[]{filter});
    }

    public int queryAssessCompleteCountByActId(Long activityId) {
        QFilter qFilter = new QFilter("activity", "=", (Object)activityId).and("assessstaus", "=", (Object)AssessStausEnum.COMPLETED.getStatus());
        return this.count("epa_actevalobj", new QFilter[]{qFilter});
    }

    public int queryAssHaveInHandOrCompleteCountByActId(Long activityId, Long nodeId, Set<String> nodeStatus) {
        QFilter qFilter = new QFilter("activity", "=", (Object)activityId).and("nodestatus", "in", nodeStatus).and("assessnode", "=", (Object)nodeId);
        return this.count("epa_actevalobj", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryToBeEvalObjs(Long activityId, int nodeIndex, Long nodeId, String nodeStatus) {
        QFilter qFilter = new QFilter("activity", "=", (Object)activityId).and("nodestatus", "=", (Object)nodeStatus).and("assessnode", "=", (Object)nodeId).and("nodeindex", "=", (Object)nodeIndex);
        return this.query("id, evalflow, perffile, person, empposrel.position, affiliateadminorg, empposrel.company,evalflowins", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryPerffilevOrgIdById(List<Long> actevalobjIdList) {
        return this.query("id,perffile.adminorg.id", new QFilter("id", "in", actevalobjIdList).toArray());
    }

    public DynamicObject[] queryFormulatingObjs(Long activityId) {
        return this.query("id, formulateflow", new QFilter[]{this.buildFormulatingEvaObjFilter(activityId)});
    }

    public DynamicObject[] queryTobeFormulateObjs(Long activityId) {
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and("assessstaus", "=", (Object)AssessStausEnum.JOINED.getStatus());
        String selectPro = "id, formulateflow, perffile, person, empposrel.position, affiliateadminorg, empposrel.company, formulateflowins";
        return this.query(selectPro, new QFilter[]{filter});
    }

    public boolean isExistsFormulateMonitorEvaObjByActivityId(Long activityId) {
        Tuple<QFilter, QFilter> filter = this.buildFormulateMonitorEvaObjFilter(activityId);
        return this.isExists(new QFilter[]{(QFilter)filter.item1, (QFilter)filter.item2});
    }

    private Tuple<QFilter, QFilter> buildFormulateMonitorEvaObjFilter(Long activityId) {
        QFilter actNFormulate = new QFilter("activity", "=", (Object)activityId).and("formulateflow", "!=", (Object)0);
        QFilter status = new QFilter("nodestatus", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus()).and("assessnode", "=", (Object)Long.valueOf(ProcessManageApEnum.TARGET_FORMULATING.getLabId())).and("nodeindex", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId()).or(new QFilter("nodestatus", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus()).and("assessnode", "=", (Object)Long.valueOf(ProcessManageApEnum.TARGET_FORMULATED.getLabId())).and("nodeindex", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId()));
        return Tuple.create((Object)actNFormulate, (Object)status);
    }

    private QFilter buildFormulatingEvaObjFilter(Long activityId) {
        return new QFilter("activity", "=", (Object)activityId).and("nodestatus", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus()).and("assessnode", "=", (Object)Long.valueOf(ProcessManageApEnum.TARGET_FORMULATING.getLabId())).and("nodeindex", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
    }

    public DynamicObject[] queryEvalObjsByIndicGroupId(long indicGroupId) {
        QFilter filter = new QFilter("indigroup", "=", (Object)indicGroupId);
        return this.query("id,assweight,assscore,areaentry.areareg,areaentry.areains,activity", new QFilter[]{filter});
    }

    public DynamicObject[] queryActivityEvaluationObjectsByIds(Long[] actevalobjIds) {
        return this.loadDynamicObjectArray(actevalobjIds);
    }

    public DynamicObject[] queryActEvalObjByIds(List<Long> evalObjIds) {
        QFilter idFilter = new QFilter("id", "in", evalObjIds);
        return this.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    public DynamicObject getNodeIdByActIdAndIndex(Long activityId, Object nodeIndex) {
        QFilter filter1 = new QFilter("activity", "=", (Object)activityId);
        QFilter filter2 = new QFilter("nodeindex", "=", nodeIndex);
        return this.queryOne("id, assessnode", new QFilter[]{filter1, filter2});
    }

    public DynamicObject[] queryPersonByObjIds(List<Long> ids) {
        String selectFields = "id,person.number, person.name";
        QFilter filter = new QFilter("id", "in", ids);
        return this.query(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryByObjIds(List<Long> actEvalObjIdList) {
        QFilter filter = new QFilter("id", "in", actEvalObjIdList);
        return this.query("isincalc", new QFilter[]{filter});
    }

    public boolean isExitActivityObjByActivity(Long activityId) {
        QFilter qFilter = new QFilter("activity", "=", (Object)activityId);
        return this.isExists(qFilter);
    }

    public DynamicObject[] queryFormulateMonitorObjs(Long activityId) {
        Tuple<QFilter, QFilter> filter = this.buildFormulateMonitorEvaObjFilter(activityId);
        return this.query("id, formulateflow", new QFilter[]{(QFilter)filter.item1, (QFilter)filter.item2});
    }

    public DynamicObject[] queryByActivityIds(String selectFields, List<Long> activityIds) {
        QFilter filter = new QFilter("activity.id", "in", activityIds).and("assessstaus", "!=", (Object)AssessStausEnum.Exited.getStatus());
        return this.query(selectFields, new QFilter[]{filter});
    }

    public int queryCurrNodeAndPreNodeCompletedCount(Long activityId, Long preNodeId, Long currNodeId) {
        QFilter preFilter = null;
        preFilter = 0L != preNodeId ? new QFilter("activity", "=", (Object)activityId).and("assessnode", "=", (Object)preNodeId).and("nodestatus", "=", (Object)AssessStausEnum.COMPLETED.getStatus()) : new QFilter("activity", "=", (Object)activityId).and("assessstaus", "=", (Object)"10");
        QFilter currFilter = new QFilter("activity", "=", (Object)activityId).and("assessnode", "=", (Object)5L).and("nodestatus", "=", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
        QFilter unionFilter = preFilter.or(currFilter);
        return this.count("epa_actevalobj", new QFilter[]{unionFilter});
    }

    public DynamicObject[] queryMpByObjIds(List<Long> objIds) {
        String selectFields = "ismprmodify, mprule, mprealrule, mprsource";
        QFilter filter = new QFilter("id", "in", objIds);
        return this.query(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryUpgradeDatas() {
        String selectFields = "cfsopscoresystem, cfloplevel, fsopscoresystem, floplevel, activity.assessform";
        QFilter sopFilter = new QFilter("fsopscoresystem", "=", (Object)0L).or("fsopscoresystem", "is null", (Object)"");
        QFilter lopfilter = new QFilter("floplevel", "=", (Object)0L).or("floplevel", "is null", (Object)"");
        return this.query(selectFields, new QFilter[]{sopFilter, lopfilter});
    }
}

