/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.activitymanage.entityservice;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.OpmcEntityService;

public class ActivityObjRecordEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("epa_actobjrecord");

    public static ActivityObjRecordEntityService getInstance() {
        return ServiceFactory.getService(ActivityObjRecordEntityService.class);
    }

    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject queryEvalRecord(Long evalObjId) {
        String selectPro = "endtime, nodestatus, modifier, modifytime";
        QFilter evalObjIdFilter = new QFilter("actevalobj", "=", (Object)evalObjId).and("assessnode", "=", (Object)AssessNodeStatusEnum.EVALUATING.getNodeId()).and("nodestatus", "=", (Object)AssessNodeStatusEnum.EVALUATING.getStatus());
        DynamicObject activityRecord = this.queryOne(selectPro, evalObjIdFilter);
        if (ObjectUtils.isEmpty((Object)activityRecord)) {
            throw new KDException(new ErrorCode("completeEvaluate", ResManager.loadKDString((String)"\u6d3b\u52a8\u8bb0\u5f55\u8868\u4e2d\u4e0d\u5b58\u5728\uff1a\u7ee9\u6548\u8bc4\u4f30-\u8bc4\u4f30\u4e2d\u7684\u6d3b\u52a8\u8bb0\u5f55", (String)"ActivityObjRecordEntityService_0", (String)"opmc-epa-business", (Object[])new Object[0])), new Object[0]);
        }
        return activityRecord;
    }

    public DynamicObject[] queryActRecordByObjIds(List<Long> actObjIds) {
        String selectProperties = "actevalobj, assessnode, nodestatus, nodeindex, endtime, activity, createtime, starttype";
        return this.query(selectProperties, new QFilter[]{new QFilter("actevalobj", "in", actObjIds)});
    }

    public DynamicObject[] queryActRecordByObjIdsAndNodeId(List<Long> actObjIds, Long nodeId) {
        String selectProperties = "actevalobj, assessnode, nodestatus, nodeindex, endtime, activity, createtime, starttype";
        QFilter objFilter = new QFilter("actevalobj", "in", actObjIds);
        QFilter nodeFilter = new QFilter("assessnode", "in", (Object)nodeId);
        return this.query(selectProperties, new QFilter[]{objFilter, nodeFilter});
    }

    public Map<Long, List<DynamicObject>> queryActRecordByActObjIds(List<Long> actObjIds) {
        String selectProperties = "actevalobj, assessnode, nodestatus, nodeindex, endtime, activity, createtime, starttype";
        DynamicObject[] actRecords = this.query(selectProperties, new QFilter[]{new QFilter("actevalobj", "in", actObjIds)});
        return Arrays.stream(actRecords).collect(Collectors.groupingBy(actRecord -> actRecord.getLong("actevalobj")));
    }

    public Map<Long, List<DynamicObject>> queryRecordByActObjsAndActId(List<Long> actObjIds, Long activityId) {
        String selectProperties = "actevalobj, assessnode, nodestatus, nodeindex, endtime, activity, createtime, starttype,modifier,modifytime";
        QFilter evalObjIdFilter = new QFilter("actevalobj", "in", actObjIds).and("activity", "=", (Object)activityId).and("assessnode", "=", (Object)AssessNodeStatusEnum.EVALUATING.getNodeId()).and("nodestatus", "=", (Object)AssessNodeStatusEnum.EVALUATING.getStatus());
        DynamicObject[] actRecords = this.query(selectProperties, new QFilter[]{evalObjIdFilter});
        return Arrays.stream(actRecords).collect(Collectors.groupingBy(actRecord -> actRecord.getLong("actevalobj")));
    }

    public List<Long> queryEvaluatedObjIdByActivityId(Long activityId) {
        String selectProperties = "actevalobj";
        QFilter evalObjIdFilter = new QFilter("activity", "=", (Object)activityId).and("assessnode", "=", (Object)AssessNodeStatusEnum.EVALUATED.getNodeId()).and("nodestatus", "=", (Object)AssessNodeStatusEnum.EVALUATED.getStatus());
        DynamicObject[] actRecords = this.query(selectProperties, new QFilter[]{evalObjIdFilter});
        return Arrays.stream(actRecords).map(item -> item.getLong("actevalobj")).collect(Collectors.toList());
    }

    public DynamicObject queryLastestRecord(String selectProperties, Long evalObjId, AssessNodeStatusEnum assessNodeStatusEnum) {
        QFilter evalObjIdFilter = new QFilter("actevalobj", "=", (Object)evalObjId).and("assessnode", "=", (Object)assessNodeStatusEnum.getNodeId()).and("nodestatus", "=", (Object)assessNodeStatusEnum.getStatus());
        Object[] activityRecord = this.query(selectProperties, new QFilter[]{evalObjIdFilter}, "createtime desc");
        if (ObjectUtils.isEmpty((Object[])activityRecord)) {
            throw new KDException(new ErrorCode("not found tobeconfirm user", ResManager.loadKDString((String)"\u6d3b\u52a8\u8bb0\u5f55\u8868\u4e2d\u4e0d\u5b58\u5728\uff1a\u7ed3\u679c\u786e\u8ba4-\u786e\u8ba4\u4e2d\u7684\u6d3b\u52a8\u8bb0\u5f55", (String)"ActivityObjRecordEntityService_1", (String)"opmc-epa-business", (Object[])new Object[0])), new Object[0]);
        }
        return activityRecord[0];
    }

    public DynamicObject[] queryRecordsByEvalIdAndNodeId(Long evalObjId, Long nodeId) {
        QFilter evalObjIdFilter = new QFilter("actevalobj", "=", (Object)evalObjId).and("assessnode", "=", (Object)nodeId);
        Object[] activityRecords = this.query("ose,ole,nodestatus,nodeindex,endtime,description", new QFilter[]{evalObjIdFilter}, "createtime");
        if (ObjectUtils.isEmpty((Object[])activityRecords)) {
            throw new KDException(new ErrorCode("not found confirm record", ResManager.loadKDString((String)"\u6d3b\u52a8\u8bb0\u5f55\u8868\u4e2d\u4e0d\u5b58\u5728\uff1a\u7ed3\u679c\u786e\u8ba4\u786e\u8ba4\u8bb0\u5f55", (String)"ActivityObjRecordEntityService_2", (String)"opmc-epa-business", (Object[])new Object[0])), new Object[0]);
        }
        return activityRecords;
    }

    public List<Long> queryEvalObjIdByActivityIdAndNode(Long activityId, AssessNodeStatusEnum assessNodeStatusEnum) {
        String selectProperties = "actevalobj";
        QFilter evalObjIdFilter = new QFilter("activity", "=", (Object)activityId).and("assessnode", "=", (Object)assessNodeStatusEnum.getNodeId()).and("nodestatus", "=", (Object)assessNodeStatusEnum.getStatus());
        DynamicObject[] actRecords = this.query(selectProperties, new QFilter[]{evalObjIdFilter});
        return Arrays.stream(actRecords).map(item -> item.getLong("actevalobj")).collect(Collectors.toList());
    }

    public List<Long> queryFormulatedObjIdByActivityId(Long activityId) {
        String selectProperties = "actevalobj";
        QFilter evalObjIdFilter = new QFilter("activity", "=", (Object)activityId).and("assessnode", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId()).and("nodestatus", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus());
        DynamicObject[] actRecords = this.queryOriginalArray(selectProperties, new QFilter[]{evalObjIdFilter});
        return Arrays.stream(actRecords).map(item -> item.getLong("actevalobj")).collect(Collectors.toList());
    }

    public List<Long> queryPerfSummaryedObjIdByActivityId(Long activityId) {
        String selectProperties = "actevalobj";
        QFilter evalObjIdFilter = new QFilter("activity", "=", (Object)activityId).and("assessnode", "=", (Object)AssessNodeStatusEnum.MPED.getNodeId()).and("nodestatus", "=", (Object)AssessNodeStatusEnum.MPED.getStatus());
        DynamicObject[] actRecords = this.queryOriginalArray(selectProperties, new QFilter[]{evalObjIdFilter});
        return Arrays.stream(actRecords).map(item -> item.getLong("actevalobj")).collect(Collectors.toList());
    }

    public int deleteRecordByEvalObjIdsAndNodeId(List<Long> evalObjIds, Long nodeId) {
        QFilter evalObjIdFilter = new QFilter("assessnode", "=", (Object)nodeId).and("actevalobj", "in", evalObjIds);
        return this.deleteByFilter(new QFilter[]{evalObjIdFilter});
    }

    public List<Long> queryEvaluatedObj(Long activityId) {
        QFilter evalObjIdFilter = new QFilter("activity", "=", (Object)activityId).and("assessnode", "=", (Object)AssessNodeStatusEnum.EVALUATING.getNodeId());
        DynamicObject[] actRecords = this.queryOriginalArray("actevalobj", new QFilter[]{evalObjIdFilter});
        return Arrays.stream(actRecords).map(item -> item.getLong("actevalobj")).collect(Collectors.toList());
    }

    public List<Long> queryUnifiedDistEvalObj() {
        String selectProperties = "actevalobj";
        QFilter evalObjIdFilter = new QFilter("assessnode", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId()).and("nodestatus", "in", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus()).and("nodeindex", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
        DynamicObject[] actRecords = this.queryOriginalArray(selectProperties, new QFilter[]{evalObjIdFilter});
        return Arrays.stream(actRecords).map(item -> item.getLong("actevalobj")).collect(Collectors.toList());
    }
}

