/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.activitymanage.enums;

import java.util.ArrayList;
import java.util.List;

public enum ProcessManageApEnum {
    JOINED("joinedap", "-2", "epa_actevalobjjoined"),
    HAVE_IN_HAND("inhandap", "-2", "epa_actevalobjinhand"),
    COMPLETED("completedap", "-2", "epa_actevalobjcompleted"),
    ADD_EXITEDAP("exitedap", "-2", "epa_actevalobjexited"),
    ADD("joinedap", "-6", "epa_actevalobjjoined"),
    ADD_PLAN_PART("planpartap", "-6", "epa_actevalobjexited"),
    PLAN_PART("planpartap", "-3", "epa_actevalobjnotjoins"),
    TO_BE_FORMULATED("tobeformulatedap", "1", "epa_tobetargetformulate"),
    TARGET_FORMULATING("formulatingap", "1", "epa_targetformulating"),
    TARGET_FORMULATED("formulatedap", "1", "epa_targetformulated"),
    TO_BE_EVALUATED("tobeevaluatedap", "4", "epa_tobeevaluated"),
    EVALUATING("evaluatingap", "4", "epa_evaluating"),
    EVALUATED("evaluatedap", "4", "epa_evaluated"),
    TO_BE_CONFIRMED("tobeconfirmedap", "8", "epa_tobeconfirmed"),
    CONFIRMING("confirmingap", "8", "epa_confirming"),
    CONFIRMED("confirmedap", "8", "epa_confirmed"),
    TO_BE_PERFORMSUM("toperformsum", "5", "epa_tobeperfsum"),
    PERFORMSUMED("performsumed", "5", "epa_perfsumed"),
    ASSESS_COMPLETED("assesscompletedap", "-1", "epa_actcompleted"),
    COOPERATOR("coorganizerap", "-7", "epa_cooporganizer");

    private final String tab;
    private final String labId;
    private final String formId;

    private ProcessManageApEnum(String tab, String labId, String formId) {
        this.tab = tab;
        this.labId = labId;
        this.formId = formId;
    }

    public static String getFormIdByTab(String tab) {
        for (ProcessManageApEnum apEnum : ProcessManageApEnum.values()) {
            if (!apEnum.tab.equals(tab)) continue;
            return apEnum.formId;
        }
        return null;
    }

    public static String getLabIdByTab(String tab) {
        for (ProcessManageApEnum apEnum : ProcessManageApEnum.values()) {
            if (!apEnum.tab.equals(tab)) continue;
            return apEnum.labId;
        }
        return null;
    }

    public static List<String> getTabsByLabId(String labId) {
        ArrayList<String> tabs = new ArrayList<String>(10);
        for (ProcessManageApEnum apEnum : ProcessManageApEnum.values()) {
            if (!apEnum.labId.equals(labId)) continue;
            tabs.add(apEnum.tab);
        }
        return tabs;
    }

    public static ProcessManageApEnum getProcessManageApByTab(String tab) {
        for (ProcessManageApEnum apEnum : ProcessManageApEnum.values()) {
            if (!apEnum.tab.equals(tab)) continue;
            return apEnum;
        }
        return JOINED;
    }

    public String getTab() {
        return this.tab;
    }

    public String getLabId() {
        return this.labId;
    }

    public String getFormId() {
        return this.formId;
    }
}

