/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.activitymanage.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.evaladjustment.ActEvalObjAdjApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.domain.activity.service.AssessActivityDomainService;
import kd.opmc.epa.business.domain.activitymanage.entity.AcrossEvaluatorListDataBO;
import kd.opmc.epa.business.domain.activitymanage.entity.ActObjStatBo;
import kd.opmc.epa.business.domain.activitymanage.entity.EvaluatorListDataBO;
import kd.opmc.epa.business.domain.activitymanage.entity.FormulatorRoleListDataBO;
import kd.opmc.epa.business.domain.activitymanage.entity.PushResultBo;
import kd.opmc.epa.business.domain.activitymanage.entity.TaskCrossBo;
import kd.opmc.epa.business.domain.activitymanage.entity.ToBeFormulateActRecordBO;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.CoorganizerEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjCrossIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjImportScoreIndEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.RutaskIndRelationEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.EvalfinishtypeEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ObjsetscorerecordEntityService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAddSubNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjCustomAreaInsEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjGenNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.service.EvalResultCalcDomainService;
import kd.opmc.epa.business.domain.indicator.service.IndicatorGroupDomainService;
import kd.opmc.epa.business.domain.interview.entityservice.InterviewObjEntityService;
import kd.opmc.epa.business.domain.interview.enums.InterStatusEnum;
import kd.opmc.epa.business.domain.mp.entityservice.MpCalcItemEntityService;
import kd.opmc.epa.business.domain.mp.entityservice.MpRuleEntityService;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumCalResultBo;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumCalDomainService;
import kd.opmc.epa.business.domain.perfworkflow.entutyservice.PerfWorkFlowEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.enums.activitymanage.PerfSumTaskTypeEnum;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;
import kd.opmc.pbs.business.domain.workflow.dto.AssignHandlerParamDTO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRollbackResultBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskIndEntryService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.UserTypeEnum;
import kd.opmc.pbs.business.domain.workflow.model.CrossScoreParamsBo;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;
import kd.opmc.pbs.business.domain.workflow.service.CrossScoreDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowAssistDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.domain.workflow.vo.AssignHandlerVO;
import kd.opmc.pbs.business.domain.workflow.vo.QueryHandlerVO;
import kd.opmc.pbs.business.domain.workflow.vo.ReminderVO;
import kd.opmc.pbs.business.external.hrcs.IHRCSTipService;
import kd.opmc.pbs.business.external.hrpi.IDepempService;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;
import kd.opmc.pbs.common.utils.ListUtils;
import kd.opmc.pmd.business.domain.perffile.entityservice.PerffileEntityService;

public class ActEvalObjManageDomainService {
    private static final Log LOG = LogFactory.getLog(ActEvalObjManageDomainService.class);
    private static final ActivityEvaluationObjectEntityService ACT_EVAL_OBJ_ENTITY_SERVICE = ActivityEvaluationObjectEntityService.getInstance();
    private static final IHRCSTipService IHRCS_TIP_SERVICE = IHRCSTipService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final AssessActivityDomainService ACTIVITY_DOMAIN_SERVICE = AssessActivityDomainService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final FlowDefProcEntityService FLOW_DEF_PROC_ENTITY_SERVICE = FlowDefProcEntityService.getInstance();
    private static final FlowRuNodeEntityService NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    private static final FlowRuRoleEntityService ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    private static final FlowRuTaskEntityService TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY = AssessActivityEntityService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_OBJ_RECORD = ActivityObjRecordEntityService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final FlowHandlerDomainService FLOW_HANDLER_DOMAIN_SERVICE = FlowHandlerDomainService.getInstance();
    private static final ObjCrossIndicatorEntityService OBJ_CROSS_INDICATOR_ENTITY_SERVICE = ObjCrossIndicatorEntityService.getInstance();
    private static final FlowHandlerBatchDomainService FLOW_HANDLER_BATCH_DOMAIN_SERVICE = FlowHandlerBatchDomainService.getInstance();
    private static final CrossScoreDomainService CROSS_SCORE_DOMAIN_SERVICE = CrossScoreDomainService.getInstance();
    private static final FlowDefRoleEntityService FLOW_DEF_ROLE_ENTITY_SERVICE = FlowDefRoleEntityService.getInstance();
    private static final RutaskIndRelationEntityService RUTASK_IND_RELATION_ENTITY_SERVICE = RutaskIndRelationEntityService.getInstance();
    private static final ObjAddSubAreaInsEntityService OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE = ObjAddSubAreaInsEntityService.getInstance();
    private static final ObjGenAreaInsEntityService OBJ_GEN_AREA_INS_ENTITY_SERVICE = ObjGenAreaInsEntityService.getInstance();
    private static final ObjGenAreaIndicatorEntityService OBJ_GEN_AREA_INDICATOR_ENTITY_SERVICE = ObjGenAreaIndicatorEntityService.getInstance();
    private static final ObjAddSubAreaIndicatorEntityService OBJ_ADD_SUB_AREA_INDICATOR_ENTITY_SERVICE = ObjAddSubAreaIndicatorEntityService.getInstance();
    private static final ObjCustomAreaInsEntityService OBJ_CUSTOM_AREA_INS_ENTITY_SERVICE = ObjCustomAreaInsEntityService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY = ExecuteSchemeEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final ObjImportScoreIndEntityService IMPORT_SCORE_IND_ENTITY_SERVICE = ObjImportScoreIndEntityService.getInstance();
    private static final ActEvalObjAdjApplicationService ACT_EVAL_OBJ_ADJ_APPLICATION_SERVICE = ActEvalObjAdjApplicationService.getInstance();
    private static final InterviewObjEntityService INTERVIEW_OBJ_ENTITY_SERVICE = InterviewObjEntityService.getInstance();
    private static final CoorganizerEntityService COORGANIZER_ENTITY_SERVICE = CoorganizerEntityService.getInstance();
    private static final String[] CUSTOM_AREA_ALL_FIELDS = new String[]{"customfield1", "customfield2", "customfield3", "customfield5", "customfield6", "customfield7", "customfield8", "customfield4", "customfield9", "customfield10"};
    private static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    private static final FlowDefNodeEntityService FLOW_DEF_NODE_ENTITY_SERVICE = FlowDefNodeEntityService.getInstance();
    private static final PerffileEntityService PERFFILE_ENTITY_SERVICE = PerffileEntityService.getInstance();
    private static final ObjNodeResEntityService OBJ_NODE_RES_ENTITY_SERVICE = ObjNodeResEntityService.getInstance();
    private static final ObjGenNodeResEntityService OBJ_GEN_NODE_RES_ENTITY_SERVICE = ObjGenNodeResEntityService.getInstance();
    private static final ObjAddSubNodeResEntityService OBJ_ADD_SUB_NODE_RES_ENTITY_SERVICE = ObjAddSubNodeResEntityService.getInstance();
    private static final EvalResultCalcDomainService EVAL_RESULT_CALC_DOMAIN_SERVICE = EvalResultCalcDomainService.getInstance();
    private static final ObjsetscorerecordEntityService OBJSETSCORERECORD_ENTITY_SERVICE = ObjsetscorerecordEntityService.getInstance();
    private static final IDepempService DEPEMP_SERVICE = IDepempService.getInstance();
    private static final IHRPIPersonService PERSON_SERVICE = IHRPIPersonService.getInstance();
    private static final FlowAssistDomainService FLOW_ASSIST_DOMAIN_SERVICE = FlowAssistDomainService.getInstance();
    private static final MpCalcItemEntityService MP_CALC_ITEM_ENTITY_SERVICE = MpCalcItemEntityService.getInstance();
    private static final MpRuleEntityService MP_RULE_ENTITY_SERVICE = MpRuleEntityService.getInstance();
    private static final FlowRuTaskIndEntryService FLOW_RU_TASK_IND_ENTRY_SERVICE = FlowRuTaskIndEntryService.getInstance();
    private static final PerfWorkFlowEntityService PERF_WORK_FLOW_ENTITY_SERVICE = PerfWorkFlowEntityService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY_SERVICE = PerfLevelEntityService.getInstance();

    public static ActEvalObjManageDomainService getInstance() {
        return ServiceFactory.getService(ActEvalObjManageDomainService.class);
    }

    public Map<Long, ActObjStatBo> countActObjStatusByActivityIds(List<Long> activityIds) {
        DynamicObject[] dynamicObjects;
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)activityIds.size());
        for (DynamicObject dynamicObject : dynamicObjects = ACT_EVAL_OBJ_ENTITY_SERVICE.listActObjStatusByActivityIds(activityIds)) {
            Long activityId = dynamicObject.getLong("activity.id");
            String assessStatus = dynamicObject.getString("assessstaus");
            if (countMap.containsKey(activityId)) {
                ((ActObjStatBo)countMap.get(activityId)).countActObj(assessStatus);
                continue;
            }
            countMap.put(activityId, new ActObjStatBo().countActObj(assessStatus));
        }
        return countMap;
    }

    public Map<String, Integer> queryCountByActId(Long activityId, DynamicObjectCollection entryEntity) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        HashMap<String, Integer> completeMap = new HashMap<String, Integer>(16);
        DynamicObject[] objects = ACT_EVAL_OBJ_ENTITY_SERVICE.queryListByActIdExceptExit(activityId);
        int seq = 1;
        int completedCount = 0;
        int joined = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            map.put(String.valueOf(seq), 0);
            completeMap.put(String.valueOf(seq), 0);
            ++seq;
        }
        for (DynamicObject object : objects) {
            if (AssessStausEnum.HAVE_IN_HAND.getStatus().equals(object.getString("assessstaus"))) {
                int nodeIndex = object.getInt("nodeindex");
                Integer count = (Integer)map.get(String.valueOf(nodeIndex));
                Integer complteCount = (Integer)completeMap.get(String.valueOf(nodeIndex));
                if (count != null && !"30".equals(object.getString("nodestatus"))) {
                    count = count + 1;
                    map.put(String.valueOf(nodeIndex), count);
                }
                if (complteCount == null || !"30".equals(object.getString("nodestatus"))) continue;
                complteCount = complteCount + 1;
                completeMap.put(String.valueOf(nodeIndex), complteCount);
                continue;
            }
            if (AssessStausEnum.COMPLETED.getStatus().equals(object.getString("assessstaus"))) {
                ++completedCount;
                continue;
            }
            if (!AssessStausEnum.JOINED.getStatus().equals(object.getString("assessstaus"))) continue;
            ++joined;
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String preKey = Integer.toString(Integer.parseInt(key) - 1);
            if (completeMap.get(preKey) == null) continue;
            Integer count = (Integer)entry.getValue() + (Integer)completeMap.get(preKey);
            entry.setValue(count);
        }
        map.put("completed", completedCount);
        map.put("joinflexparticipated", objects.length);
        map.put("joined", joined);
        return map;
    }

    public Map<String, Integer> queryJoinInCountByActId(Long activityId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        DynamicObject[] objects = ACT_EVAL_OBJ_ENTITY_SERVICE.queryListByActId(activityId);
        int joinedCount = 0;
        int inHandCount = 0;
        int completedCount = 0;
        int exited = 0;
        for (DynamicObject object : objects) {
            String status = object.getString("assessstaus");
            if (AssessStausEnum.JOINED.getStatus().equals(status)) {
                ++joinedCount;
                continue;
            }
            if (AssessStausEnum.HAVE_IN_HAND.getStatus().equals(status)) {
                ++inHandCount;
                continue;
            }
            if (AssessStausEnum.COMPLETED.getStatus().equals(status)) {
                ++completedCount;
                continue;
            }
            if (!AssessStausEnum.Exited.getStatus().equals(status)) continue;
            ++exited;
        }
        map.put("joined", joinedCount);
        map.put("haveInHand", inHandCount);
        map.put("completed", completedCount);
        map.put("exited", exited);
        return map;
    }

    public Map<String, Integer> queryNodeCountByActId(Long activityId, Integer nodeIndex, Long nodeId) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>(16);
        DynamicObject[] objects = ACT_EVAL_OBJ_ENTITY_SERVICE.queryNodeStatusByActId(activityId, nodeIndex);
        List nodeStatusList = AssessNodeStatusEnum.getNodeStatusList((Long)nodeId);
        QFilter completed = new QFilter("assessnode", ">", (Object)nodeId);
        completed.or(new QFilter("assessstaus", "=", (Object)AssessStausEnum.COMPLETED.getStatus()));
        QFilter currentNodeCompleted = new QFilter("assessnode", "=", (Object)nodeId);
        currentNodeCompleted.and(new QFilter("nodestatus", "=", (Object)"30"));
        completed.or(currentNodeCompleted);
        completed.and(new QFilter("activity", "=", (Object)activityId));
        List<Long> objIds = ACT_EVAL_OBJ_ADJ_APPLICATION_SERVICE.queryFormulatedObjIdByActivityId(activityId);
        int farmolateCount = ACT_EVAL_OBJ_ENTITY_SERVICE.count("epa_actevalobj", new QFilter[]{new QFilter("id", "in", objIds)});
        List<Long> evaobjIds = ACT_EVAL_OBJ_ADJ_APPLICATION_SERVICE.queryEvaluatedObjIdByActivityId(activityId);
        int evalCount = ACT_EVAL_OBJ_ENTITY_SERVICE.count("epa_actevalobj", new QFilter[]{new QFilter("id", "in", evaobjIds)});
        int completeCount = ACT_EVAL_OBJ_ENTITY_SERVICE.count("epa_actevalobj", new QFilter[]{completed});
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        DynamicObject activity = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(activityId);
        String status = activity.getString("activitystatus");
        DynamicObjectCollection timePlanEntry = activity.getDynamicObjectCollection("timeplanentry");
        for (DynamicObject object : objects) {
            String key = object.getInt("nodeindex") + object.getString("nodestatus");
            Integer count = (Integer)countMap.get(key);
            if (count == null) {
                countMap.put(key, 1);
                continue;
            }
            count = count + 1;
            countMap.put(key, count);
        }
        for (AssessNodeStatusEnum assessNodeStatusEnum : nodeStatusList) {
            String nodeStatus = assessNodeStatusEnum.getStatus();
            String key = nodeIndex > 1 && assessNodeStatusEnum.isFirstStatus() ? nodeIndex - 1 + "30" : nodeIndex + assessNodeStatusEnum.getStatus();
            if (countMap.get(key) != null) {
                resultMap.put(assessNodeStatusEnum.getLabelName(), (Integer)countMap.get(key));
            } else {
                resultMap.put(assessNodeStatusEnum.getLabelName(), 0);
            }
            if (HRStringUtils.equals((String)"30", (String)nodeStatus)) {
                if (HRStringUtils.equals((String)assessNodeStatusEnum.getLabelName(), (String)AssessNodeStatusEnum.TARGET_FORMULATED.getLabelName())) {
                    resultMap.put(assessNodeStatusEnum.getLabelName(), farmolateCount);
                } else if (HRStringUtils.equals((String)assessNodeStatusEnum.getLabelName(), (String)AssessNodeStatusEnum.EVALUATED.getLabelName())) {
                    resultMap.put(assessNodeStatusEnum.getLabelName(), evalCount);
                } else {
                    resultMap.put(assessNodeStatusEnum.getLabelName(), completeCount);
                }
            }
            if (!ActivityStatusEnum.EXECUTING.getValue().equals(status) || timePlanEntry.size() != nodeIndex.intValue() || !assessNodeStatusEnum.isLastStatus()) continue;
            int count = ACT_EVAL_OBJ_ENTITY_SERVICE.queryAssessCompleteCountByActId(activityId);
            resultMap.put(assessNodeStatusEnum.getLabelName(), count);
        }
        return resultMap;
    }

    public Tuple<Boolean, Boolean> queryIsLastNodeNActEnd(Long actId, AssessNodeStatusEnum assessNodeStatusEnum) {
        DynamicObject activity = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(actId);
        DynamicObjectCollection timePlanEntry = activity.getDynamicObjectCollection("timeplanentry");
        boolean isLastNode = ((DynamicObject)timePlanEntry.get(timePlanEntry.size() - 1)).getLong("activity.index") == assessNodeStatusEnum.getNodeId().longValue();
        boolean activityEnd = ActivityStatusEnum.COMPLETED.getValue().equals(activity.getString("activitystatus"));
        return new Tuple((Object)isLastNode, (Object)activityEnd);
    }

    public int getNowNodeIndex(Long activityId) {
        DynamicObject[] objects = ACT_EVAL_OBJ_ENTITY_SERVICE.queryListByActId(activityId);
        int index = Arrays.stream(objects).max(Comparator.comparing(obj -> obj.getInt("nodeindex"))).map(obj -> obj.getInt("nodeindex")).orElse(0);
        return index;
    }

    public Map<String, Integer> queryPerformSummaryLabCount(Long activityId, Long preNodeId, Long currNodeId) {
        int notcompletedCount = ACT_EVAL_OBJ_ENTITY_SERVICE.queryCurrNodeAndPreNodeCompletedCount(activityId, preNodeId, currNodeId);
        List<Long> compeleteObj = ACTIVITY_OBJ_RECORD.queryPerfSummaryedObjIdByActivityId(activityId);
        QFilter completed = new QFilter("id", "in", compeleteObj);
        int completeCount = ACT_EVAL_OBJ_ENTITY_SERVICE.count("epa_actevalobj", new QFilter[]{completed});
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("notcompletedCount", notcompletedCount);
        result.put("completedCount", completeCount);
        return result;
    }

    public DynamicObject[] queryListByActId(Long activityId) {
        return ACT_EVAL_OBJ_ENTITY_SERVICE.queryListByActId(activityId);
    }

    public boolean queryAssFlowExistsByActivityId(Long activityId, Long groupId, Long flowId) {
        return ACT_EVAL_OBJ_ENTITY_SERVICE.queryAssFlowExistsByActivityId(activityId, groupId, flowId);
    }

    public String getTips(String key, DynamicObject dy) {
        List tips = IHRCS_TIP_SERVICE.getTips("epa_activity", key, dy);
        if (!ObjectUtils.isEmpty((Object)tips)) {
            return (String)tips.get(0);
        }
        return "";
    }

    public DynamicObject[] queryEvaObjByActivityId(Long activityId) {
        return ACT_EVAL_OBJ_ENTITY_SERVICE.queryEvaObjByActivityId(activityId);
    }

    public DynamicObject queryActivityEvaluationObjectById(Long actevalobjId) {
        return ACT_EVAL_OBJ_ENTITY_SERVICE.queryActivityEvaluationObjectById(actevalobjId);
    }

    public void saveAssessObject(DynamicObject activity, DynamicObject[] assessObjectArr) {
        new ActivityEvaluationObjectDomainService().addEvaluationObjects(assessObjectArr, activity);
    }

    public DynamicObject[] queryByPkValues(Object[] primaryKeyValues) {
        return ACT_EVAL_OBJ_ENTITY_SERVICE.queryByPkValues(primaryKeyValues);
    }

    public void endProcess(long flowId) {
        FLOW_RU_PROC_DOMAIN_SERVICE.endProcess(Long.valueOf(flowId));
    }

    public void exitObject(DynamicObject[] dataEntities) {
        ACT_EVAL_OBJ_ENTITY_SERVICE.save(dataEntities);
    }

    public void updateAssessObjGroup(Long activityId, Long groupId, Object[] pkIds) {
        DynamicObject[] evalObj = ACT_EVAL_OBJ_ENTITY_SERVICE.queryByPkValues(pkIds);
        long currUserId = RequestContext.get().getCurrUserId();
        Date modifyTime = new Date();
        for (DynamicObject assessObjectDatum : evalObj) {
            assessObjectDatum.set("assgroup", (Object)groupId);
            assessObjectDatum.set("modifytime", (Object)modifyTime);
            assessObjectDatum.set("modifier", (Object)currUserId);
        }
        ACT_EVAL_OBJ_ENTITY_SERVICE.save(evalObj);
    }

    public DynamicObject[] queryToBeEvalObjs(Long activityId, Object nodeIndex) {
        int lastIndex = Integer.parseInt(nodeIndex.toString()) - 1;
        Long nodeId = this.getNodeIdByActIdAndIndex(activityId, lastIndex);
        AssessNodeStatusEnum nodeStatusEnum = AssessNodeStatusEnum.getLastNodeStatus((Long)nodeId);
        return ACT_EVAL_OBJ_ENTITY_SERVICE.queryToBeEvalObjs(activityId, lastIndex, nodeId, nodeStatusEnum.getStatus());
    }

    public Long getNodeIdByActIdAndIndex(Long activityId, int nodeIndex) {
        DynamicObject evalNode;
        int seq;
        DynamicObject activity = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(activityId);
        DynamicObjectCollection timePlanEntry = activity.getDynamicObjectCollection("timeplanentry");
        int entrySeq = nodeIndex > 0 ? nodeIndex - 1 : ((seq = timePlanEntry.indexOf((Object)(evalNode = (DynamicObject)timePlanEntry.stream().filter(dy -> dy.getDynamicObject("activity").getLong("id") == NodeTabMapEnum.EVAL_PROCESS.getNodeId().longValue()).findAny().orElse(null)))) > 0 ? seq - 1 : 0);
        return ((DynamicObject)timePlanEntry.get(entrySeq)).getDynamicObject("activity").getLong("id");
    }

    public Map<Object, Long> getEvalFlowsMap(Long activityId, Object nodexIndex) {
        DynamicObject[] objs = this.queryToBeEvalObjs(activityId, nodexIndex);
        return Arrays.stream(objs).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("evalflow").getPkValue(), Collectors.counting()));
    }

    public DynamicObject[] queryFlowByPkValue(Set<Object> pkValues) {
        return WORK_FLOW_ENTITY_SERVICE.getWorkflowById(pkValues);
    }

    public DynamicObject queryFlowProcPkValue(Long pkValue) {
        return FLOW_DEF_PROC_ENTITY_SERVICE.getFlowDefProcByPkValue(pkValue);
    }

    public Map<Object, Long> getEvaluatingFlowsMap(Long activityId) {
        DynamicObject[] objs = this.queryNormalEvaluated(activityId);
        return Arrays.stream(objs).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("evalflow").getPkValue(), Collectors.counting()));
    }

    public DynamicObject[] queryNormalEvaluated(Long activityId) {
        List<Long> objIds = ACTIVITY_OBJ_RECORD.queryEvaluatedObj(activityId);
        List finishEval = Arrays.stream(new String[]{EvalfinishtypeEnum.FINISH_EVAL.getType(), EvalfinishtypeEnum.HANDWORK_INPUT.getType(), EvalfinishtypeEnum.NOPART_EVAL.getType()}).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", objIds).and("evalfinishtype", "not in", finishEval).and("assessstaus", "!=", (Object)AssessStausEnum.Exited.getStatus());
        return ACT_EVAL_OBJ_ENTITY_SERVICE.query("id, evalflow, evalflowins", new QFilter[]{qFilter});
    }

    public Map<Long, List<DynamicObject>> queryEvaObjByFlow(Long flowId, Long activityId) {
        List nodeStatus = Arrays.stream(new String[]{AssessNodeStatusEnum.TO_BE_EVALUATED.getStatus(), AssessNodeStatusEnum.EVALUATING.getStatus()}).collect(Collectors.toList());
        QFilter qFilter = new QFilter("activity", "=", (Object)activityId).and("nodestatus", "in", nodeStatus).and("assessnode", "=", (Object)AssessNodeStatusEnum.TO_BE_EVALUATED.getNodeId()).and("evalflow", "=", (Object)flowId);
        DynamicObject[] objDys = ACT_EVAL_OBJ_ENTITY_SERVICE.query("id, evalflowins.currentnode", new QFilter[]{qFilter});
        List nodeIds = Arrays.stream(objDys).map(dy -> dy.getLong("evalflowins.currentnode.id")).collect(Collectors.toList());
        DynamicObject[] nodeDys = NODE_ENTITY_SERVICE.query("flownodedef", new QFilter[]{new QFilter("id", "in", nodeIds)});
        Map<Long, List<DynamicObject>> objGroupByNodeMap = Arrays.stream(objDys).collect(Collectors.groupingBy(obj -> obj.getLong("evalflowins.currentnode.id")));
        HashMap<Long, List<DynamicObject>> resultMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject nodeDy : nodeDys) {
            Long nodeDefId = (Long)nodeDy.getDynamicObject("flownodedef").getPkValue();
            Long nodeId = (Long)nodeDy.getPkValue();
            List<DynamicObject> objListByNode = objGroupByNodeMap.get(nodeId);
            if (ObjectUtils.isEmpty(resultMap.get(nodeDefId))) {
                resultMap.put(nodeDefId, objListByNode);
                continue;
            }
            List objListByNodeDef = (List)resultMap.get(nodeDefId);
            objListByNodeDef.addAll(objListByNode);
            resultMap.put(nodeDefId, objListByNodeDef);
        }
        return resultMap;
    }

    public Map<Long, List<Long>> getPerffilevOrgIdById(List<Long> actevalobjIdList) {
        DynamicObject[] objs = ACT_EVAL_OBJ_ENTITY_SERVICE.queryPerffilevOrgIdById(actevalobjIdList);
        return Arrays.stream(objs).collect(Collectors.toMap(x -> x.getLong("id"), y -> {
            ArrayList<Long> adminorgIdList = new ArrayList<Long>(1);
            adminorgIdList.add(y.getLong("perffile.adminorg.id"));
            return adminorgIdList;
        }));
    }

    public Map<Long, List<Long>> queryActivityRespersonIdByIds(List<Long> actevalobjIdList) {
        DynamicObject[] objs = ACT_EVAL_OBJ_ENTITY_SERVICE.queryActivityEvaluationObjectById("id,resperson", actevalobjIdList);
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(16);
        for (int i = 0; i < objs.length; ++i) {
            List fbasedataidIdList = objs[i].getDynamicObjectCollection("resperson").stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
            Long actevalobjId = objs[i].getLong("id");
            List longList = (List)map.get(actevalobjId);
            if (longList != null && longList.size() != 0) {
                longList.addAll(fbasedataidIdList);
                map.put(actevalobjId, longList);
                continue;
            }
            map.put(actevalobjId, fbasedataidIdList);
        }
        return map;
    }

    public Map<Long, List<Long>> queryActivityCreateSchemeIdByIds(List<Long> actevalobjIdList) {
        DynamicObject[] objs = ACT_EVAL_OBJ_ENTITY_SERVICE.queryActivityEvaluationObjectById("id,activity.id", actevalobjIdList);
        List activityIdList = Arrays.stream(objs).map(x -> x.getLong("activity.id")).collect(Collectors.toList());
        Map<Long, Long> temMap = Arrays.stream(objs).collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getLong("activity.id")));
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(16);
        QFilter idFilter = new QFilter("id", "in", activityIdList);
        DynamicObject[] activity = ACTIVITY_ENTITY.query("id,scheme.creator.id", new QFilter[]{idFilter});
        for (int i = 0; i < actevalobjIdList.size(); ++i) {
            for (int j = 0; j < activity.length; ++j) {
                Long actevalobjId = actevalobjIdList.get(i);
                if (!temMap.get(actevalobjId).equals(activity[j].getLong("id"))) continue;
                map.put(actevalobjId, Collections.singletonList(activity[j].getLong("scheme.creator.id")));
            }
        }
        return map;
    }

    public Map<Long, List<Long>> queryActivityCreateIdByIds(List<Long> actevalobjIdList) {
        DynamicObject[] objs = ACT_EVAL_OBJ_ENTITY_SERVICE.queryActivityEvaluationObjectById("id,activity.creator.id", actevalobjIdList);
        return Arrays.stream(objs).collect(Collectors.toMap(x -> x.getLong("id"), y -> {
            ArrayList<Long> creatorIdList = new ArrayList<Long>(1);
            creatorIdList.add(y.getLong("activity.creator.id"));
            return creatorIdList;
        }));
    }

    public Map<Object, Long> queryFormulatingFlowsMap(Long activityId) {
        DynamicObject[] objs = ACT_EVAL_OBJ_ENTITY_SERVICE.queryFormulatingObjs(activityId);
        return Arrays.stream(objs).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("formulateflow").getPkValue(), Collectors.counting()));
    }

    public Map<Object, Long> queryTobeFormulateFlowsMap(Long activityId) {
        DynamicObject[] objs = ACT_EVAL_OBJ_ENTITY_SERVICE.queryTobeFormulateObjs(activityId);
        return Arrays.stream(objs).filter(obj -> !ObjectUtils.isEmpty((Object)obj.getDynamicObject("formulateflow"))).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("formulateflow").getPkValue(), Collectors.counting()));
    }

    public boolean isExistsFormulateMonitorEvaObjByActivityId(Long activityId) {
        return ACT_EVAL_OBJ_ENTITY_SERVICE.isExistsFormulateMonitorEvaObjByActivityId(activityId);
    }

    public List<String> validateTaskOfReturnEval(List<Object> taskIdList) {
        boolean failStatus;
        QFilter idFilter = new QFilter("id", "in", taskIdList);
        DynamicObject[] taskDys = TASK_ENTITY_SERVICE.query("flowruproc.actevalobj, flowrurole.flowdefrole, taskstatus", new QFilter[]{idFilter});
        Map<Long, List<DynamicObject>> groupByObjMap = Arrays.stream(taskDys).collect(Collectors.groupingBy(task -> task.getLong("flowruproc.actevalobj")));
        Map<Long, List<DynamicObject>> groupByRoleMap = Arrays.stream(taskDys).collect(Collectors.groupingBy(task -> task.getLong("flowrurole.flowdefrole.id")));
        ArrayList<String> validateResult = new ArrayList<String>(10);
        if (groupByObjMap.size() > 1 || groupByRoleMap.size() > 1) {
            validateResult.add(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u540c\u4e00\u8bc4\u4f30\u5bf9\u8c61\u76f8\u540c\u89d2\u8272\u7684\u8bc4\u4f30\u4eba\u9000\u56de\u8bc4\u4f30\u3002", (String)"ActEvalObjManageDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        if (failStatus = Arrays.stream(taskDys).anyMatch(task -> !HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PROCESSED.getCode()))) {
            validateResult.add(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9000\u56de\u201c\u5df2\u8bc4\u4f30\u201d\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ActEvalObjManageDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        return validateResult;
    }

    public List<String> validateTaskOfReturnFormulate(List<Object> taskIdList) {
        QFilter idFilter = new QFilter("id", "in", taskIdList);
        DynamicObject[] taskDys = TASK_ENTITY_SERVICE.query("flowruproc.actevalobj, flowrurole.flowdefrole, taskstatus", new QFilter[]{idFilter});
        Map<Long, List<DynamicObject>> groupByObjMap = Arrays.stream(taskDys).collect(Collectors.groupingBy(task -> task.getLong("flowruproc.actevalobj")));
        Map<Long, List<DynamicObject>> groupByRoleMap = Arrays.stream(taskDys).collect(Collectors.groupingBy(task -> task.getLong("flowrurole.flowdefrole.id")));
        ArrayList<String> validateResult = new ArrayList<String>(10);
        if (groupByObjMap.size() > 1 || groupByRoleMap.size() > 1) {
            validateResult.add(CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u540c\u4e00\u5236\u5b9a\u5bf9\u8c61\u76f8\u540c\u89d2\u8272\u7684\u5236\u5b9a\u4eba\u9000\u56de\u3002", (String)"ActEvalObjManageDomainService_2", (String)"opmc-epa-business", (Object[])new Object[0])));
        }
        return validateResult;
    }

    public FlowRollbackResultBo rollbackTask(List<Long> taskIds, String reason) {
        return FLOW_RU_SECOND_DOMAIN_SERVICE.rollbackTask(taskIds, reason);
    }

    public FlowValidateResultBo batchRollbackTasks(List<Long> taskIds, String reason) {
        return FLOW_RU_SECOND_DOMAIN_SERVICE.batchRollbackTasks(taskIds, reason);
    }

    public Map<Long, ReminderVO> pushTask(List<Long> taskIds) {
        return FLOW_HANDLER_DOMAIN_SERVICE.reminderProcess(taskIds);
    }

    public Map<Long, Boolean> pushObjTask(List<Long> ObjIds) {
        return FLOW_HANDLER_DOMAIN_SERVICE.reminderProcessByActevalObj(ObjIds);
    }

    public Map<Long, Boolean> sendTask(List<Long> taskIds) {
        return FLOW_HANDLER_DOMAIN_SERVICE.startProcessAfterWaiting(taskIds);
    }

    public Map<Long, DynamicObject> queryEvalObjById(List<Long> objIds) {
        QFilter idFilter = new QFilter("id", "in", objIds);
        DynamicObject[] objDys = ACT_EVAL_OBJ_ENTITY_SERVICE.query("person, assessnode, nodestatus, nodeindex, formulateflowins, formulateflow", new QFilter[]{idFilter});
        return Arrays.stream(objDys).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity()));
    }

    public DynamicObject[] queryTaskByIds(List<Long> taskIds) {
        return TASK_ENTITY_SERVICE.queryTaskByPks(taskIds);
    }

    public Map<Long, String> queryEvaluator(List<Long> roleIds) {
        HashMap<Long, String> evaluatorMap = new HashMap<Long, String>(16);
        Map handerMap = FLOW_HANDLER_DOMAIN_SERVICE.queryHandlerByRuleIds(roleIds);
        for (Map.Entry set : handerMap.entrySet()) {
            List handerList = (List)set.getValue();
            if (ObjectUtils.isEmpty((Object)handerList)) {
                evaluatorMap.put((Long)set.getKey(), "");
                continue;
            }
            StringBuilder builder = new StringBuilder();
            int index = 0;
            for (DynamicObject hander : handerList) {
                if (hander == null) continue;
                if (index != 0) {
                    builder.append(",");
                }
                builder.append(hander.getString("name"));
                String number = String.format("(%s)", hander.getString("number"));
                builder.append(number);
                ++index;
            }
            evaluatorMap.put((Long)set.getKey(), builder.toString());
        }
        return evaluatorMap;
    }

    public List<AssignHandlerVO> setEvaluatorByRoleRuId(List<Long> roleRuIds, List<Long> evals) {
        return FLOW_HANDLER_DOMAIN_SERVICE.assignHandlerBeforeStartProcess(roleRuIds, evals);
    }

    public DynamicObject[] queryTaskById(List<Object> taskIdList) {
        QFilter idFilter = new QFilter("id", "in", taskIdList);
        return TASK_ENTITY_SERVICE.query("flowrurole.flowdefrole, taskstatus, flowruproc.actevalobj, handler.name", new QFilter[]{idFilter});
    }

    public Map<Long, AssignHandlerVO> modifyEvalPerson(List<DynamicObject> taskDys, String evaluator) {
        List collect = taskDys.stream().map(taskDy -> {
            AssignHandlerParamDTO assignHandlerDTO = new AssignHandlerParamDTO();
            assignHandlerDTO.setTaskId((Long)taskDy.getPkValue());
            assignHandlerDTO.setHandlerIds(Collections.singletonList(Long.parseLong(evaluator)));
            assignHandlerDTO.setRoleId(Long.valueOf(taskDy.getLong("flowrurole.id")));
            assignHandlerDTO.setActevaObj(Long.valueOf(taskDy.getLong("flowruproc.actevalobj")));
            assignHandlerDTO.setWorkFlowType("2");
            assignHandlerDTO.setHandType((short)1);
            return assignHandlerDTO;
        }).collect(Collectors.toList());
        List assignHandlerVOs = FLOW_HANDLER_BATCH_DOMAIN_SERVICE.modifyHandlerAfterStartProcess(collect);
        return assignHandlerVOs.stream().collect(Collectors.toMap(AssignHandlerVO::getTaskId, Function.identity()));
    }

    public Map<Long, AssignHandlerVO> modifyEvalPersonCross(List<DynamicObject> modifyList, String evaluator) {
        List<Long> ruRoleIds = modifyList.stream().map(dy -> dy.getLong("rutask.flowrurole.id")).collect(Collectors.toList());
        Map<Object, Long> roleToObjMap = this.getEvalObjMap(ruRoleIds);
        List collect = modifyList.stream().map(dy -> {
            AssignHandlerParamDTO assignHandlerDTO = new AssignHandlerParamDTO();
            assignHandlerDTO.setId((Long)dy.getPkValue());
            assignHandlerDTO.setHandlerIds(Collections.singletonList(Long.parseLong(evaluator)));
            assignHandlerDTO.setTaskId(Long.valueOf(dy.getLong("rutask.id")));
            assignHandlerDTO.setIndicatorId(Long.valueOf(dy.getLong("indicator")));
            assignHandlerDTO.setActevaObj((Long)roleToObjMap.get(dy.getLong("rutask.flowrurole.id")));
            assignHandlerDTO.setHandType((short)1);
            assignHandlerDTO.setWorkFlowType("2");
            return assignHandlerDTO;
        }).collect(Collectors.toList());
        List assignHandlerVOs = FLOW_HANDLER_BATCH_DOMAIN_SERVICE.modifyHandlerCrossAfterStartProcess(collect);
        return assignHandlerVOs.stream().collect(Collectors.toMap(AssignHandlerVO::getId, Function.identity()));
    }

    public DynamicObject[] queryRoleByNodeDefId(Long nodeDefId) {
        QFilter qFilter = new QFilter("flowrunode.flownodedef", "=", (Object)nodeDefId);
        return ROLE_ENTITY_SERVICE.query("id, name, flowdefrole", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryToBeFormulateObjs(Long activityId) {
        return ACT_EVAL_OBJ_ENTITY_SERVICE.queryTobeFormulateObjs(activityId);
    }

    public List<AssignHandlerVO> setFormulatorByRoleRuId(List<Long> roleRuIds, List<Long> evals) {
        return FLOW_HANDLER_DOMAIN_SERVICE.assignHandlerAfterStartProcess(roleRuIds, evals);
    }

    public Map<Long, List<DynamicObject>> queryHandlerByTaskIds(List<Long> ruTaskIds) {
        QFilter idFilter = new QFilter("id", "in", ruTaskIds);
        DynamicObject[] taskDys = TASK_ENTITY_SERVICE.query("flowrurole.id", new QFilter[]{idFilter});
        List roleIds = Arrays.stream(taskDys).map(task -> task.getLong("flowrurole.id")).collect(Collectors.toList());
        return FLOW_HANDLER_DOMAIN_SERVICE.queryHandlerByRuleIds(roleIds);
    }

    public void saveAssessObjectWithInput(IFormView view, DynamicObject activity, DynamicObjectCollection assessObject) {
        new ActivityEvaluationObjectDomainService().addEvaluationObjectsWithInput(view, assessObject, activity);
    }

    public Map<Long, List<DynamicObject>> queryHandlerByRoleIds(List<Long> ruRoleIds) {
        return FLOW_HANDLER_DOMAIN_SERVICE.queryHandlerByRuleIds(ruRoleIds);
    }

    public Map<Long, AssignHandlerVO> deleteEvalPerson(List<DynamicObject> taskDys) {
        List collect = taskDys.stream().map(taskDy -> {
            AssignHandlerParamDTO assignHandlerDTO = new AssignHandlerParamDTO();
            assignHandlerDTO.setTaskId((Long)taskDy.getPkValue());
            assignHandlerDTO.setHandlerIds(Collections.singletonList(taskDy.getLong("handler.id")));
            assignHandlerDTO.setRoleId(Long.valueOf(taskDy.getLong("flowrurole.id")));
            assignHandlerDTO.setWorkFlowType("2");
            assignHandlerDTO.setHandType((short)2);
            assignHandlerDTO.setActevaObj(Long.valueOf(taskDy.getLong("flowruproc.actevalobj")));
            return assignHandlerDTO;
        }).collect(Collectors.toList());
        List assignHandlerVOs = FLOW_HANDLER_BATCH_DOMAIN_SERVICE.deleteHandlerAfterStartProcess(collect);
        LOG.info("delete evaluator result : {}", (Object)SerializationUtils.toJsonString((Object)assignHandlerVOs));
        return assignHandlerVOs.stream().collect(Collectors.toMap(AssignHandlerVO::getTaskId, Function.identity()));
    }

    public Map<Long, AssignHandlerVO> deleteEvalPersonCross(List<DynamicObject> delList, Map<Object, Long> roleToObjMap) {
        List collect = delList.stream().map(taskDy -> {
            AssignHandlerParamDTO assignHandlerDTO = new AssignHandlerParamDTO();
            assignHandlerDTO.setId((Long)taskDy.getPkValue());
            assignHandlerDTO.setTaskId(Long.valueOf(taskDy.getLong("rutask.id")));
            assignHandlerDTO.setIndicatorId(Long.valueOf(taskDy.getLong("indicator")));
            assignHandlerDTO.setHandType((short)2);
            assignHandlerDTO.setWorkFlowType("2");
            long ruRoleId = taskDy.getLong("rutask.flowrurole.id");
            Long objId = (Long)roleToObjMap.get(ruRoleId);
            assignHandlerDTO.setActevaObj(objId);
            assignHandlerDTO.setRoleId(Long.valueOf(ruRoleId));
            return assignHandlerDTO;
        }).collect(Collectors.toList());
        List assignHandlerVOs = FLOW_HANDLER_BATCH_DOMAIN_SERVICE.deleteHandlerCrossAfterStartProcess(collect);
        LOG.info("delete evaluator cross result : {}", (Object)SerializationUtils.toJsonString((Object)assignHandlerVOs));
        return assignHandlerVOs.stream().collect(Collectors.toMap(AssignHandlerVO::getId, Function.identity()));
    }

    public Map<Object, Long> getEvalObjMap(List<Long> ruRoleIds) {
        DynamicObject[] ruRoles = ROLE_ENTITY_SERVICE.queryByPkValue(ruRoleIds);
        return Arrays.stream(ruRoles).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy.getLong("flowruproc.actevalobj")));
    }

    public Map<Object, DynamicObject> getRoleMap(List<Long> ruRoleIds) {
        DynamicObject[] ruRoles = ROLE_ENTITY_SERVICE.queryByPkValue(ruRoleIds);
        return Arrays.stream(ruRoles).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
    }

    public Map<Long, List<DynamicObject>> queryFormulateEvaObjByFlow(Long flowId, Long activityId) {
        List nodeStatus = Arrays.stream(new String[]{AssessNodeStatusEnum.TO_BE_FORMULATED.getStatus(), AssessNodeStatusEnum.TARGET_FORMULATING.getStatus()}).collect(Collectors.toList());
        QFilter qFilter = new QFilter("activity", "=", (Object)activityId).and("nodestatus", "in", nodeStatus).and("assessnode", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId()).and("formulateflow", "=", (Object)flowId);
        DynamicObject[] objDys = ACT_EVAL_OBJ_ENTITY_SERVICE.query("id, formulateflowins.currentnode", new QFilter[]{qFilter});
        List nodeIds = Arrays.stream(objDys).map(dy -> dy.getLong("formulateflowins.currentnode.id")).collect(Collectors.toList());
        DynamicObject[] nodeDys = NODE_ENTITY_SERVICE.query("flownodedef", new QFilter[]{new QFilter("id", "in", nodeIds)});
        Map<Long, List<DynamicObject>> objGroupByNodeMap = Arrays.stream(objDys).collect(Collectors.groupingBy(obj -> obj.getLong("formulateflowins.currentnode.id")));
        HashMap<Long, List<DynamicObject>> resultMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject nodeDy : nodeDys) {
            Long nodeDefId = (Long)nodeDy.getDynamicObject("flownodedef").getPkValue();
            Long nodeId = (Long)nodeDy.getPkValue();
            List<DynamicObject> objListByNode = objGroupByNodeMap.get(nodeId);
            if (ObjectUtils.isEmpty(resultMap.get(nodeDefId))) {
                resultMap.put(nodeDefId, objListByNode);
                continue;
            }
            List objListByNodeDef = (List)resultMap.get(nodeDefId);
            objListByNodeDef.addAll(objListByNode);
            resultMap.put(nodeDefId, objListByNodeDef);
        }
        return resultMap;
    }

    public Map<Long, String> queryEvalObjRoleInfo(List<Long> idList) {
        QFilter idFilter = new QFilter("id", "in", idList);
        DynamicObject[] objList = ACT_EVAL_OBJ_ENTITY_SERVICE.query("evalflowins.currentnode", new QFilter[]{idFilter});
        List nodeIds = Arrays.stream(objList).map(obj -> obj.getLong("evalflowins.currentnode.id")).collect(Collectors.toList());
        QFilter nodeIdFilter = new QFilter("flowrunode", "in", nodeIds);
        DynamicObject[] roleDys = ROLE_ENTITY_SERVICE.query("id, rolestatus, flowrunode, flowdefrole.rolename", new QFilter[]{nodeIdFilter});
        Map<Long, List<DynamicObject>> nodeDyMap = Arrays.stream(roleDys).collect(Collectors.groupingBy(nodeDy -> nodeDy.getLong("flowrunode.id")));
        return Arrays.stream(objList).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> {
            Long nodeId = obj.getLong("evalflowins.currentnode.id");
            List nodeDys = (List)nodeDyMap.get(nodeId);
            StringBuilder roleInfo = new StringBuilder();
            for (int i = 0; i < nodeDys.size(); ++i) {
                roleInfo.append(((DynamicObject)nodeDys.get(i)).getString("flowdefrole.rolename")).append('\uff08').append(FlowRuRoleStatusEnum.getFlowRuRoleStatusByCode((String)((DynamicObject)nodeDys.get(i)).getString("rolestatus")).getText()).append('\uff09').append(i == nodeDys.size() - 1 ? "" : Character.valueOf(','));
            }
            return roleInfo.toString();
        }));
    }

    public Map<Long, ToBeFormulateActRecordBO> queryActRecordByObjIds(List<Long> objIds) {
        DynamicObject[] records = ACTIVITY_OBJ_RECORD.queryActRecordByObjIds(objIds);
        return Arrays.stream(records).collect(Collectors.toMap(records1 -> records1.getLong("actevalobj"), records2 -> {
            ToBeFormulateActRecordBO actRecordBO = new ToBeFormulateActRecordBO();
            if (AssessNodeStatusEnum.TARGET_FORMULATING.getStatus().equals(records2.getString("nodestatus")) && Long.parseLong(ProcessManageApEnum.TARGET_FORMULATING.getLabId()) == records2.getLong("assessnode") && AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId().longValue() == records2.getLong("nodeindex")) {
                actRecordBO.setProcess(true);
            } else if (AssessNodeStatusEnum.TARGET_FORMULATED.getStatus().equals(records2.getString("nodestatus")) && Long.parseLong(ProcessManageApEnum.TARGET_FORMULATING.getLabId()) == records2.getLong("assessnode") && AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId().longValue() == records2.getLong("nodeindex")) {
                actRecordBO.setDistri(true);
            }
            return actRecordBO;
        }, (records1, records2) -> records1.isProcess() ? records1 : (records2.isDistri() ? records2 : records1)));
    }

    public List<FormulatorRoleListDataBO> getFormulatorRoleListData(Long activityId) {
        ArrayList<FormulatorRoleListDataBO> roleListDatas = new ArrayList<FormulatorRoleListDataBO>(10);
        DynamicObject[] objs = ACT_EVAL_OBJ_ENTITY_SERVICE.queryTobeFormulateObjs(activityId);
        Map formulateFlowInstIdMap = Arrays.stream(objs).filter(obj -> obj.getLong("formulateflowins.id") != 0L).collect(Collectors.toMap(obj -> obj.getLong("formulateflowins.id"), Function.identity()));
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and("flowruproc", "in", formulateFlowInstIdMap.keySet());
        String selectPro = "flowruproc, flowrunode, issethandler";
        DynamicObject[] roleArr = ROLE_ENTITY_SERVICE.query(selectPro, new QFilter[]{filter});
        List<Long> roleIds = Arrays.stream(roleArr).map(role -> role.getLong("id")).collect(Collectors.toList());
        ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = new ActEvalObjManageApplicationService();
        Map<Long, List<DynamicObject>> roleHandlerMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryHandlerByRoleIds(roleIds);
        for (DynamicObject role2 : roleArr) {
            List<DynamicObject> roleHandleList;
            FormulatorRoleListDataBO dataBO = new FormulatorRoleListDataBO();
            DynamicObject evalObj = (DynamicObject)formulateFlowInstIdMap.get(role2.getLong("flowruproc.id"));
            String personName = evalObj.getString("person.name");
            dataBO.setPerfFileNumber(evalObj.getString("perffile.number"));
            dataBO.setName(personName);
            dataBO.setNumber(evalObj.getString("person.number"));
            String processName = role2.getString("flowruproc.name").replace(personName, "");
            dataBO.setProcessName(processName);
            dataBO.setNodeName(role2.getString("flowrunode.name"));
            if (!ObjectUtils.isEmpty(roleHandlerMap) && !ObjectUtils.isEmpty(roleHandleList = roleHandlerMap.get(role2.getLong("id")))) {
                String handler = roleHandleList.stream().filter(Objects::nonNull).map(roleHandler -> roleHandler.getString("name") + "(" + roleHandler.getString("number") + ")").collect(Collectors.joining(","));
                dataBO.setHandle(handler);
            }
            dataBO.setIsSetHandler(role2.getBoolean("issethandler") ? ResManager.loadKDString((String)"\u662f", (String)"ActEvalObjManageDomainService_3", (String)"opmc-epa-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ActEvalObjManageDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]));
            dataBO.setRole(role2.getString("name"));
            dataBO.setJob(evalObj.getString("empposrel.position.name"));
            dataBO.setAdminorg(evalObj.getString("affiliateadminorg.name"));
            dataBO.setBelongCom(evalObj.getString("empposrel.company.name"));
            roleListDatas.add(dataBO);
        }
        return roleListDatas;
    }

    public DynamicObject[] queryActivityEvaluationObjectArrayById(Long[] actevalobjIds) {
        return ACT_EVAL_OBJ_ENTITY_SERVICE.queryActivityEvaluationObjectsByIds(actevalobjIds);
    }

    public DynamicObject[] queryActEvalObjByIds(List<Long> evalObjIds) {
        return ACT_EVAL_OBJ_ENTITY_SERVICE.queryActEvalObjByIds(evalObjIds);
    }

    public Map<Long, Map<Long, Long>> queryIndicatorByObjIds(List<Long> evalObjIds) {
        DynamicObject[] dys = OBJ_CROSS_INDICATOR_ENTITY_SERVICE.queryIndicatorByObjIds(evalObjIds);
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)evalObjIds.size());
        for (DynamicObject dy : dys) {
            Long evalObjId = dy.getLong("actevalobj");
            Long indicatorId = dy.getLong("indicator");
            Long areaId = dy.getLong("area");
            Map indicatorMap = retMap.computeIfAbsent(evalObjId, k -> new HashMap(16));
            indicatorMap.put(indicatorId, areaId);
        }
        return retMap;
    }

    public List<AssignHandlerVO> modifyHandlerAfterStartProcess(List<ExtendedDataEntity> dataEntities, Map<String, List<Long>> handlerInfo) {
        ArrayList<AssignHandlerParamDTO> handlerParamDTOs = new ArrayList<AssignHandlerParamDTO>(10);
        Map<Long, Long> taskObjMap = dataEntities.stream().collect(Collectors.toMap(task -> task.getDataEntity().getLong("id"), task -> task.getDataEntity().getLong("flowruproc.actevalobj")));
        Map<Long, Long> taskRoleMap = dataEntities.stream().collect(Collectors.toMap(task -> task.getDataEntity().getLong("id"), task -> task.getDataEntity().getLong("flowrurole.id")));
        for (ExtendedDataEntity task2 : dataEntities) {
            long taskId = task2.getDataEntity().getLong("id");
            AssignHandlerParamDTO dto = new AssignHandlerParamDTO();
            dto.setRoleId(taskRoleMap.get(taskId));
            dto.setTaskId(Long.valueOf(taskId));
            dto.setHandlerIds(handlerInfo.get("handlers"));
            dto.setActevaObj(taskObjMap.get(taskId));
            dto.setHandType((short)1);
            handlerParamDTOs.add(dto);
        }
        return FLOW_HANDLER_BATCH_DOMAIN_SERVICE.modifyHandlerAfterStartProcess(handlerParamDTOs);
    }

    public List<AssignHandlerVO> addHandlerAfterStartProcess(List<ExtendedDataEntity> dataEntities, Map<String, List<Long>> handlerInfo) {
        ArrayList<AssignHandlerParamDTO> handlerParamDTOs = new ArrayList<AssignHandlerParamDTO>(10);
        Set roleIds = dataEntities.stream().map(task -> task.getDataEntity().getLong("flowrurole.id")).collect(Collectors.toSet());
        HashMap roleObjMap = new HashMap(16);
        dataEntities.stream().forEach(task -> {
            long roleId = task.getDataEntity().getLong("flowrurole.id");
            if (roleIds.contains(roleId) && !roleObjMap.containsKey(roleId)) {
                roleObjMap.put(roleId, task.getDataEntity().getLong("flowruproc.actevalobj"));
            }
        });
        List<Long> handlers = handlerInfo.get("handlers");
        for (Long roleId : roleIds) {
            AssignHandlerParamDTO dto = new AssignHandlerParamDTO();
            dto.setRoleId(roleId);
            dto.setHandlerIds(handlers);
            dto.setActevaObj((Long)roleObjMap.get(roleId));
            dto.setHandType((short)0);
            handlerParamDTOs.add(dto);
        }
        return FLOW_HANDLER_BATCH_DOMAIN_SERVICE.addHandlerAfterStartProcess(handlerParamDTOs);
    }

    public Integer getIndexByNodeId(Long nodeId) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.getIndexByRUNodeId(nodeId);
    }

    public List<AssignHandlerVO> deleteHandlerAfterStartProcess(List<ExtendedDataEntity> dataEntities, String workFlowType) {
        ArrayList<AssignHandlerParamDTO> handlerParamDTOs = new ArrayList<AssignHandlerParamDTO>(10);
        Map<Long, Long> taskObjMap = dataEntities.stream().collect(Collectors.toMap(task -> task.getDataEntity().getLong("id"), task -> task.getDataEntity().getLong("flowruproc.actevalobj")));
        Map<Long, Long> taskRoleMap = dataEntities.stream().collect(Collectors.toMap(task -> task.getDataEntity().getLong("id"), task -> task.getDataEntity().getLong("flowrurole.id")));
        for (ExtendedDataEntity task2 : dataEntities) {
            AssignHandlerParamDTO dto = new AssignHandlerParamDTO();
            long taskId = task2.getDataEntity().getLong("id");
            dto.setRoleId(taskRoleMap.get(taskId));
            dto.setTaskId(Long.valueOf(taskId));
            dto.setActevaObj(taskObjMap.get(taskId));
            dto.setHandType((short)2);
            dto.setWorkFlowType(workFlowType);
            handlerParamDTOs.add(dto);
        }
        return FLOW_HANDLER_BATCH_DOMAIN_SERVICE.deleteHandlerAfterStartProcess(handlerParamDTOs);
    }

    public List<AssignHandlerVO> addEvalPerson(List<AssignHandlerParamDTO> addList) {
        return FLOW_HANDLER_BATCH_DOMAIN_SERVICE.addHandlerAfterStartProcess(addList);
    }

    public Map<Long, String> resetEval(List<Long> objIds) {
        LOG.info("resetProcs start : {}", (Object)objIds.size());
        FlowValidateResultBo flowValidateResultBo = FLOW_RU_SECOND_DOMAIN_SERVICE.resetProcs(objIds, "2");
        Map ruProcIdMap = flowValidateResultBo.getRuProcIdMap();
        LOG.info("resetProcs end : {}", (Object)ruProcIdMap.size());
        if (!ruProcIdMap.isEmpty()) {
            this.resetActObjs(ruProcIdMap.keySet().toArray(), ruProcIdMap);
            this.deleteIndicatorScore(new ArrayList<Long>(ruProcIdMap.keySet()));
            this.deleteCustomAreaAndRecord(new ArrayList<Long>(ruProcIdMap.keySet()));
        }
        return flowValidateResultBo.getValidateMap();
    }

    public void returnEval(List<Long> objIds) {
        this.resetActObjs(objIds.toArray(), new HashMap<Long, Long>(16));
        this.deleteIndicatorScore(objIds);
        this.deleteSont(objIds);
        EVAL_RESULT_CALC_DOMAIN_SERVICE.refreshScoreOnImportInd(objIds);
    }

    private void resetActObjs(Object[] objIds, Map<Long, Long> ruProcIdMap) {
        DynamicObject[] objects = ACT_EVAL_OBJ_ENTITY_SERVICE.queryAllFieldsByPkValues(objIds);
        long activityId = objects[0].getLong("activity.id");
        int nodeindex = objects[0].getInt("nodeindex");
        if (nodeindex == 0) {
            nodeindex = this.getNodeIndexByActId(activityId, NodeTabMapEnum.EVAL_PROCESS);
        }
        long lastNodeId = this.getNodeIdByActIdAndIndex(activityId, nodeindex - 1);
        AssessNodeStatusEnum nodeStatusEnum = AssessNodeStatusEnum.getLastNodeStatus((Long)lastNodeId);
        for (DynamicObject obj : objects) {
            if (!ruProcIdMap.isEmpty()) {
                Long flowInsId = ruProcIdMap.get((Long)obj.getPkValue());
                obj.set("evalflowins", (Object)flowInsId);
                obj.set("assessnode", (Object)lastNodeId);
                obj.set("nodestatus", (Object)nodeStatusEnum.getStatus());
                obj.set("nodeindex", (Object)(nodeindex - 1));
            } else {
                obj.set("assessnode", (Object)AssessNodeStatusEnum.EVALUATING.getNodeId());
                obj.set("nodestatus", (Object)AssessNodeStatusEnum.EVALUATING.getStatus());
                obj.set("nodeindex", (Object)nodeindex);
            }
            obj.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
            obj.set("evalfinishtype", null);
            obj.set("completetime", null);
            obj.set(AssessScoreAbbrEnum.ATCS.getCode(), null);
            obj.set(AssessScoreAbbrEnum.ATCL.getCode(), null);
            obj.set(AssessScoreAbbrEnum.SOAT.getCode(), null);
            obj.set(AssessScoreAbbrEnum.LEVELOAT.getCode(), null);
            obj.set("soatsource", null);
            obj.set(AssessScoreAbbrEnum.SOAC.getCode(), null);
            obj.set(AssessScoreAbbrEnum.LOAC.getCode(), null);
            obj.set(AssessScoreAbbrEnum.SOP.getCode(), null);
            obj.set(AssessScoreAbbrEnum.LOP.getCode(), null);
            obj.set("sopsource", null);
            obj.set(AssessScoreAbbrEnum.FSOP.getCode(), null);
            obj.set(AssessScoreAbbrEnum.FLOP.getCode(), null);
            obj.set("fsopsource", null);
            obj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            obj.set("modifytime", (Object)new Date());
        }
        ACT_EVAL_OBJ_ENTITY_SERVICE.save(objects);
    }

    private void deleteIndicatorScore(List<Long> actObjIds) {
        DynamicObject[] addSubAreas = OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.querySozByActObjId(actObjIds);
        Arrays.stream(addSubAreas).forEach(dy -> {
            dy.set(AssessScoreAbbrEnum.SOZ.getCode(), null);
            dy.set(AssessScoreAbbrEnum.CSOZ.getCode(), null);
        });
        OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.save(addSubAreas);
        DynamicObject[] genAreas = OBJ_GEN_AREA_INS_ENTITY_SERVICE.querySozByActObjId(actObjIds);
        Arrays.stream(genAreas).forEach(dy -> {
            dy.set(AssessScoreAbbrEnum.SOZ.getCode(), null);
            dy.set(AssessScoreAbbrEnum.CSOZ.getCode(), null);
        });
        OBJ_GEN_AREA_INS_ENTITY_SERVICE.save(genAreas);
        List<Long> areaInsId = Arrays.stream(genAreas).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] genInds = OBJ_GEN_AREA_INDICATOR_ENTITY_SERVICE.queryScoreByActObjId(areaInsId);
        Arrays.stream(genInds).forEach(dy -> {
            dy.set(AssessScoreAbbrEnum.SOI.getCode(), null);
            dy.set(AssessScoreAbbrEnum.IECS.getCode(), null);
            dy.set(AssessScoreAbbrEnum.IES.getCode(), null);
        });
        OBJ_GEN_AREA_INDICATOR_ENTITY_SERVICE.save(genInds);
        List<Long> addSubAreaInsId = Arrays.stream(addSubAreas).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] addSubInd = OBJ_ADD_SUB_AREA_INDICATOR_ENTITY_SERVICE.queryScoreByActObjId(addSubAreaInsId);
        Arrays.stream(addSubInd).forEach(dy -> {
            dy.set(AssessScoreAbbrEnum.SOI.getCode(), null);
            dy.set(AssessScoreAbbrEnum.IECS.getCode(), null);
            dy.set(AssessScoreAbbrEnum.IES.getCode(), null);
        });
        OBJ_ADD_SUB_AREA_INDICATOR_ENTITY_SERVICE.save(addSubInd);
    }

    private void deleteCustomAreaAndRecord(List<Long> actObjIds) {
        DynamicObject[] customInds = OBJ_CUSTOM_AREA_INS_ENTITY_SERVICE.queryByActObjId(actObjIds);
        Arrays.stream(customInds).forEach(custom -> Arrays.stream(CUSTOM_AREA_ALL_FIELDS).forEach(field -> custom.set(field, null)));
        OBJ_CUSTOM_AREA_INS_ENTITY_SERVICE.save(customInds);
        QFilter objFilter = new QFilter("actevalobj", "in", actObjIds);
        QFilter nodeFilter = new QFilter("assessnode", "in", (Object)NodeTabMapEnum.EVAL_PROCESS.getNodeId());
        ACTIVITY_OBJ_RECORD.deleteByFilter(new QFilter[]{objFilter, nodeFilter});
        OBJSETSCORERECORD_ENTITY_SERVICE.deleteByFilter(new QFilter[]{objFilter, nodeFilter});
    }

    private void deleteSont(List<Long> objIds) {
        DynamicObject[] addSubSon = OBJ_ADD_SUB_NODE_RES_ENTITY_SERVICE.querySonByActObjId(objIds);
        Arrays.stream(addSubSon).forEach(dy -> dy.set(AssessScoreAbbrEnum.SON.getCode(), null));
        OBJ_ADD_SUB_NODE_RES_ENTITY_SERVICE.save(addSubSon);
        DynamicObject[] genSon = OBJ_GEN_NODE_RES_ENTITY_SERVICE.querySonByActObjId(objIds);
        Arrays.stream(genSon).forEach(dy -> dy.set(AssessScoreAbbrEnum.SON.getCode(), null));
        OBJ_GEN_NODE_RES_ENTITY_SERVICE.save(genSon);
        DynamicObject[] sontObj = OBJ_NODE_RES_ENTITY_SERVICE.querySontByActObjId(objIds);
        Arrays.stream(sontObj).forEach(dy -> dy.set(AssessScoreAbbrEnum.SONT.getCode(), null));
        OBJ_NODE_RES_ENTITY_SERVICE.save(sontObj);
        DynamicObject[] records = ACTIVITY_OBJ_RECORD.queryActRecordByObjIdsAndNodeId(objIds, NodeTabMapEnum.EVAL_PROCESS.getNodeId());
        Arrays.stream(records).forEach(dy -> dy.set("nodestatus", (Object)AssessNodeStatusEnum.EVALUATING.getStatus()));
        ACTIVITY_OBJ_RECORD.save(records);
    }

    public FlowValidateResultBo resetFormulate(Map<Boolean, List<Long>> actEvalObjIdMap) {
        return FLOW_RU_SECOND_DOMAIN_SERVICE.resetProcs(actEvalObjIdMap, "1");
    }

    public FlowValidateResultBo resetInterviewPro(Map<Boolean, List<Long>> actEvalObjIdMap) {
        return FLOW_RU_SECOND_DOMAIN_SERVICE.resetProcs(actEvalObjIdMap, "3");
    }

    public void dealWithAfterResetFormulate(List<Long> objIds) {
        Object[] evalObjArr = new ActivityEvaluationObjectDomainService().queryEvaluationObjectById(objIds);
        if (ObjectUtils.isEmpty((Object[])evalObjArr)) {
            return;
        }
        this.deleteCrossConfNImportScoreByFilter(objIds);
    }

    private void deleteCrossConfNImportScoreByFilter(List<Long> objIds) {
        QFilter qFilter = new QFilter("actevalobj", "in", objIds);
        OBJ_CROSS_INDICATOR_ENTITY_SERVICE.deleteByFilter(new QFilter[]{qFilter});
        IMPORT_SCORE_IND_ENTITY_SERVICE.deleteByFilter(new QFilter[]{qFilter});
    }

    public void dealWithAfterResetFormulate(Map<Long, Long> ruProcIdMap, boolean targetFormulatingForm) {
        ActivityEvaluationObjectDomainService objectDomainService = new ActivityEvaluationObjectDomainService();
        ArrayList<Long> objIds = new ArrayList<Long>(ruProcIdMap.keySet());
        Object[] evalObjArr = objectDomainService.queryEvaluationObjectById(objIds);
        if (ObjectUtils.isEmpty((Object[])evalObjArr)) {
            return;
        }
        QFilter qFilter = new QFilter("actevalobj", "in", objIds);
        objectDomainService.updateNodeIndiToUnify((DynamicObject[])evalObjArr);
        if (!targetFormulatingForm) {
            OBJ_CROSS_INDICATOR_ENTITY_SERVICE.deleteByFilter(new QFilter[]{qFilter});
            IMPORT_SCORE_IND_ENTITY_SERVICE.deleteByFilter(new QFilter[]{qFilter});
        }
        ACTIVITY_OBJ_RECORD.deleteByFilter(new QFilter[]{qFilter});
        this.updateEvalObjFlowInfo((DynamicObject[])evalObjArr, ruProcIdMap);
    }

    public void dealWithAfterResetInterview(Map<Long, Long> ruProcIdMap) {
        ArrayList<Long> objIds = new ArrayList<Long>(ruProcIdMap.keySet());
        Object[] evalObjArr = INTERVIEW_OBJ_ENTITY_SERVICE.queryInterviewobjsById("id, modifier, modifytime, interstatus, interflowins", objIds);
        if (ObjectUtils.isEmpty((Object[])evalObjArr)) {
            return;
        }
        for (Object evalObj : evalObjArr) {
            evalObj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            evalObj.set("modifytime", (Object)new Date());
            evalObj.set("interstatus", (Object)InterStatusEnum.JOINED.getStatus());
            evalObj.set("interflowins", (Object)ruProcIdMap.get(evalObj.getLong("id")));
        }
        INTERVIEW_OBJ_ENTITY_SERVICE.save((DynamicObject[])evalObjArr);
    }

    private void updateEvalObjFlowInfo(DynamicObject[] evalObjArr, Map<Long, Long> objRefProInstMap) {
        for (DynamicObject evalObj : evalObjArr) {
            evalObj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            evalObj.set("modifytime", (Object)new Date());
            evalObj.set("nodeindex", null);
            evalObj.set("nodestatus", null);
            evalObj.set("assessstaus", (Object)AssessStausEnum.JOINED.getStatus());
            evalObj.set("assessnode", null);
            evalObj.set("formulateflowins", (Object)objRefProInstMap.get(evalObj.getLong("id")));
        }
        new IndicatorGroupDomainService().updateEvalScore(evalObjArr);
    }

    public void dealWithAfterBaskFormulate(List<Long> objIds) {
        QFilter qFilter = new QFilter("actevalobj", "in", objIds);
        OBJ_CROSS_INDICATOR_ENTITY_SERVICE.deleteByFilter(new QFilter[]{qFilter});
        IMPORT_SCORE_IND_ENTITY_SERVICE.deleteByFilter(new QFilter[]{qFilter});
        this.updateEvalObjRecord(objIds);
        Object[] evalObjArr = new ActivityEvaluationObjectDomainService().queryEvaluationObjectById(objIds);
        if (ObjectUtils.isEmpty((Object[])evalObjArr)) {
            return;
        }
        this.updateEvalObjTargetFormulating((DynamicObject[])evalObjArr);
    }

    private void updateEvalObjRecord(List<Long> objIds) {
        DynamicObject[] record;
        for (DynamicObject obj : record = ACTIVITY_OBJ_RECORD.query("nodestatus,assessnode", new QFilter[]{new QFilter("actevalobj", "in", objIds).and("nodestatus", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus()).and("assessnode", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId()).and("nodeindex", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId())})) {
            obj.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_CHANGING.getStatus());
        }
        ACTIVITY_OBJ_RECORD.update(record);
    }

    private void updateEvalObjTargetFormulating(DynamicObject[] evalObjArr) {
        for (DynamicObject evalObj : evalObjArr) {
            evalObj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            evalObj.set("modifytime", (Object)new Date());
            evalObj.set("nodeindex", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
            evalObj.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus());
            evalObj.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
            evalObj.set("assessnode", (Object)Long.valueOf(ProcessManageApEnum.TARGET_FORMULATING.getLabId()));
        }
        new ActivityEvaluationObjectDomainService().saveEvaluationObject(evalObjArr);
    }

    public DynamicObject[] queryActObjByCrossId(Object[] pkValues) {
        return OBJ_CROSS_INDICATOR_ENTITY_SERVICE.queryActObjByCrossId(pkValues);
    }

    public List<DynamicObject> getEvaluatiesByIndicatorId(Long nodeId, List<Long> indicatorIds) {
        return CROSS_SCORE_DOMAIN_SERVICE.queryCrossRoleSetByIndicatorList(nodeId, indicatorIds);
    }

    public DynamicObject[] getDefRoleByDefNodeId(Long nodeId) {
        return FLOW_DEF_ROLE_ENTITY_SERVICE.getDefRoleByDefNodeId(nodeId);
    }

    public boolean setCrossEvaluaties(CrossScoreParamsBo crossScoreBo) {
        return CROSS_SCORE_DOMAIN_SERVICE.setCrossScore(crossScoreBo);
    }

    public Map<Long, String> getEvaluatorMap(Long nodeDefId, Object[] ids) {
        HashMap indicatorToInfoMap = new HashMap(16);
        DynamicObject[] crossData = OBJ_CROSS_INDICATOR_ENTITY_SERVICE.queryActObjByCrossId(ids);
        Map<Long, Long> idMap = Arrays.stream(crossData).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("indicator")));
        Map handerMap = CROSS_SCORE_DOMAIN_SERVICE.queryHandlerByCross(nodeDefId, new ArrayList<Long>(idMap.values()));
        for (Map.Entry set : handerMap.entrySet()) {
            List crossRoleSets = ((QueryHandlerVO)set.getValue()).getCrossRoleSets();
            if (ObjectUtils.isEmpty((Object)crossRoleSets)) continue;
            Map<Integer, List<DynamicObject>> turnMap = crossRoleSets.stream().collect(Collectors.groupingBy(dy -> dy.getInt("turnoversort")));
            List keyList = turnMap.keySet().stream().sorted().distinct().collect(Collectors.toList());
            StringBuilder info = new StringBuilder();
            for (Integer sort : keyList) {
                if (StringUtils.isNotBlank((CharSequence)info)) {
                    info.append("->");
                }
                List<DynamicObject> list = turnMap.get(sort);
                StringBuilder evalBuilder = new StringBuilder();
                for (DynamicObject dy2 : list) {
                    if (StringUtils.isNotBlank((CharSequence)evalBuilder)) {
                        evalBuilder.append("&");
                    }
                    DynamicObjectCollection cols = dy2.getDynamicObjectCollection("entryentity");
                    StringBuilder nameBuilder = new StringBuilder();
                    for (DynamicObject obj : cols) {
                        if (StringUtils.isNotBlank((CharSequence)nameBuilder)) {
                            nameBuilder.append(",");
                        }
                        nameBuilder.append(obj.getDynamicObject("handlerid").getString("name")).append(String.format("(%s)", obj.getDynamicObject("handlerid").getString("number")));
                    }
                    evalBuilder.append(dy2.getString("defroleid.rolename")).append(":").append((CharSequence)nameBuilder);
                }
                info.append((CharSequence)evalBuilder);
            }
            indicatorToInfoMap.put(set.getKey(), info.toString());
        }
        HashMap<Long, String> crossIdToInfoMap = new HashMap<Long, String>(16);
        for (Map.Entry<Long, Long> set : idMap.entrySet()) {
            long crossId = set.getKey();
            long indicatorId = set.getValue();
            crossIdToInfoMap.put(crossId, (String)indicatorToInfoMap.get(indicatorId));
        }
        return crossIdToInfoMap;
    }

    public DynamicObject[] queryRelationById(List<Object> relationIdList) {
        return RUTASK_IND_RELATION_ENTITY_SERVICE.queryById(relationIdList);
    }

    public Collection<DynamicObject> getIndicatorTask(Object[] primaryIds) {
        DynamicObject[] indicatorTasks = RUTASK_IND_RELATION_ENTITY_SERVICE.queryById(Arrays.asList(primaryIds));
        Set taskStatus = Arrays.stream(new String[]{FlowRuRoleStatusEnum.RUNNING.getCode(), FlowRuRoleStatusEnum.NOT_ACTIVE.getCode(), FlowRuRoleStatusEnum.PENDING.getCode()}).collect(Collectors.toSet());
        List ruRoleIds = Arrays.stream(indicatorTasks).map(indicatorTask -> indicatorTask.getLong("rutask.flowrurole.id")).collect(Collectors.toList());
        DynamicObject[] ruRoleDys = ROLE_ENTITY_SERVICE.queryByRuRoleIds(ruRoleIds);
        Map ruRoleMap = Arrays.stream(ruRoleDys).collect(Collectors.toMap(ruRole -> ruRole.getLong("id"), Function.identity()));
        Map indicatorTaskMap = Arrays.stream(indicatorTasks).filter(indicatorTask -> taskStatus.contains(((DynamicObject)ruRoleMap.get(indicatorTask.getLong("rutask.flowrurole.id"))).getString("rolestatus"))).collect(Collectors.toMap(indicatorTask -> indicatorTask.getString("rutask.flowrurole.id") + indicatorTask.getString("indicator"), Function.identity(), (val1, val2) -> val1));
        return indicatorTaskMap.values();
    }

    public Map<Long, DynamicObject> queryActObjByIndicatorId(Collection<Long> indicatorIds) {
        QFilter indicatorFilter = new QFilter("indicator", "in", indicatorIds);
        DynamicObject[] indicatorDys = OBJ_CROSS_INDICATOR_ENTITY_SERVICE.query("person, actevalobj, indicator", new QFilter[]{indicatorFilter});
        return Arrays.stream(indicatorDys).collect(Collectors.toMap(indicatorDy -> indicatorDy.getLong("indicator"), Function.identity(), (val1, val2) -> val1));
    }

    public List<AssignHandlerVO> addEvalPersonCross(List<AssignHandlerParamDTO> addList) {
        return FLOW_HANDLER_BATCH_DOMAIN_SERVICE.addHandlerCrossAfterStartProcess(addList);
    }

    public boolean checkEvalFinishType(Object pkId, boolean isEval) {
        QFilter idFilter = new QFilter("id", "=", pkId);
        List finishTypes = Arrays.stream(new String[]{EvalfinishtypeEnum.HANDWORK_INPUT.getType(), EvalfinishtypeEnum.NOPART_EVAL.getType()}).collect(Collectors.toList());
        QFilter finishTypeFilter = new QFilter("evalfinishtype", "not in", finishTypes);
        if (!isEval) {
            QFilter iscurperiodFilter = new QFilter("iscurperiod", "!=", (Object)"0");
            DynamicObject actEvalObj = ACT_EVAL_OBJ_ENTITY_SERVICE.queryOne(pkId);
            long flowId = actEvalObj.getLong("activity.perfworkflow.id");
            boolean dependentSummary = this.isDependentSummary(flowId);
            boolean exists = ACT_EVAL_OBJ_ENTITY_SERVICE.isExists(new QFilter[]{idFilter, finishTypeFilter, iscurperiodFilter});
            return !dependentSummary && exists;
        }
        return ACT_EVAL_OBJ_ENTITY_SERVICE.isExists(new QFilter[]{idFilter, finishTypeFilter});
    }

    public Map<Object, String> getIndicatorIdNameMap(List<Long> indicators) {
        DynamicObject[] objects = OBJ_CROSS_INDICATOR_ENTITY_SERVICE.queryNameByIndicatorId(indicators);
        return Arrays.stream(objects).collect(Collectors.toMap(dy -> dy.getLong("indicator"), dy -> dy.getString("indctrname")));
    }

    public DynamicObject queryAssessFormByActivityNumber(String number) {
        DynamicObject atcivityDy = ACTIVITY_ENTITY_SERVICE.queryAssessFormByActivityNumber(number);
        DynamicObject executeSchemeDy = EXECUTE_SCHEME_ENTITY.queryOne(atcivityDy.get("executescheme_id"));
        Long assessFormId = executeSchemeDy.getLong("assessform_id");
        return ASSESS_FORM_ENTITY_SERVICE.queryAssessFormByPk(assessFormId);
    }

    public DynamicObject[] getActObjIds(Long activityId, Integer nodeIndex, Long nodeId, String nodeStatus, boolean isComplete) {
        QFilter qFilter = null;
        if (isComplete) {
            DynamicObject activity = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(activityId);
            String assessStatus = activity.getString("activitystatus");
            DynamicObjectCollection timePlanEntry = activity.getDynamicObjectCollection("timeplanentry");
            if (ActivityStatusEnum.COMPLETED.getValue().equals(assessStatus)) {
                return new DynamicObject[0];
            }
            if (ActivityStatusEnum.EXECUTING.getValue().equals(assessStatus)) {
                if (timePlanEntry.size() == nodeIndex.intValue()) {
                    qFilter = new QFilter("activity", "=", (Object)activityId).and("assessstaus", "=", (Object)AssessStausEnum.COMPLETED.getStatus());
                } else if (timePlanEntry.size() > nodeIndex) {
                    qFilter = new QFilter("activity", "=", (Object)activityId).and("nodeindex", "=", (Object)nodeIndex).and("assessnode", "=", (Object)nodeId).and("nodestatus", "=", (Object)nodeStatus);
                }
            } else {
                qFilter = new QFilter("activity", "=", (Object)0L);
            }
        } else {
            qFilter = new QFilter("activity", "=", (Object)activityId).and("nodeindex", "=", (Object)nodeIndex).and("assessnode", "=", (Object)nodeId).and("nodestatus", "=", (Object)nodeStatus);
        }
        return ACT_EVAL_OBJ_ENTITY_SERVICE.query("id", new QFilter[]{qFilter});
    }

    public List<Long> queryNodeByDef(Object nodeDefId) {
        QFilter nodeDefFilter = new QFilter("flownodedef", "=", nodeDefId);
        DynamicObject[] dys = NODE_ENTITY_SERVICE.queryOriginalArray("id", new QFilter[]{nodeDefFilter});
        return Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public Map<Long, Long> queryNodeDefById(Set<Long> nodeRuIds) {
        DynamicObject[] ruNodes = NODE_ENTITY_SERVICE.query("flownodedef.nodetype", new QFilter[]{new QFilter("id", "in", nodeRuIds)});
        return Arrays.stream(ruNodes).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("flownodedef.nodetype.id")));
    }

    public int queryIndicatorCount(List<Long> actIds) {
        QFilter filter = new QFilter("actevalobj", "in", actIds);
        return IMPORT_SCORE_IND_ENTITY_SERVICE.count("epa_objimportscoreind", new QFilter[]{filter});
    }

    public boolean updateActEvaObjFlowInstance(Map<Long, Long> fomulateInsMap, Map<Long, Long> evalInsMap) {
        DynamicObject[] actEvaObjDyns;
        HashSet<Long> actEvaObjIdSet = new HashSet<Long>(16);
        actEvaObjIdSet.addAll(fomulateInsMap.keySet());
        actEvaObjIdSet.addAll(evalInsMap.keySet());
        QFilter qFilter = new QFilter("id", "in", actEvaObjIdSet);
        for (DynamicObject actEvaObjDyn : actEvaObjDyns = ACT_EVAL_OBJ_ENTITY_SERVICE.query("id,formulateflowins,evalflowins,startstatus", new QFilter[]{qFilter})) {
            if (null != fomulateInsMap.get(actEvaObjDyn.getLong("id"))) {
                actEvaObjDyn.set("formulateflowins", (Object)fomulateInsMap.get(actEvaObjDyn.getLong("id")));
            }
            if (null == evalInsMap.get(actEvaObjDyn.getLong("id"))) continue;
            actEvaObjDyn.set("evalflowins", (Object)evalInsMap.get(actEvaObjDyn.getLong("id")));
        }
        ACT_EVAL_OBJ_ENTITY_SERVICE.save(actEvaObjDyns);
        return Boolean.TRUE;
    }

    public List<Long> getIdsByIsSetted(Long activityId, Object flowId, String lastNodeStatus, Long lastNodeId, int lastIndex, Long nodeDefId) {
        DynamicObject[] objects = OBJ_CROSS_INDICATOR_ENTITY_SERVICE.queryIndicator(activityId, flowId, lastNodeStatus, lastNodeId, lastIndex);
        List indicatorIds = Arrays.stream(objects).map(dy -> dy.getLong("indicator")).collect(Collectors.toList());
        Map handerMap = CROSS_SCORE_DOMAIN_SERVICE.queryHandlerByCross(nodeDefId, indicatorIds);
        ArrayList<Long> list = new ArrayList<Long>(10);
        for (Map.Entry set : handerMap.entrySet()) {
            List crossRoleSets = ((QueryHandlerVO)set.getValue()).getCrossRoleSets();
            if (ObjectUtils.isEmpty((Object)crossRoleSets)) continue;
            list.add((Long)set.getKey());
        }
        return list;
    }

    public PushResultBo pushByObjIds(List<Long> objIds, Long activityId, String workFlowType) {
        DynamicObject[] objs = "2".equals(workFlowType) ? ACT_EVAL_OBJ_ENTITY_SERVICE.queryActivityEvaluationObjectById("id,person.name,person.number,evalflowins,evalflowins.currentnode", objIds) : INTERVIEW_OBJ_ENTITY_SERVICE.queryInterviewobjsById("id,person.name,person.number,interflowins,interflowins.currentnode", objIds);
        Map objIdDyMap = Arrays.stream(objs).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity()));
        String flowInsProp = "2".equals(workFlowType) ? "evalflowins.id" : "interflowins.id";
        String currentNodeProp = "2".equals(workFlowType) ? "evalflowins.currentnode.id" : "interflowins.currentnode.id";
        List ruProcIds = Arrays.stream(objs).map(dy -> dy.getLong(flowInsProp)).collect(Collectors.toList());
        List currentNodeId = Arrays.stream(objs).map(dy -> dy.getLong(currentNodeProp)).collect(Collectors.toList());
        Map<Long, Long> objProcMap = Arrays.stream(objs).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getLong(flowInsProp)));
        ArrayList<String> taskStatusList = new ArrayList<String>(10);
        taskStatusList.add(FlowRuTaskStatusEnum.WAITING.getCode());
        taskStatusList.add(FlowRuTaskStatusEnum.PROCESSING.getCode());
        taskStatusList.add(FlowRuTaskStatusEnum.PENDING.getCode());
        taskStatusList.add(FlowRuTaskStatusEnum.BE_WAITTING.getCode());
        DynamicObject[] taskDys = TASK_ENTITY_SERVICE.loadTasksByProcIdsAndStatus(ruProcIds, taskStatusList, currentNodeId);
        Map<Long, List<DynamicObject>> procTaskListMap = Arrays.stream(taskDys).collect(Collectors.groupingBy(obj -> obj.getLong("flowruproc.id")));
        HashMap<Long, List> objTaskListMap = new HashMap<Long, List>(16);
        objProcMap.forEach((objId, procId) -> {
            if (procTaskListMap.get(procId) != null) {
                objTaskListMap.put((Long)objId, (List)procTaskListMap.get(procId));
            }
        });
        List<Long> taskIdList = Arrays.stream(taskDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Map<Long, ReminderVO> taskReminderVOMap = this.pushTask(taskIdList);
        ArrayList<Long> successTaskList = new ArrayList<Long>(10);
        ArrayList<Long> failTaskList = new ArrayList<Long>(10);
        HashMap<Long, String> taskFailMessageMap = new HashMap<Long, String>(16);
        HashMap objFailMessageMap = new HashMap(16);
        for (Long objId2 : objIds) {
            List taskDyList = (List)objTaskListMap.get(objId2);
            if (taskDyList == null) continue;
            DynamicObject objDy = (DynamicObject)objIdDyMap.get(objId2);
            Iterator iterator = taskDyList.iterator();
            while (iterator.hasNext()) {
                DynamicObject taskDy = (DynamicObject)iterator.next();
                ReminderVO reminderVO = taskReminderVOMap.get(taskDy.get("id"));
                if (reminderVO == null || !reminderVO.isSucess()) {
                    failTaskList.add(taskDy.getLong("id"));
                    String taskStatus = taskDy.getString("taskstatus");
                    String taskStatusStr = EntityMetaDataUtils.getEntityComboFieldItemName((String)"epa_evalflowrutask", (String)"taskstatus", (String)taskStatus);
                    String failMessage = "";
                    if (reminderVO != null && reminderVO.getErrorType() == 2) {
                        failMessage = "2".equals(workFlowType) ? ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0} {1}\uff1a\u8bc4\u4f30\u4eba-{2}\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u4e3a\u201c\u5df2\u6302\u8d77\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"ActEvalObjManageDomainService_5", (String)"opmc-epa-business", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), taskDy.getString("handler.name")}) : ResManager.loadKDString((String)"\u9762\u8c08\u5bf9\u8c61-{0} {1}\uff1a\u5904\u7406\u4eba-{2}\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u4e3a\u201c\u5df2\u6302\u8d77\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"ActEvalObjManageDomainService_6", (String)"opmc-epa-business", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), taskDy.getString("handler.name")});
                    } else {
                        String string = failMessage = "2".equals(workFlowType) ? ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0} {1}\uff1a\u8bc4\u4f30\u4eba-{2}\u5728\u201c{3}\u201d\u8282\u70b9\u7684\u8bc4\u4f30\u4efb\u52a1\u5904\u5728\u201c{4}\u201d\uff0c\u65e0\u9700\u50ac\u529e", (String)"ActEvalObjManageDomainService_7", (String)"opmc-epa-business", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), taskDy.getString("handler.name"), taskDy.getString("flowrunode.name"), taskStatusStr}) : ResManager.loadKDString((String)"\u9762\u8c08\u5bf9\u8c61-{0} {1}\uff1a\u5904\u7406\u4eba-{2}\u5728\u201c{3}\u201d\u8282\u70b9\u7684\u9762\u8c08\u4efb\u52a1\u5904\u5728\u201c{4}\u201d\uff0c\u65e0\u9700\u50ac\u529e", (String)"ActEvalObjManageDomainService_8", (String)"opmc-epa-business", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), taskDy.getString("handler.name"), taskDy.getString("flowrunode.name"), taskStatusStr});
                    }
                    if (HRStringUtils.isEmpty((String)failMessage)) continue;
                    taskFailMessageMap.put(taskDy.getLong("id"), failMessage);
                    continue;
                }
                successTaskList.add(taskDy.getLong("id"));
            }
        }
        objTaskListMap.forEach((mObjId, taskList) -> {
            StringBuilder stb = new StringBuilder();
            if (taskList != null) {
                for (DynamicObject failTaskDy : taskList) {
                    if (taskFailMessageMap.get(failTaskDy.getLong("id")) == null) continue;
                    stb.append((String)taskFailMessageMap.get(failTaskDy.getLong("id")));
                    stb.append("\n");
                }
            }
            if (stb.length() > 0) {
                objFailMessageMap.put(mObjId, stb.substring(0, stb.length() - 1));
            }
        });
        StringBuilder failMessageStb = new StringBuilder();
        String failReasonMessage = "";
        for (Long fObjId : objIds) {
            if (objFailMessageMap.get(fObjId) == null) continue;
            failMessageStb.append((String)objFailMessageMap.get(fObjId));
            failMessageStb.append("\n");
        }
        if (failMessageStb.length() > 0) {
            failReasonMessage = failMessageStb.substring(0, failMessageStb.length() - 1);
        }
        PushResultBo pushResultBo = new PushResultBo();
        pushResultBo.setMessage(failReasonMessage);
        pushResultBo.setObjCount(objIds.size());
        pushResultBo.setTaskCount(taskDys.length);
        pushResultBo.setSuccessCount(successTaskList.size());
        pushResultBo.setFailCount(failTaskList.size());
        return pushResultBo;
    }

    public boolean isExitActivityObjByActivity(Long activityId) {
        return ACT_EVAL_OBJ_ENTITY_SERVICE.isExitActivityObjByActivity(activityId);
    }

    public List<DynamicObject> getEvaluatoies(Long roleId) {
        Map handerMap = FLOW_HANDLER_DOMAIN_SERVICE.queryHandlerByRuleIds(Collections.singletonList(roleId));
        List list = (List)handerMap.get(roleId);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return list.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>(10);
    }

    public Map<Long, String> getFlowInfo(List<Long> ruProcIds) {
        return FLOW_HANDLER_DOMAIN_SERVICE.getActEvaObjProcessInfo(ruProcIds);
    }

    public List<Long> queryIndicatorByObject(List<QFilter> filters) {
        DynamicObject[] indicators = OBJ_CROSS_INDICATOR_ENTITY_SERVICE.query("indicator", filters.toArray(new QFilter[0]));
        return Arrays.stream(indicators).map(indicator -> indicator.getLong("indicator")).collect(Collectors.toList());
    }

    public boolean checkCommonSort(Set<Long> roleIdSet) {
        DynamicObject[] ruRoles = ROLE_ENTITY_SERVICE.queryByPkValue(new ArrayList<Long>(roleIdSet));
        Set set = Arrays.stream(ruRoles).map(dy -> dy.getInt("turnoversort")).collect(Collectors.toSet());
        return set.size() == 1;
    }

    public Map<Long, String> returnEvalPersonCross(Map<Long, List<Long>> taskToIndicatorMap, String reason) {
        ArrayList<RollbackParamBo> rollbackParamBos = new ArrayList<RollbackParamBo>(10);
        for (Map.Entry<Long, List<Long>> entry : taskToIndicatorMap.entrySet()) {
            Long taskId = entry.getKey();
            List<Long> indicatorIds = entry.getValue();
            RollbackParamBo bo = new RollbackParamBo();
            bo.setReason(reason);
            bo.setRuTaskId(taskId);
            bo.setRollbackType("2");
            bo.setIndicatorIds(indicatorIds);
            rollbackParamBos.add(bo);
        }
        FlowValidateResultBo flowValidateResultBo = FLOW_RU_SECOND_DOMAIN_SERVICE.rollbackToSpecifiedTask(rollbackParamBos);
        return flowValidateResultBo.getValidateMap();
    }

    public Map<String, Set<Long>> queryNameOrNumRoleSetMap(List<Long> roleIds) {
        Map handlerMap = FLOW_HANDLER_DOMAIN_SERVICE.queryHandlerByRuleIds(roleIds);
        HashMap<Long, Set> roleNameOrNumSetMap = new HashMap<Long, Set>(16);
        for (Long roleId2 : roleIds) {
            List handlerList = (List)handlerMap.get(roleId2);
            if (ObjectUtils.isEmpty((Object)handlerList)) {
                roleNameOrNumSetMap.put(roleId2, this.getEmptyStrSet());
                continue;
            }
            HashSet<String> nameOrNumSet = new HashSet<String>(16);
            for (DynamicObject handler : handlerList) {
                if (handler == null) continue;
                String personName = handler.getString("name");
                String personNumber = handler.getString("number");
                if (HRStringUtils.isNotEmpty((String)personName)) {
                    nameOrNumSet.add(personName);
                }
                if (!HRStringUtils.isNotEmpty((String)personNumber)) continue;
                nameOrNumSet.add(personNumber);
            }
            if (nameOrNumSet.size() == 0) {
                roleNameOrNumSetMap.put(roleId2, this.getEmptyStrSet());
            }
            roleNameOrNumSetMap.put(roleId2, nameOrNumSet);
        }
        HashMap<String, Set<Long>> nameOrNumRoleSetMap = new HashMap<String, Set<Long>>(16);
        roleNameOrNumSetMap.forEach((roleId, personInfoSet) -> personInfoSet.forEach(personNameOrNum -> {
            Set roleSet = (Set)nameOrNumRoleSetMap.get(personNameOrNum);
            if (roleSet != null) {
                roleSet.add(roleId);
            } else {
                HashSet<Long> acrossIdSetNew = new HashSet<Long>(16);
                acrossIdSetNew.add((Long)roleId);
                nameOrNumRoleSetMap.put((String)personNameOrNum, (Set<Long>)acrossIdSetNew);
            }
        }));
        return nameOrNumRoleSetMap;
    }

    private Set<String> getEmptyStrSet() {
        HashSet<String> emptyStrSet = new HashSet<String>(1);
        emptyStrSet.add("");
        return emptyStrSet;
    }

    public List<Long> queryByListDefaultFilter(Long activityId, Object seq, Long flowId, String lastNodeStatus, Long lastNodeId, int lastIndex) {
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and("evalflow", "=", (Object)flowId).and("nodestatus", "=", (Object)lastNodeStatus).and("assessnode", "=", (Object)lastNodeId).and("nodeindex", "=", (Object)lastIndex);
        DynamicObject[] objDys = ACT_EVAL_OBJ_ENTITY_SERVICE.queryOriginalArray("id,evalflowins.id", new QFilter[]{filter});
        List objIds = Arrays.stream(objDys).map(evalObjDy -> evalObjDy.getLong("evalflowins.id")).collect(Collectors.toList());
        return ROLE_ENTITY_SERVICE.queryByRuNodeIndexAndRuProc(seq, objIds);
    }

    public List<Long> queryFormulatorByListDefaultFilter(Long activityId, Object seq, Long flowId) {
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and("formulateflow", "=", (Object)Long.parseLong(flowId.toString())).and("assessstaus", "=", (Object)AssessStausEnum.JOINED.getStatus());
        DynamicObject[] objDys = ACT_EVAL_OBJ_ENTITY_SERVICE.queryOriginalArray("id,formulateflowins.id", new QFilter[]{filter});
        List objIds = Arrays.stream(objDys).map(evalObjDy -> evalObjDy.getLong("formulateflowins.id")).collect(Collectors.toList());
        return ROLE_ENTITY_SERVICE.queryByRuNodeIndexAndRuProc(seq, objIds);
    }

    public Map<String, Set<Long>> getAcrossIds(QFilter qFilter, Long nodeDefId) {
        HashMap indicatorPersonInfoSetMap = new HashMap(16);
        DynamicObject[] crossData = OBJ_CROSS_INDICATOR_ENTITY_SERVICE.queryByFilter(qFilter);
        Map<Long, Long> idMap = Arrays.stream(crossData).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("indicator")));
        Map handerMap = CROSS_SCORE_DOMAIN_SERVICE.queryHandlerByCross(nodeDefId, new ArrayList<Long>(idMap.values()));
        for (Map.Entry set : handerMap.entrySet()) {
            List list = ((QueryHandlerVO)set.getValue()).getCrossRoleSets();
            if (ObjectUtils.isEmpty((Object)list)) continue;
            Map<Integer, List<DynamicObject>> turnMap = list.stream().collect(Collectors.groupingBy(dy -> dy.getInt("turnoversort")));
            List keyList = turnMap.keySet().stream().sorted().distinct().collect(Collectors.toList());
            HashSet<String> personNameOrNumberSet = new HashSet<String>(16);
            for (Integer sort : keyList) {
                List<DynamicObject> list2 = turnMap.get(sort);
                for (DynamicObject dy2 : list2) {
                    DynamicObjectCollection cols = dy2.getDynamicObjectCollection("entryentity");
                    for (DynamicObject obj : cols) {
                        String personName = obj.getDynamicObject("handlerid").getString("name");
                        String personNumber = obj.getDynamicObject("handlerid").getString("number");
                        if (HRStringUtils.isNotEmpty((String)personName)) {
                            personNameOrNumberSet.add(personName);
                        }
                        if (!HRStringUtils.isNotEmpty((String)personNumber)) continue;
                        personNameOrNumberSet.add(personNumber);
                    }
                }
            }
            indicatorPersonInfoSetMap.put(set.getKey(), personNameOrNumberSet);
        }
        HashMap<Long, Set> crossIdPersonInfoSetMap = new HashMap<Long, Set>(16);
        for (Map.Entry entry : idMap.entrySet()) {
            long crossId = (Long)entry.getKey();
            long indicatorId = (Long)entry.getValue();
            Set personNameOrNumInInSet = (Set)indicatorPersonInfoSetMap.get(indicatorId);
            if (personNameOrNumInInSet == null || personNameOrNumInInSet.size() == 0) {
                crossIdPersonInfoSetMap.put(crossId, this.getEmptyStrSet());
                continue;
            }
            crossIdPersonInfoSetMap.put(crossId, personNameOrNumInInSet);
        }
        HashMap<String, Set<Long>> personNameOrNumAcrossIdsMap = new HashMap<String, Set<Long>>(16);
        crossIdPersonInfoSetMap.forEach((acrossId, personInfoSet) -> personInfoSet.forEach(personNameOrNum -> {
            Set acrossIdSet = (Set)personNameOrNumAcrossIdsMap.get(personNameOrNum);
            if (acrossIdSet != null) {
                acrossIdSet.add(acrossId);
            } else {
                HashSet<Long> acrossIdSetNew = new HashSet<Long>(16);
                acrossIdSetNew.add((Long)acrossId);
                personNameOrNumAcrossIdsMap.put((String)personNameOrNum, (Set<Long>)acrossIdSetNew);
            }
        }));
        return personNameOrNumAcrossIdsMap;
    }

    public List<EvaluatorListDataBO> getEvaluatorListData(Long activityId, Object nodeIndex) {
        ArrayList<EvaluatorListDataBO> evaluatorListDataBOs = new ArrayList<EvaluatorListDataBO>(10);
        DynamicObject[] objs = this.queryToBeEvalObjs(activityId, nodeIndex);
        Map evalFlowInstIdMap = Arrays.stream(objs).filter(obj -> obj.getLong("evalflowins.id") != 0L).collect(Collectors.toMap(obj -> obj.getLong("evalflowins.id"), Function.identity()));
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and("flowruproc", "in", evalFlowInstIdMap.keySet()).and("iscrossrole", "!=", (Object)Boolean.TRUE);
        String selectPro = "flowruproc, flowrunode, issethandler,turnoversort";
        DynamicObject[] roleArr = ROLE_ENTITY_SERVICE.query(selectPro, new QFilter[]{filter});
        List<Long> roleIds = Arrays.stream(roleArr).map(role -> role.getLong("id")).collect(Collectors.toList());
        ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = new ActEvalObjManageApplicationService();
        Map<Long, List<DynamicObject>> roleHandlerMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryHandlerByRoleIds(roleIds);
        for (DynamicObject role2 : roleArr) {
            List<DynamicObject> roleHandleList;
            EvaluatorListDataBO dataBO = new EvaluatorListDataBO();
            DynamicObject evalObj = (DynamicObject)evalFlowInstIdMap.get(role2.getLong("flowruproc.id"));
            String personName = evalObj.getString("person.name");
            dataBO.setPerfFileNumber(evalObj.getString("perffile.number"));
            dataBO.setName(personName);
            dataBO.setNumber(evalObj.getString("person.number"));
            String processName = role2.getString("flowruproc.name").replace(personName, "");
            dataBO.setProcessName(processName);
            dataBO.setNodeName(role2.getString("flowrunode.name"));
            if (!ObjectUtils.isEmpty(roleHandlerMap) && !ObjectUtils.isEmpty(roleHandleList = roleHandlerMap.get(role2.getLong("id")))) {
                String handler = roleHandleList.stream().filter(Objects::nonNull).map(roleHandler -> roleHandler.getString("name") + "(" + roleHandler.getString("number") + ")").collect(Collectors.joining(","));
                dataBO.setHandle(handler);
            }
            dataBO.setTurnoversort(role2.getInt("turnoversort"));
            dataBO.setIsSetHandler(role2.getBoolean("issethandler") ? ResManager.loadKDString((String)"\u662f", (String)"ActEvalObjManageDomainService_3", (String)"opmc-epa-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ActEvalObjManageDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]));
            dataBO.setRole(role2.getString("name"));
            dataBO.setJob(evalObj.getString("empposrel.position.name"));
            dataBO.setAdminorg(evalObj.getString("affiliateadminorg.name"));
            dataBO.setBelongCom(evalObj.getString("empposrel.company.name"));
            evaluatorListDataBOs.add(dataBO);
        }
        return evaluatorListDataBOs;
    }

    public List<AcrossEvaluatorListDataBO> getAcrossEvaluatorListData(Long activityId, Object nodeIndex) {
        ArrayList<AcrossEvaluatorListDataBO> acrossEvaluatorListDataBOS = new ArrayList<AcrossEvaluatorListDataBO>(10);
        DynamicObject[] objs = this.queryToBeEvalObjs(activityId, nodeIndex);
        List<Long> objIds = Arrays.stream(objs).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        String selectField = "actevalobj.perffile.name, person.number,actevalobj.affiliateadminorg.name,indctrname,actevalobj.perffile.number,actevalobj.perffile.position,actevalobj.perffile.company.name,actevalobj.modifytime,actevalobj.evalflow";
        DynamicObject[] actevalobjinds = OBJ_CROSS_INDICATOR_ENTITY_SERVICE.queryIndicatorFieldByObjIds(selectField, objIds);
        Map<Long, List<DynamicObject>> flowEvalIndMap = Arrays.stream(actevalobjinds).collect(Collectors.groupingBy(obj -> obj.getLong("actevalobj.evalflow.id")));
        Map<Long, Long> inIdPerfFileIdMap = Arrays.stream(actevalobjinds).collect(Collectors.toMap(itemL -> itemL.getLong("id"), itemB -> itemB.getLong("actevalobj.perffile.id")));
        ArrayList<Long> perfFileIdList = new ArrayList<Long>(inIdPerfFileIdMap.values());
        DynamicObject[] perffileListByIds = PERFFILE_ENTITY_SERVICE.getPerffileListByIds("position.name,company.name", perfFileIdList);
        Map idPerfFileMap = Arrays.stream(perffileListByIds).collect(Collectors.toMap(itemL -> itemL.getLong("id"), Function.identity()));
        HashMap inIdPerfFileDyMap = new HashMap(16);
        inIdPerfFileIdMap.forEach((inId, perfFileId) -> inIdPerfFileDyMap.put(inId, idPerfFileMap.get(perfFileId)));
        ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = new ActEvalObjManageApplicationService();
        Map<Object, Long> flowsCount = Arrays.stream(objs).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("evalflow").getPkValue(), Collectors.counting()));
        DynamicObject[] flows = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowByPkValue(flowsCount.keySet());
        List flowIdList = Arrays.stream(flows).map(flow -> flow.getLong("id")).collect(Collectors.toList());
        DynamicObject perfWorkFlow = ACTIVITY_DOMAIN_SERVICE.queryPerfWorkFlow(activityId);
        DynamicObjectCollection flowEntry = perfWorkFlow.getDynamicObjectCollection("flowentry");
        Map<Long, Boolean> temMap = flowEntry.stream().collect(Collectors.toMap(itemL -> itemL.getLong("flowvid"), itemB -> itemB.getBoolean("isdefaultflow")));
        Arrays.stream(flows).forEach(item -> {
            if (temMap.containsKey(item.getLong("id"))) {
                item.set("isdefault", temMap.get(item.getLong("id")));
            }
        });
        Map<Long, String> flowNameMap = Arrays.stream(flows).collect(Collectors.toMap(flow -> flow.getLong("id"), flow -> flow.getString("name")));
        Map<Long, List> flowNodeMap = Arrays.stream(flows).collect(Collectors.toMap(flow -> flow.getLong("id"), flow -> {
            Long flowProcId = ((DynamicObject)flow.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            DynamicObject flowProc = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowProcPkValue(flowProcId);
            return flowProc.getDynamicObjectCollection("nodeentry").stream().filter(dy -> dy.getBoolean("crossscore")).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }));
        ArrayList nodeIdList = new ArrayList(10);
        for (Long flowId2 : flowIdList) {
            List nodeIdList1 = flowNodeMap.get(flowId2);
            nodeIdList.addAll(nodeIdList1);
        }
        HashMap NodeFlowMap = new HashMap(16);
        HashMap nodeIndEvaluatorMap = new HashMap(16);
        flowNodeMap.forEach((flowId, defNodeIdList) -> {
            for (Long defNodeId : defNodeIdList) {
                List indsInFlow = (List)flowEvalIndMap.get(flowId);
                Object[] inIds = indsInFlow.stream().map(obj -> obj.get("id")).collect(Collectors.toList()).toArray();
                Map<Long, String> evaluatorMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getEvaluatorMap(defNodeId, inIds);
                nodeIndEvaluatorMap.put(defNodeId, evaluatorMap);
                NodeFlowMap.put(defNodeId, flowId);
            }
        });
        DynamicObject[] flowDefNodes = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(nodeIdList);
        Map<Long, String> nodeIdNameMap = Arrays.stream(flowDefNodes).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("nodename")));
        for (Long flowId3 : flowIdList) {
            List<DynamicObject> evalObjInd = flowEvalIndMap.get(flowId3);
            List tNodeIdList = flowNodeMap.get(flowId3);
            for (DynamicObject indy : evalObjInd) {
                for (Long tNodeId : tNodeIdList) {
                    Map evaluatorMap = (Map)nodeIndEvaluatorMap.get(tNodeId);
                    if (evaluatorMap == null) continue;
                    String evalName = (String)evaluatorMap.get(indy.getLong("id"));
                    AcrossEvaluatorListDataBO acrossEvaluatorListDataBO = new AcrossEvaluatorListDataBO();
                    acrossEvaluatorListDataBO.setFileNo(indy.getString("actevalobj.perffile.number"));
                    acrossEvaluatorListDataBO.setName(indy.getString("actevalobj.perffile.name"));
                    acrossEvaluatorListDataBO.setPersonNumber(indy.getString("person.number"));
                    acrossEvaluatorListDataBO.setAdminOrgName(indy.getString("actevalobj.affiliateadminorg.name"));
                    acrossEvaluatorListDataBO.setIndName(indy.getString("indctrname"));
                    String flowName = flowNameMap.get(NodeFlowMap.get(tNodeId));
                    acrossEvaluatorListDataBO.setFlowName(flowName);
                    acrossEvaluatorListDataBO.setDefNodeName(nodeIdNameMap.get(tNodeId));
                    acrossEvaluatorListDataBO.setEvalName(evalName);
                    String yes = ResManager.loadKDString((String)"\u662f", (String)"ActEvalObjManageDomainService_3", (String)"opmc-epa-business", (Object[])new Object[0]);
                    String no = ResManager.loadKDString((String)"\u5426", (String)"ActEvalObjManageDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]);
                    acrossEvaluatorListDataBO.setIsSetHandler(StringUtils.isNotBlank((CharSequence)evalName) ? yes : no);
                    acrossEvaluatorListDataBO.setJob(((DynamicObject)inIdPerfFileDyMap.get(indy.getLong("id"))).getString("position.name"));
                    acrossEvaluatorListDataBO.setBelongCom(((DynamicObject)inIdPerfFileDyMap.get(indy.getLong("id"))).getString("company.name"));
                    acrossEvaluatorListDataBOS.add(acrossEvaluatorListDataBO);
                }
            }
        }
        return acrossEvaluatorListDataBOS;
    }

    public Map<Long, String> getActEvalObjPerffileNamesByObjIds(List<Long> evalObjIds) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        DynamicObject[] actevalObjs = ACT_EVAL_OBJ_ENTITY_SERVICE.queryActivityEvaluationObjectById("id,perffile.id", evalObjIds);
        DynamicObject[] perfFiles = PERFFILE_ENTITY_SERVICE.getPerffileListByIds("id,name", Arrays.stream(actevalObjs).map(e -> e.getLong("perffile.id")).distinct().collect(Collectors.toList()));
        Map<Long, DynamicObject> perFilesMap = Arrays.stream(perfFiles).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<Long, DynamicObject> actevalObjMap = Arrays.stream(actevalObjs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (Long evalObjId : evalObjIds) {
            resultMap.computeIfAbsent(evalObjId, v -> {
                Long perFileId = actevalObjMap.get(evalObjId) == null ? 0L : ((DynamicObject)actevalObjMap.get(evalObjId)).getLong("perffile.id");
                return perFilesMap.get(perFileId) == null ? "" : ((DynamicObject)perFilesMap.get(perFileId)).getString("name");
            });
        }
        return resultMap;
    }

    public Map<Long, Map<String, String>> getActEvalObjPerffilePersonInfoByObjIds(List<Long> evalObjIds) {
        HashMap<Long, Map<String, String>> resultMap = new HashMap<Long, Map<String, String>>(16);
        DynamicObject[] actevalObjs = ACT_EVAL_OBJ_ENTITY_SERVICE.queryActivityEvaluationObjectById("id,perffile.id", evalObjIds);
        DynamicObject[] perfFiles = PERFFILE_ENTITY_SERVICE.getPerffileListByIds("id,name,billno", Arrays.stream(actevalObjs).map(e -> e.getLong("perffile.id")).distinct().collect(Collectors.toList()));
        Map<Long, DynamicObject> perFilesMap = Arrays.stream(perfFiles).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<Long, DynamicObject> actevalObjMap = Arrays.stream(actevalObjs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (Long evalObjId : evalObjIds) {
            resultMap.computeIfAbsent(evalObjId, v -> {
                HashMap<String, String> perFilePersonInfo = new HashMap<String, String>(16);
                if (actevalObjMap.get(evalObjId) != null) {
                    Long perFileId = ((DynamicObject)actevalObjMap.get(evalObjId)).getLong("perffile.id");
                    perFilePersonInfo.put("billno", perFilesMap.get(perFileId) == null ? "" : ((DynamicObject)perFilesMap.get(perFileId)).getString("billno"));
                    perFilePersonInfo.put("name", perFilesMap.get(perFileId) == null ? "" : ((DynamicObject)perFilesMap.get(perFileId)).getString("name"));
                    return perFilePersonInfo;
                }
                return null;
            });
        }
        return resultMap;
    }

    public DynamicObject[] queryEvaluatedObj(Long activityId) {
        return this.queryNormalEvaluated(activityId);
    }

    public Map<Long, TaskCrossBo> queryTaskCrossInfo(List<Object> idList) {
        DynamicObject[] dys = RUTASK_IND_RELATION_ENTITY_SERVICE.queryById(idList);
        List<Long> indicatorIds = Arrays.stream(dys).map(dy -> dy.getLong("indicator")).collect(Collectors.toList());
        DynamicObject[] crossIndDys = OBJ_CROSS_INDICATOR_ENTITY_SERVICE.queryByIndicatorId(indicatorIds);
        Map crossIndMap = Arrays.stream(crossIndDys).collect(Collectors.toMap(dy -> dy.getLong("indicator"), Function.identity()));
        List roleIds = Arrays.stream(dys).map(dy -> dy.getLong("rutask.flowrurole.id")).collect(Collectors.toList());
        DynamicObject[] roleDys = ROLE_ENTITY_SERVICE.queryByPkValue(roleIds);
        Map roleDyMap = Arrays.stream(roleDys).collect(Collectors.toMap(dy -> (Long)dy.getPkValue(), Function.identity()));
        HashMap<Long, TaskCrossBo> map = new HashMap<Long, TaskCrossBo>(dys.length);
        for (DynamicObject dy2 : dys) {
            DynamicObject crossInd = (DynamicObject)crossIndMap.get(dy2.getLong("indicator"));
            DynamicObject roleDy = (DynamicObject)roleDyMap.get(dy2.getLong("rutask.flowrurole.id"));
            TaskCrossBo taskCrossBo = new TaskCrossBo();
            taskCrossBo.setEntryid((Long)dy2.getPkValue());
            taskCrossBo.setIndicator(crossInd.getLong("indicator"));
            taskCrossBo.setAreaName(crossInd.getString("areaname"));
            taskCrossBo.setIndicatorName(crossInd.getString("indctrname"));
            taskCrossBo.setRutask(dy2.getLong("rutask.id"));
            taskCrossBo.setRoleStatus(roleDy.getString("rolestatus"));
            taskCrossBo.setRoleTurnoverSort(roleDy.getInt("turnoversort"));
            map.put((Long)dy2.getPkValue(), taskCrossBo);
        }
        return map;
    }

    public Map<Long, String> getObjFlowInfo(List<Long> objIds) {
        if (objIds == null || objIds.size() == 0) {
            return new HashMap<Long, String>();
        }
        DynamicObject[] objs = ACT_EVAL_OBJ_ENTITY_SERVICE.queryActivityEvaluationObjectById("evalflowins.id", objIds);
        Map<Long, Long> objFlowMap = Arrays.stream(objs).collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getLong("evalflowins.id")));
        List<Long> ruProcIds = Arrays.stream(objs).map(dy -> dy.getLong("evalflowins.id")).collect(Collectors.toList());
        Map<Long, String> flowIdInfoMap = this.getFlowInfo(ruProcIds);
        HashMap<Long, String> objFlowInfoMap = new HashMap<Long, String>(16);
        objFlowMap.forEach((obj, flow) -> objFlowInfoMap.put((Long)obj, (String)flowIdInfoMap.get(flow)));
        return objFlowInfoMap;
    }

    public Map<Object, Long> queryFormulateMonitorFlowsMap(Long activityId) {
        DynamicObject[] objs = ACT_EVAL_OBJ_ENTITY_SERVICE.queryFormulateMonitorObjs(activityId);
        return Arrays.stream(objs).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("formulateflow").getPkValue(), Collectors.counting()));
    }

    public Map<Object, Long> queryInterViewMonitorFlowsMap(Long activityId) {
        DynamicObject[] objs = INTERVIEW_OBJ_ENTITY_SERVICE.queryInterObjNoTOBe(activityId);
        return Arrays.stream(objs).collect(Collectors.groupingBy(obj -> obj.getLong("interflow.id"), Collectors.counting()));
    }

    public boolean updateIntObjFlowInstance(Map<Long, Long> intInsMap) {
        DynamicObject[] intObjDyns;
        HashSet<Long> actEvaObjIdSet = new HashSet<Long>(16);
        actEvaObjIdSet.addAll(intInsMap.keySet());
        QFilter qFilter = new QFilter("id", "in", actEvaObjIdSet);
        for (DynamicObject intObjDyn : intObjDyns = INTERVIEW_OBJ_ENTITY_SERVICE.query("id,interflowins", new QFilter[]{qFilter})) {
            if (null == intInsMap.get(intObjDyn.getLong("id"))) continue;
            intObjDyn.set("interflowins", (Object)intInsMap.get(intObjDyn.getLong("id")));
        }
        INTERVIEW_OBJ_ENTITY_SERVICE.save(intObjDyns);
        return Boolean.TRUE;
    }

    public int getNodeIndexByActId(long activityId, NodeTabMapEnum nodeEnum) {
        DynamicObject activity = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(activityId);
        DynamicObjectCollection timePlanEntry = activity.getDynamicObjectCollection("timeplanentry");
        DynamicObject node = timePlanEntry.stream().filter(dy -> dy.getDynamicObject("activity").getLong("id") == nodeEnum.getNodeId().longValue()).findAny().orElse(null);
        int seq = timePlanEntry.indexOf((Object)node);
        return seq + 1;
    }

    public List<Long> getUserIdsByDepempIds(List<Long> evals) {
        List<Long> userIdList = new ArrayList<Long>(10);
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("sign", "depemp");
        requestMap.put("signList", evals);
        Map infoMap = DEPEMP_SERVICE.listEmpOrgRelGroup(requestMap);
        boolean success = (Boolean)infoMap.get("success");
        LOG.info("getUserIdsByDepempIds.listEmpOrgRelGroup result :{}", (Object)success);
        if (success) {
            ArrayList<Long> personIdList = new ArrayList<Long>(10);
            Map data = (Map)infoMap.get("data");
            for (Map.Entry set : data.entrySet()) {
                List value = (List)set.getValue();
                List personIds = value.stream().map(map -> (Long)map.get("person_id")).collect(Collectors.toList());
                personIdList.addAll(personIds);
            }
            userIdList = this.getUserIdByPersonInfo(personIdList);
            LOG.info("getUserIdsByDepempIds.personIdList result :{}", personIdList);
        }
        LOG.info("getUserIdsByDepempIds.userIdList result :{}", userIdList);
        return userIdList;
    }

    private List<Long> getUserIdByPersonInfo(List<Long> personIdList) {
        ArrayList<Long> userIdList = new ArrayList<Long>(10);
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>(16);
        idMaps.put("person", personIdList);
        Map userIdByPersonInfo = PERSON_SERVICE.getUserIdByPersonInfo(idMaps);
        Map data = (Map)userIdByPersonInfo.get("data");
        boolean success = (Boolean)userIdByPersonInfo.get("success");
        if (success && data != null) {
            for (Long personId : personIdList) {
                Map userInfo = (Map)data.get(personId);
                long userId = userInfo == null ? 0L : (Long)userInfo.get("user");
                userIdList.add(userId);
            }
        }
        return userIdList;
    }

    public boolean isExistHaveInHandCompleteAssess(Long activityId, Long nodeId) {
        HashSet<String> nodeStatus = new HashSet<String>(Arrays.asList(AssessNodeStatusEnum.TARGET_FORMULATING.getStatus(), AssessNodeStatusEnum.TARGET_FORMULATED.getStatus()));
        switch (nodeId.intValue()) {
            case 1: {
                nodeStatus = new HashSet<String>(Arrays.asList(AssessNodeStatusEnum.TARGET_FORMULATING.getStatus(), AssessNodeStatusEnum.TARGET_FORMULATED.getStatus()));
                break;
            }
            case 4: {
                nodeStatus = new HashSet<String>(Arrays.asList(AssessNodeStatusEnum.EVALUATING.getStatus(), AssessNodeStatusEnum.EVALUATED.getStatus()));
                break;
            }
            case 8: {
                nodeStatus = new HashSet<String>(Arrays.asList(AssessNodeStatusEnum.CONFIRMING.getStatus(), AssessNodeStatusEnum.CONFIRMED.getStatus()));
            }
        }
        return ACT_EVAL_OBJ_ENTITY_SERVICE.queryAssHaveInHandOrCompleteCountByActId(activityId, nodeId, nodeStatus) > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public List<FlowCommonResultBo> verifyUserIsValid(List<Long> userIds) {
        return FLOW_ASSIST_DOMAIN_SERVICE.verifyUserIsValid(userIds, UserTypeEnum.PLATFORM_USER);
    }

    public Map<Long, String> checkUserEnable(List<Long> evals) {
        List resultBos = FLOW_ASSIST_DOMAIN_SERVICE.verifyUserIsValid(evals, UserTypeEnum.PLATFORM_USER);
        return resultBos.stream().filter(dy -> HRStringUtils.equals((String)dy.getCode(), (String)"-1")).collect(Collectors.toMap(FlowCommonResultBo::getDataId, FlowCommonResultBo::getMessage));
    }

    public void saveCoorganizer(DynamicObject[] coorganizers) {
        COORGANIZER_ENTITY_SERVICE.save(coorganizers);
    }

    public String checkDupCoorganizer(DynamicObject coorganizer) {
        Long activityId = coorganizer.getLong("activity");
        Long authorizedId = coorganizer.getLong("authorized.id");
        String bussinessStr = coorganizer.getString("business");
        String[] bussinessArr = bussinessStr.split(",");
        List<String> bussinessList = Arrays.stream(bussinessArr).filter(bussiness -> !HRStringUtils.isEmpty((String)bussiness)).collect(Collectors.toList());
        Date periodStartDate = coorganizer.getDate("period_startdate");
        Date periodEndDate = coorganizer.getDate("period_enddate");
        Long id = coorganizer.getLong("id");
        DynamicObject[] coorganizers = null;
        coorganizers = id != null && id != 0L ? COORGANIZER_ENTITY_SERVICE.queryActRecordByObjIds(activityId, authorizedId, Collections.singletonList(coorganizer.getString("thisbusiness")), periodStartDate, periodEndDate, id) : COORGANIZER_ENTITY_SERVICE.queryActRecordByObjIds(activityId, authorizedId, bussinessList, periodStartDate, periodEndDate, id);
        if (coorganizers != null && coorganizers.length > 0) {
            List thisbusinessList = Arrays.stream(coorganizers).map(dy -> dy.getString("thisbusiness")).collect(Collectors.toList());
            List listWithoutDuplicates = thisbusinessList.stream().distinct().collect(Collectors.toList());
            StringBuilder businessNameStb = new StringBuilder();
            for (String thisbusinessStr : listWithoutDuplicates) {
                String businessName = EntityMetaDataUtils.getEntityComboFieldItemName((String)"epa_cooporganizer", (String)"thisbusiness", (String)thisbusinessStr);
                businessNameStb.append(businessName).append("\u3001");
            }
            String businessName = "";
            String result = "";
            if (businessNameStb.length() > 1) {
                businessName = businessNameStb.substring(0, businessNameStb.length() - 1);
                result = ResManager.loadKDString((String)"\u6388\u6743\u4eba\u5df2\u6388\u6743{0}", (String)"ActEvalObjManageDomainService_9", (String)"opmc-epa-business", (Object[])new Object[]{businessName});
            }
            return result;
        }
        return "";
    }

    public Map<Long, List<Long>> getCooperator(Long activityId, List<Long> authorizedIdList, String businessType) {
        HashMap<Long, List<Long>> authorCoopListMap = new HashMap<Long, List<Long>>(16);
        DynamicObject[] coorganizers = COORGANIZER_ENTITY_SERVICE.queryByActivityIdAndBusiness(activityId, authorizedIdList, businessType);
        if (coorganizers != null && coorganizers.length > 0) {
            for (DynamicObject coorDy : coorganizers) {
                ArrayList<Long> coorganizerIdList = new ArrayList<Long>(10);
                DynamicObjectCollection coorganizerReColl = coorDy.getDynamicObjectCollection("coorganizer");
                if (coorganizerReColl != null) {
                    for (DynamicObject coorganizerRe : coorganizerReColl) {
                        coorganizerIdList.add(coorganizerRe.getLong("fbasedataid_id"));
                    }
                }
                authorCoopListMap.put(coorDy.getLong("authorized.id"), coorganizerIdList);
            }
        }
        return authorCoopListMap;
    }

    public int countCoorganizerByActivityId(Long activityId) {
        return COORGANIZER_ENTITY_SERVICE.countByActivityId(activityId);
    }

    public void syncAttach(DynamicObject coorganizerDyV) {
        DynamicObject[] coorcopy;
        if (coorganizerDyV.getLong("sourceid") != 0L) {
            return;
        }
        coorganizerDyV.set("sourceid", (Object)coorganizerDyV.getLong("id"));
        COORGANIZER_ENTITY_SERVICE.saveOne(coorganizerDyV);
        HRBaseServiceHelper attachmentServiceHelper = new HRBaseServiceHelper("bos_attachment");
        QFilter filter = new QFilter("fbilltype", "=", (Object)"epa_cooporganizer");
        filter.and("finterid", "=", (Object)Long.toString(coorganizerDyV.getLong("id")));
        DynamicObject[] attachs = attachmentServiceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        QFilter coorCopyFilter = new QFilter("authorized.id", "=", (Object)coorganizerDyV.getLong("authorized.id"));
        coorCopyFilter.and("thisbusiness", "!=", (Object)coorganizerDyV.getString("thisbusiness"));
        coorCopyFilter.and("activity", "=", (Object)coorganizerDyV.getLong("activity"));
        for (DynamicObject coorganizer : coorcopy = COORGANIZER_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{coorCopyFilter})) {
            coorganizer.set("sourceid", (Object)coorganizerDyV.getLong("id"));
        }
        COORGANIZER_ENTITY_SERVICE.save(coorcopy);
        List coorIdList = Arrays.stream(coorcopy).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        ArrayList<DynamicObject> attachments = new ArrayList<DynamicObject>(16);
        long[] ids = new long[]{};
        int index = 0;
        if (attachs.length > 0) {
            ids = ORM.create().genLongIds("bos_attachment", attachs.length * coorIdList.size());
        }
        for (int i = 0; i < coorIdList.size(); ++i) {
            for (DynamicObject dynamicObject : attachs) {
                DynamicObject emptyDynamicObject = attachmentServiceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)emptyDynamicObject);
                emptyDynamicObject.set("id", (Object)ids[index++]);
                emptyDynamicObject.set("finterid", coorIdList.get(i));
                emptyDynamicObject.set("fbilltype", (Object)"epa_cooporganizer");
                attachments.add(emptyDynamicObject);
            }
        }
        attachmentServiceHelper.save(attachments.toArray(new DynamicObject[0]));
    }

    public PerfSumCalResultBo resetDefaultRule(List<Long> objIds) {
        DynamicObject[] objects;
        for (DynamicObject obj : objects = ACT_EVAL_OBJ_ENTITY_SERVICE.queryMpByObjIds(objIds)) {
            obj.set("ismprmodify", (Object)false);
            obj.set("mprsource", (Object)2);
            obj.set("mprule", null);
            obj.set("mprealrule", null);
        }
        ACT_EVAL_OBJ_ENTITY_SERVICE.save(objects);
        PerfSumCalDomainService PERF_SUM_CAL_DOMAIN_SERVICE = new PerfSumCalDomainService();
        return PERF_SUM_CAL_DOMAIN_SERVICE.batchCalPerfSumData(objIds, PerfSumTaskTypeEnum.RESET_RULE);
    }

    public DynamicObject[] queryMpResultByObjId(Long objId) {
        return MP_CALC_ITEM_ENTITY_SERVICE.queryMpResultByObjId(objId);
    }

    public DynamicObject queryMpRuleByPkValue(Object pkValue) {
        return MP_RULE_ENTITY_SERVICE.loadSingle(pkValue);
    }

    public DynamicObject[] loadTaskEntryDy(Long[] taskEntryIds) {
        return FLOW_RU_TASK_IND_ENTRY_SERVICE.loadDynamicObjectArray((Object[])taskEntryIds);
    }

    public DynamicObject[] loadTaskByEntryId(Long[] taskEntryIds) {
        DynamicObject[] taskEntryDys = FLOW_RU_TASK_IND_ENTRY_SERVICE.loadDynamicObjectArray((Object[])taskEntryIds);
        List<Long> taskIds = Arrays.stream(taskEntryDys).map(dataEntity -> dataEntity.getLong("rutask.id")).collect(Collectors.toList());
        ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = new ActEvalObjManageApplicationService();
        return ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryTaskByIds(taskIds);
    }

    public DynamicObject queryFlowById(Long perflowId) {
        return PERF_WORK_FLOW_ENTITY_SERVICE.loadDynamicObject(new QFilter("id", "=", (Object)perflowId));
    }

    public String mplopMapping(long flowId, long assessFormId, String mplop) {
        Long sumperflevelId;
        DynamicObject perfworkflow = PERF_WORK_FLOW_ENTITY_SERVICE.loadDynamicObject(new QFilter("id", "=", (Object)flowId));
        String mplevelset = perfworkflow.getString("mplevelset");
        if ("1".equals(mplevelset)) {
            DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryOne(assessFormId);
            sumperflevelId = assessForm.getLong("sumperflevel.id");
        } else {
            sumperflevelId = perfworkflow.getLong("sumperflevel.id");
        }
        return this.getMappingResultByMplop(sumperflevelId, mplop);
    }

    public String getMappingResultByMplop(Long sumperflevelId, String mplop) {
        if (sumperflevelId == null || sumperflevelId == 0L || StringUtils.isBlank((CharSequence)mplop)) {
            return "";
        }
        DynamicObject sumperflevel = PERF_LEVEL_ENTITY_SERVICE.queryOne((Object)sumperflevelId);
        DynamicObjectCollection cols = sumperflevel.getDynamicObjectCollection("entryentity");
        return cols.stream().filter(dy -> dy.getInt("seq") == Integer.parseInt(mplop)).map(dy -> dy.getString("levelname")).findFirst().orElse("");
    }

    public boolean isDependentSummary(Long perfworkflowId) {
        DynamicObject perfWorkflow = PERF_WORK_FLOW_ENTITY_SERVICE.loadDynamicObject(new QFilter("id", "=", (Object)perfworkflowId));
        DynamicObjectCollection nodeCols = perfWorkflow.getDynamicObjectCollection("entryentity");
        boolean haveSum = false;
        boolean haveTarget = false;
        boolean haveEval = false;
        for (DynamicObject dy : nodeCols) {
            long node = dy.getDynamicObject("node").getLong("id");
            if (NodeTabMapEnum.PERF_SUM.getNodeId() == node) {
                haveSum = dy.getBoolean("isshow");
                continue;
            }
            if (NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId() == node) {
                haveTarget = dy.getBoolean("isshow");
                continue;
            }
            if (NodeTabMapEnum.EVAL_PROCESS.getNodeId() != node) continue;
            haveEval = dy.getBoolean("isshow");
        }
        return haveSum && !haveEval && !haveTarget;
    }

    public void synFsopAndCfsop() {
        DynamicObject[] objects = ACT_EVAL_OBJ_ENTITY_SERVICE.queryUpgradeDatas();
        List<DynamicObject> list = Arrays.asList(objects);
        ListUtils.excute(list, (int)500, this::batchSynFsopAndCfsop);
    }

    private void batchSynFsopAndCfsop(List<DynamicObject> objects) {
        List<Long> executeSchemeIds = objects.stream().map(dy -> dy.getLong("activity.executescheme.id")).distinct().collect(Collectors.toList());
        DynamicObject[] executeSchemes = EXECUTE_SCHEME_ENTITY.queryListByIds(executeSchemeIds);
        Map<Long, Long> schemeToFormMap = Arrays.stream(executeSchemes).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("assessform.id"), (k1, k2) -> k1));
        List<Long> assessFormIds = Arrays.stream(executeSchemes).map(dy -> dy.getLong("assessform.id")).distinct().collect(Collectors.toList());
        DynamicObject[] assessForms = ASSESS_FORM_ENTITY_SERVICE.queryScoreAndLevel(assessFormIds);
        Map formMap = Arrays.stream(assessForms).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (k1, k2) -> k1));
        for (DynamicObject obj : objects) {
            long executeschemeId = obj.getLong("activity.executescheme.id");
            Long formId = schemeToFormMap.get(executeschemeId);
            DynamicObject assessForm = (DynamicObject)formMap.get(formId);
            if (assessForm == null) continue;
            DynamicObject scoresystem = assessForm.getDynamicObject("scoresystem");
            DynamicObject sumperflevel = assessForm.getDynamicObject("sumperflevel");
            obj.set("fsopscoresystem", (Object)scoresystem);
            obj.set("cfsopscoresystem", (Object)scoresystem);
            obj.set("floplevel", (Object)sumperflevel);
            obj.set("cfloplevel", (Object)sumperflevel);
        }
        ACT_EVAL_OBJ_ENTITY_SERVICE.save(objects.toArray(new DynamicObject[0]));
    }

    public Map<Long, Map<String, Object>> getActevaobjPerfFileInfo(List<Long> evalObjIdList) {
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>(16);
        DynamicObject[] actevalObjDyns = ACT_EVAL_OBJ_ENTITY_SERVICE.queryActivityEvaluationObjectById("id,perffile.id", evalObjIdList);
        List perfFileIdList = Arrays.stream(actevalObjDyns).map(e -> e.getLong("perffile.id")).distinct().collect(Collectors.toList());
        DynamicObject[] perfFiles = PERFFILE_ENTITY_SERVICE.getPerffileListByIds("id,name,depemp.id", perfFileIdList);
        Map<Long, DynamicObject> perFilesMap = Arrays.stream(perfFiles).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<Long, DynamicObject> actevalObjMap = Arrays.stream(actevalObjDyns).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (Long evalObjId : evalObjIdList) {
            resultMap.computeIfAbsent(evalObjId, v -> {
                HashMap<String, Object> perfFileMap = new HashMap<String, Object>(16);
                if (actevalObjMap.get(evalObjId) != null) {
                    Long perFileId = ((DynamicObject)actevalObjMap.get(evalObjId)).getLong("perffile.id");
                    DynamicObject perfFileDyn = (DynamicObject)perFilesMap.get(perFileId);
                    perfFileMap.put("depempId", perfFileDyn == null ? "" : Long.valueOf(perfFileDyn.getLong("depemp.id")));
                    perfFileMap.put("name", perfFileDyn == null ? "" : perfFileDyn.getString("name"));
                    return perfFileMap;
                }
                return null;
            });
        }
        return resultMap;
    }
}

