/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.activitymanage.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activitymanage.entity.IndicatorPrintAreaBO;
import kd.opmc.epa.business.domain.activitymanage.entity.IndicatorPrintAreaConfBO;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAttachAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.AttachConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.NormalConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.PlusMinusConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.service.AssessRuleDomainService;
import kd.opmc.epa.common.constants.AssessTableConfConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.pbs.business.external.hrpi.IEmployeeService;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;

public class ActEvalObjPrintDomainService {
    private static final Log LOG = LogFactory.getLog(ActEvalObjPrintDomainService.class);
    private static final AssessRuleDomainService ASSESS_RULE_DOMAIN_SERVICE = AssessRuleDomainService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final NormalConfigEntityService NORMAL_CONFIG_ENTITY_SERVICE = NormalConfigEntityService.getInstance();
    private static final PlusMinusConfigEntityService PLUS_MINUS_CONFIG_ENTITY_SERVICE = PlusMinusConfigEntityService.getInstance();
    private static final AttachConfigEntityService ATTACH_CONFIG_ENTITY_SERVICE = AttachConfigEntityService.getInstance();
    private static final ObjGenAreaIndicatorEntityService OBJ_GEN_AREA_INS_ENTITY_SERVICE = ObjGenAreaIndicatorEntityService.getInstance();
    private static final ObjAddSubAreaIndicatorEntityService OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE = ObjAddSubAreaIndicatorEntityService.getInstance();
    private static final ObjAttachAreaIndicatorEntityService OBJ_ATTACH_AREA_INS_ENTITY_SERVICE = ObjAttachAreaIndicatorEntityService.getInstance();
    private static final IEmployeeService EMPLOYEE_SERVICE = IEmployeeService.getInstance();

    public static ActEvalObjPrintDomainService getInstance() {
        return ServiceFactory.getService(ActEvalObjPrintDomainService.class);
    }

    public Map<Long, List<IndicatorPrintAreaBO>> queryIndicatorAreas(DynamicObject[] evalObj) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)evalObj.length);
        ArrayList normIns = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList plusMinusIns = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList attachIns = Lists.newArrayListWithExpectedSize((int)10);
        List<IndicatorPrintAreaConfBO> indicatorAreaPrintBOS = this.queryIndicatorAreaConfig(evalObj[0]);
        Arrays.stream(evalObj).forEach(object -> {
            DynamicObjectCollection areaEntry = object.getDynamicObjectCollection("areaentry");
            areaEntry.forEach(area -> {
                AreaRegEnum areaReg = AreaRegEnum.get((Long)area.getLong("areareg.id"));
                Long areaIns = area.getLong("areains");
                if (AreaRegEnum.NORM_INDCTR_AREA == areaReg) {
                    normIns.add(areaIns);
                } else if (AreaRegEnum.PLUS_MINUS_AREA == areaReg) {
                    plusMinusIns.add(areaIns);
                } else if (AreaRegEnum.ATTACH_AREA == areaReg) {
                    attachIns.add(areaIns);
                }
            });
        });
        DynamicObject[] genAreaInsList = OBJ_GEN_AREA_INS_ENTITY_SERVICE.queryAllIndicatorInfoByIds(normIns);
        DynamicObject[] addSubAreaInsList = OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.queryAllIndicatorInfoByIds(plusMinusIns);
        DynamicObject[] attachAreaInsList = OBJ_ATTACH_AREA_INS_ENTITY_SERVICE.queryAllIndicatorInfoByIds(attachIns);
        Map<Long, List<DynamicObject>> genAreaGroup = Arrays.stream(genAreaInsList).collect(Collectors.groupingBy(gen1 -> gen1.getLong("instanceid")));
        Map<Long, List<DynamicObject>> addSubAreaGroup = Arrays.stream(addSubAreaInsList).collect(Collectors.groupingBy(gen1 -> gen1.getLong("instanceid")));
        Map<Long, List<DynamicObject>> attachAreaGroup = Arrays.stream(attachAreaInsList).collect(Collectors.groupingBy(gen1 -> gen1.getLong("instanceid")));
        Map<Long, IndicatorPrintAreaConfBO> areaConfigMap = indicatorAreaPrintBOS.stream().collect(Collectors.toMap(IndicatorPrintAreaConfBO::getId, ind -> ind));
        LOG.info("\u8003\u6838\u8868\u6253\u5370\uff0c\u83b7\u53d6\u6240\u6709\u7684\u533a\u57df\u914d\u7f6e\u7684\u4fe1\u606f: {}", areaConfigMap);
        Arrays.stream(evalObj).forEach(object -> {
            DynamicObjectCollection areaEntry = object.getDynamicObjectCollection("areaentry");
            ArrayList indicatorInsPerObj = Lists.newArrayListWithExpectedSize((int)areaEntry.size());
            areaEntry.forEach(area -> {
                IndicatorPrintAreaBO indicatorAreaPrintBO = IndicatorPrintAreaBO.create();
                AreaRegEnum areaReg = AreaRegEnum.get((Long)area.getLong("areareg.id"));
                Long areaIns = area.getLong("areains");
                Long areaConf = area.getLong("areaconf");
                if (AreaRegEnum.NORM_INDCTR_AREA == areaReg) {
                    this.setIndicatorArea((List)genAreaGroup.get(areaIns), (IndicatorPrintAreaConfBO)areaConfigMap.get(areaConf), indicatorAreaPrintBO);
                } else if (AreaRegEnum.PLUS_MINUS_AREA == areaReg) {
                    this.setIndicatorArea((List)addSubAreaGroup.get(areaIns), (IndicatorPrintAreaConfBO)areaConfigMap.get(areaConf), indicatorAreaPrintBO);
                } else if (AreaRegEnum.ATTACH_AREA == areaReg) {
                    this.setIndicatorArea((List)attachAreaGroup.get(areaIns), (IndicatorPrintAreaConfBO)areaConfigMap.get(areaConf), indicatorAreaPrintBO);
                }
                indicatorInsPerObj.add(indicatorAreaPrintBO);
            });
            ret.put(object.getLong("id"), indicatorInsPerObj);
        });
        return ret;
    }

    private void setIndicatorArea(List<DynamicObject> areaInsList, IndicatorPrintAreaConfBO indicatorConf, IndicatorPrintAreaBO indicatorAreaPrintBO) {
        indicatorAreaPrintBO.setAreaColumn(indicatorConf.getIndicatorName().size());
        indicatorAreaPrintBO.setAreaName(indicatorConf.getAreaName());
        indicatorAreaPrintBO.setIndicatorConf(indicatorConf);
        if (HRCollUtil.isEmpty(areaInsList)) {
            LOG.info("\u8fd9\u4e2a\u533a\u57df\u6ca1\u6709\u5b9e\u4f8b \uff0c\u533a\u57df\u914d\u7f6eid \uff1a{}", (Object)indicatorConf.getId());
            return;
        }
        ArrayList indicatorInsValue = Lists.newArrayListWithExpectedSize((int)areaInsList.size());
        areaInsList.forEach(areains -> {
            ArrayList indicatorInsItem = Lists.newArrayListWithExpectedSize((int)indicatorConf.getFieldCount());
            indicatorConf.getIndicatorName().forEach(conf -> {
                try {
                    if (areains.getDynamicObjectType().getProperties().containsKey(conf.item1)) {
                        Object value = areains.get((String)conf.item1);
                        if ("evaltype".equals(conf.item1) || "evalmode".equals(conf.item1)) {
                            String evalTypeValue = EntityMetaDataUtils.getEntityComboFieldItemName((String)"epa_normindctrarea", (String)((String)conf.item1), (String)areains.getString((String)conf.item1));
                            indicatorInsItem.add(evalTypeValue);
                        } else if (value instanceof BigDecimal) {
                            indicatorInsItem.add(((BigDecimal)value).stripTrailingZeros().toPlainString());
                        } else if (value instanceof Timestamp) {
                            indicatorInsItem.add(HRDateTimeUtils.format((Date)((Timestamp)value), (String)"yyyy-MM-dd"));
                        } else {
                            indicatorInsItem.add(areains.getString((String)conf.item1));
                        }
                    } else {
                        indicatorInsItem.add("");
                        LOG.error("Indicator instance[{}] have no field [{}] in the indicator area config[{}].", new Object[]{areains.get("id"), conf.item1, indicatorConf.getId()});
                    }
                }
                catch (Exception exception) {
                    LOG.error("Indicator instance[{}] have no field [{}] in the indicator area config[{}].  exception msg: {}", new Object[]{areains.get("id"), conf.item1, indicatorConf.getId(), exception.getMessage()});
                }
            });
            indicatorInsValue.add(indicatorInsItem);
        });
        indicatorAreaPrintBO.setAreaRow(areaInsList.size());
        indicatorAreaPrintBO.setIndicatorValue(indicatorInsValue);
    }

    private List<IndicatorPrintAreaConfBO> queryIndicatorAreaConfig(DynamicObject evalObjSingle) {
        DynamicObjectCollection areaEntry = evalObjSingle.getDynamicObjectCollection("areaentry").stream().sorted(Comparator.comparing(area -> area.getInt("seq"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        ArrayList ret = Lists.newArrayListWithExpectedSize((int)areaEntry.size());
        for (DynamicObject area2 : areaEntry) {
            IndicatorPrintAreaConfBO tempIapbo = new IndicatorPrintAreaConfBO();
            AreaRegEnum areaReg = AreaRegEnum.get((Long)area2.getLong("areareg.id"));
            Long areaconf = area2.getLong("areaconf");
            DynamicObject[] areaConfig = null;
            if (AreaRegEnum.NORM_INDCTR_AREA == areaReg) {
                areaConfig = NORMAL_CONFIG_ENTITY_SERVICE.queryOriginAreaConfByPkt(areaconf);
            } else if (AreaRegEnum.PLUS_MINUS_AREA == areaReg) {
                areaConfig = PLUS_MINUS_CONFIG_ENTITY_SERVICE.queryOriginAreaConfByPkt(areaconf);
            } else if (AreaRegEnum.ATTACH_AREA == areaReg) {
                areaConfig = ATTACH_CONFIG_ENTITY_SERVICE.queryOriginAreaConfByPkt(areaconf);
            }
            if (areaConfig == null || areaConfig.length <= 0) continue;
            tempIapbo.setId(areaconf);
            tempIapbo.setAreaName(areaConfig[0].getString("areacustname"));
            Set genNotLoadFiled = Arrays.stream(AssessTableConfConstants.GEN_IGNORE_FIELD).collect(Collectors.toSet());
            Set addNotLoadFiled = Arrays.stream(AssessTableConfConstants.ADD_SUB_IGNORE_FIELD).collect(Collectors.toSet());
            Set attNotLoadFiled = Arrays.stream(AssessTableConfConstants.ATTACH_IGNORE_FIELD).collect(Collectors.toSet());
            List<Tuple<String, String>> indicatorName = Arrays.stream(areaConfig).filter(notLoad -> {
                if (AreaRegEnum.NORM_INDCTR_AREA == areaReg) {
                    return !genNotLoadFiled.contains(notLoad.getString("entryentity.areafield.number"));
                }
                if (AreaRegEnum.PLUS_MINUS_AREA == areaReg) {
                    return !addNotLoadFiled.contains(notLoad.getString("entryentity.areafield.number"));
                }
                return !attNotLoadFiled.contains(notLoad.getString("entryentity.areafield.number"));
            }).map(normal -> Tuple.create((Object)normal.getString("entryentity.areafield.number"), (Object)normal.getString("entryentity.fieldcustname"))).collect(Collectors.toList());
            tempIapbo.setIndicatorName(indicatorName);
            ret.add(tempIapbo);
        }
        return ret;
    }

    public Map<Long, List<Tuple<String, Object>>> queryBaseInfoByObjIds(DynamicObject[] evalObjValue) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)evalObjValue.length);
        long assessFormId = evalObjValue[0].getDynamicObject("activity").getLong("assessform.id");
        DynamicObject assessForms = ASSESS_FORM_ENTITY_SERVICE.queryAssessForm(assessFormId);
        DynamicObject empInfoConf = ASSESS_RULE_DOMAIN_SERVICE.queryEmpInfoConfigByPk(assessForms.getLong("empinfoconf"));
        DynamicObjectCollection entryEntity = empInfoConf.getDynamicObjectCollection("entryentity");
        List empBaseInfoConf = entryEntity.stream().filter(emp1 -> emp1.getBoolean("isshow")).filter(emp1 -> !emp1.getString("areafield.number").equals("headsculpture")).sorted(Comparator.comparing(emp2 -> emp2.getInt("seq"))).collect(Collectors.toList());
        HashMap requestParam = Maps.newHashMapWithExpectedSize((int)3);
        Map<Long, Long> objIdMap = Arrays.stream(evalObjValue).collect(Collectors.toMap(obj1 -> obj1.getLong("id"), obj2 -> obj2.getLong("employee.id")));
        List employeeIds = Arrays.stream(evalObjValue).map(obj2 -> obj2.getLong("employee.id")).collect(Collectors.toList());
        requestParam.put("sign", "employee");
        requestParam.put("signList", employeeIds);
        requestParam.put("dateTime", new Date());
        Map queryResult = EMPLOYEE_SERVICE.listPersonServiceAgeWithIds((Map)requestParam);
        Map ageRetMap = Maps.newHashMapWithExpectedSize((int)evalObjValue.length);
        Boolean success = (Boolean)queryResult.get("success");
        if (success.booleanValue()) {
            ageRetMap = (Map)queryResult.get("data");
        }
        for (DynamicObject evlObj : evalObjValue) {
            Long objId = evlObj.getLong("id");
            ArrayList baseInfoList = Lists.newArrayListWithExpectedSize((int)empBaseInfoConf.size());
            for (DynamicObject baseInfoConf : empBaseInfoConf) {
                String number = baseInfoConf.getString("areafield.number");
                String baseValue = "";
                try {
                    switch (number) {
                        case "name": {
                            baseValue = evlObj.getString("perffile.name");
                            break;
                        }
                        case "number": {
                            baseValue = evlObj.getString("perffile.billno");
                            break;
                        }
                        case "company": {
                            baseValue = evlObj.getString("perffile.company.name");
                            if (!HRStringUtils.isEmpty((String)baseValue)) break;
                            baseValue = "-";
                            break;
                        }
                        case "position": {
                            baseValue = evlObj.getString("perffile.position.name");
                            if (!HRStringUtils.isEmpty((String)baseValue)) break;
                            baseValue = "-";
                            break;
                        }
                        case "job": {
                            baseValue = evlObj.getString("perffile.job.name");
                            if (!HRStringUtils.isEmpty((String)baseValue)) break;
                            baseValue = "-";
                            break;
                        }
                        case "entrytime": {
                            baseValue = HRDateTimeUtils.format((Date)evlObj.getDate("perffile.employedate"), (String)"yyyy-MM-dd");
                            if (!HRStringUtils.isEmpty((String)baseValue)) break;
                            baseValue = "-";
                            break;
                        }
                        case "adminorg": {
                            baseValue = evlObj.getString("perffile.adminorg.name");
                            break;
                        }
                        case "workyear": {
                            Map map = (Map)ageRetMap.get(objIdMap.get(objId));
                            if (map == null || !map.containsKey("socialWorkAge")) break;
                            BigDecimal socialWorkAge = (BigDecimal)map.get("socialWorkAge");
                            baseValue = socialWorkAge == null ? "0" : socialWorkAge.stripTrailingZeros().toPlainString();
                            break;
                        }
                        case "entservicelen": {
                            Map map1 = (Map)ageRetMap.get(objIdMap.get(objId));
                            if (map1 == null || !map1.containsKey("companyWorkAge")) break;
                            BigDecimal socialWorkAge = (BigDecimal)map1.get("companyWorkAge");
                            baseValue = socialWorkAge == null ? "0" : socialWorkAge.stripTrailingZeros().toPlainString();
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    LOG.error("There is an exception when get basic information values from the evaluation object[{}]. ", (Object)"You should check the value of the performance file.", (Object)objId);
                }
                Tuple fieldValue = Tuple.create((Object)baseInfoConf.getString("areafield.name"), (Object)(baseValue == null ? "" : baseValue));
                baseInfoList.add(fieldValue);
            }
            ret.put(objId, baseInfoList);
        }
        return ret;
    }
}

