/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.activitymanage.service;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activitymanage.entity.IndicatorPrintAreaBO;
import kd.opmc.epa.business.domain.activitymanage.entity.IndicatorPrintAreaConfBO;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjPrintDomainService;
import kd.opmc.epa.business.print.PrintContext;
import kd.opmc.epa.business.print.PrintFileOutputStream;
import kd.opmc.epa.business.print.font.PrintFontUtil;

public class ActEvalObjPrintPaintDomainService {
    private static final Log LOG = LogFactory.getLog(ActEvalObjPrintPaintDomainService.class);
    private static final ActivityEvaluationObjectEntityService EVALUATION_OBJECT_ENTITY_SERVICE = ActivityEvaluationObjectEntityService.getInstance();
    private static final ActEvalObjPrintDomainService ACT_EVAL_OBJ_PRINT_DOMAIN_SERVICE = ActEvalObjPrintDomainService.getInstance();

    public static ActEvalObjPrintPaintDomainService getInstance() {
        return ServiceFactory.getService(ActEvalObjPrintPaintDomainService.class);
    }

    public String buildIndicatorPrintPdf(Object[] objIds) {
        PrintContext context = new PrintContext();
        PrintFileOutputStream printOutputStream = new PrintFileOutputStream(context);
        Document document = this.createPrintDocument();
        PdfWriter writer = null;
        try {
            writer = PdfWriter.getInstance((Document)document, (OutputStream)printOutputStream);
            document.open();
            this.paintPdf(document, objIds, context);
            document.close();
            writer.close();
        }
        catch (DocumentException e) {
            LOG.error("print pdf file upload fail\uff1a", (Throwable)e);
        }
        String path = null;
        try {
            String tableNameSuffix = ResManager.loadKDString((String)"\u8003\u6838\u8868.pdf", (String)"ActEvalObjPrintPaintDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]);
            path = printOutputStream.uploadFileAndGetPreviewUrl(tableNameSuffix);
            printOutputStream.close();
        }
        catch (Exception e) {
            LOG.error("print pdf file upload fail! msg{}", (Object)e.getMessage());
        }
        return path;
    }

    private Document createPrintDocument() {
        return new Document(PageSize.A4.rotate(), -50.0f, -50.0f, 20.0f, 20.0f);
    }

    private void setDocumentMetaInfo(Document document) {
        document.addCreationDate();
        String tableNameSuffix = ResManager.loadKDString((String)"\u8003\u6838\u8868.pdf", (String)"ActEvalObjPrintPaintDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]);
        document.addTitle(tableNameSuffix);
    }

    private Paragraph setTitle(String cycleName) {
        String tableNameSuffix = ResManager.loadKDString((String)"\u8003\u6838\u8868", (String)"ActEvalObjPrintPaintDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]);
        Font font = new Font(PrintFontUtil.getSimsunText());
        font.setStyle(1);
        font.setSize(18.0f);
        Paragraph paragraph = new Paragraph(cycleName + tableNameSuffix, font);
        paragraph.setAlignment(1);
        paragraph.setSpacingAfter(18.0f);
        return paragraph;
    }

    private void setBaseInfo(Document document, List<Tuple<String, Object>> empBaseInfoList) throws DocumentException {
        String baseInfoName = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"ActEvalObjPrintPaintDomainService_2", (String)"opmc-epa-business", (Object[])new Object[0]);
        this.paintTableTitle(document, baseInfoName);
        PdfPTable baseInfoTable = new PdfPTable(8);
        for (Tuple<String, Object> empBaseInfo : empBaseInfoList) {
            baseInfoTable.addCell(this.createPdfCell((String)empBaseInfo.item1, false));
            baseInfoTable.addCell(this.createPdfCell(empBaseInfo.item2.toString(), false));
        }
        int diffCellNum = 8 - empBaseInfoList.size() % 8;
        while (diffCellNum-- > 0) {
            baseInfoTable.addCell(this.createPdfCell("", false));
        }
        document.add((Element)baseInfoTable);
    }

    private PdfPCell createPdfCell(String text, boolean isHeader) {
        Font simSunText = null;
        simSunText = isHeader ? PrintFontUtil.getSimsunTextBold() : PrintFontUtil.getSimsunText();
        Paragraph paragraph = new Paragraph(text, simSunText);
        paragraph.setAlignment(1);
        PdfPCell cell = new PdfPCell((Phrase)paragraph);
        cell.setBorder(15);
        return cell;
    }

    private void paintTableTitle(Document document, String name) throws DocumentException {
        PdfPTable pdfPTable = new PdfPTable(1);
        pdfPTable.addCell(this.createTableTitleCell(name));
        document.add((Element)pdfPTable);
    }

    private PdfPCell createTableTitleCell(String text) {
        Paragraph paragraph = new Paragraph(text, PrintFontUtil.getSimsunTextBold());
        paragraph.setAlignment(1);
        PdfPCell cell = new PdfPCell((Phrase)paragraph);
        cell.setBorder(15);
        cell.setBackgroundColor(Color.LIGHT_GRAY);
        return cell;
    }

    private void setIndicatorArea(Document document, List<IndicatorPrintAreaBO> indicatorAreaPrintBOS) throws DocumentException {
        for (IndicatorPrintAreaBO areaPrintBO : indicatorAreaPrintBOS) {
            this.paintTableTitle(document, areaPrintBO.getAreaName());
            PdfPTable pdfPTable = new PdfPTable(areaPrintBO.getAreaColumn());
            IndicatorPrintAreaConfBO indicatorConf = areaPrintBO.getIndicatorConf();
            indicatorConf.getIndicatorName().forEach(indConf -> pdfPTable.addCell(this.createPdfCell((String)indConf.item2, true)));
            List<List<String>> indicatorValue = areaPrintBO.getIndicatorValue();
            if (HRCollUtil.isNotEmpty(indicatorValue)) {
                indicatorValue.forEach(ind -> ind.forEach(indValue -> pdfPTable.addCell(this.createPdfCell((String)indValue, false))));
            } else {
                indicatorConf.getIndicatorName().forEach(indConf -> pdfPTable.addCell(this.createPdfCell(" ", false)));
            }
            document.add((Element)pdfPTable);
        }
    }

    private void setIndicatorSignature(Document document) throws DocumentException {
        Paragraph paragraph = new Paragraph();
        Font simSunText = PrintFontUtil.getSimsunTextBold();
        paragraph.setAlignment(2);
        String signatureContent = ResManager.loadKDString((String)"\u7b7e\u5b57\uff1a                 \u65e5\u671f\uff1a                                ", (String)"ActEvalObjPrintPaintDomainService_3", (String)"opmc-epa-business", (Object[])new Object[0]);
        Chunk signature = new Chunk(signatureContent, simSunText);
        paragraph.add((Element)signature);
        paragraph.setSpacingBefore(18.0f);
        document.add((Element)paragraph);
    }

    private void paintPdf(Document document, Object[] objIds, PrintContext context) throws DocumentException {
        DynamicObject[] evalObjValue = EVALUATION_OBJECT_ENTITY_SERVICE.queryAreaByPkValues(objIds);
        if (evalObjValue.length <= 0) {
            LOG.error("no eval object to paint pdf, selected objIds:{}", (Object)Arrays.toString(objIds));
            return;
        }
        String periodName = evalObjValue[0].getString("activity.period");
        String actId = evalObjValue[0].getString("activity.id");
        context.setAppFormPkIdStr("epa/epa_activity/" + actId + "/");
        this.setDocumentMetaInfo(document);
        Map<Long, List<Tuple<String, Object>>> empBaseInfoMap = ACT_EVAL_OBJ_PRINT_DOMAIN_SERVICE.queryBaseInfoByObjIds(evalObjValue);
        Map<Long, List<IndicatorPrintAreaBO>> indicatorAreaPrintBOS = ACT_EVAL_OBJ_PRINT_DOMAIN_SERVICE.queryIndicatorAreas(evalObjValue);
        try {
            for (DynamicObject evalObj : evalObjValue) {
                Long evalObjId = evalObj.getLong("id");
                document.add((Element)this.setTitle(periodName));
                this.setBaseInfo(document, empBaseInfoMap.get(evalObjId));
                this.setIndicatorArea(document, indicatorAreaPrintBOS.get(evalObjId));
                this.setIndicatorSignature(document);
                document.newPage();
            }
        }
        catch (Exception e) {
            LOG.error("paint pdf fail ! base info area\uff1a{}; indicator area:{}, exception:{}", new Object[]{empBaseInfoMap, indicatorAreaPrintBOS, e});
        }
    }
}

