/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.activitymanage.service;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.DynamicObjectUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.domain.activity.service.AssessActivityDomainService;
import kd.opmc.epa.business.domain.activitymanage.entity.CopyHisIndicatorTaskBo;
import kd.opmc.epa.business.domain.activitymanage.entity.CopyHisIndicatorTaskVo;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAreaIndicatorReqEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAttachAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAttachAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjCrossIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjImportScoreIndEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.EvalModeEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.EvalfinishtypeEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.ScoreTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.extpoint.IBuildActivityEvaluationDynObjService;
import kd.opmc.epa.business.domain.activitymanage.extpoint.IIndicatorSetGroupService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.business.domain.assessrule.entityservice.AttachConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.NormalConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.PlusMinusConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.enums.TargetModelEnum;
import kd.opmc.epa.business.domain.assessrule.enums.TargetPersonEnum;
import kd.opmc.epa.business.domain.assessrule.enums.TargetPersonNullEnum;
import kd.opmc.epa.business.domain.assessrule.service.AssessRuleDomainService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAddSubAreaIndAssignEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAttachAreaIndAssignEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjGenAreaIndAssignEntityService;
import kd.opmc.epa.business.domain.indicator.entity.AreaNameMappingBo;
import kd.opmc.epa.business.domain.indicator.entityservice.IndicatorGroupEntityService;
import kd.opmc.epa.business.domain.indicator.service.IndicatorGroupDomainService;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumDomainService;
import kd.opmc.epa.business.domain.perfworkflow.service.PerfWorkFlowDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.AssessGroupEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.domain.scheme.service.ExecuteSchemeDomainService;
import kd.opmc.epa.business.domain.todomessage.service.ToDoMessageDomainService;
import kd.opmc.epa.business.task.StartUpActivityTask;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.constants.ActivityEvaluationObjectConstants;
import kd.opmc.epa.common.constants.PassNodeConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.common.enums.activitymanage.AssFormatEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.enums.assessrule.AdjustTypeEnum;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.common.vo.ResponseResult;
import kd.opmc.pbs.business.application.impl.mq.StartProcessPublisher;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.flowscan.entity.BatchFlowTaskResultBo;
import kd.opmc.pbs.business.domain.flowscan.entity.ReWriteEvalObjRequest;
import kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskTypeEnum;
import kd.opmc.pbs.business.domain.flowscan.service.BatchFlowTaskService;
import kd.opmc.pbs.business.domain.workflow.dto.SendMessageDTO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowMsgMergeEnumBO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuMsgMergeEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.FlowDefNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;
import kd.opmc.pbs.business.external.hrpi.IHRPIWorkRoleService;
import kd.opmc.pbs.common.constants.NodeTypeConstants;
import kd.opmc.pbs.common.enums.FieldTypeEnum;
import kd.opmc.pbs.common.utils.CommonResultBo;
import kd.opmc.pmd.business.application.service.PerffileApplicationService;
import kd.opmc.pmd.business.domain.perffile.service.PerffileDomainService;

public class ActivityEvaluationObjectDomainService {
    private static final Log LOG = LogFactory.getLog(ActivityEvaluationObjectDomainService.class);
    private static final IHRPIWorkRoleService WORK_ROLE_SERVICE = IHRPIWorkRoleService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final AssessRuleDomainService ASSESS_RULE_DOMAIN_SERVICE = AssessRuleDomainService.getInstance();
    private static final ObjGenAreaInsEntityService OBJ_GEN_AREA_INS_ENTITY = ObjGenAreaInsEntityService.getInstance();
    private static final ObjAddSubAreaInsEntityService OBJ_ADD_SUB_AREA_INS_ENTITY = ObjAddSubAreaInsEntityService.getInstance();
    private static final ObjAttachAreaInsEntityService OBJ_ATTACH_AREA_INS_ENTITY = ObjAttachAreaInsEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY = AssessFormEntityService.getInstance();
    private static final ToDoMessageDomainService TO_DO_MESSAGE_DOMAIN_SERVICE = ToDoMessageDomainService.getInstance();
    private static final ObjAreaIndicatorReqEntityService INDICATOR_REQ_ENTITY = ObjAreaIndicatorReqEntityService.getInstance();
    private static final AssessGroupEntityService ASSESS_GROUP_ENTITY = AssessGroupEntityService.getInstance();
    private static final Map<Long, OpmcEntityService> AREA_INS_ENTITY_MAP = new HashMap<Long, OpmcEntityService>(16);
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final FlowDefProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RUSECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ExecuteSchemeDomainService EXECUTE_SCHEME_DOMAIN_SERVICE = ExecuteSchemeDomainService.getInstance();
    private static final PerfWorkFlowDomainService PERF_WORK_FLOW_DOMAIN_SERVICE = PerfWorkFlowDomainService.getInstance();
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final AssessFormDomainService ASSESS_FORM_DOMAIN_SERVICE = AssessFormDomainService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ObjCrossIndicatorEntityService OBJ_CROSS_INDICATOR_ENTITY_SERVICE = ObjCrossIndicatorEntityService.getInstance();
    private static final ObjImportScoreIndEntityService IMPORT_SCORE_IND_ENTITY_SERVICE = ObjImportScoreIndEntityService.getInstance();
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final IIndicatorSetGroupService INDICATOR_SET_GROUP_SERVICE = IIndicatorSetGroupService.getInstance();
    private static final NormalConfigEntityService NORMAL_CONFIG_ENTITY_SERVICE = NormalConfigEntityService.getInstance();
    private static final AttachConfigEntityService ATTACH_CONFIG_ENTITY_SERVICE = AttachConfigEntityService.getInstance();
    private static final PlusMinusConfigEntityService PLUS_MINUS_CONFIG_ENTITY_SERVICE = PlusMinusConfigEntityService.getInstance();
    private static final IBuildActivityEvaluationDynObjService iBuildActivityEvaluationDynObjService = IBuildActivityEvaluationDynObjService.getInstance();
    private static final BatchStartEvalEntityService BATCH_START_EVAL_ENTITY_SERVICE = BatchStartEvalEntityService.getInstance();
    private static final BatchFlowTaskService BATCH_FLOW_TASK_SERVICE = BatchFlowTaskService.getInstance();
    private static final FlowRuProcBatchDomainService FLOW_RU_PROC_BATCH_DOMAIN_SERVICE = FlowRuProcBatchDomainService.getInstance();
    private static final ObjGenAreaIndicatorEntityService GEN_AREA_INDICATOR_ENTITY = ObjGenAreaIndicatorEntityService.getInstance();
    private static final ObjAddSubAreaIndicatorEntityService ADD_SUB_AREA_INDICATOR_ENTITY = ObjAddSubAreaIndicatorEntityService.getInstance();
    private static final ObjAttachAreaIndicatorEntityService ATTACH_AREA_INDICATOR_ENTITY = ObjAttachAreaIndicatorEntityService.getInstance();
    private static final PerffileApplicationService PERF_FILE_APPLICATION_SERVICE = PerffileApplicationService.getInstance();
    private static final AssessObjectApplicationService ASSESS_OBJECT_APPLICATION_SERVICE = AssessObjectApplicationService.getInstance();
    private static final PerffileDomainService PERFFILE_DOMAIN_SERVICE = PerffileDomainService.getInstance();
    private static final ObjGenAreaInsEntityService OBJ_GEN_AREAINS_ENTITY;
    private static final ObjAddSubAreaInsEntityService OBJ_ADDSUB_AREAINS_ENTITY;
    private static final ObjAttachAreaInsEntityService OBJ_ATTACH_AREAINS_ENTITY;
    private static final ActivityEvaluationObjectApplicationService EVALUATION_OBJECT_APPLICATION_SERVICE;
    private static final IndicatorGroupEntityService INDICATOR_GROUP_ENTITY_SERVICE;
    private static final FlowHandlerBatchDomainService FLOW_HANDLER_BATCH_DOMAIN_SERVICE;
    private static final HRBaseServiceHelper dynamixcPermitService;
    private static final PerfSumDomainService PERF_SUM_DOMAIN_SERVICE;
    private static final ActivityEvaluationObjectApplicationService ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE;
    private static final String SUCCESS = "success";
    private static final String DATA = "data";
    private static final String USER = "user";
    private static final String ENDDATE = "enddate";
    private static final String PMDORG = "pmdorg";
    private static final IHRPIPersonService PERSON_SERVICE;

    public DynamicObject getObjGenAreaIns(Object id) {
        return OBJ_GEN_AREA_INS_ENTITY.queryOne(id);
    }

    public DynamicObject loadObjGenAreaIns(Object id) {
        return OBJ_GEN_AREA_INS_ENTITY.loadSingle(id);
    }

    public static ActivityEvaluationObjectDomainService getInstance() {
        return ServiceFactory.getService(ActivityEvaluationObjectDomainService.class);
    }

    public Object[] saveEvaluationObject(DynamicObject[] dynamicObjects) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.save(dynamicObjects);
    }

    public Object[] saveEvaluationObjectColl(DynamicObjectCollection dynamicObjects) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.save(dynamicObjects);
    }

    public Map<Long, List<Long>> getSuperiorUserIdsByPersonIds(List<Long> personIds) {
        HashMap<Long, List<Long>> retMap = new HashMap<Long, List<Long>>(16);
        Map directSuperior = WORK_ROLE_SERVICE.getDirectSuperior(personIds);
        if (directSuperior != null) {
            HashMap personSuperiorMap = new HashMap(16);
            ArrayList<Long> superiorIds = new ArrayList<Long>(10);
            for (Long personId : personIds) {
                List superiorList = (List)directSuperior.get(personId);
                if (HRObjectUtils.isEmpty((Object)superiorList)) continue;
                ArrayList<Long> superiorListPer = new ArrayList<Long>(16);
                for (Map superiorInfo : superiorList) {
                    Long superiorId = (Long)superiorInfo.get("person.id");
                    if (HRObjectUtils.isEmpty((Object)superiorId)) continue;
                    superiorListPer.add(superiorId);
                    superiorIds.add(superiorId);
                }
                personSuperiorMap.put(personId, superiorListPer);
            }
            Map<Long, Long> superiorUserMap = this.getUserIdsByPersonIds(superiorIds);
            for (Map.Entry personSuperiorEntry : personSuperiorMap.entrySet()) {
                List superiorPerson = (List)personSuperiorEntry.getValue();
                ArrayList<Long> superiorUser = new ArrayList<Long>(10);
                for (Long user : superiorPerson) {
                    superiorUser.add(superiorUserMap.get(user));
                }
                retMap.put((Long)personSuperiorEntry.getKey(), (List<Long>)superiorUser);
            }
        }
        return retMap;
    }

    public Map<Long, List<Long>> getSuperiorIdsByPersonIds(List<Long> personIds) {
        Map directSuperior = WORK_ROLE_SERVICE.getDirectSuperior(personIds);
        HashMap<Long, List<Long>> personSuperiorMap = new HashMap<Long, List<Long>>(16);
        if (directSuperior != null) {
            for (Long personId : personIds) {
                List superiorList = (List)directSuperior.get(personId);
                if (HRObjectUtils.isEmpty((Object)superiorList)) continue;
                ArrayList<Long> superiorListPer = new ArrayList<Long>(16);
                for (Map superiorInfo : superiorList) {
                    Long superiorId = (Long)superiorInfo.get("person.id");
                    if (HRObjectUtils.isEmpty((Object)superiorId)) continue;
                    superiorListPer.add(superiorId);
                }
                personSuperiorMap.put(personId, superiorListPer);
            }
        }
        return personSuperiorMap;
    }

    public Map<Long, Long> getUserIdsByPersonIds(List<Long> personIds) {
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(16);
        HashMap<String, List<Long>> personIdMap = new HashMap<String, List<Long>>(16);
        personIdMap.put("person", personIds);
        Map userIdByPersonInfo = PERSON_SERVICE.getUserIdByPersonInfo(personIdMap);
        Boolean success = (Boolean)userIdByPersonInfo.get(SUCCESS);
        if (success.booleanValue()) {
            Map userInfo = (Map)userIdByPersonInfo.get(DATA);
            for (Long personId : personIds) {
                Map user = (Map)userInfo.get(personId);
                if (user == null) continue;
                Long userId = (Long)user.get(USER);
                retMap.put(personId, userId);
            }
        }
        return retMap;
    }

    public DynamicObject[] filterJoinAssess(DynamicObject[] joinInAssessObjectLists, DynamicObject activityDynObj) {
        return (DynamicObject[])Arrays.stream(joinInAssessObjectLists).filter(joinInAssessObject -> this.comparePeriod((DynamicObject)joinInAssessObject, activityDynObj)).toArray(DynamicObject[]::new);
    }

    private boolean comparePeriod(DynamicObject joinInAssessObject, DynamicObject activityDynObj) {
        try {
            String period = activityDynObj.getString("period");
            String startCycle = joinInAssessObject.getString("startcycle");
            String endCycle = joinInAssessObject.getString("endcycle");
            if (HRStringUtils.isEmpty((String)period) || HRStringUtils.isEmpty((String)startCycle) || HRStringUtils.isEmpty((String)endCycle)) {
                return false;
            }
            Date periodStartDate = HRDateTimeUtils.truncateDate((Date)activityDynObj.getDate("periodstartdate"));
            Date periodEndDate = HRDateTimeUtils.truncateDate((Date)activityDynObj.getDate("periodenddate"));
            DynamicObject perFile = joinInAssessObject.getDynamicObject("perfile");
            Date startDate = HRDateTimeUtils.truncateDate((Date)perFile.getDate("startdate"));
            Date endDate = HRDateTimeUtils.truncateDate((Date)perFile.getDate(ENDDATE));
            if (HRDateTimeUtils.dayAfter((Date)startDate, (Date)periodEndDate) || HRDateTimeUtils.dayBefore((Date)endDate, (Date)periodStartDate)) {
                return false;
            }
            String periodYear = period.substring(0, 4);
            String startCycleYear = startCycle.substring(0, 4);
            String endCycleYear = endCycle.substring(0, 4);
            String periodMonth = period.substring(5);
            String startCycleMonth = startCycle.substring(5);
            String endCycleMonth = endCycle.substring(5);
            if (Integer.parseInt(startCycleYear) <= Integer.parseInt(periodYear) && Integer.parseInt(periodYear) <= Integer.parseInt(endCycleYear)) {
                if (period.length() == 5) {
                    return true;
                }
                return Integer.parseInt(startCycleMonth) <= Integer.parseInt(periodMonth) && Integer.parseInt(periodMonth) <= Integer.parseInt(endCycleMonth);
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    public void addEvaluationObjects(DynamicObject[] assessObjectDynObjArr, DynamicObject activityDynObj, StartUpActivityTask task) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.addEvaluationObjectsNoTX(assessObjectDynObjArr, activityDynObj, task);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
                txHandle.markRollback();
                throw ex;
            }
        }
    }

    private void setEvaluationObjectId(List<DynamicObject> needSaveEvaluationObjectList) {
        long[] evaluationObjectIdArr = DB.genGlobalLongIds((int)needSaveEvaluationObjectList.size());
        for (int i = 0; i < needSaveEvaluationObjectList.size(); ++i) {
            DynamicObject evaluationObjectDnyObj = needSaveEvaluationObjectList.get(i);
            evaluationObjectDnyObj.set("id", (Object)evaluationObjectIdArr[i]);
        }
    }

    private List<BatchFlowTaskResultBo> preCreateEvaluationObjectProcessInstance(DynamicObject[] evaluationObjectArr, Map<String, Long> defaultWorkFlow) {
        ArrayList<BatchFlowTaskResultBo> batchFlowTaskResultBoList = new ArrayList<BatchFlowTaskResultBo>(10);
        ArrayList<FlowRuProcBo> formulatFlowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
        FlowRuProcBo flowRuProcBo = null;
        for (Map.Entry<String, Long> workFlow : defaultWorkFlow.entrySet()) {
            long workFlowVid = workFlow.getValue();
            String workFlowType = workFlow.getKey();
            for (DynamicObject activityEvaluationObject : evaluationObjectArr) {
                if (!"1".equals(workFlowType)) continue;
                flowRuProcBo = activityEvaluationObject.get("formulateflow") != null ? (activityEvaluationObject.get("formulateflow") instanceof Long ? EvalObjUtils.buildEvaluationProcBo(activityEvaluationObject, activityEvaluationObject.getLong("formulateflow"), workFlowType) : EvalObjUtils.buildEvaluationProcBo(activityEvaluationObject, activityEvaluationObject.getDynamicObject("formulateflow").getLong("id"), workFlowType)) : EvalObjUtils.buildEvaluationProcBo(activityEvaluationObject, workFlowVid, workFlowType);
                formulatFlowRuProcBoList.add(flowRuProcBo);
            }
        }
        if (evaluationObjectArr.length <= 20) {
            CommonResultBo indicatorResultBo = FLOW_RU_PROC_BATCH_DOMAIN_SERVICE.preCreateProcessInstanceNoTx(formulatFlowRuProcBoList, null);
            Map indicatorResMap = indicatorResultBo.getResultMap();
            for (DynamicObject evaObj : evaluationObjectArr) {
                evaObj.set("formulateflowins", indicatorResMap.get(evaObj.getLong("id")));
            }
        } else {
            BatchFlowTaskResultBo formulateResultBo = BATCH_START_EVAL_ENTITY_SERVICE.generateBatchFlowTaskData(formulatFlowRuProcBoList, TaskTypeEnum.INDICATOR_PRE_INSTANTIATION.getValue());
            formulateResultBo.setTaskType(TaskTypeEnum.INDICATOR_PRE_INSTANTIATION.getValue());
            batchFlowTaskResultBoList.add(formulateResultBo);
        }
        return batchFlowTaskResultBoList;
    }

    private boolean checkDefaultEvalAndFormulateFlow(DynamicObject workFlowDynObjTemp) {
        return workFlowDynObjTemp.getBoolean("isdefaultflow") && workFlowDynObjTemp.getBoolean("isenable") && (workFlowDynObjTemp.getLong("passnode") == PassNodeConstants.SET_INDICATOR.longValue() || workFlowDynObjTemp.getLong("passnode") == PassNodeConstants.EVALUATE_PERF.longValue());
    }

    private void saveAreaInstanceAndSetAreaInstanceId(DynamicObject[] assessObjectDynObjArr, DynamicObject activityDynObj, Map<String, Long> defaultWorkFlow, List<DynamicObject> needSaveEvaluationObjectList, DynamicObject assessFormDynObj) {
        HashMap<Long, DynamicObject> areaConfCache = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, ArrayList<DynamicObject>> areaInstanceListOfAreaRegMap = new HashMap<Long, ArrayList<DynamicObject>>(16);
        DynamicObjectCollection areaConfColl = !ObjectUtils.isEmpty((Object)assessFormDynObj) ? assessFormDynObj.getDynamicObjectCollection("areaconfentry") : new DynamicObjectCollection();
        String assScore = this.getAssScore(assessFormDynObj);
        DynamicObject defaultAssessGroup = this.getDefaultAssessGroup(activityDynObj);
        for (DynamicObject assessObjectDynObj : assessObjectDynObjArr) {
            DynamicObject activityEvaluationObject = this.buildActivityEvaluationDynObj(activityDynObj, defaultWorkFlow, assScore, assessObjectDynObj, defaultAssessGroup);
            DynamicObjectCollection areaEntry = activityEvaluationObject.getDynamicObjectCollection("areaentry");
            if (!ObjectUtils.isEmpty((Object)areaConfColl)) {
                for (DynamicObject assTableConf : areaConfColl) {
                    DynamicObject areaInstanceEntryRow = new DynamicObject(areaEntry.getDynamicObjectType());
                    long areaRegId = assTableConf.getDynamicObject("areareg").getLong("id");
                    long confId = assTableConf.getLong("areaconf");
                    areaInstanceEntryRow.set("areareg", (Object)areaRegId);
                    areaInstanceEntryRow.set("areaconf", (Object)confId);
                    DynamicObject areaInstance = this.initAreaInstance(areaConfCache, areaRegId, confId);
                    if (areaInstance == null) continue;
                    ArrayList<DynamicObject> areaInstanceDys = (ArrayList<DynamicObject>)areaInstanceListOfAreaRegMap.get(areaRegId);
                    if (ObjectUtils.isEmpty((Object)areaInstanceDys)) {
                        areaInstanceDys = new ArrayList<DynamicObject>(10);
                        areaInstanceListOfAreaRegMap.put(areaRegId, areaInstanceDys);
                    }
                    areaInstanceDys.add(areaInstance);
                    areaInstanceEntryRow.set("areains", areaInstance.getPkValue());
                    areaEntry.add((Object)areaInstanceEntryRow);
                }
            }
            needSaveEvaluationObjectList.add(activityEvaluationObject);
        }
        for (Map.Entry entry : areaInstanceListOfAreaRegMap.entrySet()) {
            long areaRegId = (Long)entry.getKey();
            OpmcEntityService entity = AREA_INS_ENTITY_MAP.get(areaRegId);
            if (!ObjectUtils.isEmpty((Object)entity)) {
                entity.save(((List)entry.getValue()).toArray(new DynamicObject[0]));
                continue;
            }
            LOG.info("Excluded areaReg {}", (Object)areaRegId);
        }
    }

    private DynamicObject getDefaultAssessGroup(DynamicObject activityDynObj) {
        long schemeId = activityDynObj.getLong("scheme.id");
        long executeSchemeAssessScopeId = activityDynObj.getLong("executescheme.assessscope.id");
        Object[] assessGroupArr = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssessGroupArr(schemeId, executeSchemeAssessScopeId);
        Object assessGroup = null;
        for (DynamicObject dynamicObject : assessGroupArr) {
            if (!dynamicObject.getBoolean("isdefault")) continue;
            assessGroup = dynamicObject;
            break;
        }
        if (assessGroup == null && !HRArrayUtils.isEmpty((Object[])assessGroupArr) && assessGroupArr.length > 0) {
            assessGroup = assessGroupArr[0];
        }
        return assessGroup;
    }

    private DynamicObject buildActivityEvaluationDynObj(DynamicObject activityDynObj, Map<String, Long> defaultWorkFlow, String assScore, DynamicObject assessObjectDynObj, DynamicObject defaultAssessGroup) {
        Long groupId;
        long schemeId = activityDynObj.getLong("scheme.id");
        long executeSchemeAssessScopeId = activityDynObj.getLong("executescheme.assessscope.id");
        DynamicObject[] assessGroupArr = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssessGroupArr(schemeId, executeSchemeAssessScopeId);
        List assessGroupArrs = Arrays.stream(assessGroupArr).map(data -> data.getLong("id")).collect(Collectors.toList());
        DynamicObject activityEvaluationObject = this.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)assessObjectDynObj, (DynamicObject)activityEvaluationObject);
        activityEvaluationObject.set("perffile", assessObjectDynObj.get("perfile"));
        activityEvaluationObject.set("affiliateadminorg", assessObjectDynObj.get("perfile.affiliateadminorg"));
        DataEntityPropertyCollection properties = assessObjectDynObj.getDataEntityType().getProperties();
        Date perfStart = null;
        Date perfEnd = null;
        if (!properties.containsKey((Object)"perfile.bsed") || !properties.containsKey((Object)"perfile.bsled")) {
            Object perfFileObj = assessObjectDynObj.get("perfile");
            Long perfFlieId = perfFileObj instanceof Long ? (Long)perfFileObj : Long.valueOf(assessObjectDynObj.getLong("perfile.id"));
            Object[] perffileLists = PERFFILE_DOMAIN_SERVICE.getPerffileListByIds("bsled,bsed", Collections.singletonList(perfFlieId));
            if (HRArrayUtils.isNotEmpty((Object[])perffileLists)) {
                perfStart = perffileLists[0].getDate("bsed");
                perfEnd = perffileLists[0].getDate("bsled");
            }
        } else {
            perfStart = assessObjectDynObj.getDate("perfile.bsed");
            perfEnd = assessObjectDynObj.getDate("perfile.bsled");
        }
        if (perfStart != null && perfEnd != null) {
            activityEvaluationObject.set("startdate", (Object)(perfStart.compareTo(activityDynObj.getDate("periodstartdate")) < 0 ? activityDynObj.getDate("periodstartdate") : perfStart));
            activityEvaluationObject.set(ENDDATE, (Object)(perfEnd.compareTo(activityDynObj.getDate("periodenddate")) > 0 ? activityDynObj.getDate("periodenddate") : perfEnd));
        }
        activityEvaluationObject.set("activity", (Object)activityDynObj);
        activityEvaluationObject.set("assessperiod", activityDynObj.get("period"));
        if (!HRObjectUtils.isEmpty((Object)activityDynObj.get("year"))) {
            activityEvaluationObject.set("assessyear", (Object)HRDateTimeUtils.getYear((Date)((Date)activityDynObj.get("year"))));
        }
        Long evaluatorWorkFlowId = defaultWorkFlow.get("2");
        activityEvaluationObject.set("evalflow", (Object)evaluatorWorkFlowId);
        Long indicatorWorkFlowId = defaultWorkFlow.get("1");
        activityEvaluationObject.set("formulateflow", (Object)indicatorWorkFlowId);
        activityEvaluationObject.set("assscore", (Object)assScore);
        activityEvaluationObject.set("assessstaus", (Object)AssessStausEnum.JOINED.getStatus());
        activityEvaluationObject.set("createtime", (Object)new Date());
        activityEvaluationObject.set("modifytime", (Object)new Date());
        activityEvaluationObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        activityEvaluationObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        activityEvaluationObject.set("person", assessObjectDynObj.get("person"));
        activityEvaluationObject.set("perforg", assessObjectDynObj.get("perfile.pmdorg"));
        if (activityEvaluationObject.get("assgroup") != null && !assessGroupArrs.contains(groupId = Long.valueOf(activityEvaluationObject.get("assgroup") instanceof Long ? activityEvaluationObject.getLong("assgroup") : activityEvaluationObject.getDynamicObject("assgroup").getLong("id")))) {
            activityEvaluationObject.set("assgroup", (Object)defaultAssessGroup);
        }
        activityEvaluationObject.set("startstatus", (Object)10);
        activityEvaluationObject.set("empposrel", assessObjectDynObj.get("perfile.empposrel"));
        activityEvaluationObject.set("ressyncstatus", (Object)"10");
        activityEvaluationObject.set("iscurperiod", (Object)"true");
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)iBuildActivityEvaluationDynObjService, IBuildActivityEvaluationDynObjService.class, (String)"kd.opmc.epa.business.domain.activitymanage.extpoint.IBuildActivityEvaluationDynObjService#afterBuildActivityEvaluationDynObj", (PluginFilter)null);
        pluginProxy.callAfter(p -> {
            p.afterBuildActivityEvaluationDynObj(activityEvaluationObject);
            return null;
        });
        return activityEvaluationObject;
    }

    private String getAssScore(DynamicObject assessFormDynObj) {
        if (ObjectUtils.isEmpty((Object)assessFormDynObj)) {
            return "0/0";
        }
        BigDecimal maxScore = assessFormDynObj.getBigDecimal("scoresystem.maxscore");
        String stripZeroVal = maxScore.stripTrailingZeros().toPlainString();
        return "0/" + stripZeroVal;
    }

    public Map<String, Long> getDefaultWorkFlowMap(DynamicObjectCollection flowEntryColl) {
        HashSet<Long> defaultWorkFlowIdSet = new HashSet<Long>(16);
        for (DynamicObject tempDynObj : flowEntryColl) {
            if (!this.checkDefaultEvalAndFormulateFlow(tempDynObj)) continue;
            defaultWorkFlowIdSet.add(tempDynObj.getLong("flowvid"));
        }
        DynamicObjectCollection workFlowDynObjColl = WORK_FLOW_ENTITY_SERVICE.queryOriginalCollection("id,workflowtype", new QFilter("id", "in", defaultWorkFlowIdSet).toArray());
        return workFlowDynObjColl.stream().collect(Collectors.toMap(dynObj -> dynObj.getString("workflowtype"), dynObj -> dynObj.getLong("id"), (key1, key2) -> key1));
    }

    public DynamicObjectCollection getPerfWorkFlowEntryColl(DynamicObject activityDynObj) {
        long perfWorkFlowId = activityDynObj.getLong("perfworkflow.id");
        DynamicObject workFlowDynObj = PERF_WORK_FLOW_DOMAIN_SERVICE.loadSingleWorkFlow(perfWorkFlowId);
        return workFlowDynObj.getDynamicObjectCollection("flowentry");
    }

    public void addEvaluationObjects(DynamicObject[] assessObjectArr, DynamicObject activityDynObj) {
        DynamicObject[] evaluationObjectSavedArr = new DynamicObject[assessObjectArr.length];
        HashMap<String, Long> defaultWorkFlow = new HashMap(16);
        List<Object> batchFlowTaskResultBoList = new ArrayList(10);
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required();){
            try {
                DynamicObjectCollection flowEntryColl = this.getPerfWorkFlowEntryColl(activityDynObj);
                defaultWorkFlow = this.getDefaultWorkFlowMap(flowEntryColl);
                long assessFormId = activityDynObj.getLong("assessform.id");
                DynamicObject assessFormDynObj = assessFormId == 0L ? null : ASSESS_FORM_ENTITY.loadSingle(assessFormId);
                ArrayList<DynamicObject> needSaveEvaluationObjectList = new ArrayList<DynamicObject>(16);
                this.saveAreaInstanceAndSetAreaInstanceId(assessObjectArr, activityDynObj, defaultWorkFlow, needSaveEvaluationObjectList, assessFormDynObj);
                this.setEvaluationObjectId(needSaveEvaluationObjectList);
                DynamicObject[] evaluationObjectArr = (DynamicObject[])this.saveEvaluationObject(needSaveEvaluationObjectList.toArray(new DynamicObject[0]));
                List<Long> evaluationObjIdList = Arrays.stream(evaluationObjectArr).map(evaluationObject -> evaluationObject.getLong("id")).collect(Collectors.toList());
                evaluationObjectSavedArr = this.getEvaluationObjectByIdList(evaluationObjIdList);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
                txHandle.markRollback();
                throw ex;
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        batchFlowTaskResultBoList = this.preCreateEvaluationObjectProcessInstance(evaluationObjectSavedArr, defaultWorkFlow);
        if (evaluationObjectSavedArr.length <= 20) {
            this.saveEvaluationObject(evaluationObjectSavedArr);
        }
        if (evaluationObjectSavedArr.length > 20) {
            for (BatchFlowTaskResultBo batchFlowTaskResultBo : batchFlowTaskResultBoList) {
                StartProcessPublisher.publish((List)batchFlowTaskResultBo.getBatchTaskIdList(), (String)batchFlowTaskResultBo.getTaskType());
            }
        }
    }

    private DynamicObject[] getEvaluationObjectByIdList(List<Long> evaluationObjIdList) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(evaluationObjIdList.toArray());
    }

    private boolean setEvalFlow(DynamicObject evalObj, DynamicObject activity) {
        DynamicObject dyc;
        Optional<DynamicObject> optional;
        Optional<DynamicObject> objectOptional;
        DynamicObjectCollection dynamicObjectCollection = activity.getDynamicObjectCollection("assgroupentry");
        if (dynamicObjectCollection.size() > 0 && (objectOptional = dynamicObjectCollection.stream().filter(dynamicObject -> HRObjectUtils.equals((Object)dynamicObject.getLong("assgroup.id"), (Object)evalObj.getLong("assgroup.id"))).findFirst()).isPresent() && !HRObjectUtils.isEmpty((Object)objectOptional.get()) && (optional = (dyc = objectOptional.get()).getDynamicObjectCollection("groupassflow").stream().filter(flow -> flow.getBoolean("afisdefault")).findFirst()).isPresent() && !HRObjectUtils.isEmpty((Object)optional.get())) {
            DynamicObject outflow = optional.get();
            evalObj.set("evalflow", outflow.get("flowvid"));
            DynamicObject workflow = WORK_FLOW_ENTITY_SERVICE.loadSingle((Object)outflow.getDynamicObject("flowvid").getLong("id"));
            DynamicObjectCollection workflowDynamicObjectCollection = workflow.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject2 : workflowDynamicObjectCollection) {
                DynamicObject addNew = evalObj.getDynamicObjectCollection("evalflowentry").addNew();
                addNew.set("evalflowdef", (Object)dynamicObject2.getLong("flowdefproc"));
            }
            return true;
        }
        return false;
    }

    public DynamicObject[] queryActivityEvaluationObjectActivityId(String selectFields, Long activityId) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.queryActivityEvaluationObjectActivityId(selectFields, activityId);
    }

    public DynamicObject[] queryActivityEvaluationObjectById(String selectFields, List<Long> ids) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.queryActivityEvaluationObjectById(selectFields, ids);
    }

    public DynamicObject generateEmptyDynamicObject() {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.generateEmptyDynamicObject();
    }

    public List<Map<String, Object>> getMainChargeInfoByOrg(Long adminOrgId) {
        List mainChargeInfoByOrg = WORK_ROLE_SERVICE.getMainChargeInfoByOrg(Collections.singletonList(adminOrgId));
        LOG.info("getMainChargeInfoByOrg\uff1a{}", (Object)mainChargeInfoByOrg);
        return mainChargeInfoByOrg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initEvalObjAssessTableInfo(Long[] evalObjIds) {
        DynamicObject[] evalObjDys = ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(evalObjIds);
        Map<Long, List<DynamicObject>> groupByActivity = Arrays.stream(evalObjDys).collect(Collectors.groupingBy(evalObjDy -> evalObjDy.getLong("activity.id")));
        if (groupByActivity.size() != 1) {
            LOG.error("The assess activity of evaluation objects must be the same");
            return;
        }
        AssessActivityDomainService assessActivityDomainService = new AssessActivityDomainService();
        DynamicObject activityDy = assessActivityDomainService.queryActivity(evalObjDys[0].getLong("activity.id"));
        DynamicObjectCollection assGroupDys = activityDy.getDynamicObjectCollection("assgroupentry");
        List<DynamicObject> assGroupsOfTableRequire = assGroupDys.stream().filter(assGroup -> assGroup.getBoolean("isasstablerequire")).collect(Collectors.toList());
        assGroupDys.removeAll(assGroupsOfTableRequire);
        try (TXHandle txhandle = TX.required();){
            if (!assGroupsOfTableRequire.isEmpty()) {
                this.initEvalObjAssessTableInfoForActivity(assGroupsOfTableRequire, evalObjDys);
            }
            if (!assGroupDys.isEmpty()) {
                long ruleId = activityDy.getDynamicObject("rule").getLong("id");
                this.initEvalObjAssessTableInfoForRule((List<DynamicObject>)assGroupDys, evalObjDys, ruleId);
            }
        }
    }

    private void initEvalObjAssessTableInfoForRule(List<DynamicObject> assGroupDys, DynamicObject[] evalObjDys, long ruleId) {
        Set assGroupIds = assGroupDys.stream().map(assGroupDy -> assGroupDy.getDynamicObject("assgroup").getLong("id")).collect(Collectors.toSet());
        List<DynamicObject> evalObjDyList = Arrays.stream(evalObjDys).filter(evalObjDy -> assGroupIds.contains(evalObjDy.getLong("assgroup.id"))).collect(Collectors.toList());
        DynamicObject ruleDy = ASSESS_FORM_ENTITY.loadSingle(ruleId);
        DynamicObjectCollection assTableConfOfRule = ruleDy.getDynamicObjectCollection("areaconfentry");
        HashMap<Long, DynamicObject> areaConfCache = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, List<DynamicObject>> areaInstanceListOfAreaRegMap = new HashMap<Long, List<DynamicObject>>(16);
        long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject evalObjDy2 : evalObjDyList) {
            evalObjDy2.set("modifytime", (Object)new Date());
            evalObjDy2.set("modifier", (Object)userId);
            DynamicObjectCollection areaEntry = evalObjDy2.getDynamicObjectCollection("areaentry");
            areaEntry.clear();
            for (DynamicObject assTableConf : assTableConfOfRule) {
                DynamicObject areaInstanceEntryRow = new DynamicObject(areaEntry.getDynamicObjectType());
                long areaRegId = assTableConf.getDynamicObject("areareg").getLong("id");
                long confId = assTableConf.getLong("areaconf");
                areaInstanceEntryRow.set("areareg", (Object)areaRegId);
                areaInstanceEntryRow.set("areaconf", (Object)confId);
                DynamicObject areaInstance = this.initAreaInstance(areaConfCache, areaRegId, confId);
                if (areaInstance == null) continue;
                ArrayList<DynamicObject> areaInstanceDys = (ArrayList<DynamicObject>)areaInstanceListOfAreaRegMap.get(areaRegId);
                if (ObjectUtils.isEmpty((Object)areaInstanceDys)) {
                    areaInstanceDys = new ArrayList<DynamicObject>(10);
                    areaInstanceListOfAreaRegMap.put(areaRegId, areaInstanceDys);
                }
                areaInstanceDys.add(areaInstance);
                areaInstanceEntryRow.set("areains", areaInstance.getPkValue());
                areaEntry.add((Object)areaInstanceEntryRow);
            }
        }
        this.saveEvalObject(evalObjDyList, areaInstanceListOfAreaRegMap);
    }

    private void saveEvalObject(List<DynamicObject> evalObjDyList, Map<Long, List<DynamicObject>> areaInstanceListOfAreaRegMap) {
        for (Map.Entry<Long, List<DynamicObject>> areaInstance : areaInstanceListOfAreaRegMap.entrySet()) {
            long areaRegId = areaInstance.getKey();
            OpmcEntityService entity = AREA_INS_ENTITY_MAP.get(areaRegId);
            if (!ObjectUtils.isEmpty((Object)entity)) {
                entity.save(areaInstance.getValue().toArray(new DynamicObject[0]));
                continue;
            }
            LOG.info("Excluded areaReg {}", (Object)areaRegId);
        }
        ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evalObjDyList.toArray(new DynamicObject[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEvalObject(DynamicObject[] evalObjDys, Map<Long, List<DynamicObject>> areaInstanceListOfAreaRegMap) {
        try (TXHandle txHandle = TX.required();){
            ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evalObjDys);
            for (Map.Entry<Long, List<DynamicObject>> areaInstance : areaInstanceListOfAreaRegMap.entrySet()) {
                long areaRegId = areaInstance.getKey();
                OpmcEntityService entity = AREA_INS_ENTITY_MAP.get(areaRegId);
                if (!ObjectUtils.isEmpty((Object)entity)) {
                    entity.save(areaInstance.getValue().toArray(new DynamicObject[0]));
                    continue;
                }
                LOG.info("Excluded areaReg {}", (Object)areaRegId);
            }
        }
    }

    private DynamicObject initAreaInstance(Map<Long, DynamicObject> areaConfCache, long areaRegId, long confId) {
        DynamicObject conf;
        DynamicObject areaInstance;
        OpmcEntityService entity = AREA_INS_ENTITY_MAP.get(areaRegId);
        if (!ObjectUtils.isEmpty((Object)entity)) {
            areaInstance = entity.generateEmptyDynamicObject();
            conf = this.getAssessFormConf(areaConfCache, areaRegId, confId);
            if (areaRegId == AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId()) {
                areaInstance.set("areascore", conf.get("areascore"));
                areaInstance.set("areaweight", conf.get("weight"));
                areaInstance.set("areaconf", (Object)confId);
                areaInstance.set("scoresystem", conf.get("scoresystem"));
            } else if (areaRegId == AreaRegEnum.PLUS_MINUS_AREA.getAreaPkId()) {
                BigDecimal minusLimit = conf.getBigDecimal("minuslimit");
                BigDecimal plusLimit = conf.getBigDecimal("pluslimit");
                boolean isPartIn = conf.getBoolean("ispartin");
                areaInstance.set("minareascore", (Object)minusLimit);
                areaInstance.set("maxareascore", (Object)plusLimit);
                areaInstance.set("ispartin", (Object)isPartIn);
                areaInstance.set("areaconf", (Object)confId);
            }
        } else {
            LOG.error("Excluded areaReg {0}", (Object)areaRegId);
            return null;
        }
        areaInstance.set("description", conf.get("description"));
        areaInstance.set("createtime", (Object)new Date());
        areaInstance.set("creator", (Object)RequestContext.get().getCurrUserId());
        ORM.create().setPrimaryKey(areaInstance);
        return areaInstance;
    }

    private DynamicObject getAssessFormConf(Map<Long, DynamicObject> areaConfCache, long areaRegId, long confId) {
        DynamicObject conf = areaConfCache.get(confId);
        if (ObjectUtils.isEmpty((Object)conf)) {
            if (areaRegId == AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId()) {
                conf = ASSESS_RULE_DOMAIN_SERVICE.queryNormalConfigByPk(confId);
            } else if (areaRegId == AreaRegEnum.PLUS_MINUS_AREA.getAreaPkId()) {
                conf = ASSESS_RULE_DOMAIN_SERVICE.queryPlusMinusConfigByPk(confId);
            } else if (areaRegId == AreaRegEnum.ATTACH_AREA.getAreaPkId()) {
                conf = ASSESS_RULE_DOMAIN_SERVICE.queryAttachConfigByPk(confId);
            }
            areaConfCache.put(confId, conf);
        }
        return conf;
    }

    public void initEvalObjAssessTableInfoForActivity(List<DynamicObject> assGroupDys, DynamicObject[] evalObjDys) {
        Map assGroupMap = assGroupDys.stream().collect(Collectors.toMap(assGroupDy -> assGroupDy.getDynamicObject("assgroup").getLong("id"), Function.identity(), (key1, key2) -> key2));
        Map<Long, List<DynamicObject>> evalObjDysGroupByAssGroups = Arrays.stream(evalObjDys).filter(evalObjDy -> assGroupMap.containsKey(evalObjDy.getLong("assgroup.id"))).collect(Collectors.groupingBy(evalObjDy -> evalObjDy.getLong("assgroup.id")));
        Map<Long, DynamicObject> areaInstanceMap = this.getAreaInstanceMapOfActivityAssGroup(assGroupDys);
        ArrayList<DynamicObject> evalObjOfCopy = new ArrayList<DynamicObject>(evalObjDys.length);
        long userId = RequestContext.get().getCurrUserId();
        Date currentDate = new Date();
        HashMap<Long, List<DynamicObject>> allAreaInstanceColl = new HashMap<Long, List<DynamicObject>>(16);
        for (Map.Entry<Long, List<DynamicObject>> evalObjDysGroupByAssGroup : evalObjDysGroupByAssGroups.entrySet()) {
            Long assGroupId = evalObjDysGroupByAssGroup.getKey();
            DynamicObject assGroupDy2 = (DynamicObject)assGroupMap.get(assGroupId);
            DynamicObjectCollection assTableConfEntry = assGroupDy2.getDynamicObjectCollection("asstableconfentry");
            List<DynamicObject> evalObjDysOfAssGroup = evalObjDysGroupByAssGroup.getValue();
            for (DynamicObject evalObjDyOfAssGroup : evalObjDysOfAssGroup) {
                evalObjDyOfAssGroup.set("modifier", (Object)userId);
                evalObjDyOfAssGroup.set("modifytime", (Object)currentDate);
                this.putAreaInstance(allAreaInstanceColl, this.copyPreIndicatorToEvalObj(areaInstanceMap, assTableConfEntry, evalObjDyOfAssGroup, true));
            }
            evalObjOfCopy.addAll(evalObjDysOfAssGroup);
        }
        this.saveEvalObject(evalObjOfCopy, allAreaInstanceColl);
    }

    public void initEvalObjAssessTableFromIndicatorGroup(DynamicObject indiGroup, DynamicObject[] evalObjDys) {
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)INDICATOR_SET_GROUP_SERVICE, IIndicatorSetGroupService.class, (String)"kd.opmc.epa.business.domain.activitymanage.extpoint.IIndicatorSetGroupService#getNotCopyAreaConfIds", (PluginFilter)null);
        List sets = proxy.callReplaceIfPresent(IIndicatorSetGroupService::getNotCopyAreaConfIds);
        HashSet set = new HashSet(16);
        sets.stream().filter(Objects::nonNull).forEach(set::addAll);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)INDICATOR_SET_GROUP_SERVICE, IIndicatorSetGroupService.class, (String)"kd.opmc.epa.business.domain.activitymanage.extpoint.IIndicatorSetGroupService#afterSetIndicatorGroup", (PluginFilter)null);
        pluginProxy.callAfter(p -> {
            this.initEvalObjAssessTableInfoForActivity(indiGroup, evalObjDys, set);
            return null;
        });
    }

    private void initEvalObjAssessTableInfoForActivity(DynamicObject indiGroup, DynamicObject[] evalObjDys, Set<Long> notCopyAreaConfIds) {
        if (ObjectUtils.isEmpty((Object[])evalObjDys)) {
            return;
        }
        if (indiGroup == null) {
            return;
        }
        DynamicObjectCollection indAreaConfEntry = indiGroup.getDynamicObjectCollection("indareaconfentry");
        if (notCopyAreaConfIds != null) {
            indAreaConfEntry = indAreaConfEntry.stream().filter(indareaconf -> !notCopyAreaConfIds.contains(indareaconf.getLong("area.id"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        }
        Set<Long> areaInstanceIds = indAreaConfEntry.stream().filter(indareaconf -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(indareaconf.getLong("area.id"))).map(indareaconf -> indareaconf.getLong("areainstance")).collect(Collectors.toSet());
        DynamicObject[] genInstCollection = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryGenInstance(areaInstanceIds);
        BigDecimal sumIndctrScore = this.getSumOfTarget(genInstCollection, "indctrscore");
        BigDecimal sumWeightScore = this.getSumOfTarget(genInstCollection, "weight");
        DynamicObject activityDy = evalObjDys[0].getDynamicObject("activity");
        IndicatorGroupDomainService indicatorGroupDomainService = new IndicatorGroupDomainService();
        DynamicObject assessFormDy = indicatorGroupDomainService.queryAssessFormByActivityId(activityDy.getLong("id"));
        DynamicObject scoreSystemDy = EXECUTE_SCHEME_DOMAIN_SERVICE.queryScoreSystemByScoreSystemId(assessFormDy.getLong("scoresystem.id"));
        String numAccuracy = assessFormDy.getString("numaccuracy");
        String scaleType = assessFormDy.getString("scaletype");
        String score = sumIndctrScore.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get(scaleType).getType()).stripTrailingZeros().toPlainString();
        String maxScoreOfSystem = scoreSystemDy.getBigDecimal("maxscore").setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get(scaleType).getType()).stripTrailingZeros().toPlainString();
        HashMap<Long, List<DynamicObject>> allAreaInstanceColl = new HashMap<Long, List<DynamicObject>>(16);
        Map<Long, DynamicObject> areaInstanceMap = this.getAreaInstanceMapOfIndiGroup(indAreaConfEntry);
        for (DynamicObject evalObjDy : evalObjDys) {
            evalObjDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            evalObjDy.set("modifytime", (Object)new Date());
            evalObjDy.set("indigroup", (Object)indiGroup);
            evalObjDy.set("assweight", (Object)sumWeightScore.divide(new BigDecimal(100), 2, 1));
            evalObjDy.set("assscore", (Object)(score + "/" + maxScoreOfSystem));
            this.putAreaInstance(allAreaInstanceColl, this.copyPreIndicatorToEvalObj(areaInstanceMap, indAreaConfEntry, evalObjDy, notCopyAreaConfIds));
        }
        this.saveEvalObject(evalObjDys, allAreaInstanceColl);
    }

    private BigDecimal getSumOfTarget(DynamicObject[] genInstCollection, String target) {
        List indctrScoreList = Arrays.stream(genInstCollection).flatMap(genInst -> genInst.getDynamicObjectCollection("entryentity").stream()).map(item -> item.getBigDecimal(target)).collect(Collectors.toList());
        return indctrScoreList.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private void putAreaInstance(Map<Long, List<DynamicObject>> allAreaInstanceColl, Map<Long, List<DynamicObject>> areaInstanceColl) {
        for (Map.Entry<Long, List<DynamicObject>> entry : areaInstanceColl.entrySet()) {
            List<DynamicObject> dynamicObjects = allAreaInstanceColl.get(entry.getKey());
            if (ObjectUtils.isEmpty(dynamicObjects)) {
                allAreaInstanceColl.put(entry.getKey(), entry.getValue());
                continue;
            }
            dynamicObjects.addAll((Collection<DynamicObject>)entry.getValue());
        }
    }

    private Map<Long, List<DynamicObject>> copyPreIndicatorToEvalObj(Map<Long, DynamicObject> areaInstanceMap, DynamicObjectCollection assTableConfEntry, DynamicObject evalObjDy, boolean isActivityCopy) {
        HashMap<Long, List<DynamicObject>> areaInstanceColl = new HashMap<Long, List<DynamicObject>>(16);
        DynamicObjectCollection areaEntry = evalObjDy.getDynamicObjectCollection("areaentry");
        DynamicObject activityDy = evalObjDy.getDynamicObject("activity");
        areaEntry.clear();
        ORM orm = ORM.create();
        for (DynamicObject assTableConf : assTableConfEntry) {
            long areaInstanceIdOfConf;
            long areaRegId;
            DynamicObject areaInstanceEntryRow = new DynamicObject(areaEntry.getDynamicObjectType());
            if (isActivityCopy) {
                areaRegId = assTableConf.getDynamicObject("area").getLong("id");
                areaInstanceIdOfConf = assTableConf.getLong("areainstance");
            } else {
                areaRegId = assTableConf.getDynamicObject("areareg").getLong("id");
                areaInstanceIdOfConf = assTableConf.getLong("areains");
            }
            areaInstanceEntryRow.set("areareg", (Object)areaRegId);
            areaInstanceEntryRow.set("areaconf", (Object)assTableConf.getLong("areaconf"));
            DynamicObject areaInstance = this.initAreaInstance(areaInstanceMap.get(areaInstanceIdOfConf), activityDy, orm, areaRegId, isActivityCopy);
            if (areaInstance == null) continue;
            areaInstance.set("areaactevalobj", (Object)evalObjDy.getLong("id"));
            areaInstance.set("areaassessyear", (Object)evalObjDy.getInt("assessyear"));
            areaInstance.set("areaassessperiod", (Object)evalObjDy.getString("assessperiod"));
            areaInstance.set("areaactivity", (Object)evalObjDy.getLong("activity.id"));
            areaInstance.set("areaperforg", (Object)evalObjDy.getLong("perforg.id"));
            areaInstanceEntryRow.set("areains", areaInstance.getPkValue());
            areaEntry.add((Object)areaInstanceEntryRow);
            ArrayList<DynamicObject> areaInstanceDys = (ArrayList<DynamicObject>)areaInstanceColl.get(areaRegId);
            if (ObjectUtils.isEmpty((Object)areaInstanceDys)) {
                areaInstanceDys = new ArrayList<DynamicObject>(10);
                areaInstanceColl.put(areaRegId, areaInstanceDys);
            }
            areaInstanceDys.add(areaInstance);
        }
        return areaInstanceColl;
    }

    private Map<Long, List<DynamicObject>> copyPreIndicatorToEvalObj(Map<Long, DynamicObject> areaInstanceMap, DynamicObjectCollection indAreaConfEntry, DynamicObject evalObjDy, Set<Long> notCopyAreaConfIds) {
        HashMap<Long, List<DynamicObject>> areaInstanceColl = new HashMap<Long, List<DynamicObject>>(16);
        DynamicObjectCollection areaEntry = evalObjDy.getDynamicObjectCollection("areaentry");
        if (notCopyAreaConfIds != null) {
            areaEntry = areaEntry.stream().filter(indareaconf -> !notCopyAreaConfIds.contains(indareaconf.getLong("areareg_id"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        }
        DynamicObject activityDy = evalObjDy.getDynamicObject("activity");
        List collect = indAreaConfEntry.stream().filter(indArea -> !AreaRegEnum.CUSTOM_AREA.getAreaPkId().equals(indArea.get("area.id"))).collect(Collectors.toList());
        if (areaEntry.size() != collect.size()) {
            return areaInstanceColl;
        }
        Map<Long, Long> areaMap = areaEntry.stream().collect(Collectors.toMap(area -> area.getLong("areaconf"), area -> area.getLong("areains")));
        for (int i = 0; i < collect.size(); ++i) {
            DynamicObject indAreaConf = (DynamicObject)collect.get(i);
            long areaInstId = areaMap.get(indAreaConf.getLong("areaconf"));
            long areaRegId = indAreaConf.getLong("area.id");
            DynamicObject areaInstance = this.copyAreaInstance(areaInstanceMap.get(indAreaConf.getLong("areainstance")), activityDy, areaRegId, true, areaInstId);
            if (areaInstance == null) continue;
            areaInstance.set("areaactevalobj", (Object)evalObjDy.getLong("id"));
            areaInstance.set("areaassessyear", (Object)evalObjDy.getInt("assessyear"));
            areaInstance.set("areaassessperiod", (Object)evalObjDy.getString("assessperiod"));
            areaInstance.set("areaactivity", (Object)evalObjDy.getLong("activity.id"));
            areaInstance.set("areaperforg", (Object)evalObjDy.getLong("perforg.id"));
            ArrayList<DynamicObject> areaInstanceDys = (ArrayList<DynamicObject>)areaInstanceColl.get(areaRegId);
            if (ObjectUtils.isEmpty((Object)areaInstanceDys)) {
                areaInstanceDys = new ArrayList<DynamicObject>(10);
                areaInstanceColl.put(areaRegId, areaInstanceDys);
            }
            areaInstanceDys.add(areaInstance);
        }
        return areaInstanceColl;
    }

    private DynamicObject copyAreaInstance(DynamicObject areaInstanceOfGroup, DynamicObject activityDy, long areaRegId, boolean isActivityCopy, long areaInstId) {
        OpmcEntityService entity = AREA_INS_ENTITY_MAP.get(areaRegId);
        if (ObjectUtils.isEmpty((Object)entity)) {
            LOG.error("Excluded areaReg {0}", (Object)areaRegId);
            return null;
        }
        DynamicObject areaInstance = entity.queryOne((Object)areaInstId);
        HRDynamicObjectUtils.copy((DynamicObject)areaInstanceOfGroup, (DynamicObject)areaInstance, this.getIgnoreKeys());
        areaInstance.set("areafrom", (Object)areaInstanceOfGroup.getLong("id"));
        DynamicObjectCollection indicatorDys = areaInstance.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection areaInstDys = areaInstanceOfGroup.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < indicatorDys.size(); ++i) {
            DynamicObject indicatorDy = (DynamicObject)indicatorDys.get(i);
            if (isActivityCopy) {
                indicatorDy.set("ispreinstall", (Object)"1");
            }
            indicatorDy.set("assessyear", (Object)HRDateTimeUtils.getYear((Date)activityDy.getDate("year")));
            indicatorDy.set("assessperiod", activityDy.get("period"));
            indicatorDy.set("activity", activityDy.getPkValue());
            indicatorDy.set("from", (Object)((DynamicObject)areaInstDys.get(i)).getLong("id"));
            if (!AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaRegId)) continue;
            indicatorDy.set("realweight", (Object)((DynamicObject)areaInstDys.get(i)).getBigDecimal("weight"));
        }
        return areaInstance;
    }

    private DynamicObject copyAreaInstance(DynamicObject activityDy, long areaRegId, long sourceAreaInstId, long targetAreaInstId) {
        OpmcEntityService entity = AREA_INS_ENTITY_MAP.get(areaRegId);
        if (ObjectUtils.isEmpty((Object)entity)) {
            LOG.error("Excluded areaReg {0}", (Object)areaRegId);
            return null;
        }
        DynamicObject targetAreaInst = entity.queryOne((Object)targetAreaInstId);
        DynamicObject sourceAreaInst = entity.queryOne((Object)sourceAreaInstId);
        if (ObjectUtils.isEmpty((Object)sourceAreaInst)) {
            LOG.error("copyAreaInstance method param\uff1a[sourceAreaInst] is empty");
            return null;
        }
        HRDynamicObjectUtils.copy((DynamicObject)sourceAreaInst, (DynamicObject)targetAreaInst, this.getIgnoreKeys());
        targetAreaInst.set("areafrom", (Object)sourceAreaInst.getLong("id"));
        DynamicObjectCollection targetIndicatorDys = targetAreaInst.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection sourceIndicatorDys = sourceAreaInst.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < targetIndicatorDys.size(); ++i) {
            DynamicObject indicatorDy = (DynamicObject)targetIndicatorDys.get(i);
            indicatorDy.set("ispreinstall", (Object)"1");
            indicatorDy.set("assessyear", (Object)HRDateTimeUtils.getYear((Date)activityDy.getDate("year")));
            indicatorDy.set("assessperiod", activityDy.get("period"));
            indicatorDy.set("activity", activityDy.getPkValue());
            indicatorDy.set("from", (Object)((DynamicObject)sourceIndicatorDys.get(i)).getLong("id"));
            if (!AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaRegId)) continue;
            indicatorDy.set("realweight", (Object)((DynamicObject)sourceIndicatorDys.get(i)).getBigDecimal("weight"));
        }
        return targetAreaInst;
    }

    private Set<String> getIgnoreKeys() {
        HashSet<String> ignoreKeys = new HashSet<String>(16);
        ignoreKeys.add("id");
        return ignoreKeys;
    }

    private DynamicObject initAreaInstance(DynamicObject areaInstanceOfActivity, DynamicObject activityDy, ORM orm, long areaRegId, boolean isActivityCopy) {
        OpmcEntityService entity = AREA_INS_ENTITY_MAP.get(areaRegId);
        if (ObjectUtils.isEmpty((Object)entity)) {
            LOG.error("Excluded areaReg {0}", (Object)areaRegId);
            return null;
        }
        DynamicObject areaInstance = entity.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)areaInstanceOfActivity, (DynamicObject)areaInstance);
        areaInstance.set("areafrom", (Object)areaInstanceOfActivity.getLong("id"));
        DynamicObjectCollection indicatorDys = areaInstance.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection areaInstDys = areaInstanceOfActivity.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < indicatorDys.size(); ++i) {
            DynamicObject indicatorDy = (DynamicObject)indicatorDys.get(i);
            if (isActivityCopy) {
                indicatorDy.set("ispreinstall", (Object)"1");
            }
            indicatorDy.set("assessyear", (Object)HRDateTimeUtils.getYear((Date)activityDy.getDate("year")));
            indicatorDy.set("assessperiod", activityDy.get("period"));
            indicatorDy.set("activity", activityDy.getPkValue());
            indicatorDy.set("from", (Object)((DynamicObject)areaInstDys.get(i)).getLong("id"));
            indicatorDy.set("realweight", (Object)((DynamicObject)areaInstDys.get(i)).getBigDecimal("weight"));
        }
        orm.setPrimaryKey(areaInstance);
        return areaInstance;
    }

    private Map<Long, DynamicObject> getAreaInstanceMapOfActivityAssGroup(List<DynamicObject> assGroupDys) {
        HashMap<Long, ArrayList<Long>> assTableConfOfAreaMap = new HashMap<Long, ArrayList<Long>>(16);
        for (DynamicObject assGroupDy : assGroupDys) {
            DynamicObjectCollection assTableConfEntry = assGroupDy.getDynamicObjectCollection("asstableconfentry");
            for (DynamicObject assTableConf : assTableConfEntry) {
                long areaId = assTableConf.getDynamicObject("area").getLong("id");
                ArrayList<Long> assTableList = (ArrayList<Long>)assTableConfOfAreaMap.get(areaId);
                if (!ObjectUtils.isEmpty((Object)assTableList)) {
                    assTableList.add(assTableConf.getLong("areainstance"));
                    continue;
                }
                assTableList = new ArrayList<Long>(10);
                assTableList.add(assTableConf.getLong("areainstance"));
                assTableConfOfAreaMap.put(areaId, assTableList);
            }
        }
        HashMap<Long, DynamicObject> areaInstanceMap = new HashMap<Long, DynamicObject>(16);
        AssessActivityDomainService assessActivityDomainService = new AssessActivityDomainService();
        for (Map.Entry assTableConfOfArea : assTableConfOfAreaMap.entrySet()) {
            DynamicObject[] areaInstanceDys = assessActivityDomainService.queryAreaAssessTable((Long)assTableConfOfArea.getKey(), (List)assTableConfOfArea.getValue());
            Map collect = Arrays.stream(areaInstanceDys).collect(Collectors.toMap(areaInstance -> areaInstance.getLong("id"), Function.identity(), (key1, key2) -> key2));
            areaInstanceMap.putAll(collect);
        }
        return areaInstanceMap;
    }

    private Map<Long, DynamicObject> getAreaInstanceMapOfIndiGroup(DynamicObjectCollection indAreaConfEntry) {
        HashMap<Long, ArrayList<Long>> confOfAreaMap = new HashMap<Long, ArrayList<Long>>(16);
        for (DynamicObject areaConf : indAreaConfEntry) {
            long areaId = areaConf.getLong("area.id");
            ArrayList<Long> assTableList = (ArrayList<Long>)confOfAreaMap.get(areaId);
            if (!ObjectUtils.isEmpty((Object)assTableList)) {
                assTableList.add(areaConf.getLong("areainstance"));
                continue;
            }
            assTableList = new ArrayList<Long>(10);
            assTableList.add(areaConf.getLong("areainstance"));
            confOfAreaMap.put(areaId, assTableList);
        }
        HashMap<Long, DynamicObject> areaInstanceMap = new HashMap<Long, DynamicObject>(16);
        AssessActivityDomainService assessActivityDomainService = new AssessActivityDomainService();
        for (Map.Entry assTableConfOfArea : confOfAreaMap.entrySet()) {
            DynamicObject[] areaInstanceDys = assessActivityDomainService.queryAreaAssessTable((Long)assTableConfOfArea.getKey(), (List)assTableConfOfArea.getValue());
            Map collect = Arrays.stream(areaInstanceDys).collect(Collectors.toMap(areaInstance -> areaInstance.getLong("id"), Function.identity(), (key1, key2) -> key2));
            areaInstanceMap.putAll(collect);
        }
        return areaInstanceMap;
    }

    public List<DynamicObject> getJoinActivityObjects(Long selectId) {
        DynamicObject[] activityEvaluationObjects = this.queryActivityEvaluationObjectActivityId("id,assessyear,nodeindex,targetmodel,perffile.depemp.id,person,employee,assessstaus,assessnode,nodestatus,assignuser,affiliateadminorg,assgroup", selectId);
        return Arrays.stream(activityEvaluationObjects).filter(activityEvaluationObject -> HRStringUtils.equals((String)activityEvaluationObject.getString("assessstaus"), (String)AssessStausEnum.JOINED.getStatus())).collect(Collectors.toList());
    }

    public List<DynamicObject> getJoinActivityObjects(List<Long> evaluationIds) {
        DynamicObject[] activityEvaluationObjects = this.queryActivityEvaluationObjectById("id,assessyear,nodeindex,targetmodel,perffile.depemp.id,person,employee,assessstaus,assessnode,nodestatus,assignuser,affiliateadminorg,assgroup,activity", evaluationIds);
        return Arrays.stream(activityEvaluationObjects).filter(activityEvaluationObject -> HRStringUtils.equals((String)activityEvaluationObject.getString("assessstaus"), (String)AssessStausEnum.JOINED.getStatus())).collect(Collectors.toList());
    }

    public DynamicObject[] queryEvaluationObjectOfAssigner(long activityId) {
        long userId = RequestContext.get().getCurrUserId();
        QFilter assignUserFilter = new QFilter("assignuser", "=", (Object)userId);
        QFilter activityFilter = new QFilter("activity", "=", (Object)activityId);
        QFilter nodeFilter = new QFilter("assessnode", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
        QFilter nodeStatusFilter = new QFilter("nodestatus", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus());
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.query("person, perffile", new QFilter[]{activityFilter, assignUserFilter, nodeFilter, nodeStatusFilter});
    }

    public DynamicObject queryAssessRule(long ruleId) {
        return this.queryAssessForm(ruleId);
    }

    public DynamicObject loadAssessForm(Object formId) {
        return ASSESS_FORM_ENTITY.loadSingle(formId);
    }

    public DynamicObject queryAssessForm(long formId) {
        return ASSESS_FORM_ENTITY.queryOne("consistentwitharea,scorecalcway,evalway,numaccuracy,scoresystem,scoresystem.maxscore,scoresystem.minscore,allowexceedupper,limitmaxscore,allowexceedlower,limitminscore,empinfoconf,areaconfentry, areaconfentry.areaconf,areaconfentry.areareg,evasumlimit, limitmaxratio", formId);
    }

    public DynamicObject queryScoreSystemByForm(Long formId) {
        return ASSESS_FORM_ENTITY.queryOne("areaconfentry, areaconfentry.areaconf,areaconfentry.areareg, scoresystem, scoresystem.maxscore", formId);
    }

    public DynamicObject[] loadDynamicObjectArray(Long[] ids) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(ids);
    }

    private void setTargetPerson(DynamicObject assessActivity, DynamicObject activityEvaluation, Map<Long, List<Long>> superiorUserIdsPersonIdMap) {
        String targetPerson = assessActivity.getDynamicObject("rule").getString("targetpersion");
        switch (TargetPersonEnum.getTargetPerson(targetPerson)) {
            case DIRECT_SUPERIOR: {
                Object directSuperior = this.setDirectSuperior(activityEvaluation, superiorUserIdsPersonIdMap);
                if (!ObjectUtils.isEmpty((Object)directSuperior) && (!(directSuperior instanceof Long) || !HRObjectUtils.equals((Object)directSuperior, (Object)0L))) break;
                this.setTargetPersonNull(assessActivity, activityEvaluation, superiorUserIdsPersonIdMap);
                break;
            }
            case PERSON_IN_CHARGE: {
                Object personCharge = this.setPersonCharge(activityEvaluation);
                if (!ObjectUtils.isEmpty((Object)personCharge) && (!(personCharge instanceof Long) || !HRObjectUtils.equals((Object)personCharge, (Object)0L))) break;
                this.setTargetPersonNull(assessActivity, activityEvaluation, superiorUserIdsPersonIdMap);
                break;
            }
        }
        if (HRObjectUtils.isEmpty((Object)activityEvaluation.get("assignuser")) || HRObjectUtils.equals((Object)activityEvaluation.get("assignuser"), (Object)0L)) {
            activityEvaluation.set("assignuser", (Object)ActivityEvaluationObjectConstants.DEFAULT_USER);
        }
    }

    private Object setPersonCharge(DynamicObject activityEvaluation) {
        List<Map<String, Object>> mainChargeInfo = ActivityEvaluationObjectApplicationService.getInstance().getMainChargeInfoByOrg(activityEvaluation.getLong("affiliateadminorg.id"));
        if (!ObjectUtils.isEmpty(mainChargeInfo) && !ObjectUtils.isEmpty((Object)mainChargeInfo.get(0).get("person"))) {
            Long sysId = AssessSchemeApplicationService.getInstance().getUserIdByPersonInfo((Long)mainChargeInfo.get(0).get("person"));
            activityEvaluation.set("assignuser", (Object)sysId);
            return activityEvaluation.get("assignuser");
        }
        return null;
    }

    private Object setDirectSuperior(DynamicObject activityEvaluation, Map<Long, List<Long>> superiorUserIdsPersonIdMap) {
        if (ObjectUtils.isEmpty(superiorUserIdsPersonIdMap)) {
            return null;
        }
        List<Long> superiorUsers = superiorUserIdsPersonIdMap.get(activityEvaluation.getLong("person.id"));
        if (!ObjectUtils.isEmpty(superiorUsers)) {
            activityEvaluation.set("assignuser", (Object)superiorUsers.get(0));
            return activityEvaluation.get("assignuser");
        }
        return null;
    }

    private void setTargetPersonNull(DynamicObject assessActivity, DynamicObject activityEvaluation, Map<Long, List<Long>> superiorUserIdsPersonIdMap) {
        String targetPerson = assessActivity.getDynamicObject("rule").getString("targetpersionnull");
        switch (TargetPersonNullEnum.getTargetPerson(targetPerson)) {
            case SCHEME_CREATOR: {
                activityEvaluation.set("assignuser", (Object)assessActivity.getDynamicObject("scheme").getLong("creator.id"));
                break;
            }
            case DIRECT_SUPERIOR: {
                this.setDirectSuperior(activityEvaluation, superiorUserIdsPersonIdMap);
                break;
            }
            case DEPARTMENT_HEAD: {
                this.setPersonCharge(activityEvaluation);
                break;
            }
        }
    }

    public void changeJoinActivity(DynamicObject assessActivity, List<DynamicObject> joinActivityEvaluation) {
        ArrayList<DynamicObject> waitToSend = new ArrayList<DynamicObject>(16);
        String targetPerson = assessActivity.getDynamicObject("rule").getString("targetpersion");
        List<Long> personIds = joinActivityEvaluation.stream().map(actEval -> actEval.getLong("person.id")).collect(Collectors.toList());
        Map<Object, Object> superiorUserIdsPersonIdMap = new HashMap(16);
        if (HRStringUtils.equals((String)TargetPersonEnum.DIRECT_SUPERIOR.getPerson(), (String)targetPerson)) {
            superiorUserIdsPersonIdMap = this.getSuperiorUserIdsByPersonIds(personIds);
        }
        Map<Object, Object> userIdsPersonIdMap = new HashMap(16);
        if (HRStringUtils.equals((String)TargetPersonEnum.EMPLOYEE_HIMSELF.getPerson(), (String)targetPerson)) {
            userIdsPersonIdMap = this.getUserIdsByPersonIds(personIds);
        }
        Map<Object, Object> finalSuperiorUserIdsPersonIdMap = superiorUserIdsPersonIdMap;
        HashMap finalUserIdsPersonIdMap = userIdsPersonIdMap;
        joinActivityEvaluation.forEach(activityEvaluation -> {
            boolean isNeedSend;
            activityEvaluation.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
            if (HRStringUtils.equals((String)TargetPersonEnum.EMPLOYEE_HIMSELF.getPerson(), (String)targetPerson) && !ObjectUtils.isEmpty((Object)finalUserIdsPersonIdMap)) {
                activityEvaluation.set("assignuser", finalUserIdsPersonIdMap.get(activityEvaluation.getLong("person.id")));
            } else {
                this.setTargetPerson(assessActivity, (DynamicObject)activityEvaluation, (Map<Long, List<Long>>)finalSuperiorUserIdsPersonIdMap);
            }
            boolean bl = isNeedSend = HRObjectUtils.equals((Object)activityEvaluation.get("targetmodel"), (Object)TargetModelEnum.SELF_FILLING.getModel()) && HRObjectUtils.isEmpty((Object)activityEvaluation.get("assessnode"));
            if (isNeedSend) {
                waitToSend.add((DynamicObject)activityEvaluation);
            }
            activityEvaluation.set("assessnode", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
            activityEvaluation.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus());
            activityEvaluation.set("nodeindex", (Object)1);
        });
        TO_DO_MESSAGE_DOMAIN_SERVICE.sendToDoMessage(waitToSend, assessActivity);
    }

    public String validateAssessTableIndicatorReq(Long instanceId, DynamicObject indicatorType) {
        String indicatorTypeName = ObjectUtils.isEmpty((Object)indicatorType) ? "" : indicatorType.getString("name");
        DynamicObject[] indicatorReqs = INDICATOR_REQ_ENTITY.queryByInstanceId(instanceId);
        boolean indicatorTypeRepeat = Arrays.stream(indicatorReqs).anyMatch(indicatorReq -> indicatorReq.getLong("indicatortype.id") == indicatorType.getLong("id"));
        if (indicatorTypeRepeat) {
            return ResManager.loadKDString((String)"\u533a\u57df\u4e2d\u5df2\u8bbe\u7f6e\u4e86{0}\u7684\u8981\u6c42\uff0c\u65e0\u9700\u91cd\u590d\u8bbe\u7f6e", (String)"ActivityEvaluationObjectDomainService_0", (String)"opmc-epa-business", (Object[])new Object[]{indicatorTypeName});
        }
        return null;
    }

    public DynamicObject[] queryEvaluationObjectByIdAndAssignUser(List<Long> evalObjectIdList) {
        QFilter idFilter = new QFilter("id", "in", evalObjectIdList);
        long userId = RequestContext.get().getCurrUserId();
        QFilter assignUserFilter = new QFilter("assignuser", "=", (Object)userId);
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.query("person, perffile.pmdperson, assgroup, indicatortype, assignuser, activity, affiliateadminorg, perforg, empposrel.position, modifytime", new QFilter[]{idFilter, assignUserFilter}, "modifytime desc");
    }

    public DynamicObject[] queryEvaluationObjectById(List<Long> evalObjectIdList) {
        QFilter idFilter = new QFilter("id", "in", evalObjectIdList);
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.query("evalflow,evalflow.boid,person, perffile.pmdperson,perffile.billno,perffile.name,perffile.number,perffile.position.name,perffile.job.name, assgroup, indicatortype, assignuser, activity, affiliateadminorg, perforg, empposrel.position, modifytime, assessyear,sop, lop, sopsource,fsop,flop, fsopsource, cfsop, cflop, cfsopsource,assessperiod, empposrel, assessnode, nodestatus, creator, createtime, modifier, modifytime, evalflowentry, nodeindex, evalflowentry.evalflowru, assessstaus, activity.activitystatus, activity.perfworkflow,activity.period,activity.year,evalflowins,formulateflowins,evalflowentry.evalflowdef, evalflowentry.evalflowinfo, evalflowentry.evalevalarea, formulateflow,formulateflow.id,indigroup, assweight, assscore, areaentry.areareg, areaentry.areains, areaentry.areaconf,startstatus,isincalc,ressyncstatus,completetime,perffilev,mpsopendway,mpsopgenway,iscurperiod,ismpcalc,mprsource,mpsop,mplop,mpsopflag,mpcalcerrmsg, ismprmodify,mpgroup,mprule,mprealrule,mpsopsource,csop,clop,csopsource,floplevel,fsopscoresystem,cfloplevel,cfsopscoresystem", new QFilter[]{idFilter}, "modifytime desc");
    }

    public DynamicObject[] queryEvaluationObjectByFilter(QFilter qFilter) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.query("evalflow,evalflow.boid,person, perffile.pmdperson,perffile.billno,perffile.name,perffile.number,perffile.position.name,perffile.job.name, assgroup, indicatortype, assignuser, activity, affiliateadminorg, perforg, empposrel.position, modifytime, assessyear,sop, lop, sopsource,fsop,flop, fsopsource, cfsop, cflop, cfsopsource,assessperiod, empposrel, assessnode, nodestatus, creator, createtime, modifier, modifytime, evalflowentry, nodeindex, evalflowentry.evalflowru, assessstaus, activity.activitystatus,activity.period,activity.year,evalflowins,formulateflowins,evalflowentry.evalflowdef, evalflowentry.evalflowinfo, evalflowentry.evalevalarea, formulateflow,formulateflow.boid,indigroup, assweight, assscore, areaentry.areareg, areaentry.areains, areaentry.areaconf,startstatus,isincalc,mpsopsource", new QFilter[]{qFilter}, "modifytime desc");
    }

    public DynamicObject[] queryEvalObjStatusById(List<Long> evalObjectIdList) {
        QFilter idFilter = new QFilter("id", "in", evalObjectIdList);
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.query("startstatus", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryEvalObjFsopById(List<Long> evalObjectIdList) {
        QFilter idFilter = new QFilter("id", "in", evalObjectIdList);
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id, fsop, flop", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryEvalObjWithScoreById(List<Long> evalObjectIdList) {
        QFilter idFilter = new QFilter("id", "in", evalObjectIdList);
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.query("evalflow,person, perffile.pmdperson,perffile.name,perffile.billno, assgroup, indicatortype, assignuser, activity, affiliateadminorg, perforg, empposrel.position, modifytime, assessyear, assessperiod, empposrel,employee, assessnode, nodestatus, creator, createtime, modifier, modifytime, evalflowentry, nodeindex, evalflowentry.evalflowru, assessstaus,ressyncstatus ,activity.activitystatus,activity.period,activity.year,activity.executescheme.id,activity.assessform.id,person.name,person.number,evalflowentry.evalflowdef, evalflowentry.evalflowinfo, evalflowentry.evalevalarea, formulateflow,evalflowins,indigroup, assweight, assscore, areaentry.areareg, areaentry.areains, areaentry.areaconfmpsopendway,iscurperiod,satcs , satcl  , soat,leveloat ,soatsource  , soac ,loac,soacsource ,msoac,mloac , sop  ,lop , sopsource ,cfsop,cflop,cfsopsource, fsop ,flop , fsopsource,floplevel,fsopscoresystem,cfloplevel,cfsopscoresystem ,completetime,evalfinishtype,perffile.sourcevid,perffilev.id", new QFilter[]{idFilter}, "modifytime desc");
    }

    public Map<Long, DynamicObject> queryEvalObjWithIdList(String selectProperty, List<Long> evalObjectIdList) {
        Map<Object, Object> evalObjMap = Maps.newHashMapWithExpectedSize((int)16);
        QFilter idFilter = new QFilter("id", "in", evalObjectIdList);
        DynamicObject[] evalObjArr = ACTIVITY_EVALUATION_OBJECT_ENTITY.query(selectProperty, new QFilter[]{idFilter}, "modifytime desc");
        if (null == evalObjArr || evalObjArr.length <= 0) {
            return evalObjMap;
        }
        evalObjMap = Arrays.asList(evalObjArr).stream().collect(Collectors.toMap(evalObj -> evalObj.getLong("id"), evalObj -> evalObj));
        return evalObjMap;
    }

    public void copyAssessTableInfoOfCommon(long currentPkId, List<Long> copyObjIdList) {
        this.copyAssessTableInfo(currentPkId, copyObjIdList, "10");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAssessTableInfo(long currentPkId, List<Long> copyObjIdList, String indicatorType) {
        if (ObjectUtils.isEmpty(copyObjIdList)) {
            return;
        }
        ArrayList<Long> allObjIdList = new ArrayList<Long>(copyObjIdList);
        allObjIdList.add(currentPkId);
        QFilter idFilter = new QFilter("id", "in", allObjIdList);
        DynamicObject[] allObjDy = ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(new QFilter[]{idFilter});
        Map objMap = Arrays.stream(allObjDy).collect(Collectors.toMap(objDy -> objDy.getLong("id"), Function.identity()));
        DynamicObject currentObj = (DynamicObject)objMap.remove(currentPkId);
        DynamicObjectCollection areaEntry = currentObj.getDynamicObjectCollection("areaentry");
        Map<Long, List<DynamicObject>> areaInsOfRegMap = areaEntry.stream().collect(Collectors.groupingBy(area -> area.getLong("areareg.id")));
        HashMap<Long, DynamicObject> sourceAreaInsMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry<Long, List<DynamicObject>> areaInsInfoOfReg : areaInsOfRegMap.entrySet()) {
            Long areaReg = areaInsInfoOfReg.getKey();
            Long[] areaInsIds = (Long[])areaInsInfoOfReg.getValue().stream().map(areaInsInfo -> areaInsInfo.getLong("areains")).toArray(Long[]::new);
            OpmcEntityService areaInsEntity = AREA_INS_ENTITY_MAP.get(areaReg);
            DynamicObject[] areaInsDys = areaInsEntity.loadDynamicObjectArray((Object[])areaInsIds);
            Map areaInsMap = Arrays.stream(areaInsDys).collect(Collectors.toMap(areaInsDy -> areaInsDy.getLong("id"), Function.identity()));
            sourceAreaInsMap.putAll(areaInsMap);
        }
        ArrayList<DynamicObject> targetEvalObjs = new ArrayList<DynamicObject>(objMap.values());
        HashMap<Long, List<DynamicObject>> copyAreaInstanceColl = new HashMap<Long, List<DynamicObject>>(16);
        try (TXHandle txhandle = TX.required();){
            this.deleteTargetObjAreaInstance(targetEvalObjs);
            for (DynamicObject targetEvalObj : targetEvalObjs) {
                targetEvalObj.set("modifier", currentObj.get("modifier"));
                targetEvalObj.set("modifytime", currentObj.get("modifytime"));
                targetEvalObj.set("indicatortype", (Object)indicatorType);
                this.putAreaInstance(copyAreaInstanceColl, this.copyPreIndicatorToEvalObj(sourceAreaInsMap, areaEntry, targetEvalObj, false));
            }
            targetEvalObjs.add(currentObj);
            this.saveEvalObject(targetEvalObjs, copyAreaInstanceColl);
        }
    }

    private void deleteTargetObjAreaInstance(List<DynamicObject> targetEvalObjs) {
        HashMap<Long, ArrayList<Long>> delAreaInstanceColl = new HashMap<Long, ArrayList<Long>>(16);
        for (DynamicObject dynamicObject : targetEvalObjs) {
            DynamicObjectCollection delAreaEntry = dynamicObject.getDynamicObjectCollection("areaentry");
            for (DynamicObject delAreaInfo : delAreaEntry) {
                long areaReg = delAreaInfo.getLong("areareg.id");
                ArrayList<Long> instanceIds = (ArrayList<Long>)delAreaInstanceColl.get(areaReg);
                if (ObjectUtils.isEmpty((Object)instanceIds)) {
                    instanceIds = new ArrayList<Long>(10);
                    delAreaInstanceColl.put(areaReg, instanceIds);
                }
                instanceIds.add(delAreaInfo.getLong("areains"));
            }
        }
        for (Map.Entry entry : delAreaInstanceColl.entrySet()) {
            long areaRegId = (Long)entry.getKey();
            OpmcEntityService entity = AREA_INS_ENTITY_MAP.get(areaRegId);
            if (!ObjectUtils.isEmpty((Object)entity)) {
                entity.delete((Object[])((List)entry.getValue()).toArray(new Long[0]));
                continue;
            }
            LOG.info("Excluded areaReg {}", (Object)areaRegId);
        }
    }

    public DynamicObject queryActivityAbstractInfo(Long activityId) {
        AssessActivityDomainService assessActivityDomainService = new AssessActivityDomainService();
        return assessActivityDomainService.queryActivityAbstractInfo(activityId);
    }

    public void moveObjToCustomAssign(List<Long> objIdList) {
        this.changeIndicatorAssignType(objIdList, "20");
    }

    private void changeIndicatorAssignType(List<Long> objIdList, String indicatorType) {
        QFilter idFilter = new QFilter("id", "in", objIdList);
        DynamicObject[] objList = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id, indicatortype, modifier, modifytime", new QFilter[]{idFilter});
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject dynamicObject : objList) {
            dynamicObject.set("indicatortype", (Object)indicatorType);
            dynamicObject.set("modifier", (Object)userId);
            dynamicObject.set("modifytime", (Object)date);
        }
        ACTIVITY_EVALUATION_OBJECT_ENTITY.save(objList);
    }

    public void moveObjToCommonAssign(List<Long> objIdList) {
        this.changeIndicatorAssignType(objIdList, "10");
    }

    public void copyAssessTableInfoOfCustom(long currentPkId, List<Long> copyObjIdList) {
        this.copyAssessTableInfo(currentPkId, copyObjIdList, "20");
    }

    public List<String> checkSubmitIndicator(List<Long> objIds) {
        List<String> validateMsg = new ArrayList<String>(16);
        Object[] dynamicObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(objIds.toArray());
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            DynamicObject dynamicObject = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(dynamicObjects[0].getLong("activity.id"));
            long ruleId = dynamicObject.getLong("assessform.id");
            DynamicObject ruleDy = this.queryAssessForm(ruleId);
            ScoreCalcWayEnum scoreCalcWay = ScoreCalcWayEnum.getScoreCalcWay((String)ruleDy.getString("scorecalcway"));
            String evaSumLimit = ruleDy.getString("evasumlimit");
            BigDecimal limitMaxRatioBD = new BigDecimal(100);
            if (ruleDy.getBigDecimal("limitmaxratio") != null) {
                limitMaxRatioBD = ruleDy.getBigDecimal("limitmaxratio");
            }
            if (!ObjectUtils.isEmpty((Object)scoreCalcWay)) {
                if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.SUM)) {
                    validateMsg = this.checkSumSubmitIndicator((DynamicObject[])dynamicObjects, ruleDy.getDynamicObject("scoresystem"), true);
                } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT) && EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit)) {
                    validateMsg = this.checkOutWeightSubmitIndicator((DynamicObject[])dynamicObjects, true, limitMaxRatioBD);
                } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT)) {
                    validateMsg = this.checkWeightSubmitIndicator((DynamicObject[])dynamicObjects, true);
                }
            }
        }
        return validateMsg;
    }

    public List<String> checkSubmitIndicator(Long objId, DynamicObject[] evalDynamicObjects, DynamicObject ruleDy) {
        List<String> validateMsg = new ArrayList<String>(16);
        Object[] dynamicObjects = (DynamicObject[])Arrays.stream(evalDynamicObjects).filter(dyc -> HRObjectUtils.equals((Object)dyc.getLong("id"), (Object)objId)).toArray(DynamicObject[]::new);
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObjects) && !HRObjectUtils.isEmpty((Object)ruleDy)) {
            ScoreCalcWayEnum scoreCalcWay = ScoreCalcWayEnum.getScoreCalcWay((String)ruleDy.getString("scorecalcway"));
            String evaSumLimit = ruleDy.getString("evasumlimit");
            BigDecimal limitMaxRatioBD = new BigDecimal(100);
            if (ruleDy.getBigDecimal("limitmaxratio") != null) {
                limitMaxRatioBD = ruleDy.getBigDecimal("limitmaxratio");
            }
            if (!ObjectUtils.isEmpty((Object)scoreCalcWay)) {
                if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.SUM)) {
                    validateMsg = this.checkSumSubmitIndicator((DynamicObject[])dynamicObjects, ruleDy.getDynamicObject("scoresystem"), true);
                } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT) && EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit)) {
                    validateMsg = this.checkOutWeightSubmitIndicator((DynamicObject[])dynamicObjects, true, limitMaxRatioBD);
                } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT)) {
                    validateMsg = this.checkWeightSubmitIndicator((DynamicObject[])dynamicObjects, true);
                }
            }
        }
        return validateMsg;
    }

    public List<String> checkAreaEqual(Long objId, DynamicObject[] evalDynamicObjects, DynamicObject ruleDy) {
        List<String> validateMsg = new ArrayList<String>(16);
        Object[] dynamicObjects = (DynamicObject[])Arrays.stream(evalDynamicObjects).filter(dyc -> HRObjectUtils.equals((Object)dyc.getLong("id"), (Object)objId)).toArray(DynamicObject[]::new);
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObjects) && !HRObjectUtils.isEmpty((Object)ruleDy)) {
            ScoreCalcWayEnum scoreCalcWay = ScoreCalcWayEnum.getScoreCalcWay((String)ruleDy.getString("scorecalcway"));
            String evaSumLimit = ruleDy.getString("evasumlimit");
            BigDecimal limitMaxRatioBD = new BigDecimal(100);
            if (ruleDy.getBigDecimal("limitmaxratio") != null) {
                limitMaxRatioBD = ruleDy.getBigDecimal("limitmaxratio");
            }
            if (!ObjectUtils.isEmpty((Object)scoreCalcWay)) {
                if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.SUM)) {
                    validateMsg = this.checkSumAreaEqual((DynamicObject[])dynamicObjects, ruleDy.getDynamicObject("scoresystem"));
                } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT) && EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit)) {
                    validateMsg = this.checkOutWeightEqual((DynamicObject[])dynamicObjects, limitMaxRatioBD);
                } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT)) {
                    validateMsg = this.checkWeightEqual((DynamicObject[])dynamicObjects);
                }
            }
        }
        return validateMsg;
    }

    public void deletePreinstallIndicator(List<Long> objIds) {
        DynamicObject[] evalDynamicObject = this.loadDynamicObjectArray(objIds.toArray(new Long[0]));
        this.deletePreinstallIndicator(evalDynamicObject);
        for (DynamicObject dynamicObject : evalDynamicObject) {
            dynamicObject.set("indigroup", (Object)0L);
            dynamicObject.set("assweight", (Object)this.getAssweight(dynamicObject));
            dynamicObject.set("assscore", (Object)this.getAssscore(dynamicObject));
        }
        this.saveEvaluationObject(evalDynamicObject);
    }

    public List<String> checkSurpassSubmitIndicator(Long objId, DynamicObject[] evalDynamicObjects, DynamicObject ruleDy) {
        List<String> validateMsg = new ArrayList<String>(16);
        Object[] dynamicObjects = (DynamicObject[])Arrays.stream(evalDynamicObjects).filter(dyc -> HRObjectUtils.equals((Object)dyc.getLong("id"), (Object)objId)).toArray(DynamicObject[]::new);
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObjects) && !HRObjectUtils.isEmpty((Object)ruleDy)) {
            ScoreCalcWayEnum scoreCalcWay = ScoreCalcWayEnum.getScoreCalcWay((String)ruleDy.getString("scorecalcway"));
            String evaSumLimit = ruleDy.getString("evasumlimit");
            BigDecimal limitMaxRatioBD = new BigDecimal(100);
            if (ruleDy.getBigDecimal("limitmaxratio") != null) {
                limitMaxRatioBD = ruleDy.getBigDecimal("limitmaxratio");
            }
            if (!ObjectUtils.isEmpty((Object)scoreCalcWay)) {
                if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.SUM)) {
                    validateMsg = this.checkSurpassSumSubmitIndicator((DynamicObject[])dynamicObjects, ruleDy.getDynamicObject("scoresystem"), false);
                } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT) && EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit)) {
                    validateMsg = this.checkSurpassOutWeightSubmitIndicator((DynamicObject[])dynamicObjects, false, limitMaxRatioBD);
                } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT)) {
                    validateMsg = this.checkSurpassWeightSubmitIndicator((DynamicObject[])dynamicObjects, false);
                }
            }
        }
        return validateMsg;
    }

    public List<String> checkAreaEqual(List<Long> objIds) {
        List<String> validateMsg = new ArrayList<String>(16);
        Object[] dynamicObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(objIds.toArray());
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            DynamicObject dynamicObject = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(dynamicObjects[0].getLong("activity.id"));
            long ruleId = dynamicObject.getLong("assessform.id");
            DynamicObject ruleDy = this.queryAssessForm(ruleId);
            ScoreCalcWayEnum scoreCalcWay = ScoreCalcWayEnum.getScoreCalcWay((String)ruleDy.getString("scorecalcway"));
            String evaSumLimit = ruleDy.getString("evasumlimit");
            BigDecimal limitMaxRatioBD = new BigDecimal(100);
            if (ruleDy.getBigDecimal("limitmaxratio") != null) {
                limitMaxRatioBD = ruleDy.getBigDecimal("limitmaxratio");
            }
            if (!ObjectUtils.isEmpty((Object)scoreCalcWay)) {
                if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.SUM)) {
                    validateMsg = this.checkSumAreaEqual((DynamicObject[])dynamicObjects, ruleDy.getDynamicObject("scoresystem"));
                } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT) && EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit)) {
                    validateMsg = this.checkOutWeightEqual((DynamicObject[])dynamicObjects, limitMaxRatioBD);
                } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT)) {
                    validateMsg = this.checkWeightEqual((DynamicObject[])dynamicObjects);
                }
            }
        }
        return validateMsg;
    }

    public List<String> checkSurpassSubmitIndicator(List<Long> objIds) {
        List<String> validateMsg = new ArrayList<String>(16);
        Object[] dynamicObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(objIds.toArray());
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            ScoreCalcWayEnum scoreCalcWay;
            DynamicObject dynamicObject = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(dynamicObjects[0].getLong("activity.id"));
            long ruleId = dynamicObject.getLong("assessform.id");
            DynamicObject ruleDy = this.queryAssessForm(ruleId);
            String evaSumLimit = ruleDy.getString("evasumlimit");
            BigDecimal limitMaxRatioBD = new BigDecimal(100);
            if (ruleDy.getBigDecimal("limitmaxratio") != null) {
                limitMaxRatioBD = ruleDy.getBigDecimal("limitmaxratio");
            }
            if (!ObjectUtils.isEmpty((Object)(scoreCalcWay = ScoreCalcWayEnum.getScoreCalcWay((String)ruleDy.getString("scorecalcway"))))) {
                if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.SUM)) {
                    validateMsg = this.checkSurpassSumSubmitIndicator((DynamicObject[])dynamicObjects, ruleDy.getDynamicObject("scoresystem"), false);
                } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT) && EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit)) {
                    validateMsg = this.checkSurpassOutWeightSubmitIndicator((DynamicObject[])dynamicObjects, false, limitMaxRatioBD);
                } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT)) {
                    validateMsg = this.checkSurpassWeightSubmitIndicator((DynamicObject[])dynamicObjects, false);
                }
            }
        }
        return validateMsg;
    }

    public void finishIndicator(List<Long> objIds) {
        LOG.info("finishIndicator : {}", objIds);
        Object[] dynamicObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(objIds.toArray());
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        DynamicObject activityDy = dynamicObjects[0].getDynamicObject("activity");
        DynamicObject schemeDy = ASSESS_SCHEME_APPLICATION_SERVICE.queryOneById(activityDy.getLong("scheme.id"));
        DynamicObject executeScheme = EXECUTE_SCHEME_ENTITY_SERVICE.queryOne(activityDy.getLong("executescheme.id"));
        String settingMode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(executeScheme.getLong("perfworkflow.id")), "4");
        ArrayList<FlowRuProcBo> evalFlowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
        DynamicObjectCollection flowEntryColl = this.getPerfWorkFlowEntryColl(activityDy);
        Map<String, Long> defaultWorkFlow = this.getDefaultWorkFlowMap(flowEntryColl);
        Long evaluatorWorkFlowId = defaultWorkFlow.get("2");
        for (Object dynamicObject : dynamicObjects) {
            Date date = new Date();
            int nodeIndex = dynamicObject.getInt("nodeindex");
            long userId = UserServiceHelper.getCurrentUserId();
            LOG.info("preCreateProcessInstance : {}", (Object)dynamicObject.getLong("id"));
            FlowRuProcBo flowRuProcBo = this.buildEvaluationProcBo((DynamicObject)dynamicObject, schemeDy, settingMode, evaluatorWorkFlowId);
            evalFlowRuProcBoList.add(flowRuProcBo);
            LOG.info("before updateEvalObj : {}", (Object)dynamicObject.getLong("id"));
            this.updateEvalObj(date, userId, (DynamicObject)dynamicObject);
            LOG.info("after updateEvalObj : {}", (Object)dynamicObject.getLong("id"));
            LOG.info("before addActivityRecord : {}", (Object)dynamicObject.getLong("id"));
            this.addActivityRecord(nodeIndex, (DynamicObject)dynamicObject, date, userId);
            LOG.info("after addActivityRecord : {}", (Object)dynamicObject.getLong("id"));
        }
        if (!ObjectUtils.isEmpty(evalFlowRuProcBoList)) {
            CommonResultBo evaResultBo = FLOW_RU_PROC_BATCH_DOMAIN_SERVICE.preCreateProcessInstanceNoTx(evalFlowRuProcBoList, null);
            Map evaResMap = evaResultBo.getResultMap();
            Arrays.stream(dynamicObjects).forEach(evalObj -> {
                evalObj.set("evalflowins", evaResMap.get(evalObj.getLong("id")));
                evalObj.set("evalflow", (Object)evaluatorWorkFlowId);
            });
        }
        LOG.info("saveEvaluationObject : {}", objIds);
        this.saveEvaluationObject((DynamicObject[])dynamicObjects);
        this.saveObjCrossIndicator((DynamicObject[])dynamicObjects);
        this.saveImportScoreInd((DynamicObject[])dynamicObjects);
    }

    private FlowRuProcBo buildEvaluationProcBo(DynamicObject evaluationObj, DynamicObject schemeDy, String settingMode, Long evaluatorWorkFlowId) {
        DynamicObject person = evaluationObj.getDynamicObject("person");
        Integer assessYear = evaluationObj.getInt("assessyear");
        String assessPeriod = evaluationObj.getString("assessperiod");
        long actEvalObjId = evaluationObj.getLong("id");
        long perfOrgId = schemeDy.getLong("createorg.id");
        long adminOrgId = schemeDy.getLong("adminorg.id");
        long activityId = evaluationObj.getLong("activity.id");
        long empPosRelId = evaluationObj.getLong("empposrel.id");
        return FlowRuProcBo.builder().flowVid(evaluatorWorkFlowId).person(person).perfOrgId(Long.valueOf(perfOrgId)).adminOrgId(Long.valueOf(adminOrgId)).assessYear(assessYear).assessPeriod(assessPeriod).actEvalObjId(Long.valueOf(actEvalObjId)).activityId(Long.valueOf(activityId)).empPosRelId(Long.valueOf(empPosRelId)).settingMode(settingMode).workflowType("2").build();
    }

    private void updateEvalObj(Date date, long userId, DynamicObject evaluationObj) {
        LOG.info(" ----------\u3010\u53d8\u66f4\u8bc4\u4f30\u5bf9\u8c61\u3011ASSESSNODE:{},NODESTATUS:{}----------", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId(), (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus());
        evaluationObj.set("modifier", (Object)userId);
        evaluationObj.set("modifytime", (Object)date);
        evaluationObj.set("assessnode", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId());
        evaluationObj.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus());
        evaluationObj.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
    }

    private DynamicObject addActivityRecord(int nodeIndex, DynamicObject evaluationObj, Date date, long userId) {
        LOG.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5f00\u59cb----------");
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId());
        activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus());
        activityRecord.set("nodeindex", (Object)nodeIndex);
        activityRecord.set("endtime", (Object)date);
        activityRecord.set("starttype", (Object)"20");
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        activityRecord.set("activity", (Object)evaluationObj.getLong("activity.id"));
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("creator", (Object)userId);
        activityRecord.set("createtime", (Object)date);
        activityRecord.set("modifier", (Object)userId);
        activityRecord.set("modifytime", (Object)date);
        ACTIVITY_RECORD_ENTITY.saveOne(activityRecord);
        LOG.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5b8c\u6210----------");
        return activityRecord;
    }

    private DynamicObject getActivityRecord(int nodeIndex, DynamicObject evaluationObj, Date date, long userId) {
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
        activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus());
        activityRecord.set("nodeindex", (Object)nodeIndex);
        activityRecord.set("endtime", (Object)date);
        activityRecord.set("starttype", (Object)"20");
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        activityRecord.set("activity", (Object)evaluationObj.getLong("activity.id"));
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("creator", (Object)userId);
        activityRecord.set("createtime", (Object)date);
        activityRecord.set("modifier", (Object)userId);
        activityRecord.set("modifytime", (Object)date);
        return activityRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long preCreateProcessInstance(DynamicObject evalObj) {
        try (TXHandle txhandle = TX.required();){
            boolean deleteFlag = FLOW_RUSECOND_DOMAIN_SERVICE.deleteRunProc(Collections.singletonList(evalObj.getLong("id")));
            if (!deleteFlag) {
                Long l = null;
                return l;
            }
            FlowRuProcBo flowRuProcBo = this.buildEvaluationProcBo(evalObj);
            List ruProcIds = FLOW_RU_PROC_DOMAIN_SERVICE.preCreateProcessInstance(flowRuProcBo);
            if (!CollectionUtils.isEmpty((Collection)ruProcIds)) {
                Long l = (Long)ruProcIds.get(0);
                return l;
            }
        }
        return null;
    }

    public boolean checkMustInput(Long objId, DynamicObject[] evalDynamicObjects, Map<String, List<String>> indicatorMustInputMap, Long currentNode, Long typeId, boolean isCanEdit) {
        Object[] dynamicObjects = (DynamicObject[])Arrays.stream(evalDynamicObjects).filter(dyc -> HRObjectUtils.equals((Object)dyc.getLong("id"), (Object)objId)).toArray(DynamicObject[]::new);
        boolean mustInput = false;
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObjects) && !HRObjectUtils.isEmpty(indicatorMustInputMap)) {
            for (Object evaluationObj : dynamicObjects) {
                DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
                mustInput = this.checkEntryMustInput(areaEntry, indicatorMustInputMap, currentNode, typeId, isCanEdit);
            }
        }
        return mustInput;
    }

    private boolean checkEntryMustInput(DynamicObjectCollection areaEntry, Map<String, List<String>> indicatorMustInputMap, Long currentNode, Long typeId, boolean isCanEdit) {
        boolean checkMustInput = false;
        for (DynamicObject areaInfo : areaEntry) {
            if (!this.isNull(indicatorMustInputMap, areaInfo, currentNode, typeId, isCanEdit)) continue;
            checkMustInput = true;
            break;
        }
        return checkMustInput;
    }

    private boolean isNull(Map<String, List<String>> indicatorMustInputMap, DynamicObject areaInfo, Long currentNode, Long typeId, boolean isCanEdit) {
        long areaReg = areaInfo.getLong("areareg.id");
        long instanceId = areaInfo.getLong("areains");
        long areaConf = areaInfo.getLong("areaconf");
        String cacheKey = "indicatorMustInput_" + areaReg + "_" + areaConf;
        List<String> mustInputField = indicatorMustInputMap.get(cacheKey);
        if (mustInputField != null && mustInputField.size() > 0) {
            return this.valueCheck(areaReg, instanceId, mustInputField, currentNode, typeId, isCanEdit);
        }
        return false;
    }

    private boolean valueCheck(long areaReg, long instanceId, List<String> mustInputField, Long currentNode, Long typeId, boolean isCanEdit) {
        DynamicObject[] areaInsDys;
        OpmcEntityService areaInsEntity;
        String fields = String.join((CharSequence)",", mustInputField) + ",flowrunode,ispreinstall";
        if (HRObjectUtils.equals((Object)areaReg, (Object)AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId())) {
            areaInsEntity = ObjGenAreaIndAssignEntityService.getInstance();
            fields = fields + ",iseditable";
        } else if (HRObjectUtils.equals((Object)areaReg, (Object)AreaRegEnum.PLUS_MINUS_AREA.getAreaPkId())) {
            areaInsEntity = ObjAddSubAreaIndAssignEntityService.getInstance();
            fields = fields + ",iseditable";
        } else {
            areaInsEntity = ObjAttachAreaIndAssignEntityService.getInstance();
        }
        QFilter qFilter = new QFilter("instanceid", "in", (Object)instanceId);
        for (DynamicObject areaInsDy : areaInsDys = areaInsEntity.query(fields, new QFilter[]{qFilter})) {
            long flowRuNode = areaInsDy.getLong("flowrunode");
            boolean isPreinstall = areaInsDy.getBoolean("ispreinstall");
            if (typeId.equals(NodeTypeConstants.INDICATOR_FORMULATE)) {
                if ((HRObjectUtils.equals((Object)areaReg, (Object)AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId()) || HRObjectUtils.equals((Object)areaReg, (Object)AreaRegEnum.PLUS_MINUS_AREA.getAreaPkId())) && isPreinstall && !areaInsDy.getBoolean("iseditable") || HRObjectUtils.equals((Object)areaReg, (Object)AreaRegEnum.ATTACH_AREA.getAreaPkId()) && isPreinstall || flowRuNode != 0L && flowRuNode != currentNode) continue;
                if (HRObjectUtils.equals((Object)areaReg, (Object)AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId()) || HRObjectUtils.equals((Object)areaReg, (Object)AreaRegEnum.PLUS_MINUS_AREA.getAreaPkId())) {
                    boolean isEdiTable = areaInsDy.getBoolean("iseditable");
                    Long flowRuNodeId = areaInsDy.getLong("flowrunode");
                    if (HRObjectUtils.equals((Object)0L, (Object)flowRuNodeId) && !isEdiTable) continue;
                }
            }
            if (typeId.equals(NodeTypeConstants.INDICATOR_AUDIT) && !isCanEdit || typeId.equals(NodeTypeConstants.INDICATOR_CONFIRM)) continue;
            for (String field : mustInputField) {
                if (!HRObjectUtils.isEmpty((Object)areaInsDy.get(field))) continue;
                return true;
            }
        }
        return false;
    }

    private FlowRuProcBo buildEvaluationProcBo(DynamicObject evaluationObj) {
        long flowVid = evaluationObj.getLong("evalflow.id");
        DynamicObject person = evaluationObj.getDynamicObject("person");
        Integer assessYear = evaluationObj.getInt("assessyear");
        String assessPeriod = evaluationObj.getString("assessperiod");
        long actEvalObjId = evaluationObj.getLong("id");
        DynamicObject activityDy = evaluationObj.getDynamicObject("activity");
        DynamicObject schemeDy = ASSESS_SCHEME_APPLICATION_SERVICE.queryOneById(activityDy.getLong("scheme.id"));
        long perfOrgId = schemeDy.getLong("createorg.id");
        long adminOrgId = schemeDy.getLong("adminorg.id");
        long activityId = evaluationObj.getLong("activity.id");
        long empPosRelId = evaluationObj.getLong("empposrel.id");
        DynamicObject executeScheme = EXECUTE_SCHEME_ENTITY_SERVICE.queryOne(activityDy.getLong("executescheme.id"));
        String settingMode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(executeScheme.getLong("perfworkflow.id")), "1");
        return FlowRuProcBo.builder().flowVid(Long.valueOf(flowVid)).person(person).perfOrgId(Long.valueOf(perfOrgId)).adminOrgId(Long.valueOf(adminOrgId)).assessYear(assessYear).assessPeriod(assessPeriod).actEvalObjId(Long.valueOf(actEvalObjId)).activityId(Long.valueOf(activityId)).empPosRelId(Long.valueOf(empPosRelId)).settingMode(settingMode).workflowType("2").build();
    }

    private List<String> checkSumAreaEqual(DynamicObject[] dynamicObjects, DynamicObject scoreSystem) {
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(dynamicObjects);
        List<String> validateMsg = new ArrayList<String>(16);
        for (DynamicObject evaluationObj : dynamicObjects) {
            validateMsg = this.validateSumEvalObjEqual(evaluationObj, scoreSystem, areaInstanceMap);
        }
        return validateMsg;
    }

    private BigDecimal checkAreaScore(Map<Long, DynamicObject> areaInstanceMap, DynamicObjectCollection areaEntry, DynamicObject scoreSystemDy) {
        BigDecimal sumAreaScore = new BigDecimal(0);
        BigDecimal zeroScore = new BigDecimal(0);
        boolean isModify = true;
        for (DynamicObject areaInfo : areaEntry) {
            long areaReg = areaInfo.getLong("areareg.id");
            if (!AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaReg)) continue;
            long areaInstId = areaInfo.getLong("areains");
            DynamicObject areaInst = areaInstanceMap.get(areaInstId);
            BigDecimal areaScore = areaInst.getBigDecimal("areascore");
            sumAreaScore = sumAreaScore.add(areaScore);
            if (zeroScore.compareTo(areaScore) != 0) continue;
            isModify = false;
        }
        if (isModify) {
            return sumAreaScore;
        }
        return scoreSystemDy.getBigDecimal("maxscore");
    }

    public List<String> validateSumEvalObjEqual(DynamicObject evaluationObj, DynamicObject scoreSystemDy, Map<Long, DynamicObject> areaInstanceMap) {
        ArrayList<String> msgList = new ArrayList<String>(10);
        DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
        BigDecimal sumAreaScore = this.checkAreaScore(areaInstanceMap, areaEntry, scoreSystemDy);
        BigDecimal maxScoreOfSystem = scoreSystemDy.getBigDecimal("maxscore");
        if (maxScoreOfSystem.compareTo(sumAreaScore) != 0) {
            msgList.add(ResManager.loadKDString((String)"{0} {1}:\u533a\u57df\u5408\u8ba1\u5206\u503c\u9700=\u57fa\u51c6\u6700\u9ad8\u5206", (String)"ActivityEvaluationObjectDomainService_50", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number")}));
        }
        return msgList;
    }

    private List<String> checkSumSubmitIndicator(DynamicObject[] dynamicObjects, DynamicObject scoreSystem, boolean isEqual) {
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(dynamicObjects);
        Map<Long, Long> areaConfMap = this.queryEvaluationGenAreaConfId(dynamicObjects);
        List<String> validateMsg = new ArrayList<String>(16);
        for (DynamicObject evaluationObj : dynamicObjects) {
            validateMsg = this.validateSumEvalObj(evaluationObj, scoreSystem, areaInstanceMap, areaConfMap, isEqual, false);
        }
        return validateMsg;
    }

    private List<String> checkSurpassSumSubmitIndicator(DynamicObject[] dynamicObjects, DynamicObject scoreSystem, boolean isEqual) {
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(dynamicObjects);
        Map<Long, Long> areaConfMap = this.queryEvaluationGenAreaConfId(dynamicObjects);
        List<String> validateMsg = new ArrayList<String>(16);
        for (DynamicObject evaluationObj : dynamicObjects) {
            validateMsg = this.validateSumEvalObj(evaluationObj, scoreSystem, areaInstanceMap, areaConfMap, isEqual, true);
        }
        return validateMsg;
    }

    private List<String> checkWeightSubmitIndicator(DynamicObject[] dynamicObjects, boolean isEqual) {
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(dynamicObjects);
        Map<Long, Long> areaConfMap = this.queryEvaluationGenAreaConfId(dynamicObjects);
        List<String> validateMsg = new ArrayList<String>(16);
        for (DynamicObject evaluationObj : dynamicObjects) {
            validateMsg = this.validateWeightEvalObj(evaluationObj, areaInstanceMap, areaConfMap, isEqual, false);
        }
        return validateMsg;
    }

    private List<String> checkOutWeightSubmitIndicator(DynamicObject[] dynamicObjects, boolean isEqual, BigDecimal limitMaxRatio) {
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(dynamicObjects);
        Map<Long, Long> areaConfMap = this.queryEvaluationGenAreaConfId(dynamicObjects);
        List<String> validateMsg = new ArrayList<String>(16);
        for (DynamicObject evaluationObj : dynamicObjects) {
            validateMsg = this.validateOutWeightEvalObj(evaluationObj, areaInstanceMap, areaConfMap, isEqual, false, limitMaxRatio);
        }
        return validateMsg;
    }

    private List<String> checkSurpassWeightSubmitIndicator(DynamicObject[] dynamicObjects, boolean isEqual) {
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(dynamicObjects);
        Map<Long, Long> areaConfMap = this.queryEvaluationGenAreaConfId(dynamicObjects);
        List<String> validateMsg = new ArrayList<String>(16);
        for (DynamicObject evaluationObj : dynamicObjects) {
            validateMsg = this.validateWeightEvalObj(evaluationObj, areaInstanceMap, areaConfMap, isEqual, true);
        }
        return validateMsg;
    }

    private List<String> checkSurpassOutWeightSubmitIndicator(DynamicObject[] dynamicObjects, boolean isEqual, BigDecimal limitMaxRatio) {
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(dynamicObjects);
        Map<Long, Long> areaConfMap = this.queryEvaluationGenAreaConfId(dynamicObjects);
        List<String> validateMsg = new ArrayList<String>(16);
        for (DynamicObject evaluationObj : dynamicObjects) {
            validateMsg = this.validateOutWeightEvalObj(evaluationObj, areaInstanceMap, areaConfMap, isEqual, true, limitMaxRatio);
        }
        return validateMsg;
    }

    private List<String> checkWeightEqual(DynamicObject[] dynamicObjects) {
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(dynamicObjects);
        List<String> validateMsg = new ArrayList<String>(16);
        for (DynamicObject evaluationObj : dynamicObjects) {
            validateMsg = this.validateWeightEvalObjEqual(evaluationObj, areaInstanceMap);
        }
        return validateMsg;
    }

    private List<String> checkOutWeightEqual(DynamicObject[] dynamicObjects, BigDecimal limitMaxRatio) {
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(dynamicObjects);
        List<String> validateMsg = new ArrayList<String>(16);
        for (DynamicObject evaluationObj : dynamicObjects) {
            validateMsg = this.validateOutWeightEvalObjEqual(evaluationObj, areaInstanceMap, limitMaxRatio);
        }
        return validateMsg;
    }

    public List<String> validateWeightEvalObjEqual(DynamicObject evaluationObj, Map<Long, DynamicObject> areaInstanceMap) {
        ArrayList<String> msgList = new ArrayList<String>(10);
        DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
        BigDecimal sumAreaScore = this.checkAreaWeightScoreEqual(areaInstanceMap, areaEntry);
        BigDecimal bigDecimal = BigDecimal.valueOf(100L);
        if (bigDecimal.compareTo(sumAreaScore) != 0) {
            msgList.add(ResManager.loadKDString((String)"%1$s %1$s:\u533a\u57df\u5408\u8ba1\u6743\u91cd\u7d2f\u8ba1\u9700=100%\u3002", (String)"ActivityEvaluationObjectDomainService_2", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number")}));
        }
        return msgList;
    }

    public List<String> validateOutWeightEvalObjEqual(DynamicObject evaluationObj, Map<Long, DynamicObject> areaInstanceMap, BigDecimal limitMaxRatio) {
        ArrayList<String> msgList = new ArrayList<String>(10);
        DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
        BigDecimal sumAreaScore = this.checkAreaWeightScoreEqual(areaInstanceMap, areaEntry);
        BigDecimal bigDecimal = BigDecimal.valueOf(100L);
        if (bigDecimal.compareTo(sumAreaScore) > 0 || limitMaxRatio.compareTo(sumAreaScore) < 0) {
            msgList.add(ResManager.loadKDString((String)"{0} {1}:\u201c\u533a\u57df\u7d2f\u8ba1\u6743\u91cd\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u8bc4\u4f30\u8868\u5355\u6307\u5b9a\u6743\u91cd\u9650\u5236\u6700\u9ad8\u6bd4\u4f8b\u201d\uff1a{2}%\uff0c\u5927\u4e8e\u7b49\u4e8e100%\u3002", (String)"ActivityEvaluationObjectDomainService_52", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number"), limitMaxRatio}));
        }
        return msgList;
    }

    private BigDecimal checkAreaWeightScoreEqual(Map<Long, DynamicObject> areaInstanceMap, DynamicObjectCollection areaEntry) {
        BigDecimal sumAreaWeight = new BigDecimal(0);
        BigDecimal zero = new BigDecimal(0);
        BigDecimal oneHundred = new BigDecimal(100);
        boolean isModify = true;
        for (DynamicObject areaInfo : areaEntry) {
            long areaInstId;
            DynamicObject areaInst;
            long areaReg = areaInfo.getLong("areareg.id");
            if (!AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaReg) || HRObjectUtils.isEmpty((Object)(areaInst = areaInstanceMap.get(areaInstId = areaInfo.getLong("areains"))))) continue;
            BigDecimal areaWeight = areaInst.getBigDecimal("areaweight");
            sumAreaWeight = sumAreaWeight.add(areaWeight);
            if (zero.compareTo(areaWeight) != 0) continue;
            isModify = false;
        }
        if (isModify) {
            return sumAreaWeight;
        }
        return oneHundred;
    }

    public List<String> validateSumEvalObj(DynamicObject evaluationObj, DynamicObject scoreSystemDy, Map<Long, DynamicObject> areaInstanceMap, Map<Long, Long> areaConfMap, boolean isEqual, boolean isSurPass) {
        ArrayList<String> msgList = new ArrayList<String>(10);
        DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
        BigDecimal sumAreaScore = this.checkAndAddAreaScore(evaluationObj, areaInstanceMap, areaConfMap, msgList, areaEntry, isEqual);
        BigDecimal maxScoreOfSystem = scoreSystemDy.getBigDecimal("maxscore");
        if (isEqual) {
            if (maxScoreOfSystem.compareTo(sumAreaScore) != 0) {
                msgList.add(ResManager.loadKDString((String)"{0} {1}: \u533a\u57df\u5408\u8ba1\u5206\u503c\u9700=\u57fa\u51c6\u6700\u9ad8\u5206\u3002", (String)"ActivityEvaluationObjectDomainService_53", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number")}));
            }
        } else if (maxScoreOfSystem.compareTo(sumAreaScore) < 0) {
            msgList.add(ResManager.loadKDString((String)"{0} {1}: \u533a\u57df\u5408\u8ba1\u5206\u503c\u9700\u2264\u57fa\u51c6\u6700\u9ad8\u5206\u3002", (String)"ActivityEvaluationObjectDomainService_54", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number")}));
        }
        return msgList;
    }

    public List<String> validateWeightEvalObj(DynamicObject evaluationObj, Map<Long, DynamicObject> areaInstanceMap, Map<Long, Long> areaConfMap, boolean isEqual, boolean isSurpass) {
        ArrayList<String> msgList = new ArrayList<String>(10);
        DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
        BigDecimal sumAreaScore = this.checkAreaWeightScore(evaluationObj, areaInstanceMap, areaConfMap, msgList, areaEntry, isEqual);
        BigDecimal bigDecimal = BigDecimal.valueOf(100L);
        if (isEqual) {
            if (bigDecimal.compareTo(sumAreaScore) != 0) {
                if (!isSurpass) {
                    msgList.add(ResManager.loadKDString((String)"{0} {1}:\u533a\u57df\u5408\u8ba1\u6743\u91cd\u9700=100%\u3002", (String)"ActivityEvaluationObjectDomainService_55", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number")}));
                } else {
                    msgList.add(ResManager.loadKDString((String)"{0} {1}:\u533a\u57df\u6743\u91cd\u5168\u90e8\u5927\u4e8e0\u65f6\uff0c\u533a\u57df\u5408\u8ba1\u6743\u91cd\u9700=100%\u3002", (String)"ActivityEvaluationObjectDomainService_56", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number")}));
                }
            }
        } else if (bigDecimal.compareTo(sumAreaScore) < 0) {
            msgList.add(ResManager.loadKDString((String)"{0} {1}:\u533a\u57df\u5408\u8ba1\u6743\u91cd\u9700\u2264100%\u3002", (String)"ActivityEvaluationObjectDomainService_57", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number")}));
        }
        return msgList;
    }

    public List<String> validateOutWeightEvalObj(DynamicObject evaluationObj, Map<Long, DynamicObject> areaInstanceMap, Map<Long, Long> areaConfMap, boolean isEqual, boolean isSurpass, BigDecimal limitMaxRatio) {
        ArrayList<String> msgList = new ArrayList<String>(10);
        DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
        BigDecimal sumAreaScore = this.checkAreaWeightScore(evaluationObj, areaInstanceMap, areaConfMap, msgList, areaEntry, isEqual);
        BigDecimal bigDecimal = BigDecimal.valueOf(100L);
        if (isEqual) {
            if (bigDecimal.compareTo(sumAreaScore) > 0 || limitMaxRatio.compareTo(sumAreaScore) < 0) {
                if (!isSurpass) {
                    msgList.add(ResManager.loadKDString((String)"{0} {1}:\u201c\u533a\u57df\u7d2f\u8ba1\u6743\u91cd\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u8bc4\u4f30\u8868\u5355\u6307\u5b9a\u6743\u91cd\u9650\u5236\u6700\u9ad8\u6bd4\u4f8b\u201d\uff1a{2}%\uff0c\u5927\u4e8e\u7b49\u4e8e100%\u3002", (String)"ActivityEvaluationObjectDomainService_52", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number"), limitMaxRatio}));
                } else {
                    msgList.add(ResManager.loadKDString((String)"{0} {1}:\u533a\u57df\u6743\u91cd\u5168\u90e8\u5927\u4e8e0\u65f6\uff0c\u201c\u533a\u57df\u7d2f\u8ba1\u6743\u91cd\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u8bc4\u4f30\u8868\u5355\u6307\u5b9a\u6743\u91cd\u9650\u5236\u6700\u9ad8\u6bd4\u4f8b\u201d\uff1a{2}%\uff0c\u5927\u4e8e\u7b49\u4e8e100%\u3002", (String)"ActivityEvaluationObjectDomainService_58", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number"), limitMaxRatio}));
                }
            }
        } else if (limitMaxRatio.compareTo(sumAreaScore) < 0) {
            msgList.add(ResManager.loadKDString((String)"{0} {1}:\u201c\u533a\u57df\u7d2f\u8ba1\u6743\u91cd\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u8bc4\u4f30\u8868\u5355\u6307\u5b9a\u6743\u91cd\u9650\u5236\u6700\u9ad8\u6bd4\u4f8b\u201d\uff1a{2}%\u3002", (String)"ActivityEvaluationObjectDomainService_59", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number"), limitMaxRatio}));
        }
        return msgList;
    }

    public Map<Long, Long> queryEvaluationGenAreaConfId(DynamicObject[] evaluationObjList) {
        HashMap<Long, Long> allInsOfConfMap = new HashMap<Long, Long>(16);
        for (DynamicObject evaluationObj : evaluationObjList) {
            DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
            for (DynamicObject areaInfo : areaEntry) {
                long areaReg = areaInfo.getLong("areareg.id");
                if (!AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaReg)) continue;
                allInsOfConfMap.put(areaInfo.getLong("areains"), areaInfo.getLong("areaconf"));
            }
        }
        return allInsOfConfMap;
    }

    public Map<Long, DynamicObject> queryEvaluationAreaInstance(DynamicObject[] evaluationObjList) {
        HashMap<Long, ArrayList<Long>> areaInstanceIdOfRegMap = new HashMap<Long, ArrayList<Long>>(16);
        for (DynamicObject evaluationObj : evaluationObjList) {
            DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
            for (DynamicObject areaInfo : areaEntry) {
                long areaReg = areaInfo.getLong("areareg.id");
                ArrayList<Long> areaInstanceIds = (ArrayList<Long>)areaInstanceIdOfRegMap.get(areaReg);
                if (ObjectUtils.isEmpty((Object)areaInstanceIds)) {
                    areaInstanceIds = new ArrayList<Long>(evaluationObjList.length * 2);
                }
                areaInstanceIds.add(areaInfo.getLong("areains"));
                areaInstanceIdOfRegMap.put(areaReg, areaInstanceIds);
            }
        }
        HashMap<Long, DynamicObject> allAreaInsMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry areaInsInfoOfReg : areaInstanceIdOfRegMap.entrySet()) {
            Long areaReg = (Long)areaInsInfoOfReg.getKey();
            Long[] areaInsIds = ((List)areaInsInfoOfReg.getValue()).toArray(new Long[0]);
            OpmcEntityService areaInsEntity = AREA_INS_ENTITY_MAP.get(areaReg);
            if (!AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaReg)) continue;
            QFilter qFilter = new QFilter("id", "in", (Object)areaInsIds);
            DynamicObject[] areaInsDys = areaInsEntity.query("id,entryentity,entryentity.indctrscore,entryentity.weight,entryentity.addnodeindex,entryentity.indctrname,areascore,indreqentity,indreqentity.indicatortype,indreqentity.score,indreqentity.scoretype,areaweight,areaactevalobj", new QFilter[]{qFilter});
            Map areaInsMap = Arrays.stream(areaInsDys).collect(Collectors.toMap(areaInsDy -> areaInsDy.getLong("id"), Function.identity()));
            allAreaInsMap.putAll(areaInsMap);
        }
        return allAreaInsMap;
    }

    private void deletePreinstallIndicator(DynamicObject[] evaluationObjList) {
        HashMap<Long, ArrayList<Long>> areaInstanceIdOfRegMap = new HashMap<Long, ArrayList<Long>>(16);
        for (DynamicObject evaluationObj : evaluationObjList) {
            DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
            for (DynamicObject areaInfo : areaEntry) {
                long areaReg = areaInfo.getLong("areareg.id");
                ArrayList<Long> areaInstanceIds = (ArrayList<Long>)areaInstanceIdOfRegMap.get(areaReg);
                if (ObjectUtils.isEmpty((Object)areaInstanceIds)) {
                    areaInstanceIds = new ArrayList<Long>(evaluationObjList.length * 2);
                }
                areaInstanceIds.add(areaInfo.getLong("areains"));
                areaInstanceIdOfRegMap.put(areaReg, areaInstanceIds);
            }
        }
        for (Map.Entry entry : areaInstanceIdOfRegMap.entrySet()) {
            DynamicObject[] areaInsDys;
            Long areaReg = (Long)entry.getKey();
            Long[] areaInsIds = ((List)entry.getValue()).toArray(new Long[0]);
            OpmcEntityService areaInsEntity = AREA_INS_ENTITY_MAP.get(areaReg);
            QFilter qFilter = new QFilter("id", "in", (Object)areaInsIds);
            for (DynamicObject areaInsDy : areaInsDys = areaInsEntity.query("id,entryentity,entryentity.ispreinstall,areafrom", new QFilter[]{qFilter})) {
                areaInsDy.set("areafrom", (Object)0L);
                DynamicObjectCollection entryentity = areaInsDy.getDynamicObjectCollection("entryentity");
                entryentity.removeIf(next -> next.getBoolean("ispreinstall"));
            }
            areaInsEntity.save(areaInsDys);
        }
    }

    public Map<Long, DynamicObject> queryEvaluationAddsubAreaInstance(DynamicObject[] evaluationObjList) {
        HashMap<Long, ArrayList<Long>> areaInstanceIdOfRegMap = new HashMap<Long, ArrayList<Long>>(16);
        for (DynamicObject evaluationObj : evaluationObjList) {
            DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
            for (DynamicObject areaInfo : areaEntry) {
                long areaReg = areaInfo.getLong("areareg.id");
                ArrayList<Long> areaInstanceIds = (ArrayList<Long>)areaInstanceIdOfRegMap.get(areaReg);
                if (ObjectUtils.isEmpty((Object)areaInstanceIds)) {
                    areaInstanceIds = new ArrayList<Long>(evaluationObjList.length * 2);
                }
                areaInstanceIds.add(areaInfo.getLong("areains"));
                areaInstanceIdOfRegMap.put(areaReg, areaInstanceIds);
            }
        }
        HashMap<Long, DynamicObject> allAreaInsMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry areaInsInfoOfReg : areaInstanceIdOfRegMap.entrySet()) {
            Long areaReg = (Long)areaInsInfoOfReg.getKey();
            Long[] areaInsIds = ((List)areaInsInfoOfReg.getValue()).toArray(new Long[0]);
            OpmcEntityService areaInsEntity = AREA_INS_ENTITY_MAP.get(areaReg);
            if (!AreaRegEnum.PLUS_MINUS_AREA.getAreaPkId().equals(areaReg)) continue;
            QFilter qFilter = new QFilter("id", "in", (Object)areaInsIds);
            DynamicObject[] areaInsDys = areaInsEntity.query("id,entryentity,entryentity.addnodeindex,entryentity.indctrname,areaactevalobj", new QFilter[]{qFilter});
            Map areaInsMap = Arrays.stream(areaInsDys).collect(Collectors.toMap(areaInsDy -> areaInsDy.getLong("id"), Function.identity()));
            allAreaInsMap.putAll(areaInsMap);
        }
        return allAreaInsMap;
    }

    public Map<Long, DynamicObject> queryEvaluationAttachAreaInstance(DynamicObject[] evaluationObjList) {
        HashMap<Long, ArrayList<Long>> areaInstanceIdOfRegMap = new HashMap<Long, ArrayList<Long>>(16);
        for (DynamicObject evaluationObj : evaluationObjList) {
            DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
            for (DynamicObject areaInfo : areaEntry) {
                long areaReg = areaInfo.getLong("areareg.id");
                ArrayList<Long> areaInstanceIds = (ArrayList<Long>)areaInstanceIdOfRegMap.get(areaReg);
                if (ObjectUtils.isEmpty((Object)areaInstanceIds)) {
                    areaInstanceIds = new ArrayList<Long>(evaluationObjList.length * 2);
                }
                areaInstanceIds.add(areaInfo.getLong("areains"));
                areaInstanceIdOfRegMap.put(areaReg, areaInstanceIds);
            }
        }
        HashMap<Long, DynamicObject> allAreaInsMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry areaInsInfoOfReg : areaInstanceIdOfRegMap.entrySet()) {
            Long areaReg = (Long)areaInsInfoOfReg.getKey();
            Long[] areaInsIds = ((List)areaInsInfoOfReg.getValue()).toArray(new Long[0]);
            OpmcEntityService areaInsEntity = AREA_INS_ENTITY_MAP.get(areaReg);
            if (!AreaRegEnum.ATTACH_AREA.getAreaPkId().equals(areaReg)) continue;
            QFilter qFilter = new QFilter("id", "in", (Object)areaInsIds);
            DynamicObject[] areaInsDys = areaInsEntity.query("id,entryentity,entryentity.addnodeindex,entryentity.keyactname,areaactevalobj", new QFilter[]{qFilter});
            Map areaInsMap = Arrays.stream(areaInsDys).collect(Collectors.toMap(areaInsDy -> areaInsDy.getLong("id"), Function.identity()));
            allAreaInsMap.putAll(areaInsMap);
        }
        return allAreaInsMap;
    }

    public List<Long> checkNormalIndicatorNameInArea(List<Long> objIds, int currentIndex) {
        DynamicObject[] objArr = ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(objIds.toArray());
        Map<Long, DynamicObject> normalAreaIdDyMap = this.queryEvaluationAreaInstance(objArr);
        HashMap<Long, Map> areaIdNameCountMap = new HashMap<Long, Map>(16);
        normalAreaIdDyMap.forEach((areaId, area) -> {
            DynamicObjectCollection indicatorEntrys = area.getDynamicObjectCollection("entryentity");
            HashMap<String, Integer> nameCountMap = new HashMap<String, Integer>(16);
            for (DynamicObject entry : indicatorEntrys) {
                if (entry.getInt("addnodeindex") > currentIndex) continue;
                if (nameCountMap.get(entry.getString("indctrname")) == null) {
                    nameCountMap.put(entry.getString("indctrname"), 1);
                    continue;
                }
                nameCountMap.put(entry.getString("indctrname"), (Integer)nameCountMap.get(entry.getString("indctrname")) + 1);
            }
            areaIdNameCountMap.put((Long)areaId, nameCountMap);
        });
        LinkedList<Long> duId = new LinkedList<Long>();
        areaIdNameCountMap.forEach((areaId, nameCountMapI) -> {
            for (Map.Entry entry : nameCountMapI.entrySet()) {
                if (entry.getValue() == null || (Integer)entry.getValue() <= 1) continue;
                duId.add((Long)areaId);
                break;
            }
        });
        return duId;
    }

    public List<Long> checkAddSubIndicatorNameInArea(List<Long> objIds, int currentIndex) {
        DynamicObject[] objArr = ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(objIds.toArray());
        Map<Long, DynamicObject> addSubAreaIdDyMap = this.queryEvaluationAddsubAreaInstance(objArr);
        HashMap<Long, Map> areaIdNameCountMap = new HashMap<Long, Map>(16);
        addSubAreaIdDyMap.forEach((areaId, area) -> {
            HashMap<String, Integer> nameCountMap = new HashMap<String, Integer>(16);
            DynamicObjectCollection indicatorEntrys = area.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : indicatorEntrys) {
                if (entry.getInt("addnodeindex") > currentIndex) continue;
                if (nameCountMap.get(entry.getString("indctrname")) == null) {
                    nameCountMap.put(entry.getString("indctrname"), 1);
                    continue;
                }
                nameCountMap.put(entry.getString("indctrname"), (Integer)nameCountMap.get(entry.getString("indctrname")) + 1);
            }
            areaIdNameCountMap.put((Long)areaId, nameCountMap);
        });
        LinkedList<Long> duId = new LinkedList<Long>();
        areaIdNameCountMap.forEach((areaId, nameCountMapI) -> {
            for (Map.Entry entry : nameCountMapI.entrySet()) {
                if (entry.getValue() == null || (Integer)entry.getValue() <= 1) continue;
                duId.add((Long)areaId);
                break;
            }
        });
        return duId;
    }

    public List<Long> checkAttachIndicatorNameInArea(List<Long> objIds, int currentIndex) {
        DynamicObject[] objArr = ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(objIds.toArray());
        Map<Long, DynamicObject> attachAreaIdDyMap = this.queryEvaluationAttachAreaInstance(objArr);
        HashMap<Long, Map> areaIdNameCountMap = new HashMap<Long, Map>(16);
        attachAreaIdDyMap.forEach((areaId, area) -> {
            HashMap<String, Integer> nameCountMap = new HashMap<String, Integer>(16);
            DynamicObjectCollection indicatorEntrys = area.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : indicatorEntrys) {
                if (entry.getInt("addnodeindex") > currentIndex) continue;
                if (nameCountMap.get(entry.getString("keyactname")) == null) {
                    nameCountMap.put(entry.getString("keyactname"), 1);
                    continue;
                }
                nameCountMap.put(entry.getString("keyactname"), (Integer)nameCountMap.get(entry.getString("keyactname")) + 1);
            }
            areaIdNameCountMap.put((Long)areaId, nameCountMap);
        });
        LinkedList<Long> duId = new LinkedList<Long>();
        areaIdNameCountMap.forEach((areaId, nameCountMapI) -> {
            for (Map.Entry entry : nameCountMapI.entrySet()) {
                if (entry.getValue() == null || (Integer)entry.getValue() <= 1) continue;
                duId.add((Long)areaId);
                break;
            }
        });
        return duId;
    }

    public String checkIndicatorNameInArea(List<Long> objIds, Long attachAreaConfId, int currentIndex) {
        List<Long> normalId = this.checkNormalIndicatorNameInArea(objIds, currentIndex);
        List<Long> addSubId = this.checkAddSubIndicatorNameInArea(objIds, currentIndex);
        List<Long> attachId = this.checkAttachIndicatorNameInArea(objIds, currentIndex);
        DynamicObject[] genAreaIns = OBJ_GEN_AREA_INS_ENTITY.queryAreaConfById(normalId);
        DynamicObject[] addSubAreaIns = OBJ_ADD_SUB_AREA_INS_ENTITY.queryAreaConfById(addSubId);
        List<Long> normalConfIds = Arrays.asList(genAreaIns).stream().map(ins -> ins.getLong("areaconf.id")).collect(Collectors.toList());
        List<Long> addSubConfIds = Arrays.asList(addSubAreaIns).stream().map(ins -> ins.getLong("areaconf.id")).collect(Collectors.toList());
        DynamicObject attachConf = ATTACH_CONFIG_ENTITY_SERVICE.queryConfNameByPk(attachAreaConfId);
        DynamicObject[] normalConfs = NORMAL_CONFIG_ENTITY_SERVICE.queryConfNameByPks(normalConfIds);
        DynamicObject[] pMConfs = PLUS_MINUS_CONFIG_ENTITY_SERVICE.queryConfNameByPks(addSubConfIds);
        List normalNames = Arrays.asList(normalConfs).stream().map(conf -> conf.getString("areacustname")).collect(Collectors.toList());
        List pMNames = Arrays.asList(pMConfs).stream().map(conf -> conf.getString("areacustname")).collect(Collectors.toList());
        StringBuilder stb = new StringBuilder();
        for (String normalName : normalNames) {
            stb.append(normalName);
            stb.append(',');
        }
        for (String pMName : pMNames) {
            stb.append(pMName);
            stb.append(',');
        }
        if (attachConf != null && attachId.size() > 0) {
            stb.append(attachConf.getString("areacustname"));
            stb.append(',');
        }
        if (stb.length() <= 0) {
            return "";
        }
        return stb.substring(0, stb.length() - 1);
    }

    public Map<Long, DynamicObject> queryEvaluationAreaInstance(List<DynamicObject> evaluationObjList) {
        HashMap<Long, ArrayList<Long>> areaInstanceIdOfRegMap = new HashMap<Long, ArrayList<Long>>(16);
        for (DynamicObject evaluationObj : evaluationObjList) {
            DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
            for (DynamicObject areaInfo : areaEntry) {
                long areaReg = areaInfo.getLong("areareg.id");
                ArrayList<Long> areaInstanceIds = (ArrayList<Long>)areaInstanceIdOfRegMap.get(areaReg);
                if (ObjectUtils.isEmpty((Object)areaInstanceIds)) {
                    areaInstanceIds = new ArrayList<Long>(evaluationObjList.size() * 2);
                }
                areaInstanceIds.add(areaInfo.getLong("areains"));
                areaInstanceIdOfRegMap.put(areaReg, areaInstanceIds);
            }
        }
        List areaInsIds = (List)areaInstanceIdOfRegMap.get(AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId());
        if (ObjectUtils.isEmpty((Object)areaInsIds)) {
            return new HashMap<Long, DynamicObject>(16);
        }
        OpmcEntityService areaInsEntity = AREA_INS_ENTITY_MAP.get(AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId());
        QFilter qFilter = new QFilter("id", "in", (Object)areaInsIds);
        DynamicObject[] areaInsDys = areaInsEntity.query("id,entryentity,entryentity.indctrscore,entryentity.weight,entryentity.indctrname,entryentity.addnodeindex,areascore,areaweight,indreqentity,indreqentity.indicatortype,indreqentity.score,indreqentity.scoretype", new QFilter[]{qFilter});
        return Arrays.stream(areaInsDys).collect(Collectors.toMap(areaInsDy -> areaInsDy.getLong("id"), Function.identity()));
    }

    public Map<Long, Long> queryEvaluationGenAreaConfId(List<DynamicObject> evaluationObjList) {
        HashMap<Long, Long> allInsOfConfMap = new HashMap<Long, Long>(16);
        for (DynamicObject evaluationObj : evaluationObjList) {
            DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
            for (DynamicObject areaInfo : areaEntry) {
                long areaReg = areaInfo.getLong("areareg.id");
                if (!AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaReg)) continue;
                allInsOfConfMap.put(areaInfo.getLong("areains"), areaInfo.getLong("areaconf"));
            }
        }
        return allInsOfConfMap;
    }

    public DynamicObject[] queryAssessGroup(List<Long> assGroupIds) {
        QFilter filter = new QFilter("id", "in", assGroupIds);
        return ASSESS_GROUP_ENTITY.query("number", new QFilter[]{filter}, "number");
    }

    public List<String> validateEvalObj(DynamicObject evaluationObj, DynamicObject scoreSystemDy, DynamicObject activityDy, Map<Long, DynamicObject> areaInstanceMap, Map<Long, Long> areaConfMap) {
        ArrayList<String> msgList = new ArrayList<String>(10);
        DynamicObjectCollection areaEntry = evaluationObj.getDynamicObjectCollection("areaentry");
        BigDecimal sumAreaScore = this.checkAndAddAreaScore(evaluationObj, areaInstanceMap, areaConfMap, msgList, areaEntry, true);
        BigDecimal maxScoreOfSystem = scoreSystemDy.getBigDecimal("maxscore");
        if (maxScoreOfSystem.compareTo(sumAreaScore) != 0) {
            msgList.add(ResManager.loadKDString((String)"{0} {1}: \u6240\u6709\u533a\u57df\u7684\u5206\u503c\u603b\u548c\u5fc5\u987b\u7b49\u4e8e{2}", (String)"ActivityEvaluationObjectDomainService_60", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number"), maxScoreOfSystem.stripTrailingZeros().toPlainString()}));
        }
        this.checkIndicatorReq(evaluationObj, activityDy, areaInstanceMap, areaEntry);
        return msgList;
    }

    private void checkIndicatorReq(DynamicObject evaluationObj, DynamicObject activityDy, Map<Long, DynamicObject> areaInstanceMap, DynamicObjectCollection areaEntry) {
        long currentAssGroupId = evaluationObj.getLong("assgroup_id");
        DynamicObjectCollection assGroupCollection = activityDy.getDynamicObjectCollection("assgroupentry");
        DynamicObject currentAssGroup = assGroupCollection.stream().filter(assGroup -> assGroup.getLong("assgroup_id") == currentAssGroupId).findFirst().orElse(null);
        boolean isRequire = currentAssGroup.getBoolean("isasstablerequire");
        if (isRequire) {
            for (DynamicObject areaInfo : areaEntry) {
                long areaInstId;
                DynamicObject areaInst;
                DynamicObjectCollection indreqEntity;
                long areaReg = areaInfo.getLong("areareg.id");
                if (!AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaReg) || ObjectUtils.isEmpty((Object)(indreqEntity = (areaInst = areaInstanceMap.get(areaInstId = areaInfo.getLong("areains"))).getDynamicObjectCollection("indreqentity")))) continue;
                for (DynamicObject indicatorReq : indreqEntity) {
                    String scoreType = indicatorReq.getString("scoretype");
                    if (!HRStringUtils.equals((String)ScoreTypeEnum.SUGGEST_REQUIRE.getType(), (String)scoreType)) continue;
                }
            }
        }
    }

    private BigDecimal checkAndAddAreaScore(DynamicObject evaluationObj, Map<Long, DynamicObject> areaInstanceMap, Map<Long, Long> areaConfMap, List<String> msgList, DynamicObjectCollection areaEntry, boolean isEqual) {
        BigDecimal sumAreaScore = new BigDecimal(0);
        for (DynamicObject areaInfo : areaEntry) {
            long areaReg = areaInfo.getLong("areareg.id");
            if (!AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaReg)) continue;
            long areaInstId = areaInfo.getLong("areains");
            DynamicObject areaInst = areaInstanceMap.get(areaInstId);
            BigDecimal areaScore = areaInst.getBigDecimal("areascore");
            sumAreaScore = sumAreaScore.add(areaScore);
            BigDecimal sumScore = this.getSumScore(evaluationObj, areaInst);
            Long confId = areaConfMap.get(areaInstId);
            DynamicObject conf = ASSESS_RULE_APP_SERVICE.queryNormalConfigByPk(confId);
            String custName = conf.getString("areacustname");
            if (isEqual) {
                if (sumScore.compareTo(areaScore) == 0) continue;
                msgList.add(ResManager.loadKDString((String)"%1$s %2$s: %3$s\u6307\u6807\u5408\u8ba1\u5206\u503c\u9700=\u533a\u57df\u5206\u503c\u3002", (String)"ActivityEvaluationObjectDomainService_61", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number"), custName}));
                continue;
            }
            if (sumScore.compareTo(areaScore) <= 0) continue;
            msgList.add(ResManager.loadKDString((String)"{0} {1}: {2}\u6307\u6807\u5408\u8ba1\u5206\u503c\u9700\u2264\u533a\u57df\u5206\u503c\u3002", (String)"ActivityEvaluationObjectDomainService_62", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number"), custName}));
        }
        return sumAreaScore;
    }

    private BigDecimal checkAreaWeightScore(DynamicObject evaluationObj, Map<Long, DynamicObject> areaInstanceMap, Map<Long, Long> areaConfMap, List<String> msgList, DynamicObjectCollection areaEntry, boolean isEqual) {
        BigDecimal sumAreaWeight = new BigDecimal(0);
        for (DynamicObject areaInfo : areaEntry) {
            long areaInstId;
            DynamicObject areaInst;
            long areaReg = areaInfo.getLong("areareg.id");
            if (!AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaReg) || HRObjectUtils.isEmpty((Object)(areaInst = areaInstanceMap.get(areaInstId = areaInfo.getLong("areains"))))) continue;
            BigDecimal areaWeight = areaInst.getBigDecimal("areaweight");
            sumAreaWeight = sumAreaWeight.add(areaWeight);
            BigDecimal weightScore = this.getWeightScore(evaluationObj, areaInst);
            Long confId = areaConfMap.get(areaInstId);
            DynamicObject conf = ASSESS_RULE_APP_SERVICE.queryNormalConfigByPk(confId);
            String custName = conf.getString("areacustname");
            if (isEqual) {
                if (weightScore.compareTo(areaWeight) == 0) continue;
                msgList.add(ResManager.loadKDString((String)"{0} {1}: {2}\u6307\u6807\u5408\u8ba1\u6743\u91cd\u9700=\u533a\u57df\u6743\u91cd\u3002", (String)"ActivityEvaluationObjectDomainService_63", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number"), custName}));
                continue;
            }
            if (weightScore.compareTo(areaWeight) <= 0) continue;
            msgList.add(ResManager.loadKDString((String)"{0} {1}: {2}\u6307\u6807\u5408\u8ba1\u6743\u91cd\u9700\u2264\u533a\u57df\u6743\u91cd\u3002", (String)"ActivityEvaluationObjectDomainService_64", (String)"opmc-epa-business", (Object[])new Object[]{evaluationObj.getString("person.name"), evaluationObj.getString("person.number"), custName}));
        }
        return sumAreaWeight;
    }

    private BigDecimal getWeightScore(DynamicObject evalObj, DynamicObject areaInst) {
        DynamicObjectCollection indicatorEntry = areaInst.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection indicatorEntryNew = new DynamicObjectCollection();
        int index = 0;
        if (evalObj != null) {
            Long formulateflowinsid = evalObj.getLong("formulateflowins.id");
            if (formulateflowinsid != 0L) {
                DynamicObject flowRuProc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(formulateflowinsid);
                index = flowRuProc.getInt("currentnode.index");
            }
            for (DynamicObject entry : indicatorEntry) {
                if (entry.getInt("addnodeindex") > index) continue;
                indicatorEntryNew.add((Object)entry);
            }
        }
        return indicatorEntryNew.stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal("weight")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getSumScore(DynamicObject evalObj, DynamicObject areaInst) {
        DynamicObjectCollection indicatorEntry = areaInst.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection indicatorEntryNew = new DynamicObjectCollection();
        Long objId = areaInst.getLong("areaactevalobj");
        int index = 0;
        if (evalObj != null) {
            Long formulateflowinsid = evalObj.getLong("formulateflowins.id");
            if (formulateflowinsid != 0L) {
                DynamicObject flowRuProc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(formulateflowinsid);
                index = flowRuProc.getInt("currentnode.index");
            }
            for (DynamicObject entry : indicatorEntry) {
                if (entry.getInt("addnodeindex") > index) continue;
                indicatorEntryNew.add((Object)entry);
            }
        }
        return indicatorEntryNew.stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal("indctrscore")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public int getCurrentNodeIndex(Long objId) {
        Long formulateflowinsid;
        DynamicObject evalObj = ACTIVITY_EVALUATION_OBJECT_ENTITY.loadSingle(objId);
        int index = 0;
        if (evalObj != null && (formulateflowinsid = Long.valueOf(evalObj.getLong("formulateflowins.id"))) != 0L) {
            DynamicObject flowRuProc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(formulateflowinsid);
            index = flowRuProc.getInt("currentnode.index");
        }
        return index;
    }

    public boolean queryAssGroupEvaObjExistsByActivityId(Long activityId, Long groupId) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.queryAssGroupEvaObjExistsByActivityId(activityId, groupId);
    }

    public Integer queryMaxProgressNodeStatusByActId(Long activityId, List<Integer> nodeIndexs) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.queryMaxProgressNodeStatusByActId(activityId, nodeIndexs);
    }

    public boolean isExistsInProgress(Long activityId) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.isExistsInProgress(activityId);
    }

    public boolean isExistsEvalObj(Long activityId) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.isExistsEvalObj(activityId);
    }

    public DynamicObject[] queryEvaluationObjectByActId(Long actId) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.queryActivityEvaluationObjectActivityId("id, perffile,perffile.archivesstatus", actId);
    }

    public DynamicObject[] queryExistEvalObjectByPersonId(String activityPeriod, List<Long> perffileIds) {
        AssessActivityDomainService assessActivityDomainService = new AssessActivityDomainService();
        DynamicObject[] activities = assessActivityDomainService.queryActivityByPeriod(activityPeriod);
        List actIds = Arrays.stream(activities).map(act -> act.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("activity", "in", actIds).and("perffile", "in", perffileIds).and("assessstaus", "!=", (Object)AssessStausEnum.Exited.getStatus());
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id, perffile", new QFilter[]{qFilter});
    }

    public Map<Long, DynamicObject> queryExistEvalObjectByPerfIds(String activityPeriod, List<Long> perfFileIdList) {
        AssessActivityDomainService assessActivityDomainService = new AssessActivityDomainService();
        DynamicObject[] activities = assessActivityDomainService.queryActivityByPeriod(activityPeriod);
        List actIds = Arrays.stream(activities).map(act -> act.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("activity", "in", actIds).and("perffile", "in", perfFileIdList).and("assessstaus", "!=", (Object)AssessStausEnum.Exited.getStatus());
        DynamicObject[] evalObj = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id, perffile, activity", new QFilter[]{qFilter});
        return Arrays.stream(evalObj).collect(Collectors.toMap(item1 -> item1.getLong("perffile.id"), item2 -> item2.getDynamicObject("activity"), (e1, e2) -> e1));
    }

    public void updateActivityRecordInfo(DynamicObject[] evalObjDy) {
        DynamicObject[] objRecordDys;
        List evalObjIdList = Arrays.stream(evalObjDy).map(evalObj -> evalObj.getLong("id")).collect(Collectors.toList());
        QFilter objFilter = new QFilter("actevalobj", "in", evalObjIdList);
        QFilter nodeFilter = new QFilter("assessnode", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId());
        for (DynamicObject objRecordDy : objRecordDys = ACTIVITY_RECORD_ENTITY.query("nodestatus, endtime", new QFilter[]{objFilter, nodeFilter})) {
            objRecordDy.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus());
            objRecordDy.set("endtime", (Object)new Date());
        }
        ACTIVITY_RECORD_ENTITY.save(objRecordDys);
    }

    public Map<Long, List<DynamicObject>> queryActRecordByActObjIds(List<Long> actObjIds) {
        return ACTIVITY_RECORD_ENTITY.queryActRecordByActObjIds(actObjIds);
    }

    public Map<Long, Map<String, String>> queryEvaluatingCurNodeByObjIds(List<Long> actObjIds, long assessNode) {
        DynamicObject[] evaluationObjects;
        QFilter objFilter = new QFilter("id", "in", actObjIds);
        Map<Object, Object> objIdProcMap = new HashMap(16);
        List<Object> procIds = new ArrayList(10);
        if (AssessNodeStatusEnum.EVALUATING.getNodeId().equals(assessNode)) {
            evaluationObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.queryOriginalArray("id, evalflowins", new QFilter[]{objFilter});
            objIdProcMap = Arrays.stream(evaluationObjects).collect(Collectors.toMap(obj1 -> obj1.getLong("id"), obj2 -> obj2.getLong("evalflowins")));
            procIds = Arrays.stream(evaluationObjects).map(obj -> obj.getLong("evalflowins")).collect(Collectors.toList());
        } else {
            evaluationObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.queryOriginalArray("id, formulateflowins", new QFilter[]{objFilter});
            objIdProcMap = Arrays.stream(evaluationObjects).collect(Collectors.toMap(obj1 -> obj1.getLong("id"), obj2 -> obj2.getLong("formulateflowins")));
            procIds = Arrays.stream(evaluationObjects).map(obj -> obj.getLong("formulateflowins")).collect(Collectors.toList());
        }
        HashMap<Long, Map<String, String>> ret = new HashMap<Long, Map<String, String>>(objIdProcMap.size());
        DynamicObject[] procs = FLOW_RU_PROC_APPLICATION_SERVICE.queryProcByProcIds(procIds);
        HashMap<Long, DynamicObject> curNodeMap = new HashMap<Long, DynamicObject>(procs.length);
        for (DynamicObject proc : procs) {
            curNodeMap.put(proc.getLong("id"), proc.getDynamicObject("currentnode"));
        }
        List curNodeIds = Arrays.stream(procs).map(x -> x.getLong("currentnode.id")).collect(Collectors.toList());
        Map curNodeTaskMap = FLOW_RU_PROC_APPLICATION_SERVICE.queryTaskByNodeIds(curNodeIds);
        Date date = new Date();
        for (Map.Entry<Object, Object> objIdProcId : objIdProcMap.entrySet()) {
            HashMap<String, String> tempMap = new HashMap<String, String>(4);
            DynamicObject currentNode = (DynamicObject)curNodeMap.get(objIdProcId.getValue());
            if (currentNode != null) {
                tempMap.put("currentnode", currentNode.getString("name"));
                tempMap.put("duration", DateUtils.getIntervalDays((Date)date, (Date)currentNode.getDate("starttime")) + "d");
                List tasks = (List)curNodeTaskMap.get(currentNode.getLong("id"));
                tempMap.put("currenthandler", tasks == null ? "-" : this.getCurrentHandlerStr(tasks));
                tempMap.put("assessprocess", tasks == null ? "0/0" : this.getNodeHandlerNumber(tasks));
            } else {
                tempMap.put("currentnode", "-");
                tempMap.put("duration", "0d");
                tempMap.put("currenthandler", "-");
                tempMap.put("assessprocess", "0/0");
            }
            ret.put((Long)objIdProcId.getKey(), tempMap);
        }
        return ret;
    }

    private String getNodeHandlerNumber(List<DynamicObject> tasks) {
        return tasks.stream().filter(x -> FlowRuTaskStatusEnum.PROCESSED.getCode().equals(x.getString("taskstatus"))).count() + "/" + tasks.stream().filter(task -> {
            FlowRuTaskStatusEnum status = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)task.getString("taskstatus"));
            return status == FlowRuTaskStatusEnum.NOT_ACTIVE || status == FlowRuTaskStatusEnum.WAITING || status == FlowRuTaskStatusEnum.PROCESSING || status == FlowRuTaskStatusEnum.BE_WAITTING || status == FlowRuTaskStatusEnum.RETURNED || status == FlowRuTaskStatusEnum.PROCESSED || status == FlowRuTaskStatusEnum.PENDING;
        }).count();
    }

    private String getCurrentHandlerStr(List<DynamicObject> tasks) {
        StringBuilder sb = new StringBuilder();
        Map<Long, List<DynamicObject>> taskMap = tasks.stream().filter(task -> {
            FlowRuTaskStatusEnum status = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)task.getString("taskstatus"));
            return status == FlowRuTaskStatusEnum.NOT_ACTIVE || status == FlowRuTaskStatusEnum.WAITING || status == FlowRuTaskStatusEnum.PROCESSING || status == FlowRuTaskStatusEnum.BE_WAITTING || status == FlowRuTaskStatusEnum.RETURNED || status == FlowRuTaskStatusEnum.PENDING;
        }).collect(Collectors.groupingBy(tas -> tas.getLong("flowrurole.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : taskMap.entrySet()) {
            if (!CollectionUtils.isNotEmpty((Collection)entry.getValue())) continue;
            sb.append(entry.getValue().get(0).getString("flowrurole.roletype.name")).append('\uff1a');
            for (DynamicObject taskDetail : entry.getValue()) {
                sb.append(taskDetail.getString("handler.name"));
                String handlerNumber = taskDetail.getString("handler.number");
                if (!HRStringUtils.isBlank((CharSequence)handlerNumber)) {
                    sb.append('\uff08').append(handlerNumber).append('\uff09').append('\uff0c');
                    continue;
                }
                sb.append('\uff0c');
            }
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\uff0c') {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append('\uff1b');
        }
        if (sb.length() < 1) {
            return "";
        }
        return sb.charAt(sb.length() - 1) == '\uff1b' ? sb.deleteCharAt(sb.length() - 1).toString() : sb.toString();
    }

    public Map<Long, Date> queryEvaluatedFlowRuEndTimeByObjIds(List<Long> actObjIds) {
        QFilter objFilter = new QFilter("id", "in", actObjIds);
        DynamicObject[] evaluationObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id, evalflowentry.evalflowru", new QFilter[]{objFilter});
        return Arrays.stream(evaluationObjects).collect(Collectors.toMap(x -> x.getLong("id"), y -> ((DynamicObject)y.getDynamicObjectCollection("evalflowentry").get(0)).getDynamicObject("evalflowru").getDate("updatestatustime")));
    }

    public void addEvaluationObjectsWithInput(IFormView view, DynamicObjectCollection joinInAssess, DynamicObject activity) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        IPageCache pageCache = view.getPageCache();
        FormShowParameter parameter = view.getFormShowParameter();
        Integer nodeIndex = (Integer)parameter.getCustomParam("nodeindex");
        Map<String, String> pkAndSeq = ASSESS_FORM_DOMAIN_SERVICE.requireLevelMap(Long.parseLong(pageCache.get("assessFormId")));
        Map<String, Long> scoreAndLevelMap = EvalObjUtils.reqFormScoreAndLevel(activity);
        for (DynamicObject join : joinInAssess) {
            DynamicObject activityEvaluationObject = this.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)join, (DynamicObject)activityEvaluationObject);
            activityEvaluationObject.set("assgroup", join.get("group"));
            activityEvaluationObject.set("affiliateadminorg", join.get("perffile.affiliateadminorg"));
            Date perfStart = join.getDate("perffile.startdate");
            Date perfEnd = join.getDate("perffile.enddate");
            if (perfStart != null && perfEnd != null) {
                activityEvaluationObject.set("startdate", (Object)(perfStart.compareTo(activity.getDate("periodstartdate")) < 0 ? activity.getDate("periodstartdate") : perfStart));
                activityEvaluationObject.set(ENDDATE, (Object)(perfEnd.compareTo(activity.getDate("periodenddate")) > 0 ? activity.getDate("periodenddate") : perfEnd));
            }
            activityEvaluationObject.set("activity", (Object)activity.getLong("id"));
            activityEvaluationObject.set("assessperiod", activity.get("period"));
            if (!HRObjectUtils.isEmpty((Object)activity.get("year"))) {
                activityEvaluationObject.set("assessyear", (Object)HRDateTimeUtils.getYear((Date)((Date)activity.get("year"))));
            }
            activityEvaluationObject.set("ressyncstatus", (Object)"10");
            activityEvaluationObject.set("assessstaus", (Object)AssessStausEnum.JOINED.getStatus());
            activityEvaluationObject.set("createtime", (Object)new Date());
            activityEvaluationObject.set("modifytime", (Object)new Date());
            activityEvaluationObject.set("modifytime", (Object)RequestContext.get().getCurrUserId());
            activityEvaluationObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            activityEvaluationObject.set("perforg", join.get("perffile.pmdorg"));
            activityEvaluationObject.set("empposrel", join.get("perffile.empposrel"));
            BigDecimal score = join.getBigDecimal("scorefield");
            String levelPk = join.getString("levelfield");
            String level = null == pkAndSeq || StringUtils.isEmpty((String)levelPk) ? "" : pkAndSeq.get(levelPk);
            activityEvaluationObject.set(AssessScoreAbbrEnum.SATCS.getCode(), (Object)score);
            activityEvaluationObject.set(AssessScoreAbbrEnum.SATCL.getCode(), (Object)level);
            activityEvaluationObject.set(AssessScoreAbbrEnum.SOAT.getCode(), (Object)score);
            activityEvaluationObject.set(AssessScoreAbbrEnum.LEVELOAT.getCode(), (Object)level);
            activityEvaluationObject.set("soatsource", (Object)AssessScoreAbbrEnum.SATCS.getCode());
            activityEvaluationObject.set(AssessScoreAbbrEnum.SOAC.getCode(), (Object)score);
            activityEvaluationObject.set(AssessScoreAbbrEnum.LOAC.getCode(), (Object)level);
            activityEvaluationObject.set(AssessScoreAbbrEnum.SOP.getCode(), (Object)score);
            activityEvaluationObject.set(AssessScoreAbbrEnum.LOP.getCode(), (Object)level);
            activityEvaluationObject.set("sopsource", (Object)AssessScoreAbbrEnum.SOAC.getCode());
            activityEvaluationObject.set(AssessScoreAbbrEnum.FSOP.getCode(), (Object)score);
            activityEvaluationObject.set(AssessScoreAbbrEnum.FLOP.getCode(), (Object)level);
            activityEvaluationObject.set("fsopsource", (Object)AssessScoreAbbrEnum.SOP.getCode());
            activityEvaluationObject.set("fsopscoresystem", (Object)scoreAndLevelMap.get("scoreSystem"));
            activityEvaluationObject.set("floplevel", (Object)scoreAndLevelMap.get("sumPerfLevel"));
            DynamicObjectCollection timeplanEntry = activity.getDynamicObjectCollection("timeplanentry");
            boolean isLastNode = timeplanEntry.size() == (null == nodeIndex ? 2 : nodeIndex);
            long userId = UserServiceHelper.getCurrentUserId();
            activityEvaluationObject.set("evalfinishtype", (Object)EvalfinishtypeEnum.HANDWORK_INPUT.getType());
            activityEvaluationObject.set("perffilev", join.get("perffile.sourcevid"));
            activityEvaluationObject.set("nodestatus", (Object)(isLastNode ? null : AssessNodeStatusEnum.EVALUATED.getStatus()));
            activityEvaluationObject.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
            activityEvaluationObject.set("assessnode", (Object)NodeTabMapEnum.EVAL_PROCESS.getNodeId());
            activityEvaluationObject.set("nodeindex", (Object)2);
            activityEvaluationObject.set("iscurperiod", (Object)Boolean.TRUE);
            if (isLastNode) {
                activityEvaluationObject.set("assessstaus", (Object)AssessStausEnum.COMPLETED.getStatus());
                activityEvaluationObject.set("assessnode", null);
                activityEvaluationObject.set("nodeindex", null);
                activityEvaluationObject.set("completetime", (Object)new Date());
            }
            dynamicObjects.add(activityEvaluationObject);
        }
        Object[] dyArray = this.saveEvaluationObject(dynamicObjects.toArray(new DynamicObject[0]));
        if (null == dyArray || dyArray.length <= 0) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection recodeDyColl = new DynamicObjectCollection();
        for (Object obj : dyArray) {
            if (!(obj instanceof DynamicObject)) continue;
            DynamicObject dy = (DynamicObject)obj;
            DynamicObject recodeDy = EvalObjUtils.addActivityRecord(dy.getInt("nodeindex"), dy, new Date(), userId);
            recodeDyColl.add((Object)recodeDy);
        }
        EvalObjUtils.saveRecordEntityColl(recodeDyColl);
    }

    public DynamicObject queryEvaluatedObj(Long id) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.loadSingle(id);
    }

    public Map<Long, BigDecimal> getSumWeightScoreMap(DynamicObject[] evalObjs) {
        return this.getSumScoreMap(evalObjs, "weight");
    }

    public Map<Long, BigDecimal> getNormalAreaSumMap(DynamicObject[] evalObjs, Map<Long, DynamicObject> areaInstanceMap, String target) {
        HashMap<Long, BigDecimal> sumScoreMap = new HashMap<Long, BigDecimal>(16);
        if (ObjectUtils.isEmpty(areaInstanceMap)) {
            return sumScoreMap;
        }
        for (DynamicObject evalObj : evalObjs) {
            DynamicObjectCollection areaEntity = evalObj.getDynamicObjectCollection("areaentry");
            Set<Long> areaInstIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areains")).collect(Collectors.toSet());
            ArrayList areaInstList = new ArrayList();
            areaInstIds.forEach(areaInstId -> areaInstList.add(areaInstanceMap.get(areaInstId)));
            List allNormIndicator = areaInstList.stream().flatMap(areaInst -> areaInst.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
            BigDecimal reduce = allNormIndicator.stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal(target)).reduce(BigDecimal.ZERO, BigDecimal::add);
            sumScoreMap.put(evalObj.getLong("id"), reduce);
        }
        return sumScoreMap;
    }

    public Map<Long, BigDecimal> getNormalAreaWeightSumMap(DynamicObject[] evalObjs, Map<Long, DynamicObject> areaInstanceMap) {
        HashMap<Long, BigDecimal> weightScoreMap = new HashMap<Long, BigDecimal>(16);
        if (ObjectUtils.isEmpty(areaInstanceMap)) {
            return weightScoreMap;
        }
        for (DynamicObject evalObj : evalObjs) {
            DynamicObjectCollection areaEntity = evalObj.getDynamicObjectCollection("areaentry");
            Set<Long> areaInstIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areains")).collect(Collectors.toSet());
            ArrayList areaInstList = new ArrayList();
            areaInstIds.forEach(areaInstId -> areaInstList.add(areaInstanceMap.get(areaInstId)));
            BigDecimal reduce = areaInstList.stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal("areaweight")).reduce(BigDecimal.ZERO, BigDecimal::add);
            weightScoreMap.put(evalObj.getLong("id"), reduce);
        }
        return weightScoreMap;
    }

    private Map<Long, BigDecimal> getSumScoreMap(DynamicObject[] evalObjs, String target) {
        HashMap<Long, BigDecimal> sumScoreMap = new HashMap<Long, BigDecimal>(16);
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(Arrays.asList(evalObjs));
        if (ObjectUtils.isEmpty(areaInstanceMap)) {
            return sumScoreMap;
        }
        for (DynamicObject evalObj : evalObjs) {
            DynamicObjectCollection areaEntity = evalObj.getDynamicObjectCollection("areaentry");
            Set<Long> areaInstIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areains")).collect(Collectors.toSet());
            ArrayList areaInstList = new ArrayList();
            areaInstIds.forEach(areaInstId -> areaInstList.add(areaInstanceMap.get(areaInstId)));
            List allNormIndicator = areaInstList.stream().flatMap(areaInst -> areaInst.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
            BigDecimal reduce = allNormIndicator.stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal(target)).reduce(BigDecimal.ZERO, BigDecimal::add);
            sumScoreMap.put(evalObj.getLong("id"), reduce);
        }
        return sumScoreMap;
    }

    public Map<Long, Boolean> checkForcedControlZeroMap(DynamicObject[] evalObjs, String target, BigDecimal limit) {
        HashMap<Long, Boolean> isZeroMap = new HashMap<Long, Boolean>(16);
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(Arrays.asList(evalObjs));
        if (ObjectUtils.isEmpty(areaInstanceMap)) {
            return isZeroMap;
        }
        for (DynamicObject evalObj : evalObjs) {
            DynamicObjectCollection areaEntity = evalObj.getDynamicObjectCollection("areaentry");
            Set<Long> areaInstIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areains")).collect(Collectors.toSet());
            Set<Long> areaConfIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areaconf")).collect(Collectors.toSet());
            Map<Long, Long> areaInsConfIdMaps = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).collect(Collectors.toMap(area -> area.getLong("areains"), area -> area.getLong("areaconf")));
            DynamicObject[] normalConfigs = ASSESS_FORM_DOMAIN_SERVICE.queryNormalConfigByIds(areaConfIds);
            ArrayList areaInstList = new ArrayList();
            areaInstIds.forEach(areaInstId -> areaInstList.add(areaInstanceMap.get(areaInstId)));
            BigDecimal reduce = areaInstList.stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal(target)).reduce(BigDecimal.ZERO, BigDecimal::add);
            areaInstList.forEach(areaInst -> {
                BigDecimal areaWeight;
                DynamicObject dynamicObject = Arrays.stream(normalConfigs).filter(config -> HRObjectUtils.equals((Object)config.getLong("id"), areaInsConfIdMaps.get(areaInst.getLong("id")))).findFirst().orElse(null);
                if (dynamicObject != null && dynamicObject.getBoolean("isforcedcontrol") && BigDecimal.ZERO.compareTo(areaWeight = areaInst.getBigDecimal(target)) == 0 && BigDecimal.ZERO.compareTo(reduce) < 0 && limit.compareTo(reduce) != 0) {
                    isZeroMap.put(evalObj.getLong("id"), true);
                }
            });
        }
        return isZeroMap;
    }

    public Map<Long, Boolean> checkOutWeightForcedControlZeroMap(DynamicObject[] evalObjs, String target, BigDecimal limitMaxRatioBD) {
        HashMap<Long, Boolean> isZeroMap = new HashMap<Long, Boolean>(16);
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(Arrays.asList(evalObjs));
        if (ObjectUtils.isEmpty(areaInstanceMap)) {
            return isZeroMap;
        }
        for (DynamicObject evalObj : evalObjs) {
            DynamicObjectCollection areaEntity = evalObj.getDynamicObjectCollection("areaentry");
            Set<Long> areaInstIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areains")).collect(Collectors.toSet());
            Set<Long> areaConfIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areaconf")).collect(Collectors.toSet());
            Map<Long, Long> areaInsConfIdMaps = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).collect(Collectors.toMap(area -> area.getLong("areains"), area -> area.getLong("areaconf")));
            DynamicObject[] normalConfigs = ASSESS_FORM_DOMAIN_SERVICE.queryNormalConfigByIds(areaConfIds);
            ArrayList areaInstList = new ArrayList();
            areaInstIds.forEach(areaInstId -> areaInstList.add(areaInstanceMap.get(areaInstId)));
            BigDecimal reduce = areaInstList.stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal(target)).reduce(BigDecimal.ZERO, BigDecimal::add);
            areaInstList.forEach(areaInst -> {
                BigDecimal areaWeight;
                DynamicObject dynamicObject = Arrays.stream(normalConfigs).filter(config -> HRObjectUtils.equals((Object)config.getLong("id"), areaInsConfIdMaps.get(areaInst.getLong("id")))).findFirst().orElse(null);
                if (dynamicObject != null && dynamicObject.getBoolean("isforcedcontrol") && (BigDecimal.ZERO.compareTo(areaWeight = areaInst.getBigDecimal(target)) == 0 && BigDecimal.ZERO.compareTo(reduce) < 0 && new BigDecimal(100).compareTo(reduce) > 0 || limitMaxRatioBD.compareTo(reduce) < 0)) {
                    isZeroMap.put(evalObj.getLong("id"), true);
                }
            });
        }
        return isZeroMap;
    }

    public Map<Long, BigDecimal> getSumIndctrScoreMap(DynamicObject[] evalObjs) {
        return this.getSumScoreMap(evalObjs, "indctrscore");
    }

    public Map<Long, DynamicObject> queryEvalObjectsByIds(List<Long> evalObjectIdList) {
        QFilter idFilter = new QFilter("id", "in", evalObjectIdList);
        DynamicObject[] evals = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("evalflow,person, assessnode, nodestatus, nodeindex", new QFilter[]{idFilter}, "modifytime desc");
        Map<Long, DynamicObject> ret = Arrays.stream(evals).collect(Collectors.toMap(task -> task.getLong("id"), task -> task));
        return ret;
    }

    public void updateWeightAndIndctrScore(Long objId) {
        DynamicObject obj = ACTIVITY_EVALUATION_OBJECT_ENTITY.loadSingle(objId);
        obj.set("assweight", (Object)this.getAssweight(obj));
        obj.set("assscore", (Object)this.getAssscore(obj));
        ACTIVITY_EVALUATION_OBJECT_ENTITY.updateOne(obj);
    }

    public void batchUpdateWeightAndIndctrScore(List<Long> objIds) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = ACTIVITY_EVALUATION_OBJECT_ENTITY.queryActEvalObjByIds(objIds)) {
            obj.set("assweight", (Object)this.getAssweight(obj));
            obj.set("assscore", (Object)this.getAssscore(obj));
        }
        ACTIVITY_EVALUATION_OBJECT_ENTITY.update(objs);
    }

    private BigDecimal getAssweight(DynamicObject evalObj) {
        return this.getSumScore(evalObj, "weight").divide(new BigDecimal(100), 2, 1);
    }

    private String getAssscore(DynamicObject evalObj) {
        BigDecimal sumIndctrScore = this.getSumScore(evalObj, "indctrscore");
        DynamicObject activityDy = evalObj.getDynamicObject("activity");
        DynamicObject assessFormDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssessFormByActId(activityDy.getLong("id"));
        DynamicObject scoreSystemDy = EXECUTE_SCHEME_DOMAIN_SERVICE.queryScoreSystemByScoreSystemId(assessFormDy.getLong("scoresystem.id"));
        String numAccuracy = assessFormDy.getString("numaccuracy");
        String scaleType = assessFormDy.getString("scaletype");
        String score = sumIndctrScore.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get(scaleType).getType()).stripTrailingZeros().toPlainString();
        String maxScoreOfSystem = scoreSystemDy.getBigDecimal("maxscore").setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get(scaleType).getType()).stripTrailingZeros().toPlainString();
        return score + "/" + maxScoreOfSystem;
    }

    private BigDecimal getSumScore(DynamicObject evalObj, String target) {
        Map<Long, DynamicObject> areaInstanceMap = this.queryEvaluationAreaInstance(Collections.singletonList(evalObj));
        DynamicObjectCollection areaEntity = evalObj.getDynamicObjectCollection("areaentry");
        Set<Long> areaInstIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areains")).collect(Collectors.toSet());
        ArrayList areaInstList = new ArrayList();
        areaInstIds.forEach(areaInstId -> areaInstList.add(areaInstanceMap.get(areaInstId)));
        List allNormIndicator = areaInstList.stream().flatMap(areaInst -> areaInst.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
        Long formulateflowinsid = evalObj.getLong("formulateflowins.id");
        int index = 0;
        if (formulateflowinsid != 0L) {
            DynamicObject flowRuProc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(formulateflowinsid);
            index = flowRuProc.getInt("currentnode.index");
        }
        int finalIndex = index;
        BigDecimal reduce = allNormIndicator.stream().filter(Objects::nonNull).filter(dy -> dy.getInt("addnodeindex") <= finalIndex).map(indicator -> indicator.getBigDecimal(target)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return reduce;
    }

    public Map<Long, Long> getAreaSumScoreNotEqMap(DynamicObject[] evalObjs, Map<Long, DynamicObject> areaInstanceMap) {
        HashMap<Long, Long> refMap = new HashMap<Long, Long>(16);
        for (DynamicObject evalObj : evalObjs) {
            DynamicObjectCollection areaEntity = evalObj.getDynamicObjectCollection("areaentry");
            Set<Long> areaInstIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areains")).collect(Collectors.toSet());
            ArrayList areaInstList = new ArrayList();
            areaInstIds.forEach(areaInstId -> areaInstList.add(areaInstanceMap.get(areaInstId)));
            areaInstList.forEach(areaInst -> {
                BigDecimal areaScore;
                BigDecimal count = areaInst.getDynamicObjectCollection("entryentity").stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal("indctrscore")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (count.compareTo(areaScore = areaInst.getBigDecimal("areascore")) != 0) {
                    refMap.put(evalObj.getLong("id"), areaInst.getLong("id"));
                }
            });
        }
        return refMap;
    }

    public Map<Long, Long> getAreaSumWeightNotEqMap(DynamicObject[] evalObjs, Map<Long, DynamicObject> areaInstanceMap) {
        HashMap<Long, Long> refMap = new HashMap<Long, Long>(16);
        for (DynamicObject evalObj : evalObjs) {
            DynamicObjectCollection areaEntity = evalObj.getDynamicObjectCollection("areaentry");
            Set<Long> areaInstIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areains")).collect(Collectors.toSet());
            ArrayList areaInstList = new ArrayList();
            areaInstIds.forEach(areaInstId -> areaInstList.add(areaInstanceMap.get(areaInstId)));
            areaInstList.forEach(areaInst -> {
                BigDecimal areaWeight;
                BigDecimal count = areaInst.getDynamicObjectCollection("entryentity").stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal("weight")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (count.compareTo(areaWeight = areaInst.getBigDecimal("areaweight")) != 0) {
                    refMap.put(evalObj.getLong("id"), areaInst.getLong("id"));
                }
            });
        }
        return refMap;
    }

    public Map<Long, Long> getAreaSumNotEqMap(DynamicObject[] evalObjs, Map<Long, DynamicObject> areaInstanceMap, String assFormat) {
        if (ObjectUtils.isEmpty(areaInstanceMap)) {
            return new HashMap<Long, Long>(16);
        }
        return HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) ? this.getAreaSumWeightNotEqMap(evalObjs, areaInstanceMap) : this.getAreaSumScoreNotEqMap(evalObjs, areaInstanceMap);
    }

    public DynamicObject[] queryById(String properties, List<Long> actEvaObjId) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.query(properties, new QFilter[]{new QFilter("id", "in", actEvaObjId)});
    }

    public DynamicObject[] queryEvalObjsByIndicGroupId(long indicGroupId) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.queryEvalObjsByIndicGroupId(indicGroupId);
    }

    public Map<Long, Long> getAreaSumScoreGtMap(DynamicObject[] evalObjs, Map<Long, DynamicObject> areaInstanceMap) {
        HashMap<Long, Long> refMap = new HashMap<Long, Long>(16);
        for (DynamicObject evalObj : evalObjs) {
            DynamicObjectCollection areaEntity = evalObj.getDynamicObjectCollection("areaentry");
            Set<Long> areaInstIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areains")).collect(Collectors.toSet());
            ArrayList areaInstList = new ArrayList();
            areaInstIds.forEach(areaInstId -> areaInstList.add(areaInstanceMap.get(areaInstId)));
            areaInstList.forEach(areaInst -> {
                BigDecimal areaScore;
                BigDecimal count = areaInst.getDynamicObjectCollection("entryentity").stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal("indctrscore")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (count.compareTo(areaScore = areaInst.getBigDecimal("areascore")) > 0) {
                    refMap.put(evalObj.getLong("id"), areaInst.getLong("id"));
                }
            });
        }
        return refMap;
    }

    public Map<Long, Long> getAreaSumWeightGtMap(DynamicObject[] evalObjs, Map<Long, DynamicObject> areaInstanceMap) {
        HashMap<Long, Long> refMap = new HashMap<Long, Long>(16);
        for (DynamicObject evalObj : evalObjs) {
            DynamicObjectCollection areaEntity = evalObj.getDynamicObjectCollection("areaentry");
            Set<Long> areaInstIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areains")).collect(Collectors.toSet());
            ArrayList areaInstList = new ArrayList();
            areaInstIds.forEach(areaInstId -> areaInstList.add(areaInstanceMap.get(areaInstId)));
            areaInstList.forEach(areaInst -> {
                BigDecimal areaWeight;
                BigDecimal count = areaInst.getDynamicObjectCollection("entryentity").stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal("weight")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (count.compareTo(areaWeight = areaInst.getBigDecimal("areaweight")) > 0) {
                    refMap.put(evalObj.getLong("id"), areaInst.getLong("id"));
                }
            });
        }
        return refMap;
    }

    public Map<Long, Long> getNormalAreaSumGtMap(DynamicObject[] evalObjs, Map<Long, DynamicObject> areaInstanceMap, String assFormat) {
        if (ObjectUtils.isEmpty(areaInstanceMap)) {
            return new HashMap<Long, Long>(16);
        }
        return HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) ? this.getAreaSumWeightGtMap(evalObjs, areaInstanceMap) : this.getAreaSumScoreGtMap(evalObjs, areaInstanceMap);
    }

    public DynamicObject getTask(Long taskId) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.getEvalTask(taskId.longValue());
    }

    public Map<Long, BigDecimal> getAreaValNotEqMap(DynamicObject[] evalObjs, String target, BigDecimal compareVal, Map<Long, DynamicObject> areaInstanceMap) {
        HashMap<Long, BigDecimal> refMap = new HashMap<Long, BigDecimal>(16);
        if (ObjectUtils.isEmpty(areaInstanceMap)) {
            return refMap;
        }
        for (DynamicObject evalObj : evalObjs) {
            BigDecimal count;
            DynamicObjectCollection areaEntity = evalObj.getDynamicObjectCollection("areaentry");
            Set<Long> areaInstIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areains")).collect(Collectors.toSet());
            ArrayList areaInstList = new ArrayList();
            areaInstIds.forEach(areaInstId -> areaInstList.add(areaInstanceMap.get(areaInstId)));
            boolean allMatch = areaInstList.stream().allMatch(areaInst -> areaInst.getBigDecimal(target).compareTo(BigDecimal.ZERO) > 0);
            if (!allMatch || (count = areaInstList.stream().map(areaInst -> areaInst.getBigDecimal(target)).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(compareVal) == 0) continue;
            refMap.put(evalObj.getLong("id"), count);
        }
        return refMap;
    }

    public Map<Long, BigDecimal> getAreaValLargeMap(DynamicObject[] evalObjs, String target, BigDecimal limitMaxRatioBD, Map<Long, DynamicObject> areaInstanceMap) {
        HashMap<Long, BigDecimal> refMap = new HashMap<Long, BigDecimal>(16);
        if (ObjectUtils.isEmpty(areaInstanceMap)) {
            return refMap;
        }
        for (DynamicObject evalObj : evalObjs) {
            BigDecimal count;
            DynamicObjectCollection areaEntity = evalObj.getDynamicObjectCollection("areaentry");
            Set<Long> areaInstIds = areaEntity.stream().filter(area -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(area.getLong("areareg.id"))).map(area -> area.getLong("areains")).collect(Collectors.toSet());
            ArrayList areaInstList = new ArrayList();
            areaInstIds.forEach(areaInstId -> areaInstList.add(areaInstanceMap.get(areaInstId)));
            boolean allMatch = areaInstList.stream().allMatch(areaInst -> areaInst.getBigDecimal(target).compareTo(BigDecimal.ZERO) > 0);
            if (!allMatch || (count = areaInstList.stream().map(areaInst -> areaInst.getBigDecimal(target)).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(limitMaxRatioBD) <= 0 && count.compareTo(new BigDecimal(100)) >= 0) continue;
            refMap.put(evalObj.getLong("id"), count);
        }
        return refMap;
    }

    public int getEntrySeq(String entity, Long id) {
        DynamicObject[] dynamicObjects = null;
        if ("epa_objgenareaind".equals(entity)) {
            dynamicObjects = OBJ_GEN_AREA_INS_ENTITY.queryAreaEntryById(id);
        } else if ("epa_objaddsubareaind".equals(entity)) {
            dynamicObjects = OBJ_ADD_SUB_AREA_INS_ENTITY.queryAreaEntryById(id);
        } else if ("epa_objattachareaind".equals(entity)) {
            dynamicObjects = OBJ_ATTACH_AREA_INS_ENTITY.queryAreaEntryById(id);
        }
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return 0;
        }
        DynamicObjectCollection dyc = dynamicObjects[0].getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (DynamicObject dy : dyc) {
            if (dy.getInt("seq") <= seq) continue;
            seq = dy.getInt("seq");
        }
        return seq;
    }

    public void saveObjCrossIndicator(DynamicObject[] evalObjs) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<DynamicObject> indicatorDyList = new ArrayList<DynamicObject>(10);
        for (DynamicObject evalObj2 : evalObjs) {
            List areaList;
            DynamicObjectCollection areaEntry = evalObj2.getDynamicObjectCollection("areaentry");
            if (ObjectUtils.isEmpty((Object)areaEntry) || ObjectUtils.isEmpty(areaList = areaEntry.stream().filter(areaInfo -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaInfo.getLong("areareg.id")) || AreaRegEnum.PLUS_MINUS_AREA.getAreaPkId().equals(areaInfo.getLong("areareg.id"))).collect(Collectors.toList()))) continue;
            ArrayList confList = new ArrayList(10);
            List<Long> confIds = areaList.stream().map(ins -> ins.getLong("areaconf")).collect(Collectors.toList());
            DynamicObject[] normalConfs = NORMAL_CONFIG_ENTITY_SERVICE.queryConfNameByPks(confIds);
            Arrays.stream(normalConfs).forEach(normalConf -> confList.add(normalConf));
            DynamicObject[] pMConfs = PLUS_MINUS_CONFIG_ENTITY_SERVICE.queryConfNameByPks(confIds);
            Arrays.stream(pMConfs).forEach(pMConf -> confList.add(pMConf));
            Map<Long, String> confNameMap = confList.stream().collect(Collectors.toMap(conf -> conf.getLong("id"), conf -> conf.getString("areacustname")));
            for (DynamicObject areaInfo2 : areaList) {
                Object[] indicatorDys;
                DynamicObject plusminusconf;
                boolean iscrossscore;
                long areaConfId = areaInfo2.getLong("areaconf");
                long areaReg = areaInfo2.getLong("areareg.id");
                long areaInstId = areaInfo2.getLong("areains");
                if (AreaRegEnum.PLUS_MINUS_AREA.getAreaPkId().equals(areaReg) && !(iscrossscore = (plusminusconf = BusinessDataServiceHelper.loadSingle((Object)areaConfId, (String)"epa_plusminusconf")) != null && plusminusconf.getBoolean("iscrossscore")) || ObjectUtils.isEmpty((Object[])(indicatorDys = APP_SERVICE.queryIndicator(areaInstId, AreaRegEnum.get((Long)areaReg))))) continue;
                for (Object indicatorDy : indicatorDys) {
                    if (AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaReg) && HRStringUtils.equals((String)EvalModeEnum.SYS_INPUT.getCode(), (String)indicatorDy.getString("evalmode"))) continue;
                    DynamicObject objCrossIndicator = OBJ_CROSS_INDICATOR_ENTITY_SERVICE.generateEmptyDynamicObject();
                    objCrossIndicator.set("createtime", (Object)date);
                    objCrossIndicator.set("modifytime", (Object)date);
                    objCrossIndicator.set("modifier", (Object)currUserId);
                    objCrossIndicator.set("creator", (Object)currUserId);
                    objCrossIndicator.set("person", (Object)evalObj2.getLong("person.id"));
                    objCrossIndicator.set("activity", (Object)evalObj2.getLong("activity.id"));
                    objCrossIndicator.set("assessyear", (Object)evalObj2.getInt("assessyear"));
                    objCrossIndicator.set("assessperiod", (Object)evalObj2.getString("assessperiod"));
                    objCrossIndicator.set("perforg", (Object)evalObj2.getLong("perforg.id"));
                    objCrossIndicator.set("actevalobj", (Object)evalObj2.getLong("id"));
                    if (!ObjectUtils.isEmpty(confNameMap)) {
                        objCrossIndicator.set("areaname", (Object)confNameMap.get(areaConfId));
                    }
                    objCrossIndicator.set("indicator", (Object)indicatorDy.getLong("id"));
                    objCrossIndicator.set("area", (Object)areaInstId);
                    objCrossIndicator.set("areareg", (Object)areaReg);
                    objCrossIndicator.set("indctrname", (Object)indicatorDy.getString("indctrname"));
                    objCrossIndicator.set("issetted", (Object)false);
                    indicatorDyList.add(objCrossIndicator);
                }
            }
        }
        List evalObjIds = Arrays.stream(evalObjs).map(evalObj -> evalObj.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("actevalobj", "in", evalObjIds);
        OBJ_CROSS_INDICATOR_ENTITY_SERVICE.deleteByFilter(new QFilter[]{qFilter});
        OBJ_CROSS_INDICATOR_ENTITY_SERVICE.save(indicatorDyList.toArray(new DynamicObject[0]));
    }

    public DynamicObject[] filterPerffileAssess(DynamicObject[] joinInAssessObjectLists, DynamicObject activityDynObj) {
        return (DynamicObject[])Arrays.stream(joinInAssessObjectLists).filter(joinInAssessObject -> this.comparePerffilePeriod((DynamicObject)joinInAssessObject, activityDynObj)).toArray(DynamicObject[]::new);
    }

    private boolean comparePerffilePeriod(DynamicObject joinInAssessObject, DynamicObject activityDynObj) {
        return true;
    }

    public void addEvaluationObjectsNoTX(DynamicObject[] assessObjectDynObjArr, DynamicObject activityDynObj, AbstractTask task) {
        DynamicObjectCollection flowEntryColl = this.getPerfWorkFlowEntryColl(activityDynObj);
        Map<String, Long> defaultWorkFlow = this.getDefaultWorkFlowMap(flowEntryColl);
        long assessFormId = activityDynObj.getLong("assessform.id");
        DynamicObject assessFormDynObj = assessFormId == 0L ? null : ASSESS_FORM_ENTITY.loadSingle(assessFormId);
        ArrayList<DynamicObject> needSaveEvaluationObjectList = new ArrayList<DynamicObject>(16);
        this.saveAreaInstanceAndSetAreaInstanceId(assessObjectDynObjArr, activityDynObj, defaultWorkFlow, needSaveEvaluationObjectList, assessFormDynObj);
        String desc = ResManager.loadKDString((String)"\u6b63\u5728\u4e3a\u60a8\u81ea\u52a8\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61...", (String)"ActivityEvaluationObjectDomainService_16", (String)"opmc-epa-business", (Object[])new Object[0]);
        this.setEvaluationObjectId(needSaveEvaluationObjectList);
        DynamicObject[] evaluationObjectArr = (DynamicObject[])this.saveEvaluationObject(needSaveEvaluationObjectList.toArray(new DynamicObject[0]));
        List<Long> evaluationObjIdList = Arrays.stream(evaluationObjectArr).map(evaluationObject -> evaluationObject.getLong("id")).collect(Collectors.toList());
        DynamicObject[] evaluationObjectSavedArr = this.getEvaluationObjectByIdList(evaluationObjIdList);
        this.preCreateEvaluationObjectProcessInstance(evaluationObjectSavedArr, defaultWorkFlow);
        activityDynObj.set("activitystatus", (Object)ActivityStatusEnum.EXECUTING.getValue());
        AssessActivityDomainService assessActivityDomainService = new AssessActivityDomainService();
        assessActivityDomainService.saveActivity(new DynamicObject[]{activityDynObj});
        List<Object> batchFlowTaskResultBoList = new ArrayList(10);
        batchFlowTaskResultBoList = this.preCreateEvaluationObjectProcessInstance(evaluationObjectSavedArr, defaultWorkFlow);
        if (evaluationObjectSavedArr.length <= 20) {
            this.saveEvaluationObject(evaluationObjectSavedArr);
        }
        if (evaluationObjectSavedArr.length > 20) {
            for (BatchFlowTaskResultBo batchFlowTaskResultBo : batchFlowTaskResultBoList) {
                StartProcessPublisher.publish((List)batchFlowTaskResultBo.getBatchTaskIdList(), (String)batchFlowTaskResultBo.getTaskType());
            }
        }
    }

    public DynamicObject queryActevalObj(Object pkId) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.queryOne(pkId);
    }

    public DynamicObject[] queryActevalObjs(Object[] pkIds) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(pkIds);
    }

    public boolean batchUpdateEvaluationObject(ReWriteEvalObjRequest request) {
        if (request.getTotalCount() == request.getFailureCount()) {
            return false;
        }
        Map<Long, Long> map = request.getReWriteEvalObjInfoList().stream().collect(Collectors.toMap(ReWriteEvalObjInfo2 -> ReWriteEvalObjInfo2.getEvalObjId(), ReWriteEvalObjInfo2 -> ReWriteEvalObjInfo2.getEvalObjId(), (key1, key2) -> key2));
        DynamicObject[] dynamicObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("evalflowins,formulateflowins", new QFilter[]{new QFilter("id", "in", map.keySet())});
        String workFlowType = request.getTaskType();
        Long ruProcId = null;
        for (DynamicObject activityEvaluationObject : dynamicObjects) {
            ruProcId = map.get(activityEvaluationObject.getLong("id"));
            if ("2".equals(workFlowType)) {
                activityEvaluationObject.set("evalflowins", (Object)ruProcId);
            }
            if (!"1".equals(workFlowType)) continue;
            activityEvaluationObject.set("formulateflowins", (Object)ruProcId);
        }
        Object[] result = ACTIVITY_EVALUATION_OBJECT_ENTITY.save(dynamicObjects);
        return result.length > 0;
    }

    public Map<Long, String> getPersonNameAndNumberByIds(List<Long> ids) {
        DynamicObject[] dynamicObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.queryPersonByObjIds(ids);
        return Arrays.asList(dynamicObjects).stream().collect(Collectors.toMap(dyc -> dyc.getLong("id"), dyc -> dyc.getString("person.name") + " " + dyc.getString("person.number")));
    }

    public void deleteAreaIndicator(DynamicObject[] evalObjArr) {
        List<DynamicObject> areaEntry = Arrays.stream(evalObjArr).flatMap(evalObj -> evalObj.getDynamicObjectCollection("areaentry").stream()).collect(Collectors.toList());
        APP_SERVICE.deleteAreaIndicator(areaEntry);
    }

    public DynamicObject getObjGenareaIns(Long id) {
        return OBJ_GEN_AREA_INS_ENTITY.loadSingle(id);
    }

    public DynamicObject getObjAddSubareaIns(Long id) {
        return OBJ_ADD_SUB_AREA_INS_ENTITY.loadSingle(id);
    }

    public DynamicObject getObjAttachareaIns(Long id) {
        return OBJ_ATTACH_AREA_INS_ENTITY.loadSingle(id);
    }

    public void saveImportScoreInd(DynamicObject[] evalObjs) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<DynamicObject> indicatorDyList = new ArrayList<DynamicObject>(10);
        for (DynamicObject evalObj2 : evalObjs) {
            List areaList;
            DynamicObjectCollection areaEntry = evalObj2.getDynamicObjectCollection("areaentry");
            if (ObjectUtils.isEmpty((Object)areaEntry) || ObjectUtils.isEmpty(areaList = areaEntry.stream().filter(areaInfo -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaInfo.getLong("areareg.id"))).collect(Collectors.toList()))) continue;
            List<Long> normalConfIds = areaList.stream().map(ins -> ins.getLong("areaconf")).collect(Collectors.toList());
            DynamicObject[] normalConfs = NORMAL_CONFIG_ENTITY_SERVICE.queryConfNameByPks(normalConfIds);
            Map<Long, String> confNameMap = Arrays.stream(normalConfs).collect(Collectors.toMap(conf -> conf.getLong("id"), conf -> conf.getString("areacustname")));
            for (DynamicObject areaInfo2 : areaList) {
                long areaConfId = areaInfo2.getLong("areaconf");
                long areaInstId = areaInfo2.getLong("areains");
                Object[] indicatorDys = APP_SERVICE.queryIndicator(areaInstId, AreaRegEnum.NORM_INDCTR_AREA);
                if (ObjectUtils.isEmpty((Object[])indicatorDys)) continue;
                for (Object indicatorDy : indicatorDys) {
                    if (!HRStringUtils.equals((String)EvalModeEnum.SYS_INPUT.getCode(), (String)indicatorDy.getString("evalmode"))) continue;
                    DynamicObject importScoreInd = IMPORT_SCORE_IND_ENTITY_SERVICE.generateEmptyDynamicObject();
                    importScoreInd.set("createtime", (Object)date);
                    importScoreInd.set("modifytime", (Object)date);
                    importScoreInd.set("modifier", (Object)currUserId);
                    importScoreInd.set("creator", (Object)currUserId);
                    importScoreInd.set("person", (Object)evalObj2.getLong("person.id"));
                    importScoreInd.set("activity", (Object)evalObj2.getLong("activity.id"));
                    importScoreInd.set("assessyear", (Object)evalObj2.getInt("assessyear"));
                    importScoreInd.set("assessperiod", (Object)evalObj2.getString("assessperiod"));
                    importScoreInd.set("perforg", (Object)evalObj2.getLong("perforg.id"));
                    importScoreInd.set("actevalobj", (Object)evalObj2.getLong("id"));
                    importScoreInd.set("iecs", (Object)indicatorDy.getLong("iecs"));
                    importScoreInd.set("affiliateadminorg", evalObj2.get("affiliateadminorg"));
                    importScoreInd.set("area", (Object)areaInstId);
                    importScoreInd.set("area", (Object)areaInstId);
                    importScoreInd.set("indicator", (Object)indicatorDy.getLong("id"));
                    if (!ObjectUtils.isEmpty(confNameMap)) {
                        importScoreInd.set("areaname", (Object)confNameMap.get(areaConfId));
                    }
                    importScoreInd.set("indicatorname", (Object)indicatorDy.getString("indctrname"));
                    importScoreInd.set("perffilenumber", (Object)evalObj2.getString("perffile.number"));
                    indicatorDyList.add(importScoreInd);
                }
            }
        }
        QFilter qFilter = new QFilter("actevalobj", "in", (Object)Arrays.stream(evalObjs).map(evalObj -> evalObj.getLong("id")).toArray());
        IMPORT_SCORE_IND_ENTITY_SERVICE.deleteByFilter(new QFilter[]{qFilter});
        IMPORT_SCORE_IND_ENTITY_SERVICE.save(indicatorDyList.toArray(new DynamicObject[0]));
    }

    public Map<Long, DynamicObject> queryEvalObjById(List<Long> evalObjectIdList) {
        DynamicObject[] dyArr;
        HashMap evalMap = Maps.newHashMapWithExpectedSize((int)16);
        QFilter idFilter = new QFilter("id", "in", evalObjectIdList);
        for (DynamicObject dy : dyArr = ACTIVITY_EVALUATION_OBJECT_ENTITY.queryOriginalArray("id , activity.id , evalflowins , evalfinishtype ", new QFilter[]{idFilter}, "modifytime desc")) {
            evalMap.put(dy.getLong("id"), dy);
        }
        return evalMap;
    }

    public DynamicObject[] queryActEvalObjPerffile(List<Long> evalObjIds) {
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.query("perffile.billno, perffile.name", new QFilter[]{new QFilter("id", "in", evalObjIds)});
    }

    public void updateNodeIndiToUnify(DynamicObject[] evalObjArr) {
        List areaEntry = Arrays.stream(evalObjArr).flatMap(evalObj -> evalObj.getDynamicObjectCollection("areaentry").stream()).collect(Collectors.toList());
        List areaList = areaEntry.stream().filter(areaInfo -> !AreaRegEnum.CUSTOM_AREA.getAreaPkId().equals(areaInfo.getLong("areareg.id"))).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(areaList)) {
            return;
        }
        ArrayList<Long> normalAreaInstList = new ArrayList<Long>(10);
        ArrayList<Long> addSubAreaInstList = new ArrayList<Long>(10);
        ArrayList<Long> attachAreaInstList = new ArrayList<Long>(10);
        for (DynamicObject areaInfo2 : areaList) {
            Long areaRegId = areaInfo2.getLong("areareg.id");
            Long areaInstId = areaInfo2.getLong("areains");
            AreaRegEnum areaRegEnum = AreaRegEnum.get((Long)areaRegId);
            if (areaRegEnum == AreaRegEnum.NORM_INDCTR_AREA) {
                normalAreaInstList.add(areaInstId);
                continue;
            }
            if (areaRegEnum == AreaRegEnum.PLUS_MINUS_AREA) {
                addSubAreaInstList.add(areaInstId);
                continue;
            }
            if (areaRegEnum != AreaRegEnum.ATTACH_AREA) continue;
            attachAreaInstList.add(areaInstId);
        }
        DynamicObject[] genAreaInds = GEN_AREA_INDICATOR_ENTITY.query("flowrunode,flowrutask,addnodeindex", this.getNodeIndFilter(normalAreaInstList));
        DynamicObject[] addSubAreaInds = ADD_SUB_AREA_INDICATOR_ENTITY.query("flowrunode,flowrutask,addnodeindex", this.getNodeIndFilter(addSubAreaInstList));
        DynamicObject[] attachAreaInds = ATTACH_AREA_INDICATOR_ENTITY.query("flowrunode,flowrutask,addnodeindex", this.getNodeIndFilter(attachAreaInstList));
        this.setUnifyValue(genAreaInds);
        this.setUnifyValue(addSubAreaInds);
        this.setUnifyValue(attachAreaInds);
        if (genAreaInds != null && genAreaInds.length > 0) {
            GEN_AREA_INDICATOR_ENTITY.update(genAreaInds);
        }
        if (addSubAreaInds != null && addSubAreaInds.length > 0) {
            ADD_SUB_AREA_INDICATOR_ENTITY.update(addSubAreaInds);
        }
        if (attachAreaInds != null && attachAreaInds.length > 0) {
            ATTACH_AREA_INDICATOR_ENTITY.update(attachAreaInds);
        }
    }

    private QFilter[] getNodeIndFilter(List<Long> areaInstList) {
        QFilter qFilter = new QFilter("flowrunode", "!=", (Object)0L).and("flowrunode", "is not null", null);
        return new QFilter[]{qFilter.and("instanceid", "in", areaInstList)};
    }

    private void setUnifyValue(DynamicObject[] areaInds) {
        if (areaInds == null) {
            return;
        }
        for (DynamicObject areaInd : areaInds) {
            areaInd.set("flowrunode", (Object)0L);
            areaInd.set("flowrutask", (Object)0L);
            areaInd.set("addnodeindex", (Object)0);
        }
    }

    public void backCompletedEvalObjStatus(Long activityId) {
        DynamicObject activityObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(activityId);
        DynamicObject perfWorkFlowDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryPerfWorkFlow(activityId);
        DynamicObjectCollection perfWorkflowEntryEntity = perfWorkFlowDy.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection oldNodes = activityObj.getDynamicObjectCollection("timeplanentry");
        if (CollectionUtils.isNotEmpty((Collection)perfWorkflowEntryEntity) && CollectionUtils.isNotEmpty((Collection)oldNodes)) {
            List newNodes = perfWorkflowEntryEntity.stream().filter(obj -> obj.getBoolean("isshow")).sorted(Comparator.comparing(obj -> obj.getInt("seq"))).collect(Collectors.toList());
            DynamicObject oldMaxNode = oldNodes.stream().max(Comparator.comparing(obj -> obj.getInt("seq"))).orElseGet(() -> (DynamicObject)oldNodes.get(oldNodes.size() - 1));
            if (newNodes.size() > oldNodes.size()) {
                DynamicObject[] evalObjs;
                long oldMaxNodeId = oldMaxNode.getDynamicObject("activity").getLong("id");
                QFilter assessstatusFilter = new QFilter("assessstaus", "=", (Object)AssessStausEnum.COMPLETED.getStatus());
                QFilter activityFilter = new QFilter("activity", "=", (Object)activityId);
                DynamicObject[] dynamicObjectArray = evalObjs = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id,assessstaus,assessnode,nodeindex,nodestatus,completetime", new QFilter[]{assessstatusFilter, activityFilter});
                int n = dynamicObjectArray.length;
                for (int i = 0; i < n; ++i) {
                    DynamicObject evalObj = dynamicObjectArray[i];
                    evalObj.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
                    evalObj.set("assessnode", (Object)oldMaxNodeId);
                    evalObj.set("nodeindex", (Object)oldNodes.size());
                    evalObj.set("nodestatus", (Object)"30");
                    evalObj.set("completetime", null);
                }
                ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evalObjs);
            }
            if (newNodes.size() < oldNodes.size()) {
                DynamicObject[] evalObjs;
                QFilter assessstatusFilter = new QFilter("nodestatus", "=", (Object)AssessStausEnum.COMPLETED.getStatus());
                QFilter assessnodeFilter = new QFilter("assessnode", "=", (Object)((DynamicObject)newNodes.get(newNodes.size() - 1)).getDynamicObject("node").getLong("id"));
                QFilter activityFilter = new QFilter("activity", "=", (Object)activityId);
                for (DynamicObject evalObj : evalObjs = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id,assessstaus,assessnode,nodeindex,nodestatus,completetime", new QFilter[]{assessstatusFilter, assessnodeFilter, activityFilter})) {
                    evalObj.set("assessstaus", (Object)AssessStausEnum.COMPLETED.getStatus());
                    evalObj.set("assessnode", (Object)0);
                    evalObj.set("nodeindex", (Object)0);
                    evalObj.set("nodestatus", (Object)"");
                    evalObj.set("completetime", null);
                }
                ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evalObjs);
            }
        }
    }

    private boolean changeNumAccuracy(DynamicObject copyFromAssessFormDy, DynamicObject copyToAssessFormDy) {
        String fromNumAccuracy = copyFromAssessFormDy.getString("numaccuracy");
        String toNumAccuracy = copyToAssessFormDy.getString("numaccuracy");
        return HRStringUtils.isNotEmpty((String)fromNumAccuracy) && HRStringUtils.isNotEmpty((String)toNumAccuracy) && Integer.parseInt(toNumAccuracy) < Integer.parseInt(fromNumAccuracy);
    }

    public CopyHisIndicatorTaskVo copyIndicatorArea(CopyHisIndicatorTaskBo copyHisIndicatorTaskBo) {
        DynamicObject[] copyToDynamicObjects = copyHisIndicatorTaskBo.getCopyToDynamicObjects();
        Map<Long, DynamicObject> copyFromDycMaps = copyHisIndicatorTaskBo.getCopyFromDycMaps();
        Map<Long, DynamicObject> toActivityAssessFromMaps = copyHisIndicatorTaskBo.getToActivityAssessFromMaps();
        Map<Long, Map<String, AreaNameMappingBo>> copyFromObjAreaMap = copyHisIndicatorTaskBo.getCopyFromObjAreaMap();
        Map<String, AreaNameMappingBo> copyToAreaMap = copyHisIndicatorTaskBo.getCopyToAreaMap();
        Map<Long, String> copyToAreaRegIdMap = copyHisIndicatorTaskBo.getCopyToAreaRegIdMap();
        List<Long> successObjList = copyHisIndicatorTaskBo.getSuccessObjList();
        ArrayList<String> msgList = new ArrayList<String>(16);
        HashSet<Long> successObjSet = new HashSet<Long>(16);
        HashSet<Long> haveFailObjSet = new HashSet<Long>(16);
        DynamicObject copyFromAssessFormDy = copyHisIndicatorTaskBo.getCopyFromAssessFormDy();
        DynamicObject copyToAssessFormDy = copyHisIndicatorTaskBo.getCopyToAssessFormDy();
        for (DynamicObject copyToDynamicObject : copyToDynamicObjects) {
            Long perffileId = copyToDynamicObject.getLong("perffile.id");
            DynamicObject copyFromDynamicObject = copyFromDycMaps.get(copyToDynamicObject.getLong("perffile.id"));
            if (HRObjectUtils.isEmpty(toActivityAssessFromMaps) || HRObjectUtils.isEmpty((Object)toActivityAssessFromMaps.get(copyToDynamicObject.getLong("activity.id"))) || HRObjectUtils.isEmpty((Object)copyFromAssessFormDy) || HRObjectUtils.isEmpty((Object)copyToAssessFormDy)) {
                String msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u7684\u8bc4\u4f30\u8868\u5355\u914d\u7f6e\u4e3a\u7a7a\u3002", (String)"ActivityEvaluationObjectDomainService_17", (String)"opmc-epa-business", (Object[])new Object[]{copyToDynamicObject.getString("person.name"), copyToDynamicObject.getString("person.number")});
                msgList.add(msg);
                haveFailObjSet.add(copyToDynamicObject.getLong("id"));
                continue;
            }
            boolean changeNumAccuracy = this.changeNumAccuracy(copyFromAssessFormDy, copyToAssessFormDy);
            Map<String, AreaNameMappingBo> copyFromAreaMap = copyFromObjAreaMap.get(perffileId);
            if (HRObjectUtils.isEmpty((Object)copyFromDynamicObject) || HRObjectUtils.isEmpty(copyFromAreaMap)) {
                String msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u4e0d\u5728\u6240\u9009\u5386\u53f2\u8003\u6838\u6d3b\u52a8\u4e2d\uff0c\u65e0\u6cd5\u590d\u5236\u5386\u53f2\u6307\u6807\u3002", (String)"ActivityEvaluationObjectDomainService_18", (String)"opmc-epa-business", (Object[])new Object[]{copyToDynamicObject.getString("person.name"), copyToDynamicObject.getString("person.number")});
                msgList.add(msg);
                haveFailObjSet.add(copyToDynamicObject.getLong("id"));
                continue;
            }
            DynamicObjectCollection copyToAreas = copyToDynamicObject.getDynamicObjectCollection("areaentry");
            for (DynamicObject copyToArea : copyToAreas) {
                Long areaRegId = copyToArea.getLong("areareg.id");
                Long confId = copyToArea.getLong("areaconf");
                String areaName = copyToAreaRegIdMap.get(confId);
                if (copyFromAreaMap.get(areaName) == null) {
                    String msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u8bc4\u4f30\u8868\u5355\u533a\u57df\u540d\u79f0\u201c{2}\u201d\u4e0e\u5386\u53f2\u8003\u6838\u6d3b\u52a8\u8bc4\u4f30\u8868\u5355\u533a\u57df\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"ActivityEvaluationObjectDomainService_45", (String)"opmc-epa-business", (Object[])new Object[]{copyToDynamicObject.getString("person.name"), copyToDynamicObject.getString("person.number"), areaName});
                    msgList.add(msg);
                    haveFailObjSet.add(copyToDynamicObject.getLong("id"));
                    continue;
                }
                AreaNameMappingBo fromAreaNameMappingBo = copyFromAreaMap.get(areaName);
                if (!HRObjectUtils.equals((Object)areaRegId, (Object)fromAreaNameMappingBo.getAreaEntry().getLong("areareg.id"))) {
                    String msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{2}\u201d\u7684\u7c7b\u578b\u4e0e\u5386\u53f2\u8003\u6838\u6d3b\u52a8\u8bc4\u4f30\u8868\u5355\u533a\u57df\u7684\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"ActivityEvaluationObjectDomainService_46", (String)"opmc-epa-business", (Object[])new Object[]{copyToDynamicObject.getString("person.name"), copyToDynamicObject.getString("person.number"), areaName});
                    msgList.add(msg);
                    haveFailObjSet.add(copyToDynamicObject.getLong("id"));
                    continue;
                }
                AreaNameMappingBo toAreaNameMappingBo = copyToAreaMap.get(areaName);
                DynamicObject fromArea = fromAreaNameMappingBo.getAreaEntry();
                String formId = AreaRegEnum.get((Long)areaRegId).getEvalObjAreaPageIdOfAssign();
                DynamicObject fromAreaConfig = fromAreaNameMappingBo.getAreaConfig();
                DynamicObject toAreaConfig = toAreaNameMappingBo.getAreaConfig();
                LOG.info("=============fromAreaConfig:{}==============", (Object)DynamicObjectUtil.serializeToMap((DynamicObject)fromAreaConfig));
                LOG.info("===============toAreaConfig:{}===============", (Object)DynamicObjectUtil.serializeToMap((DynamicObject)toAreaConfig));
                boolean checkFlag = true;
                switch (formId) {
                    case "epa_genareains_assign": {
                        DynamicObjectCollection configEntryEntity;
                        DynamicObject addNew;
                        int index;
                        DynamicObjectCollection fromEntryEntity;
                        DynamicObjectCollection toEntryEntity;
                        DynamicObject copyFromAreaObj;
                        DynamicObject copyToAreaObj;
                        DynamicObjectCollection fromEntryEntity2;
                        checkFlag = this.checkGenArea(msgList, copyToDynamicObject, copyToAssessFormDy, copyFromAssessFormDy, areaName, fromAreaConfig, toAreaConfig);
                        DynamicObject copyFromGenAreaObj = OBJ_GEN_AREAINS_ENTITY.loadSingle(fromArea.getLong("areains"));
                        if (checkFlag && this.checkIndicatorAreaData(msgList, copyToDynamicObject, areaName, fromEntryEntity2 = copyFromGenAreaObj.getDynamicObjectCollection("entryentity"))) {
                            haveFailObjSet.add(copyToDynamicObject.getLong("id"));
                            checkFlag = false;
                        }
                        if (checkFlag) {
                            copyToAreaObj = OBJ_GEN_AREAINS_ENTITY.loadSingle(copyToArea.getLong("areains"));
                            copyFromAreaObj = OBJ_GEN_AREAINS_ENTITY.loadSingle(fromArea.getLong("areains"));
                            copyToAreaObj.set("areaweight", (Object)this.getChangeNum(changeNumAccuracy, copyToAssessFormDy, copyFromAreaObj.getBigDecimal("areaweight")));
                            copyToAreaObj.set("areascore", (Object)this.getChangeNum(changeNumAccuracy, copyToAssessFormDy, copyFromAreaObj.getBigDecimal("areascore")));
                            copyToAreaObj.set("minareascore", (Object)this.getChangeNum(changeNumAccuracy, copyToAssessFormDy, copyFromAreaObj.getBigDecimal("minareascore")));
                            copyToAreaObj.set("maxareascore", (Object)this.getChangeNum(changeNumAccuracy, copyToAssessFormDy, copyFromAreaObj.getBigDecimal("maxareascore")));
                            toEntryEntity = copyToAreaObj.getDynamicObjectCollection("entryentity");
                            fromEntryEntity = copyFromGenAreaObj.getDynamicObjectCollection("entryentity");
                            toEntryEntity.clear();
                            index = 0;
                            for (DynamicObject dynamicObject : fromEntryEntity) {
                                addNew = toEntryEntity.addNew();
                                addNew.set("seq", (Object)index);
                                ++index;
                                configEntryEntity = toAreaConfig.getDynamicObjectCollection("entryentity");
                                for (DynamicObject config : configEntryEntity) {
                                    this.setIndicatorEntryField(changeNumAccuracy, copyToAssessFormDy, dynamicObject, addNew, config);
                                }
                                addNew.set("realweight", addNew.get("weight"));
                                addNew.set("iseditable", dynamicObject.get("iseditable"));
                                if (!toAreaConfig.getBoolean("reversepoints")) continue;
                                if (HRStringUtils.equals((String)toAreaConfig.getString("adjusttype"), (String)AdjustTypeEnum.NORMAL.getValue())) {
                                    addNew.set("minevalscore", (Object)toAreaConfig.getBigDecimal("lowerscore"));
                                    addNew.set("maxevalscore", (Object)toAreaConfig.getBigDecimal("upperscore"));
                                    continue;
                                }
                                addNew.set("minevalscore", (Object)this.getChangeNum(changeNumAccuracy, copyToAssessFormDy, dynamicObject.getBigDecimal("minevalscore")));
                                addNew.set("maxevalscore", (Object)this.getChangeNum(changeNumAccuracy, copyToAssessFormDy, dynamicObject.getBigDecimal("maxevalscore")));
                            }
                            OBJ_GEN_AREAINS_ENTITY.saveOne(copyToAreaObj);
                            successObjSet.add(copyToDynamicObject.getLong("id"));
                            break;
                        }
                        haveFailObjSet.add(copyToDynamicObject.getLong("id"));
                        break;
                    }
                    case "epa_addsubareains_assign": {
                        DynamicObjectCollection configEntryEntity;
                        DynamicObject addNew;
                        int index;
                        DynamicObjectCollection fromEntryEntity;
                        DynamicObjectCollection toEntryEntity;
                        DynamicObject copyFromAreaObj;
                        DynamicObject copyToAreaObj;
                        if (!(HRObjectUtils.equals((Object)fromAreaConfig.get("pluslimit"), (Object)toAreaConfig.get("pluslimit")) && HRObjectUtils.equals((Object)fromAreaConfig.get("minuslimit"), (Object)toAreaConfig.get("minuslimit")) && HRObjectUtils.equals((Object)fromAreaConfig.get("ispartin"), (Object)toAreaConfig.get("ispartin")) && HRObjectUtils.equals((Object)fromAreaConfig.get("iscrossscore"), (Object)toAreaConfig.get("iscrossscore")))) {
                            String msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{2}\u201d\u7684\u914d\u7f6e\u4e0e\u5386\u53f2\u8003\u6838\u6d3b\u52a8\u8bc4\u4f30\u8868\u5355\u533a\u57df\u7684\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"ActivityEvaluationObjectDomainService_47", (String)"opmc-epa-business", (Object[])new Object[]{copyToDynamicObject.getString("person.name"), copyToDynamicObject.getString("person.number"), areaName});
                            msgList.add(msg);
                            haveFailObjSet.add(copyToDynamicObject.getLong("id"));
                            checkFlag = false;
                        }
                        if (checkFlag) {
                            copyToAreaObj = OBJ_ADDSUB_AREAINS_ENTITY.loadSingle(copyToArea.getLong("areains"));
                            copyFromAreaObj = OBJ_ADDSUB_AREAINS_ENTITY.loadSingle(fromArea.getLong("areains"));
                            copyToAreaObj.set("minareascore", (Object)this.getChangeNum(changeNumAccuracy, copyToAssessFormDy, copyFromAreaObj.getBigDecimal("minareascore")));
                            copyToAreaObj.set("maxareascore", (Object)this.getChangeNum(changeNumAccuracy, copyToAssessFormDy, copyFromAreaObj.getBigDecimal("maxareascore")));
                            toEntryEntity = copyToAreaObj.getDynamicObjectCollection("entryentity");
                            fromEntryEntity = copyFromAreaObj.getDynamicObjectCollection("entryentity");
                            if (this.checkIndicatorAreaData(msgList, copyToDynamicObject, areaName, fromEntryEntity)) {
                                haveFailObjSet.add(copyToDynamicObject.getLong("id"));
                                break;
                            }
                            toEntryEntity.clear();
                            index = 0;
                            for (DynamicObject dynamicObject : fromEntryEntity) {
                                addNew = toEntryEntity.addNew();
                                addNew.set("seq", (Object)index);
                                ++index;
                                configEntryEntity = toAreaConfig.getDynamicObjectCollection("entryentity");
                                for (DynamicObject config : configEntryEntity) {
                                    this.setIndicatorEntryField(changeNumAccuracy, copyToAssessFormDy, dynamicObject, addNew, config);
                                }
                                addNew.set("iseditable", dynamicObject.get("iseditable"));
                            }
                            OBJ_ADDSUB_AREAINS_ENTITY.saveOne(copyToAreaObj);
                            successObjSet.add(copyToDynamicObject.getLong("id"));
                            break;
                        }
                        haveFailObjSet.add(copyToDynamicObject.getLong("id"));
                        break;
                    }
                    case "epa_attachareains_assign": {
                        DynamicObjectCollection configEntryEntity;
                        DynamicObject addNew;
                        DynamicObject copyToAreaObj = OBJ_ATTACH_AREAINS_ENTITY.loadSingle(copyToArea.getLong("areains"));
                        DynamicObject copyFromAreaObj = OBJ_ATTACH_AREAINS_ENTITY.loadSingle(fromArea.getLong("areains"));
                        DynamicObjectCollection toEntryEntity = copyToAreaObj.getDynamicObjectCollection("entryentity");
                        DynamicObjectCollection fromEntryEntity = copyFromAreaObj.getDynamicObjectCollection("entryentity");
                        if (this.checkIndicatorAreaData(msgList, copyToDynamicObject, areaName, fromEntryEntity)) {
                            haveFailObjSet.add(copyToDynamicObject.getLong("id"));
                            break;
                        }
                        toEntryEntity.clear();
                        int index = 0;
                        for (DynamicObject dynamicObject : fromEntryEntity) {
                            addNew = toEntryEntity.addNew();
                            addNew.set("seq", (Object)index);
                            ++index;
                            configEntryEntity = toAreaConfig.getDynamicObjectCollection("entryentity");
                            for (DynamicObject config : configEntryEntity) {
                                this.setIndicatorEntryField(changeNumAccuracy, copyToAssessFormDy, dynamicObject, addNew, config);
                            }
                        }
                        OBJ_ATTACH_AREAINS_ENTITY.saveOne(copyToAreaObj);
                        successObjSet.add(copyToDynamicObject.getLong("id"));
                        break;
                    }
                }
            }
        }
        successObjList.addAll(successObjSet);
        this.deleteGroup(successObjList);
        ArrayList<Long> success = new ArrayList<Long>(16);
        ArrayList<Long> halfSuccess = new ArrayList<Long>(16);
        for (Long aLong : successObjList) {
            if (haveFailObjSet.contains(aLong)) {
                halfSuccess.add(aLong);
                continue;
            }
            success.add(aLong);
        }
        return new CopyHisIndicatorTaskVo(success, halfSuccess, msgList);
    }

    private void deleteGroup(List<Long> objIds) {
        if (objIds != null && !objIds.isEmpty()) {
            DynamicObject[] evalDynamicObject = this.loadDynamicObjectArray(objIds.toArray(new Long[0]));
            this.deletePreinstallIndicator(evalDynamicObject);
            for (DynamicObject dynamicObject : evalDynamicObject) {
                dynamicObject.set("indigroup", (Object)0L);
            }
            this.saveEvaluationObject(evalDynamicObject);
        }
    }

    private void setIndicatorEntryField(boolean changeNumAccuracy, DynamicObject toActivityAssessFrom, DynamicObject dynamicObject, DynamicObject addNew, DynamicObject config) {
        String number = config.getString("areafield.number");
        String propType = config.getString("areafield.proptype");
        if (!addNew.getDynamicObjectType().getProperties().containsKey((Object)number)) {
            return;
        }
        if (FieldTypeEnum.Decimal.getValue().equals(propType) && changeNumAccuracy) {
            String numAccuracy = toActivityAssessFrom.getString("numaccuracy");
            String scaleType = toActivityAssessFrom.getString("scaletype");
            BigDecimal sumIndctrScore = dynamicObject.getBigDecimal(number);
            String score = sumIndctrScore.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get(scaleType).getType()).stripTrailingZeros().toPlainString();
            addNew.set(number, (Object)score);
        } else {
            addNew.set(number, dynamicObject.get(number));
        }
    }

    private BigDecimal getChangeNum(boolean changeNumAccuracy, DynamicObject toActivityAssessFrom, BigDecimal data) {
        if (changeNumAccuracy && data != null) {
            String numAccuracy = toActivityAssessFrom.getString("numaccuracy");
            String scaleType = toActivityAssessFrom.getString("scaletype");
            return data.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get(scaleType).getType()).stripTrailingZeros();
        }
        return data;
    }

    private boolean checkIndicatorAreaData(List<String> msgList, DynamicObject copyToDynamicObject, String areaName, DynamicObjectCollection fromEntryEntity) {
        if (fromEntryEntity == null || fromEntryEntity.isEmpty()) {
            String msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{2}\u201d\u4e0d\u5b58\u5728\u6307\u6807\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"ActivityEvaluationObjectDomainService_48", (String)"opmc-epa-business", (Object[])new Object[]{copyToDynamicObject.getString("person.name"), copyToDynamicObject.getString("person.number"), areaName});
            msgList.add(msg);
            return true;
        }
        return false;
    }

    private boolean checkGenArea(List<String> msgList, DynamicObject copyToDynamicObject, DynamicObject toActivityAssessFrom, DynamicObject fromActivityAssessFrom, String areaName, DynamicObject fromAreaConfig, DynamicObject toAreaConfig) {
        ScoreCalcWayEnum scoreCalcWay;
        String fromScoreCalcWayStr;
        boolean checkFlag = true;
        String scoreCalcWayStr = toActivityAssessFrom.getString("scorecalcway");
        if (!HRStringUtils.equals((String)scoreCalcWayStr, (String)(fromScoreCalcWayStr = fromActivityAssessFrom.getString("scorecalcway")))) {
            checkFlag = false;
            String msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{2}\u201d\u7684\u914d\u7f6e\u4e0e\u5386\u53f2\u8003\u6838\u6d3b\u52a8\u8bc4\u4f30\u8868\u5355\u533a\u57df\u7684\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"ActivityEvaluationObjectDomainService_47", (String)"opmc-epa-business", (Object[])new Object[]{copyToDynamicObject.getString("person.name"), copyToDynamicObject.getString("person.number"), areaName});
            msgList.add(msg);
        }
        if (HRObjectUtils.equals((Object)(scoreCalcWay = ScoreCalcWayEnum.getScoreCalcWay((String)scoreCalcWayStr)), (Object)ScoreCalcWayEnum.SUM)) {
            String msg;
            if (!(HRObjectUtils.equals((Object)fromAreaConfig.get("isalloweval"), (Object)toAreaConfig.get("isalloweval")) && HRObjectUtils.equals((Object)fromAreaConfig.get("ispartin"), (Object)toAreaConfig.get("ispartin")) && HRObjectUtils.equals((Object)fromAreaConfig.get("isforcedcontrol"), (Object)toAreaConfig.get("isforcedcontrol")) && HRObjectUtils.equals((Object)fromAreaConfig.get("areascore"), (Object)toAreaConfig.get("areascore")) && HRObjectUtils.equals((Object)fromAreaConfig.get("reversepoints"), (Object)toAreaConfig.get("reversepoints")))) {
                checkFlag = false;
                msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{2}\u201d\u7684\u914d\u7f6e\u4e0e\u5386\u53f2\u8003\u6838\u6d3b\u52a8\u8bc4\u4f30\u8868\u5355\u533a\u57df\u7684\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"ActivityEvaluationObjectDomainService_47", (String)"opmc-epa-business", (Object[])new Object[]{copyToDynamicObject.getString("person.name"), copyToDynamicObject.getString("person.number"), areaName});
                msgList.add(msg);
            }
            if (!(!checkFlag || !fromAreaConfig.getBoolean("reversepoints") || HRObjectUtils.equals((Object)fromAreaConfig.get("reversepoints"), (Object)toAreaConfig.get("reversepoints")) && HRObjectUtils.equals((Object)fromAreaConfig.get("adjusttype"), (Object)toAreaConfig.get("adjusttype")) && HRObjectUtils.equals((Object)fromAreaConfig.get("upperscore"), (Object)toAreaConfig.get("upperscore")) && HRObjectUtils.equals((Object)fromAreaConfig.get("lowerscore"), (Object)toAreaConfig.get("lowerscore")))) {
                checkFlag = false;
                msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{2}\u201d\u7684\u914d\u7f6e\u4e0e\u5386\u53f2\u8003\u6838\u6d3b\u52a8\u8bc4\u4f30\u8868\u5355\u533a\u57df\u7684\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"ActivityEvaluationObjectDomainService_47", (String)"opmc-epa-business", (Object[])new Object[]{copyToDynamicObject.getString("person.name"), copyToDynamicObject.getString("person.number"), areaName});
                msgList.add(msg);
            }
        } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT)) {
            String msg;
            if (!(HRObjectUtils.equals((Object)fromAreaConfig.get("isalloweval"), (Object)toAreaConfig.get("isalloweval")) && HRObjectUtils.equals((Object)fromAreaConfig.get("ispartin"), (Object)toAreaConfig.get("ispartin")) && HRObjectUtils.equals((Object)fromAreaConfig.get("isforcedcontrol"), (Object)toAreaConfig.get("isforcedcontrol")) && HRObjectUtils.equals((Object)fromAreaConfig.get("weight"), (Object)toAreaConfig.get("weight")) && HRObjectUtils.equals((Object)fromAreaConfig.get("scoresystem.id"), (Object)toAreaConfig.get("scoresystem.id")) && HRObjectUtils.equals((Object)fromAreaConfig.get("reversepoints"), (Object)toAreaConfig.get("reversepoints")))) {
                checkFlag = false;
                msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{2}\u201d\u7684\u914d\u7f6e\u4e0e\u5386\u53f2\u8003\u6838\u6d3b\u52a8\u8bc4\u4f30\u8868\u5355\u533a\u57df\u7684\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"ActivityEvaluationObjectDomainService_47", (String)"opmc-epa-business", (Object[])new Object[]{copyToDynamicObject.getString("person.name"), copyToDynamicObject.getString("person.number"), areaName});
                msgList.add(msg);
            }
            if (!(!checkFlag || !fromAreaConfig.getBoolean("reversepoints") || HRObjectUtils.equals((Object)fromAreaConfig.get("reversepoints"), (Object)toAreaConfig.get("reversepoints")) && HRObjectUtils.equals((Object)fromAreaConfig.get("adjusttype"), (Object)toAreaConfig.get("adjusttype")) && HRObjectUtils.equals((Object)fromAreaConfig.get("upperscore"), (Object)toAreaConfig.get("upperscore")) && HRObjectUtils.equals((Object)fromAreaConfig.get("lowerscore"), (Object)toAreaConfig.get("lowerscore")))) {
                checkFlag = false;
                msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{2}\u201d\u7684\u914d\u7f6e\u4e0e\u5386\u53f2\u8003\u6838\u6d3b\u52a8\u8bc4\u4f30\u8868\u5355\u533a\u57df\u7684\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"ActivityEvaluationObjectDomainService_47", (String)"opmc-epa-business", (Object[])new Object[]{copyToDynamicObject.getString("person.name"), copyToDynamicObject.getString("person.number"), areaName});
                msgList.add(msg);
            }
        }
        return checkFlag;
    }

    public ResponseResult startFormulateFlow(List<Long> evalObjectIds, int nodeIndex) {
        if (ObjectUtils.isEmpty(evalObjectIds)) {
            return ResponseResult.fail((Integer)200, (String)ResManager.loadKDString((String)"\u8981\u542f\u52a8\u7684\u8bc4\u4f30\u5bf9\u8c61ID[evalObjectIds]\u4e3a\u5fc5\u586b\u9879", (String)"ActivityEvaluationObjectDomainService_65", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        DynamicObject[] evalObjs = this.queryEvaluationObjectById(evalObjectIds);
        DynamicObject activityDy = evalObjs[0].getDynamicObject("activity");
        DynamicObject executeScheme = EXECUTE_SCHEME_ENTITY_SERVICE.queryOne(activityDy.getLong("executescheme.id"));
        String settingMode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(executeScheme.getLong("perfworkflow.id")), "1");
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        Tuple<List<DynamicObject>, String> checkResult = this.validateBeforeStart(evalObjs, resultMap);
        List evalObjPassList = (List)checkResult.item1;
        if (ObjectUtils.isEmpty((Object)evalObjPassList)) {
            return ResponseResult.fail((Integer)200, resultMap);
        }
        this.updateEvalObjStartStatus(evalObjectIds, "20");
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        String batchNo = BATCH_FLOW_TASK_SERVICE.requireBatchNoByBatchTask(TaskTypeEnum.INDICATOR_START);
        ArrayList<DynamicObject> activityRecordList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < evalObjPassList.size(); ++i) {
            DynamicObject evalObj = (DynamicObject)evalObjPassList.get(i);
            FlowRuResultBo flowRuResultBo = this.startProcess(evalObj, settingMode, batchNo);
            if (flowRuResultBo == null) {
                String personDesc = evalObj.getString("person.name") + " " + evalObj.getString("person.number") + ": ";
                String reason = ResManager.loadKDString((String)"{0}\u8c03\u7528\u542f\u52a8\u6307\u6807\u5236\u5b9a\u5de5\u4f5c\u6d41\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\u3002", (String)"ActivityEvaluationObjectDomainService_24", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                long evalObjId = evalObj.getLong("id");
                resultMap.put(evalObjId, reason);
                continue;
            }
            this.updateEvalObj(nodeIndex, date, userId, evalObj);
            activityRecordList.add(this.getActivityRecord(nodeIndex, evalObj, date, userId));
        }
        this.saveEvaluationObject(evalObjs);
        this.updateEvalObjStartStatus(evalObjectIds, "10");
        if (!ObjectUtils.isEmpty(activityRecordList)) {
            ACTIVITY_RECORD_ENTITY.save(activityRecordList.toArray(new DynamicObject[0]));
            SendMessageDTO SendMessageDTO2 = new SendMessageDTO(batchNo, new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.START_FORMULATE_SIN, FlowRuMsgMergeEnum.START_FORMULATE_MUL));
            FLOW_HANDLER_BATCH_DOMAIN_SERVICE.sendMessageMerge(Collections.singletonList(SendMessageDTO2));
        }
        return ResponseResult.success(resultMap);
    }

    private Tuple<List<DynamicObject>, String> validateBeforeStart(DynamicObject[] evalObjs, Map<Long, String> resultMap) {
        DynamicObject activityDy = evalObjs[0].getDynamicObject("activity");
        DynamicObject executeScheme = EXECUTE_SCHEME_ENTITY_SERVICE.queryOne(activityDy.getLong("executescheme.id"));
        DynamicObject assessform = executeScheme.getDynamicObject("assessform");
        String assFormat = assessform.getString("scorecalcway");
        String settingMode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(executeScheme.getLong("perfworkflow.id")), "1");
        DynamicObject scoreSystemDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryScoreSystemByActId(activityDy.getLong("id"));
        BigDecimal maxScoreOfSystem = scoreSystemDy.getBigDecimal("maxscore");
        BigDecimal limitMaxScore = this.getBigLimitMaxSore(activityDy, maxScoreOfSystem);
        Map<Long, DynamicObject> areaInstanceMap = EVALUATION_OBJECT_APPLICATION_SERVICE.queryEvaluationGenAreaInstance(Arrays.asList(evalObjs));
        String target = HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) ? "weight" : "indctrscore";
        Map<Long, BigDecimal> normalAreaSumMap = EVALUATION_OBJECT_APPLICATION_SERVICE.getNormalAreaSumMap(evalObjs, areaInstanceMap, target);
        Map<Long, Long> areaSumScoreMap = EVALUATION_OBJECT_APPLICATION_SERVICE.getNormalAreaSumGtMap(evalObjs, areaInstanceMap, assFormat);
        BigDecimal compareVal = HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) ? new BigDecimal(100) : maxScoreOfSystem;
        Map<Long, BigDecimal> areaScoreNotEqMap = EVALUATION_OBJECT_APPLICATION_SERVICE.getAreaScoreNotEqMap(evalObjs, compareVal, areaInstanceMap, assFormat);
        Map<Long, Boolean> checkForcedControlZeroMap = EVALUATION_OBJECT_APPLICATION_SERVICE.checkForcedControlZeroMap(evalObjs, HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) ? "areaweight" : "areascore", HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) ? new BigDecimal(100) : limitMaxScore);
        List flowIds = Arrays.stream(evalObjs).map(evalObject -> evalObject.getLong("formulateflowins.id")).collect(Collectors.toList());
        FlowCommonResultBo flowCommonResultBo = FLOW_RU_PROC_DOMAIN_SERVICE.verifyHandlerBeforeStartProcess(flowIds);
        ArrayList<DynamicObject> evalObjPassList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < evalObjs.length; ++i) {
            String reason;
            String reason2;
            DynamicObject evalObj = evalObjs[i];
            long evalObjId = evalObj.getLong("id");
            String personDesc = evalObj.getString("person.name") + " " + evalObj.getString("person.number") + ": ";
            if (!HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessStausEnum.JOINED.getStatus())) {
                reason2 = ResManager.loadKDString((String)"{0}\u5236\u5b9a\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u5f85\u5236\u5b9a\u201d\uff0c\u4e0d\u80fd\u542f\u52a8\u5236\u5b9a\u6d41\u7a0b", (String)"ActivityEvaluationObjectDomainService_25", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                resultMap.put(evalObjId, reason2);
                continue;
            }
            if (evalObj.getLong("formulateflowins.id") == 0L) {
                reason2 = ResManager.loadKDString((String)"{0}\u6b63\u5728\u9884\u5b9e\u4f8b\u5316\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"ActivityEvaluationObjectDomainService_49", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                resultMap.put(evalObjId, reason2);
                continue;
            }
            String startStatus = evalObj.getString("startstatus");
            if (HRStringUtils.equals((String)startStatus, (String)"20")) {
                String reason3 = ResManager.loadKDString((String)"{0}\u5236\u5b9a\u5bf9\u8c61\u7684\u6307\u6807\u5236\u5b9a\u4efb\u52a1\u5df2\u542f\u52a8\u6216\u5df2\u5b8c\u6210\u3002", (String)"ActivityEvaluationObjectDomainService_27", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                resultMap.put(evalObjId, reason3);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)evalObj.getDynamicObject("formulateflow"))) {
                String reason4 = ResManager.loadKDString((String)"{0}\u672a\u914d\u7f6e\u6d41\u7a0b\u3002", (String)"ActivityEvaluationObjectDomainService_28", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                resultMap.put(evalObjId, reason4);
                continue;
            }
            if (HRStringUtils.equals((String)settingMode, (String)"20")) {
                List roleCheckList = (List)flowCommonResultBo.getMsgMap().get(evalObjId);
                if (HRStringUtils.equals((String)flowCommonResultBo.getCode(), (String)"-1") && !ObjectUtils.isEmpty((Object)roleCheckList)) {
                    String reason5 = personDesc + ((Map)roleCheckList.get(0)).values().toString();
                    resultMap.put(evalObjId, reason5);
                    continue;
                }
            }
            boolean hasFormulateNode = this.hasFormulateNode(executeScheme, evalObj);
            if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode())) {
                BigDecimal sumWeightScore;
                BigDecimal bigDecimal = sumWeightScore = normalAreaSumMap.get(evalObjId) == null ? new BigDecimal(0) : normalAreaSumMap.get(evalObjId);
                if (checkForcedControlZeroMap.get(evalObjId) != null && checkForcedControlZeroMap.get(evalObjId).booleanValue()) {
                    reason = ResManager.loadKDString((String)"{0}\u533a\u57df\u5408\u8ba1\u6743\u91cd\u9700=100%\u3002", (String)"ActivityEvaluationObjectDomainService_30", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    resultMap.put(evalObjId, reason);
                    continue;
                }
                if (sumWeightScore.compareTo(new BigDecimal(100)) > 0) {
                    reason = ResManager.loadKDString((String)"{0}\u533a\u57df\u5408\u8ba1\u6743\u91cd\u9700=100%\u3002", (String)"ActivityEvaluationObjectDomainService_30", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    resultMap.put(evalObjId, reason);
                    continue;
                }
                if (!hasFormulateNode && sumWeightScore.compareTo(new BigDecimal(100)) < 0) {
                    reason = ResManager.loadKDString((String)"{0}\u5df2\u5236\u5b9a\u6307\u6807\u6743\u91cd\u672a\u8fbe\u5230100%\uff0c\u4f46\u6240\u9009\u62e9\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\u672a\u6709\u201c\u5236\u5b9a\u201d\u8282\u70b9\u3002", (String)"ActivityEvaluationObjectDomainService_31", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    resultMap.put(evalObjId, reason);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaSumScoreMap.get(evalObjId))) {
                    reason = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u6743\u91cd\u9700\u2264\u533a\u57df\u6743\u91cd\u3002", (String)"ActivityEvaluationObjectDomainService_32", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    resultMap.put(evalObjId, reason);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaScoreNotEqMap.get(evalObjId))) {
                    reason = ResManager.loadKDString((String)"{0}\u533a\u57df\u6743\u91cd\u5168\u90e8\u5927\u4e8e0\u65f6\uff0c\u533a\u57df\u5408\u8ba1\u6743\u91cd\u9700=100%\u3002", (String)"ActivityEvaluationObjectDomainService_33", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    resultMap.put(evalObjId, reason);
                    continue;
                }
            } else {
                BigDecimal sumIndctrScore;
                BigDecimal bigDecimal = sumIndctrScore = normalAreaSumMap.get(evalObjId) == null ? new BigDecimal(0) : normalAreaSumMap.get(evalObjId);
                if (checkForcedControlZeroMap.get(evalObjId) != null && checkForcedControlZeroMap.get(evalObjId).booleanValue()) {
                    reason = ResManager.loadKDString((String)"{0}\u533a\u57df\u5408\u8ba1\u5206\u503c\u9700=\u57fa\u51c6\u6700\u9ad8\u5206\u3002", (String)"ActivityEvaluationObjectDomainService_1", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    resultMap.put(evalObjId, reason);
                    continue;
                }
                if (sumIndctrScore.compareTo(limitMaxScore) > 0) {
                    reason = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u5206\u503c\u9700\u2264\u533a\u57df\u5206\u503c\u3002", (String)"ActivityEvaluationObjectDomainService_34", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    resultMap.put(evalObjId, reason);
                    continue;
                }
                if (!hasFormulateNode && sumIndctrScore.compareTo(maxScoreOfSystem) < 0) {
                    reason = ResManager.loadKDString((String)"{0}\u5df2\u5236\u5b9a\u6307\u6807\u5206\u503c\u7d2f\u8ba1\u672a=\u57fa\u51c6\u6700\u9ad8\u5206\uff0c\u4f46\u6240\u9009\u62e9\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\u672a\u6709\u201c\u5236\u5b9a\u201d\u8282\u70b9\u3002", (String)"ActivityEvaluationObjectDomainService_35", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    resultMap.put(evalObjId, reason);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaSumScoreMap.get(evalObjId))) {
                    reason = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u5206\u503c\u9700=\u533a\u57df\u5206\u503c\u3002", (String)"ActivityEvaluationObjectDomainService_36", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    resultMap.put(evalObjId, reason);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaScoreNotEqMap.get(evalObjId))) {
                    reason = ResManager.loadKDString((String)"{0}\u533a\u57df\u5408\u8ba1\u5206\u503c\u9700=\u57fa\u51c6\u6700\u9ad8\u5206\u3002", (String)"ActivityEvaluationObjectDomainService_1", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    resultMap.put(evalObjId, reason);
                    continue;
                }
            }
            evalObjPassList.add(evalObj);
        }
        return Tuple.create(evalObjPassList, (Object)"");
    }

    protected void updateEvalObjStartStatus(List<Long> evalObjectIds, String status) {
        DynamicObject[] startingObj = this.queryEvalObjStatusById(evalObjectIds);
        Arrays.stream(startingObj).forEach(evalObj -> evalObj.set("startstatus", (Object)status));
        this.saveEvaluationObject(startingObj);
    }

    private boolean hasFormulateNode(DynamicObject executeScheme, DynamicObject evalObj) {
        HashMap<Long, Long> flowIdMap = new HashMap<Long, Long>(16);
        long flowVid = evalObj.getLong("formulateflow.id");
        flowIdMap.put(flowVid, executeScheme.getLong("perfworkflow.id"));
        List workflowBoList = FLOW_DEF_PROC_DOMAIN_SERVICE.getWorkflowDefByID(flowIdMap);
        if (ObjectUtils.isEmpty((Object)workflowBoList)) {
            return false;
        }
        List flowdefNodeBoList = ((WorkflowBo)workflowBoList.get(0)).getFlowdefNodeBoList();
        if (ObjectUtils.isEmpty((Object)flowdefNodeBoList)) {
            return false;
        }
        DynamicObject flowdefNodeDyn = ((FlowDefNodeBo)flowdefNodeBoList.get(0)).getFlowdefNodeDyn();
        return flowdefNodeDyn.getLong("nodetype.id") == NodeTypeConstants.INDICATOR_FORMULATE.longValue();
    }

    private BigDecimal getBigLimitMaxSore(DynamicObject activityDy, BigDecimal maxScoreOfSystem) {
        DynamicObject schemeDy = EXECUTE_SCHEME_ENTITY_SERVICE.queryOne(activityDy.getLong("executescheme.id"));
        DynamicObject assessFormDy = schemeDy.getDynamicObject("assessform");
        return assessFormDy.getBoolean("allowexceedupper") ? assessFormDy.getBigDecimal("limitmaxscore") : maxScoreOfSystem;
    }

    private FlowRuProcBo buildEvaluationProcBo(DynamicObject evaluationObj, String settingMode, String batchNo) {
        long flowVid = evaluationObj.getLong("formulateflow.id");
        DynamicObject person = evaluationObj.getDynamicObject("person");
        Integer assessYear = evaluationObj.getInt("assessyear");
        String assessPeriod = evaluationObj.getString("assessperiod");
        long actEvalObjId = evaluationObj.getLong("id");
        DynamicObject activityDy = evaluationObj.getDynamicObject("activity");
        DynamicObject schemeDy = ASSESS_SCHEME_APPLICATION_SERVICE.queryOneById(activityDy.getLong("scheme.id"));
        long perfOrgId = schemeDy.getLong("createorg.id");
        long adminOrgId = schemeDy.getLong("adminorg.id");
        long activityId = evaluationObj.getLong("activity.id");
        long empPosRelId = evaluationObj.getLong("empposrel.id");
        return FlowRuProcBo.builder().flowVid(Long.valueOf(flowVid)).person(person).perfOrgId(Long.valueOf(perfOrgId)).adminOrgId(Long.valueOf(adminOrgId)).assessYear(assessYear).assessPeriod(assessPeriod).actEvalObjId(Long.valueOf(actEvalObjId)).activityId(Long.valueOf(activityId)).empPosRelId(Long.valueOf(empPosRelId)).settingMode(settingMode).workflowType("1").batchNo(batchNo).build();
    }

    private void updateEvalObj(int nodeIndex, Date date, long userId, DynamicObject evaluationObj) {
        evaluationObj.set("modifier", (Object)userId);
        evaluationObj.set("modifytime", (Object)date);
        evaluationObj.set("assessnode", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
        evaluationObj.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
        evaluationObj.set("nodeindex", (Object)nodeIndex);
        evaluationObj.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus());
    }

    public void setFormulateGroup(Long indicatorGroupId, List<Long> evalObjectIdList) {
        DynamicObject indiGroup = INDICATOR_GROUP_ENTITY_SERVICE.queryOne(indicatorGroupId);
        DynamicObject[] evalObjArr = this.queryEvaluationObjectById(evalObjectIdList);
        this.initEvalObjAssessTableFromIndicatorGroup(indiGroup, evalObjArr);
    }

    private FlowRuResultBo startProcess(DynamicObject evaluationObj, String settingMode, String batchNo) {
        LOG.info(" ----------\u3010\u542f\u52a8\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\u3011\u5f00\u59cb\u6267\u884c----------");
        FlowRuProcBo flowRuProcBo = this.buildEvaluationProcBo(evaluationObj, settingMode, batchNo);
        if (flowRuProcBo.getActEvalObjId() == 0L || flowRuProcBo.getActivityId() == 0L || flowRuProcBo.getAdminOrgId() == 0L || flowRuProcBo.getFlowVid() == 0L || flowRuProcBo.getPerfOrgId() == 0L || HRStringUtils.isEmpty((String)flowRuProcBo.getAssessPeriod()) || flowRuProcBo.getAssessYear() == 0 || ObjectUtils.isEmpty((Object)flowRuProcBo.getPerson())) {
            LOG.error("\u542f\u52a8\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\u65f6\u6570\u636e\u6709\u8bef\uff0c\u65e0\u6cd5\u542f\u52a8\u6d41\u7a0b\uff0cFlowRuProcBo:[{}]", (Object)flowRuProcBo.toString());
            return null;
        }
        return FLOW_RU_PROC_DOMAIN_SERVICE.startProcess(flowRuProcBo);
    }

    public void saveEvaluationObject(List<Long> perfileIds, Long assessActivityPkId) {
        DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(assessActivityPkId);
        String selectors = "person,empposrel,employee,affiliateadminorg,startdate,enddate,pmdorg";
        DynamicObject[] assessObjectJoinInCol = PERF_FILE_APPLICATION_SERVICE.getPerffileListByIds(selectors, perfileIds);
        DynamicObjectCollection assessObjectJoinInList = new DynamicObjectCollection();
        Arrays.stream(assessObjectJoinInCol).forEach(data -> assessObjectJoinInList.add(data));
        this.saveAssessObjectAndEvaluationObject(activityDynObj, assessObjectJoinInList);
    }

    private void saveAssessObjectAndEvaluationObject(DynamicObject curActivityDynObj, DynamicObjectCollection assessObjectJoinInList) {
        long schemeId = curActivityDynObj.getLong("scheme.id");
        long executeSchemeAssessScopeId = curActivityDynObj.getLong("executescheme.assessscope.id");
        DynamicObjectCollection assessObjectEntryEntity = this.genAssessObjectEntryEntity(assessObjectJoinInList, schemeId, executeSchemeAssessScopeId);
        DynamicObject[] assessObjectArr = ASSESS_OBJECT_APPLICATION_SERVICE.saveAssessObject(schemeId, assessObjectEntryEntity, curActivityDynObj);
        this.addEvaluationObjects(assessObjectArr, curActivityDynObj);
    }

    private DynamicObjectCollection genAssessObjectEntryEntity(DynamicObjectCollection assessObjectJoinInList, long schemeId, long executeSchemeAssessScopeId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"epa_assessobject_joinin");
        DynamicObject emptyJonInDynObj = new DynamicObject((DynamicObjectType)dataEntityType);
        Object[] assessGroupArr = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssessGroupArr(schemeId, executeSchemeAssessScopeId);
        Object assessGroup = null;
        for (DynamicObject dynamicObject : assessGroupArr) {
            if (!dynamicObject.getBoolean("isdefault")) continue;
            assessGroup = dynamicObject;
            break;
        }
        if (assessGroup == null && !HRArrayUtils.isEmpty((Object[])assessGroupArr) && assessGroupArr.length > 0) {
            assessGroup = assessGroupArr[0];
        }
        DynamicObjectCollection assessObjectEntryEntity = emptyJonInDynObj.getDynamicObjectCollection("assessobjectentryentity");
        for (DynamicObject perfFileDynObj : assessObjectJoinInList) {
            DynamicObject dynamicObject = assessObjectEntryEntity.addNew();
            dynamicObject.set("perffile", (Object)perfFileDynObj);
            dynamicObject.set("group", (Object)(assessGroup == null ? 0L : assessGroup.getLong("id")));
            dynamicObject.set("assessscope", (Object)(assessGroup == null ? 0L : assessGroup.getLong("objectscope.id")));
            dynamicObject.set("person", (Object)perfFileDynObj.getDynamicObject("person"));
            dynamicObject.set("empposorgrel", (Object)perfFileDynObj.getDynamicObject("empposrel"));
            dynamicObject.set("employee", (Object)perfFileDynObj.getDynamicObject("employee"));
        }
        return assessObjectEntryEntity;
    }

    public DynamicObject[] getUnifiedDistEvalObj() {
        List<Long> evalObjectIds = ACTIVITY_RECORD_ENTITY.queryUnifiedDistEvalObj();
        return this.queryEvaluationObjectById(evalObjectIds);
    }

    public ResponseResult copyIndicatorToEvalObj(Long sourceActivityId, Long targetActivityId) {
        Object[] sourceObjArr = this.queryEvaluationObjectByActivityId(sourceActivityId);
        if (ObjectUtils.isEmpty((Object[])sourceObjArr)) {
            return ResponseResult.fail((Integer)200, (String)ResManager.loadKDString((String)"[\u6e90\u8003\u6838\u6d3b\u52a8]\u4e0b\u4e0d\u5b58\u5728\u8bc4\u4f30\u5bf9\u8c61", (String)"ActivityEvaluationObjectDomainService_66", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        Object[] targetObjArr = this.queryEvaluationObjectByActivityId(targetActivityId);
        if (ObjectUtils.isEmpty((Object[])targetObjArr)) {
            return ResponseResult.fail((Integer)200, (String)ResManager.loadKDString((String)"[\u76ee\u6807\u8003\u6838\u6d3b\u52a8]\u4e0b\u4e0d\u5b58\u5728\u8bc4\u4f30\u5bf9\u8c61", (String)"ActivityEvaluationObjectDomainService_67", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        List<DynamicObject> targetObjList = Arrays.stream(targetObjArr).filter(obj -> obj.getString("assessstaus").equals(AssessStausEnum.JOINED.getStatus())).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(targetObjList)) {
            return ResponseResult.fail((Integer)200, (String)ResManager.loadKDString((String)"[\u76ee\u6807\u8003\u6838\u6d3b\u52a8]\u4e0b\u4e0d\u5b58\u5728[\u8003\u6838\u72b6\u6001]\u4e3a[\u672a\u5f00\u59cb]\u7684\u8bc4\u4f30\u5bf9\u8c61", (String)"ActivityEvaluationObjectDomainService_68", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        this.copyIndicatorToEvalObj((DynamicObject[])sourceObjArr, targetObjList.toArray(new DynamicObject[0]));
        return ResponseResult.success((String)"copyIndicatorToEvalObj success!!!");
    }

    public DynamicObject[] queryEvaluationObjectByActivityId(Long activityId) {
        String selectFields = "assessstaus, indigroup, assweight, assscore, perffile,evalflow,evalflow.boid,person, perffile.pmdperson,perffile.billno,perffile.name,perffile.number,perffile.position.name,perffile.job.name, assgroup, indicatortype, assignuser, activity, affiliateadminorg, perforg, empposrel.position, modifytime, assessyear,sop, lop, sopsource,fsop,flop, fsopsource, cfsop, cflop, cfsopsource,assessperiod, empposrel, assessnode, nodestatus, creator, createtime, modifier, modifytime, evalflowentry, nodeindex, evalflowentry.evalflowru, activity.activitystatus, activity.perfworkflowactivity.period,activity.year,evalflowins,formulateflowins,evalflowentry.evalflowdef, evalflowentry.evalflowinfo, evalflowentry.evalevalarea, formulateflow,formulateflow.id,areaentry.areareg, areaentry.areains, areaentry.areaconf,startstatus,isincalc";
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.queryActivityEvaluationObjectActivityId(selectFields, activityId);
    }

    public void copyIndicatorToEvalObj(DynamicObject[] sourceObjDys, DynamicObject[] targetObjDys) {
        HashMap<Long, List<DynamicObject>> allAreaInstanceColl = new HashMap<Long, List<DynamicObject>>(16);
        block0: for (DynamicObject targetObjDy : targetObjDys) {
            String targetPerfNum = targetObjDy.getString("perffile.number");
            for (DynamicObject sourceObjDy : sourceObjDys) {
                String sourcePerfNum = sourceObjDy.getString("perffile.number");
                if (!HRStringUtils.equals((String)targetPerfNum, (String)sourcePerfNum)) continue;
                targetObjDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
                targetObjDy.set("modifytime", (Object)new Date());
                targetObjDy.set("assweight", sourceObjDy.get("assweight"));
                targetObjDy.set("assscore", sourceObjDy.get("assscore"));
                this.putAreaInstance(allAreaInstanceColl, this.copyAreaInstanceToEvalObj(sourceObjDy, targetObjDy));
                continue block0;
            }
        }
        this.saveEvalObject(targetObjDys, allAreaInstanceColl);
    }

    public Map<Long, List<DynamicObject>> copyAreaInstanceToEvalObj(DynamicObject sourceObjDy, DynamicObject targetObjDy) {
        HashMap<Long, List<DynamicObject>> areaInstanceColl = new HashMap<Long, List<DynamicObject>>(16);
        DynamicObjectCollection sourceObjAreaEntry = sourceObjDy.getDynamicObjectCollection("areaentry");
        DynamicObjectCollection targetObjAreaEntry = targetObjDy.getDynamicObjectCollection("areaentry");
        List sourceObjAreaList = sourceObjAreaEntry.stream().filter(indArea -> !AreaRegEnum.CUSTOM_AREA.getAreaPkId().equals(indArea.getLong("areareg.id"))).collect(Collectors.toList());
        List targetObjAreaList = targetObjAreaEntry.stream().filter(indArea -> !AreaRegEnum.CUSTOM_AREA.getAreaPkId().equals(indArea.get("areareg.id"))).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(sourceObjAreaList) || ObjectUtils.isEmpty(targetObjAreaList) || sourceObjAreaList.size() != targetObjAreaList.size()) {
            return new HashMap<Long, List<DynamicObject>>(16);
        }
        Map<Long, Long> sourceAreaMap = sourceObjAreaList.stream().collect(Collectors.toMap(area -> area.getLong("areaconf"), area -> area.getLong("areains")));
        List<Long> sourceAreaConfIds = sourceObjAreaList.stream().map(area -> area.getLong("areaconf")).collect(Collectors.toList());
        List<Long> targetAreaConfIds = targetObjAreaList.stream().map(area -> area.getLong("areaconf")).collect(Collectors.toList());
        List<DynamicObject> sourceAreaConfEntry = this.queryAssFormConfEntryByConfIds(sourceAreaConfIds);
        List<DynamicObject> targetAreaConfEntry = this.queryAssFormConfEntryByConfIds(targetAreaConfIds);
        Map<Long, Long> sourceSourceConfMap = sourceAreaConfEntry.stream().collect(Collectors.toMap(conf -> conf.getLong("source"), conf -> conf.getLong("areaconf"), (oldVal, newVal) -> oldVal));
        Map<Long, Long> targetSourceConfMap = targetAreaConfEntry.stream().collect(Collectors.toMap(conf -> conf.getLong("areaconf"), conf -> conf.getLong("source"), (oldVal, newVal) -> oldVal));
        for (DynamicObject targetObjArea : targetObjAreaList) {
            long areaRegId = targetObjArea.getLong("areareg.id");
            long targetAreaInstId = targetObjArea.getLong("areains");
            long areaConfId = targetObjArea.getLong("areaconf");
            Long sourceId = targetSourceConfMap.get(areaConfId);
            Long sourceAreaConfId = sourceSourceConfMap.get(sourceId);
            Long sourceAreaInstId = sourceAreaMap.get(sourceAreaConfId);
            DynamicObject areaInstance = this.copyAreaInstance(targetObjDy.getDynamicObject("activity"), areaRegId, sourceAreaInstId, targetAreaInstId);
            if (areaInstance == null) continue;
            areaInstance.set("areaactevalobj", (Object)targetObjDy.getLong("id"));
            areaInstance.set("areaassessyear", (Object)targetObjDy.getInt("assessyear"));
            areaInstance.set("areaassessperiod", (Object)targetObjDy.getString("assessperiod"));
            areaInstance.set("areaactivity", (Object)targetObjDy.getLong("activity.id"));
            areaInstance.set("areaperforg", (Object)targetObjDy.getLong("perforg.id"));
            ArrayList<DynamicObject> areaInstanceDys = (ArrayList<DynamicObject>)areaInstanceColl.get(areaRegId);
            if (ObjectUtils.isEmpty((Object)areaInstanceDys)) {
                areaInstanceDys = new ArrayList<DynamicObject>(10);
                areaInstanceColl.put(areaRegId, areaInstanceDys);
            }
            areaInstanceDys.add(areaInstance);
        }
        return areaInstanceColl;
    }

    public List<DynamicObject> queryAssFormConfEntryByConfIds(List<Long> confIdList) {
        QFilter filter = new QFilter("areaconfentry.areaconf", "in", confIdList);
        DynamicObject[] assFormfDys = ASSESS_FORM_ENTITY.query("areaconfentry, areaconfentry.areaconf,areaconfentry.areareg, areaconfentry.source", new QFilter[]{filter});
        return Arrays.stream(assFormfDys).flatMap(assFormDy -> assFormDy.getDynamicObjectCollection("areaconfentry").stream()).collect(Collectors.toList());
    }

    public ResponseResult unifiedDistTask(List<Long> evalObjectIds, int nodeIndex) {
        if (ObjectUtils.isEmpty(evalObjectIds)) {
            return ResponseResult.fail((Integer)200, (String)ResManager.loadKDString((String)"\u8981\u7edf\u4e00\u6d3e\u53d1\u7684\u8bc4\u4f30\u5bf9\u8c61ID[evalObjectIds]\u4e3a\u5fc5\u586b\u9879", (String)"ActivityEvaluationObjectDomainService_69", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        DynamicObject[] evalObjs = this.queryEvaluationObjectById(evalObjectIds);
        int allSize = evalObjs.length;
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        DynamicObject activityDy = evalObjs[0].getDynamicObject("activity");
        DynamicObject schemeDy = ASSESS_SCHEME_APPLICATION_SERVICE.queryOneById(activityDy.getLong("scheme.id"));
        String settingMode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(activityDy.getLong("perfworkflow.id")), "4");
        DynamicObjectCollection flowEntryColl = this.getPerfWorkFlowEntryColl(activityDy);
        Map<String, Long> defaultWorkFlow = this.getDefaultWorkFlowMap(flowEntryColl);
        Long evaluatorWorkFlowId = defaultWorkFlow.get("2");
        ArrayList<String> failMessage = new ArrayList<String>(16);
        Tuple<List<DynamicObject>, String> checkResult = this.validateBeforeStart(evalObjs, failMessage, resultMap);
        List evalObjPassList = (List)checkResult.item1;
        if (ObjectUtils.isEmpty((Object)evalObjPassList)) {
            return ResponseResult.fail((Integer)200, resultMap);
        }
        this.updateEvalObjStartStatus(evalObjectIds, "20");
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList<DynamicObject> activityRecordList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(10);
        ArrayList<FlowRuProcBo> evalFlowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
        for (int i = 0; i < evalObjPassList.size(); ++i) {
            DynamicObject evalObj2 = (DynamicObject)evalObjPassList.get(i);
            FlowRuProcBo flowRuProcBo = this.buildEvaluationProcBo(evalObj2, schemeDy, settingMode, evaluatorWorkFlowId);
            evalFlowRuProcBoList.add(flowRuProcBo);
            this.updateEvalObj(nodeIndex, date, userId, evalObj2);
            activityRecordList.add(this.addActivityRecord(nodeIndex, evalObj2, date, userId));
            objectList.add(evalObj2);
        }
        if (!ObjectUtils.isEmpty(evalFlowRuProcBoList)) {
            List evalObjectIdList = evalObjPassList.stream().map(object -> object.getLong("evalflowins.id")).collect(Collectors.toList());
            FLOW_RUSECOND_DOMAIN_SERVICE.deleteRunProc(evalObjectIdList);
            CommonResultBo evaResultBo = FLOW_RU_PROC_BATCH_DOMAIN_SERVICE.preCreateProcessInstanceNoTx(evalFlowRuProcBoList, null);
            Map evaResMap = evaResultBo.getResultMap();
            Arrays.stream(evalObjs).forEach(evalObj -> {
                evalObj.set("evalflowins", evaResMap.get(evalObj.getLong("id")));
                evalObj.set("evalflow", (Object)evaluatorWorkFlowId);
            });
        }
        this.saveEvaluationObject(evalObjs);
        this.updateEvalObjStartStatus(evalObjectIds, "10");
        this.saveObjCrossIndicator(objectList.toArray(new DynamicObject[0]));
        this.saveImportScoreInd(objectList.toArray(new DynamicObject[0]));
        if (!ObjectUtils.isEmpty(activityRecordList)) {
            ACTIVITY_RECORD_ENTITY.save(activityRecordList.toArray(new DynamicObject[0]));
        }
        return ResponseResult.success(resultMap);
    }

    private Tuple<List<DynamicObject>, String> validateBeforeStart(DynamicObject[] evalObjs, List<String> failMessage, Map<Long, String> resultMap) {
        DynamicObject activityDy = evalObjs[0].getDynamicObject("activity");
        DynamicObject executeScheme = EXECUTE_SCHEME_ENTITY_SERVICE.queryOne(activityDy.getLong("executescheme.id"));
        DynamicObject assessform = executeScheme.getDynamicObject("assessform");
        String assFormat = assessform.getString("scorecalcway");
        DynamicObject scoreSystemDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryScoreSystemByActId(activityDy.getLong("id"));
        BigDecimal maxScoreOfSystem = scoreSystemDy.getBigDecimal("maxscore");
        Map<Long, DynamicObject> areaInstanceMap = EVALUATION_OBJECT_APPLICATION_SERVICE.queryEvaluationGenAreaInstance(Arrays.asList(evalObjs));
        String target = HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) ? "weight" : "indctrscore";
        Map<Long, BigDecimal> sumScoreMap = EVALUATION_OBJECT_APPLICATION_SERVICE.getNormalAreaSumMap(evalObjs, areaInstanceMap, target);
        Map<Long, Long> areaSumScoreMap = EVALUATION_OBJECT_APPLICATION_SERVICE.getAreaSumNotEqMap(evalObjs, areaInstanceMap, assFormat);
        ArrayList<DynamicObject> evalObjPassList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < evalObjs.length; ++i) {
            String reason;
            DynamicObject evalObj = evalObjs[i];
            long evalObjId = evalObj.getLong("id");
            String personDesc = evalObj.getString("person.name") + " " + evalObj.getString("person.number") + ": ";
            if (!HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessStausEnum.JOINED.getStatus())) {
                String reason2 = ResManager.loadKDString((String)"{0}\u5236\u5b9a\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u5f85\u5236\u5b9a\u201d\uff0c\u4e0d\u80fd\u7edf\u4e00\u6d3e\u53d1\u3002", (String)"ActivityEvaluationObjectDomainService_41", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                failMessage.add(reason2);
                resultMap.put(evalObjId, reason2);
                continue;
            }
            String startStatus = evalObj.getString("startstatus");
            if (HRStringUtils.equals((String)startStatus, (String)"20")) {
                String reason3 = ResManager.loadKDString((String)"{0}\u5236\u5b9a\u5bf9\u8c61\u7684\u7edf\u4e00\u6d3e\u53d1\u4efb\u52a1\u5df2\u5b8c\u6210\u3002", (String)"ActivityEvaluationObjectDomainService_42", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                failMessage.add(reason3);
                resultMap.put(evalObjId, reason3);
                continue;
            }
            if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode())) {
                BigDecimal sumWeightScore;
                BigDecimal bigDecimal = sumWeightScore = sumScoreMap.get(evalObjId) == null ? new BigDecimal(0) : sumScoreMap.get(evalObjId);
                if (sumWeightScore.compareTo(new BigDecimal(100)) != 0) {
                    reason = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u6743\u91cd\u9700=100%\u3002", (String)"ActivityEvaluationObjectDomainService_43", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    resultMap.put(evalObjId, reason);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaSumScoreMap.get(evalObjId))) {
                    reason = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u6743\u91cd\u9700=\u533a\u57df\u6743\u91cd\u3002", (String)"ActivityEvaluationObjectDomainService_44", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    resultMap.put(evalObjId, reason);
                    continue;
                }
            } else {
                BigDecimal sumIndctrScore;
                BigDecimal bigDecimal = sumIndctrScore = sumScoreMap.get(evalObjId) == null ? new BigDecimal(0) : sumScoreMap.get(evalObjId);
                if (sumIndctrScore.compareTo(maxScoreOfSystem) < 0) {
                    reason = ResManager.loadKDString((String)"{0}\u533a\u57df\u5408\u8ba1\u5206\u503c\u9700=\u57fa\u51c6\u6700\u9ad8\u5206\u3002", (String)"ActivityEvaluationObjectDomainService_1", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    resultMap.put(evalObjId, reason);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaSumScoreMap.get(evalObjId))) {
                    reason = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u5206\u503c\u9700=\u533a\u57df\u5206\u503c\u3002", (String)"ActivityEvaluationObjectDomainService_36", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    resultMap.put(evalObjId, reason);
                    continue;
                }
            }
            evalObjPassList.add(evalObj);
        }
        return Tuple.create(evalObjPassList, (Object)"");
    }

    public void preCreateProcessAndForm(Long activityId, String assessFormId) {
        DynamicObject activityObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(activityId);
        DynamicObject assessForm = activityObj.getDynamicObject("assessform");
        if (ObjectUtils.isEmpty((Object)assessForm)) {
            activityObj.set("assessform", (Object)assessFormId);
            ASSESS_ACTIVITY_APPLICATION_SERVICE.saveActivity(new DynamicObject[]{activityObj});
            DynamicObject dynamicpermission = activityObj.getDynamicObject("dynamicpermission");
            dynamicpermission.set("assessform", (Object)assessFormId);
            dynamixcPermitService.saveOne(dynamicpermission);
            List<DynamicObject> joinEvalObj = ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE.getJoinActivityObjects(activityId);
            List evalObjIds = joinEvalObj.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            DynamicObject[] evalObjDys = ACTIVITY_EVALUATION_OBJECT_ENTITY.loadDynamicObjectArray(evalObjIds.toArray());
            this.preCreateProcessAndAreaInstance(evalObjDys, assessFormId, this.getPerfWorkFlowEntryColl(activityObj));
        }
    }

    public void clearPerfSumData(long activityId, Boolean haveChange) {
        DynamicObject activityObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(activityId);
        DynamicObjectCollection perfWorkflowEntryEntity = activityObj.getDynamicObjectCollection("perfworkflow.entryentity");
        DynamicObjectCollection timeplanentry = activityObj.getDynamicObjectCollection("timeplanentry");
        if (CollectionUtils.isNotEmpty((Collection)perfWorkflowEntryEntity) && CollectionUtils.isNotEmpty((Collection)timeplanentry)) {
            DynamicObject tobeMp = perfWorkflowEntryEntity.stream().filter(obj -> obj.getBoolean("isshow")).filter(obj -> obj.getDynamicObject("node").getLong("id") == AssessNodeStatusEnum.TO_BE_MP.getNodeId().longValue()).findAny().orElse(null);
            DynamicObject tobeMpOfObj = timeplanentry.stream().filter(obj -> obj.getDynamicObject("activity").getLong("id") == AssessNodeStatusEnum.TO_BE_MP.getNodeId().longValue()).findAny().orElse(null);
            if (ObjectUtils.isEmpty((Object)tobeMp) && !ObjectUtils.isEmpty((Object)tobeMpOfObj) || haveChange.booleanValue()) {
                PERF_SUM_DOMAIN_SERVICE.clearPerfSumData(activityId);
            }
            DynamicObject tobeFormulate = perfWorkflowEntryEntity.stream().filter(obj -> obj.getBoolean("isshow")).filter(obj -> obj.getDynamicObject("node").getLong("id") == AssessNodeStatusEnum.TO_BE_FORMULATED.getNodeId().longValue()).findAny().orElse(null);
            DynamicObject tobeFormulateOfObj = timeplanentry.stream().filter(obj -> obj.getDynamicObject("activity").getLong("id") == AssessNodeStatusEnum.TO_BE_FORMULATED.getNodeId().longValue()).findAny().orElse(null);
            if (!ObjectUtils.isEmpty((Object)tobeFormulate) && ObjectUtils.isEmpty((Object)tobeFormulateOfObj)) {
                PERF_SUM_DOMAIN_SERVICE.clearPerfSumData(activityId);
            }
        }
    }

    public void preCreateProcessAndAreaInstance(DynamicObject[] evalObj, String assessFormId, DynamicObjectCollection flowEntryColl) {
        Map<String, Long> defaultWorkFlow;
        try (TXHandle txHandle = TX.required();){
            try {
                defaultWorkFlow = this.getDefaultWorkFlowMap(flowEntryColl);
                DynamicObject assessFormDynObj = ASSESS_FORM_ENTITY.loadSingle(assessFormId);
                this.setAreaInstanceId(evalObj, assessFormDynObj, defaultWorkFlow);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
                txHandle.markRollback();
                throw ex;
            }
        }
        List<BatchFlowTaskResultBo> batchFlowTaskResultBoList = this.preCreateEvaluationObjectProcessInstance(evalObj, defaultWorkFlow);
        if (evalObj.length <= 20) {
            this.saveEvaluationObject(evalObj);
        }
        if (evalObj.length > 20) {
            for (BatchFlowTaskResultBo formulateResultBo : batchFlowTaskResultBoList) {
                StartProcessPublisher.publish((List)formulateResultBo.getBatchTaskIdList(), (String)formulateResultBo.getTaskType());
            }
        }
    }

    private void setAreaInstanceId(DynamicObject[] evalObj, DynamicObject assessFormDynObj, Map<String, Long> defaultWorkFlow) {
        HashMap<Long, DynamicObject> areaConfCache = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, ArrayList<DynamicObject>> areaInstanceListOfAreaRegMap = new HashMap<Long, ArrayList<DynamicObject>>(16);
        DynamicObjectCollection areaConfColl = !ObjectUtils.isEmpty((Object)assessFormDynObj) ? assessFormDynObj.getDynamicObjectCollection("areaconfentry") : new DynamicObjectCollection();
        String assScore = this.getAssScore(assessFormDynObj);
        for (DynamicObject assessObjectDynObj : evalObj) {
            Long evaluatorWorkFlowId = defaultWorkFlow.get("2");
            assessObjectDynObj.set("evalflow", (Object)evaluatorWorkFlowId);
            Long indicatorWorkFlowId = defaultWorkFlow.get("1");
            assessObjectDynObj.set("formulateflow", (Object)indicatorWorkFlowId);
            assessObjectDynObj.set("assscore", (Object)assScore);
            DynamicObjectCollection areaEntry = assessObjectDynObj.getDynamicObjectCollection("areaentry");
            if (ObjectUtils.isEmpty((Object)areaConfColl)) continue;
            for (DynamicObject assTableConf : areaConfColl) {
                DynamicObject areaInstanceEntryRow = new DynamicObject(areaEntry.getDynamicObjectType());
                long areaRegId = assTableConf.getDynamicObject("areareg").getLong("id");
                long confId = assTableConf.getLong("areaconf");
                areaInstanceEntryRow.set("areareg", (Object)areaRegId);
                areaInstanceEntryRow.set("areaconf", (Object)confId);
                DynamicObject areaInstance = this.initAreaInstance(areaConfCache, areaRegId, confId);
                if (areaInstance == null) continue;
                ArrayList<DynamicObject> areaInstanceDys = (ArrayList<DynamicObject>)areaInstanceListOfAreaRegMap.get(areaRegId);
                if (ObjectUtils.isEmpty((Object)areaInstanceDys)) {
                    areaInstanceDys = new ArrayList<DynamicObject>(10);
                    areaInstanceListOfAreaRegMap.put(areaRegId, areaInstanceDys);
                }
                areaInstanceDys.add(areaInstance);
                areaInstanceEntryRow.set("areains", areaInstance.getPkValue());
                areaEntry.add((Object)areaInstanceEntryRow);
            }
        }
        for (Map.Entry entry : areaInstanceListOfAreaRegMap.entrySet()) {
            long areaRegId = (Long)entry.getKey();
            OpmcEntityService entity = AREA_INS_ENTITY_MAP.get(areaRegId);
            if (!ObjectUtils.isEmpty((Object)entity)) {
                entity.save(((List)entry.getValue()).toArray(new DynamicObject[0]));
                continue;
            }
            LOG.info("Excluded areaReg {}", (Object)areaRegId);
        }
    }

    static {
        AREA_INS_ENTITY_MAP.put(AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId(), OBJ_GEN_AREA_INS_ENTITY);
        AREA_INS_ENTITY_MAP.put(AreaRegEnum.PLUS_MINUS_AREA.getAreaPkId(), OBJ_ADD_SUB_AREA_INS_ENTITY);
        AREA_INS_ENTITY_MAP.put(AreaRegEnum.ATTACH_AREA.getAreaPkId(), OBJ_ATTACH_AREA_INS_ENTITY);
        OBJ_GEN_AREAINS_ENTITY = ObjGenAreaInsEntityService.getInstance();
        OBJ_ADDSUB_AREAINS_ENTITY = ObjAddSubAreaInsEntityService.getInstance();
        OBJ_ATTACH_AREAINS_ENTITY = ObjAttachAreaInsEntityService.getInstance();
        EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
        INDICATOR_GROUP_ENTITY_SERVICE = new IndicatorGroupEntityService();
        FLOW_HANDLER_BATCH_DOMAIN_SERVICE = FlowHandlerBatchDomainService.getInstance();
        dynamixcPermitService = new HRBaseServiceHelper("epa_dynamicpermission");
        PERF_SUM_DOMAIN_SERVICE = PerfSumDomainService.getInstance();
        ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
        PERSON_SERVICE = IHRPIPersonService.getInstance();
    }
}

