/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.activitymanage.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.EvalfinishtypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.vo.ResponseResult;
import kd.opmc.pbs.business.application.impl.mq.StartProcessPublisher;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.flowscan.entity.BatchFlowTaskResultBo;
import kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskTypeEnum;
import kd.opmc.pbs.business.domain.flowscan.service.BatchFlowTaskService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import org.apache.commons.collections.MapUtils;

public class AssessEvaluatedDomainService {
    private static final Log log = LogFactory.getLog(AssessEvaluatedDomainService.class);
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final FlowDefProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final BatchFlowTaskService BATCH_FLOW_TASK_SERVICE = BatchFlowTaskService.getInstance();
    private static final BatchStartEvalEntityService BATCH_START_EVAL_ENTITY_SERVICE = BatchStartEvalEntityService.getInstance();

    public static AssessEvaluatedDomainService getInstance() {
        return ServiceFactory.getService(AssessEvaluatedDomainService.class);
    }

    public void completeEvaluate(Long evalObjectId) {
        if (ObjectUtils.isEmpty((Object)evalObjectId)) {
            throw new KDException(new ErrorCode("completeEvaluate", "evalObjectId is empty"), new Object[0]);
        }
        DynamicObject evalObj = ACTIVITY_EVALUATION_OBJECT_ENTITY.queryObjForCompleteEval(evalObjectId);
        DynamicObjectCollection timeplanEntry = evalObj.getDynamicObjectCollection("activity.timeplanentry");
        if (evalObj.getLong("assessnode.id") != AssessNodeStatusEnum.EVALUATING.getNodeId().longValue() || !HRStringUtils.equals((String)evalObj.getString("nodestatus"), (String)AssessNodeStatusEnum.EVALUATING.getStatus()) || !HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessStausEnum.HAVE_IN_HAND.getStatus())) {
            throw new KDException(new ErrorCode("completeEvaluate", ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u5bf9\u8c61\u5f53\u524d\u7ee9\u6548\u4e1a\u52a1\u6d3b\u52a8\u4e0d\u4e3a\uff1a\u7ee9\u6548\u8bc4\u4f30-\u8bc4\u4f30\u4e2d", (String)"AssessEvaluatedDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0])), new Object[0]);
        }
        boolean isLastNode = timeplanEntry.size() == evalObj.getInt("nodeindex");
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        evalObj.set("modifier", (Object)userId);
        evalObj.set("modifytime", (Object)date);
        evalObj.set("evalfinishtype", (Object)EvalfinishtypeEnum.FINISHED_UPDATE_EVAL.getType());
        evalObj.set("perffilev", evalObj.get("perffile.sourcevid"));
        evalObj.set("nodestatus", (Object)(isLastNode ? null : AssessNodeStatusEnum.EVALUATED.getStatus()));
        if (isLastNode) {
            evalObj.set("assessstaus", (Object)AssessStausEnum.COMPLETED.getStatus());
            evalObj.set("assessnode", null);
            evalObj.set("nodeindex", null);
            evalObj.set("completetime", (Object)date);
        }
        ACTIVITY_EVALUATION_OBJECT_ENTITY.saveOne(evalObj);
        DynamicObject evalRecord = ACTIVITY_RECORD_ENTITY.queryEvalRecord(evalObjectId);
        evalRecord.set("nodestatus", (Object)AssessNodeStatusEnum.EVALUATED.getStatus());
        evalRecord.set("endtime", (Object)date);
        evalRecord.set("modifier", (Object)userId);
        evalRecord.set("modifytime", (Object)date);
        ACTIVITY_RECORD_ENTITY.saveOne(evalRecord);
    }

    public List<Long> queryEvaluatedObjIdByActivityId(Long activityId) {
        return ACTIVITY_RECORD_ENTITY.queryEvaluatedObjIdByActivityId(activityId);
    }

    public List<Long> queryFormulatedObjIdByActivityId(Long activityId) {
        return ACTIVITY_RECORD_ENTITY.queryFormulatedObjIdByActivityId(activityId);
    }

    public List<Long> queryPerfSummaryedObjIdByActivityId(Long activityId) {
        return ACTIVITY_RECORD_ENTITY.queryPerfSummaryedObjIdByActivityId(activityId);
    }

    public ResponseResult startEvaluate(List<Long> evalObjectIds, int nodeIndex) {
        Object[] evalObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(evalObjectIds);
        if (ObjectUtils.isEmpty((Object[])evalObjs)) {
            return ResponseResult.fail((Integer)200, (String)ResManager.loadKDString((String)"\u8981\u542f\u52a8\u7684\u8bc4\u4f30\u5bf9\u8c61ID[evalObjectIds]\u4e3a\u5fc5\u586b\u9879", (String)"AssessEvaluatedDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        int allSize = evalObjs.length;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        this.builerProgressResult(resultMap, allSize, "0");
        if (this.excuteValEval((DynamicObject[])evalObjs, allSize)) {
            return ResponseResult.fail((Integer)200, resultMap);
        }
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList failList = Lists.newArrayListWithCapacity((int)10);
        DynamicObjectCollection dyColl = this.updateEvalStatus2Starting((DynamicObject[])evalObjs, failList);
        this.builerProgressResult(resultMap, allSize, "1");
        int successSize = dyColl.size();
        int suspendcount = 0;
        String batchNo = BATCH_FLOW_TASK_SERVICE.requireBatchNoByBatchTask(TaskTypeEnum.EVAL_START);
        List cannotStartEvaObjList = BatchStartEvalEntityService.getInstance().getActevaobjUnCompletedTask(evalObjectIds, TaskTypeEnum.EVAL_START.getValue());
        ArrayList<FlowRuProcBo> evalFlowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
        for (int i = 0; i < dyColl.size(); ++i) {
            DynamicObject evalObj = (DynamicObject)dyColl.get(i);
            if (evalObj.getLong("assessnode.id") != NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId().longValue() || !HRStringUtils.equals((String)evalObj.getString("nodestatus"), (String)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus()) || evalObj.getLong("nodeindex") != AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId().longValue()) {
                this.buiderFailResult(failList, evalObj, ResManager.loadKDString((String)"\u5c1a\u672a\u8fdb\u5165\u7ee9\u6548\u8bc4\u4f30\u6d41\u7a0b\u6216\u7ee9\u6548\u8bc4\u4f30\u6d41\u7a0b\u5df2\u5b8c\u6210 ", (String)"AssessEvaluatedDomainService_2", (String)"opmc-epa-business", (Object[])new Object[0]));
                --successSize;
                continue;
            }
            if (cannotStartEvaObjList.contains(evalObj.getLong("id"))) {
                --successSize;
                this.buiderFailResult(failList, evalObj, ResManager.loadKDString((String)"\u7ee9\u6548\u8bc4\u4f30\u6d41\u7a0b\u6b63\u5728\u542f\u52a8\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5 ", (String)"AssessEvaluatedDomainService_3", (String)"opmc-epa-business", (Object[])new Object[0]));
                continue;
            }
            FlowRuProcBo flowRuProcBo = this.buildEvaluationProcBo(evalObj, batchNo);
            evalFlowRuProcBoList.add(flowRuProcBo);
            this.builerProgressResult(resultMap, 1, "2");
            this.updateEvalObj(nodeIndex, date, userId, evalObj);
            this.addActivityRecord(nodeIndex, evalObj, date, userId);
        }
        BatchFlowTaskResultBo startEvaResultBo = BATCH_START_EVAL_ENTITY_SERVICE.generateBatchFlowTaskData(evalFlowRuProcBoList, TaskTypeEnum.EVAL_START.getValue());
        StartProcessPublisher.publish((List)startEvaResultBo.getBatchTaskIdList(), (String)startEvaResultBo.getTaskType());
        List<Long> ids = Arrays.stream(evalObjs).map(coll -> coll.getLong("id")).collect(Collectors.toList());
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject((DynamicObject[])evalObjs);
        this.updateEvalObjStartStatus(ids, "10");
        this.buiderResult(allSize, successSize, suspendcount, failList, resultMap);
        return ResponseResult.success(resultMap);
    }

    protected void updateEvalObjStartStatus(List<Long> evalObjectIds, String status) {
        DynamicObject[] startingObj = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjStatusById(evalObjectIds);
        Arrays.stream(startingObj).forEach(evalObj -> evalObj.set("startstatus", (Object)status));
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject(startingObj);
    }

    private boolean excuteValEval(DynamicObject[] evalObjs, int allSize) {
        HashMap<String, Object> validateDataMap = EvalObjUtils.startCheckTask(evalObjs);
        this.builerProgressResult(validateDataMap, allSize, "0");
        this.builerProgressResult(validateDataMap, allSize, "1");
        String data = JSONObject.toJSONString(validateDataMap);
        Boolean isStartTask = this.validateIsStartTask(data);
        return isStartTask == false;
    }

    private Boolean validateIsStartTask(String data) {
        JSONObject resultDate = JSONObject.parseObject((String)data);
        if (Objects.isNull(resultDate)) {
            return Boolean.FALSE;
        }
        Map dataMap = MapUtils.getMap((Map)resultDate, (Object)"data");
        if (HRObjectUtils.isEmpty((Object)dataMap)) {
            return Boolean.FALSE;
        }
        Integer failcount = MapUtils.getInteger((Map)dataMap, (Object)"failcount");
        if (!Objects.isNull(failcount) && failcount > 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private DynamicObjectCollection updateEvalStatus2Starting(DynamicObject[] evalObjs, List<Map<String, String>> failList) {
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        for (DynamicObject evalObj : evalObjs) {
            if (evalObj.getLong("assessnode.id") != NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId().longValue() || !HRStringUtils.equals((String)evalObj.getString("nodestatus"), (String)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus()) || evalObj.getLong("nodeindex") != AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId().longValue()) {
                this.buiderFailResult(failList, evalObj, ResManager.loadKDString((String)"\u5c1a\u672a\u8fdb\u5165\u7ee9\u6548\u8bc4\u4f30\u6d41\u7a0b\u6216\u7ee9\u6548\u8bc4\u4f30\u6d41\u7a0b\u5df2\u5b8c\u6210 ", (String)"AssessEvaluatedDomainService_2", (String)"opmc-epa-business", (Object[])new Object[0]));
                continue;
            }
            String startStatus = evalObj.getString("startstatus");
            if (HRStringUtils.equals((String)startStatus, (String)"20")) {
                this.buiderFailResult(failList, evalObj, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u8bc4\u4f30\u4efb\u52a1\u5df2\u542f\u52a8\u6216\u5df2\u5b8c\u6210", (String)"AssessEvaluatedDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]));
                continue;
            }
            evalObj.set("startstatus", (Object)"20");
            dyColl.add((Object)evalObj);
        }
        List<Long> ids = dyColl.stream().map(coll -> coll.getLong("id")).collect(Collectors.toList());
        this.updateEvalObjStartStatus(ids, "10");
        return dyColl;
    }

    private void builerProgressResult(HashMap<String, Object> resultMap, int val, String type) {
        if (HRStringUtils.equals((String)type, (String)"0")) {
            resultMap.put("valTotalNum", val);
            resultMap.put("startTotalNum", val);
        } else if (HRStringUtils.equals((String)type, (String)"1")) {
            resultMap.put("valDealNum", this.setDealNum(resultMap.get("valDealNum"), val));
        } else {
            resultMap.put("startDealNum", this.setDealNum(resultMap.get("startDealNum"), val));
        }
    }

    private int setDealNum(Object obj, int val) {
        if (Objects.isNull(obj)) {
            return val;
        }
        if (obj instanceof Integer) {
            return (Integer)obj + val;
        }
        return val;
    }

    private void buiderResult(int allSize, int successSize, int suspendcount, List<Map<String, String>> failList, HashMap<String, Object> resultMap) {
        HashMap message = Maps.newHashMapWithExpectedSize((int)16);
        message.put("totalcount", allSize);
        message.put("sucesscount", successSize);
        message.put("failcount", allSize - successSize);
        message.put("suspendcount", suspendcount);
        message.put("failList", failList);
        resultMap.put("data", message);
    }

    private void buiderFailResult(List<Map<String, String>> failList, DynamicObject evalObj, String detail) {
        HashMap failMessage = Maps.newHashMapWithExpectedSize((int)16);
        failMessage.put("dealername", evalObj.getString("person.name"));
        failMessage.put("dealernum", evalObj.getString("person.number"));
        failMessage.put("preffileno", evalObj.getString("perffile.number"));
        failMessage.put("detail", detail);
        failList.add(failMessage);
    }

    private void updateEvalObj(int nodeIndex, Date date, long userId, DynamicObject evaluationObj) {
        log.info(" ----------\u3010\u53d8\u66f4\u8bc4\u4f30\u5bf9\u8c61\u3011ASSESSNODE:{},NODEINDEX:{},NODESTATUS:{}----------", new Object[]{AssessNodeStatusEnum.EVALUATING.getNodeId(), nodeIndex, AssessNodeStatusEnum.EVALUATING.getStatus()});
        evaluationObj.set("modifier", (Object)userId);
        evaluationObj.set("modifytime", (Object)date);
        evaluationObj.set("assessnode", (Object)AssessNodeStatusEnum.EVALUATING.getNodeId());
        evaluationObj.set("nodeindex", (Object)nodeIndex);
        evaluationObj.set("nodestatus", (Object)AssessNodeStatusEnum.EVALUATING.getStatus());
    }

    private void addActivityRecord(int nodeIndex, DynamicObject evaluationObj, Date date, long userId) {
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5f00\u59cb----------");
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.EVALUATING.getNodeId());
        activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.EVALUATING.getStatus());
        activityRecord.set("nodeindex", (Object)nodeIndex);
        activityRecord.set("endtime", (Object)date);
        activityRecord.set("starttype", (Object)"20");
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        activityRecord.set("activity", (Object)evaluationObj.getLong("activity.id"));
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("creator", (Object)userId);
        activityRecord.set("createtime", (Object)date);
        activityRecord.set("modifier", (Object)userId);
        activityRecord.set("modifytime", (Object)date);
        ACTIVITY_RECORD_ENTITY.saveOne(activityRecord);
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5b8c\u6210----------");
    }

    private FlowRuProcBo buildEvaluationProcBo(DynamicObject evaluationObj, String batchNo) {
        long flowVid = evaluationObj.getLong("evalflow.id");
        DynamicObject person = evaluationObj.getDynamicObject("person");
        Integer assessYear = evaluationObj.getInt("assessyear");
        String assessPeriod = evaluationObj.getString("assessperiod");
        long actEvalObjId = evaluationObj.getLong("id");
        DynamicObject activityDy = evaluationObj.getDynamicObject("activity");
        DynamicObject schemeDy = ASSESS_SCHEME_APPLICATION_SERVICE.queryOneById(activityDy.getLong("scheme.id"));
        long perfOrgId = schemeDy.getLong("createorg.id");
        long adminOrgId = schemeDy.getLong("adminorg.id");
        long activityId = evaluationObj.getLong("activity.id");
        long empPosRelId = evaluationObj.getLong("empposrel.id");
        DynamicObject executeScheme = EXECUTE_SCHEME_ENTITY_SERVICE.queryOne(activityDy.getLong("executescheme.id"));
        String settingmode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(executeScheme.getLong("perfworkflow.id")), "4");
        FlowRuProcBo flowRuProcBo = FlowRuProcBo.builder().flowVid(Long.valueOf(flowVid)).person(person).perfOrgId(Long.valueOf(perfOrgId)).adminOrgId(Long.valueOf(adminOrgId)).assessYear(assessYear).assessPeriod(assessPeriod).actEvalObjId(Long.valueOf(actEvalObjId)).activityId(Long.valueOf(activityId)).empPosRelId(Long.valueOf(empPosRelId)).settingMode(StringUtils.isEmpty((String)settingmode) ? "" : settingmode).workflowType("2").batchNo(batchNo).build();
        return flowRuProcBo;
    }
}

