/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.activitymanage.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.pbs.business.domain.workflow.enums.FlowCooperatorEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowCooperateDomainService;
import kd.opmc.pbs.common.utils.CommonResultBo;

public class CooperatorManageDomainService {
    private static final FlowCooperateDomainService FLOW_COOPERATE_DOMAIN_SERVICE = FlowCooperateDomainService.getInstance();

    public static CooperatorManageDomainService getInstance() {
        return ServiceFactory.getService(CooperatorManageDomainService.class);
    }

    public Map<Long, String> getTasksCooperator(List<Long> taskIds) {
        HashMap<Long, String> taskCooperator = new HashMap<Long, String>(16);
        Map cooperatorByMainTaskIds = FLOW_COOPERATE_DOMAIN_SERVICE.getCooperatorByMainTaskIds(taskIds);
        cooperatorByMainTaskIds.forEach((taskId, dycs) -> {
            if (!dycs.isEmpty()) {
                ArrayList<String> cooperatorName = new ArrayList<String>(16);
                for (DynamicObject dyc : dycs) {
                    if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(dyc.getString("taskstatus"))) continue;
                    FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)dyc.getString("taskstatus"));
                    cooperatorName.add(MessageFormat.format("{0} ({1})", dyc.getString("handler.name"), taskStatus == null ? "" : taskStatus.getText()));
                }
                String names = String.join((CharSequence)"-", cooperatorName);
                taskCooperator.put((Long)taskId, names);
            }
        });
        return taskCooperator;
    }

    public Map<Long, List<Long>> getTasksCooperatorIds(List<Long> taskIds) {
        HashMap<Long, List<Long>> taskCooperatorIds = new HashMap<Long, List<Long>>(16);
        ArrayList cooperatorIds = new ArrayList(16);
        Map cooperatorByMainTaskIds = FLOW_COOPERATE_DOMAIN_SERVICE.getCooperatorByMainTaskIds(taskIds);
        cooperatorByMainTaskIds.forEach((taskId, dycs) -> {
            if (!dycs.isEmpty()) {
                for (DynamicObject dyc : dycs) {
                    cooperatorIds.add(dyc.getLong("handler.id"));
                }
            }
            taskCooperatorIds.put((Long)taskId, cooperatorIds);
        });
        return taskCooperatorIds;
    }

    public CommonResultBo setCooperator(Map<Long, List<Long>> cooperatorMap, FlowCooperatorEnum cooperatorEnum) {
        return FLOW_COOPERATE_DOMAIN_SERVICE.setCooperator(cooperatorMap, cooperatorEnum);
    }
}

