/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.activitymanage.service;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.IndicatorScoreImportEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.NormalConfigEntityService;
import kd.opmc.epa.business.domain.evaluating.service.EvalResultCalcDomainService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;

public class IndicatorScoreImportDomainService {
    private static final Log LOG = LogFactory.getLog(IndicatorScoreImportDomainService.class);
    private static final IndicatorScoreImportEntityService INDICATOR_SCORE_IMPORT_ENTITY = IndicatorScoreImportEntityService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY = AssessActivityEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY = AssessFormEntityService.getInstance();
    private static final NormalConfigEntityService NORMAL_CONFIG_ENTITY = NormalConfigEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService EVAL_OBJ_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final ObjGenAreaIndicatorEntityService GEN_AREA_INDICATOR_ENTITY = ObjGenAreaIndicatorEntityService.getInstance();
    private static final ObjAddSubAreaInsEntityService ADD_SUB_AREA_INS_ENTITY = ObjAddSubAreaInsEntityService.getInstance();
    private static final ObjAddSubAreaIndicatorEntityService ADD_SUB_AREA_INDICATOR_ENTITY = ObjAddSubAreaIndicatorEntityService.getInstance();
    private static final Set<String> ignoreFields = new HashSet<String>(Arrays.asList("entryseq", "instanceid", "indctrname", "modifytime", "initdatasource", "assessyear", "assessperiod", "activity", "perforg", "actevalobj", "flowruproc", "flowrunode", "flowrurole", "flowrutask", "from", "addnodeindex"));
    private static final EvalResultCalcDomainService RESULT_CALC_DOMAIN = EvalResultCalcDomainService.getInstance();

    public static IndicatorScoreImportDomainService getInstance() {
        return ServiceFactory.getService(IndicatorScoreImportDomainService.class);
    }

    public DynamicObject[] queryIndicator(Long activityId, List<Long> objIds) {
        QFilter actFilter = new QFilter("activity", "=", (Object)activityId);
        QFilter objFilter = new QFilter("actevalobj", "in", objIds);
        return INDICATOR_SCORE_IMPORT_ENTITY.loadDynamicObjectArray(new QFilter[]{actFilter, objFilter});
    }

    public DynamicObject queryFormByActivity(Long activityId) {
        DynamicObject dynamicObject = ACTIVITY_ENTITY.queryOriginalOne("assessform.id", activityId);
        long formId = dynamicObject.getLong("assessform.id");
        return ASSESS_FORM_ENTITY.queryAssessFormByPk(formId);
    }

    public DynamicObject[] queryNormalConfById(Collection<Long> areaConfIdSet) {
        return NORMAL_CONFIG_ENTITY.query("areascore,weight,scoresystem,reversepoints", new QFilter("id", "in", areaConfIdSet).toArray());
    }

    public void processScoreOfIndicator(DynamicObject[] dataEntities) {
        DynamicObject[] indicatorDys;
        Map indicatorImportDataMap = Arrays.stream(dataEntities).collect(Collectors.toMap(dy -> dy.getLong("indicator.id"), Function.identity()));
        for (DynamicObject indicatorDy : indicatorDys = GEN_AREA_INDICATOR_ENTITY.queryIndicatorByIds(indicatorImportDataMap.keySet())) {
            DynamicObject importData = (DynamicObject)indicatorImportDataMap.get(indicatorDy.getLong("id"));
            BigDecimal iecs = importData.getBigDecimal("iecs");
            indicatorDy.set("iecs", (Object)iecs);
            indicatorDy.set("ies", (Object)iecs);
        }
        GEN_AREA_INDICATOR_ENTITY.save(indicatorDys);
        boolean isRefreshScore = Arrays.stream(dataEntities).allMatch(dy -> {
            String nodeStatus = dy.getString("actevalobj.nodestatus");
            Long assessNode = dy.getLong("actevalobj.assessnode.id");
            AssessNodeStatusEnum nodeStatusEnum = AssessNodeStatusEnum.getEnumByIdAndStatus((Long)assessNode, (String)nodeStatus);
            return nodeStatusEnum != AssessNodeStatusEnum.TO_BE_EVALUATED;
        });
        List<Long> objIds = Arrays.stream(dataEntities).map(dy -> dy.getLong("actevalobj.id")).distinct().collect(Collectors.toList());
        if (!isRefreshScore) {
            return;
        }
        RESULT_CALC_DOMAIN.refreshScoreOnImportInd(objIds);
    }

    public Long queryLastActNode(Long activityId, Long nodeId) {
        int i;
        DynamicObject activity = ACTIVITY_ENTITY.queryActivityPAssessNode(activityId);
        DynamicObjectCollection timePlanEntry = activity.getDynamicObjectCollection("timeplanentry");
        for (i = 0; i < timePlanEntry.size() && !nodeId.equals(((DynamicObject)timePlanEntry.get(i)).getLong("activity.id")); ++i) {
        }
        if (i > 0) {
            return ((DynamicObject)timePlanEntry.get(i - 1)).getLong("activity.id");
        }
        return 0L;
    }

    public Map<String, Object> updateEvalInfo(Map<String, Object> param) {
        LOG.info("IndicatorScoreImportDomainService.updateEvalInfo:{}", (Object)JSONObject.toJSONString(param));
        String activityNumber = (String)param.get("activitynumber");
        if (HRStringUtils.isEmpty((String)activityNumber)) {
            return ApiResult.toMap((ApiResult)ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u3010{0}\u3011\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorScoreImportDomainService_0", (String)"opmc-epa-business", (Object[])new Object[]{"activitynumber"})));
        }
        DynamicObject activityDy = ACTIVITY_ENTITY.queryOne("id", new QFilter("number", "=", (Object)activityNumber));
        if (activityDy == null) {
            return ApiResult.toMap((ApiResult)ApiResult.fail((String)ResManager.loadKDString((String)"\u3010{0}\u3011\u5bf9\u5e94\u7684\u8003\u6838\u6d3b\u52a8\u4e0d\u5b58\u5728\u3002", (String)"IndicatorScoreImportDomainService_1", (String)"opmc-epa-business", (Object[])new Object[]{activityNumber})));
        }
        Long areaRegId = (Long)param.get("arearegid");
        if (areaRegId == null || areaRegId == 0L) {
            return ApiResult.toMap((ApiResult)ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u3010{0}\u3011\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorScoreImportDomainService_0", (String)"opmc-epa-business", (Object[])new Object[]{"arearegid"})));
        }
        List indicatorList = (List)param.get("indicatorList");
        if (ObjectUtils.isEmpty((Object)indicatorList)) {
            return ApiResult.toMap((ApiResult)ApiResult.fail((String)ResManager.loadKDString((String)"\u6307\u6807\u6570\u636e\u4e3a\u7a7a\u3002", (String)"IndicatorScoreImportDomainService_2", (String)"opmc-epa-business", (Object[])new Object[]{"perffilenumber,areaname,indctrname"})));
        }
        boolean existNullField = indicatorList.stream().anyMatch(indInfo -> HRStringUtils.isEmpty((String)((String)indInfo.get("perffilenumber"))) || HRStringUtils.isEmpty((String)((String)indInfo.get("areaname"))) || HRStringUtils.isEmpty((String)((String)indInfo.get("indctrname"))));
        if (existNullField) {
            return ApiResult.toMap((ApiResult)ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u3010{0}\u3011\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorScoreImportDomainService_0", (String)"opmc-epa-business", (Object[])new Object[]{"perffilenumber,areaname,indctrname"})));
        }
        List fileNumberList = indicatorList.stream().map(indInfo -> (String)indInfo.get("perffilenumber")).collect(Collectors.toList());
        QFilter activityFilter = new QFilter("activity", "=", (Object)activityDy.getLong("id"));
        QFilter fileNumberFilter = new QFilter("perffile.number", "in", fileNumberList);
        DynamicObject[] objDys = EVAL_OBJ_ENTITY.query("perffile.number", new QFilter[]{activityFilter, fileNumberFilter});
        Map<Long, String> fileNumberObjMap = Arrays.stream(objDys).collect(Collectors.toMap(objDy -> objDy.getLong("id"), objDy -> objDy.getString("perffile.number"), (v1, v2) -> v1));
        Map<String, Map<String, Object>> indParamMap = indicatorList.stream().collect(Collectors.toMap(indInfo -> (String)indInfo.get("perffilenumber") + indInfo.get("areaname") + indInfo.get("indctrname"), Function.identity()));
        if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            return this.processAddSubIndicator(fileNumberObjMap, indParamMap);
        }
        if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            return this.processGenIndicator(activityDy, fileNumberObjMap, indParamMap);
        }
        return ApiResult.toMap((ApiResult)ApiResult.fail((String)ResManager.loadKDString((String)"\u5176\u4ed6\u533a\u57df\u6682\u4e0d\u652f\u6301\u5bfc\u5165", (String)"IndicatorScoreImportDomainService_3", (String)"opmc-epa-business", (Object[])new Object[0])));
    }

    private Map<String, Object> processGenIndicator(DynamicObject activityDy, Map<Long, String> fileNumberObjMap, Map<String, Map<String, Object>> indParamMap) {
        ArrayList<Long> objIds = new ArrayList<Long>(fileNumberObjMap.keySet());
        Object[] importInds = this.queryIndicator(activityDy.getLong("id"), objIds);
        if (ObjectUtils.isEmpty((Object[])importInds)) {
            return ApiResult.toMap((ApiResult)ApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u6307\u6807\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5b57\u6bb5\u3010{0}\u3011\u8fdb\u884c\u5339\u914d\u6216\u68c0\u67e5\u6307\u6807\u662f\u5426\u4e3a\u540e\u53f0\u5f55\u5165\u6307\u6807\u3002", (String)"IndicatorScoreImportDomainService_4", (String)"opmc-epa-business", (Object[])new Object[]{"perffilenumber,areaname,indctrname"})));
        }
        DynamicObject[] indDys = GEN_AREA_INDICATOR_ENTITY.loadDynamicObjectArray(Arrays.stream(importInds).map(importInd -> importInd.getLong("indicator.id")).toArray(Long[]::new));
        Map indDyMap = Arrays.stream(indDys).collect(Collectors.toMap(indDy -> indDy.getLong("id"), Function.identity()));
        HashMap<String, DynamicObject> successData = new HashMap<String, DynamicObject>(16);
        DataEntityPropertyCollection properties = indDys[0].getDataEntityType().getProperties();
        Set fields = properties.stream().map(IMetadata::getName).collect(Collectors.toSet());
        fields.removeAll(ignoreFields);
        for (Object importInd2 : importInds) {
            String key = importInd2.getString("perffilenumber") + importInd2.getString("areaname") + importInd2.getString("indicatorname");
            DynamicObject indDy2 = (DynamicObject)indDyMap.get(importInd2.getLong("indicator.id"));
            Map<String, Object> indParam = indParamMap.remove(key);
            if (ObjectUtils.isEmpty(indParam)) continue;
            for (Map.Entry<String, Object> fieldInfo : indParam.entrySet()) {
                if (!fields.contains(fieldInfo.getKey())) continue;
                indDy2.set(fieldInfo.getKey(), fieldInfo.getValue());
            }
            successData.put(key, indDy2);
        }
        GEN_AREA_INDICATOR_ENTITY.save(successData.values().toArray(new DynamicObject[0]));
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("success_data", successData.keySet());
        map.put("failed_data", indParamMap.keySet());
        if (!ObjectUtils.isEmpty(indParamMap)) {
            map.put("failed_msg", ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u6307\u6807\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5b57\u6bb5\u3010{0}\u3011\u8fdb\u884c\u5339\u914d\u6216\u68c0\u67e5\u6307\u6807\u662f\u5426\u4e3a\u540e\u53f0\u5f55\u5165\u6307\u6807\u3002", (String)"IndicatorScoreImportDomainService_4", (String)"opmc-epa-business", (Object[])new Object[]{"perffilenumber,areaname,indctrname"}));
        }
        return ApiResult.toMap((ApiResult)ApiResult.success(map));
    }

    private Map<String, Object> processAddSubIndicator(Map<Long, String> fileNumberObjMap, Map<String, Map<String, Object>> indParamMap) {
        DynamicObject[] objects;
        Set<Long> objIds = fileNumberObjMap.keySet();
        HashMap<Long, Long> areaInsIdMap = new HashMap<Long, Long>(objIds.size());
        for (DynamicObject dynamicObject : objects = EVAL_OBJ_ENTITY.queryActEvalObjByIds(new ArrayList<Long>(objIds))) {
            DynamicObjectCollection areaEntry = dynamicObject.getDynamicObjectCollection("areaentry");
            for (DynamicObject area : areaEntry) {
                if (area.getLong("areareg.id") != AssessRuleConstants.PLUS_MINUS_AREA_PK.longValue()) continue;
                areaInsIdMap.put(area.getLong("areains"), dynamicObject.getLong("id"));
            }
        }
        QFilter insIdFilter = new QFilter("id", "in", areaInsIdMap.keySet());
        DynamicObject[] areaInsDys = ADD_SUB_AREA_INS_ENTITY.query("areaactevalobj,areaconf.areacustname", new QFilter[]{insIdFilter});
        HashMap<Long, String> areaInsMap = new HashMap<Long, String>(areaInsDys.length);
        for (DynamicObject areaInsDy2 : areaInsDys) {
            long objId = (Long)areaInsIdMap.get(areaInsDy2.getLong("id"));
            areaInsMap.put(areaInsDy2.getLong("id"), fileNumberObjMap.get(objId) + areaInsDy2.getString("areaconf.areacustname"));
        }
        List list = Arrays.stream(areaInsDys).map(areaInsDy -> areaInsDy.getLong("id")).collect(Collectors.toList());
        QFilter areaInsFilter = new QFilter("instanceid", "in", list);
        Object[] indicatorDys = ADD_SUB_AREA_INDICATOR_ENTITY.loadDynamicObjectArray(new QFilter[]{areaInsFilter});
        if (ObjectUtils.isEmpty((Object[])indicatorDys)) {
            return ApiResult.toMap((ApiResult)ApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u6307\u6807\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5b57\u6bb5\u3010{0}\u3011\u8fdb\u884c\u5339\u914d\u3002", (String)"IndicatorScoreImportDomainService_5", (String)"opmc-epa-business", (Object[])new Object[]{"perffilenumber,areaname,indctrname"})));
        }
        DataEntityPropertyCollection properties = indicatorDys[0].getDataEntityType().getProperties();
        Set fields = properties.stream().map(IMetadata::getName).collect(Collectors.toSet());
        fields.removeAll(ignoreFields);
        HashMap<String, Object> successData = new HashMap<String, Object>(16);
        for (Object indicatorDy : indicatorDys) {
            long instanceId = indicatorDy.getLong("instanceid");
            String key = (String)areaInsMap.get(instanceId) + indicatorDy.getString("indctrname");
            Map<String, Object> indInfoMap = indParamMap.remove(key);
            if (ObjectUtils.isEmpty(indInfoMap)) continue;
            for (Map.Entry<String, Object> indFieldInfo : indInfoMap.entrySet()) {
                String field = indFieldInfo.getKey();
                if (!fields.contains(field)) continue;
                indicatorDy.set(field, indFieldInfo.getValue());
            }
            successData.put(key, indicatorDy);
        }
        ADD_SUB_AREA_INDICATOR_ENTITY.save(successData.values().toArray(new DynamicObject[0]));
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("success_data", successData.keySet());
        map.put("failed_data", indParamMap.keySet());
        if (!ObjectUtils.isEmpty(indParamMap)) {
            map.put("failed_msg", ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u6307\u6807\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5b57\u6bb5\u3010{0}\u3011\u8fdb\u884c\u5339\u914d\u3002", (String)"IndicatorScoreImportDomainService_5", (String)"opmc-epa-business", (Object[])new Object[]{"perffilenumber,areaname,indctrname"}));
        }
        return ApiResult.toMap((ApiResult)ApiResult.success(map));
    }
}

