/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.assessrule.entityservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.common.constants.AreaFieldConstants;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.assessrule.EvalWayEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.pbs.business.domain.OpmcEntityService;

public class AreaFieldEntityService
extends OpmcEntityService
implements AreaFieldConstants {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("epa_areafieldreg");

    public static AreaFieldEntityService getInstance() {
        return ServiceFactory.getService(AreaFieldEntityService.class);
    }

    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject[] queryDefaultNormalFields(ScoreCalcWayEnum scoreCalcWayEnum, EvalWayEnum evalWayEnum) {
        QFilter areaFilter = new QFilter("area", "=", (Object)AssessRuleConstants.NORM_INDCTR_AREA_PK);
        QFilter qFilter = new QFilter("isdefault", "=", (Object)true);
        ArrayList<String> numberList = new ArrayList<String>(3);
        if (ScoreCalcWayEnum.WEIGHT == scoreCalcWayEnum || EvalWayEnum.LEVEL == evalWayEnum) {
            numberList.add("weight");
        }
        if (EvalWayEnum.SCORE == evalWayEnum) {
            numberList.add("evalscore");
            if (ScoreCalcWayEnum.SUM == scoreCalcWayEnum) {
                numberList.add("indctrscore");
            }
        }
        if (numberList.size() > 0) {
            qFilter.or("number", "in", numberList);
        }
        return this.query("ismustinput", new QFilter[]{areaFilter, qFilter}, "index");
    }

    public DynamicObject[] queryDefaultPlusMinusFields() {
        QFilter qFilter = new QFilter("area", "=", (Object)AssessRuleConstants.PLUS_MINUS_AREA_PK).and("isdefault", "=", (Object)true);
        return this.query("ismustinput", new QFilter[]{qFilter}, "index");
    }

    public DynamicObject[] queryDefaultAttachFields() {
        QFilter qFilter = new QFilter("area", "=", (Object)AssessRuleConstants.ATTACH_AREA_PK).and("isdefault", "=", (Object)true);
        return this.query("ismustinput", new QFilter[]{qFilter}, "index");
    }

    public DynamicObject[] queryRelatedFields(Long areaPk, List<String> numberList) {
        QFilter qFilter = new QFilter("area", "=", (Object)areaPk).and("number", "in", numberList);
        return this.query("ismustinput", new QFilter[]{qFilter}, "index");
    }

    public DynamicObject[] queryDefaultSumFields(boolean isSetSumPerfLevel, EvalWayEnum evalWayEnum) {
        QFilter areaFilter = new QFilter("area", "=", (Object)AssessRuleConstants.SUM_AREA_PK);
        QFilter qFilter = new QFilter("isdefault", "=", (Object)true);
        ArrayList<String> numberList = new ArrayList<String>(2);
        if (isSetSumPerfLevel || EvalWayEnum.LEVEL == evalWayEnum) {
            numberList.add("ole");
        }
        if (EvalWayEnum.SCORE == evalWayEnum) {
            numberList.add("ose");
        }
        if (numberList.size() > 0) {
            qFilter.or("number", "in", numberList);
        }
        return this.query(new QFilter[]{areaFilter, qFilter}, "index");
    }

    public DynamicObject[] queryDefaultEmpInfoFields() {
        QFilter qFilter = new QFilter("area", "=", (Object)AssessRuleConstants.EMP_INFO_AREA_PK);
        return this.query("isdefault", new QFilter[]{qFilter}, "index");
    }

    public DynamicObject[] queryDefaultCustomConfFields() {
        QFilter qFilter = new QFilter("area", "=", (Object)AssessRuleConstants.CUSTOM_AREA_PK);
        qFilter.and("isdefault", "=", (Object)Boolean.TRUE);
        return this.query("proptype,isdefault", new QFilter[]{qFilter}, "index");
    }

    public DynamicObject[] querySysPresetFieldsByAreaId(Long areaId) {
        QFilter qFilter = new QFilter("area", "=", (Object)areaId);
        return this.query("id", new QFilter[]{qFilter}, "index");
    }
}

