/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.assessrule.service;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.assessrule.entityservice.AreaFieldEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.AreaRegEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.AttachConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.CustomConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.EmpInfoConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.NormalConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.PlusMinusConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.SumConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.enums.NormalAreaFieldSeqEnum;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.assessrule.EvalWayEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.common.enums.FieldTypeEnum;

public class AssessRuleDomainService {
    private static final Log LOG = LogFactory.getLog(AssessRuleDomainService.class);
    private static final NormalConfigEntityService NORMAL_CONFIG_ENTITY_SERVICE = NormalConfigEntityService.getInstance();
    private static final PlusMinusConfigEntityService PLUS_MINUS_CONFIG_ENTITY_SERVICE = PlusMinusConfigEntityService.getInstance();
    private static final SumConfigEntityService SUM_CONFIG_ENTITY_SERVICE = SumConfigEntityService.getInstance();
    private static final EmpInfoConfigEntityService EMP_INFO_CONFIG_ENTITY_SERVICE = EmpInfoConfigEntityService.getInstance();
    private static final CustomConfigEntityService CUSTOM_CONFIG_ENTITY_SERVICE = CustomConfigEntityService.getInstance();
    private static final AreaRegEntityService AREA_REG_ENTITY_SERVICE = AreaRegEntityService.getInstance();
    private static final AreaFieldEntityService AREA_FIELD_ENTITY_SERVICE = AreaFieldEntityService.getInstance();
    private static final AttachConfigEntityService ATTACH_CONFIG_ENTITY_SERVICE = AttachConfigEntityService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY = PerfLevelEntityService.getInstance();

    public static AssessRuleDomainService getInstance() {
        return ServiceFactory.getService(AssessRuleDomainService.class);
    }

    public Long getDefaultNormalConf(DynamicObject assessFormDynObj, Object areaName, ScoreCalcWayEnum scoreCalcWayEnum, EvalWayEnum evalWayEnum) {
        DynamicObject normalConf = NORMAL_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
        normalConf.set("areacustname", areaName);
        normalConf.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObject[] areaFields = AREA_FIELD_ENTITY_SERVICE.queryDefaultNormalFields(scoreCalcWayEnum, evalWayEnum);
        DynamicObjectCollection entryEntity = normalConf.getDynamicObjectCollection("entryentity");
        this.initNormalAreaField(areaFields, entryEntity);
        String scoreCalcWay = assessFormDynObj.getString("scorecalcway");
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            normalConf.set("scoresystem", assessFormDynObj.get("scoresystem"));
        }
        NORMAL_CONFIG_ENTITY_SERVICE.saveOne(normalConf);
        return (Long)normalConf.getPkValue();
    }

    public Object[] getDefaultNormalConfArr(DynamicObject assessFormDynObj, Map<Long, Object> normalAreaNameAndNewIdMap, ScoreCalcWayEnum scoreCalcWayEnum, EvalWayEnum evalWayEnum) {
        DynamicObject[] dynObjArr = new DynamicObject[normalAreaNameAndNewIdMap.size()];
        DynamicObject[] areaFields = AREA_FIELD_ENTITY_SERVICE.queryDefaultNormalFields(scoreCalcWayEnum, evalWayEnum);
        int i = 0;
        for (Map.Entry<Long, Object> entry : normalAreaNameAndNewIdMap.entrySet()) {
            DynamicObject normalConf = NORMAL_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
            normalConf.set("areacustname", entry.getValue());
            normalConf.set("id", (Object)entry.getKey());
            normalConf.set("creator", (Object)RequestContext.get().getCurrUserId());
            DynamicObjectCollection entryEntity = normalConf.getDynamicObjectCollection("entryentity");
            this.initNormalAreaField(areaFields, entryEntity);
            String scoreCalcWay = assessFormDynObj.getString("scorecalcway");
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                normalConf.set("scoresystem", assessFormDynObj.get("scoresystem"));
            }
            dynObjArr[i] = normalConf;
            ++i;
        }
        return NORMAL_CONFIG_ENTITY_SERVICE.save(dynObjArr);
    }

    public Long getDefaultPlusMinusConf(Object areaName) {
        DynamicObject plusMinusConf = PLUS_MINUS_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
        plusMinusConf.set("areacustname", areaName);
        plusMinusConf.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObject[] areaFields = AREA_FIELD_ENTITY_SERVICE.queryDefaultPlusMinusFields();
        DynamicObjectCollection entryEntity = plusMinusConf.getDynamicObjectCollection("entryentity");
        this.initAreaField(areaFields, entryEntity);
        PLUS_MINUS_CONFIG_ENTITY_SERVICE.saveOne(plusMinusConf);
        return (Long)plusMinusConf.getPkValue();
    }

    public Long getDefaultAttachConf(Object areaName) {
        DynamicObject attachConf = ATTACH_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
        attachConf.set("areacustname", areaName);
        attachConf.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObject[] areaFields = AREA_FIELD_ENTITY_SERVICE.queryDefaultAttachFields();
        DynamicObjectCollection entryEntity = attachConf.getDynamicObjectCollection("entryentity");
        this.initAreaField(areaFields, entryEntity);
        ATTACH_CONFIG_ENTITY_SERVICE.saveOne(attachConf);
        return (Long)attachConf.getPkValue();
    }

    public Long getDefaultSumConf(boolean isSetSumPerfLevel, EvalWayEnum evalWayEnum) {
        DynamicObject sumConf = SUM_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
        DynamicObject sumArea = this.queryAreaRegByPk(AssessRuleConstants.SUM_AREA_PK);
        sumConf.set("areacustname", sumArea.get("name"));
        sumConf.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObject[] areaFields = AREA_FIELD_ENTITY_SERVICE.queryDefaultSumFields(isSetSumPerfLevel, evalWayEnum);
        DynamicObjectCollection entryEntity = sumConf.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject areaField : areaFields) {
            DynamicObject fieldInfo = entryEntity.addNew();
            fieldInfo.set("areafield", (Object)areaField);
            fieldInfo.set("fieldcustname", areaField.get("name"));
            fieldInfo.set("seq", (Object)seq++);
        }
        SUM_CONFIG_ENTITY_SERVICE.saveOne(sumConf);
        return (Long)sumConf.getPkValue();
    }

    public Long getDefaultEmpInfoConf() {
        DynamicObject empInfoConf = EMP_INFO_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
        DynamicObject[] areaFields = AREA_FIELD_ENTITY_SERVICE.queryDefaultEmpInfoFields();
        DynamicObjectCollection entryEntity = empInfoConf.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject areaField : areaFields) {
            if (HRStringUtils.equals((String)"stdposition", (String)areaField.getString("number"))) continue;
            DynamicObject fieldInfo = entryEntity.addNew();
            fieldInfo.set("areafield", (Object)areaField);
            fieldInfo.set("seq", (Object)seq++);
        }
        EMP_INFO_CONFIG_ENTITY_SERVICE.saveOne(empInfoConf);
        return (Long)empInfoConf.getPkValue();
    }

    public Long getDefaultCustomConf(Object areaName) {
        DynamicObject[] defaultCustomConfFields = AREA_FIELD_ENTITY_SERVICE.queryDefaultCustomConfFields();
        DynamicObject emptyDynamicObject = CUSTOM_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
        emptyDynamicObject.set("areacustname", areaName);
        emptyDynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection collection = emptyDynamicObject.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject customConfField : defaultCustomConfFields) {
            DynamicObject newEntry = collection.addNew();
            newEntry.set("areafield", (Object)customConfField);
            newEntry.set("fieldcustname", (Object)customConfField.getString("name"));
            if (FieldTypeEnum.Attachment.equals((Object)FieldTypeEnum.getFieldPropEnum((String)customConfField.getString("proptype")))) {
                newEntry.set("fieldtype", (Object)"0");
            } else {
                newEntry.set("fieldtype", (Object)"1");
            }
            newEntry.set("seq", (Object)seq++);
        }
        CUSTOM_CONFIG_ENTITY_SERVICE.saveOne(emptyDynamicObject);
        return emptyDynamicObject.getLong("id");
    }

    private void initAreaField(DynamicObject[] areaFields, DynamicObjectCollection entryEntity) {
        int seq = 1;
        for (DynamicObject areaField : areaFields) {
            DynamicObject fieldInfo = entryEntity.addNew();
            fieldInfo.set("areafield", (Object)areaField);
            fieldInfo.set("fieldcustname", areaField.get("name"));
            fieldInfo.set("seq", (Object)seq++);
        }
    }

    public DynamicObject queryAreaRegByPk(Long pk) {
        return AREA_REG_ENTITY_SERVICE.queryOne(pk);
    }

    public DynamicObject queryNormalConfigByPk(Long pk) {
        return NORMAL_CONFIG_ENTITY_SERVICE.queryOne(pk);
    }

    public DynamicObject queryCustomConfigByPk(Long pk) {
        return CUSTOM_CONFIG_ENTITY_SERVICE.queryOne(pk);
    }

    public DynamicObject[] queryNormalConfigByIds(Collection<Long> idColl) {
        return NORMAL_CONFIG_ENTITY_SERVICE.query("areascore,weight,scoresystem,entryentity.areafield,entryentity.fieldcustname,areacustname", new QFilter("id", "in", idColl).toArray());
    }

    public void updateNormalConfig(DynamicObject[] normalConfigArr) {
        NORMAL_CONFIG_ENTITY_SERVICE.update(normalConfigArr);
    }

    public DynamicObject[] queryCustomAreaAllFields() {
        QFilter qFilter = new QFilter("area", "=", (Object)AssessRuleConstants.CUSTOM_AREA_PK);
        qFilter.and("enable", "=", (Object)"1");
        return AREA_FIELD_ENTITY_SERVICE.query("number", qFilter.toArray());
    }

    public Map<Long, Boolean> getIsPartInMap(List<Long> confIdList, Long areaTypeId) {
        DynamicObject[] configs = AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaTypeId) ? NORMAL_CONFIG_ENTITY_SERVICE.queryOriginalConfByPks(confIdList) : PLUS_MINUS_CONFIG_ENTITY_SERVICE.queryOriginalConfByPks(confIdList);
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)configs.length);
        for (DynamicObject config : configs) {
            retMap.put(config.getLong("id"), config.getBoolean("ispartin"));
        }
        return retMap;
    }

    public Long copyNormalConfigByPk(Long pk) {
        DynamicObject conf = NORMAL_CONFIG_ENTITY_SERVICE.queryOne(pk);
        DynamicObject newConf = NORMAL_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)conf, (DynamicObject)newConf);
        NORMAL_CONFIG_ENTITY_SERVICE.saveOne(newConf);
        return (Long)newConf.getPkValue();
    }

    public DynamicObject queryPlusMinusConfigByPk(Long pk) {
        return PLUS_MINUS_CONFIG_ENTITY_SERVICE.queryOne(pk);
    }

    public Long copyPlusMinusConfigByPk(Long pk) {
        DynamicObject conf = PLUS_MINUS_CONFIG_ENTITY_SERVICE.queryOne(pk);
        DynamicObject newConf = PLUS_MINUS_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)conf, (DynamicObject)newConf);
        PLUS_MINUS_CONFIG_ENTITY_SERVICE.saveOne(newConf);
        return (Long)newConf.getPkValue();
    }

    public DynamicObject queryAttachConfigByPk(Long pk) {
        return ATTACH_CONFIG_ENTITY_SERVICE.queryOne(pk);
    }

    public Long copyAttachConfigByPk(Long pk) {
        DynamicObject conf = ATTACH_CONFIG_ENTITY_SERVICE.queryOne(pk);
        DynamicObject newConf = ATTACH_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)conf, (DynamicObject)newConf);
        ATTACH_CONFIG_ENTITY_SERVICE.saveOne(newConf);
        return (Long)newConf.getPkValue();
    }

    public DynamicObject querySumConfigByPk(Long pk) {
        return SUM_CONFIG_ENTITY_SERVICE.queryOne(pk);
    }

    public Long copySumConfigByPk(Long pk) {
        DynamicObject conf = SUM_CONFIG_ENTITY_SERVICE.queryOne(pk);
        DynamicObject newConf = SUM_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)conf, (DynamicObject)newConf);
        SUM_CONFIG_ENTITY_SERVICE.saveOne(newConf);
        return (Long)newConf.getPkValue();
    }

    public Long copyCustomConfigByPk(Long pk) {
        DynamicObject conf = CUSTOM_CONFIG_ENTITY_SERVICE.queryOne(pk);
        DynamicObject newConf = CUSTOM_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)conf, (DynamicObject)newConf);
        CUSTOM_CONFIG_ENTITY_SERVICE.saveOne(newConf);
        return (Long)newConf.getPkValue();
    }

    public DynamicObject queryEmpInfoConfigByPk(Long pk) {
        return EMP_INFO_CONFIG_ENTITY_SERVICE.queryOne(pk);
    }

    public Long copyEmpInfoConfigByPk(Long pk) {
        DynamicObject conf = EMP_INFO_CONFIG_ENTITY_SERVICE.queryOne(pk);
        DynamicObject newConf = EMP_INFO_CONFIG_ENTITY_SERVICE.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)conf, (DynamicObject)newConf);
        EMP_INFO_CONFIG_ENTITY_SERVICE.saveOne(newConf);
        return (Long)newConf.getPkValue();
    }

    public DynamicObject[] queryRelatedFields(Long areaPk, List<String> numberList) {
        return AREA_FIELD_ENTITY_SERVICE.queryRelatedFields(areaPk, numberList);
    }

    public DynamicObjectCollection queryAssFlowByRule(Long ruleId) {
        return new DynamicObjectCollection();
    }

    public String calculateLevel(DynamicObject assessForm, BigDecimal score) {
        if (assessForm.getDynamicObject("scoresystem") == null || assessForm.getDynamicObject("sumperflevel") == null) {
            return "";
        }
        long scoreSystemId = assessForm.getLong("scoresystem.id");
        long sumPerfLevelId = assessForm.getLong("sumperflevel.id");
        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelId);
        DynamicObjectCollection scoreMapEntry = sumPerfLevel.getDynamicObjectCollection("scoremapentryentity");
        DynamicObject scoreMapDy = scoreMapEntry.stream().filter(scoreMap -> scoreMap.getLong("scoresystem.id") == scoreSystemId).findFirst().orElse(null);
        if (scoreMapDy == null) {
            LOG.error("Unable to find score system mapping for performance level, scoreSystemId[{}], sumPerfLevelId[{}]", (Object)scoreSystemId, (Object)sumPerfLevelId);
            return "";
        }
        String levelScoreMap = scoreMapDy.getString("levelscoremap");
        if (HRStringUtils.equals((String)levelScoreMap, (String)"20")) {
            LOG.error("Mapping by default is not supported");
            return "";
        }
        DynamicObjectCollection scoreLevelMapEntry = scoreMapDy.getDynamicObjectCollection("scoresubentryentity");
        for (DynamicObject scoreLevelMap : scoreLevelMapEntry) {
            BigDecimal maxScore = scoreLevelMap.getBigDecimal("maxscore");
            String scoreMaxOperation = scoreLevelMap.getString("scoremaxoperation");
            String scoreMinOperation = scoreLevelMap.getString("scoreminoperation");
            BigDecimal minScore = scoreLevelMap.getBigDecimal("minscore");
            boolean maxCompare = true;
            if (maxScore != null && maxScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMaxOperation, (String)"10")) {
                    maxCompare = maxScore.compareTo(score) > 0;
                } else if (HRStringUtils.equals((String)scoreMaxOperation, (String)"20")) {
                    maxCompare = maxScore.compareTo(score) >= 0;
                }
            }
            boolean minCompare = true;
            if (minScore != null && minScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMinOperation, (String)"10")) {
                    minCompare = score.compareTo(minScore) > 0;
                } else if (HRStringUtils.equals((String)scoreMinOperation, (String)"20")) {
                    boolean bl = minCompare = score.compareTo(minScore) >= 0;
                }
            }
            if (!maxCompare || !minCompare) continue;
            return scoreLevelMap.getString("seq");
        }
        return "";
    }

    public DynamicObject getAreaRegFieldBy(long areaRegFieldId) {
        return AREA_FIELD_ENTITY_SERVICE.queryOne("name", areaRegFieldId);
    }

    private void initNormalAreaField(DynamicObject[] areaFields, DynamicObjectCollection entryEntity) {
        int seq = 1;
        for (DynamicObject areaField : areaFields) {
            DynamicObject fieldInfo = entryEntity.addNew();
            fieldInfo.set("areafield", (Object)areaField);
            fieldInfo.set("fieldcustname", areaField.get("name"));
            seq = NormalAreaFieldSeqEnum.getSeqByFieldNumber(areaField.getString("number"));
            fieldInfo.set("seq", (Object)seq);
        }
    }
}

