/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.evaladjustment.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.Pair;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.application.service.dynpermission.DynPermissionConfigService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.AreaFieldEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.NormalConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.PlusMinusConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.SumConfigEntityService;
import kd.opmc.epa.business.domain.evaladjustment.entity.EmpInfoConfEntityService;
import kd.opmc.epa.business.domain.evaladjustment.entity.EvalAdjustmentEntityService;
import kd.opmc.epa.business.domain.evaloverall.entity.ProcessPermsettingEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjGenAreaRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjProcessPermSettingEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjSumAreaRecordEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.assessrule.EvalWayEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.common.enums.evaloverall.ProcPermContentEnum;
import kd.opmc.epa.common.vo.dynpermission.ContentAreaEntry;
import kd.opmc.epa.common.vo.dynpermission.ContentFieldEntry;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.ScoreSystemEntityService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.BatchTaskmapEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;
import kd.opmc.pbs.business.model.NodeRoleConfigBo;
import kd.opmc.pbs.common.enums.FieldTypeEnum;
import kd.opmc.pmd.business.domain.perffile.entityservice.PerffileEntityService;

public class ActEvalObjAdjDomainService {
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RUSECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final FlowDefProcEntityService FLOW_DEF_PROC_ENTITY_SERVICE = FlowDefProcEntityService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUN_SUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    private static final FlowDefRoleEntityService FLOW_DEF_ROLE_ENTITY = FlowDefRoleEntityService.getInstance();
    private static final AreaFieldEntityService AREA_FIELD_ENTITY_SERVICE = AreaFieldEntityService.getInstance();
    private static final ObjProcessPermSettingEntityService PROCESS_PERM_SETTING_ENTITY_SERVICE = ObjProcessPermSettingEntityService.getInstance();
    private static final ObjGenAreaRecordEntityService GEN_AREA_RECORD_ENTITY = ObjGenAreaRecordEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE = ActivityEvaluationObjectEntityService.getInstance();
    private static final BatchTaskmapEntityService BATCH_TASKMAP_ENTITY_SERVICE = BatchTaskmapEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService EPA_ACTEVALOBJ_SERVICE = ActivityEvaluationObjectEntityService.getInstance();
    private static final PerffileEntityService PERFFILE_ENTITY_SERVICE = PerffileEntityService.getInstance();
    private static final AssessActivityEntityService ASSESS_ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final SumConfigEntityService SUM_CONFIG_ENTITY_SERVICE = SumConfigEntityService.getInstance();
    private static final EmpInfoConfEntityService EMP_INFO_CONF_ENTITY_SERVICE = EmpInfoConfEntityService.getInstance();
    private static final ProcessPermsettingEntityService PROCESS_PERMSETTING_ENTITY_SERVICE = ProcessPermsettingEntityService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY = PerfLevelEntityService.getInstance();
    private static final ScoreSystemEntityService SCORE_SYSTEM_ENTITY = ScoreSystemEntityService.getInstance();
    private static final EvalAdjustmentEntityService EVAL_ADJUSTMENT_ENTITY_SERVICE = EvalAdjustmentEntityService.getInstance();
    private static final ObjGenAreaInsEntityService OBJ_GEN_AREA_INS_ENTITY_SERVICE = ObjGenAreaInsEntityService.getInstance();
    private static final ObjAddSubAreaInsEntityService OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE = ObjAddSubAreaInsEntityService.getInstance();
    private static final NormalConfigEntityService NORMAL_CONFIG_ENTITY_SERVICE = NormalConfigEntityService.getInstance();
    private static final PlusMinusConfigEntityService PLUS_MINUS_CONFIG_ENTITY_SERVICE = PlusMinusConfigEntityService.getInstance();
    private static final ObjSumAreaRecordEntityService OBJ_SUM_AREA_RECORD_ENTITY_SERVICE = ObjSumAreaRecordEntityService.getInstance();
    private static final ObjNodeResEntityService OBJ_NODE_RES_ENTITY_SERVICE = ObjNodeResEntityService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY = ExecuteSchemeEntityService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final IHRPIPersonService PERSON_SERVICE = IHRPIPersonService.getInstance();
    private static final Log LOG = LogFactory.getLog(ActEvalObjAdjDomainService.class);

    public static ActEvalObjAdjDomainService getInstance() {
        return ServiceFactory.getService(ActEvalObjAdjDomainService.class);
    }

    public Pair<Boolean, String> checkTaskInfo(Long taskId) {
        if (StringUtils.isEmpty((CharSequence)String.valueOf(taskId))) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"ActEvalObjAdjDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        DynamicObject taskDy = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        long userId = RequestContext.get().getCurrUserId();
        if (ObjectUtils.isEmpty((Object)taskDy) || userId != taskDy.getLong("handler.id")) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"ActEvalObjAdjDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        String flowStatus = taskDy.getString("flowruproc.procstatus");
        if (StringUtils.equals((CharSequence)flowStatus, (CharSequence)FlowRuProcStatusEnum.STOP.getCode())) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8bc4\u4f30\u6d41\u7a0b\u201c{0}\u201d\u6062\u590d\u6b63\u5e38\u540e\uff0c\u8bc4\u4f30\u4efb\u52a1\u5c06\u91cd\u65b0\u53d1\u9001\uff0c\u5c4a\u65f6\u53ef\u518d\u6b21\u8bc4\u4f30\u3002", (String)"ActEvalObjAdjDomainService_1", (String)"opmc-epa-business", (Object[])new Object[]{FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)flowStatus).getText()}));
        }
        if (StringUtils.equals((CharSequence)flowStatus, (CharSequence)FlowRuProcStatusEnum.DEPRECATED.getCode())) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ActEvalObjAdjDomainService_2", (String)"opmc-epa-business", (Object[])new Object[]{FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)flowStatus).getText()}));
        }
        FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskDy.getString("taskstatus"));
        if (taskStatus == FlowRuTaskStatusEnum.REJECTED || taskStatus == FlowRuTaskStatusEnum.EXPIRED) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ActEvalObjAdjDomainService_2", (String)"opmc-epa-business", (Object[])new Object[]{taskStatus.getText()}));
        }
        return new Pair((Object)Boolean.TRUE, (Object)"");
    }

    public void processTask(List<Long> taskIdList) {
        for (Long taskId : taskIdList) {
            FLOW_RU_PROC_DOMAIN_SERVICE.processTask(taskId);
        }
    }

    public List<Map<String, Object>> querySumAdjConf(Long taskId) {
        Map oleRowObj;
        Boolean fieldmodifyitem;
        Boolean fieldmustinputitem;
        Boolean fielddisplayitem;
        Map oseRowObj;
        Map oseRowObj2;
        ArrayList<Map<String, Object>> sumFieldsList = new ArrayList<Map<String, Object>>(10);
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowruproc, flowrunode", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, dynamicpermission", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("evalway, numaccuracy, sumconf, sumperflevel ", new QFilter[]{assessFormFilter});
        int numaccuracy = assessFormObj.getInt("numaccuracy");
        Long sumConfIdId = assessFormObj.getLong("sumconf");
        DynamicObject sumConfObj = SUM_CONFIG_ENTITY_SERVICE.queryOne(sumConfIdId);
        DynamicObjectCollection filedEntry = sumConfObj.getDynamicObjectCollection("entryentity");
        Map fieldMap = filedEntry.stream().collect(Collectors.toMap(filedInfo -> filedInfo.getDynamicObject("areafield").getString("number"), Function.identity()));
        QFilter flowruprocFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowruproc.id"));
        DynamicObject flowruprocObj = FLOW_RU_PROC_ENTITY_SERVICE.queryOne("defproc", new QFilter[]{flowruprocFilter});
        QFilter flowrunodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject flowrunodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("flownodedef", new QFilter[]{flowrunodeFilter});
        QFilter defprocFilter = new QFilter("id", "=", (Object)flowruprocObj.getLong("defproc.id"));
        DynamicObject defprocObj = FLOW_DEF_PROC_ENTITY_SERVICE.queryOne("name, index, nodeentry, nodeentry.adjusetscorelowerlimit, nodeentry.adjustscoreuplimit", new QFilter[]{defprocFilter});
        DynamicObjectCollection defNodeConfig = defprocObj.getDynamicObjectCollection("nodeentry");
        DynamicObject defnodeObj = defNodeConfig.stream().filter(obj -> flowrunodeObj.getLong("flownodedef.id") == obj.getLong("id")).findFirst().orElse(null);
        BigDecimal adjusetscorelowerlimit = defnodeObj.getBigDecimal("adjusetscorelowerlimit");
        BigDecimal adjustscoreuplimit = defnodeObj.getBigDecimal("adjustscoreuplimit");
        QFilter nodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject nodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{nodeFilter});
        Map<String, Object> procPermMap = this.getProcPermMap(activityObj, sumConfIdId, nodeObj);
        HashMap<String, Object> batcsField = new HashMap<String, Object>(16);
        batcsField.put("id", "batcs");
        batcsField.put("name", ResManager.loadKDString((String)"\u73b0\u603b\u5206", (String)"ActEvalObjAdjDomainService_3", (String)"opmc-epa-business", (Object[])new Object[0]));
        batcsField.put("key", "batcs");
        batcsField.put("proptype", FieldTypeEnum.Decimal);
        batcsField.put("precision", numaccuracy + 13);
        batcsField.put("mustinput", Boolean.FALSE);
        batcsField.put("visible", Boolean.TRUE);
        batcsField.put("lock", Boolean.TRUE);
        batcsField.put("scale", numaccuracy);
        batcsField.put("maxlength", ((DynamicObject)fieldMap.get("ose")).getDynamicObject("areafield").getInt("max"));
        batcsField.put("minlength", ((DynamicObject)fieldMap.get("ose")).getDynamicObject("areafield").getInt("min"));
        sumFieldsList.add(batcsField);
        if (!procPermMap.isEmpty() && (oseRowObj2 = (Map)procPermMap.get("adjustscore")) != null) {
            Boolean fielddisplayitem2 = (Boolean)oseRowObj2.get("fielddisplayitem");
            Boolean fieldmustinputitem2 = (Boolean)oseRowObj2.get("fieldmustinputitem");
            Boolean fieldmodifyitem2 = (Boolean)oseRowObj2.get("fieldmodifyitem");
            if (fielddisplayitem2.booleanValue()) {
                HashMap<String, Object> atvField = new HashMap<String, Object>(16);
                atvField.put("id", "atv");
                atvField.put("name", ResManager.loadKDString((String)"\u8c03\u6574\u5206", (String)"ActEvalObjAdjDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]));
                atvField.put("key", "atv");
                atvField.put("proptype", FieldTypeEnum.Decimal);
                atvField.put("precision", numaccuracy + 13);
                atvField.put("mustinput", fieldmustinputitem2);
                atvField.put("visible", fielddisplayitem2);
                atvField.put("lock", fieldmodifyitem2 == false);
                atvField.put("datascope", String.format("[%s,%s]", adjusetscorelowerlimit, adjustscoreuplimit));
                atvField.put("scale", numaccuracy);
                atvField.put("maxlength", ((DynamicObject)fieldMap.get("ose")).getDynamicObject("areafield").getInt("max"));
                atvField.put("minlength", ((DynamicObject)fieldMap.get("ose")).getDynamicObject("areafield").getInt("min"));
                sumFieldsList.add(atvField);
            }
        }
        HashMap<String, Object> atcsField = new HashMap<String, Object>(16);
        atcsField.put("id", "atcs");
        atcsField.put("name", ResManager.loadKDString((String)"\u8c03\u6574\u540e\u5206\u6570", (String)"ActEvalObjAdjDomainService_5", (String)"opmc-epa-business", (Object[])new Object[0]));
        atcsField.put("key", "atcs");
        atcsField.put("proptype", FieldTypeEnum.Decimal);
        atcsField.put("precision", numaccuracy + 13);
        atcsField.put("mustinput", Boolean.FALSE);
        atcsField.put("visible", Boolean.TRUE);
        atcsField.put("lock", Boolean.TRUE);
        atcsField.put("scale", numaccuracy);
        atcsField.put("maxlength", ((DynamicObject)fieldMap.get("ose")).getDynamicObject("areafield").getInt("max"));
        atcsField.put("minlength", ((DynamicObject)fieldMap.get("ose")).getDynamicObject("areafield").getInt("min"));
        sumFieldsList.add(atcsField);
        if (!procPermMap.isEmpty() && (oseRowObj = (Map)procPermMap.get("adjustdesc")) != null) {
            fielddisplayitem = (Boolean)oseRowObj.get("fielddisplayitem");
            fieldmustinputitem = (Boolean)oseRowObj.get("fieldmustinputitem");
            fieldmodifyitem = (Boolean)oseRowObj.get("fieldmodifyitem");
            if (fielddisplayitem.booleanValue()) {
                HashMap<String, Object> insField = new HashMap<String, Object>(16);
                insField.put("id", "ins");
                insField.put("name", ResManager.loadKDString((String)"\u8c03\u6574\u8bf4\u660e", (String)"ActEvalObjAdjDomainService_6", (String)"opmc-epa-business", (Object[])new Object[0]));
                insField.put("key", "ins");
                insField.put("proptype", FieldTypeEnum.LargeTextProp);
                insField.put("mustinput", fieldmustinputitem);
                insField.put("visible", fielddisplayitem);
                insField.put("lock", fieldmodifyitem == false);
                insField.put("maxlength", ((DynamicObject)fieldMap.get("eval")).getDynamicObject("areafield").getInt("max"));
                insField.put("minlength", ((DynamicObject)fieldMap.get("eval")).getDynamicObject("areafield").getInt("min"));
                sumFieldsList.add(insField);
            }
        }
        if (!procPermMap.isEmpty() && (oleRowObj = (Map)procPermMap.get("adjustrank")) != null) {
            fielddisplayitem = (Boolean)oleRowObj.get("fielddisplayitem");
            fieldmustinputitem = (Boolean)oleRowObj.get("fieldmustinputitem");
            fieldmodifyitem = (Boolean)oleRowObj.get("fieldmodifyitem");
            if (fielddisplayitem.booleanValue()) {
                HashMap<String, Object> batclField = new HashMap<String, Object>(16);
                batclField.put("id", "batcl");
                batclField.put("name", ResManager.loadKDString((String)"\u8c03\u6574\u524d\u603b\u7b49\u7ea7", (String)"ActEvalObjAdjDomainService_7", (String)"opmc-epa-business", (Object[])new Object[0]));
                batclField.put("key", "batcl");
                batclField.put("proptype", FieldTypeEnum.Combo);
                Long perfLevelId = assessFormObj.getLong("sumperflevel.id");
                List<kd.bos.metadata.entity.commonfield.ComboItem> levelComboItem = this.queryPerfLevelByAssessForm(perfLevelId);
                batclField.put("comboitem", levelComboItem);
                batclField.put("mustinput", Boolean.FALSE);
                batclField.put("visible", Boolean.FALSE);
                batclField.put("lock", Boolean.TRUE);
                sumFieldsList.add(batclField);
                HashMap<String, Object> actlField = new HashMap<String, Object>(16);
                actlField.put("id", "atcl");
                actlField.put("name", ResManager.loadKDString((String)"\u603b\u7b49\u7ea7", (String)"ActEvalObjAdjDomainService_8", (String)"opmc-epa-business", (Object[])new Object[0]));
                actlField.put("key", "atcl");
                actlField.put("proptype", FieldTypeEnum.Combo);
                actlField.put("comboitem", levelComboItem);
                actlField.put("mustinput", fieldmustinputitem);
                actlField.put("visible", fielddisplayitem);
                actlField.put("lock", fieldmodifyitem == false);
                sumFieldsList.add(actlField);
            }
        }
        return sumFieldsList;
    }

    private Map<String, Object> getProcPermMap(DynamicObject activityObj, Long sumConfIdId, DynamicObject nodeObj) {
        Set areaFieldIdSet;
        QFilter filter;
        DynamicObject[] fieldArr;
        List contentAreaEntries;
        Map contentAreaEntriesMap;
        Long newProcPermId = activityObj.getLong("dynamicpermission.id");
        DynPermissionConfigService dynamicObjectCollection = new DynPermissionConfigService();
        long flowNodeDefId = nodeObj.getLong("flownodedef.id");
        ArrayList<Long> flowNodeIdList = new ArrayList<Long>(10);
        flowNodeIdList.add(flowNodeDefId);
        DynamicPermissionConfigVO dynamicPermissions = dynamicObjectCollection.getDynamicPermissions(newProcPermId, flowNodeIdList);
        HashMap areaFieldPermMap = new HashMap(16);
        if (dynamicPermissions != null && (contentAreaEntriesMap = dynamicPermissions.getContentAreaEntriesMap()) != null && (contentAreaEntries = (List)contentAreaEntriesMap.get(flowNodeDefId)) != null) {
            for (ContentAreaEntry contentAreaEntry : contentAreaEntries) {
                Boolean areaDisplay;
                if (contentAreaEntry == null) continue;
                Long areaPageInsId = contentAreaEntry.getAreapageInsId();
                if (sumConfIdId == null || !sumConfIdId.equals(areaPageInsId)) continue;
                List fieldEntries = contentAreaEntry.getFieldEntries();
                Boolean bl = areaDisplay = contentAreaEntry.getAreaDisplay() == null ? Boolean.FALSE : contentAreaEntry.getAreaDisplay();
                if (areaDisplay != null && !areaDisplay.booleanValue() || fieldEntries == null) continue;
                for (ContentFieldEntry fieldEntry : fieldEntries) {
                    if (fieldEntry == null) continue;
                    Long areaFieldId = fieldEntry.getAreaFieldId();
                    Boolean fieldDisplay = fieldEntry.getFieldDisplay() == null ? Boolean.FALSE : fieldEntry.getFieldDisplay();
                    Boolean fieldModify = fieldEntry.getFieldModify() == null ? Boolean.FALSE : fieldEntry.getFieldModify();
                    Boolean fieldMustInput = fieldEntry.getFieldMustInput() == null ? Boolean.FALSE : fieldEntry.getFieldMustInput();
                    HashMap<String, Boolean> procPermItemMap = new HashMap<String, Boolean>(16);
                    procPermItemMap.put("fielddisplayitem", fieldDisplay);
                    procPermItemMap.put("fieldmustinputitem", fieldMustInput);
                    procPermItemMap.put("fieldmodifyitem", fieldModify);
                    areaFieldPermMap.put(areaFieldId, procPermItemMap);
                }
            }
        }
        HashMap<String, Object> procPermMap = new HashMap<String, Object>(16);
        if (areaFieldPermMap != null && (fieldArr = AREA_FIELD_ENTITY_SERVICE.queryOriginalArray("id,number", new QFilter[]{filter = new QFilter("id", "in", areaFieldIdSet = areaFieldPermMap.keySet())})) != null) {
            block15: for (DynamicObject fieldDy : fieldArr) {
                if (fieldDy == null) continue;
                String number = fieldDy.getString("number");
                long areaFieldId = fieldDy.getLong("id");
                Map permMap = (Map)areaFieldPermMap.get(areaFieldId);
                switch (number) {
                    case "ose": 
                    case "adjustscore": {
                        procPermMap.put("adjustscore", permMap);
                        continue block15;
                    }
                    case "eval": 
                    case "adjustdesc": {
                        procPermMap.put("adjustdesc", permMap);
                        continue block15;
                    }
                    case "ole": 
                    case "adjustrank": {
                        procPermMap.put("adjustrank", permMap);
                        continue block15;
                    }
                }
            }
        }
        return procPermMap;
    }

    private List<kd.bos.metadata.entity.commonfield.ComboItem> queryPerfLevelByAssessForm(Long perfLevelId) {
        ArrayList<kd.bos.metadata.entity.commonfield.ComboItem> comboItems = new ArrayList<kd.bos.metadata.entity.commonfield.ComboItem>(10);
        if (perfLevelId == 0L) {
            return comboItems;
        }
        DynamicObject perfLevelDy = PERF_LEVEL_ENTITY.queryOne((Object)perfLevelId);
        DynamicObjectCollection levelConf = perfLevelDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject level : levelConf) {
            kd.bos.metadata.entity.commonfield.ComboItem comboItem = new kd.bos.metadata.entity.commonfield.ComboItem();
            comboItem.setCaption(new LocaleString(level.getString("levelname")));
            comboItem.setValue(level.getString("seq"));
            comboItems.add(comboItem);
        }
        return comboItems;
    }

    public DynamicObject queryActivityByTaskId(Long taskId) {
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)taskObj.getLong("activity"));
        return ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("name, period, scheme, executescheme, executescheme.assessscope", new QFilter[]{activityFilter});
    }

    public NodeRoleConfigBo queryNodeRoleConfigByTask(Long taskId) {
        if (null == taskId || taskId == 0L) {
            return null;
        }
        DynamicObject taskDy = this.queryTaskInfoById(taskId);
        long flowDefRoleId = taskDy.getLong("flowrurole.flowdefrole.id");
        DynamicObject flowDefRole = FLOW_DEF_ROLE_ENTITY.queryOne((Object)flowDefRoleId);
        String confJson = flowDefRole.getString("confjson");
        return (NodeRoleConfigBo)SerializationUtils.fromJsonString((String)confJson, NodeRoleConfigBo.class);
    }

    public DynamicObject queryTaskInfoById(Long taskId) {
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        return FLOW_RU_TASK_ENTITY_SERVICE.queryOne("taskstatus, handler, flowrunode, flowrunode.name, flowrunode.nodeweight, flowrurole, flowrurole.name", new QFilter[]{taskFilter});
    }

    public String calculateLevel(Long assessFormId, BigDecimal atcs) {
        DynamicObject assessFormDy = ASSESS_FORM_ENTITY_SERVICE.queryAssessForm(assessFormId);
        if (atcs == null || assessFormDy.getDynamicObject("scoresystem") == null || assessFormDy.getDynamicObject("sumperflevel") == null) {
            return "";
        }
        Long scoreSystemId = (Long)assessFormDy.getDynamicObject("scoresystem").getPkValue();
        Long sumPerfLevelId = (Long)assessFormDy.getDynamicObject("sumperflevel").getPkValue();
        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelId);
        DynamicObjectCollection scoreMapEntry = sumPerfLevel.getDynamicObjectCollection("scoremapentryentity");
        DynamicObject scoreMapDy = scoreMapEntry.stream().filter(scoreMap -> scoreMap.getLong("scoresystem.id") == scoreSystemId.longValue()).findFirst().orElse(null);
        if (scoreMapDy == null) {
            return null;
        }
        String levelScoreMap = scoreMapDy.getString("levelscoremap");
        if (HRStringUtils.equals((String)levelScoreMap, (String)"20")) {
            return "";
        }
        DynamicObjectCollection scoreLevelMapEntry = scoreMapDy.getDynamicObjectCollection("scoresubentryentity");
        for (DynamicObject scoreLevelMap : scoreLevelMapEntry) {
            BigDecimal maxScore = scoreLevelMap.getBigDecimal("maxscore");
            String scoreMaxOperation = scoreLevelMap.getString("scoremaxoperation");
            String scoreMinOperation = scoreLevelMap.getString("scoreminoperation");
            BigDecimal minScore = scoreLevelMap.getBigDecimal("minscore");
            boolean maxCompare = true;
            if (maxScore != null && maxScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMaxOperation, (String)"10")) {
                    maxCompare = maxScore.compareTo(atcs) > 0;
                } else if (HRStringUtils.equals((String)scoreMaxOperation, (String)"20")) {
                    maxCompare = maxScore.compareTo(atcs) >= 0;
                }
            }
            boolean minCompare = true;
            if (minScore != null && minScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMinOperation, (String)"10")) {
                    minCompare = atcs.compareTo(minScore) > 0;
                } else if (HRStringUtils.equals((String)scoreMinOperation, (String)"20")) {
                    boolean bl = minCompare = atcs.compareTo(minScore) >= 0;
                }
            }
            if (!maxCompare || !minCompare) continue;
            return scoreLevelMap.getString("seq");
        }
        return "";
    }

    public DynamicObject queryAssessFormByTaskId(Long taskId) {
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        return ASSESS_FORM_ENTITY_SERVICE.queryOne("allowexceedupper, allowexceedlower, limitmaxscore, limitminscore, scoresystem, evalway, scorecalcway, numaccuracy, sumconf, sumperflevel, scaleType, areaconfentry, areaconfentry.areareg, areaconfentry.seq, areaconf ", new QFilter[]{assessFormFilter});
    }

    public DynamicObject queryScoreSystemById(long scoresystemId) {
        return SCORE_SYSTEM_ENTITY.queryOne((Object)scoresystemId);
    }

    public DynamicObject[] queryEvalObjById(List<Long> actEvalObjIdList) {
        QFilter actEvalObjFilter = new QFilter("id", "in", actEvalObjIdList);
        return ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.query("atcs, atcl, perffile, perffile.name, perffile.billno, perffile.adminorg, perffile.position, affiliateadminorg, person.id, person.number, empposrel, empposrel.position, empposrel.job", new QFilter[]{actEvalObjFilter});
    }

    public DynamicObject[] queryPerffileById(List<Long> perffilesIdList) {
        QFilter perffileFilter = new QFilter("id", "in", perffilesIdList);
        return PERFFILE_ENTITY_SERVICE.query("adminorg, adminorg.sortcode, position, position.index, depemp, depemp.person", new QFilter[]{perffileFilter});
    }

    public DynamicObject[] queryEvalObjAdjRecordByTaskId(List<Long> taskIdList) {
        QFilter evalAdjFilter = new QFilter("flowrutask", "in", taskIdList);
        return EVAL_ADJUSTMENT_ENTITY_SERVICE.query("batcs, atv, atcs, ins, batcl, atcl, flowrutask, actevalobj", new QFilter[]{evalAdjFilter});
    }

    public DynamicObject[] queryTaskById(List<Long> taskIdList) {
        QFilter taskFilter = new QFilter("id", "in", taskIdList);
        return FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalArray("id, flowruproc.id, flowrunode.id, flowrunode.index, flowrunode.iscrossnode, flowrunode.name, flowrunode.nodeweight, flowrunode.flownodedef.id, flowrurole.id, flowrurole.name, flowrurole.turnoversort,  taskstatus, handler.id, handler.picturefield, handler.name, activity, isrollbacked", new QFilter[]{taskFilter});
    }

    public Boolean isFirstNodeAndRole(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return true;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles != null && roles.length > 0) {
            return false;
        }
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryIsFirstNode(taskId);
    }

    public DynamicObject[] queryLessThanRoleSortRoles(Long flowRuRoleId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryLessThanRoleSortRoles(flowRuRoleId);
    }

    public Boolean isCrossNodeOfPreRole(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return false;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles != null && roles.length > 0) {
            for (DynamicObject role : roles) {
                if (role == null) continue;
                return role.getBoolean("iscrossrole");
            }
        } else {
            long procId = taskObj.getLong("flowruproc.id");
            int index = taskObj.getInt("flowrunode.index");
            if (index == 1) {
                long ruNodeId = taskObj.getLong("flowrunode.id");
                DynamicObject ruNodeDy = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByPk(Long.valueOf(ruNodeId));
                if (ruNodeDy != null) {
                    return ruNodeDy.getBoolean("iscrossnode");
                }
            } else {
                DynamicObject ruNodeDy = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByIndex(Long.valueOf(procId), index - 1);
                if (ruNodeDy != null) {
                    return ruNodeDy.getBoolean("iscrossnode");
                }
            }
        }
        return false;
    }

    public void saveEvalAdjRecord(DynamicObjectCollection dyObjs) {
        ArrayList<DynamicObject> adjRecordList = new ArrayList<DynamicObject>(10);
        List<Long> taskIdList = dyObjs.stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        this.resetRollBackedMark(taskIdList);
        Map taskDyObjMap = dyObjs.stream().collect(Collectors.toMap(x -> x.getLong("flowrutask.id"), Function.identity()));
        QFilter adjRecordFilter = new QFilter("flowrutask", "in", taskIdList);
        Long userId = UserServiceHelper.getCurrentUserId();
        DynamicObject[] adjRecordObjs = EVAL_ADJUSTMENT_ENTITY_SERVICE.query("batcs, atcs, atv, ins, batcl, atcl, actevalobj, assessyear, assessperiod, activity, perforg, flowrutask, flowruproc, flowrunode, flowrurole, creator, createtime, modifier, modifytime", new QFilter[]{adjRecordFilter});
        List existObjTaskIdList = Arrays.asList(adjRecordObjs).stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        for (DynamicObject adjRecordObj : adjRecordObjs) {
            Long taskId = adjRecordObj.getLong("flowrutask.id");
            DynamicObject adjObj = (DynamicObject)taskDyObjMap.get(taskId);
            adjRecordObj.set("batcs", (Object)adjObj.getBigDecimal("batcs"));
            adjRecordObj.set("atv", (Object)adjObj.getBigDecimal("atv"));
            adjRecordObj.set("atcs", (Object)adjObj.getBigDecimal("atcs"));
            adjRecordObj.set("ins", (Object)adjObj.getString("ins"));
            adjRecordObj.set("batcl", (Object)adjObj.getString("batcl"));
            adjRecordObj.set("atcl", (Object)adjObj.getString("atcl"));
            adjRecordObj.set("modifier", (Object)userId);
            adjRecordObj.set("modifytime", (Object)new Date());
        }
        if (adjRecordObjs.length > 0) {
            EVAL_ADJUSTMENT_ENTITY_SERVICE.save(adjRecordObjs);
        }
        for (DynamicObject dyObj : dyObjs) {
            Long taskId = dyObj.getLong("flowrutask.id");
            if (existObjTaskIdList.contains(taskId)) continue;
            Long rowareainsId = DBServiceHelper.genLongIds((String)"epa_objadjrecord", (int)1)[0];
            DynamicObject adjRecordObj = EVAL_ADJUSTMENT_ENTITY_SERVICE.generateEmptyDynamicObject();
            adjRecordObj.set("id", (Object)rowareainsId);
            DynamicObject taskObj = dyObj.getDynamicObject("flowrutask");
            DynamicObject actEvalObj = dyObj.getDynamicObject("actevalobj");
            adjRecordObj.set("batcs", (Object)dyObj.getBigDecimal("batcs"));
            adjRecordObj.set("atv", (Object)dyObj.getBigDecimal("atv"));
            adjRecordObj.set("atcs", (Object)dyObj.getBigDecimal("atcs"));
            adjRecordObj.set("ins", (Object)dyObj.getString("ins"));
            adjRecordObj.set("batcl", (Object)dyObj.getString("batcl"));
            adjRecordObj.set("atcl", (Object)dyObj.getString("atcl"));
            adjRecordObj.set("actevalobj", (Object)actEvalObj.getLong("id"));
            adjRecordObj.set("assessyear", (Object)actEvalObj.getInt("assessyear"));
            adjRecordObj.set("assessperiod", (Object)actEvalObj.getString("assessperiod"));
            adjRecordObj.set("activity", (Object)actEvalObj.getLong("activity.id"));
            adjRecordObj.set("perforg", (Object)actEvalObj.getLong("perforg.id"));
            adjRecordObj.set("flowrutask", (Object)taskObj.getLong("id"));
            adjRecordObj.set("flowruproc", (Object)taskObj.getLong("flowruproc.id"));
            adjRecordObj.set("flowrunode", (Object)taskObj.getLong("flowrunode.id"));
            adjRecordObj.set("flowrurole", (Object)taskObj.getLong("flowrurole.id"));
            adjRecordObj.set("creator", (Object)userId);
            adjRecordObj.set("createtime", (Object)new Date());
            adjRecordObj.set("modifier", (Object)userId);
            adjRecordObj.set("modifytime", (Object)new Date());
            adjRecordList.add(adjRecordObj);
        }
        EVAL_ADJUSTMENT_ENTITY_SERVICE.save(adjRecordList.toArray(new DynamicObject[adjRecordList.size()]));
    }

    public boolean resetRollBackedMark(List<Long> taskIdList) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.resetRollBackedMark(taskIdList);
    }

    public DynamicObject queryFlowRuProcByTaskId(Long taskId) {
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("flowruproc", new QFilter[]{taskFilter});
        QFilter flowruprocFilter = new QFilter("id", "=", (Object)taskObj.getLong("flowruproc.id"));
        return FLOW_RU_PROC_ENTITY_SERVICE.queryOne(new QFilter[]{flowruprocFilter});
    }

    public Map<Long, String> queryTaskStatusMap(List<Long> selectedTaskIdList) {
        Map<Long, String> taskStatusMap = new HashMap<Long, String>(16);
        if (selectedTaskIdList != null && !selectedTaskIdList.isEmpty()) {
            QFilter filter = new QFilter("id", "in", selectedTaskIdList);
            DynamicObject[] taskObjs = FLOW_RU_TASK_ENTITY_SERVICE.query("taskstatus", new QFilter[]{filter});
            taskStatusMap = Arrays.asList(taskObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString("taskstatus")));
        }
        return taskStatusMap;
    }

    public Map<Long, Boolean> submitTask(List<Long> taskIdList) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.submitTask(taskIdList);
    }

    public FlowValidateResultBo rejectTask(List<Long> taskIdList, String reason) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.batchRollbackTasks(taskIdList, reason);
    }

    public void updateActEvalObjInfo(List<Long> taskIdList) {
        DynamicObject[] actEvalObjs;
        Long taskId = taskIdList.get(0);
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("scoresystem, evalway, numaccuracy, scaletype, sumperflevel ", new QFilter[]{assessFormFilter});
        int numaccuracy = assessFormObj.getInt("numaccuracy");
        String scaleType = assessFormObj.getString("scaletype");
        QFilter adjRecordFilter = new QFilter("flowrutask", "in", taskIdList);
        DynamicObject[] adjRecordObjs = EVAL_ADJUSTMENT_ENTITY_SERVICE.query("batcs, atcs, atv, ins, batcl, atcl, actevalobj, assessyear, assessperiod, activity, perforg, flowrutask, flowruproc, flowrunode, flowrurole", new QFilter[]{adjRecordFilter});
        List actevalobjIdList = Arrays.asList(adjRecordObjs).stream().map(obj -> obj.getLong("actevalobj")).collect(Collectors.toList());
        Map adjRecordMap = Arrays.asList(adjRecordObjs).stream().collect(Collectors.toMap(x -> x.getLong("actevalobj"), Function.identity()));
        QFilter evalObjFilter = new QFilter("id", "in", actevalobjIdList);
        for (DynamicObject actEvalObj : actEvalObjs = EPA_ACTEVALOBJ_SERVICE.query("atcs, atcl, soat, leveloat, soatsource, soac, loac, sop, lop, sopsource, fsop, flop, fsopsource, modifier, modifytime", new QFilter[]{evalObjFilter})) {
            Long actEvalObjId = actEvalObj.getLong("id");
            DynamicObject adjRecordObj = (DynamicObject)adjRecordMap.get(actEvalObjId);
            BigDecimal atcs = adjRecordObj.getBigDecimal("atcs");
            String atcl = adjRecordObj.getString("atcl");
            actEvalObj.set("atcs", (Object)atcs);
            actEvalObj.set("soat", (Object)atcs);
            actEvalObj.set("soatsource", (Object)"atcs");
            actEvalObj.set("soac", (Object)atcs);
            actEvalObj.set("sopsource", (Object)"soac");
            actEvalObj.set("sop", (Object)atcs.setScale(numaccuracy, ScalaTypeEnum.get(scaleType).getType()));
            actEvalObj.set("fsop", (Object)atcs.setScale(numaccuracy, ScalaTypeEnum.get(scaleType).getType()));
            if (!HRStringUtils.isEmpty((String)atcl)) {
                actEvalObj.set("atcl", (Object)atcl);
                actEvalObj.set("lop", (Object)atcl);
                actEvalObj.set("loac", (Object)atcl);
                actEvalObj.set("leveloat", (Object)atcl);
                actEvalObj.set("flop", (Object)atcl);
            }
            actEvalObj.set("fsopsource", (Object)"sop");
            actEvalObj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            actEvalObj.set("modifytime", (Object)new Date());
        }
        EPA_ACTEVALOBJ_SERVICE.save(actEvalObjs);
    }

    public void adjActEvalObjScoreByImportInd(List<Long> taskIdList) {
        if (taskIdList == null || taskIdList.isEmpty()) {
            return;
        }
        QFilter adjRecordFilter = new QFilter("flowrutask", "in", taskIdList);
        adjRecordFilter.and(new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode()));
        DynamicObject[] adjRecordObjs = EVAL_ADJUSTMENT_ENTITY_SERVICE.query("batcs, atcs, atv, ins, batcl, atcl, actevalobj, assessyear, assessperiod, activity, perforg, flowrutask, flowruproc, flowrunode, flowrurole", new QFilter[]{adjRecordFilter});
        Long taskId = taskIdList.get(0);
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("allowexceedupper, allowexceedlower, limitmaxscore, limitminscore, scoresystem, evalway, numaccuracy, sumconf, sumperflevel ", new QFilter[]{assessFormFilter});
        Long scoreSystemId = assessFormObj.getLong("scoresystem.id");
        if (adjRecordObjs != null && adjRecordObjs.length > 0) {
            Long actEvalObjId = adjRecordObjs[0].getLong("actevalobj");
            Map<String, BigDecimal> scoreRangeMap = this.getScoreRangeMap(actEvalObjId);
            BigDecimal minScore = scoreRangeMap.get("minscore");
            BigDecimal maxScore = scoreRangeMap.get("maxscore");
            DynamicObject sumperflevelObj = assessFormObj.getDynamicObject("sumperflevel");
            DynamicObject scoreMapDy = null;
            if (!HRObjectUtils.isEmpty((Object)sumperflevelObj)) {
                Long sumPerfLevelId = assessFormObj.getLong("sumperflevel.id");
                DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelId);
                DynamicObjectCollection scoreMapEntry = sumPerfLevel.getDynamicObjectCollection("scoremapentryentity");
                scoreMapDy = scoreMapEntry.stream().filter(scoreMap -> scoreMap.getLong("scoresystem.id") == scoreSystemId.longValue()).findFirst().orElse(null);
            }
            Long actevalobjId = Arrays.asList(adjRecordObjs).stream().map(obj -> obj.getLong("actevalobj")).collect(Collectors.toList()).stream().findFirst().orElse(null);
            Map adjRecordMap = Arrays.asList(adjRecordObjs).stream().collect(Collectors.toMap(x -> x.getLong("flowrutask.id"), Function.identity()));
            QFilter evalObjFilter = new QFilter("id", "=", (Object)actevalobjId);
            DynamicObject actEvalObj = EPA_ACTEVALOBJ_SERVICE.queryOne("atcs, atcl, soat, leveloat, soatsource, soac, loac, sop, lop, sopsource, fsop, flop, fsopsource, modifier, modifytime", new QFilter[]{evalObjFilter});
            if (!HRObjectUtils.isEmpty((Object)actEvalObj)) {
                BigDecimal batcs = actEvalObj.getBigDecimal("atcs");
                BigDecimal finalAtcs = BigDecimal.ZERO;
                String finalAtcl = "";
                ArrayList<DynamicObject> newAdjRecordList = new ArrayList<DynamicObject>(10);
                for (Long tId : taskIdList) {
                    DynamicObject adjRecordObj = (DynamicObject)adjRecordMap.get(tId);
                    BigDecimal atv = adjRecordObj.getBigDecimal("atv");
                    BigDecimal atcs = batcs.add(atv);
                    if (minScore != null && atcs.compareTo(minScore) < 0) {
                        atcs = minScore;
                    }
                    if (maxScore != null && atcs.compareTo(maxScore) > 0) {
                        atcs = maxScore;
                    }
                    String batcl = this.calculatAdjImpScore(scoreMapDy, batcs);
                    adjRecordObj.set("batcs", (Object)batcs);
                    adjRecordObj.set("batcl", (Object)batcl);
                    adjRecordObj.set("atcs", (Object)atcs);
                    String atcl = this.calculatAdjImpScore(scoreMapDy, atcs);
                    if (StringUtils.isNotEmpty((CharSequence)atcl)) {
                        adjRecordObj.set("atcl", (Object)atcl);
                    }
                    finalAtcs = atcs;
                    finalAtcl = atcl;
                    newAdjRecordList.add(adjRecordObj);
                    batcs = atcs;
                }
                EVAL_ADJUSTMENT_ENTITY_SERVICE.save(newAdjRecordList.toArray(new DynamicObject[newAdjRecordList.size()]));
                actEvalObj.set("atcs", (Object)finalAtcs);
                actEvalObj.set("soat", (Object)finalAtcs);
                actEvalObj.set("soatsource", (Object)"atcs");
                actEvalObj.set("soac", (Object)finalAtcs);
                actEvalObj.set("sop", (Object)finalAtcs);
                actEvalObj.set("sopsource", (Object)"soac");
                actEvalObj.set("fsop", (Object)finalAtcs);
                if (StringUtils.isNotEmpty((CharSequence)finalAtcl)) {
                    actEvalObj.set("atcl", (Object)finalAtcl);
                    actEvalObj.set("leveloat", (Object)finalAtcl);
                    actEvalObj.set("loac", (Object)finalAtcl);
                    actEvalObj.set("lop", (Object)finalAtcl);
                    actEvalObj.set("flop", (Object)finalAtcl);
                }
                actEvalObj.set("fsopsource", (Object)"sop");
                actEvalObj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
                actEvalObj.set("modifytime", (Object)new Date());
                EPA_ACTEVALOBJ_SERVICE.saveOne(actEvalObj);
            }
        }
    }

    private String calculatAdjImpScore(DynamicObject scoreMapDy, BigDecimal atcs) {
        if (scoreMapDy == null) {
            return "";
        }
        String levelScoreMap = scoreMapDy.getString("levelscoremap");
        if (HRStringUtils.equals((String)levelScoreMap, (String)"20")) {
            return "";
        }
        DynamicObjectCollection scoreLevelMapEntry = scoreMapDy.getDynamicObjectCollection("scoresubentryentity");
        for (DynamicObject scoreLevelMap : scoreLevelMapEntry) {
            BigDecimal maxScore = scoreLevelMap.getBigDecimal("maxscore");
            String scoreMaxOperation = scoreLevelMap.getString("scoremaxoperation");
            String scoreMinOperation = scoreLevelMap.getString("scoreminoperation");
            BigDecimal minScore = scoreLevelMap.getBigDecimal("minscore");
            boolean maxCompare = true;
            if (maxScore != null && maxScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMaxOperation, (String)"10")) {
                    maxCompare = maxScore.compareTo(atcs) > 0;
                } else if (HRStringUtils.equals((String)scoreMaxOperation, (String)"20")) {
                    maxCompare = maxScore.compareTo(atcs) >= 0;
                }
            }
            boolean minCompare = true;
            if (minScore != null && minScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMinOperation, (String)"10")) {
                    minCompare = atcs.compareTo(minScore) > 0;
                } else if (HRStringUtils.equals((String)scoreMinOperation, (String)"20")) {
                    boolean bl = minCompare = atcs.compareTo(minScore) >= 0;
                }
            }
            if (!maxCompare || !minCompare) continue;
            return scoreLevelMap.getString("seq");
        }
        return "";
    }

    public DynamicObject queryAdjustScoreByTaskId(Long taskId) {
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalOne("id, flowruproc.id, flowrunode.id", new QFilter[]{taskFilter});
        QFilter flowruprocFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowruproc.id"));
        DynamicObject flowruprocObj = FLOW_RU_PROC_ENTITY_SERVICE.queryOriginalOne("id, defproc.id", new QFilter[]{flowruprocFilter});
        QFilter flowrunodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject flowrunodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOriginalOne("id, flownodedef.id", new QFilter[]{flowrunodeFilter});
        QFilter defprocFilter = new QFilter("id", "=", (Object)flowruprocObj.getLong("defproc.id"));
        DynamicObject defprocObj = FLOW_DEF_PROC_ENTITY_SERVICE.queryOne("name, index, nodeentry.id, nodeentry.adjusetscorelowerlimit, nodeentry.adjustscoreuplimit", new QFilter[]{defprocFilter});
        DynamicObjectCollection defNodeConfig = defprocObj.getDynamicObjectCollection("nodeentry");
        DynamicObject defnodeObj = defNodeConfig.stream().filter(obj -> flowrunodeObj.getLong("flownodedef.id") == obj.getLong("id")).findFirst().orElse(null);
        return defnodeObj;
    }

    public List<Map<String, Object>> queryAdjPersonInfoFields(Long taskId) {
        Set areaFieldIdSet;
        QFilter filter;
        DynamicObject[] fieldArr;
        List contentAreaEntries;
        Map contentAreaEntriesMap;
        ArrayList<Map<String, Object>> personInfoFieldsList = new ArrayList<Map<String, Object>>(10);
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowruproc, flowrunode", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, dynamicpermission", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("empinfoconf", new QFilter[]{assessFormFilter});
        long empInfoIdId = assessFormObj.getLong("empinfoconf");
        QFilter nodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject nodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{nodeFilter});
        HashMap areaFieldPermMap = new HashMap(16);
        Long newProcPermId = activityObj.getLong("dynamicpermission.id");
        DynPermissionConfigService dynamicObjectCollection = new DynPermissionConfigService();
        long flowNodeDefId = nodeObj.getLong("flownodedef.id");
        ArrayList<Long> flowNodeIdList = new ArrayList<Long>(10);
        flowNodeIdList.add(flowNodeDefId);
        DynamicPermissionConfigVO dynamicPermissions = dynamicObjectCollection.getDynamicPermissions(newProcPermId, flowNodeIdList);
        if (dynamicPermissions != null && (contentAreaEntriesMap = dynamicPermissions.getContentAreaEntriesMap()) != null && (contentAreaEntries = (List)contentAreaEntriesMap.get(flowNodeDefId)) != null) {
            for (ContentAreaEntry contentAreaEntry : contentAreaEntries) {
                Boolean areaDisplay;
                DynamicObject[] areaPageInsId;
                if (contentAreaEntry == null || empInfoIdId != (areaPageInsId = contentAreaEntry.getAreapageInsId() == null ? Long.valueOf("0") : contentAreaEntry.getAreapageInsId()).longValue()) continue;
                List fieldEntries = contentAreaEntry.getFieldEntries();
                Boolean bl = areaDisplay = contentAreaEntry.getAreaDisplay() == null ? Boolean.FALSE : contentAreaEntry.getAreaDisplay();
                if (areaDisplay != null && !areaDisplay.booleanValue()) break;
                if (fieldEntries == null) continue;
                for (ContentFieldEntry fieldEntry : fieldEntries) {
                    if (fieldEntry == null) continue;
                    Long areaFieldId = fieldEntry.getAreaFieldId();
                    Boolean fieldDisplay = fieldEntry.getFieldDisplay() == null ? Boolean.FALSE : fieldEntry.getFieldDisplay();
                    Boolean fieldModify = fieldEntry.getFieldModify() == null ? Boolean.FALSE : fieldEntry.getFieldModify();
                    Boolean fieldMustInput = fieldEntry.getFieldMustInput() == null ? Boolean.FALSE : fieldEntry.getFieldMustInput();
                    HashMap<String, Boolean> procPermItemMap = new HashMap<String, Boolean>(16);
                    procPermItemMap.put("fielddisplayitem", fieldDisplay);
                    procPermItemMap.put("fieldmustinputitem", fieldMustInput);
                    procPermItemMap.put("fieldmodifyitem", fieldModify);
                    areaFieldPermMap.put(areaFieldId, procPermItemMap);
                }
            }
        }
        HashMap<String, Map> procPermMap = new HashMap<String, Map>(16);
        if (areaFieldPermMap != null && (fieldArr = AREA_FIELD_ENTITY_SERVICE.queryOriginalArray("id,number", new QFilter[]{filter = new QFilter("id", "in", areaFieldIdSet = areaFieldPermMap.keySet())})) != null) {
            for (DynamicObject fieldDy : fieldArr) {
                if (fieldDy == null) continue;
                String number = fieldDy.getString("number");
                long areaFieldId = fieldDy.getLong("id");
                Map permMap = (Map)areaFieldPermMap.get(areaFieldId);
                procPermMap.put(number, permMap);
            }
        }
        for (Map.Entry next : procPermMap.entrySet()) {
            if (next == null) continue;
            String key = (String)next.getKey();
            Map permObj = (Map)next.getValue();
            Boolean fielddisplayitem = (Boolean)permObj.get("fielddisplayitem");
            Boolean fieldmustinputitem = (Boolean)permObj.get("fieldmustinputitem");
            Boolean fieldmodifyitem = (Boolean)permObj.get("fieldmodifyitem");
            if (!fielddisplayitem.booleanValue()) continue;
            switch (key) {
                case "name": {
                    HashMap<String, Object> nameField = new HashMap<String, Object>(16);
                    nameField.put("id", "name");
                    nameField.put("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"ActEvalObjAdjDomainService_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    nameField.put("key", "name");
                    nameField.put("proptype", FieldTypeEnum.MuliLangText);
                    nameField.put("mustinput", fieldmustinputitem);
                    nameField.put("visible", fielddisplayitem);
                    nameField.put("lock", fieldmodifyitem == false);
                    personInfoFieldsList.add(nameField);
                    break;
                }
                case "number": {
                    HashMap<String, Object> numberField = new HashMap<String, Object>(16);
                    numberField.put("id", "number");
                    numberField.put("name", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ActEvalObjAdjDomainService_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    numberField.put("key", "number");
                    numberField.put("proptype", FieldTypeEnum.Text);
                    numberField.put("mustinput", fieldmustinputitem);
                    numberField.put("visible", fielddisplayitem);
                    numberField.put("lock", fieldmodifyitem == false);
                    personInfoFieldsList.add(numberField);
                    break;
                }
                case "adminorg": {
                    HashMap<String, Object> adminOrgField = new HashMap<String, Object>(16);
                    adminOrgField.put("id", "adminorg");
                    adminOrgField.put("name", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"ActEvalObjAdjDomainService_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    adminOrgField.put("key", "adminorg");
                    adminOrgField.put("proptype", FieldTypeEnum.MuliLangText);
                    adminOrgField.put("mustinput", fieldmustinputitem);
                    adminOrgField.put("visible", fielddisplayitem);
                    adminOrgField.put("lock", fieldmodifyitem == false);
                    personInfoFieldsList.add(adminOrgField);
                    break;
                }
                case "position": {
                    HashMap<String, Object> positionField = new HashMap<String, Object>(16);
                    positionField.put("id", "position");
                    positionField.put("name", ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"ActEvalObjAdjDomainService_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    positionField.put("key", "position");
                    positionField.put("proptype", FieldTypeEnum.MuliLangText);
                    positionField.put("mustinput", fieldmustinputitem);
                    positionField.put("visible", fielddisplayitem);
                    positionField.put("lock", fieldmodifyitem == false);
                    personInfoFieldsList.add(positionField);
                    break;
                }
                case "job": {
                    HashMap<String, Object> jobField = new HashMap<String, Object>(16);
                    jobField.put("id", "job");
                    jobField.put("name", ResManager.loadKDString((String)"\u804c\u4f4d", (String)"ActEvalObjAdjDomainService_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    jobField.put("key", "job");
                    jobField.put("proptype", FieldTypeEnum.MuliLangText);
                    jobField.put("mustinput", fieldmustinputitem);
                    jobField.put("visible", fielddisplayitem);
                    jobField.put("lock", fieldmodifyitem == false);
                    personInfoFieldsList.add(jobField);
                    break;
                }
            }
        }
        HashMap<String, Object> adminOrgIndexField = new HashMap<String, Object>(16);
        adminOrgIndexField.put("id", "adminorgst");
        adminOrgIndexField.put("name", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u6392\u5e8f\u7801", (String)"ActEvalObjAdjDomainService_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        adminOrgIndexField.put("key", "adminorgst");
        adminOrgIndexField.put("proptype", FieldTypeEnum.Text);
        adminOrgIndexField.put("mustinput", Boolean.FALSE);
        adminOrgIndexField.put("visible", Boolean.FALSE);
        adminOrgIndexField.put("lock", Boolean.TRUE);
        personInfoFieldsList.add(adminOrgIndexField);
        HashMap<String, Object> positionIndexField = new HashMap<String, Object>(16);
        positionIndexField.put("id", "positionindex");
        positionIndexField.put("name", ResManager.loadKDString((String)"\u5c97\u4f4d\u6392\u5e8f\u7801", (String)"ActEvalObjAdjDomainService_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        positionIndexField.put("key", "positionindex");
        positionIndexField.put("proptype", FieldTypeEnum.Integer);
        positionIndexField.put("mustinput", Boolean.FALSE);
        positionIndexField.put("visible", Boolean.FALSE);
        positionIndexField.put("lock", Boolean.TRUE);
        personInfoFieldsList.add(positionIndexField);
        return personInfoFieldsList;
    }

    public Map<String, BigDecimal> getScoreRangeMap(Long actEvalObjId) {
        String evasumlimitStr;
        HashMap<String, BigDecimal> scoreRangeMap = new HashMap<String, BigDecimal>(16);
        BigDecimal maxScore = BigDecimal.ZERO;
        BigDecimal minScore = BigDecimal.ZERO;
        QFilter actEvalObjFilter = new QFilter("id", "=", (Object)actEvalObjId);
        DynamicObject actEvalObj = ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.queryOne("activity,  areaentry.areareg, areaentry.areains, areaentry.areaconf", new QFilter[]{actEvalObjFilter});
        Long activityId = actEvalObj.getLong("activity.id");
        QFilter activityFilter = new QFilter("id", "=", (Object)activityId);
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryOne("scaletype, evasumlimit, limitmaxscore, limitminscore, scoresystem, evalway, scorecalcway, numaccuracy, sumconf, sumperflevel ", new QFilter[]{assessFormFilter});
        String evalWayStr = assessForm.getString("evalway");
        EvalWayEnum evalWay = EvalWayEnum.getEvalWay((String)evalWayStr);
        String scoreCalcWayStr = assessForm.getString("scorecalcway");
        ScoreCalcWayEnum scoreCalcWay = ScoreCalcWayEnum.getScoreCalcWay((String)scoreCalcWayStr);
        Long scoreSystemId = assessForm.getLong("scoresystem.id");
        DynamicObject scoreSystemDy = SCORE_SYSTEM_ENTITY.queryOne((Object)scoreSystemId);
        BigDecimal maxSysScore = BigDecimal.ZERO;
        if (scoreSystemDy != null) {
            maxSysScore = scoreSystemDy.getBigDecimal("maxscore") == null ? BigDecimal.ZERO : scoreSystemDy.getBigDecimal("maxscore");
            BigDecimal bigDecimal = minScore = scoreSystemDy.getBigDecimal("minscore") == null ? BigDecimal.ZERO : scoreSystemDy.getBigDecimal("minscore");
        }
        if (HRStringUtils.isNotEmpty((String)(evasumlimitStr = assessForm.getString("evasumlimit")))) {
            EvaSumLimit evaSumLimit = EvaSumLimit.getEvaSumLimit((String)evasumlimitStr);
            switch (evaSumLimit) {
                case NOT_LIMIT: {
                    maxScore = null;
                    minScore = null;
                    break;
                }
                case SUM_LIMIT: {
                    maxScore = maxSysScore;
                    break;
                }
                case APPOINT_SUM_LIMIT: {
                    List partinASAreaConfIdList;
                    QFilter addSubAreaConfFilter;
                    DynamicObject[] addSubAreaConfObjs;
                    DynamicObjectCollection areaEntry = actEvalObj.getDynamicObjectCollection("areaentry");
                    ArrayList<Long> genAreaConfIdList = new ArrayList<Long>(10);
                    List<Object> genAreaInsIdList = new ArrayList(10);
                    ArrayList<Long> addSubAreaConfIdList = new ArrayList<Long>(10);
                    List<Object> addSubAreaInsIdList = new ArrayList(10);
                    for (DynamicObject area : areaEntry) {
                        Long areaRegId = area.getLong("areareg.id");
                        Long areaConfId = area.getLong("areaconf");
                        if (AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaRegId)) {
                            genAreaConfIdList.add(areaConfId);
                            continue;
                        }
                        if (!AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaRegId)) continue;
                        addSubAreaConfIdList.add(areaConfId);
                    }
                    QFilter genAreaConfFilter = new QFilter("id", "in", genAreaConfIdList);
                    DynamicObject[] genAreaConfObjs = NORMAL_CONFIG_ENTITY_SERVICE.queryOriginalArray("id, isalloweval, ispartin, areascore, weight", new QFilter[]{genAreaConfFilter});
                    List partinGenAreaConfIdList = Arrays.asList(genAreaConfObjs).stream().filter(obj -> obj.getBoolean("isalloweval") && obj.getBoolean("ispartin")).map(obj -> obj.getLong("id")).collect(Collectors.toList());
                    if (partinGenAreaConfIdList != null && !partinGenAreaConfIdList.isEmpty()) {
                        DynamicObject[] genAreaInsObjs;
                        genAreaInsIdList = areaEntry.stream().filter(obj -> partinGenAreaConfIdList.contains(obj.getLong("areaconf"))).map(obj -> obj.getLong("areains")).collect(Collectors.toList());
                        QFilter genAreaFilter = new QFilter("id", "in", genAreaInsIdList);
                        for (DynamicObject genAreaInsObj : genAreaInsObjs = OBJ_GEN_AREA_INS_ENTITY_SERVICE.queryOriginalArray("areaweight, areascore", new QFilter[]{genAreaFilter})) {
                            if (scoreCalcWay == ScoreCalcWayEnum.SUM) {
                                BigDecimal areaScore = genAreaInsObj.getBigDecimal("areascore");
                                maxScore = maxScore.add(areaScore);
                                continue;
                            }
                            if (scoreCalcWay != ScoreCalcWayEnum.WEIGHT) continue;
                            BigDecimal weight = genAreaInsObj.getBigDecimal("areaweight");
                            BigDecimal weightPercent = weight.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP);
                            BigDecimal areaScore = maxSysScore.multiply(weightPercent);
                            maxScore = maxScore.add(areaScore);
                        }
                    }
                    if ((addSubAreaConfObjs = PLUS_MINUS_CONFIG_ENTITY_SERVICE.queryOriginalArray("id, ispartin", new QFilter[]{addSubAreaConfFilter = new QFilter("id", "in", addSubAreaConfIdList)})) != null && addSubAreaConfObjs.length > 0 && (partinASAreaConfIdList = Arrays.asList(addSubAreaConfObjs).stream().filter(obj -> obj.getBoolean("ispartin")).map(obj -> obj.getLong("id")).collect(Collectors.toList())) != null && !partinASAreaConfIdList.isEmpty()) {
                        DynamicObject[] addSubAreaInsObjs;
                        addSubAreaInsIdList = areaEntry.stream().filter(obj -> partinASAreaConfIdList.contains(obj.getLong("areaconf"))).map(obj -> obj.getLong("areains")).collect(Collectors.toList());
                        QFilter addSubAreaFilter = new QFilter("id", "in", addSubAreaInsIdList);
                        for (DynamicObject addSubAreaIns : addSubAreaInsObjs = OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.queryOriginalArray("minareascore, maxareascore, ispartin", new QFilter[]{addSubAreaFilter})) {
                            BigDecimal maxAreaScore = addSubAreaIns.getBigDecimal("maxareascore");
                            maxScore = maxScore.add(maxAreaScore);
                            BigDecimal minAreaScore = addSubAreaIns.getBigDecimal("minareascore");
                            minScore = minScore.add(minAreaScore);
                        }
                    }
                    BigDecimal limitmaxscore = assessForm.getBigDecimal("limitmaxscore");
                    BigDecimal limitminscore = assessForm.getBigDecimal("limitminscore");
                    maxScore = limitmaxscore == null ? BigDecimal.ZERO : maxScore.min(limitmaxscore);
                    minScore = limitminscore == null ? BigDecimal.ZERO : minScore.max(limitminscore);
                    break;
                }
            }
        }
        scoreRangeMap.put("maxscore", maxScore);
        scoreRangeMap.put("minscore", minScore);
        return scoreRangeMap;
    }

    public DynamicObject queryActEvalObjById(Long actEvalObjId) {
        QFilter actEvalObjFilter = new QFilter("id", "=", (Object)actEvalObjId);
        return ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.queryOne("id, person.name, person.number, person.headsculpture, personnumber, affiliateadminorg.id, affiliateadminorg.name, empposrel.job.name,  empposrel.position.name, perforg.id, assessyear, assessperiod, activity.id, activity.name, activity.period, activity.executescheme.name, activity.executescheme.id, activityareaentry, areaentry.areareg, areaentry.areains, areaentry.areaconf, atcs, atcl", new QFilter[]{actEvalObjFilter});
    }

    public Map<String, Object> queryAdjPermMap(Long taskId) {
        HashMap<String, Object> sumPermMap = new HashMap<String, Object>(16);
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowrunode", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, dynamicpermission", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("evalway, numaccuracy, sumconf, sumperflevel ", new QFilter[]{assessFormFilter});
        Long sumConfIdId = assessFormObj.getLong("sumconf");
        DynamicObject sumConfObj = SUM_CONFIG_ENTITY_SERVICE.queryOne(sumConfIdId);
        DynamicObjectCollection filedEntry = sumConfObj.getDynamicObjectCollection("entryentity");
        Map fieldMap = filedEntry.stream().collect(Collectors.toMap(filedInfo -> filedInfo.getDynamicObject("areafield").getString("number"), Function.identity()));
        EvalWayEnum evalWay = EvalWayEnum.getEvalWay((String)assessFormObj.getString("evalway"));
        QFilter flowrunodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject flowrunodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{flowrunodeFilter});
        Map<String, Object> procPermMap = this.getProcPermMap(activityObj, sumConfIdId, flowrunodeObj);
        if (!procPermMap.isEmpty()) {
            HashMap<String, Boolean> atvMap = (HashMap<String, Boolean>)procPermMap.get("adjustscore");
            if (atvMap == null || atvMap.isEmpty()) {
                atvMap = new HashMap<String, Boolean>(16);
                atvMap.put("fielddisplayitem", Boolean.FALSE);
                atvMap.put("fieldmustinputitem", Boolean.FALSE);
                atvMap.put("fieldmodifyitem", Boolean.FALSE);
            }
            sumPermMap.put("adjustscore", atvMap);
            HashMap<String, Boolean> atclMap = (HashMap<String, Boolean>)procPermMap.get("adjustrank");
            if (atclMap == null || atclMap.isEmpty()) {
                atclMap = new HashMap<String, Boolean>(16);
                atclMap.put("fielddisplayitem", Boolean.FALSE);
                atclMap.put("fieldmustinputitem", Boolean.FALSE);
                atclMap.put("fieldmodifyitem", Boolean.FALSE);
            }
            sumPermMap.put("adjustrank", atclMap);
            HashMap<String, Boolean> insMap = (HashMap<String, Boolean>)procPermMap.get("adjustdesc");
            if (insMap == null || insMap.isEmpty()) {
                insMap = new HashMap<String, Boolean>(16);
                insMap.put("fielddisplayitem", Boolean.FALSE);
                insMap.put("fieldmustinputitem", Boolean.FALSE);
                insMap.put("fieldmodifyitem", Boolean.FALSE);
            }
            sumPermMap.put("adjustdesc", insMap);
        }
        return sumPermMap;
    }

    public List<ComboItem> queryPerfLevelItemByRule(Long perfLevelId) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        if (perfLevelId == 0L) {
            return comboItems;
        }
        DynamicObject perfLevelDy = PERF_LEVEL_ENTITY.queryOne((Object)perfLevelId);
        DynamicObjectCollection levelConf = perfLevelDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject level : levelConf) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(level.getString("levelname")));
            comboItem.setValue(level.getString("seq"));
            comboItems.add(comboItem);
        }
        return comboItems;
    }

    public DynamicObject queryTaskInfo(Long taskId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
    }

    public DynamicObject queryAdjEvalRecord(Long taskId) {
        QFilter sumareaFilter = new QFilter("flowrutask", "=", (Object)taskId);
        return EVAL_ADJUSTMENT_ENTITY_SERVICE.queryOne("actevalobj, batcs, batcl, atv, atcs, atcl, ins", sumareaFilter);
    }

    public DynamicObject[] querySumRecordByActEvalObjId(Long actEvalObjId) {
        QFilter sumRecordFilter = new QFilter("actevalobj", "=", (Object)actEvalObjId);
        QFilter taskStatus = new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        return OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.query("actevalobj, ose, ole, eval, flowrutask, flowrutask.taskstatus, flowrutask.handler, flowrunode.iscrossnode", new QFilter[]{sumRecordFilter, taskStatus}, "modifytime desc");
    }

    public DynamicObject[] queryAdjRecordByActEvalObjId(Long actEvalObjId) {
        QFilter adjFilter = new QFilter("actevalobj", "=", (Object)actEvalObjId);
        adjFilter.and(new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode()));
        return EVAL_ADJUSTMENT_ENTITY_SERVICE.queryOriginalArray("atcs, ins, atcl, actevalobj, flowrutask.id, flowrutask.taskstatus", new QFilter[]{adjFilter}, "modifytime desc");
    }

    public DynamicObject[] queryNdrRecordByActEvalObjId(Long actEvalObjId) {
        QFilter activityFilter = new QFilter("actevalobj", "=", (Object)actEvalObjId);
        return OBJ_NODE_RES_ENTITY_SERVICE.queryOriginalArray("flowruproc, flowrunode, sont, activity, actevalobj", new QFilter[]{activityFilter});
    }

    public Map<String, Object> queryPermissionConfig(Long taskId) {
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowruproc, flowrunode, flowrunode.index", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("executescheme, processpermsetting", new QFilter[]{activityFilter});
        HashMap<String, Object> permissionConfig = new HashMap<String, Object>(16);
        QFilter flowrunodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject flowrunodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{flowrunodeFilter});
        QFilter procPermFilter = new QFilter("scopeareaentry.aflowdefnode", "=", (Object)flowrunodeObj.getLong("flownodedef.id"));
        Long procPermId = activityObj.getLong("processpermsetting.id");
        procPermFilter.and(new QFilter("id", "=", (Object)procPermId));
        DataSet procPermObjs = PROCESS_PERMSETTING_ENTITY_SERVICE.queryDataSet("epa_processpermsetting", "scopeareaentry.aflowdefnode, scopeareaentry.scorecontent.number, scopeareaentry.scoreshowarea.number", new QFilter[]{procPermFilter});
        permissionConfig.put("flowrunodeId", flowruTaskObj.getLong("flowrunode.id"));
        permissionConfig.put("flowrunodeIndex", flowrunodeObj.getInt("index"));
        for (Row procPermObj : procPermObjs) {
            String scoreContent = procPermObj.getString("scopeareaentry.scorecontent.number");
            String scoreshowarea = procPermObj.getString("scopeareaentry.scoreshowarea.number");
            permissionConfig.put(scoreContent, scoreshowarea);
        }
        procPermObjs.close();
        return permissionConfig;
    }

    public DynamicObject queryActivityById(long activityId) {
        QFilter activityFilter = new QFilter("id", "=", (Object)activityId);
        return ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("name, dynamicpermission.id", new QFilter[]{activityFilter});
    }

    public Map<Long, String> queryAnonymity(Long procPermId) {
        HashMap<Long, String> anonymityMap = new HashMap<Long, String>(16);
        QFilter procPermFilter = new QFilter("id", "=", (Object)procPermId);
        procPermFilter.and(new QFilter("scopeareaentry.scorecontent.number", "=", (Object)ProcPermContentEnum.ANONYMOUS.getCode()));
        DataSet procPermDataSet = PROCESS_PERMSETTING_ENTITY_SERVICE.queryDataSet("epa_processpermsetting", "scopeareaentry.aflowdefnode, scopeareaentry.scorecontent.number, scopeareaentry.scoreshowarea.number", new QFilter[]{procPermFilter});
        for (Row row : procPermDataSet) {
            Long aflowdefnode = row.getLong("scopeareaentry.aflowdefnode");
            String scoreContent = row.getString("scopeareaentry.scoreshowarea.number");
            anonymityMap.put(aflowdefnode, scoreContent);
        }
        procPermDataSet.close();
        return anonymityMap;
    }

    public DynamicObject queryExecuteSchemeByActivityID(Long activityId) {
        return ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne(activityId);
    }

    public DynamicObject queryExecuteScheme(Long execSchemeId) {
        return EXECUTE_SCHEME_ENTITY.queryOne(execSchemeId);
    }

    public DynamicObject queryAssessForm(Long assessFormId) {
        return ASSESS_FORM_ENTITY_SERVICE.queryOne(assessFormId);
    }

    public List<Map<String, Object>> getBatchTaskDetails(Long batchTaskId) {
        QFilter taskStatusFilter = new QFilter("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
        taskStatusFilter.and("handler", "=", (Object)RequestContext.get().getCurrUserId());
        return FLOW_RU_SECOND_DOMAIN_SERVICE.getBatchTaskDetails(batchTaskId, taskStatusFilter);
    }

    public void saveEvalAdjObj(DynamicObject dyObj) {
        Long flowrutaskId = dyObj.getLong("flowrutask.id");
        this.resetRollBackedMark(Collections.singletonList(flowrutaskId));
        QFilter adjRecordFilter = new QFilter("flowrutask", "=", (Object)flowrutaskId);
        DynamicObject adjRecordObj = EVAL_ADJUSTMENT_ENTITY_SERVICE.queryOne("batcs, atcs, atv, ins, batcl, atcl, actevalobj, assessyear, assessperiod, activity, perforg, flowrutask, flowruproc, flowrunode, flowrurole, creator, createtime, modifier, modifytime", new QFilter[]{adjRecordFilter});
        Long userId = UserServiceHelper.getCurrentUserId();
        if (HRObjectUtils.isEmpty((Object)adjRecordObj)) {
            Long rowareainsId = DBServiceHelper.genLongIds((String)"epa_objadjrecord", (int)1)[0];
            DynamicObject adjObj = EVAL_ADJUSTMENT_ENTITY_SERVICE.generateEmptyDynamicObject();
            Long taskId = dyObj.getLong("flowrutask.id");
            DynamicObject taskObj = this.queryTaskInfo(taskId);
            Long actEvalObjId = dyObj.getLong("actevalobj");
            DynamicObject actEvalObj = this.queryActEvalObjById(actEvalObjId);
            adjObj.set("id", (Object)rowareainsId);
            adjObj.set("batcs", (Object)dyObj.getBigDecimal("batcs"));
            adjObj.set("atv", (Object)dyObj.getBigDecimal("atv"));
            adjObj.set("atcs", (Object)dyObj.getBigDecimal("atcs"));
            adjObj.set("ins", (Object)dyObj.getString("ins"));
            adjObj.set("batcl", (Object)dyObj.getString("batcl"));
            adjObj.set("atcl", (Object)dyObj.getString("atcl"));
            adjObj.set("actevalobj", (Object)dyObj.getLong("actevalobj"));
            adjObj.set("assessyear", (Object)actEvalObj.getInt("assessyear"));
            adjObj.set("assessperiod", (Object)actEvalObj.getString("assessperiod"));
            adjObj.set("activity", (Object)actEvalObj.getLong("activity.id"));
            adjObj.set("perforg", (Object)actEvalObj.getLong("perforg.id"));
            adjObj.set("flowrutask", (Object)taskObj.getLong("id"));
            adjObj.set("flowruproc", (Object)taskObj.getLong("flowruproc.id"));
            adjObj.set("flowrunode", (Object)taskObj.getLong("flowrunode.id"));
            adjObj.set("flowrurole", (Object)taskObj.getLong("flowrurole.id"));
            adjObj.set("creator", (Object)userId);
            adjObj.set("createtime", (Object)new Date());
            adjObj.set("modifier", (Object)userId);
            adjObj.set("modifytime", (Object)new Date());
            EVAL_ADJUSTMENT_ENTITY_SERVICE.saveOne(adjObj);
        } else {
            adjRecordObj.set("batcs", (Object)dyObj.getBigDecimal("batcs"));
            adjRecordObj.set("atv", (Object)dyObj.getBigDecimal("atv"));
            adjRecordObj.set("atcs", (Object)dyObj.getBigDecimal("atcs"));
            adjRecordObj.set("ins", (Object)dyObj.getString("ins"));
            adjRecordObj.set("batcl", (Object)dyObj.getString("batcl"));
            adjRecordObj.set("atcl", (Object)dyObj.getString("atcl"));
            adjRecordObj.set("modifier", (Object)userId);
            adjRecordObj.set("modifytime", (Object)new Date());
            EVAL_ADJUSTMENT_ENTITY_SERVICE.saveOne(adjRecordObj);
        }
    }

    public List<Map<String, Object>> getBatchTaskList(Long taskId, QFilter cusFilter) {
        DynamicObject[] taskDyns;
        DynamicObject taskDyo;
        ArrayList<Map<String, Object>> taskListMap = new ArrayList<Map<String, Object>>(10);
        DynamicObject[] batchTaskDyns = BATCH_TASKMAP_ENTITY_SERVICE.queryTaskByBatchTaskIds(Collections.singletonList(taskId));
        if (batchTaskDyns.length > 0) {
            taskId = batchTaskDyns[0].getLong("rutask.id");
        }
        if (null == (taskDyo = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(taskId))) {
            return taskListMap;
        }
        QFilter taskFilter = new QFilter("handler", "=", (Object)taskDyo.getDynamicObject("handler").getLong("id"));
        taskFilter.and("activity", "=", (Object)taskDyo.getLong("activity"));
        taskFilter.and("flowrurole.flowdefrole.id", "=", (Object)taskDyo.getLong("flowrurole.flowdefrole.id"));
        if (null != cusFilter) {
            taskFilter.and(cusFilter);
        }
        for (DynamicObject task : taskDyns = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByCusFilter(taskFilter)) {
            HashMap<String, Object> taskMap = new HashMap<String, Object>(16);
            taskMap.put("taskId", task.getLong("id"));
            taskMap.put("actEvaObjId", task.getLong("flowruproc.actevalobj"));
            taskMap.put("taskStatus", task.getString("taskstatus"));
            taskMap.put("indicatorColl", task.getDynamicObjectCollection("entryentity"));
            taskMap.put("iscrossevaluate", task.getBoolean("iscrossevaluate"));
            taskMap.put("activity", task.getLong("activity"));
            taskMap.put("flowrunode", task.getLong("flowrunode.id"));
            taskMap.put("flowrurole", task.getLong("flowrurole.id"));
            taskMap.put("handler", task.getLong("handler.id"));
            taskListMap.add(taskMap);
        }
        return taskListMap;
    }

    public Map<String, Boolean> querySumMustInputMap(Long taskId) {
        HashMap<String, Boolean> sumMustInput = new HashMap<String, Boolean>(16);
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowruproc, flowrunode", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, dynamicpermission", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("evalway, numaccuracy, sumconf, sumperflevel ", new QFilter[]{assessFormFilter});
        int numaccuracy = assessFormObj.getInt("numaccuracy");
        Long sumConfIdId = assessFormObj.getLong("sumconf");
        DynamicObject sumConfObj = SUM_CONFIG_ENTITY_SERVICE.queryOne(sumConfIdId);
        DynamicObjectCollection filedEntry = sumConfObj.getDynamicObjectCollection("entryentity");
        Map fieldMap = filedEntry.stream().collect(Collectors.toMap(filedInfo -> filedInfo.getDynamicObject("areafield").getString("number"), Function.identity()));
        QFilter flowruprocFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowruproc.id"));
        DynamicObject flowruprocObj = FLOW_RU_PROC_ENTITY_SERVICE.queryOne("defproc", new QFilter[]{flowruprocFilter});
        QFilter flowrunodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject flowrunodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{flowrunodeFilter});
        QFilter defprocFilter = new QFilter("id", "=", (Object)flowruprocObj.getLong("defproc.id"));
        DynamicObject defprocObj = FLOW_DEF_PROC_ENTITY_SERVICE.queryOne("name, index, nodeentry, nodeentry.adjusetscorelowerlimit, nodeentry.adjustscoreuplimit", new QFilter[]{defprocFilter});
        DynamicObjectCollection defNodeConfig = defprocObj.getDynamicObjectCollection("nodeentry");
        DynamicObject defnodeObj = defNodeConfig.stream().filter(obj -> flowrunodeObj.getLong("flownodedef.id") == obj.getLong("id")).findFirst().orElse(null);
        BigDecimal adjusetscorelowerlimit = defnodeObj.getBigDecimal("adjusetscorelowerlimit");
        BigDecimal adjustscoreuplimit = defnodeObj.getBigDecimal("adjustscoreuplimit");
        NodeRoleConfigBo roleConfig = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(taskId);
        long newProcPermId = activityObj.getLong("dynamicpermission.id");
        long flowNodeDefId = flowrunodeObj.getLong("flownodedef.id");
        Map<Long, Map<String, Boolean>> areaFieldPermMap = this.getAreaFieldPermMap(sumConfIdId, newProcPermId, flowNodeDefId);
        if (areaFieldPermMap != null) {
            Set<Long> areaFieldIdSet = areaFieldPermMap.keySet();
            QFilter filter = new QFilter("id", "in", areaFieldIdSet);
            DynamicObject[] fieldArr = AREA_FIELD_ENTITY_SERVICE.queryOriginalArray("id,number", new QFilter[]{filter});
            if (fieldArr != null) {
                block10: for (DynamicObject fieldDy : fieldArr) {
                    if (fieldDy == null) continue;
                    String number = fieldDy.getString("number");
                    long areaFieldId = fieldDy.getLong("id");
                    Map<String, Boolean> procPermObj = areaFieldPermMap.get(areaFieldId);
                    Boolean fielddisplayitem = procPermObj.get("fielddisplayitem");
                    Boolean fieldmustinputitem = procPermObj.get("fieldmustinputitem");
                    Boolean fieldmodifyitem = procPermObj.get("fieldmodifyitem");
                    switch (number) {
                        case "ose": {
                            if (fielddisplayitem.booleanValue()) {
                                sumMustInput.put("atv", fieldmustinputitem);
                                continue block10;
                            }
                            sumMustInput.put("atv", Boolean.FALSE);
                            continue block10;
                        }
                        case "ole": {
                            if (fielddisplayitem.booleanValue()) {
                                DynamicObject oleObj = (DynamicObject)fieldMap.get("ole");
                                if (oleObj != null) {
                                    if (fielddisplayitem.booleanValue()) {
                                        sumMustInput.put("atcl", fieldmustinputitem);
                                        continue block10;
                                    }
                                    sumMustInput.put("atcl", Boolean.FALSE);
                                    continue block10;
                                }
                                sumMustInput.put("atcl", Boolean.FALSE);
                                continue block10;
                            }
                            sumMustInput.put("atcl", Boolean.FALSE);
                            continue block10;
                        }
                        case "eval": {
                            if (fielddisplayitem.booleanValue()) {
                                sumMustInput.put("ins", fieldmustinputitem);
                                continue block10;
                            }
                            sumMustInput.put("ins", Boolean.FALSE);
                            continue block10;
                        }
                    }
                }
            }
        }
        if (!sumMustInput.containsKey("atv")) {
            sumMustInput.put("atv", Boolean.FALSE);
        }
        if (!sumMustInput.containsKey("atcl")) {
            sumMustInput.put("atcl", Boolean.FALSE);
        }
        if (!sumMustInput.containsKey("ins")) {
            sumMustInput.put("ins", Boolean.FALSE);
        }
        return sumMustInput;
    }

    private Map<Long, Map<String, Boolean>> getAreaFieldPermMap(Long sumConfIdId, Long newProcPermId, Long flowNodeDefId) {
        List contentAreaEntries;
        Map contentAreaEntriesMap;
        DynPermissionConfigService dynPermissionConfigService = new DynPermissionConfigService();
        DynamicPermissionConfigVO dynamicPermissions = dynPermissionConfigService.getDynamicPermissions(newProcPermId, Collections.singletonList(flowNodeDefId));
        HashMap<Long, Map<String, Boolean>> areaFieldPermMap = new HashMap<Long, Map<String, Boolean>>(16);
        if (dynamicPermissions != null && (contentAreaEntriesMap = dynamicPermissions.getContentAreaEntriesMap()) != null && (contentAreaEntries = (List)contentAreaEntriesMap.get(flowNodeDefId)) != null) {
            for (ContentAreaEntry contentAreaEntry : contentAreaEntries) {
                Boolean areaDisplay;
                if (contentAreaEntry == null) continue;
                Long areaPageInsId = contentAreaEntry.getAreapageInsId();
                if (sumConfIdId == null || !sumConfIdId.equals(areaPageInsId)) continue;
                List fieldEntries = contentAreaEntry.getFieldEntries();
                Boolean bl = areaDisplay = contentAreaEntry.getAreaDisplay() == null ? Boolean.FALSE : contentAreaEntry.getAreaDisplay();
                if (areaDisplay != null && !areaDisplay.booleanValue() || fieldEntries == null) continue;
                for (ContentFieldEntry fieldEntry : fieldEntries) {
                    if (fieldEntry == null) continue;
                    Long areaFieldId = fieldEntry.getAreaFieldId();
                    Map<String, Boolean> procPermItemMap = this.getProcPermItemMap(fieldEntry);
                    areaFieldPermMap.put(areaFieldId, procPermItemMap);
                }
            }
        }
        return areaFieldPermMap;
    }

    private Map<String, Boolean> getProcPermItemMap(ContentFieldEntry fieldEntry) {
        Boolean fieldDisplay = fieldEntry.getFieldDisplay() == null ? Boolean.FALSE : fieldEntry.getFieldDisplay();
        Boolean fieldModify = fieldEntry.getFieldModify() == null ? Boolean.FALSE : fieldEntry.getFieldModify();
        Boolean fieldMustInput = fieldEntry.getFieldMustInput() == null ? Boolean.FALSE : fieldEntry.getFieldMustInput();
        HashMap<String, Boolean> procPermItemMap = new HashMap<String, Boolean>(16);
        procPermItemMap.put("fielddisplayitem", fieldDisplay);
        procPermItemMap.put("fieldmustinputitem", fieldMustInput);
        procPermItemMap.put("fieldmodifyitem", fieldModify);
        return procPermItemMap;
    }

    public DynamicObject queryGenAreaConf(Long areaConfId) {
        return NORMAL_CONFIG_ENTITY_SERVICE.queryOne(areaConfId);
    }

    public DynamicObject queryAddSubAreaConf(Long areaConfId) {
        return PLUS_MINUS_CONFIG_ENTITY_SERVICE.queryOne(areaConfId);
    }

    public DynamicObject queryPerfLevelById(Long sumperfLevelId) {
        return PERF_LEVEL_ENTITY.queryOne((Object)sumperfLevelId);
    }

    public Map<Long, Object> queryBatchProcessPermSettingScope(List<Long> taskIdList) {
        DynamicObject[] taskObjs;
        Map<Long, Object> permCfgMap = new HashMap<Long, Object>(16);
        if (taskIdList != null && !taskIdList.isEmpty() && (taskObjs = this.queryTaskById(taskIdList)) != null && taskObjs.length > 0) {
            Long activityId = taskObjs[0].getLong("activity");
            DynamicObject activityObj = this.queryActivityById(activityId);
            Long procPermId = activityObj.getLong("dynamicpermission.id");
            Set nodeDefIdSet = Arrays.stream(taskObjs).map(obj -> obj.getLong("flowrunode.flownodedef.id")).collect(Collectors.toSet());
            ArrayList<Long> nodeDefIdList = new ArrayList<Long>(nodeDefIdSet);
            permCfgMap = PROCESS_PERM_SETTING_ENTITY_SERVICE.queryBatchProcessPermSettingScope(procPermId, nodeDefIdList);
        }
        return permCfgMap;
    }

    public Long queryPreRoleLastTaskOfEval(Long taskId) {
        if (taskId == null) {
            return null;
        }
        boolean isFirstNodeAndRole = this.queryIsFirstNodeAndRole(taskId);
        if (isFirstNodeAndRole) {
            return null;
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Map<Long, Long> roleMap = this.queryPreNodeLastRoleMap(taskId);
            return this.getNextEvalLastTaskId(roleMap);
        }
        Map<Long, Long> sortRoleDefMap = this.getMaxOverSortRoleMap(roles);
        return this.getNextEvalLastTaskId(sortRoleDefMap);
    }

    public boolean queryIsFirstNodeAndRole(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return true;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles != null && roles.length > 0) {
            return false;
        }
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryIsFirstNode(taskId);
    }

    public Map<Long, Long> queryPreNodeLastRoleMap(Long taskId) {
        Map roleDefMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryPreNodeLastRoleMap(taskId);
        return roleDefMap;
    }

    private Long getNextEvalLastTaskId(Map<Long, Long> sortRoleDefMap) {
        Set<Long> defRoleIdSet = sortRoleDefMap.keySet();
        ArrayList<Long> nextRuRoleIdList = new ArrayList<Long>(10);
        Map roleConfigBoMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(defRoleIdSet);
        if (roleConfigBoMap != null) {
            for (Map.Entry next : roleConfigBoMap.entrySet()) {
                Long ruRoleId;
                Boolean isEvalNext;
                NodeRoleConfigBo roleConfigBo;
                if (next == null || (roleConfigBo = (NodeRoleConfigBo)next.getValue()) == null || (isEvalNext = roleConfigBo.getIsevaluatenext()) == null || !isEvalNext.booleanValue() || (ruRoleId = sortRoleDefMap.get(next.getKey())) == null) continue;
                nextRuRoleIdList.add(ruRoleId);
            }
        }
        Long lastTaskIdOfFinish = this.queryLastTaskIdByRoleIds(nextRuRoleIdList);
        return lastTaskIdOfFinish;
    }

    public Long queryLastTaskIdByRoleIds(List<Long> ruRoleIds) {
        if (ruRoleIds == null || ruRoleIds.isEmpty()) {
            return null;
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryLastTaskByRoleIds(ruRoleIds);
        if (taskObj == null) {
            return null;
        }
        return taskObj.getLong("id");
    }

    private Map<Long, Long> getMaxOverSortRoleMap(DynamicObject[] roles) {
        HashMap<Long, Long> ruRoleMap = new HashMap<Long, Long>(16);
        DynamicObject maxSortRole = null;
        for (DynamicObject role : roles) {
            if (role == null) continue;
            if (maxSortRole == null) {
                maxSortRole = role;
            }
            int turnOverSort = role.getInt("turnoversort");
            int maxTurnOverSort = maxSortRole.getInt("turnoversort");
            if (maxTurnOverSort != turnOverSort) continue;
            ruRoleMap.put(role.getLong("flowdefrole.id"), role.getLong("id"));
        }
        return ruRoleMap;
    }

    public DynamicObject[] querySumRecordByActEvalObjIds(List<Long> actEvalObjIds) {
        QFilter sumRecordFilter = new QFilter("actevalobj", "in", actEvalObjIds);
        QFilter taskStatus = new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        return OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.query("actevalobj, ose, ole, eval, flowrutask, flowrutask.taskstatus, flowrutask.handler, flowrunode.iscrossnode", new QFilter[]{sumRecordFilter, taskStatus}, "modifytime desc");
    }

    public WorkflowRuProcBo getRuProcInstance(Long evalflowinsId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.getRuProcInstance(evalflowinsId);
    }

    public DynamicObject queryActEvalObjByFlowInsId(Long evalflowinsId) {
        QFilter filter = new QFilter("evalflowins", "=", (Object)evalflowinsId);
        return ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.queryOne("id, person.id", new QFilter[]{filter});
    }

    public Map<Long, Long> getUserIdsByPersonIds(List<Long> personIds) {
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(16);
        HashMap<String, List<Long>> personIdMap = new HashMap<String, List<Long>>(16);
        personIdMap.put("person", personIds);
        Map userIdByPersonInfo = new HashMap(16);
        try {
            userIdByPersonInfo = PERSON_SERVICE.getUserIdByPersonInfo(personIdMap);
        }
        catch (Exception e) {
            LOG.error("\u3010OPMC\u3011-getUserIdsByPersonIds error,personIds:{}", personIds);
            LOG.error((Throwable)e);
        }
        if (userIdByPersonInfo.isEmpty()) {
            return retMap;
        }
        Boolean success = (Boolean)userIdByPersonInfo.get("success");
        if (success.booleanValue()) {
            Map userInfo = (Map)userIdByPersonInfo.get("data");
            ArrayList<Long> userIds = new ArrayList<Long>(personIds.size());
            for (Long personId : personIds) {
                Map user = (Map)userInfo.get(personId);
                if (user == null) continue;
                Long userId = (Long)user.get("user");
                userIds.add(userId);
            }
            Map<Long, Boolean> userIsEnableMap = this.batchQueryUserIsEnable(userIds);
            for (Long personId : personIds) {
                Long userId;
                Map user = (Map)userInfo.get(personId);
                if (user == null || !userIsEnableMap.getOrDefault(userId = (Long)user.get("user"), false).booleanValue()) continue;
                retMap.put(personId, userId);
            }
        }
        return retMap;
    }

    private Map<Long, Boolean> batchQueryUserIsEnable(List<Long> userIds) {
        List userInfo = UserServiceHelper.get(userIds, (String[])new String[]{"id", "isforbidden", "enable"}, null);
        HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>(16);
        if (CollectionUtils.isEmpty((Collection)userInfo)) {
            return ret;
        }
        for (Map user : userInfo) {
            ret.put((Long)user.get("id"), (Boolean)user.get("isforbidden") == false && "1".equals(user.get("enable")));
        }
        return ret;
    }

    public DynamicObject querySumAreaEvalRecordOfPreRoleLastTask(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return null;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Map<Long, Long> roleMap = this.queryPreNodeLastRoleMap(taskId);
            return this.queryLastTaskSumAreaEvalRecord(roleMap);
        }
        HashMap<Long, Long> sortRoleMap = new HashMap<Long, Long>(16);
        DynamicObject maxSortRole = null;
        for (DynamicObject role : roles) {
            if (role == null) continue;
            if (maxSortRole == null) {
                maxSortRole = role;
            }
            int turnOverSort = role.getInt("turnoversort");
            int maxTurnOverSort = maxSortRole.getInt("turnoversort");
            if (maxTurnOverSort != turnOverSort) continue;
            sortRoleMap.put(role.getLong("flowdefrole.id"), role.getLong("id"));
        }
        return this.queryLastTaskSumAreaEvalRecord(sortRoleMap);
    }

    private DynamicObject queryLastTaskSumAreaEvalRecord(Map<Long, Long> sortRoleMap) {
        DynamicObject dynamicObject;
        Long lastTaskIdOfFinish;
        Set<Long> defRoleIdSet = sortRoleMap.keySet();
        ArrayList<Long> scoreNextRoleIdList = new ArrayList<Long>(10);
        Map roleConfigBoMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(defRoleIdSet);
        HashMap<Long, Boolean> isCarryLevelMap = new HashMap<Long, Boolean>(16);
        HashMap<Long, Boolean> isCarryEvaluMap = new HashMap<Long, Boolean>(16);
        if (roleConfigBoMap != null) {
            for (Map.Entry next : roleConfigBoMap.entrySet()) {
                Boolean isevaluatenext;
                NodeRoleConfigBo roleConfigBo;
                if (next == null || (roleConfigBo = (NodeRoleConfigBo)next.getValue()) == null) continue;
                Long runRoleId = sortRoleMap.get(next.getKey());
                Boolean isgradenext = roleConfigBo.getIsgradenext();
                if (isgradenext != null && isgradenext.booleanValue()) {
                    isCarryLevelMap.put(runRoleId, true);
                    scoreNextRoleIdList.add(runRoleId);
                }
                if ((isevaluatenext = roleConfigBo.getIsevaluatenext()) == null || !isevaluatenext.booleanValue()) continue;
                isCarryEvaluMap.put(runRoleId, true);
                if (scoreNextRoleIdList.contains(runRoleId)) continue;
                scoreNextRoleIdList.add(runRoleId);
            }
        }
        if ((lastTaskIdOfFinish = this.queryLastTaskIdByRoleIds(scoreNextRoleIdList)) != null && (dynamicObject = this.querySumAreaEvalRecord(lastTaskIdOfFinish)) != null) {
            DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(lastTaskIdOfFinish);
            long flowRuRoleId = taskObj.getLong("flowrurole.id");
            if (isCarryEvaluMap.get(flowRuRoleId) == null || !((Boolean)isCarryEvaluMap.get(flowRuRoleId)).booleanValue()) {
                dynamicObject.set("eval", null);
            } else if (isCarryLevelMap.get(flowRuRoleId) == null || !((Boolean)isCarryLevelMap.get(flowRuRoleId)).booleanValue()) {
                dynamicObject.set("ole", null);
            }
            return dynamicObject;
        }
        return null;
    }

    public DynamicObject querySumAreaEvalRecord(Long taskId) {
        QFilter sumareaFilter = new QFilter("flowrutask", "=", (Object)taskId);
        return OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.queryOne("actevalobj, ose, ole, eval", sumareaFilter);
    }

    public Long queryPreRoleLastTaskOfNextEval(Long taskId) {
        if (taskId == null) {
            return null;
        }
        boolean isFirstNodeAndRole = this.queryIsFirstNodeAndRole(taskId);
        if (isFirstNodeAndRole) {
            return null;
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Map<Long, Long> roleMap = this.queryPreNodeLastRoleMap(taskId);
            return this.getNextEvalLastTaskId(roleMap);
        }
        Map<Long, Long> sortRoleDefMap = this.getMaxOverSortRoleMap(roles);
        return this.getNextEvalLastTaskId(sortRoleDefMap);
    }

    public DynamicObject[] queryGenRecordByActEvalObjId(Long actEvalObjId) {
        QFilter taskFilter = new QFilter("actevalobj", "in", (Object)actEvalObjId);
        QFilter taskStatus = new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        return GEN_AREA_RECORD_ENTITY.query("id, flowrutask", new QFilter[]{taskFilter, taskStatus}, "modifytime desc");
    }
}

