/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.evalback.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activitymanage.enums.EvalfinishtypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.evalback.entity.EvalBackInfoResult;
import kd.opmc.epa.business.domain.evalback.entity.EvalBackTaskDto;
import kd.opmc.epa.business.domain.evalback.entity.EvalBatchBackDto;
import kd.opmc.epa.business.domain.evalback.entity.EvalBatchBackResult;
import kd.opmc.epa.business.domain.indicator.service.IndicatorGroupDomainService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import org.apache.commons.collections.MapUtils;

public class ActEvalObjBackDomainService {
    private static final Log LOG = LogFactory.getLog(IndicatorGroupDomainService.class);
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActEvalObjManageDomainService ACTEVALOBJMANAGE_DOMAIN_SERVICE = ActEvalObjManageDomainService.getInstance();

    public static ActEvalObjBackDomainService getInstance() {
        return ServiceFactory.getService(ActEvalObjBackDomainService.class);
    }

    public EvalBatchBackResult validateEvalBatchBack(List<EvalBatchBackDto> evalBatchBackDtoList) {
        EvalBatchBackResult evalBatchBackResult = new EvalBatchBackResult();
        if (CollectionUtils.isEmpty(evalBatchBackDtoList)) {
            LOG.info("BatchBack's evalBatchBackDtoList is null!");
            return evalBatchBackResult;
        }
        evalBatchBackResult.setTotalCount(evalBatchBackDtoList.size());
        this.validateEvalBatchBackDeal(evalBatchBackDtoList, evalBatchBackResult);
        return evalBatchBackResult;
    }

    private void validateEvalBatchBackDeal(List<EvalBatchBackDto> evalBatchBackDtoList, EvalBatchBackResult evalBatchBackResult) {
        List<Long> evalObjIdList = evalBatchBackDtoList.stream().map(evalBatchBackDto -> evalBatchBackDto.getEvalObjId()).collect(Collectors.toList());
        Map<Long, DynamicObject> evalMap = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjById(evalObjIdList);
        String successReason = ResManager.loadKDString((String)"\u9000\u56de\u6821\u9a8c\u6210\u529f\u3002", (String)"ActEvalObjBackDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]);
        for (EvalBatchBackDto evalBatchBackDto2 : evalBatchBackDtoList) {
            DynamicObject evalObjDy = evalMap.get(evalBatchBackDto2.getEvalObjId());
            String evalfinishtype = evalObjDy.getString("evalfinishtype");
            if (HRStringUtils.equals((String)evalfinishtype, (String)EvalfinishtypeEnum.NOPART_EVAL.getType())) {
                evalBatchBackResult.addFailureCount(1);
                evalBatchBackResult.addFailureBackInfoList(evalBatchBackDto2.getEvalObjId(), ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u8bc4\u4f30\u5b8c\u6210\u65b9\u5f0f\u4e3a\u201c\u4e0d\u53c2\u4e0e\u8bc4\u4f30\u201d\uff0c\u4e0d\u53ef\u9000\u56de\u3002", (String)"ActEvalObjBackDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]));
                continue;
            }
            if (HRStringUtils.equals((String)evalfinishtype, (String)EvalfinishtypeEnum.HANDWORK_INPUT.getType())) {
                evalBatchBackResult.addFailureCount(1);
                evalBatchBackResult.addFailureBackInfoList(evalBatchBackDto2.getEvalObjId(), ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u8bc4\u4f30\u5b8c\u6210\u65b9\u5f0f\u4e3a\u201c\u624b\u5de5\u5f55\u5165\u201d\uff0c\u4e0d\u53ef\u9000\u56de\u3002", (String)"ActEvalObjBackDomainService_2", (String)"opmc-epa-business", (Object[])new Object[0]));
                continue;
            }
            if (HRStringUtils.equals((String)evalfinishtype, (String)EvalfinishtypeEnum.FINISH_EVAL.getType())) {
                evalBatchBackResult.addFailureCount(1);
                evalBatchBackResult.addFailureBackInfoList(evalBatchBackDto2.getEvalObjId(), ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u8bc4\u4f30\u5b8c\u6210\u65b9\u5f0f\u4e3a\u201c\u7ed3\u675f\u8bc4\u4f30\u201d\uff0c\u4e0d\u53ef\u9000\u56de\u3002", (String)"ActEvalObjBackDomainService_3", (String)"opmc-epa-business", (Object[])new Object[0]));
                continue;
            }
            if (null == evalBatchBackDto2.getRuNodeId() || 0L == evalBatchBackDto2.getRuNodeId()) {
                evalBatchBackResult.addFailureCount(1);
                evalBatchBackResult.addFailureBackInfoList(evalBatchBackDto2.getEvalObjId(), ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u5bf9\u8c61\u9000\u56de\u6307\u5b9a\u7684\u8282\u70b9\u5b9e\u4f8b\u4e3a\u7a7a\u3002", (String)"ActEvalObjBackDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]));
                continue;
            }
            evalBatchBackResult.addSuccessCount(1);
            evalBatchBackResult.addSuccessBackInfoList(evalBatchBackDto2.getEvalObjId(), successReason);
        }
    }

    public EvalBatchBackResult evalBatchBack(List<EvalBatchBackDto> evalBatchBackDtoList) {
        EvalBatchBackResult evalBatchBackResult = new EvalBatchBackResult();
        if (CollectionUtils.isEmpty(evalBatchBackDtoList)) {
            LOG.info("BatchBack's evalBatchBackDtoList is null!");
            return evalBatchBackResult;
        }
        evalBatchBackResult.setTotalCount(evalBatchBackDtoList.size());
        Map<String, Object> splitMap = this.splitEvalBatchBackData(evalBatchBackDtoList, evalBatchBackResult);
        this.startFlowBatchBack(splitMap, evalBatchBackResult);
        this.uptEvalProcessData(evalBatchBackResult);
        return evalBatchBackResult;
    }

    private void startFlowBatchBack(Map<String, Object> splitMap, EvalBatchBackResult evalBatchBackResult) {
        List nodeBackList = (List)splitMap.get("nodeBackList");
        if (CollectionUtils.isNotEmpty((Collection)nodeBackList)) {
            FlowValidateResultBo flowValidateResultBo = FLOW_RU_SECOND_DOMAIN_SERVICE.rollbackToSpecifiedNode(nodeBackList);
            this.setEvalBatchBackNodeResult(evalBatchBackResult, nodeBackList, flowValidateResultBo);
        }
        List taskBackList = (List)splitMap.get("taskBackList");
        List taskBackDtoList = (List)splitMap.get("taskBackDtoList");
        if (CollectionUtils.isNotEmpty((Collection)taskBackList)) {
            FlowValidateResultBo flowValidateResultBo = FLOW_RU_SECOND_DOMAIN_SERVICE.rollbackToSpecifiedTask(taskBackList);
            this.setEvalBatchBackTaskResult(evalBatchBackResult, taskBackDtoList, flowValidateResultBo);
        }
    }

    public void addAllBackInfoListWithType(EvalBatchBackResult evalBatchBackResult, List<RollbackParamBo> backList, String type, String dealReason) {
        for (RollbackParamBo RollbackParamBo2 : backList) {
            if (HRStringUtils.equals((String)"0", (String)type)) {
                evalBatchBackResult.addFailureBackInfoList(RollbackParamBo2.getActevalobjId(), dealReason);
                continue;
            }
            evalBatchBackResult.addSuccessBackInfoList(RollbackParamBo2.getActevalobjId(), dealReason);
        }
    }

    private void setEvalBatchBackTaskResult(EvalBatchBackResult evalBatchBackResult, List<EvalBatchBackDto> taskBackList, FlowValidateResultBo flowValidateResultBo) {
        if (null == flowValidateResultBo) {
            evalBatchBackResult.addFailureCount(taskBackList.size());
            evalBatchBackResult.addAllFailureBackInfoList(taskBackList, ResManager.loadKDString((String)"\u8c03\u7528\u6d41\u7a0b\u9000\u56de\u8bc4\u4f30\u4eba\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"ActEvalObjBackDomainService_5", (String)"opmc-epa-business", (Object[])new Object[0]));
            return;
        }
        String successReason = ResManager.loadKDString((String)"\u9000\u56de\u8bc4\u4f30\u4eba\u6210\u529f\u3002", (String)"ActEvalObjBackDomainService_6", (String)"opmc-epa-business", (Object[])new Object[0]);
        String code = flowValidateResultBo.getCode();
        Map validateMap = flowValidateResultBo.getValidateMap();
        if (HRStringUtils.equals((String)"1", (String)code) || MapUtils.isEmpty((Map)validateMap)) {
            evalBatchBackResult.addSuccessCount(taskBackList.size());
            evalBatchBackResult.addAllSuccessBackInfoList(taskBackList, successReason);
            return;
        }
        for (EvalBatchBackDto backDto : taskBackList) {
            Long evalObjId = backDto.getEvalObjId();
            String validateErrorMsg = (String)validateMap.get(evalObjId);
            if (HRStringUtils.isEmpty((String)validateErrorMsg)) {
                evalBatchBackResult.addSuccessCount(1);
                evalBatchBackResult.addSuccessBackInfoList(evalObjId, successReason);
                continue;
            }
            evalBatchBackResult.addFailureCount(1);
            evalBatchBackResult.addFailureBackInfoList(evalObjId, validateErrorMsg);
        }
    }

    private void setEvalBatchBackNodeResult(EvalBatchBackResult evalBatchBackResult, List<RollbackParamBo> backList, FlowValidateResultBo flowValidateResultBo) {
        if (null == flowValidateResultBo) {
            evalBatchBackResult.addFailureCount(backList.size());
            this.addAllBackInfoListWithType(evalBatchBackResult, backList, "0", ResManager.loadKDString((String)"\u8c03\u7528\u6d41\u7a0b\u9000\u56de\u8282\u70b9\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"ActEvalObjBackDomainService_7", (String)"opmc-epa-business", (Object[])new Object[0]));
            return;
        }
        String successReason = ResManager.loadKDString((String)"\u9000\u56de\u8282\u70b9\u6210\u529f\u3002", (String)"ActEvalObjBackDomainService_8", (String)"opmc-epa-business", (Object[])new Object[0]);
        String code = flowValidateResultBo.getCode();
        Map validateMap = flowValidateResultBo.getValidateMap();
        if (HRStringUtils.equals((String)"1", (String)code) || MapUtils.isEmpty((Map)validateMap)) {
            evalBatchBackResult.addSuccessCount(backList.size());
            this.addAllBackInfoListWithType(evalBatchBackResult, backList, "1", successReason);
            return;
        }
        for (RollbackParamBo backDto : backList) {
            Long evalObjId = backDto.getActevalobjId();
            String validateErrorMsg = (String)validateMap.get(evalObjId);
            if (HRStringUtils.isEmpty((String)validateErrorMsg)) {
                evalBatchBackResult.addSuccessCount(1);
                evalBatchBackResult.addSuccessBackInfoList(evalObjId, successReason);
                continue;
            }
            evalBatchBackResult.addFailureCount(1);
            evalBatchBackResult.addFailureBackInfoList(evalObjId, validateErrorMsg);
        }
    }

    private void uptEvalProcessData(EvalBatchBackResult evalBatchBackResult) {
        List<EvalBackInfoResult> sucessBackInfoList = evalBatchBackResult.getSucessBackInfoList();
        if (CollectionUtils.isEmpty(sucessBackInfoList)) {
            return;
        }
        List<Long> evalObjIdList = sucessBackInfoList.stream().map(sucessBackInfo -> sucessBackInfo.getEvalObjId()).collect(Collectors.toList());
        ACTEVALOBJMANAGE_DOMAIN_SERVICE.returnEval(evalObjIdList);
    }

    private Map<String, Object> splitEvalBatchBackData(List<EvalBatchBackDto> evalBatchBackDtoList, EvalBatchBackResult evalBatchBackResult) {
        HashMap splitMap = Maps.newHashMapWithExpectedSize((int)16);
        List<Long> evalObjIdList = evalBatchBackDtoList.stream().map(evalBatchBackDto -> evalBatchBackDto.getEvalObjId()).collect(Collectors.toList());
        Map<Long, DynamicObject> evalMap = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjById(evalObjIdList);
        ArrayList nodeBackList = Lists.newArrayListWithCapacity((int)10);
        ArrayList taskBackList = Lists.newArrayListWithCapacity((int)10);
        ArrayList taskBackDtoList = Lists.newArrayListWithCapacity((int)10);
        for (EvalBatchBackDto evalBatchBackDto2 : evalBatchBackDtoList) {
            DynamicObject evalObjDy = evalMap.get(evalBatchBackDto2.getEvalObjId());
            if (HRObjectUtils.isEmpty((Object)evalObjDy)) {
                evalBatchBackResult.addFailureCount(1);
                evalBatchBackResult.addFailureBackInfoList(evalBatchBackDto2.getEvalObjId(), ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"ActEvalObjBackDomainService_9", (String)"opmc-epa-business", (Object[])new Object[0]));
                continue;
            }
            boolean whetherEvalBackType = this.valWhetherEvalBackType(evalBatchBackResult, evalBatchBackDto2, evalObjDy);
            if (!whetherEvalBackType) continue;
            if (CollectionUtils.isEmpty(evalBatchBackDto2.getTaskList())) {
                this.builderNodeBackList(evalBatchBackDto2, evalMap.get(evalBatchBackDto2.getEvalObjId()), nodeBackList);
                continue;
            }
            this.builderTaskBackList(evalBatchBackDto2, evalMap.get(evalBatchBackDto2.getEvalObjId()), taskBackList);
            taskBackDtoList.add(evalBatchBackDto2);
        }
        splitMap.put("nodeBackList", nodeBackList);
        splitMap.put("taskBackList", taskBackList);
        splitMap.put("taskBackDtoList", taskBackDtoList);
        return splitMap;
    }

    private boolean valWhetherEvalBackType(EvalBatchBackResult evalBatchBackResult, EvalBatchBackDto evalBatchBackDto, DynamicObject evalObjDy) {
        String evalfinishtype = evalObjDy.getString("evalfinishtype");
        if (HRStringUtils.equals((String)evalfinishtype, (String)EvalfinishtypeEnum.NOPART_EVAL.getType())) {
            evalBatchBackResult.addFailureCount(1);
            evalBatchBackResult.addFailureBackInfoList(evalBatchBackDto.getEvalObjId(), ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u8bc4\u4f30\u5b8c\u6210\u65b9\u5f0f\u4e3a\u201c\u4e0d\u53c2\u4e0e\u8bc4\u4f30\u201d\uff0c\u4e0d\u53ef\u9000\u56de\u3002", (String)"ActEvalObjBackDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (HRStringUtils.equals((String)evalfinishtype, (String)EvalfinishtypeEnum.HANDWORK_INPUT.getType())) {
            evalBatchBackResult.addFailureCount(1);
            evalBatchBackResult.addFailureBackInfoList(evalBatchBackDto.getEvalObjId(), ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u8bc4\u4f30\u5b8c\u6210\u65b9\u5f0f\u4e3a\u201c\u624b\u5de5\u5f55\u5165\u201d\uff0c\u4e0d\u53ef\u9000\u56de\u3002", (String)"ActEvalObjBackDomainService_2", (String)"opmc-epa-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (HRStringUtils.equals((String)evalfinishtype, (String)EvalfinishtypeEnum.FINISH_EVAL.getType())) {
            evalBatchBackResult.addFailureCount(1);
            evalBatchBackResult.addFailureBackInfoList(evalBatchBackDto.getEvalObjId(), ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u8bc4\u4f30\u5b8c\u6210\u65b9\u5f0f\u4e3a\u201c\u7ed3\u675f\u8bc4\u4f30\u201d\uff0c\u4e0d\u53ef\u9000\u56de\u3002", (String)"ActEvalObjBackDomainService_3", (String)"opmc-epa-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (null == evalBatchBackDto.getRuNodeId() || 0L == evalBatchBackDto.getRuNodeId()) {
            evalBatchBackResult.addFailureCount(1);
            evalBatchBackResult.addFailureBackInfoList(evalBatchBackDto.getEvalObjId(), ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u5bf9\u8c61\u9000\u56de\u6307\u5b9a\u7684\u8282\u70b9\u5b9e\u4f8b\u4e3a\u7a7a\u3002", (String)"ActEvalObjBackDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void builderTaskBackList(EvalBatchBackDto evalBatchBackDto, DynamicObject evalObjDy, List<RollbackParamBo> taskBackList) {
        List<EvalBackTaskDto> taskList = evalBatchBackDto.getTaskList();
        for (EvalBackTaskDto evalBackTaskDto : taskList) {
            RollbackParamBo rollbackParamBo = this.getRollbackParamBo(evalBatchBackDto, evalObjDy);
            rollbackParamBo.setRuTaskId(evalBackTaskDto.getTaskId());
            rollbackParamBo.setIndicatorIds(evalBackTaskDto.getIndicatorIdList());
            taskBackList.add(rollbackParamBo);
        }
    }

    private RollbackParamBo getRollbackParamBo(EvalBatchBackDto evalBatchBackDto, DynamicObject evalObjDy) {
        RollbackParamBo rollbackParamBo = new RollbackParamBo();
        rollbackParamBo.setActivityId(Long.valueOf(evalObjDy.getLong("activity.id")));
        rollbackParamBo.setActevalobjId(Long.valueOf(evalObjDy.getLong("id")));
        rollbackParamBo.setRollbackType("2");
        rollbackParamBo.setRuNodeId(evalBatchBackDto.getRuNodeId());
        rollbackParamBo.setRuProcId(Long.valueOf(evalObjDy.getLong("evalflowins")));
        rollbackParamBo.setReason(evalBatchBackDto.getBackReason());
        return rollbackParamBo;
    }

    private void builderNodeBackList(EvalBatchBackDto evalBatchBackDto, DynamicObject evalObjDy, List<RollbackParamBo> nodeBackList) {
        RollbackParamBo rollbackParamBo = this.getRollbackParamBo(evalBatchBackDto, evalObjDy);
        nodeBackList.add(rollbackParamBo);
    }
}

