/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.evalback.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.evalback.entity.EvalBackInfoResult;
import kd.opmc.epa.business.domain.evalback.entity.EvalBatchBackDto;
import kd.opmc.epa.business.domain.evalback.entity.EvalBatchBackResult;
import kd.opmc.epa.business.domain.evalback.service.ActEvalObjBackDomainService;
import kd.opmc.epa.business.domain.evalback.service.IBackDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.enums.activitymanage.NodeIdScoreEnum;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;

public class ActEvalObjConfirmBackDomainService
implements IBackDomainService {
    private static final Log log = LogFactory.getLog(ActEvalObjConfirmBackDomainService.class);
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();

    public static ActEvalObjBackDomainService getInstance() {
        return ServiceFactory.getService(ActEvalObjBackDomainService.class);
    }

    @Override
    public EvalBatchBackResult validate(List<EvalBatchBackDto> evalBatchBackDtoList) {
        log.info("confirm back validate start..., evalBatchBackDtoList:" + evalBatchBackDtoList);
        if (CollectionUtils.isEmpty(evalBatchBackDtoList)) {
            return new EvalBatchBackResult();
        }
        ArrayList<Long> actObjIds = new ArrayList<Long>(10);
        for (EvalBatchBackDto evalBatchBackDto : evalBatchBackDtoList) {
            actObjIds.add(evalBatchBackDto.getEvalObjId());
        }
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        HashMap<Long, DynamicObject> evalObjMap = new HashMap<Long, DynamicObject>(16);
        DynamicObject[] evalObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(actObjIds);
        for (DynamicObject evalObj : evalObjs) {
            evalObjMap.put(evalObj.getLong("id"), evalObj);
        }
        for (EvalBatchBackDto evalBatchBackDto : evalBatchBackDtoList) {
            DynamicObject evalObj = (DynamicObject)evalObjMap.get(evalBatchBackDto.getEvalObjId());
            String errorMsg = this.validate(evalObj);
            if (HRStringUtils.isEmpty((String)errorMsg)) continue;
            errorMap.put(evalObj.getLong("id"), errorMsg);
        }
        EvalBatchBackResult evalBatchBackResult = this.buildEvalBatchBackResult(evalBatchBackDtoList, errorMap, true);
        log.info("confirm back validate end...,errorMap:" + errorMap);
        return evalBatchBackResult;
    }

    @Override
    public EvalBatchBackResult evalBatchBack(List<EvalBatchBackDto> evalBatchBackDtoList) {
        DynamicObject[] evalObjs;
        log.info("confirm back start..., evalBatchBackDtoList:" + evalBatchBackDtoList);
        if (CollectionUtils.isEmpty(evalBatchBackDtoList)) {
            return new EvalBatchBackResult();
        }
        ArrayList<Long> actObjIds = new ArrayList<Long>(10);
        for (EvalBatchBackDto evalBatchBackDto : evalBatchBackDtoList) {
            actObjIds.add(evalBatchBackDto.getEvalObjId());
        }
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        ArrayList<DynamicObject> updateEvalObjList = new ArrayList<DynamicObject>(10);
        ArrayList<Long> deleteRecordEvalObjIdList = new ArrayList<Long>(10);
        ArrayList<String> workflowBusinessIdList = new ArrayList<String>(10);
        HashMap<Long, DynamicObject> evalObjMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject evalObj : evalObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(actObjIds)) {
            evalObjMap.put(evalObj.getLong("id"), evalObj);
        }
        Long preAssessNodeId = this.getPreAssessNodeStatusEnum(evalObjs[0]);
        for (EvalBatchBackDto evalBatchBackDto : evalBatchBackDtoList) {
            DynamicObject evalObj;
            evalObj = (DynamicObject)evalObjMap.get(evalBatchBackDto.getEvalObjId());
            String errorMsg = this.validate(evalObj);
            if (!HRStringUtils.isEmpty((String)errorMsg)) {
                errorMap.put(evalObj.getLong("id"), errorMsg);
                continue;
            }
            String nodeStatus = evalObj.getString("nodestatus");
            updateEvalObjList.add(this.updateEvalObj(evalObj, preAssessNodeId));
            deleteRecordEvalObjIdList.add(evalObj.getLong("id"));
            if (!AssessNodeStatusEnum.CONFIRMING.getStatus().equals(nodeStatus)) continue;
            workflowBusinessIdList.add(String.valueOf(evalObj.getLong("id")));
        }
        boolean isSuccess = this.confirmBackHandle(updateEvalObjList, deleteRecordEvalObjIdList, workflowBusinessIdList, errorMap);
        EvalBatchBackResult evalBatchBackResult = this.buildEvalBatchBackResult(evalBatchBackDtoList, errorMap, isSuccess);
        log.info("confirm back end...,errorMap:" + errorMap + isSuccess);
        return evalBatchBackResult;
    }

    protected Long getPreAssessNodeStatusEnum(DynamicObject evalObj) {
        DynamicObjectCollection timeplanEntrys = evalObj.getDynamicObjectCollection("activity.timeplanentry");
        int index = 0;
        for (int i = 0; i < timeplanEntrys.size(); ++i) {
            DynamicObject timeplanEntry = (DynamicObject)timeplanEntrys.get(i);
            if (timeplanEntry.getDynamicObject("activity").getLong("id") != NodeTabMapEnum.RESULT_CONFIRM.getNodeId().longValue()) continue;
            index = i - 1;
        }
        DynamicObject preNode = (DynamicObject)timeplanEntrys.get(index);
        return preNode.getDynamicObject("activity").getLong("id");
    }

    protected String validate(DynamicObject evalObj) {
        String errorMsg = null;
        if (evalObj == null) {
            errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8bc4\u4f30\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"ActEvalObjConfirmBackDomainService_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        } else {
            DynamicObject assessNodeDyn = evalObj.getDynamicObject("assessnode");
            String nodeStatus = evalObj.getString("nodestatus");
            if (assessNodeDyn == null) {
                errorMsg = ResManager.loadKDString((String)"\u8003\u6838\u5b8c\u6210\u7684\u8bb0\u5f55\u4e0d\u652f\u6301\u9000\u56de\u64cd\u4f5c\u3002", (String)"ActEvalObjConfirmBackDomainService_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            } else if (assessNodeDyn.getLong("id") != NodeTabMapEnum.RESULT_CONFIRM.getNodeId().longValue()) {
                errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8bc4\u4f30\u8bb0\u5f55\u7684\u7ee9\u6548\u4e1a\u52a1\u6d3b\u52a8\u4e0d\u662f\u7ed3\u679c\u786e\u8ba4\u3002", (String)"ActEvalObjConfirmBackDomainService_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            } else if (HRStringUtils.isEmpty((String)nodeStatus)) {
                errorMsg = ResManager.loadKDString((String)"\u786e\u8ba4\u72b6\u6001\u4e3a\u7a7a\u7684\u4e0d\u652f\u6301\u9000\u56de\u64cd\u4f5c", (String)"ActEvalObjConfirmBackDomainService_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            } else if (HRStringUtils.equals((String)AssessNodeStatusEnum.CONFIRMED.getStatus(), (String)nodeStatus)) {
                errorMsg = ResManager.loadKDString((String)"\u786e\u8ba4\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210\u7684\u4e0d\u652f\u6301\u9000\u56de\u64cd\u4f5c", (String)"ActEvalObjConfirmBackDomainService_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            }
        }
        return errorMsg;
    }

    protected DynamicObject updateEvalObj(DynamicObject evalObj, Long preAssessNodeId) {
        evalObj.set("assessnode", (Object)preAssessNodeId);
        evalObj.set("nodeindex", (Object)(evalObj.getLong("nodeindex") - 1L));
        evalObj.set("nodestatus", (Object)AssessNodeStatusEnum.CONFIRMED.getStatus());
        Long fSopAssessNodeId = this.getFSopAssessNodeId(evalObj);
        if (fSopAssessNodeId != null) {
            NodeIdScoreEnum nodeIdScoreEnum = NodeIdScoreEnum.getEnumByNodeId((Long)fSopAssessNodeId);
            evalObj.set(AssessScoreAbbrEnum.FSOP.getCode(), evalObj.get(nodeIdScoreEnum.getScoreFieldName()));
            evalObj.set(AssessScoreAbbrEnum.FLOP.getCode(), evalObj.get(nodeIdScoreEnum.getLevelFieldName()));
            evalObj.set("fsopsource", evalObj.get(nodeIdScoreEnum.getSourceFieldName()));
        }
        evalObj.set(AssessScoreAbbrEnum.CFSOP.getCode(), null);
        evalObj.set(AssessScoreAbbrEnum.CFLOP.getCode(), null);
        evalObj.set("cfsopsource", null);
        evalObj.set("cfloplevel", null);
        evalObj.set("cfsopscoresystem", null);
        long userId = UserServiceHelper.getCurrentUserId();
        evalObj.set("modifier", (Object)userId);
        evalObj.set("modifytime", (Object)new Date());
        return evalObj;
    }

    private Long getFSopAssessNodeId(DynamicObject evalObj) {
        String cfsopsource = evalObj.getString("cfsopsource");
        if (HRStringUtils.isEmpty((String)cfsopsource)) {
            return null;
        }
        switch (cfsopsource) {
            case "sop": 
            case "soac": 
            case "msoac": {
                return AssessNodeStatusEnum.EVALUATED.getNodeId();
            }
            case "mpsop": {
                return AssessNodeStatusEnum.MPED.getNodeId();
            }
            case "csop": {
                return AssessNodeStatusEnum.CALIBRATED.getNodeId();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean confirmBackHandle(List<DynamicObject> updateEvalObjList, List<Long> deleteRecordEvalObjIdList, List<String> workflowBusinessIdList, Map<Long, String> errorMap) {
        boolean flag = true;
        if (CollectionUtils.isEmpty(updateEvalObjList)) {
            return flag;
        }
        try (TXHandle txHandle = TX.required();){
            EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject(updateEvalObjList.toArray(new DynamicObject[0]));
            ACTIVITY_RECORD_ENTITY.deleteRecordByEvalObjIdsAndNodeId(deleteRecordEvalObjIdList, NodeTabMapEnum.RESULT_CONFIRM.getNodeId());
        }
        this.workflowHandle(flag, workflowBusinessIdList, errorMap);
        return flag;
    }

    protected boolean workflowHandle(boolean flag, List<String> workflowBusinessIdList, Map<Long, String> errorMap) {
        if (flag) {
            for (String businessKey : workflowBusinessIdList) {
                try {
                    if (!WorkflowServiceHelper.inProcess((String)businessKey)) continue;
                    WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    errorMap.put(Long.parseLong(businessKey), ResManager.loadKDString((String)"\u7ed3\u679c\u786e\u8ba4\u91cd\u7f6e\u6210\u529f\uff0c\u4f46\u6d41\u7a0b\u7ec8\u6b62\u5931\u8d25\uff0c\u8bf7\u5230\u6d41\u7a0b\u670d\u52a1\u624b\u52a8\u7ec8\u6b62\uff0c\u672a\u7ec8\u6b62\u6d41\u7a0b\u4f1a\u5f71\u54cd\u540e\u7eed\u7ed3\u679c\u786e\u8ba4\u4e1a\u52a1\u3002", (String)"ActEvalObjConfirmBackDomainService_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    flag = false;
                }
            }
        }
        return flag;
    }

    protected EvalBatchBackResult buildEvalBatchBackResult(List<EvalBatchBackDto> evalBatchBackDtoList, Map<Long, String> errorMap, boolean isSuccess) {
        EvalBatchBackResult evalBatchBackResult = new EvalBatchBackResult();
        List<EvalBackInfoResult> failureBackInfoList = evalBatchBackResult.getFailureBackInfoList();
        List<EvalBackInfoResult> sucessBackInfoList = evalBatchBackResult.getSucessBackInfoList();
        for (EvalBatchBackDto evalBatchBackDto : evalBatchBackDtoList) {
            Long evalObjId = evalBatchBackDto.getEvalObjId();
            if (!HRStringUtils.isEmpty((String)errorMap.get(evalObjId))) {
                failureBackInfoList.add(new EvalBackInfoResult(evalObjId, errorMap.get(evalObjId)));
                continue;
            }
            if (!isSuccess) {
                failureBackInfoList.add(new EvalBackInfoResult(evalObjId, ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ActEvalObjConfirmBackDomainService_6", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
                continue;
            }
            sucessBackInfoList.add(new EvalBackInfoResult(evalObjId, ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"ActEvalObjConfirmBackDomainService_7", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        }
        evalBatchBackResult.setTotalCount(evalBatchBackDtoList.size());
        evalBatchBackResult.setSuccessCount(sucessBackInfoList.size());
        evalBatchBackResult.setFailureCount(failureBackInfoList.size());
        return evalBatchBackResult;
    }
}

