/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.evaloverall.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.Pair;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.application.service.dynpermission.DynPermissionConfigService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.EvalModeEnum;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.business.domain.assessrule.entityservice.AreaFieldEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.NormalConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.PlusMinusConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.SumConfigEntityService;
import kd.opmc.epa.business.domain.evaladjustment.entity.EvalAdjustmentEntityService;
import kd.opmc.epa.business.domain.evaloverall.entity.ProcessPermsettingEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAddSubNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjGenAreaRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjGenNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjProcessPermSettingEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjSumAreaRecordEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.ObjectScopeEntityService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.assessrule.EvalWayEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.common.enums.evaloverall.ProcPermContentEnum;
import kd.opmc.epa.common.enums.evaloverall.ProcPermScopeEnum;
import kd.opmc.epa.common.vo.dynpermission.ContentAreaEntry;
import kd.opmc.epa.common.vo.dynpermission.ContentFieldEntry;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.epa.common.vo.dynpermission.ScopeAreaEntry;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.ScoreSystemEntityService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.BatchTaskmapEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;
import kd.opmc.pbs.business.model.NodeRoleConfigBo;
import kd.opmc.pbs.common.enums.FieldTypeEnum;
import kd.opmc.pmd.business.domain.perffile.entityservice.PerffileEntityService;

public class ActEvalObjOverallDomainService {
    private static final Log LOG = LogFactory.getLog(ActEvalObjOverallDomainService.class);
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RUSECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUN_SUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE = ActivityEvaluationObjectEntityService.getInstance();
    private static final BatchTaskmapEntityService BATCH_TASKMAP_ENTITY_SERVICE = BatchTaskmapEntityService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY = ExecuteSchemeEntityService.getInstance();
    private static final AssessFormDomainService ASSESS_FORM_DOMAIN_SERVICE = AssessFormDomainService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final SumConfigEntityService SUM_CONFIG_ENTITY_SERVICE = SumConfigEntityService.getInstance();
    private static final ObjNodeResEntityService OBJ_NODE_RES_ENTITY_SERVICE = ObjNodeResEntityService.getInstance();
    private static final AssessActivityEntityService ASSESS_ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY = PerfLevelEntityService.getInstance();
    private static final ObjSumAreaRecordEntityService OBJ_SUM_AREA_RECORD_ENTITY_SERVICE = ObjSumAreaRecordEntityService.getInstance();
    private static final ObjectScopeEntityService OBJECT_SCOPE_ENTITY_SERVICE = ObjectScopeEntityService.getInstance();
    private static final FlowDefRoleEntityService FLOW_DEF_ROLE_ENTITY = FlowDefRoleEntityService.getInstance();
    private static final PerffileEntityService PERFFILE_ENTITY_SERVICE = PerffileEntityService.getInstance();
    private static final ScoreSystemEntityService SCORE_SYSTEM_ENTITY = ScoreSystemEntityService.getInstance();
    private static final ProcessPermsettingEntityService PROCESS_PERMSETTING_ENTITY_SERVICE = ProcessPermsettingEntityService.getInstance();
    private static final EvalAdjustmentEntityService EVAL_ADJUSTMENT_ENTITY_SERVICE = EvalAdjustmentEntityService.getInstance();
    private static final ObjGenAreaInsEntityService OBJ_GEN_AREA_INS_ENTITY_SERVICE = ObjGenAreaInsEntityService.getInstance();
    private static final ObjAddSubAreaInsEntityService OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE = ObjAddSubAreaInsEntityService.getInstance();
    private static final NormalConfigEntityService NORMAL_CONFIG_ENTITY_SERVICE = NormalConfigEntityService.getInstance();
    private static final PlusMinusConfigEntityService PLUS_MINUS_CONFIG_ENTITY_SERVICE = PlusMinusConfigEntityService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final ObjAddSubNodeResEntityService OBJ_ADD_SUB_NODE_RES_ENTITY_SERVICE = ObjAddSubNodeResEntityService.getInstance();
    private static final ObjGenNodeResEntityService OBJ_GEN_NODE_RES_ENTITY_SERVICE = ObjGenNodeResEntityService.getInstance();
    private static final ObjGenAreaIndicatorEntityService OBJ_GEN_AREA_INDICATOR_ENTITY_SERVICE = ObjGenAreaIndicatorEntityService.getInstance();
    private static final ObjAddSubAreaIndicatorEntityService OBJ_ADD_SUB_AREA_INDICATOR_ENTITY_SERVICE = ObjAddSubAreaIndicatorEntityService.getInstance();
    private static final ObjProcessPermSettingEntityService PROCESS_PERM_SETTING_ENTITY_SERVICE = ObjProcessPermSettingEntityService.getInstance();
    private static final ObjGenAreaRecordEntityService GEN_AREA_RECORD_ENTITY = ObjGenAreaRecordEntityService.getInstance();
    private static final AreaFieldEntityService AREA_FIELD_ENTITY_SERVICE = AreaFieldEntityService.getInstance();
    private static final IHRPIPersonService PERSON_SERVICE = IHRPIPersonService.getInstance();

    public static ActEvalObjOverallDomainService getInstance() {
        return ServiceFactory.getService(ActEvalObjOverallDomainService.class);
    }

    public List<Map<String, Object>> querySumConf(Long taskId) {
        Set<Long> areaFieldIdSet;
        QFilter filter;
        DynamicObject[] fieldArr;
        ArrayList<Map<String, Object>> sumFieldsList = new ArrayList<Map<String, Object>>(10);
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowrunode", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, processpermsetting, dynamicpermission", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("evalway, numaccuracy, sumconf, sumperflevel ", new QFilter[]{assessFormFilter});
        Long sumConfIdId = assessFormObj.getLong("sumconf");
        DynamicObject sumConfObj = SUM_CONFIG_ENTITY_SERVICE.queryOne(sumConfIdId);
        DynamicObjectCollection filedEntry = sumConfObj.getDynamicObjectCollection("entryentity");
        Map fieldMap = filedEntry.stream().collect(Collectors.toMap(filedInfo -> filedInfo.getDynamicObject("areafield").getString("number"), Function.identity()));
        HashMap<String, Object> oseField = new HashMap<String, Object>(16);
        int numaccuracy = assessFormObj.getInt("numaccuracy");
        EvalWayEnum evalWay = EvalWayEnum.getEvalWay((String)assessFormObj.getString("evalway"));
        QFilter flowrunodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject flowrunodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{flowrunodeFilter});
        long newProcPermId = activityObj.getLong("dynamicpermission.id");
        long flowNodeDefId = flowrunodeObj.getLong("flownodedef.id");
        Map<Long, Map<String, Boolean>> areaFieldPermMap = this.getAreaFieldPermMap(sumConfIdId, newProcPermId, flowNodeDefId);
        HashMap<String, Map<String, Boolean>> procPermMap = new HashMap<String, Map<String, Boolean>>(16);
        if (areaFieldPermMap != null && (fieldArr = AREA_FIELD_ENTITY_SERVICE.queryOriginalArray("id,number", new QFilter[]{filter = new QFilter("id", "in", areaFieldIdSet = areaFieldPermMap.keySet())})) != null) {
            block10: for (DynamicObject fieldDy : fieldArr) {
                if (fieldDy == null) continue;
                String number = fieldDy.getString("number");
                long areaFieldId = fieldDy.getLong("id");
                Map<String, Boolean> permMap = areaFieldPermMap.get(areaFieldId);
                switch (number) {
                    case "ose": {
                        procPermMap.put("ose", permMap);
                        continue block10;
                    }
                    case "ole": {
                        procPermMap.put("ole", permMap);
                        continue block10;
                    }
                    case "eval": {
                        procPermMap.put("eval", permMap);
                        continue block10;
                    }
                }
            }
        }
        if (!procPermMap.isEmpty()) {
            Map evalRowObj;
            Map oleRowObj;
            Map oseRowObj = (Map)procPermMap.get("ose");
            if (oseRowObj != null) {
                Boolean fielddisplayitem = (Boolean)oseRowObj.get("fielddisplayitem");
                Boolean fieldmustinputitem = (Boolean)oseRowObj.get("fieldmustinputitem");
                Boolean fieldmodifyitem = (Boolean)oseRowObj.get("fieldmodifyitem");
                if (fielddisplayitem.booleanValue()) {
                    oseField.put("id", "ose");
                    oseField.put("name", ((DynamicObject)fieldMap.get("ose")).getString("fieldcustname"));
                    oseField.put("key", "ose");
                    oseField.put("proptype", FieldTypeEnum.Decimal);
                    oseField.put("precision", numaccuracy + 13);
                    oseField.put("mustinput", fieldmustinputitem);
                    oseField.put("visible", fielddisplayitem);
                    oseField.put("lock", fieldmodifyitem == false);
                    oseField.put("scale", numaccuracy);
                    oseField.put("maxlength", ((DynamicObject)fieldMap.get("ose")).getDynamicObject("areafield").getInt("max"));
                    oseField.put("minlength", ((DynamicObject)fieldMap.get("ose")).getDynamicObject("areafield").getInt("min"));
                    sumFieldsList.add(oseField);
                }
            }
            if ((oleRowObj = (Map)procPermMap.get("ole")) != null) {
                DynamicObject oleObj;
                Boolean fielddisplayitem = (Boolean)oleRowObj.get("fielddisplayitem");
                Boolean fieldmustinputitem = (Boolean)oleRowObj.get("fieldmustinputitem");
                Boolean fieldmodifyitem = (Boolean)oleRowObj.get("fieldmodifyitem");
                if (fielddisplayitem.booleanValue() && (oleObj = (DynamicObject)fieldMap.get("ole")) != null) {
                    HashMap<String, Object> oleField = new HashMap<String, Object>(16);
                    oleField.put("id", "ole");
                    oleField.put("name", ((DynamicObject)fieldMap.get("ole")).getString("fieldcustname"));
                    oleField.put("key", "ole");
                    oleField.put("proptype", FieldTypeEnum.Combo);
                    Long perfLevelId = assessFormObj.getLong("sumperflevel.id");
                    List<kd.bos.metadata.entity.commonfield.ComboItem> levelComboItem = this.queryPerfLevelByAssessForm(perfLevelId);
                    oleField.put("comboitem", levelComboItem);
                    oleField.put("mustinput", fieldmustinputitem);
                    oleField.put("visible", fielddisplayitem);
                    oleField.put("lock", fieldmodifyitem == false);
                    sumFieldsList.add(oleField);
                }
            }
            if ((evalRowObj = (Map)procPermMap.get("eval")) != null) {
                Boolean fielddisplayitem = (Boolean)evalRowObj.get("fielddisplayitem");
                Boolean fieldmustinputitem = (Boolean)evalRowObj.get("fieldmustinputitem");
                Boolean fieldmodifyitem = (Boolean)evalRowObj.get("fieldmodifyitem");
                if (fielddisplayitem.booleanValue()) {
                    HashMap<String, Object> evalField = new HashMap<String, Object>(16);
                    evalField.put("id", "eval");
                    evalField.put("name", ((DynamicObject)fieldMap.get("eval")).getString("fieldcustname"));
                    evalField.put("key", "eval");
                    evalField.put("proptype", FieldTypeEnum.LargeTextProp);
                    evalField.put("mustinput", fieldmustinputitem);
                    evalField.put("visible", fielddisplayitem);
                    evalField.put("lock", fieldmodifyitem == false);
                    evalField.put("maxlength", ((DynamicObject)fieldMap.get("eval")).getDynamicObject("areafield").getInt("max"));
                    evalField.put("minlength", ((DynamicObject)fieldMap.get("eval")).getDynamicObject("areafield").getInt("min"));
                    sumFieldsList.add(evalField);
                }
            }
        }
        return sumFieldsList;
    }

    private List<kd.bos.metadata.entity.commonfield.ComboItem> queryPerfLevelByAssessForm(Long perfLevelId) {
        ArrayList<kd.bos.metadata.entity.commonfield.ComboItem> comboItems = new ArrayList<kd.bos.metadata.entity.commonfield.ComboItem>(10);
        if (perfLevelId == 0L) {
            return comboItems;
        }
        DynamicObject perfLevelDy = PERF_LEVEL_ENTITY.queryOne((Object)perfLevelId);
        DynamicObjectCollection levelConf = perfLevelDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject level : levelConf) {
            kd.bos.metadata.entity.commonfield.ComboItem comboItem = new kd.bos.metadata.entity.commonfield.ComboItem();
            comboItem.setCaption(new LocaleString(level.getString("levelname")));
            comboItem.setValue(level.getString("seq"));
            comboItems.add(comboItem);
        }
        return comboItems;
    }

    public List<Map<String, Object>> queryEvalObjNodes(List<Map<String, Object>> taskList) {
        Map.Entry<Long, List<DynamicObject>> firstEntry;
        Iterator<Map.Entry<Long, List<DynamicObject>>> iterator;
        Set<Map.Entry<Long, List<DynamicObject>>> groupEntrySet;
        List scopeAreaEntries;
        Map scopeAreaEntriesMap;
        ArrayList<Map<String, Object>> nodeFieldsList = new ArrayList<Map<String, Object>>(10);
        List taskIdList = taskList.stream().map(obj -> (Long)obj.get("taskId")).collect(Collectors.toList());
        QFilter taskFilter = new QFilter("id", "in", taskIdList);
        DynamicObject[] flowruTaskObjs = FLOW_RU_TASK_ENTITY_SERVICE.query("activity, flowruproc, flowrunode, flowrunode.index, flowrunode.flownodedef.id", new QFilter[]{taskFilter});
        List nodeList = Arrays.stream(flowruTaskObjs).map(obj -> obj.getLong("flowrunode.id")).collect(Collectors.toList());
        Set flowruprocIds = Arrays.asList(flowruTaskObjs).stream().map(obj -> obj.getLong("flowruproc.id")).collect(Collectors.toSet());
        DynamicObject flowruTaskObj = flowruTaskObjs[0];
        int flowrunodeIndex = flowruTaskObj.getInt("flowrunode.index");
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, processpermsetting ,dynamicpermission", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("evalway, numaccuracy, sumconf, sumperflevel ", new QFilter[]{assessFormFilter});
        Long sumConfIdId = assessFormObj.getLong("sumconf");
        DynamicObject sumConfObj = SUM_CONFIG_ENTITY_SERVICE.queryOne(sumConfIdId);
        DynamicObjectCollection filedEntry = sumConfObj.getDynamicObjectCollection("entryentity");
        Map fieldMap = filedEntry.stream().collect(Collectors.toMap(filedInfo -> filedInfo.getDynamicObject("areafield").getString("number"), Function.identity()));
        int numaccuracy = assessFormObj.getInt("numaccuracy");
        int maxLength = ((DynamicObject)fieldMap.get("ose")).getDynamicObject("areafield").getInt("max");
        int minLength = ((DynamicObject)fieldMap.get("ose")).getDynamicObject("areafield").getInt("min");
        QFilter ndrFilter = new QFilter("flowruproc", "in", flowruprocIds);
        DynamicObject[] ndrRes = OBJ_NODE_RES_ENTITY_SERVICE.query("flowruproc, flowrunode", new QFilter[]{ndrFilter});
        Set flowrunodes = Arrays.stream(ndrRes).map(obj -> obj.getLong("flowrunode")).collect(Collectors.toSet());
        QFilter ruNodeFilter = new QFilter("flowruproc", "in", flowruprocIds);
        ruNodeFilter.and(new QFilter("id", "in", flowrunodes));
        DynamicObject[] flowrunodeArr = FLOW_RU_NODE_ENTITY_SERVICE.query("name, flowruproc, flownodedef, index, iscrossnode", new QFilter[]{ruNodeFilter}, "index asc");
        Map<Long, List<DynamicObject>> groupByProcSumObjs = Arrays.stream(flowrunodeArr).collect(Collectors.groupingBy(obj -> obj.getLong("flowruproc.id")));
        int maxIndex = Integer.MAX_VALUE;
        for (Map.Entry<Long, List<DynamicObject>> groupByProcSumObj : groupByProcSumObjs.entrySet()) {
            List indexList;
            Optional maxIndexOptional;
            List<DynamicObject> sumObjList = groupByProcSumObj.getValue();
            if (sumObjList == null || sumObjList.isEmpty() || !(maxIndexOptional = (indexList = sumObjList.stream().map(obj -> obj.getInt("index")).collect(Collectors.toList())).stream().max(Integer::compareTo)).isPresent()) continue;
            maxIndex = Math.min(maxIndex, (Integer)maxIndexOptional.get());
        }
        long newProcPermId = activityObj.getLong("dynamicpermission.id");
        long flowNodeDefId = flowruTaskObj.getLong("flowrunode.flownodedef.id");
        DynPermissionConfigService dynPermissionConfigService = new DynPermissionConfigService();
        DynamicPermissionConfigVO dynamicPermissions = dynPermissionConfigService.getDynamicPermissions(newProcPermId, Collections.singletonList(flowNodeDefId));
        boolean onlySelfNode = false;
        if (dynamicPermissions != null && (scopeAreaEntriesMap = dynamicPermissions.getScopeAreaEntriesMap()) != null && CollectionUtils.isNotEmpty((Collection)(scopeAreaEntries = (List)scopeAreaEntriesMap.get(flowNodeDefId)))) {
            Map<Long, String> scoreContentIdNumberMap = this.queryIdNumberMap("epa_scorecontent");
            Map<Long, String> scoreShowAreaIdNumberMap = this.queryIdNumberMap("epa_scoreshowarea");
            for (ScopeAreaEntry scopeAreaEntry : scopeAreaEntries) {
                Long scoreContentId = scopeAreaEntry.getScoreContentId();
                Long scoreShowAreaId = scopeAreaEntry.getScoreShowAreaId();
                String contentNumber = scoreContentIdNumberMap.get(scoreContentId);
                if (!HRStringUtils.equals((String)contentNumber, (String)ProcPermContentEnum.SUM.getCode())) continue;
                String showareaNumber = scoreShowAreaIdNumberMap.get(scoreShowAreaId);
                ProcPermScopeEnum procPermScope = ProcPermScopeEnum.get((String)showareaNumber);
                switch (procPermScope) {
                    case SHOW_SELF: {
                        maxIndex = 0;
                        break;
                    }
                    case SHOW_SELFNODE: {
                        onlySelfNode = true;
                        maxIndex = maxIndex >= flowrunodeIndex ? 1 : 0;
                        break;
                    }
                    case SHOW_SELFANDPRE: {
                        maxIndex = maxIndex >= flowrunodeIndex ? flowrunodeIndex - 1 : maxIndex;
                        break;
                    }
                    case SHOW_PRE: {
                        maxIndex = Math.min(maxIndex, flowrunodeIndex);
                        break;
                    }
                    case SHOW_ALL: {
                        break;
                    }
                }
                break;
            }
        }
        if (!(groupEntrySet = groupByProcSumObjs.entrySet()).isEmpty() && (iterator = groupEntrySet.iterator()).hasNext() && (firstEntry = iterator.next()) != null) {
            List<DynamicObject> flowrunodeList = firstEntry.getValue();
            maxIndex = Math.min(maxIndex, flowrunodeList.size());
            for (int i = 0; i < maxIndex; ++i) {
                DynamicObject flowrunode = flowrunodeList.get(i);
                if (onlySelfNode) {
                    Optional<DynamicObject> selfNodeOptional = flowrunodeList.stream().filter(obj -> nodeList.contains(obj.getLong("id"))).findFirst();
                    if (!selfNodeOptional.isPresent()) continue;
                    flowrunode = selfNodeOptional.get();
                }
                HashMap<String, Object> nodeField = new HashMap<String, Object>(16);
                int nodeKey = i + 1;
                String fieldKey = "node" + nodeKey;
                nodeField.put("id", fieldKey);
                nodeField.put("name", ResManager.loadKDString((String)"{0}\u5f97\u5206", (String)"ActEvalObjOverallDomainService_0", (String)"opmc-epa-business", (Object[])new Object[]{flowrunode.getString("name")}));
                nodeField.put("key", fieldKey);
                nodeField.put("proptype", FieldTypeEnum.Decimal);
                nodeField.put("mustinput", Boolean.FALSE);
                nodeField.put("visible", Boolean.TRUE);
                nodeField.put("scale", numaccuracy);
                nodeField.put("lock", Boolean.TRUE);
                nodeField.put("maxlength", maxLength);
                nodeField.put("minlength", minLength);
                nodeFieldsList.add(nodeField);
            }
        }
        return nodeFieldsList;
    }

    private Map<Long, String> queryIdNumberMap(String entityNumber) {
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>(16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        DynamicObjectCollection dyCollection = serviceHelper.queryOriginalCollection("id, number", new QFilter[0]);
        for (DynamicObject dy : dyCollection) {
            idNumberMap.put(dy.getLong("id"), dy.getString("number"));
        }
        return idNumberMap;
    }

    public DynamicObject queryFlowRuProcByTaskId(Object taskId) {
        QFilter taskFilter = new QFilter("id", "=", taskId);
        DynamicObject taskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("flowruproc", new QFilter[]{taskFilter});
        QFilter flowruprocFilter = new QFilter("id", "=", (Object)taskObj.getLong("flowruproc.id"));
        return FLOW_RU_PROC_ENTITY_SERVICE.queryOne(new QFilter[]{flowruprocFilter});
    }

    public DynamicObject[] queryEvalObjById(List<Long> actEvalObjIdList) {
        QFilter actEvalObjFilter = new QFilter("id", "in", actEvalObjIdList);
        return ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.query("perffile, perffile.name, perffile.billno, perffile.adminorg, perffile.position, affiliateadminorg, person.id, person.number, empposrel, empposrel.position, empposrel.job", new QFilter[]{actEvalObjFilter});
    }

    public DynamicObject[] queryEvalObjSumRecordByTaskId(List<Long> taskIdList) {
        QFilter sumRecordFilter = new QFilter("flowrutask", "in", taskIdList);
        return OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.query("actevalobj, ose, ole, eval, flowrutask, modifytime", new QFilter[]{sumRecordFilter}, "flowrutask.taskstatus asc");
    }

    public DynamicObject[] querySumRecordByActEvalObjId(Long actEvalObjId) {
        QFilter sumRecordFilter = new QFilter("actevalobj", "=", (Object)actEvalObjId);
        QFilter taskStatus = new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        return OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.query("actevalobj, ose, ole, eval, flowrutask, flowrutask.taskstatus, flowrutask.handler, flowrunode.iscrossnode", new QFilter[]{sumRecordFilter, taskStatus}, "modifytime desc");
    }

    public DynamicObject[] queryTaskById(List<Long> taskIdList) {
        QFilter taskFilter = new QFilter("id", "in", taskIdList);
        return FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalArray("id, flowruproc.id, flowrunode.id, flowrunode.index, flowrunode.iscrossnode, flowrunode.name, flowrunode.nodeweight, flowrunode.flownodedef.id, flowrurole.id, flowrurole.name, flowrurole.turnoversort, taskstatus, handler.id, handler.picturefield, handler.name, activity, isrollbacked", new QFilter[]{taskFilter}, "flowrunode.index desc");
    }

    public DynamicObject queryActivityByTaskId(Long taskId) {
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)taskObj.getLong("activity"));
        return ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("name, period, scheme, executescheme, executescheme.assessscope", new QFilter[]{activityFilter});
    }

    public void saveSumRecord(DynamicObjectCollection dyObjs) {
        ArrayList<DynamicObject> sumareainsList = new ArrayList<DynamicObject>(10);
        List<Long> taskIdList = dyObjs.stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        this.resetRollBackedMark(taskIdList);
        Map taskDyObjMap = dyObjs.stream().collect(Collectors.toMap(x -> x.getLong("flowrutask.id"), Function.identity()));
        QFilter sumareaFilter = new QFilter("flowrutask", "in", taskIdList);
        DynamicObject[] sumareainsObjs = OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.query("ose, ole, eval, actevalobj, assessyear, assessperiod, activity, perforg, flowrutask, flowruproc, flowrunode, flowrurole, creator, createtime, modifier, modifytime", new QFilter[]{sumareaFilter});
        List existObjTaskIdList = Arrays.asList(sumareainsObjs).stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        Long userId = UserServiceHelper.getCurrentUserId();
        for (DynamicObject sumareainsObj : sumareainsObjs) {
            Long taskId = sumareainsObj.getLong("flowrutask.id");
            DynamicObject sumObj = (DynamicObject)taskDyObjMap.get(taskId);
            sumareainsObj.set("ose", (Object)sumObj.getBigDecimal("ose"));
            sumareainsObj.set("ole", (Object)sumObj.getString("ole"));
            sumareainsObj.set("eval", (Object)sumObj.getString("eval"));
            sumareainsObj.set("modifier", (Object)userId);
            sumareainsObj.set("modifytime", (Object)new Date());
        }
        if (sumareainsObjs.length > 0) {
            OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.save(sumareainsObjs);
        }
        for (DynamicObject dyObj : dyObjs) {
            Long taskId = dyObj.getLong("flowrutask.id");
            if (existObjTaskIdList.contains(taskId)) continue;
            Long rowareainsId = DBServiceHelper.genLongIds((String)"epa_evalsumareains", (int)1)[0];
            DynamicObject sumareainsObj = OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.generateEmptyDynamicObject();
            sumareainsObj.set("id", (Object)rowareainsId);
            DynamicObject taskObj = dyObj.getDynamicObject("flowrutask");
            DynamicObject actEvalObj = dyObj.getDynamicObject("actevalobj");
            sumareainsObj.set("ose", (Object)dyObj.getBigDecimal("ose"));
            sumareainsObj.set("ole", (Object)dyObj.getString("ole"));
            sumareainsObj.set("eval", (Object)dyObj.getString("eval"));
            sumareainsObj.set("actevalobj", (Object)actEvalObj.getLong("id"));
            sumareainsObj.set("assessyear", (Object)actEvalObj.getInt("assessyear"));
            sumareainsObj.set("assessperiod", (Object)actEvalObj.getString("assessperiod"));
            sumareainsObj.set("activity", (Object)actEvalObj.getLong("activity.id"));
            sumareainsObj.set("perforg", (Object)actEvalObj.getLong("perforg.id"));
            sumareainsObj.set("flowrutask", (Object)taskObj.getLong("id"));
            sumareainsObj.set("flowruproc", (Object)taskObj.getLong("flowruproc.id"));
            sumareainsObj.set("flowrunode", (Object)taskObj.getLong("flowrunode.id"));
            sumareainsObj.set("flowrurole", (Object)taskObj.getLong("flowrurole.id"));
            sumareainsObj.set("creator", (Object)userId);
            sumareainsObj.set("createtime", (Object)new Date());
            sumareainsObj.set("modifier", (Object)userId);
            sumareainsObj.set("modifytime", (Object)new Date());
            sumareainsList.add(sumareainsObj);
        }
        OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.save(sumareainsList.toArray(new DynamicObject[sumareainsList.size()]));
    }

    public boolean resetRollBackedMark(List<Long> taskIdList) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.resetRollBackedMark(taskIdList);
    }

    public Map<Long, Boolean> submitTask(List<Long> taskIdList) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.submitTask(taskIdList);
    }

    public FlowValidateResultBo rejectTask(List<Long> taskIdList, String reason) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.batchRollbackTasks(taskIdList, reason);
    }

    public Map<Long, List<BigDecimal>> queryObjNodeResRecordByTaskIdList(List<Long> taskIdList) {
        Long flowruprocId;
        List scopeAreaEntries;
        Map scopeAreaEntriesMap;
        QFilter taskInfoFilter = new QFilter("id", "in", taskIdList);
        DynamicObject[] taskInfoObjs = FLOW_RU_TASK_ENTITY_SERVICE.query("activity, flowruproc, flowrunode, flowrunode.index, flowrunode.flownodedef.id", new QFilter[]{taskInfoFilter});
        List currFlowrunodeIdList = Arrays.stream(taskInfoObjs).map(obj -> obj.getLong("flowrunode.id")).collect(Collectors.toList());
        Set flowruprocIds = Arrays.asList(taskInfoObjs).stream().map(obj -> obj.getLong("flowruproc.id")).collect(Collectors.toSet());
        QFilter ndrFilter = new QFilter("flowruproc", "in", flowruprocIds);
        DynamicObject[] ndrRes = OBJ_NODE_RES_ENTITY_SERVICE.query("actevalobj, flowruproc, flowrunode, sont", new QFilter[]{ndrFilter});
        Set flowrunodes = Arrays.stream(ndrRes).map(obj -> obj.getLong("flowrunode")).collect(Collectors.toSet());
        QFilter ruNodeFilter = new QFilter("flowruproc", "in", flowruprocIds);
        ruNodeFilter.and(new QFilter("id", "in", flowrunodes));
        DynamicObject[] flowrunodeArr = FLOW_RU_NODE_ENTITY_SERVICE.query("name, flowruproc, flownodedef, index", new QFilter[]{ruNodeFilter}, "index asc");
        Map<Long, List<DynamicObject>> groupByProcSumObjs = Arrays.stream(flowrunodeArr).collect(Collectors.groupingBy(obj -> obj.getLong("flowruproc.id")));
        int maxIndex = Integer.MAX_VALUE;
        for (Map.Entry<Long, List<DynamicObject>> groupByProcSumObj : groupByProcSumObjs.entrySet()) {
            List indexList;
            Optional maxIndexOptional;
            List<DynamicObject> sumObjList = groupByProcSumObj.getValue();
            if (sumObjList == null || sumObjList.isEmpty() || !(maxIndexOptional = (indexList = sumObjList.stream().map(obj -> obj.getInt("index")).collect(Collectors.toList())).stream().max(Integer::compareTo)).isPresent()) continue;
            maxIndex = Math.min(maxIndex, (Integer)maxIndexOptional.get());
        }
        DynamicObject flowruTaskObj = taskInfoObjs[0];
        int flowrunodeIndex = flowruTaskObj.getInt("flowrunode.index");
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, processpermsetting ,dynamicpermission", new QFilter[]{activityFilter});
        long newProcPermId = activityObj.getLong("dynamicpermission.id");
        long flowNodeDefId = flowruTaskObj.getLong("flowrunode.flownodedef.id");
        DynPermissionConfigService dynPermissionConfigService = new DynPermissionConfigService();
        DynamicPermissionConfigVO dynamicPermissions = dynPermissionConfigService.getDynamicPermissions(newProcPermId, Collections.singletonList(flowNodeDefId));
        boolean onlySelfNode = false;
        if (dynamicPermissions != null && (scopeAreaEntriesMap = dynamicPermissions.getScopeAreaEntriesMap()) != null && CollectionUtils.isNotEmpty((Collection)(scopeAreaEntries = (List)scopeAreaEntriesMap.get(flowNodeDefId)))) {
            Map<Long, String> scoreContentIdNumberMap = this.queryIdNumberMap("epa_scorecontent");
            Map<Long, String> scoreShowAreaIdNumberMap = this.queryIdNumberMap("epa_scoreshowarea");
            for (ScopeAreaEntry scopeAreaEntry : scopeAreaEntries) {
                Long scoreContentId = scopeAreaEntry.getScoreContentId();
                Long scoreShowAreaId = scopeAreaEntry.getScoreShowAreaId();
                String contentNumber = scoreContentIdNumberMap.get(scoreContentId);
                if (!HRStringUtils.equals((String)contentNumber, (String)ProcPermContentEnum.SUM.getCode())) continue;
                String showareaNumber = scoreShowAreaIdNumberMap.get(scoreShowAreaId);
                ProcPermScopeEnum procPermScope = ProcPermScopeEnum.get((String)showareaNumber);
                switch (procPermScope) {
                    case SHOW_SELF: {
                        maxIndex = 0;
                        break;
                    }
                    case SHOW_SELFNODE: {
                        onlySelfNode = true;
                        maxIndex = maxIndex >= flowrunodeIndex ? 1 : 0;
                        break;
                    }
                    case SHOW_SELFANDPRE: {
                        maxIndex = maxIndex >= flowrunodeIndex ? flowrunodeIndex - 1 : maxIndex;
                        break;
                    }
                    case SHOW_PRE: {
                        maxIndex = Math.min(maxIndex, flowrunodeIndex);
                        break;
                    }
                    case SHOW_ALL: {
                        break;
                    }
                }
                break;
            }
        }
        List flowruprocIdList = Arrays.asList(taskInfoObjs).stream().map(task -> task.getLong("flowruproc.id")).collect(Collectors.toList());
        QFilter flowruprocFilter = new QFilter("flowruproc", "in", flowruprocIdList);
        DataSet nodeInfoSet = FLOW_RU_NODE_ENTITY_SERVICE.queryDataSet("pbs_flowrunode", "id, flowruproc, index", new QFilter[]{flowruprocFilter}, "index asc");
        HashMap<Long, ArrayList<Long>> flowruprocMap = new HashMap<Long, ArrayList<Long>>(10);
        for (Row row : nodeInfoSet) {
            Long flowruprocId2 = row.getLong("flowruproc");
            Long flowrunodeId = row.getLong("id");
            ArrayList<Long> flowrunodeList = (ArrayList<Long>)flowruprocMap.get(flowruprocId2);
            if (flowrunodeList == null) {
                flowrunodeList = new ArrayList<Long>(10);
            }
            flowrunodeList.add(flowrunodeId);
            flowruprocMap.put(flowruprocId2, flowrunodeList);
        }
        nodeInfoSet.close();
        HashMap<Long, HashMap<Long, BigDecimal>> ndrMap = new HashMap<Long, HashMap<Long, BigDecimal>>(16);
        maxIndex = Math.min(ndrRes.length, maxIndex);
        if (ndrRes != null && ndrRes.length > 0) {
            for (int i = 0; i < ndrRes.length; ++i) {
                DynamicObject ndrObj = ndrRes[i];
                Long actevalobjId = ndrObj.getLong("actevalobj");
                flowruprocId = ndrObj.getLong("flowruproc");
                Long flowrunodeId = ndrObj.getLong("flowrunode");
                BigDecimal sont = ndrObj.getBigDecimal("sont");
                HashMap<Long, BigDecimal> flowrunodeMap = (HashMap<Long, BigDecimal>)ndrMap.get(flowruprocId);
                if (flowrunodeMap == null) {
                    flowrunodeMap = new HashMap<Long, BigDecimal>(16);
                }
                if (onlySelfNode) {
                    if (!currFlowrunodeIdList.contains(flowrunodeId)) continue;
                    flowrunodeMap.put(flowrunodeId, sont);
                    ndrMap.put(flowruprocId, flowrunodeMap);
                    continue;
                }
                flowrunodeMap.put(flowrunodeId, sont);
                ndrMap.put(flowruprocId, flowrunodeMap);
            }
        }
        HashMap<Long, List<BigDecimal>> newNdrMap = new HashMap<Long, List<BigDecimal>>(16);
        for (Map.Entry flowruprocInfo : flowruprocMap.entrySet()) {
            flowruprocId = (Long)flowruprocInfo.getKey();
            List flowrunodeList = (List)flowruprocInfo.getValue();
            ArrayList<BigDecimal> flowrunodeNdrList = new ArrayList<BigDecimal>(10);
            Map ndrFlowRunodeMap = (Map)ndrMap.get(flowruprocId);
            for (Long flowrunodeId : flowrunodeList) {
                BigDecimal sont;
                if (ndrFlowRunodeMap == null || (sont = (BigDecimal)ndrFlowRunodeMap.get(flowrunodeId)) == null || flowrunodeNdrList.size() >= maxIndex) continue;
                flowrunodeNdrList.add(sont);
            }
            newNdrMap.put(flowruprocId, flowrunodeNdrList);
        }
        return newNdrMap;
    }

    public DynamicObject[] queryPerffileById(List<Long> perffilesIdList) {
        QFilter perffileFilter = new QFilter("id", "in", perffilesIdList);
        return PERFFILE_ENTITY_SERVICE.query("adminorg, adminorg.sortcode, position, position.index, depemp, depemp.person", new QFilter[]{perffileFilter});
    }

    public DynamicObject queryAssessFormByTaskId(Long taskId) {
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        return ASSESS_FORM_ENTITY_SERVICE.queryOne("scaletype, allowexceedupper, allowexceedlower, limitmaxscore, limitminscore, scoresystem, evalway, numaccuracy, sumconf, sumperflevel ", new QFilter[]{assessFormFilter});
    }

    public List<ComboItem> queryPerfLevelItemByRule(Long perfLevelId) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        if (perfLevelId == 0L) {
            return comboItems;
        }
        DynamicObject perfLevelDy = PERF_LEVEL_ENTITY.queryOne((Object)perfLevelId);
        DynamicObjectCollection levelConf = perfLevelDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject level : levelConf) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(level.getString("levelname")));
            comboItem.setValue(level.getString("seq"));
            comboItems.add(comboItem);
        }
        return comboItems;
    }

    public DynamicObject queryTaskInfoById(Long taskId) {
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        return FLOW_RU_TASK_ENTITY_SERVICE.queryOne("taskstatus, handler, flowrunode, flowrunode.name, flowrunode.nodeweight, flowrunode.iscrossnode,flowrurole, flowrurole.name", new QFilter[]{taskFilter});
    }

    public NodeRoleConfigBo queryNodeRoleConfigByTask(Long taskId) {
        if (null == taskId || taskId == 0L) {
            return null;
        }
        DynamicObject taskDy = this.queryTaskInfoById(taskId);
        long flowDefRoleId = taskDy.getLong("flowrurole.flowdefrole.id");
        DynamicObject flowDefRole = FLOW_DEF_ROLE_ENTITY.queryOne((Object)flowDefRoleId);
        String confJson = flowDefRole.getString("confjson");
        return (NodeRoleConfigBo)SerializationUtils.fromJsonString((String)confJson, NodeRoleConfigBo.class);
    }

    public DynamicObject queryScoreSystemById(Long scoresystemId) {
        return SCORE_SYSTEM_ENTITY.queryOne((Object)scoresystemId);
    }

    public String calculateLevel(Long assessFormId, BigDecimal ose) {
        DynamicObject assessFormDy = ASSESS_FORM_ENTITY_SERVICE.queryAssessForm(assessFormId);
        if (ose == null || assessFormDy.getDynamicObject("scoresystem") == null || assessFormDy.getDynamicObject("sumperflevel") == null) {
            return "";
        }
        Long scoreSystemId = (Long)assessFormDy.getDynamicObject("scoresystem").getPkValue();
        Long sumPerfLevelId = (Long)assessFormDy.getDynamicObject("sumperflevel").getPkValue();
        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelId);
        DynamicObjectCollection scoreMapEntry = sumPerfLevel.getDynamicObjectCollection("scoremapentryentity");
        DynamicObject scoreMapDy = scoreMapEntry.stream().filter(scoreMap -> scoreMap.getLong("scoresystem.id") == scoreSystemId.longValue()).findFirst().orElse(null);
        if (scoreMapDy == null) {
            LOG.error("Unable to find score system mapping for performance level, scoreSystemId[{}], sumPerfLevelId[{}]", (Object)scoreSystemId, (Object)sumPerfLevelId);
            return null;
        }
        String levelScoreMap = scoreMapDy.getString("levelscoremap");
        if (HRStringUtils.equals((String)levelScoreMap, (String)"20")) {
            LOG.error("Mapping by default is not supported");
            return "";
        }
        DynamicObjectCollection scoreLevelMapEntry = scoreMapDy.getDynamicObjectCollection("scoresubentryentity");
        for (DynamicObject scoreLevelMap : scoreLevelMapEntry) {
            BigDecimal maxScore = scoreLevelMap.getBigDecimal("maxscore");
            String scoreMaxOperation = scoreLevelMap.getString("scoremaxoperation");
            String scoreMinOperation = scoreLevelMap.getString("scoreminoperation");
            BigDecimal minScore = scoreLevelMap.getBigDecimal("minscore");
            boolean maxCompare = true;
            if (maxScore != null && maxScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMaxOperation, (String)"10")) {
                    maxCompare = maxScore.compareTo(ose) > 0;
                } else if (HRStringUtils.equals((String)scoreMaxOperation, (String)"20")) {
                    maxCompare = maxScore.compareTo(ose) >= 0;
                }
            }
            boolean minCompare = true;
            if (minScore != null && minScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMinOperation, (String)"10")) {
                    minCompare = ose.compareTo(minScore) > 0;
                } else if (HRStringUtils.equals((String)scoreMinOperation, (String)"20")) {
                    boolean bl = minCompare = ose.compareTo(minScore) >= 0;
                }
            }
            if (!maxCompare || !minCompare) continue;
            return scoreLevelMap.getString("seq");
        }
        return "";
    }

    public Long queryPreRoleLastTaskOfNextGrade(Long taskId) {
        if (taskId == null) {
            return null;
        }
        boolean isFirstNodeAndRole = this.queryIsFirstNodeAndRole(taskId);
        if (isFirstNodeAndRole) {
            return null;
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Map<Long, Long> roleMap = this.queryPreNodeLastRoleMap(taskId);
            return this.getNextGradleLastTaskId(roleMap);
        }
        Map<Long, Long> sortRoleDefMap = this.getMaxOverSortRoleMap(roles);
        return this.getNextGradleLastTaskId(sortRoleDefMap);
    }

    public boolean queryIsFirstNodeAndRole(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return true;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles != null && roles.length > 0) {
            return false;
        }
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryIsFirstNode(taskId);
    }

    public DynamicObject[] queryLessThanRoleSortRoles(Long flowRuRoleId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryLessThanRoleSortRoles(flowRuRoleId);
    }

    public Map<Long, Long> queryPreNodeLastRoleMap(Long taskId) {
        Map roleDefMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryPreNodeLastRoleMap(taskId);
        return roleDefMap;
    }

    private Long getNextGradleLastTaskId(Map<Long, Long> sortRoleDefMap) {
        Set<Long> defRoleIdSet = sortRoleDefMap.keySet();
        ArrayList<Long> nextRuRoleIdList = new ArrayList<Long>(10);
        Map roleConfigBoMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(defRoleIdSet);
        if (roleConfigBoMap != null) {
            for (Map.Entry next : roleConfigBoMap.entrySet()) {
                Long ruRoleId;
                Boolean isScoreNext;
                NodeRoleConfigBo roleConfigBo;
                if (next == null || (roleConfigBo = (NodeRoleConfigBo)next.getValue()) == null || (isScoreNext = roleConfigBo.getIsgradenext()) == null || !isScoreNext.booleanValue() || (ruRoleId = sortRoleDefMap.get(next.getKey())) == null) continue;
                nextRuRoleIdList.add(ruRoleId);
            }
        }
        Long lastTaskIdOfFinish = this.queryLastTaskIdByRoleIds(nextRuRoleIdList);
        return lastTaskIdOfFinish;
    }

    private Map<Long, Long> getMaxOverSortRoleMap(DynamicObject[] roles) {
        HashMap<Long, Long> ruRoleMap = new HashMap<Long, Long>(16);
        DynamicObject maxSortRole = null;
        for (DynamicObject role : roles) {
            if (role == null) continue;
            if (maxSortRole == null) {
                maxSortRole = role;
            }
            int turnOverSort = role.getInt("turnoversort");
            int maxTurnOverSort = maxSortRole.getInt("turnoversort");
            if (maxTurnOverSort != turnOverSort) continue;
            ruRoleMap.put(role.getLong("flowdefrole.id"), role.getLong("id"));
        }
        return ruRoleMap;
    }

    public Long queryLastTaskIdByRoleIds(List<Long> ruRoleIds) {
        if (ruRoleIds == null || ruRoleIds.isEmpty()) {
            return null;
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryLastTaskByRoleIds(ruRoleIds);
        if (taskObj == null) {
            return null;
        }
        return taskObj.getLong("id");
    }

    public DynamicObject querySumAreaEvalRecord(Long taskId) {
        QFilter sumareaFilter = new QFilter("flowrutask", "=", (Object)taskId);
        return OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.queryOne("actevalobj, ose, ole, eval, modifytime", sumareaFilter);
    }

    public Long queryPreRoleLastTaskOfNextEval(Long taskId) {
        if (taskId == null) {
            return null;
        }
        boolean isFirstNodeAndRole = this.queryIsFirstNodeAndRole(taskId);
        if (isFirstNodeAndRole) {
            return null;
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Map<Long, Long> roleMap = this.queryPreNodeLastRoleMap(taskId);
            return this.getNextEvalLastTaskId(roleMap);
        }
        Map<Long, Long> sortRoleDefMap = this.getMaxOverSortRoleMap(roles);
        return this.getNextEvalLastTaskId(sortRoleDefMap);
    }

    private Long getNextEvalLastTaskId(Map<Long, Long> sortRoleDefMap) {
        Set<Long> defRoleIdSet = sortRoleDefMap.keySet();
        ArrayList<Long> nextRuRoleIdList = new ArrayList<Long>(10);
        Map roleConfigBoMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(defRoleIdSet);
        if (roleConfigBoMap != null) {
            for (Map.Entry next : roleConfigBoMap.entrySet()) {
                Long ruRoleId;
                Boolean isNext;
                NodeRoleConfigBo roleConfigBo;
                if (next == null || (roleConfigBo = (NodeRoleConfigBo)next.getValue()) == null || (isNext = roleConfigBo.getIsevaluatenext()) == null || !isNext.booleanValue() || (ruRoleId = sortRoleDefMap.get(next.getKey())) == null) continue;
                nextRuRoleIdList.add(ruRoleId);
            }
        }
        Long lastTaskIdOfFinish = this.queryLastTaskIdByRoleIds(nextRuRoleIdList);
        return lastTaskIdOfFinish;
    }

    public void processTask(List<Long> taskList) {
        for (Long taskId : taskList) {
            FLOW_RU_PROC_DOMAIN_SERVICE.processTask(taskId);
        }
    }

    public Map<String, DynamicObject> querySumConfigByTaskId(Long taskId) {
        DynamicObject assessFormObj = this.queryAssessFormByTaskId(taskId);
        Long sumConfIdId = assessFormObj.getLong("sumconf");
        DynamicObject sumConfObj = SUM_CONFIG_ENTITY_SERVICE.queryOne(sumConfIdId);
        DynamicObjectCollection filedEntry = sumConfObj.getDynamicObjectCollection("entryentity");
        Map<String, DynamicObject> fieldMap = filedEntry.stream().collect(Collectors.toMap(filedInfo -> filedInfo.getDynamicObject("areafield").getString("number"), Function.identity()));
        return fieldMap;
    }

    public Map<String, Boolean> querySumMustInputMap(Long taskId) {
        HashMap<String, Boolean> sumMustInput = new HashMap<String, Boolean>(16);
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowrunode", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, dynamicpermission", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("evalway, numaccuracy, sumconf, sumperflevel ", new QFilter[]{assessFormFilter});
        Long sumConfIdId = assessFormObj.getLong("sumconf");
        DynamicObject sumConfObj = SUM_CONFIG_ENTITY_SERVICE.queryOne(sumConfIdId);
        DynamicObjectCollection filedEntry = sumConfObj.getDynamicObjectCollection("entryentity");
        Map fieldMap = filedEntry.stream().collect(Collectors.toMap(filedInfo -> filedInfo.getDynamicObject("areafield").getString("number"), Function.identity()));
        EvalWayEnum evalWay = EvalWayEnum.getEvalWay((String)assessFormObj.getString("evalway"));
        QFilter flowrunodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject flowrunodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{flowrunodeFilter});
        NodeRoleConfigBo roleConfig = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(taskId);
        long newProcPermId = activityObj.getLong("dynamicpermission.id");
        long flowNodeDefId = flowrunodeObj.getLong("flownodedef.id");
        Map<Long, Map<String, Boolean>> areaFieldPermMap = this.getAreaFieldPermMap(sumConfIdId, newProcPermId, flowNodeDefId);
        if (areaFieldPermMap != null) {
            Set<Long> areaFieldIdSet = areaFieldPermMap.keySet();
            QFilter filter = new QFilter("id", "in", areaFieldIdSet);
            DynamicObject[] fieldArr = AREA_FIELD_ENTITY_SERVICE.queryOriginalArray("id,number", new QFilter[]{filter});
            if (fieldArr != null) {
                block10: for (DynamicObject fieldDy : fieldArr) {
                    if (fieldDy == null) continue;
                    String number = fieldDy.getString("number");
                    long areaFieldId = fieldDy.getLong("id");
                    Map<String, Boolean> procPermObj = areaFieldPermMap.get(areaFieldId);
                    Boolean fielddisplayitem = procPermObj.get("fielddisplayitem");
                    Boolean fieldmustinputitem = procPermObj.get("fieldmustinputitem");
                    Boolean fieldmodifyitem = procPermObj.get("fieldmodifyitem");
                    switch (number) {
                        case "ose": {
                            if (fielddisplayitem.booleanValue()) {
                                sumMustInput.put("ose", fieldmustinputitem);
                                continue block10;
                            }
                            sumMustInput.put("ose", Boolean.FALSE);
                            continue block10;
                        }
                        case "ole": {
                            if (fielddisplayitem.booleanValue()) {
                                DynamicObject oleObj = (DynamicObject)fieldMap.get("ole");
                                if (oleObj != null) {
                                    if (fielddisplayitem.booleanValue()) {
                                        sumMustInput.put("ole", fieldmustinputitem);
                                        continue block10;
                                    }
                                    sumMustInput.put("ole", Boolean.FALSE);
                                    continue block10;
                                }
                                sumMustInput.put("ole", Boolean.FALSE);
                                continue block10;
                            }
                            sumMustInput.put("ole", Boolean.FALSE);
                            continue block10;
                        }
                        case "eval": {
                            if (fielddisplayitem.booleanValue()) {
                                sumMustInput.put("eval", fieldmustinputitem);
                                continue block10;
                            }
                            sumMustInput.put("eval", Boolean.FALSE);
                            continue block10;
                        }
                    }
                }
            }
        }
        if (!sumMustInput.containsKey("ose")) {
            sumMustInput.put("ose", Boolean.FALSE);
        }
        if (!sumMustInput.containsKey("ole")) {
            sumMustInput.put("ole", Boolean.FALSE);
        }
        if (!sumMustInput.containsKey("eval")) {
            sumMustInput.put("eval", Boolean.FALSE);
        }
        return sumMustInput;
    }

    public Map<String, Object> querySumPermMap(Long taskId) {
        Set<Long> areaFieldIdSet;
        QFilter filter;
        DynamicObject[] fieldArr;
        HashMap<String, Object> sumPermMap = new HashMap<String, Object>(16);
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowrunode", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, processpermsetting, dynamicpermission", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("evalway, numaccuracy, sumconf, sumperflevel ", new QFilter[]{assessFormFilter});
        Long sumConfIdId = assessFormObj.getLong("sumconf");
        DynamicObject sumConfObj = SUM_CONFIG_ENTITY_SERVICE.queryOne(sumConfIdId);
        DynamicObjectCollection filedEntry = sumConfObj.getDynamicObjectCollection("entryentity");
        Map fieldMap = filedEntry.stream().collect(Collectors.toMap(filedInfo -> filedInfo.getDynamicObject("areafield").getString("number"), Function.identity()));
        EvalWayEnum evalWay = EvalWayEnum.getEvalWay((String)assessFormObj.getString("evalway"));
        QFilter flowrunodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject flowrunodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{flowrunodeFilter});
        NodeRoleConfigBo roleConfig = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(taskId);
        long newProcPermId = activityObj.getLong("dynamicpermission.id");
        long flowNodeDefId = flowrunodeObj.getLong("flownodedef.id");
        Map<Long, Map<String, Boolean>> areaFieldPermMap = this.getAreaFieldPermMap(sumConfIdId, newProcPermId, flowNodeDefId);
        if (areaFieldPermMap != null && (fieldArr = AREA_FIELD_ENTITY_SERVICE.queryOriginalArray("id,number", new QFilter[]{filter = new QFilter("id", "in", areaFieldIdSet = areaFieldPermMap.keySet())})) != null) {
            block10: for (DynamicObject fieldDy : fieldArr) {
                if (fieldDy == null) continue;
                String number = fieldDy.getString("number");
                long areaFieldId = fieldDy.getLong("id");
                Map<String, Boolean> procPermObj = areaFieldPermMap.get(areaFieldId);
                Boolean fielddisplayitem = procPermObj.get("fielddisplayitem");
                Boolean fieldmustinputitem = procPermObj.get("fieldmustinputitem");
                Boolean fieldmodifyitem = procPermObj.get("fieldmodifyitem");
                switch (number) {
                    case "ose": {
                        HashMap<String, Boolean> oseMap = new HashMap<String, Boolean>(16);
                        oseMap.put("fielddisplayitem", fielddisplayitem);
                        oseMap.put("fieldmustinputitem", Boolean.TRUE.equals(fielddisplayitem) ? fieldmustinputitem : Boolean.FALSE);
                        oseMap.put("fieldmodifyitem", fieldmodifyitem);
                        sumPermMap.put("ose", oseMap);
                        continue block10;
                    }
                    case "ole": {
                        HashMap<String, Boolean> oleMap = new HashMap<String, Boolean>(16);
                        oleMap.put("fielddisplayitem", fielddisplayitem);
                        oleMap.put("fieldmustinputitem", Boolean.TRUE.equals(fielddisplayitem) && fieldMap.get("ole") != null ? fieldmustinputitem : Boolean.FALSE);
                        oleMap.put("fieldmodifyitem", fieldmodifyitem);
                        sumPermMap.put("ole", oleMap);
                        continue block10;
                    }
                    case "eval": {
                        HashMap<String, Boolean> evalMap = new HashMap<String, Boolean>(16);
                        evalMap.put("fielddisplayitem", fielddisplayitem);
                        evalMap.put("fieldmustinputitem", Boolean.TRUE.equals(fielddisplayitem) ? fieldmustinputitem : Boolean.FALSE);
                        evalMap.put("fieldmodifyitem", fieldmodifyitem);
                        sumPermMap.put("eval", evalMap);
                        continue block10;
                    }
                }
            }
        }
        if (!sumPermMap.containsKey("ose")) {
            HashMap<String, Boolean> oseMap = new HashMap<String, Boolean>(16);
            oseMap.put("fielddisplayitem", Boolean.FALSE);
            oseMap.put("fieldmustinputitem", Boolean.FALSE);
            oseMap.put("fieldmodifyitem", Boolean.FALSE);
            sumPermMap.put("ose", oseMap);
        }
        if (!sumPermMap.containsKey("ole")) {
            HashMap<String, Boolean> oleMap = new HashMap<String, Boolean>(16);
            oleMap.put("fielddisplayitem", Boolean.FALSE);
            oleMap.put("fieldmustinputitem", Boolean.FALSE);
            oleMap.put("fieldmodifyitem", Boolean.FALSE);
            sumPermMap.put("ole", oleMap);
        }
        if (!sumPermMap.containsKey("eval")) {
            HashMap<String, Boolean> evalMap = new HashMap<String, Boolean>(16);
            evalMap.put("fielddisplayitem", Boolean.FALSE);
            evalMap.put("fieldmustinputitem", Boolean.FALSE);
            evalMap.put("fieldmodifyitem", Boolean.FALSE);
            sumPermMap.put("eval", evalMap);
        }
        return sumPermMap;
    }

    public Map<String, String> querySumCustNameMap(Long taskId) {
        HashMap<String, String> sumCustNameMap = new HashMap<String, String>(16);
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowrunode", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, processpermsetting, dynamicpermission", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("evalway, numaccuracy, sumconf, sumperflevel ", new QFilter[]{assessFormFilter});
        Long sumConfIdId = assessFormObj.getLong("sumconf");
        DynamicObject sumConfObj = SUM_CONFIG_ENTITY_SERVICE.queryOne(sumConfIdId);
        DynamicObjectCollection filedEntry = sumConfObj.getDynamicObjectCollection("entryentity");
        Map fieldMap = filedEntry.stream().collect(Collectors.toMap(filedInfo -> filedInfo.getDynamicObject("areafield").getString("number"), Function.identity()));
        DynamicObject ose = (DynamicObject)fieldMap.get("ose");
        if (HRObjectUtils.isEmpty((Object)ose)) {
            sumCustNameMap.put("ose", "");
        } else {
            sumCustNameMap.put("ose", ose.getString("fieldcustname"));
        }
        DynamicObject ole = (DynamicObject)fieldMap.get("ole");
        if (HRObjectUtils.isEmpty((Object)ole)) {
            sumCustNameMap.put("ole", "");
        } else {
            sumCustNameMap.put("ole", ole.getString("fieldcustname"));
        }
        DynamicObject eval = (DynamicObject)fieldMap.get("eval");
        if (HRObjectUtils.isEmpty((Object)eval)) {
            sumCustNameMap.put("eval", "");
        } else {
            sumCustNameMap.put("eval", eval.getString("fieldcustname"));
        }
        return sumCustNameMap;
    }

    public Boolean isCrossNodeOfPreRole(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return false;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles != null && roles.length > 0) {
            for (DynamicObject role : roles) {
                if (role == null) continue;
                return role.getBoolean("iscrossrole");
            }
        } else {
            long procId = taskObj.getLong("flowruproc.id");
            int index = taskObj.getInt("flowrunode.index");
            if (index == 1) {
                long ruNodeId = taskObj.getLong("flowrunode.id");
                DynamicObject ruNodeDy = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByPk(Long.valueOf(ruNodeId));
                if (ruNodeDy != null) {
                    return ruNodeDy.getBoolean("iscrossnode");
                }
            } else {
                DynamicObject ruNodeDy = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByIndex(Long.valueOf(procId), index - 1);
                if (ruNodeDy != null) {
                    return ruNodeDy.getBoolean("iscrossnode");
                }
            }
        }
        return false;
    }

    public Boolean isFirstNodeAndRole(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return true;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles != null && roles.length > 0) {
            return false;
        }
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryIsFirstNode(taskId);
    }

    public Map<Long, String> queryTaskStatusMap(List<Long> selectedTaskIdList) {
        Map<Long, String> taskStatusMap = new HashMap<Long, String>(16);
        if (selectedTaskIdList != null && !selectedTaskIdList.isEmpty()) {
            QFilter filter = new QFilter("id", "in", selectedTaskIdList);
            DynamicObject[] taskObjs = FLOW_RU_TASK_ENTITY_SERVICE.query("taskstatus", new QFilter[]{filter});
            taskStatusMap = Arrays.asList(taskObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString("taskstatus")));
        }
        return taskStatusMap;
    }

    public Pair<Boolean, String> checkTaskInfo(Long taskId) {
        if (StringUtils.isEmpty((CharSequence)String.valueOf(taskId))) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ActEvalObjOverallDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        DynamicObject taskDy = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        long userId = RequestContext.get().getCurrUserId();
        if (ObjectUtils.isEmpty((Object)taskDy) || userId != taskDy.getLong("handler.id")) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ActEvalObjOverallDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        String flowStatus = taskDy.getString("flowruproc.procstatus");
        if (StringUtils.equals((CharSequence)flowStatus, (CharSequence)FlowRuProcStatusEnum.STOP.getCode())) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8bc4\u4f30\u6d41\u7a0b{0}\uff0c\u8bc4\u4f30\u6d41\u7a0b\u6062\u590d\u6b63\u5e38\u540e\u5c06\u53d1\u9001\u901a\u77e5\u6d88\u606f\u7ed9\u60a8\uff0c\u4e4b\u540e\u60a8\u53ef\u518d\u8bc4\u4f30", (String)"ActEvalObjOverallDomainService_2", (String)"opmc-epa-business", (Object[])new Object[]{FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)flowStatus).getText()}));
        }
        if (StringUtils.equals((CharSequence)flowStatus, (CharSequence)FlowRuProcStatusEnum.DEPRECATED.getCode())) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ActEvalObjOverallDomainService_3", (String)"opmc-epa-business", (Object[])new Object[]{FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)flowStatus).getText()}));
        }
        FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskDy.getString("taskstatus"));
        if (taskStatus == FlowRuTaskStatusEnum.REJECTED || taskStatus == FlowRuTaskStatusEnum.EXPIRED) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ActEvalObjOverallDomainService_3", (String)"opmc-epa-business", (Object[])new Object[]{taskStatus.getText()}));
        }
        return new Pair((Object)Boolean.TRUE, (Object)"");
    }

    public DynamicObject[] queryAdjRecordByActEvalObjId(Long actEvalObjId) {
        QFilter adjFilter = new QFilter("actevalobj", "=", (Object)actEvalObjId);
        adjFilter.and(new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode()));
        return EVAL_ADJUSTMENT_ENTITY_SERVICE.queryOriginalArray("atcs, ins, atcl, actevalobj, flowrutask.id, flowrutask.taskstatus", new QFilter[]{adjFilter}, "modifytime desc");
    }

    public DynamicObject queryTaskInfo(Long taskId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
    }

    public void saveRuTaskDy(DynamicObject task) {
        FLOW_RU_TASK_ENTITY_SERVICE.saveOne(task);
    }

    public DynamicObject queryActivityById(long activityId) {
        QFilter activityFilter = new QFilter("id", "=", (Object)activityId);
        return ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("name, processpermsetting, dynamicpermission", new QFilter[]{activityFilter});
    }

    public Map<Long, String> queryAnonymity(Long procPermId, List<Long> nodeDefIdList) {
        HashMap<Long, String> anonymityMap = new HashMap<Long, String>(16);
        DynPermissionConfigService dynPermissionConfigService = new DynPermissionConfigService();
        DynamicPermissionConfigVO dynamicPermissionConfigVO = dynPermissionConfigService.getDynamicPermissions(procPermId, nodeDefIdList);
        return anonymityMap;
    }

    public Map<String, Object> queryPermissionConfig(Long taskId) {
        List scopeAreaEntries;
        Map scopeAreaEntriesMap;
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowruproc, flowrunode, flowrunode.index,flowrurole", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("executescheme, processpermsetting, dynamicpermission", new QFilter[]{activityFilter});
        HashMap<String, Object> permissionConfig = new HashMap<String, Object>(16);
        QFilter flowrunodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject flowrunodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{flowrunodeFilter});
        permissionConfig.put("flowrunodeId", flowruTaskObj.getLong("flowrunode.id"));
        permissionConfig.put("flowrunodeIndex", flowrunodeObj.getInt("index"));
        permissionConfig.put("flowruroleId", flowruTaskObj.getLong("flowrurole.id"));
        Long procPermId = activityObj.getLong("dynamicpermission.id");
        long flowNodeDefId = flowrunodeObj.getLong("flownodedef.id");
        DynPermissionConfigService dynPermissionConfigService = new DynPermissionConfigService();
        DynamicPermissionConfigVO dynamicPermissions = dynPermissionConfigService.getDynamicPermissions(procPermId, Collections.singletonList(flowNodeDefId));
        if (dynamicPermissions != null && (scopeAreaEntriesMap = dynamicPermissions.getScopeAreaEntriesMap()) != null && CollectionUtils.isNotEmpty((Collection)(scopeAreaEntries = (List)scopeAreaEntriesMap.get(flowNodeDefId)))) {
            Map<Long, String> scoreContentIdNumberMap = this.queryIdNumberMap("epa_scorecontent");
            Map<Long, String> scoreShowAreaIdNumberMap = this.queryIdNumberMap("epa_scoreshowarea");
            for (ScopeAreaEntry scopeAreaEntry : scopeAreaEntries) {
                Long scoreContentId = scopeAreaEntry.getScoreContentId();
                Long scoreShowAreaId = scopeAreaEntry.getScoreShowAreaId();
                String scoreContent = scoreContentIdNumberMap.get(scoreContentId);
                String scoreShowArea = scoreShowAreaIdNumberMap.get(scoreShowAreaId);
                permissionConfig.put(scoreContent, scoreShowArea);
            }
        }
        permissionConfig.put("turnoversort", flowruTaskObj.getInt("flowrurole.turnoversort"));
        return permissionConfig;
    }

    public DynamicObject[] queryNdrRecordByActEvalObjId(Long actEvalObjId) {
        QFilter activityFilter = new QFilter("actevalobj", "=", (Object)actEvalObjId);
        return OBJ_NODE_RES_ENTITY_SERVICE.queryOriginalArray("flowruproc, flowrunode, sont, activity, actevalobj", new QFilter[]{activityFilter});
    }

    public Map<String, BigDecimal> getScoreRangeMap(Long actEvalObjId) {
        String evasumlimitStr;
        HashMap<String, BigDecimal> scoreRangeMap = new HashMap<String, BigDecimal>(16);
        BigDecimal maxScore = BigDecimal.ZERO;
        BigDecimal minScore = BigDecimal.ZERO;
        QFilter actEvalObjFilter = new QFilter("id", "=", (Object)actEvalObjId);
        DynamicObject actEvalObj = ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.queryOne("activity, areaentry.areareg, areaentry.areains, areaentry.areaconf", new QFilter[]{actEvalObjFilter});
        Long activityId = actEvalObj.getLong("activity.id");
        QFilter activityFilter = new QFilter("id", "=", (Object)activityId);
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryOne("scaletype, evasumlimit, limitmaxscore, limitminscore, scoresystem, evalway, scorecalcway, numaccuracy, sumconf, sumperflevel", new QFilter[]{assessFormFilter});
        String evalWayStr = assessForm.getString("evalway");
        EvalWayEnum evalWay = EvalWayEnum.getEvalWay((String)evalWayStr);
        String scoreCalcWayStr = assessForm.getString("scorecalcway");
        ScoreCalcWayEnum scoreCalcWay = ScoreCalcWayEnum.getScoreCalcWay((String)scoreCalcWayStr);
        Long scoreSystemId = assessForm.getLong("scoresystem.id");
        DynamicObject scoreSystemDy = SCORE_SYSTEM_ENTITY.queryOne((Object)scoreSystemId);
        BigDecimal maxSysScore = BigDecimal.ZERO;
        if (scoreSystemDy != null) {
            maxSysScore = scoreSystemDy.getBigDecimal("maxscore") == null ? BigDecimal.ZERO : scoreSystemDy.getBigDecimal("maxscore");
            BigDecimal bigDecimal = minScore = scoreSystemDy.getBigDecimal("minscore") == null ? BigDecimal.ZERO : scoreSystemDy.getBigDecimal("minscore");
        }
        if (HRStringUtils.isNotEmpty((String)(evasumlimitStr = assessForm.getString("evasumlimit")))) {
            EvaSumLimit evaSumLimit = EvaSumLimit.getEvaSumLimit((String)evasumlimitStr);
            switch (evaSumLimit) {
                case NOT_LIMIT: {
                    DynamicObject[] addSubAreaInsObjs;
                    List partinASAreaConfIdList;
                    QFilter addSubAreaConfFilter;
                    DynamicObject[] addSubAreaConfObjs;
                    DynamicObjectCollection areaEntry = actEvalObj.getDynamicObjectCollection("areaentry");
                    ArrayList<Long> genAreaConfIdList = new ArrayList<Long>(10);
                    List<Object> genAreaInsIdList = new ArrayList(10);
                    ArrayList<Long> addSubAreaConfIdList = new ArrayList<Long>(10);
                    List<Object> addSubAreaInsIdList = new ArrayList(10);
                    for (DynamicObject area : areaEntry) {
                        Long areaRegId = area.getLong("areareg.id");
                        Long areaConfId = area.getLong("areaconf");
                        if (AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaRegId)) {
                            genAreaConfIdList.add(areaConfId);
                            continue;
                        }
                        if (!AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaRegId)) continue;
                        addSubAreaConfIdList.add(areaConfId);
                    }
                    QFilter genAreaConfFilter = new QFilter("id", "in", genAreaConfIdList);
                    DynamicObject[] genAreaConfObjs = NORMAL_CONFIG_ENTITY_SERVICE.queryOriginalArray("id, isalloweval, ispartin, areascore, weight", new QFilter[]{genAreaConfFilter});
                    List partinGenAreaConfIdList = Arrays.asList(genAreaConfObjs).stream().filter(obj -> obj.getBoolean("isalloweval") && obj.getBoolean("ispartin")).map(obj -> obj.getLong("id")).collect(Collectors.toList());
                    if (partinGenAreaConfIdList != null && !partinGenAreaConfIdList.isEmpty()) {
                        DynamicObject[] genAreaInsObjs;
                        genAreaInsIdList = areaEntry.stream().filter(obj -> partinGenAreaConfIdList.contains(obj.getLong("areaconf"))).map(obj -> obj.getLong("areains")).collect(Collectors.toList());
                        QFilter genAreaFilter = new QFilter("id", "in", genAreaInsIdList);
                        for (DynamicObject dynamicObject : genAreaInsObjs = OBJ_GEN_AREA_INS_ENTITY_SERVICE.queryOriginalArray("areaweight, areascore", new QFilter[]{genAreaFilter})) {
                            if (scoreCalcWay == ScoreCalcWayEnum.SUM) {
                                BigDecimal areaScore = dynamicObject.getBigDecimal("areascore");
                                maxScore = maxScore.add(areaScore);
                                continue;
                            }
                            if (scoreCalcWay != ScoreCalcWayEnum.WEIGHT) continue;
                            BigDecimal weight = dynamicObject.getBigDecimal("areaweight");
                            BigDecimal weightPercent = weight.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP);
                            BigDecimal areaScore = maxSysScore.multiply(weightPercent);
                            maxScore = maxScore.add(areaScore);
                        }
                    }
                    if ((addSubAreaConfObjs = PLUS_MINUS_CONFIG_ENTITY_SERVICE.queryOriginalArray("id, ispartin", new QFilter[]{addSubAreaConfFilter = new QFilter("id", "in", addSubAreaConfIdList)})) == null || addSubAreaConfObjs.length <= 0 || (partinASAreaConfIdList = Arrays.asList(addSubAreaConfObjs).stream().filter(obj -> obj.getBoolean("ispartin")).map(obj -> obj.getLong("id")).collect(Collectors.toList())) == null || partinASAreaConfIdList.isEmpty()) break;
                    addSubAreaInsIdList = areaEntry.stream().filter(obj -> partinASAreaConfIdList.contains(obj.getLong("areaconf"))).map(obj -> obj.getLong("areains")).collect(Collectors.toList());
                    QFilter addSubAreaFilter = new QFilter("id", "in", addSubAreaInsIdList);
                    for (DynamicObject addSubAreaIns : addSubAreaInsObjs = OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.queryOriginalArray("minareascore, maxareascore, ispartin", new QFilter[]{addSubAreaFilter})) {
                        BigDecimal maxAreaScore = addSubAreaIns.getBigDecimal("maxareascore");
                        maxScore = maxScore.add(maxAreaScore);
                        BigDecimal minAreaScore = addSubAreaIns.getBigDecimal("minareascore");
                        minScore = minScore.add(minAreaScore);
                    }
                    break;
                }
                case SUM_LIMIT: {
                    DynamicObject[] genAreaInsObjs;
                    DynamicObjectCollection areaEntry = actEvalObj.getDynamicObjectCollection("areaentry");
                    ArrayList<Long> genAreaConfIdList = new ArrayList<Long>(10);
                    List<Object> genAreaInsIdList = new ArrayList(10);
                    for (DynamicObject area : areaEntry) {
                        Long areaRegId = area.getLong("areareg.id");
                        Long l = area.getLong("areaconf");
                        if (!AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaRegId)) continue;
                        genAreaConfIdList.add(l);
                    }
                    QFilter genAreaConfFilter = new QFilter("id", "in", genAreaConfIdList);
                    DynamicObject[] genAreaConfObjs = NORMAL_CONFIG_ENTITY_SERVICE.queryOriginalArray("id, isalloweval, ispartin, areascore, weight", new QFilter[]{genAreaConfFilter});
                    List partinGenAreaConfIdList = Arrays.asList(genAreaConfObjs).stream().filter(obj -> obj.getBoolean("isalloweval") && obj.getBoolean("ispartin")).map(obj -> obj.getLong("id")).collect(Collectors.toList());
                    if (partinGenAreaConfIdList == null || partinGenAreaConfIdList.isEmpty()) break;
                    genAreaInsIdList = areaEntry.stream().filter(obj -> partinGenAreaConfIdList.contains(obj.getLong("areaconf"))).map(obj -> obj.getLong("areains")).collect(Collectors.toList());
                    QFilter genAreaFilter = new QFilter("id", "in", genAreaInsIdList);
                    for (DynamicObject genAreaInsObj : genAreaInsObjs = OBJ_GEN_AREA_INS_ENTITY_SERVICE.queryOriginalArray("areaweight, areascore", new QFilter[]{genAreaFilter})) {
                        if (scoreCalcWay == ScoreCalcWayEnum.SUM) {
                            BigDecimal areaScore = genAreaInsObj.getBigDecimal("areascore");
                            maxScore = maxScore.add(areaScore);
                            continue;
                        }
                        if (scoreCalcWay != ScoreCalcWayEnum.WEIGHT) continue;
                        BigDecimal weight = genAreaInsObj.getBigDecimal("areaweight");
                        BigDecimal weightPercent = weight.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP);
                        BigDecimal areaScore = maxSysScore.multiply(weightPercent);
                        maxScore = maxScore.add(areaScore);
                    }
                    break;
                }
                case APPOINT_SUM_LIMIT: {
                    maxScore = assessForm.getBigDecimal("limitmaxscore") == null ? BigDecimal.ZERO : assessForm.getBigDecimal("limitmaxscore");
                    minScore = assessForm.getBigDecimal("limitminscore") == null ? BigDecimal.ZERO : assessForm.getBigDecimal("limitminscore");
                    break;
                }
            }
        }
        scoreRangeMap.put("maxscore", maxScore);
        scoreRangeMap.put("minscore", minScore);
        return scoreRangeMap;
    }

    public List<Map<String, Object>> getBatchTaskDetails(Long batchTaskId) {
        QFilter taskStatusFilter = new QFilter("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
        taskStatusFilter.and("handler", "=", (Object)RequestContext.get().getCurrUserId());
        return FLOW_RU_SECOND_DOMAIN_SERVICE.getBatchTaskDetails(batchTaskId, taskStatusFilter);
    }

    public DynamicObject queryActEvalObjById(Long actEvalObjId) {
        QFilter actEvalObjFilter = new QFilter("id", "=", (Object)actEvalObjId);
        return ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.queryOne("id, person.name, person.number, person.headsculpture, personnumber, affiliateadminorg.id, affiliateadminorg.name, empposrel.job.name,  empposrel.position.name, perforg.id, assessyear, assessperiod, activity.id, activity.name, activity.period, activity.executescheme.name, activity.executescheme.id, activityareaentry, areaentry.areareg, areaentry.areains, areaentry.areaconf", new QFilter[]{actEvalObjFilter});
    }

    public DynamicObject queryExecuteSchemeByActivityID(Long activityId) {
        return ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne(activityId);
    }

    public DynamicObject queryExecuteScheme(Long execSchemeId) {
        return EXECUTE_SCHEME_ENTITY.queryOne(execSchemeId);
    }

    public DynamicObject queryAssessForm(Long assessFormId) {
        return ASSESS_FORM_ENTITY_SERVICE.queryOne(assessFormId);
    }

    public DynamicObject queryGenAreaConf(Long confId) {
        return NORMAL_CONFIG_ENTITY_SERVICE.queryOne(confId);
    }

    public Map<String, Object> getGenEvalNodeSon(Long actEvalObjId, Long taskId, Long areaInsId, Long confId, String scoreCalcWay) {
        HashMap<String, Object> entryData = new HashMap<String, Object>(16);
        ArrayList dataSource = new ArrayList(10);
        QFilter genInsFilter = new QFilter("id", "=", (Object)areaInsId);
        DynamicObject genInsObj = OBJ_GEN_AREA_INS_ENTITY_SERVICE.queryOne("entryentity, entryentity.id, entryentity.evalmode, entryentity.indctrname, entryentity.weight, entryentity.indctrscore, entryentity.seq", new QFilter[]{genInsFilter}, "entryentity.seq asc");
        DynamicObject flowrutaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne((Object)taskId);
        Long flowruprocId = flowrutaskObj.getLong("flowruproc.id");
        QFilter genNodeResFilter = new QFilter("area", "=", (Object)areaInsId);
        genNodeResFilter.and(new QFilter("flowruproc", "=", (Object)flowruprocId));
        genNodeResFilter.and(new QFilter("actevalobj", "=", (Object)actEvalObjId));
        DynamicObject[] genNodeResObjs = OBJ_GEN_NODE_RES_ENTITY_SERVICE.queryOriginalArray("id, indicator, indicator.id, indicator.indctrname, flowrunode, son", new QFilter[]{genNodeResFilter}, "indicator.id asc");
        Map<Long, List<DynamicObject>> genNodeResMap = Arrays.stream(genNodeResObjs).collect(Collectors.groupingBy(obj -> obj.getLong("indicator.id")));
        Set flowrunodeIdSet = Arrays.stream(genNodeResObjs).map(obj -> obj.getLong("flowrunode")).collect(Collectors.toSet());
        QFilter flowrunodeFilter = new QFilter("id", "in", flowrunodeIdSet);
        DynamicObject[] flowrunodeObjs = FLOW_RU_NODE_ENTITY_SERVICE.queryOriginalArray("id, name, nodeweight, iscrossnode, index, flownodedef, flownodedef.nodename", new QFilter[]{flowrunodeFilter}, "index asc");
        List flowrunodeIdList = Arrays.stream(flowrunodeObjs).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        List indexList = Arrays.stream(flowrunodeObjs).map(obj -> obj.getInt("index")).collect(Collectors.toList());
        int minIndex = -1;
        if (!indexList.isEmpty()) {
            minIndex = indexList.stream().max(Comparator.comparing(Integer::valueOf)).get();
        }
        DynamicObject confObj = NORMAL_CONFIG_ENTITY_SERVICE.queryOne(confId);
        DynamicObjectCollection confFieldColl = confObj.getDynamicObjectCollection("entryentity");
        Map<String, String> fieldCustNameMap = confFieldColl.stream().collect(Collectors.toMap(x -> x.getString("areafield.number"), y -> y.getString("fieldcustname")));
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>(16);
        if (!fieldCustNameMap.isEmpty() && flowrunodeObjs != null) {
            columns.put("id", "id");
            columns.put("indctrname", fieldCustNameMap.get("indctrname"));
            if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
                columns.put("indctrscore", fieldCustNameMap.get("indctrscore"));
            } else if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                columns.put("weight", fieldCustNameMap.get("weight"));
            }
            for (int i = 0; i < Math.min(minIndex, flowrunodeObjs.length); ++i) {
                DynamicObject flowrunodeObj = flowrunodeObjs[i];
                columns.put("son" + (i + 1), ResManager.loadKDString((String)"{0}\u5f97\u5206", (String)"ActEvalObjOverallDomainService_0", (String)"opmc-epa-business", (Object[])new Object[]{flowrunodeObj.getString("flownodedef.nodename")}));
            }
        }
        entryData.put("columns", columns);
        if (!HRObjectUtils.isEmpty((Object)genInsObj)) {
            DynamicObjectCollection genIndColl = genInsObj.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < genIndColl.size(); ++i) {
                DynamicObject genIndObj = (DynamicObject)genIndColl.get(i);
                Long indctrId = genIndObj.getLong("id");
                String indctrname = genIndObj.getString("indctrname");
                BigDecimal weight = genIndObj.getBigDecimal("weight");
                BigDecimal indctrscore = genIndObj.getBigDecimal("indctrscore");
                String evalmode = genIndObj.getString("evalmode");
                if (EvalModeEnum.SYS_INPUT.getCode().equals(evalmode)) continue;
                LinkedHashMap<String, Object> sonMap = new LinkedHashMap<String, Object>(16);
                sonMap.put("id", indctrId);
                sonMap.put("indctrname", indctrname);
                sonMap.put("weight", weight);
                sonMap.put("indctrscore", indctrscore);
                List<DynamicObject> genNodeResList = genNodeResMap.get(indctrId);
                if (genNodeResList != null && genNodeResList.size() > 0) {
                    for (int j = 0; j < minIndex; ++j) {
                        Long flowrunodeId = (Long)flowrunodeIdList.get(j);
                        DynamicObject genNodeResObj = genNodeResList.stream().filter(obj -> flowrunodeId.equals(obj.getLong("flowrunode"))).findFirst().orElse(null);
                        if (HRObjectUtils.isEmpty((Object)genNodeResObj)) continue;
                        sonMap.put("son" + (j + 1), genNodeResObj.getBigDecimal("son"));
                    }
                }
                dataSource.add(sonMap);
            }
        }
        entryData.put("dataSource", dataSource);
        return entryData;
    }

    public DynamicObject queryAddSubAreaConf(Long confId) {
        return PLUS_MINUS_CONFIG_ENTITY_SERVICE.queryOne(confId);
    }

    public Map<String, Object> getAddSubEvalNodeSon(Long actEvalObjId, Long taskId, Long areaInsId, Long confId) {
        HashMap<String, Object> entryData = new HashMap<String, Object>(16);
        ArrayList dataSource = new ArrayList(10);
        QFilter addSubInsFilter = new QFilter("id", "=", (Object)areaInsId);
        DynamicObject addSubInsObj = OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.queryOne("entryentity, entryentity.id, entryentity.indctrname, entryentity.seq", new QFilter[]{addSubInsFilter}, "entryentity.seq asc");
        DynamicObject flowrutaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne((Object)taskId);
        Long flowruprocId = flowrutaskObj.getLong("flowruproc.id");
        QFilter genNodeResFilter = new QFilter("area", "=", (Object)areaInsId);
        genNodeResFilter.and(new QFilter("flowruproc", "=", (Object)flowruprocId));
        genNodeResFilter.and(new QFilter("actevalobj", "=", (Object)actEvalObjId));
        DynamicObject[] genNodeResObjs = OBJ_ADD_SUB_NODE_RES_ENTITY_SERVICE.queryOriginalArray("id, indicator, indicator.id, indicator.indctrname, flowrunode, son", new QFilter[]{genNodeResFilter}, "indicator.id asc");
        Map<Long, List<DynamicObject>> genNodeResMap = Arrays.stream(genNodeResObjs).collect(Collectors.groupingBy(obj -> obj.getLong("indicator.id")));
        Set flowrunodeIdSet = Arrays.stream(genNodeResObjs).map(obj -> obj.getLong("flowrunode")).collect(Collectors.toSet());
        QFilter flowrunodeFilter = new QFilter("id", "in", flowrunodeIdSet);
        DynamicObject[] flowrunodeObjs = FLOW_RU_NODE_ENTITY_SERVICE.queryOriginalArray("id, name, nodeweight, iscrossnode, index, flownodedef, flownodedef.nodename", new QFilter[]{flowrunodeFilter}, "index asc");
        List flowrunodeIdList = Arrays.stream(flowrunodeObjs).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        List indexList = Arrays.stream(flowrunodeObjs).map(obj -> obj.getInt("index")).collect(Collectors.toList());
        int minIndex = -1;
        if (!indexList.isEmpty()) {
            minIndex = indexList.stream().max(Comparator.comparing(Integer::valueOf)).get();
            minIndex = Math.min(indexList.size(), minIndex);
        }
        DynamicObject confObj = PLUS_MINUS_CONFIG_ENTITY_SERVICE.queryOne(confId);
        DynamicObjectCollection confFieldColl = confObj.getDynamicObjectCollection("entryentity");
        Map<String, String> fieldCustNameMap = confFieldColl.stream().collect(Collectors.toMap(x -> x.getString("areafield.number"), y -> y.getString("fieldcustname")));
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>(16);
        if (!fieldCustNameMap.isEmpty()) {
            columns.put("id", "id");
            columns.put("indctrname", fieldCustNameMap.get("indctrname"));
            for (int i = 0; i < Math.min(minIndex, flowrunodeObjs.length); ++i) {
                DynamicObject flowrunodeObj = flowrunodeObjs[i];
                columns.put("son" + (i + 1), ResManager.loadKDString((String)"{0}\u5f97\u5206", (String)"ActEvalObjOverallDomainService_0", (String)"opmc-epa-business", (Object[])new Object[]{flowrunodeObj.getString("flownodedef.nodename")}));
            }
        }
        entryData.put("columns", columns);
        if (!HRObjectUtils.isEmpty((Object)addSubInsObj)) {
            DynamicObjectCollection addSubIndColl = addSubInsObj.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < addSubIndColl.size(); ++i) {
                DynamicObject addSubIndObj = (DynamicObject)addSubIndColl.get(i);
                Long indctrId = addSubIndObj.getLong("id");
                String indctrname = addSubIndObj.getString("indctrname");
                LinkedHashMap<String, Object> sonMap = new LinkedHashMap<String, Object>(16);
                sonMap.put("id", indctrId);
                sonMap.put("indctrname", indctrname);
                List<DynamicObject> genNodeResList = genNodeResMap.get(indctrId);
                for (int j = 0; j < minIndex; ++j) {
                    Long flowrunodeId = (Long)flowrunodeIdList.get(j);
                    DynamicObject genNodeResObj = genNodeResList.stream().filter(obj -> flowrunodeId.equals(obj.getLong("flowrunode"))).findFirst().orElse(null);
                    if (HRObjectUtils.isEmpty((Object)genNodeResObj)) continue;
                    sonMap.put("son" + (j + 1), genNodeResObj.getBigDecimal("son"));
                }
                dataSource.add(sonMap);
            }
        }
        entryData.put("dataSource", dataSource);
        return entryData;
    }

    public void saveSumObj(DynamicObject dyObj) {
        Long flowrutaskId = dyObj.getLong("flowrutask.id");
        this.resetRollBackedMark(Collections.singletonList(flowrutaskId));
        QFilter sumareaFilter = new QFilter("flowrutask", "=", (Object)flowrutaskId);
        DynamicObject sumareainsObj = OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.queryOne("ose, ole, eval, actevalobj, assessyear, assessperiod, activity, perforg, flowrutask, flowruproc, flowrunode, flowrurole, creator, createtime, modifier, modifytime", new QFilter[]{sumareaFilter});
        Long userId = UserServiceHelper.getCurrentUserId();
        if (HRObjectUtils.isEmpty((Object)sumareainsObj)) {
            Long rowareainsId = DBServiceHelper.genLongIds((String)"epa_evalsumareains", (int)1)[0];
            DynamicObject sumObj = OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.generateEmptyDynamicObject();
            Long taskId = dyObj.getLong("flowrutask.id");
            DynamicObject taskObj = this.queryTaskInfo(taskId);
            Long actEvalObjId = dyObj.getLong("actevalobj");
            DynamicObject actEvalObj = this.queryActEvalObjById(actEvalObjId);
            sumObj.set("id", (Object)rowareainsId);
            sumObj.set("ose", (Object)dyObj.getBigDecimal("ose"));
            sumObj.set("ole", (Object)dyObj.getString("ole"));
            sumObj.set("eval", (Object)dyObj.getString("eval"));
            sumObj.set("actevalobj", (Object)actEvalObj.getLong("id"));
            sumObj.set("assessyear", (Object)actEvalObj.getInt("assessyear"));
            sumObj.set("assessperiod", (Object)actEvalObj.getString("assessperiod"));
            sumObj.set("activity", (Object)actEvalObj.getLong("activity.id"));
            sumObj.set("perforg", (Object)actEvalObj.getLong("perforg.id"));
            sumObj.set("flowrutask", (Object)taskObj.getLong("id"));
            sumObj.set("flowruproc", (Object)taskObj.getLong("flowruproc.id"));
            sumObj.set("flowrunode", (Object)taskObj.getLong("flowrunode.id"));
            sumObj.set("flowrurole", (Object)taskObj.getLong("flowrurole.id"));
            sumObj.set("creator", (Object)userId);
            sumObj.set("createtime", (Object)new Date());
            sumObj.set("modifier", (Object)userId);
            sumObj.set("modifytime", (Object)new Date());
            OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.saveOne(sumObj);
        } else {
            sumareainsObj.set("ose", (Object)dyObj.getBigDecimal("ose"));
            sumareainsObj.set("ole", (Object)dyObj.getString("ole"));
            sumareainsObj.set("eval", (Object)dyObj.getString("eval"));
            sumareainsObj.set("modifier", (Object)userId);
            sumareainsObj.set("modifytime", (Object)new Date());
            OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.saveOne(sumareainsObj);
        }
    }

    public List<Map<String, Object>> getBatchTaskList(Long taskId, QFilter cusFilter) {
        DynamicObject[] taskDyns;
        DynamicObject taskDyo;
        ArrayList<Map<String, Object>> taskListMap = new ArrayList<Map<String, Object>>(10);
        DynamicObject[] batchTaskDyns = BATCH_TASKMAP_ENTITY_SERVICE.queryTaskByBatchTaskIds(Collections.singletonList(taskId));
        if (batchTaskDyns.length > 0) {
            taskId = batchTaskDyns[0].getLong("rutask.id");
        }
        if (null == (taskDyo = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(taskId))) {
            return taskListMap;
        }
        QFilter taskFilter = new QFilter("handler", "=", (Object)taskDyo.getDynamicObject("handler").getLong("id"));
        taskFilter.and("activity", "=", (Object)taskDyo.getLong("activity"));
        taskFilter.and("flowrurole.flowdefrole.id", "=", (Object)taskDyo.getLong("flowrurole.flowdefrole.id"));
        if (null != cusFilter) {
            taskFilter.and(cusFilter);
        }
        for (DynamicObject task : taskDyns = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByCusFilter(taskFilter)) {
            HashMap<String, Object> taskMap = new HashMap<String, Object>(16);
            taskMap.put("taskId", task.getLong("id"));
            taskMap.put("actEvaObjId", task.getLong("flowruproc.actevalobj"));
            taskMap.put("taskStatus", task.getString("taskstatus"));
            taskMap.put("indicatorColl", task.getDynamicObjectCollection("entryentity"));
            taskMap.put("iscrossevaluate", task.getBoolean("iscrossevaluate"));
            taskMap.put("activity", task.getLong("activity"));
            taskMap.put("flowrunode", task.getLong("flowrunode.id"));
            taskMap.put("flowrurole", task.getLong("flowrurole.id"));
            taskMap.put("handler", task.getLong("handler.id"));
            taskListMap.add(taskMap);
        }
        return taskListMap;
    }

    public DynamicObject queryGenIndObj(Long indId) {
        return OBJ_GEN_AREA_INDICATOR_ENTITY_SERVICE.queryOne(indId);
    }

    public DynamicObject queryAddSubIndObj(Long indId) {
        return OBJ_ADD_SUB_AREA_INDICATOR_ENTITY_SERVICE.queryOne(indId);
    }

    private Map<Long, Map<String, Boolean>> getAreaFieldPermMap(Long sumConfIdId, Long newProcPermId, Long flowNodeDefId) {
        List contentAreaEntries;
        Map contentAreaEntriesMap;
        DynPermissionConfigService dynPermissionConfigService = new DynPermissionConfigService();
        DynamicPermissionConfigVO dynamicPermissions = dynPermissionConfigService.getDynamicPermissions(newProcPermId, Collections.singletonList(flowNodeDefId));
        HashMap<Long, Map<String, Boolean>> areaFieldPermMap = new HashMap<Long, Map<String, Boolean>>(16);
        if (dynamicPermissions != null && (contentAreaEntriesMap = dynamicPermissions.getContentAreaEntriesMap()) != null && (contentAreaEntries = (List)contentAreaEntriesMap.get(flowNodeDefId)) != null) {
            for (ContentAreaEntry contentAreaEntry : contentAreaEntries) {
                Boolean areaDisplay;
                if (contentAreaEntry == null) continue;
                Long areaPageInsId = contentAreaEntry.getAreapageInsId();
                if (sumConfIdId == null || !sumConfIdId.equals(areaPageInsId)) continue;
                List fieldEntries = contentAreaEntry.getFieldEntries();
                Boolean bl = areaDisplay = contentAreaEntry.getAreaDisplay() == null ? Boolean.FALSE : contentAreaEntry.getAreaDisplay();
                if (areaDisplay != null && !areaDisplay.booleanValue() || fieldEntries == null) continue;
                for (ContentFieldEntry fieldEntry : fieldEntries) {
                    if (fieldEntry == null) continue;
                    Long areaFieldId = fieldEntry.getAreaFieldId();
                    Map<String, Boolean> procPermItemMap = this.getProcPermItemMap(fieldEntry);
                    areaFieldPermMap.put(areaFieldId, procPermItemMap);
                }
            }
        }
        return areaFieldPermMap;
    }

    private Map<String, Boolean> getProcPermItemMap(ContentFieldEntry fieldEntry) {
        Boolean fieldDisplay = fieldEntry.getFieldDisplay() == null ? Boolean.FALSE : fieldEntry.getFieldDisplay();
        Boolean fieldModify = fieldEntry.getFieldModify() == null ? Boolean.FALSE : fieldEntry.getFieldModify();
        Boolean fieldMustInput = fieldEntry.getFieldMustInput() == null ? Boolean.FALSE : fieldEntry.getFieldMustInput();
        HashMap<String, Boolean> procPermItemMap = new HashMap<String, Boolean>(16);
        procPermItemMap.put("fielddisplayitem", fieldDisplay);
        procPermItemMap.put("fieldmustinputitem", fieldMustInput);
        procPermItemMap.put("fieldmodifyitem", fieldModify);
        return procPermItemMap;
    }

    public Map<Long, Object> queryBatchProcessPermSettingScope(List<Long> taskIdList) {
        DynamicObject[] taskObjs;
        Map<Long, Object> permCfgMap = new HashMap<Long, Object>(16);
        if (taskIdList != null && !taskIdList.isEmpty() && (taskObjs = this.queryTaskById(taskIdList)) != null && taskObjs.length > 0) {
            Long activityId = taskObjs[0].getLong("activity");
            DynamicObject activityObj = this.queryActivityById(activityId);
            Long procPermId = activityObj.getLong("dynamicpermission.id");
            Set nodeDefIdSet = Arrays.stream(taskObjs).map(obj -> obj.getLong("flowrunode.flownodedef.id")).collect(Collectors.toSet());
            ArrayList<Long> nodeDefIdList = new ArrayList<Long>(nodeDefIdSet);
            permCfgMap = PROCESS_PERM_SETTING_ENTITY_SERVICE.queryBatchProcessPermSettingScope(procPermId, nodeDefIdList);
        }
        return permCfgMap;
    }

    public List<Map<String, Object>> queryOverallPersonInfoFields(Long taskId) {
        Set areaFieldIdSet;
        QFilter filter;
        DynamicObject[] fieldArr;
        List contentAreaEntries;
        Map contentAreaEntriesMap;
        ArrayList<Map<String, Object>> personInfoFieldsList = new ArrayList<Map<String, Object>>(10);
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowruproc, flowrunode", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, dynamicpermission", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("empinfoconf", new QFilter[]{assessFormFilter});
        long empInfoIdId = assessFormObj.getLong("empinfoconf");
        QFilter nodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject nodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{nodeFilter});
        HashMap areaFieldPermMap = new HashMap(16);
        Long newProcPermId = activityObj.getLong("dynamicpermission.id");
        DynPermissionConfigService dynamicObjectCollection = new DynPermissionConfigService();
        long flowNodeDefId = nodeObj.getLong("flownodedef.id");
        ArrayList<Long> flowNodeIdList = new ArrayList<Long>(10);
        flowNodeIdList.add(flowNodeDefId);
        DynamicPermissionConfigVO dynamicPermissions = dynamicObjectCollection.getDynamicPermissions(newProcPermId, flowNodeIdList);
        if (dynamicPermissions != null && (contentAreaEntriesMap = dynamicPermissions.getContentAreaEntriesMap()) != null && (contentAreaEntries = (List)contentAreaEntriesMap.get(flowNodeDefId)) != null) {
            for (ContentAreaEntry contentAreaEntry : contentAreaEntries) {
                Boolean areaDisplay;
                DynamicObject[] areaPageInsId;
                if (contentAreaEntry == null || empInfoIdId != (areaPageInsId = contentAreaEntry.getAreapageInsId() == null ? Long.valueOf("0") : contentAreaEntry.getAreapageInsId()).longValue()) continue;
                List fieldEntries = contentAreaEntry.getFieldEntries();
                Boolean bl = areaDisplay = contentAreaEntry.getAreaDisplay() == null ? Boolean.FALSE : contentAreaEntry.getAreaDisplay();
                if (areaDisplay != null && !areaDisplay.booleanValue()) break;
                if (fieldEntries == null) continue;
                for (ContentFieldEntry fieldEntry : fieldEntries) {
                    if (fieldEntry == null) continue;
                    Long areaFieldId = fieldEntry.getAreaFieldId();
                    Boolean fieldDisplay = fieldEntry.getFieldDisplay() == null ? Boolean.FALSE : fieldEntry.getFieldDisplay();
                    Boolean fieldModify = fieldEntry.getFieldModify() == null ? Boolean.FALSE : fieldEntry.getFieldModify();
                    Boolean fieldMustInput = fieldEntry.getFieldMustInput() == null ? Boolean.FALSE : fieldEntry.getFieldMustInput();
                    HashMap<String, Boolean> procPermItemMap = new HashMap<String, Boolean>(16);
                    procPermItemMap.put("fielddisplayitem", fieldDisplay);
                    procPermItemMap.put("fieldmustinputitem", fieldMustInput);
                    procPermItemMap.put("fieldmodifyitem", fieldModify);
                    areaFieldPermMap.put(areaFieldId, procPermItemMap);
                }
            }
        }
        HashMap<String, Map> procPermMap = new HashMap<String, Map>(16);
        if (areaFieldPermMap != null && (fieldArr = AREA_FIELD_ENTITY_SERVICE.queryOriginalArray("id,number", new QFilter[]{filter = new QFilter("id", "in", areaFieldIdSet = areaFieldPermMap.keySet())})) != null) {
            for (DynamicObject fieldDy : fieldArr) {
                if (fieldDy == null) continue;
                String number = fieldDy.getString("number");
                long areaFieldId = fieldDy.getLong("id");
                Map permMap = (Map)areaFieldPermMap.get(areaFieldId);
                procPermMap.put(number, permMap);
            }
        }
        for (Map.Entry next : procPermMap.entrySet()) {
            if (next == null) continue;
            String key = (String)next.getKey();
            Map permObj = (Map)next.getValue();
            Boolean fielddisplayitem = (Boolean)permObj.get("fielddisplayitem");
            Boolean fieldmustinputitem = (Boolean)permObj.get("fieldmustinputitem");
            Boolean fieldmodifyitem = (Boolean)permObj.get("fieldmodifyitem");
            if (!fielddisplayitem.booleanValue()) continue;
            switch (key) {
                case "name": {
                    HashMap<String, Object> nameField = new HashMap<String, Object>(16);
                    nameField.put("id", "name");
                    nameField.put("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"ActEvalObjOverallDomainService_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    nameField.put("key", "name");
                    nameField.put("proptype", FieldTypeEnum.MuliLangText);
                    nameField.put("mustinput", fieldmustinputitem);
                    nameField.put("visible", fielddisplayitem);
                    nameField.put("lock", fieldmodifyitem == false);
                    personInfoFieldsList.add(nameField);
                    break;
                }
                case "number": {
                    HashMap<String, Object> numberField = new HashMap<String, Object>(16);
                    numberField.put("id", "number");
                    numberField.put("name", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ActEvalObjOverallDomainService_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    numberField.put("key", "number");
                    numberField.put("proptype", FieldTypeEnum.Text);
                    numberField.put("mustinput", fieldmustinputitem);
                    numberField.put("visible", fielddisplayitem);
                    numberField.put("lock", fieldmodifyitem == false);
                    personInfoFieldsList.add(numberField);
                    break;
                }
                case "adminorg": {
                    HashMap<String, Object> adminOrgField = new HashMap<String, Object>(16);
                    adminOrgField.put("id", "adminorg");
                    adminOrgField.put("name", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"ActEvalObjOverallDomainService_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    adminOrgField.put("key", "adminorg");
                    adminOrgField.put("proptype", FieldTypeEnum.MuliLangText);
                    adminOrgField.put("mustinput", fieldmustinputitem);
                    adminOrgField.put("visible", fielddisplayitem);
                    adminOrgField.put("lock", fieldmodifyitem == false);
                    personInfoFieldsList.add(adminOrgField);
                    break;
                }
                case "position": {
                    HashMap<String, Object> positionField = new HashMap<String, Object>(16);
                    positionField.put("id", "position");
                    positionField.put("name", ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"ActEvalObjOverallDomainService_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    positionField.put("key", "position");
                    positionField.put("proptype", FieldTypeEnum.MuliLangText);
                    positionField.put("mustinput", fieldmustinputitem);
                    positionField.put("visible", fielddisplayitem);
                    positionField.put("lock", fieldmodifyitem == false);
                    personInfoFieldsList.add(positionField);
                    break;
                }
                case "job": {
                    HashMap<String, Object> jobField = new HashMap<String, Object>(16);
                    jobField.put("id", "job");
                    jobField.put("name", ResManager.loadKDString((String)"\u804c\u4f4d", (String)"ActEvalObjOverallDomainService_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    jobField.put("key", "job");
                    jobField.put("proptype", FieldTypeEnum.MuliLangText);
                    jobField.put("mustinput", fieldmustinputitem);
                    jobField.put("visible", fielddisplayitem);
                    jobField.put("lock", fieldmodifyitem == false);
                    personInfoFieldsList.add(jobField);
                    break;
                }
            }
        }
        HashMap<String, Object> adminOrgIndexField = new HashMap<String, Object>(16);
        adminOrgIndexField.put("id", "adminorgst");
        adminOrgIndexField.put("name", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u6392\u5e8f\u7801", (String)"ActEvalObjOverallDomainService_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        adminOrgIndexField.put("key", "adminorgst");
        adminOrgIndexField.put("proptype", FieldTypeEnum.Text);
        adminOrgIndexField.put("mustinput", Boolean.FALSE);
        adminOrgIndexField.put("visible", Boolean.FALSE);
        adminOrgIndexField.put("lock", Boolean.TRUE);
        personInfoFieldsList.add(adminOrgIndexField);
        HashMap<String, Object> positionIndexField = new HashMap<String, Object>(16);
        positionIndexField.put("id", "positionindex");
        positionIndexField.put("name", ResManager.loadKDString((String)"\u5c97\u4f4d\u6392\u5e8f\u7801", (String)"ActEvalObjOverallDomainService_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        positionIndexField.put("key", "positionindex");
        positionIndexField.put("proptype", FieldTypeEnum.Integer);
        positionIndexField.put("mustinput", Boolean.FALSE);
        positionIndexField.put("visible", Boolean.FALSE);
        positionIndexField.put("lock", Boolean.TRUE);
        personInfoFieldsList.add(positionIndexField);
        return personInfoFieldsList;
    }

    public WorkflowRuProcBo getRuProcInstance(Long evalflowinsId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.getRuProcInstance(evalflowinsId);
    }

    public DynamicObject queryActEvalObjByFlowInsId(Long evalflowinsId) {
        QFilter filter = new QFilter("evalflowins", "=", (Object)evalflowinsId);
        return ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.queryOne("id, person.id", new QFilter[]{filter});
    }

    public Map<Long, Long> getUserIdsByPersonIds(List<Long> personIds) {
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(16);
        HashMap<String, List<Long>> personIdMap = new HashMap<String, List<Long>>(16);
        personIdMap.put("person", personIds);
        Map userIdByPersonInfo = new HashMap(16);
        try {
            userIdByPersonInfo = PERSON_SERVICE.getUserIdByPersonInfo(personIdMap);
        }
        catch (Exception e) {
            LOG.error("\u3010OPMC\u3011-getUserIdsByPersonIds error,personIds:{}", personIds);
            LOG.error((Throwable)e);
        }
        if (userIdByPersonInfo.isEmpty()) {
            return retMap;
        }
        Boolean success = (Boolean)userIdByPersonInfo.get("success");
        if (success.booleanValue()) {
            Map userInfo = (Map)userIdByPersonInfo.get("data");
            ArrayList<Long> userIds = new ArrayList<Long>(personIds.size());
            for (Long personId : personIds) {
                Map user = (Map)userInfo.get(personId);
                if (user == null) continue;
                Long userId = (Long)user.get("user");
                userIds.add(userId);
            }
            Map<Long, Boolean> userIsEnableMap = this.batchQueryUserIsEnable(userIds);
            for (Long personId : personIds) {
                Long userId;
                Map user = (Map)userInfo.get(personId);
                if (user == null || !userIsEnableMap.getOrDefault(userId = (Long)user.get("user"), false).booleanValue()) continue;
                retMap.put(personId, userId);
            }
        }
        return retMap;
    }

    private Map<Long, Boolean> batchQueryUserIsEnable(List<Long> userIds) {
        List userInfo = UserServiceHelper.get(userIds, (String[])new String[]{"id", "isforbidden", "enable"}, null);
        HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>(16);
        if (CollectionUtils.isEmpty((Collection)userInfo)) {
            return ret;
        }
        for (Map user : userInfo) {
            ret.put((Long)user.get("id"), (Boolean)user.get("isforbidden") == false && "1".equals(user.get("enable")));
        }
        return ret;
    }

    public DynamicObject queryPerfLevelById(Long sumperfLevelId) {
        return PERF_LEVEL_ENTITY.queryOne((Object)sumperfLevelId);
    }

    public DynamicObject querySumAreaEvalRecordOfPreRoleLastTask(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return null;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Map<Long, Long> roleMap = this.queryPreNodeLastRoleMap(taskId);
            return this.queryLastTaskSumAreaEvalRecord(roleMap);
        }
        HashMap<Long, Long> sortRoleMap = new HashMap<Long, Long>(16);
        DynamicObject maxSortRole = null;
        for (DynamicObject role : roles) {
            if (role == null) continue;
            if (maxSortRole == null) {
                maxSortRole = role;
            }
            int turnOverSort = role.getInt("turnoversort");
            int maxTurnOverSort = maxSortRole.getInt("turnoversort");
            if (maxTurnOverSort != turnOverSort) continue;
            sortRoleMap.put(role.getLong("flowdefrole.id"), role.getLong("id"));
        }
        return this.queryLastTaskSumAreaEvalRecord(sortRoleMap);
    }

    private DynamicObject queryLastTaskSumAreaEvalRecord(Map<Long, Long> sortRoleMap) {
        DynamicObject dynamicObject;
        Long lastTaskIdOfFinish;
        Set<Long> defRoleIdSet = sortRoleMap.keySet();
        ArrayList<Long> scoreNextRoleIdList = new ArrayList<Long>(10);
        Map roleConfigBoMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(defRoleIdSet);
        HashMap<Long, Boolean> isCarryLevelMap = new HashMap<Long, Boolean>(16);
        HashMap<Long, Boolean> isCarryEvaluMap = new HashMap<Long, Boolean>(16);
        if (roleConfigBoMap != null) {
            for (Map.Entry next : roleConfigBoMap.entrySet()) {
                Boolean isevaluatenext;
                NodeRoleConfigBo roleConfigBo;
                if (next == null || (roleConfigBo = (NodeRoleConfigBo)next.getValue()) == null) continue;
                Long runRoleId = sortRoleMap.get(next.getKey());
                Boolean isgradenext = roleConfigBo.getIsgradenext();
                if (isgradenext != null && isgradenext.booleanValue()) {
                    isCarryLevelMap.put(runRoleId, true);
                    scoreNextRoleIdList.add(runRoleId);
                }
                if ((isevaluatenext = roleConfigBo.getIsevaluatenext()) == null || !isevaluatenext.booleanValue()) continue;
                isCarryEvaluMap.put(runRoleId, true);
                if (scoreNextRoleIdList.contains(runRoleId)) continue;
                scoreNextRoleIdList.add(runRoleId);
            }
        }
        if ((lastTaskIdOfFinish = this.queryLastTaskIdByRoleIds(scoreNextRoleIdList)) != null && (dynamicObject = this.querySumAreaEvalRecord(lastTaskIdOfFinish)) != null) {
            DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(lastTaskIdOfFinish);
            long flowRuRoleId = taskObj.getLong("flowrurole.id");
            if (isCarryEvaluMap.get(flowRuRoleId) == null || !((Boolean)isCarryEvaluMap.get(flowRuRoleId)).booleanValue()) {
                dynamicObject.set("eval", null);
            } else if (isCarryLevelMap.get(flowRuRoleId) == null || !((Boolean)isCarryLevelMap.get(flowRuRoleId)).booleanValue()) {
                dynamicObject.set("ole", null);
            }
            return dynamicObject;
        }
        return null;
    }

    public DynamicObject[] queryGenRecordByActEvalObjId(Long actEvalObjId) {
        QFilter taskFilter = new QFilter("actevalobj", "in", (Object)actEvalObjId);
        QFilter taskStatus = new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        return GEN_AREA_RECORD_ENTITY.query("id, flowrutask", new QFilter[]{taskFilter, taskStatus}, "modifytime desc");
    }
}

