/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.evaluating.entityservice;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.pbs.business.domain.OpmcEntityService;

public class ObjNodeResEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("epa_objnoderes");

    public static ObjNodeResEntityService getInstance() {
        return ServiceFactory.getService(ObjNodeResEntityService.class);
    }

    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public void saveNodeRes(DynamicObject actEvalObj, BigDecimal sont, Long ruNodeId) {
        this.deleteByRuNodeId(ruNodeId);
        DynamicObject nodeRes = this.generateEmptyDynamicObject();
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        nodeRes.set("creator", (Object)userId);
        nodeRes.set("createtime", (Object)date);
        nodeRes.set("modifier", (Object)userId);
        nodeRes.set("modifytime", (Object)date);
        nodeRes.set("flowruproc", actEvalObj.get("evalflowins.id"));
        nodeRes.set("flowrunode", (Object)ruNodeId);
        nodeRes.set(AssessScoreAbbrEnum.SONT.getCode(), (Object)sont);
        nodeRes.set("assessyear", actEvalObj.get("assessyear"));
        nodeRes.set("assessperiod", actEvalObj.get("assessperiod"));
        nodeRes.set("activity", actEvalObj.get("activity.id"));
        nodeRes.set("perforg", actEvalObj.get("perforg.id"));
        nodeRes.set("actevalobj", actEvalObj.get("id"));
        this.saveOne(nodeRes);
    }

    private void deleteByRuNodeId(Long ruNodeId) {
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)ruNodeId);
        this.deleteByFilter(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryNodeResByProcId(Long ruProcId) {
        QFilter qFilter = new QFilter("flowruproc", "=", (Object)ruProcId);
        return this.queryOriginalArray("flowrunode, sont", new QFilter[]{qFilter});
    }

    public DynamicObject[] querySontByActObjId(List<Long> actObjIds) {
        QFilter qFilter = new QFilter("actevalobj", "in", actObjIds);
        return this.query("sont", new QFilter[]{qFilter});
    }
}

