/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.evaluating.service;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.openapi.common.util.Pair;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.application.service.dynpermission.DynPermissionConfigService;
import kd.opmc.epa.business.application.service.evaloverall.ActEvalObjOverallApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAttachAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjSumAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.EvalModeEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.business.domain.assessrule.entityservice.AreaFieldEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.NormalConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.PlusMinusConfigEntityService;
import kd.opmc.epa.business.domain.evaladjustment.entity.EvalAdjustmentEntityService;
import kd.opmc.epa.business.domain.evaladjustment.service.ActEvalObjAdjDomainService;
import kd.opmc.epa.business.domain.evaloverall.entity.ProcessPermsettingEntityService;
import kd.opmc.epa.business.domain.evaloverall.service.ActEvalObjOverallDomainService;
import kd.opmc.epa.business.domain.evaluating.entity.ContentAreaEntryEvaDto;
import kd.opmc.epa.business.domain.evaluating.entity.IndicatorEvalRecordBo;
import kd.opmc.epa.business.domain.evaluating.entity.RuTaskEvalBo;
import kd.opmc.epa.business.domain.evaluating.entityservice.ActevalObjAreaEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAddSubAreaRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAddSubEvalRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAttachAreaRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAttachEvalRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjCustomAreaInsEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjGenAreaRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjGenEvalRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjProcessPermSettingEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjSumAreaRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.extpoint.IIsUpdateSoeService;
import kd.opmc.epa.business.domain.evaluating.extpoint.impl.IsUpdateSoeServiceImpl;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.assessrule.EvalWayEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.common.enums.evaloverall.EvalTypeEnum;
import kd.opmc.epa.common.enums.evaloverall.ProcPermContentEnum;
import kd.opmc.epa.common.enums.per.NodeTypeEnum;
import kd.opmc.epa.common.vo.dynpermission.ContentAreaEntry;
import kd.opmc.epa.common.vo.dynpermission.ContentFieldEntry;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.ScoreSystemEntityService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowPreTaskResultBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.BatchTaskmapEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;
import kd.opmc.pbs.business.model.NodeRoleConfigBo;

public class ActEvalObjDetailDomainService {
    private static final Log LOG = LogFactory.getLog(ActEvalObjDetailDomainService.class);
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SEC_PROC_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    private static final ObjSumAreaRecordEntityService OBJ_SUM_AREA_RECORD_ENTITY_SERVICE = ObjSumAreaRecordEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUN_SUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    private static final AssessFormDomainService ASSESS_FORM_DOMAIN_SERVICE = AssessFormDomainService.getInstance();
    private static final ObjSumAreaRecordEntityService SUM_AREA_RECORD_ENTITY = ObjSumAreaRecordEntityService.getInstance();
    private static final ObjAddSubAreaRecordEntityService ADD_SUBAREA_RECORD_ENTITY = ObjAddSubAreaRecordEntityService.getInstance();
    private static final ObjGenAreaRecordEntityService GEN_AREA_RECORD_ENTITY = ObjGenAreaRecordEntityService.getInstance();
    private static final ObjAttachAreaRecordEntityService ATTACH_AREA_RECORD_ENTITY = ObjAttachAreaRecordEntityService.getInstance();
    private static final ObjCustomAreaInsEntityService CUSTOM_AREA_RECORD_ENTITY = ObjCustomAreaInsEntityService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY = PerfLevelEntityService.getInstance();
    private static final ScoreSystemEntityService SCORE_SYSTEM_ENTITY = ScoreSystemEntityService.getInstance();
    private static final ObjGenAreaIndicatorEntityService GEN_AREA_INDICATOR_ENTITY = ObjGenAreaIndicatorEntityService.getInstance();
    private static final ObjAddSubAreaIndicatorEntityService ADD_SUB_AREA_INDICATOR_ENTITY = ObjAddSubAreaIndicatorEntityService.getInstance();
    private static final ObjAttachAreaIndicatorEntityService ATTACH_AREA_INDICATOR_ENTITY = ObjAttachAreaIndicatorEntityService.getInstance();
    private static final Map<AreaRegEnum, OpmcEntityService> AREA_INDICATOR_ENTITY_MAP = new HashMap<AreaRegEnum, OpmcEntityService>(16);
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY = ExecuteSchemeEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY = AssessFormEntityService.getInstance();
    private static final BatchTaskmapEntityService BATCH_TASKMAP_ENTITY_SERVICE = BatchTaskmapEntityService.getInstance();
    private static final AssessActivityEntityService ASSESS_ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final ObjGenAreaInsEntityService OBJ_GEN_AREA_INS_ENTITY_SERVICE = ObjGenAreaInsEntityService.getInstance();
    private static final ObjAddSubAreaInsEntityService OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE = ObjAddSubAreaInsEntityService.getInstance();
    private static final ObjAddSubAreaRecordEntityService OBJ_ADD_SUB_AREA_RECORD_ENTITY_SERVICE = ObjAddSubAreaRecordEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE = ActivityEvaluationObjectEntityService.getInstance();
    private static final ProcessPermsettingEntityService PROCESS_PERMSETTING_ENTITY_SERVICE = ProcessPermsettingEntityService.getInstance();
    private static final ObjSumAreaInsEntityService OBJ_SUM_AREA_INS_ENTITY_SERVICE = ObjSumAreaInsEntityService.getInstance();
    private static final ActEvalObjOverallDomainService ACT_EVAL_OBJ_OVERALL_DOMAIN_SERVICE = ActEvalObjOverallDomainService.getInstance();
    private static final ObjProcessPermSettingEntityService PROCESS_PERM_SETTING_ENTITY_SERVICE = ObjProcessPermSettingEntityService.getInstance();
    private static final ActEvalObjAdjDomainService ACT_EVAL_OBJ_ADJ_DOMAIN_SERVICE = ActEvalObjAdjDomainService.getInstance();
    private static final EvalAdjustmentEntityService EVAL_ADJUSTMENT_ENTITY = EvalAdjustmentEntityService.getInstance();
    private static final ObjNodeResEntityService OBJ_NODE_RES_ENTITY_SERVICE = ObjNodeResEntityService.getInstance();
    private static final NormalConfigEntityService NORMAL_CONFIG_ENTITY_SERVICE = NormalConfigEntityService.getInstance();
    private static final PlusMinusConfigEntityService PLUS_MINUS_CONFIG_ENTITY_SERVICE = PlusMinusConfigEntityService.getInstance();
    private static final IHRPIPersonService PERSON_SERVICE = IHRPIPersonService.getInstance();
    private static final AreaFieldEntityService AREA_FIELD_ENTITY_SERVICE = AreaFieldEntityService.getInstance();
    private static final ObjGenEvalRecordEntityService GEN_EVAL_RECORD_ENTITY;
    private static final ObjAddSubEvalRecordEntityService ADD_SUB_EVAL_RECORD_ENTITY;
    private static final ObjAttachEvalRecordEntityService ATTACH_EVAL_RECORD_ENTITY;
    private static final Map<AreaRegEnum, OpmcEntityService> IND_RECORD_ENTITY_MAP;
    private static final String RECORD_SELECT_PROPERTIES = "modifytime, ole, ose, eval, actevalobj, flowrutask.taskstatus, flowrutask.handler, flowrunode, flowrurole";
    private static final ActEvalObjOverallApplicationService ACT_EVAL_OBJ_OVERALL_APPLICATION_SERVICE;
    private static final Map<Long, OpmcEntityService> AREA_RECORD_ENTITYSERVICE_MAP;
    private static final ActevalObjAreaEntityService ACTEVAL_OBJ_AREAENTITY_SERVICE;
    private static String[] SYNC_FIELDS;
    private static String[] CUSTOM_SYNC_FIELDS;
    private static String[] CUSTOM_LANG_FIELDS;
    private static String[] CUSTOM_ATTACH_FIELDS;
    private static String[] ATTACH_FIELDS;
    private static String[] ATTACH_SYNC_ENTRYFIELDS;
    private static String[] ADDSUB_FIELDS;
    private static String[] ADDSUB_SYNC_ENTRYFIELDS;
    private static String[] GEN_FIELDS;
    private static String[] GEN_SYNC_ENTRYFIELDS;

    public static ActEvalObjDetailDomainService getInstance() {
        return ServiceFactory.getService(ActEvalObjDetailDomainService.class);
    }

    public static DynamicObject queryActivityById(Long activityId) {
        QFilter activityFilter = new QFilter("id", "=", (Object)activityId);
        return ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("name, assessform, dynamicpermission", new QFilter[]{activityFilter});
    }

    public void releaseViewLock(Long taskId, Long handlerId) {
        long userId;
        if (taskId == null || taskId == 0L || handlerId == null) {
            return;
        }
        Long nodeId = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeId(taskId);
        DataMutex dataMutex = DataMutex.create();
        Map lockInfoMap = dataMutex.getLockInfo(nodeId.toString(), "default_netctrl", "epa_actevalobj");
        if (lockInfoMap != null && (userId = Long.parseLong((String)lockInfoMap.get("userid"))) != 0L && handlerId.equals(userId)) {
            MutexHelper.release((String)"epa_actevalobj", (String)"nodeview", (String)nodeId.toString());
        }
    }

    public static Map<Long, String> queryAnonymity(Long procPermId) {
        HashMap<Long, String> anonymityMap = new HashMap<Long, String>(16);
        QFilter procPermFilter = new QFilter("id", "=", (Object)procPermId);
        procPermFilter.and(new QFilter("scopeareaentry.scorecontent.number", "=", (Object)ProcPermContentEnum.ANONYMOUS.getCode()));
        DataSet procPermDataSet = PROCESS_PERMSETTING_ENTITY_SERVICE.queryDataSet("epa_processpermsetting", "scopeareaentry.aflowdefnode, scopeareaentry.scorecontent.number, scopeareaentry.scoreshowarea.number", new QFilter[]{procPermFilter});
        for (Row row : procPermDataSet) {
            Long aflowdefnode = row.getLong("scopeareaentry.aflowdefnode");
            String scoreContent = row.getString("scopeareaentry.scoreshowarea.number");
            anonymityMap.put(aflowdefnode, scoreContent);
        }
        procPermDataSet.close();
        return anonymityMap;
    }

    public static Map<String, Object> queryPermissionConfig(Long taskId) {
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowruproc, flowrunode, flowrunode.index,flowrurole", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("executescheme, processpermsetting,dynamicpermission", new QFilter[]{activityFilter});
        QFilter flowrunodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject flowrunodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{flowrunodeFilter});
        Long procPermId = activityObj.getLong("dynamicpermission.id");
        Map<String, Object> permissionConfig = PROCESS_PERM_SETTING_ENTITY_SERVICE.queryProcessPermSettingScopeNew(procPermId, flowrunodeObj.getLong("flownodedef.id"));
        permissionConfig.put("flowrunodeId", flowruTaskObj.getLong("flowrunode.id"));
        permissionConfig.put("flowrunodeIndex", flowrunodeObj.getInt("index"));
        permissionConfig.put("flowruroleId", flowruTaskObj.getLong("flowrurole.id"));
        permissionConfig.put("turnoversort", flowruTaskObj.getInt("flowrurole.turnoversort"));
        return permissionConfig;
    }

    public Pair<Boolean, String> checkTaskInfo(Long taskId) {
        if (StringUtils.isEmpty((CharSequence)String.valueOf(taskId))) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ActEvalObjDetailDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        DynamicObject taskDy = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        long userId = RequestContext.get().getCurrUserId();
        if (ObjectUtils.isEmpty((Object)taskDy) || userId != taskDy.getLong("handler.id")) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ActEvalObjDetailDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        String flowStatus = taskDy.getString("flowruproc.procstatus");
        if (StringUtils.equals((CharSequence)flowStatus, (CharSequence)FlowRuProcStatusEnum.STOP.getCode())) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8bc4\u4f30\u6d41\u7a0b\u201c{0}\u201d\u6062\u590d\u6b63\u5e38\u540e\uff0c\u8bc4\u4f30\u4efb\u52a1\u5c06\u91cd\u65b0\u53d1\u9001\uff0c\u5c4a\u65f6\u53ef\u518d\u6b21\u8bc4\u4f30\u3002", (String)"ActEvalObjDetailDomainService_1", (String)"opmc-epa-business", (Object[])new Object[]{FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)flowStatus).getText()}));
        }
        if (StringUtils.equals((CharSequence)flowStatus, (CharSequence)FlowRuProcStatusEnum.DEPRECATED.getCode())) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ActEvalObjDetailDomainService_2", (String)"opmc-epa-business", (Object[])new Object[]{FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)flowStatus).getText()}));
        }
        FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskDy.getString("taskstatus"));
        if (taskStatus == FlowRuTaskStatusEnum.REJECTED || taskStatus == FlowRuTaskStatusEnum.EXPIRED) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ActEvalObjDetailDomainService_2", (String)"opmc-epa-business", (Object[])new Object[]{taskStatus.getText()}));
        }
        return new Pair((Object)Boolean.TRUE, (Object)"");
    }

    public Pair<Boolean, String> checkTaskInfo(Long taskId, String strType) {
        if (StringUtils.isEmpty((CharSequence)String.valueOf(taskId))) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ActEvalObjDetailDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        DynamicObject taskDy = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        long userId = RequestContext.get().getCurrUserId();
        if (ObjectUtils.isEmpty((Object)taskDy) || userId != taskDy.getLong("handler.id")) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ActEvalObjDetailDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        String flowStatus = taskDy.getString("flowruproc.procstatus");
        if (StringUtils.equals((CharSequence)flowStatus, (CharSequence)FlowRuProcStatusEnum.STOP.getCode())) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"{0}\u6d41\u7a0b{1}\uff0c{2}\u6d41\u7a0b\u6062\u590d\u6b63\u5e38\u540e\u5c06\u53d1\u9001\u901a\u77e5\u6d88\u606f\u7ed9\u60a8\uff0c\u4e4b\u540e\u60a8\u53ef\u518d{3}", (String)"ActEvalObjDetailDomainService_3", (String)"opmc-epa-business", (Object[])new Object[]{strType, FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)flowStatus).getText(), strType, strType}));
        }
        if (StringUtils.equals((CharSequence)flowStatus, (CharSequence)FlowRuProcStatusEnum.DEPRECATED.getCode())) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"{0}\u6d41\u7a0b{1}\uff0c\u5df2\u65e0\u9700{2}", (String)"ActEvalObjDetailDomainService_4", (String)"opmc-epa-business", (Object[])new Object[]{strType, FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)flowStatus).getText(), strType}));
        }
        FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskDy.getString("taskstatus"));
        if (taskStatus == FlowRuTaskStatusEnum.REJECTED || taskStatus == FlowRuTaskStatusEnum.EXPIRED) {
            return new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"{0}\u4efb\u52a1{1}\uff0c\u65e0\u9700\u5904\u7406\u3002", (String)"ActEvalObjDetailDomainService_5", (String)"opmc-epa-business", (Object[])new Object[]{strType, taskStatus.getText()}));
        }
        return new Pair((Object)Boolean.TRUE, (Object)"");
    }

    public Map<String, Object> checkTaskList(List<Long> taskIdList) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        ArrayList<Long> checkedTaskList = new ArrayList<Long>(10);
        ArrayList<Object> errorMsgList = new ArrayList<Object>(10);
        for (Long taskId : taskIdList) {
            Pair<Boolean, String> checkResult = this.checkTaskInfo(taskId);
            if (((Boolean)checkResult.getKey()).booleanValue()) {
                result.put("status", Boolean.TRUE);
                checkedTaskList.add(taskId);
                continue;
            }
            errorMsgList.add(checkResult.getValue());
        }
        if (checkedTaskList.size() > 0) {
            result.put("checkedTaskList", checkedTaskList);
            return result;
        }
        if (errorMsgList.contains("not_exist")) {
            result.put("errorMsg", ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548", (String)"ActEvalObjDetailDomainService_6", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        if (errorMsgList.contains("stop")) {
            result.put("errorMsg", ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u6682\u505c", (String)"ActEvalObjDetailDomainService_7", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        if (errorMsgList.contains("not_exist")) {
            result.put("errorMsg", ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728", (String)"ActEvalObjDetailDomainService_8", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        return result;
    }

    public DynamicObject queryAssessForm(long assessFormId) {
        return ASSESS_FORM_DOMAIN_SERVICE.queryAssessForm(assessFormId);
    }

    public OperationStatus getViewStatusOfTask(Long taskId) {
        DynamicObject taskDy = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskDy.getString("taskstatus"));
        if (taskStatus == FlowRuTaskStatusEnum.PROCESSING || taskStatus == FlowRuTaskStatusEnum.WAITING) {
            return OperationStatus.EDIT;
        }
        return OperationStatus.VIEW;
    }

    public boolean submitEvalTask(String taskId) {
        this.checkEvalTaskAndProcStatus(taskId);
        Map resultMap = FLOW_RU_PROC_DOMAIN_SERVICE.submitTask(Collections.singletonList(Long.parseLong(taskId)));
        if (resultMap != null) {
            Boolean success = (Boolean)resultMap.get(Long.valueOf(taskId));
            if (success != null) {
                return success;
            }
            return false;
        }
        return false;
    }

    public FlowRuTaskStatusEnum getTaskStatus(String taskId) {
        if (HRStringUtils.isBlank((CharSequence)taskId)) {
            return FlowRuTaskStatusEnum.EXPIRED;
        }
        DynamicObject evalTask = FLOW_RU_PROC_DOMAIN_SERVICE.getEvalTask(Long.parseLong(taskId));
        return FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)evalTask.getString("taskstatus"));
    }

    public FlowRuTaskStatusEnum getTaskStatusForCheck(List<Long> taskIds) {
        if (taskIds == null || taskIds.isEmpty()) {
            return FlowRuTaskStatusEnum.EXPIRED;
        }
        DynamicObject[] evalTasks = FLOW_RU_PROC_DOMAIN_SERVICE.getEvalTasks(taskIds);
        if (evalTasks != null) {
            for (DynamicObject evalTask : evalTasks) {
                FlowRuTaskStatusEnum taskStatusEnum;
                if (evalTask == null || (taskStatusEnum = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)evalTask.getString("taskstatus"))) == null) continue;
                String statusCode = taskStatusEnum.getCode();
                if (!FlowRuTaskStatusEnum.RETURNED.getCode().equals(statusCode) && !FlowRuTaskStatusEnum.EXPIRED.getCode().equals(statusCode) && !FlowRuTaskStatusEnum.PROCESSED.getCode().equals(statusCode)) continue;
                return taskStatusEnum;
            }
        }
        return null;
    }

    public void checkEvalTaskAndProcStatus(String taskId) {
        DynamicObject ruProc;
        if (HRStringUtils.isBlank((CharSequence)taskId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ActEvalObjDetailDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        DynamicObject evalTask = FLOW_RU_PROC_DOMAIN_SERVICE.getEvalTask(Long.parseLong(taskId));
        long userId = RequestContext.get().getCurrUserId();
        if (ObjectUtils.isEmpty((Object)evalTask) || userId != evalTask.getLong("handler.id")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ActEvalObjDetailDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)evalTask.getString("taskstatus"));
        if (taskStatus != null) {
            String statusCode = taskStatus.getCode();
            if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(statusCode) || FlowRuTaskStatusEnum.EXPIRED.getCode().equals(statusCode) || FlowRuTaskStatusEnum.PROCESSED.getCode().equals(statusCode)) {
                String res = ResManager.loadKDString((String)"\u8bc4\u4f30\u4efb\u52a1{0}\uff0c\u4e0d\u652f\u6301\u63d0\u4ea4\u3002", (String)"ActEvalObjDetailDomainService_9", (String)"opmc-epa-business", (Object[])new Object[]{taskStatus.getText()});
                throw new KDBizException(res);
            }
        }
        if ((ruProc = evalTask.getDynamicObject("flowruproc")) != null) {
            String procStatus = ruProc.getString("procstatus");
            if (FlowRuProcStatusEnum.STOP.getCode().equals(procStatus)) {
                String tips = ResManager.loadKDString((String)"\u8bc4\u4f30\u6d41\u7a0b\u201c{0}\u201d\u6062\u590d\u6b63\u5e38\u540e\uff0c\u8bc4\u4f30\u4efb\u52a1\u5c06\u91cd\u65b0\u53d1\u9001\uff0c\u5c4a\u65f6\u53ef\u518d\u6b21\u8bc4\u4f30\u3002", (String)"ActEvalObjDetailDomainService_1", (String)"opmc-epa-business", (Object[])new Object[]{FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)procStatus).getText()});
                throw new KDBizException(tips);
            }
            if (FlowRuProcStatusEnum.DEPRECATED.getCode().equals(procStatus)) {
                String tips = ResManager.loadKDString((String)"\u8bc4\u4f30\u6d41\u7a0b{0}\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u63d0\u4ea4\u3002", (String)"ActEvalObjDetailDomainService_10", (String)"opmc-epa-business", (Object[])new Object[]{FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)procStatus).getText()});
                throw new KDBizException(tips);
            }
        }
    }

    public void checkEvalTaskAndProcStatus(List<Long> taskIdList) {
        if (taskIdList == null || taskIdList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ActEvalObjDetailDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        DynamicObject[] evalTasks = FLOW_RU_PROC_DOMAIN_SERVICE.getEvalTasks(taskIdList);
        long userId = RequestContext.get().getCurrUserId();
        if (evalTasks != null) {
            for (DynamicObject evalTask : evalTasks) {
                DynamicObject ruProc;
                if (evalTask == null) continue;
                if (ObjectUtils.isEmpty((Object)evalTask) || userId != evalTask.getLong("handler.id")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ActEvalObjDetailDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
                }
                FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)evalTask.getString("taskstatus"));
                if (taskStatus != null) {
                    String statusCode = taskStatus.getCode();
                    if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(statusCode) || FlowRuTaskStatusEnum.EXPIRED.getCode().equals(statusCode) || FlowRuTaskStatusEnum.PROCESSED.getCode().equals(statusCode)) {
                        String res = ResManager.loadKDString((String)"\u8bc4\u4f30\u4efb\u52a1{0}\uff0c\u4e0d\u652f\u6301\u63d0\u4ea4\u3002", (String)"ActEvalObjDetailDomainService_9", (String)"opmc-epa-business", (Object[])new Object[]{taskStatus.getText()});
                        throw new KDBizException(res);
                    }
                }
                if ((ruProc = evalTask.getDynamicObject("flowruproc")) == null) continue;
                String procStatus = ruProc.getString("procstatus");
                if (FlowRuProcStatusEnum.STOP.getCode().equals(procStatus)) {
                    String tips = ResManager.loadKDString((String)"\u8bc4\u4f30\u6d41\u7a0b\u201c{0}\u201d\u6062\u590d\u6b63\u5e38\u540e\uff0c\u8bc4\u4f30\u4efb\u52a1\u5c06\u91cd\u65b0\u53d1\u9001\uff0c\u5c4a\u65f6\u53ef\u518d\u6b21\u8bc4\u4f30\u3002", (String)"ActEvalObjDetailDomainService_1", (String)"opmc-epa-business", (Object[])new Object[]{FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)procStatus).getText()});
                    throw new KDBizException(tips);
                }
                if (!FlowRuProcStatusEnum.DEPRECATED.getCode().equals(procStatus)) continue;
                String tips = ResManager.loadKDString((String)"\u8bc4\u4f30\u6d41\u7a0b{0}\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u63d0\u4ea4\u3002", (String)"ActEvalObjDetailDomainService_10", (String)"opmc-epa-business", (Object[])new Object[]{FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)procStatus).getText()});
                throw new KDBizException(tips);
            }
        }
    }

    public FlowValidateResultBo rollBackEvalTask(List<Long> taskIds, String reason) {
        return FLOW_RU_SEC_PROC_DOMAIN_SERVICE.batchRollbackTasks(taskIds, reason);
    }

    public FlowValidateResultBo rollBackTargetTask(List<RollbackParamBo> rollbackParamBos) {
        return FLOW_RU_SEC_PROC_DOMAIN_SERVICE.rollbackToSpecifiedTask(rollbackParamBos);
    }

    public boolean isEvalTaskProcStatusPending(Long taskId) {
        String procStatus = ActEvalObjDetailDomainService.getTaskProcStatus(taskId);
        return FlowRuProcStatusEnum.PENDING.getCode().equals(procStatus);
    }

    public boolean isEvalTaskProcStatusStop(Long taskId) {
        String procStatus = ActEvalObjDetailDomainService.getTaskProcStatus(taskId);
        return FlowRuProcStatusEnum.STOP.getCode().equals(procStatus);
    }

    public boolean isEvalTaskProcStatusDeprecated(Long taskId) {
        String procStatus = ActEvalObjDetailDomainService.getTaskProcStatus(taskId);
        return FlowRuProcStatusEnum.DEPRECATED.getCode().equals(procStatus);
    }

    private static String getTaskProcStatus(Long taskId) {
        if (taskId == null) {
            return null;
        }
        DynamicObject procDynamicObj = FLOW_RU_PROC_DOMAIN_SERVICE.getTaskProcDynamicObj(taskId);
        if (procDynamicObj == null) {
            return null;
        }
        return procDynamicObj.getString("procstatus");
    }

    public DynamicObject[] querySumAreaEvalRecord(long evalObjId) {
        QFilter evalObjFilter = new QFilter("actevalobj", "=", (Object)evalObjId);
        DynamicObject[] recordDys = SUM_AREA_RECORD_ENTITY.query(RECORD_SELECT_PROPERTIES, new QFilter[]{evalObjFilter});
        return (DynamicObject[])Arrays.stream(recordDys).filter(recordDy -> HRStringUtils.equals((String)recordDy.getString("flowrutask.taskstatus"), (String)FlowRuTaskStatusEnum.PROCESSED.getCode())).toArray(DynamicObject[]::new);
    }

    public DynamicObject[] querySumAreaEvalRecordDesc(long evalObjId) {
        QFilter evalObjFilter = new QFilter("actevalobj", "=", (Object)evalObjId);
        return SUM_AREA_RECORD_ENTITY.query(RECORD_SELECT_PROPERTIES, new QFilter[]{evalObjFilter}, "modifytime desc");
    }

    public DynamicObject[] querySumAreaEvalRecordBatch(List<Long> actEvaObjIds) {
        QFilter evalObjFilter = new QFilter("actevalobj", "in", actEvaObjIds);
        return SUM_AREA_RECORD_ENTITY.query(RECORD_SELECT_PROPERTIES, new QFilter[]{evalObjFilter}, "modifytime desc");
    }

    public DynamicObject queryTaskInfo(Long taskId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
    }

    public DynamicObject[] queryTaskInfos(List<Long> taskIds) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPks(taskIds);
    }

    public DynamicObject querySumConfInfoById(long sumConfId) {
        return ASSESS_FORM_DOMAIN_SERVICE.querySumConfigByPk(sumConfId);
    }

    public Long queryLastNodeTaskByRoleProp(Long taskId, String confProp) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryLastNodeTaskByRoleProp(taskId, confProp);
    }

    public DynamicObject querySumAreaEvalRecord(Long actEvalObjId, Long taskId) {
        QFilter evalObjFilter = new QFilter("actevalobj", "=", (Object)actEvalObjId);
        QFilter taskFilter = new QFilter("flowrutask", "=", (Object)taskId);
        return SUM_AREA_RECORD_ENTITY.queryOne(RECORD_SELECT_PROPERTIES, new QFilter[]{evalObjFilter, taskFilter});
    }

    public List<ComboItem> queryPerfLevelByRule(Long assessFormId) {
        DynamicObject assessFormDy = this.queryAssessForm(assessFormId);
        long perfLevelId = assessFormDy.getLong("sumperflevel.id");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        if (perfLevelId == 0L) {
            return comboItems;
        }
        DynamicObject perfLevelDy = PERF_LEVEL_ENTITY.queryOne((Object)perfLevelId);
        DynamicObjectCollection levelConf = perfLevelDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject level : levelConf) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(level.getString("levelname")));
            comboItem.setValue(level.getString("seq"));
            comboItems.add(comboItem);
        }
        return comboItems;
    }

    public NodeRoleConfigBo queryNodeRoleConfigByTask(Long taskId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(taskId);
    }

    public DynamicObject queryNodeRoleByTask(Long taskId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleByTask(taskId);
    }

    public DynamicObject queryScoreSystemById(Long scoreSystemId) {
        return SCORE_SYSTEM_ENTITY.queryOne((Object)scoreSystemId);
    }

    public Map<String, Object> queryAreaEvalRecord(Long taskId) {
        if (taskId == null) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> areaRecordMap = new HashMap<String, Object>(16);
        areaRecordMap.putAll(this.queryAreaRecordMap(GEN_AREA_RECORD_ENTITY, taskId));
        areaRecordMap.putAll(this.queryAreaRecordMap(ADD_SUBAREA_RECORD_ENTITY, taskId));
        areaRecordMap.putAll(this.queryAreaRecordMap(ATTACH_AREA_RECORD_ENTITY, taskId));
        return areaRecordMap;
    }

    public DynamicObject queryCustomAreaEvalRecord(Long taskId) {
        QFilter taskFilter = new QFilter("flowrutask", "=", (Object)taskId);
        return CUSTOM_AREA_RECORD_ENTITY.queryOne("id, customfield1, customfield2, customfield3, customfield4, customfield5, customfield6, customfield7, customfield8, customfield9, customfield10", new QFilter[]{taskFilter});
    }

    private Map<String, Object> queryAreaRecordMap(OpmcEntityService entityService, Long taskId) {
        QFilter taskFilter = new QFilter("flowrutask", "=", (Object)taskId);
        DynamicObject[] genAreaRecords = entityService.query("id, area", new QFilter[]{taskFilter});
        return Arrays.stream(genAreaRecords).collect(Collectors.toMap(areaRecord -> String.valueOf(taskId) + areaRecord.getLong("area.id"), DataEntityBase::getPkValue, (v1, v2) -> v2));
    }

    public DynamicObject[] queryIndicator(Long areaId, AreaRegEnum areaReg, Boolean isCrossEvaluate, List<Long> crossIndicatorIds) {
        OpmcEntityService indicatorEntity = AREA_INDICATOR_ENTITY_MAP.get(areaReg);
        QFilter filter = new QFilter("instanceid", "=", (Object)areaId);
        if (isCrossEvaluate != null && isCrossEvaluate.booleanValue()) {
            ArrayList<Long> indicatorIds = new ArrayList<Long>(10);
            if (crossIndicatorIds != null) {
                indicatorIds.addAll(crossIndicatorIds);
            }
            QFilter idFilter = new QFilter("id", "in", indicatorIds);
            filter.and(idFilter);
        }
        String orderField = "entryseq asc";
        if (areaReg != null && AreaRegEnum.ATTACH_AREA.getAreaPkId().equals(areaReg.getAreaPkId())) {
            String selectProps = "id,realfinishdate,customfield";
            return indicatorEntity.query(selectProps, new QFilter[]{filter}, orderField);
        }
        if (areaReg != null && (AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaReg.getAreaPkId()) || AreaRegEnum.PLUS_MINUS_AREA.getAreaPkId().equals(areaReg.getAreaPkId()))) {
            StringBuilder selectPropBuild = new StringBuilder("id,realfinishdate,qualityres,finishdesc,indctrname,iecs,evalmode");
            if (AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaReg.getAreaPkId())) {
                selectPropBuild.append(",evalmode,minevalscore,maxevalscore,customfiled1,customfiled2,customfiled3,customfiled4,customfiled5");
            }
            return indicatorEntity.query(selectPropBuild.toString(), new QFilter[]{filter}, orderField);
        }
        return indicatorEntity.query(new QFilter[]{filter}, orderField);
    }

    public Map<Long, DynamicObject> queryIndicatorEvalRecord(Long taskId, AreaRegEnum areaReg) {
        OpmcEntityService indRecordEntity = IND_RECORD_ENTITY_MAP.get(areaReg);
        QFilter taskFilter = new QFilter("flowrutask", "=", (Object)taskId);
        DynamicObject[] indRecordDys = indRecordEntity.loadDynamicObjectArray(new QFilter[]{taskFilter});
        return Arrays.stream(indRecordDys).collect(Collectors.toMap(indRecord -> indRecord.getLong("indicator"), Function.identity(), (v1, v2) -> v2));
    }

    public Map<Long, DynamicObject> queryIndicatorEvalRecord(Long taskId, List<Long> indicaterIds, AreaRegEnum areaReg) {
        if (taskId == null || indicaterIds == null) {
            return new HashMap<Long, DynamicObject>(16);
        }
        OpmcEntityService indRecordEntity = IND_RECORD_ENTITY_MAP.get(areaReg);
        QFilter taskFilter = new QFilter("flowrutask", "=", (Object)taskId);
        QFilter indicatorFilter = new QFilter("indicator", "in", indicaterIds);
        taskFilter.and(indicatorFilter);
        DynamicObject[] indRecordDys = indRecordEntity.loadDynamicObjectArray(new QFilter[]{taskFilter});
        return Arrays.stream(indRecordDys).collect(Collectors.toMap(indRecord -> indRecord.getLong("indicator"), Function.identity(), (v1, v2) -> v2));
    }

    public DynamicObject[] queryIndicatorEvalRecord(Long taskId, AreaRegEnum areaReg, Long areaInstanceId) {
        OpmcEntityService indRecordEntity = IND_RECORD_ENTITY_MAP.get(areaReg);
        QFilter taskFilter = new QFilter("flowrutask", "=", (Object)taskId);
        QFilter areaInstanceFilter = new QFilter("area", "=", (Object)areaInstanceId);
        taskFilter.and(areaInstanceFilter);
        DynamicObject[] indRecordDys = indRecordEntity.loadDynamicObjectArray(new QFilter[]{taskFilter});
        return indRecordDys;
    }

    public DynamicObject[] queryIndicatorForActEval(Long areaId, AreaRegEnum areaReg, Boolean isCrossEvaluate, List<Long> crossIndicatorIds) {
        OpmcEntityService indicatorEntity = AREA_INDICATOR_ENTITY_MAP.get(areaReg);
        QFilter filter = new QFilter("instanceid", "=", (Object)areaId);
        if (isCrossEvaluate != null && isCrossEvaluate.booleanValue()) {
            ArrayList<Long> indicatorIds = new ArrayList<Long>(10);
            if (crossIndicatorIds != null) {
                indicatorIds.addAll(crossIndicatorIds);
            }
            QFilter idFilter = new QFilter("id", "in", indicatorIds);
            filter.and(idFilter);
        }
        String orderField = "entryseq asc";
        String selectedFields = "";
        if (areaReg != null && AreaRegEnum.ATTACH_AREA.getAreaPkId().equals(areaReg.getAreaPkId())) {
            String selectProps = "id,realfinishdate,customfield";
            return indicatorEntity.query(selectProps, new QFilter[]{filter}, orderField);
        }
        if (areaReg != null && AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaReg.getAreaPkId())) {
            selectedFields = "id,realfinishdate,qualityres,finishdesc,indctrname,iecs,entryseq,evalmode,minevalscore,maxevalscore,customfiled1,customfiled2,customfiled3,customfiled4,customfiled5";
            filter.and("evalmode", "!=", (Object)EvalModeEnum.SYS_INPUT.getCode());
            return indicatorEntity.query(selectedFields, new QFilter[]{filter}, orderField);
        }
        if (areaReg != null && AreaRegEnum.PLUS_MINUS_AREA.getAreaPkId().equals(areaReg.getAreaPkId())) {
            selectedFields = "id,realfinishdate,qualityres,finishdesc,indctrname,iecs,entryseq";
            return indicatorEntity.query(selectedFields, new QFilter[]{filter}, orderField);
        }
        return indicatorEntity.query(new QFilter[]{filter}, orderField);
    }

    public void saveIndicatorEvalRecord(AreaRegEnum areaReg, DynamicObjectCollection collection) {
        OpmcEntityService indRecordEntity = IND_RECORD_ENTITY_MAP.get(areaReg);
        if (collection != null) {
            indRecordEntity.save(collection);
        }
    }

    public DynamicObject[] queryAreaRecord(Long taskId, Long areaInstanceId) {
        QFilter taskFilter = new QFilter("flowrutask", "=", (Object)taskId);
        QFilter areaInsFilter = new QFilter("area", "=", (Object)areaInstanceId);
        taskFilter.and(areaInsFilter);
        DynamicObject dynamicObject = GEN_AREA_RECORD_ENTITY.loadDynamicObject(taskFilter);
        DynamicObject[] genAreaRecords = GEN_AREA_RECORD_ENTITY.query("id, entryentity.id", new QFilter[]{taskFilter});
        return genAreaRecords;
    }

    public void deleteAreaRecordByPkID(List<Long> idList) {
        if (idList != null && !idList.isEmpty()) {
            QFilter taskFilter = new QFilter("id", "in", idList);
            GEN_AREA_RECORD_ENTITY.deleteByFilter(new QFilter[]{taskFilter});
        }
    }

    public DynamicObject[] queryIndicatorForGen(Long areaId) {
        ObjGenAreaIndicatorEntityService indicatorEntity = GEN_AREA_INDICATOR_ENTITY;
        QFilter filter = new QFilter("instanceid", "=", (Object)areaId);
        filter.and("evalmode", "=", (Object)EvalModeEnum.SYS_INPUT.getCode());
        StringBuilder selectPropBuild = new StringBuilder("id,realfinishdate,qualityres,finishdesc,indctrname,evalmode,iecs,minevalscore,maxevalscore,customfiled1,customfiled2,customfiled3,customfiled4,customfiled5");
        return indicatorEntity.query(selectPropBuild.toString(), new QFilter[]{filter});
    }

    public boolean isExistsAreaRecordByTaskAndAreaId(Long taskId, Long areaId, Long areaTypeId) {
        if (taskId == null || taskId == 0L || areaId == null || areaId == 0L) {
            return false;
        }
        OpmcEntityService opmcEntityService = null;
        if (AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaTypeId)) {
            opmcEntityService = ADD_SUBAREA_RECORD_ENTITY;
        } else if (AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaTypeId)) {
            opmcEntityService = GEN_AREA_RECORD_ENTITY;
        } else if (AssessRuleConstants.ATTACH_AREA_PK.equals(areaTypeId)) {
            opmcEntityService = ATTACH_AREA_RECORD_ENTITY;
        }
        if (opmcEntityService != null) {
            QFilter deleteFilter = new QFilter("flowrutask", "=", (Object)taskId);
            QFilter areaFilter = new QFilter("area", "=", (Object)areaId);
            deleteFilter.and(areaFilter);
            return opmcEntityService.isExists(new QFilter[]{deleteFilter});
        }
        return false;
    }

    public void deleteAreaRecordByTaskAndAreaId(Long taskId, Long areaId, Long areaTypeId) {
        if (taskId == null || taskId == 0L || areaId == null || areaId == 0L) {
            return;
        }
        OpmcEntityService opmcEntityService = null;
        if (AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaTypeId)) {
            opmcEntityService = ADD_SUBAREA_RECORD_ENTITY;
        } else if (AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaTypeId)) {
            opmcEntityService = GEN_AREA_RECORD_ENTITY;
        } else if (AssessRuleConstants.ATTACH_AREA_PK.equals(areaTypeId)) {
            opmcEntityService = ATTACH_AREA_RECORD_ENTITY;
        }
        if (opmcEntityService != null) {
            QFilter deleteFilter = new QFilter("flowrutask", "=", (Object)taskId);
            QFilter areaFilter = new QFilter("area", "=", (Object)areaId);
            deleteFilter.and(areaFilter);
            opmcEntityService.deleteByFilter(new QFilter[]{deleteFilter});
        }
    }

    public boolean isExistsSumAreaRecordByTaskId(Long taskId) {
        if (taskId == null || taskId == 0L) {
            return false;
        }
        QFilter deleteFilter = new QFilter("flowrutask", "=", (Object)taskId);
        return SUM_AREA_RECORD_ENTITY.isExists(new QFilter[]{deleteFilter});
    }

    public void deleteSumAreaRecordByTaskId(Long taskId) {
        if (taskId == null || taskId == 0L) {
            return;
        }
        QFilter deleteFilter = new QFilter("flowrutask", "=", (Object)taskId);
        SUM_AREA_RECORD_ENTITY.deleteByFilter(new QFilter[]{deleteFilter});
    }

    public void saveSumAreaRecord(DynamicObject sumRecordDy) {
        if (sumRecordDy == null) {
            return;
        }
        SUM_AREA_RECORD_ENTITY.saveOne(sumRecordDy);
    }

    public void deleteAddSubAreaRecordByTaskAndAreaId(Long taskId, Long areaId) {
        if (taskId == null || taskId == 0L || areaId == null || areaId == 0L) {
            return;
        }
        QFilter deleteFilter = new QFilter("flowrutask", "=", (Object)taskId);
        QFilter areaFilter = new QFilter("area", "=", (Object)areaId);
        deleteFilter.and(areaFilter);
        GEN_AREA_RECORD_ENTITY.deleteByFilter(new QFilter[]{deleteFilter});
    }

    public void saveAreaRecord(DynamicObject areaRecord, Long areaTypeId) {
        OpmcEntityService opmcEntityService = null;
        if (AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaTypeId)) {
            opmcEntityService = ADD_SUBAREA_RECORD_ENTITY;
        } else if (AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaTypeId)) {
            opmcEntityService = GEN_AREA_RECORD_ENTITY;
        } else if (AssessRuleConstants.ATTACH_AREA_PK.equals(areaTypeId)) {
            opmcEntityService = ATTACH_AREA_RECORD_ENTITY;
        }
        if (opmcEntityService != null && areaRecord != null) {
            opmcEntityService.saveOne(areaRecord);
        }
    }

    public Map<Long, List<DynamicObject>> queryIndicatorEvalRecordHis(List<Long> indicatorIds, AreaRegEnum areaReg) {
        OpmcEntityService indRecordEntity = IND_RECORD_ENTITY_MAP.get(areaReg);
        QFilter indicatorFilter = new QFilter("indicator", "in", indicatorIds);
        QFilter taskFilter = new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        DynamicObject[] indRecordDys = indRecordEntity.query("id,indicator,flowrunode,flowrunode.iscrossnode,flowrurole,evaldesc,soe,modifier,modifytime,realfinishdate", new QFilter[]{taskFilter, indicatorFilter}, "flowrunode.index asc, flowrurole.id asc, modifytime asc");
        return Arrays.stream(indRecordDys).collect(Collectors.groupingBy(indRecord -> indRecord.getLong("indicator"), Collectors.toList()));
    }

    public Map<Long, List<DynamicObject>> queryIndicatorEvalRecordHisDesc(List<Long> indicatorIds, AreaRegEnum areaReg) {
        OpmcEntityService indRecordEntity = IND_RECORD_ENTITY_MAP.get(areaReg);
        QFilter indicatorFilter = new QFilter("indicator", "in", indicatorIds);
        QFilter taskFilter = new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        DynamicObject[] indRecordDys = indRecordEntity.query("id,indicator,flowrutask.id,flowrunode,flowrunode.iscrossnode, flowrurole,evaldesc,soe,modifier,modifier.name,modifier.picturefield,modifytime,realfinishdate", new QFilter[]{taskFilter, indicatorFilter}, "modifytime desc");
        return Arrays.stream(indRecordDys).collect(Collectors.groupingBy(indRecord -> indRecord.getLong("indicator"), Collectors.toList()));
    }

    public BigDecimal queryTaskWeight(Long taskId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskWeight(taskId);
    }

    public DynamicObject queryExecuteScheme(long pkId) {
        return EXECUTE_SCHEME_ENTITY.queryOne(pkId);
    }

    public DynamicObject queryExecuteAssessForm(long pkId) {
        return ASSESS_FORM_ENTITY.queryOne(pkId);
    }

    public String calculateLevel(Long assessFormId, BigDecimal ose) {
        return ASSESS_FORM_DOMAIN_SERVICE.calculateLevel(assessFormId, ose);
    }

    public DynamicObject processTaskAndGetTask(Long taskId) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.processTaskAndGetTask(taskId);
    }

    public boolean processTask(Long taskId) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.processTask(taskId);
    }

    public void syncIndicatorInfo(DynamicObjectCollection recordEntry, AreaRegEnum areaReg, List<Long> excludeIndicatorIds) {
        DynamicObject[] indicators;
        OpmcEntityService indicatorEntity = AREA_INDICATOR_ENTITY_MAP.get(areaReg);
        Map recordMapOfIndicator = recordEntry.stream().collect(Collectors.toMap(record -> record.getLong("indicator.id"), Function.identity(), (v1, v2) -> v2));
        String selectFields = "qualityres, realfinishdate, finishdesc";
        selectFields = AreaRegEnum.NORM_INDCTR_AREA == areaReg ? "qualityres, realfinishdate, finishdesc,customfiled1,customfiled2,customfiled3,customfiled4,customfiled5" : (AreaRegEnum.ATTACH_AREA == areaReg ? "realfinishdate,customfield" : "qualityres, realfinishdate, finishdesc");
        Set<Long> indicatorIdSet = recordMapOfIndicator.keySet();
        if (excludeIndicatorIds != null) {
            indicatorIdSet.removeAll(excludeIndicatorIds);
        }
        QFilter idFilter = new QFilter("id", "in", indicatorIdSet);
        for (DynamicObject indicator : indicators = indicatorEntity.query(selectFields, new QFilter[]{idFilter})) {
            DynamicObject record2 = (DynamicObject)recordMapOfIndicator.get(indicator.getLong("id"));
            if (AreaRegEnum.NORM_INDCTR_AREA == areaReg) {
                indicator.set("qualityres", record2.get("qualityres"));
                indicator.set("realfinishdate", record2.get("realfinishdate"));
                indicator.set("finishdesc", record2.get("finishdesc"));
                indicator.set("customfiled1", record2.get("customfiled1"));
                indicator.set("customfiled2", record2.get("customfiled2"));
                indicator.set("customfiled3", record2.get("customfiled3"));
                indicator.set("customfiled4", record2.get("customfiled4"));
                indicator.set("customfiled5", record2.get("customfiled5"));
                continue;
            }
            if (AreaRegEnum.ATTACH_AREA == areaReg) {
                indicator.set("realfinishdate", record2.get("realfinishdate"));
                indicator.set("customfield", record2.get("customfield"));
                continue;
            }
            indicator.set("qualityres", record2.get("qualityres"));
            indicator.set("realfinishdate", record2.get("realfinishdate"));
            indicator.set("finishdesc", record2.get("finishdesc"));
        }
        indicatorEntity.save(indicators);
    }

    public boolean queryIsFirstNodeAndRole(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return true;
        }
        if (FLOW_RUN_SUP_DOMAIN_SERVICE.queryIsFirstNode(taskId)) {
            long flowRuRoleId = taskObj.getLong("flowrurole.id");
            return this.isFirstRole(flowRuRoleId);
        }
        return false;
    }

    public DynamicObject[] queryLessThanRoleSortRoles(Long flowRuRoleId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryLessThanRoleSortRoles(flowRuRoleId);
    }

    public boolean isFirstRole(Long flowRuRoleId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.isFirstRole(flowRuRoleId);
    }

    public DynamicObject[] queryLessThanRoleSortNotCrossRoles(Long flowRuRoleId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.queryLessThanNotCrossRoleSortRoles(flowRuRoleId);
    }

    public Long queryLastTaskIdByRoleIds(List<Long> ruRoleIds) {
        if (ruRoleIds == null || ruRoleIds.isEmpty()) {
            return null;
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryLastTaskByRoleIds(ruRoleIds);
        if (taskObj == null) {
            return null;
        }
        return taskObj.getLong("id");
    }

    public Long queryPreNodeLastTaskByTaskId(Long taskId) {
        List lastRoleIds = FLOW_RUN_SUP_DOMAIN_SERVICE.queryPreNodeLastRole(taskId);
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryLastTaskByRoleIds(lastRoleIds);
        if (taskObj == null) {
            return null;
        }
        return taskObj.getLong("id");
    }

    public Long queryPreNotCrossNodeLastTaskByTaskId(Long taskId) {
        List lastRoleIds = FLOW_RUN_SUP_DOMAIN_SERVICE.queryPreNotCrossNodeLastRole(taskId);
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryLastTaskByRoleIds(lastRoleIds);
        if (taskObj == null) {
            return null;
        }
        return taskObj.getLong("id");
    }

    public Map<Long, Long> queryPreNodeLastRoleMap(Long taskId) {
        Map roleDefMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryPreNodeLastRoleMap(taskId);
        return roleDefMap;
    }

    public Map<Long, Long> queryPreNotCrossNodeLastRoleMap(Long taskId) {
        Map roleDefMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryPreNotCrossNodeLastRoleMap(taskId);
        return roleDefMap;
    }

    public Map<Long, DynamicObject> queryIndicatorEvalRecordOfPreRoleLastTask(Long taskId, AreaRegEnum areaRegEnum) {
        if (areaRegEnum == null) {
            return new HashMap<Long, DynamicObject>(16);
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        Map<Object, Object> indEvalRecordMap = new HashMap(16);
        if (taskObj == null) {
            return indEvalRecordMap;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Long lastTaskIdOfFinish = this.queryPreNodeLastTaskByTaskId(taskId);
            if (lastTaskIdOfFinish != null) {
                indEvalRecordMap = this.queryIndicatorEvalRecord(lastTaskIdOfFinish, areaRegEnum);
            }
        } else {
            List<Long> maxOverSortRoleList = this.getMaxOverSortRoleList(roles);
            Long lastTaskIdOfFinish = this.queryLastTaskIdByRoleIds(maxOverSortRoleList);
            if (lastTaskIdOfFinish != null) {
                indEvalRecordMap = this.queryIndicatorEvalRecord(lastTaskIdOfFinish, areaRegEnum);
            }
        }
        return indEvalRecordMap == null ? new HashMap(16) : indEvalRecordMap;
    }

    public Map<Long, DynamicObject> queryIndicatorEvalRecordOfPreRoleLastTaskNotCross(Long taskId, AreaRegEnum areaRegEnum) {
        if (areaRegEnum == null) {
            return new HashMap<Long, DynamicObject>(16);
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        Map<Object, Object> indEvalRecordMap = new HashMap(16);
        if (taskObj == null) {
            return indEvalRecordMap;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortNotCrossRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Long lastTaskIdOfFinish = this.queryPreNotCrossNodeLastTaskByTaskId(taskId);
            if (lastTaskIdOfFinish != null) {
                indEvalRecordMap = this.queryIndicatorEvalRecord(lastTaskIdOfFinish, areaRegEnum);
            }
        } else {
            List<Long> maxOverSortRoleList = this.getMaxOverSortRoleList(roles);
            Long lastTaskIdOfFinish = this.queryLastTaskIdByRoleIds(maxOverSortRoleList);
            if (lastTaskIdOfFinish != null) {
                indEvalRecordMap = this.queryIndicatorEvalRecord(lastTaskIdOfFinish, areaRegEnum);
            }
        }
        return indEvalRecordMap == null ? new HashMap(16) : indEvalRecordMap;
    }

    public Map<Long, DynamicObject> queryIndicatorEvalScoreRecordOfPreRoleLastTask(Long taskId, AreaRegEnum areaRegEnum) {
        if (areaRegEnum == null) {
            return new HashMap<Long, DynamicObject>(16);
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        Map<Long, DynamicObject> indEvalRecordMap = new HashMap<Long, DynamicObject>(16);
        if (taskObj == null) {
            return indEvalRecordMap;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Map<Long, Long> roleMap = this.queryPreNodeLastRoleMap(taskId);
            indEvalRecordMap = this.queryIndicatorEvalRecord(roleMap, areaRegEnum);
        } else {
            HashMap<Long, Long> sortRoleMap = new HashMap<Long, Long>(16);
            DynamicObject maxSortRole = null;
            for (DynamicObject role : roles) {
                if (role == null) continue;
                if (maxSortRole == null) {
                    maxSortRole = role;
                }
                int turnOverSort = role.getInt("turnoversort");
                int maxTurnOverSort = maxSortRole.getInt("turnoversort");
                if (maxTurnOverSort != turnOverSort) continue;
                sortRoleMap.put(role.getLong("flowdefrole.id"), role.getLong("id"));
            }
            indEvalRecordMap = this.queryIndicatorEvalRecord(sortRoleMap, areaRegEnum);
        }
        return indEvalRecordMap == null ? new HashMap(16) : indEvalRecordMap;
    }

    public Map<Long, DynamicObject> queryIndEvalScoreRecordOfPreRoleLastTaskNotCross(Long taskId, AreaRegEnum areaRegEnum) {
        if (areaRegEnum == null) {
            return new HashMap<Long, DynamicObject>(16);
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        Map<Long, DynamicObject> indEvalRecordMap = new HashMap<Long, DynamicObject>(16);
        if (taskObj == null) {
            return indEvalRecordMap;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortNotCrossRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Map<Long, Long> roleMap = this.queryPreNotCrossNodeLastRoleMap(taskId);
            indEvalRecordMap = this.queryIndicatorEvalRecord(roleMap, areaRegEnum);
        } else {
            HashMap<Long, Long> sortRoleMap = new HashMap<Long, Long>(16);
            DynamicObject maxSortRole = null;
            for (DynamicObject role : roles) {
                if (role == null) continue;
                if (maxSortRole == null) {
                    maxSortRole = role;
                }
                int turnOverSort = role.getInt("turnoversort");
                int maxTurnOverSort = maxSortRole.getInt("turnoversort");
                if (maxTurnOverSort != turnOverSort) continue;
                sortRoleMap.put(role.getLong("flowdefrole.id"), role.getLong("id"));
            }
            indEvalRecordMap = this.queryIndicatorEvalRecord(sortRoleMap, areaRegEnum);
        }
        return indEvalRecordMap == null ? new HashMap(16) : indEvalRecordMap;
    }

    private Map<Long, DynamicObject> queryIndicatorEvalRecord(Map<Long, Long> sortRoleMap, AreaRegEnum areaRegEnum) {
        Long lastTaskIdOfFinish;
        Map<Long, DynamicObject> indEvalRecordMap = new HashMap<Long, DynamicObject>(16);
        Set<Long> defRoleIdSet = sortRoleMap.keySet();
        ArrayList<Long> scoreNextRoleIdList = new ArrayList<Long>(10);
        Map roleConfigBoMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(defRoleIdSet);
        if (roleConfigBoMap != null) {
            for (Map.Entry next : roleConfigBoMap.entrySet()) {
                Boolean isScoreNext;
                NodeRoleConfigBo roleConfigBo;
                if (next == null || (roleConfigBo = (NodeRoleConfigBo)next.getValue()) == null || (isScoreNext = roleConfigBo.getIsscorenext()) == null || !isScoreNext.booleanValue()) continue;
                scoreNextRoleIdList.add(sortRoleMap.get(next.getKey()));
            }
        }
        if ((lastTaskIdOfFinish = this.queryLastTaskIdByRoleIds(scoreNextRoleIdList)) != null) {
            indEvalRecordMap = this.queryIndicatorEvalRecord(lastTaskIdOfFinish, areaRegEnum);
        }
        return indEvalRecordMap;
    }

    private List<Long> getMaxOverSortRoleList(DynamicObject[] roles) {
        ArrayList<Long> maxRoleList = new ArrayList<Long>(10);
        DynamicObject maxSortRole = null;
        for (DynamicObject role : roles) {
            if (role == null) continue;
            if (maxSortRole == null) {
                maxSortRole = role;
            }
            int turnOverSort = role.getInt("turnoversort");
            int maxTurnOverSort = maxSortRole.getInt("turnoversort");
            if (maxTurnOverSort != turnOverSort) continue;
            maxRoleList.add(role.getLong("id"));
        }
        return maxRoleList;
    }

    private Map<Long, Long> getMaxOverSortRoleMap(DynamicObject[] roles) {
        HashMap<Long, Long> ruRoleMap = new HashMap<Long, Long>(16);
        DynamicObject maxSortRole = null;
        for (DynamicObject role : roles) {
            if (role == null) continue;
            if (maxSortRole == null) {
                maxSortRole = role;
            }
            int turnOverSort = role.getInt("turnoversort");
            int maxTurnOverSort = maxSortRole.getInt("turnoversort");
            if (maxTurnOverSort != turnOverSort) continue;
            ruRoleMap.put(role.getLong("flowdefrole.id"), role.getLong("id"));
        }
        return ruRoleMap;
    }

    public DynamicObject[] queryGenInstance(Set<Long> areaInstanceIds) {
        QFilter idFilter = new QFilter("id", "in", areaInstanceIds);
        return OBJ_GEN_AREA_INS_ENTITY_SERVICE.query("areascore, areaweight, forcedtype, entryentity.indctrscore, entryentity.weight", new QFilter[]{idFilter});
    }

    public DynamicObject queryLastCustomAreaRecordByObj(Long objId) {
        QFilter objIdFilter = new QFilter("actevalobj", "=", (Object)objId);
        return CUSTOM_AREA_RECORD_ENTITY.queryOne("id", new QFilter[]{objIdFilter}, "createtime desc");
    }

    public DynamicObject queryLastCustomAreaRecordByObj(Long objId, Long areaConfId) {
        QFilter objIdFilter = new QFilter("actevalobj", "=", (Object)objId);
        QFilter confFilter = new QFilter("areaconf", "=", (Object)areaConfId);
        DynamicObject dynamicObject = CUSTOM_AREA_RECORD_ENTITY.queryOne("id", new QFilter[]{objIdFilter, confFilter}, "createtime desc");
        if (dynamicObject == null) {
            dynamicObject = this.queryLastCustomAreaRecordByObj(objId);
        }
        return dynamicObject;
    }

    public Map<Long, DynamicObject> queryLastestCustomAreaRecordByEvalObjId(Long evalObjId) {
        DynamicObject[] customAreaRecords;
        HashMap<Long, DynamicObject> areaConfRecordMap = new HashMap<Long, DynamicObject>(16);
        QFilter objIdFilter = new QFilter("actevalobj", "=", (Object)evalObjId);
        for (DynamicObject customAreaRecord : customAreaRecords = CUSTOM_AREA_RECORD_ENTITY.query("id, areaconf", new QFilter[]{objIdFilter}, "createtime desc")) {
            long areaconfId = customAreaRecord.getLong("areaconf");
            if (areaConfRecordMap.containsKey(areaconfId)) continue;
            areaConfRecordMap.put(areaconfId, customAreaRecord);
        }
        return areaConfRecordMap;
    }

    public boolean queryObjIndicatorAreaEntry(Long areaRegId, Long areaInsId, Boolean isCrossEvaluate, Map<Long, List<Long>> areaRegIndicaMap) {
        DynamicObject[] cols;
        AreaRegEnum areaReg = AreaRegEnum.get((Long)areaRegId);
        OpmcEntityService indicatorEntity = AREA_INDICATOR_ENTITY_MAP.get(areaReg);
        QFilter filter = new QFilter("instanceid", "=", (Object)areaInsId);
        if (isCrossEvaluate != null && isCrossEvaluate.booleanValue()) {
            ArrayList indicaIds = new ArrayList(10);
            if (areaRegIndicaMap != null) {
                indicaIds = areaRegIndicaMap.get(areaInsId) == null ? new ArrayList(10) : areaRegIndicaMap.get(areaInsId);
            }
            QFilter idFilter = new QFilter("id", "in", indicaIds);
            filter.and(idFilter);
        }
        return (cols = indicatorEntity.query("id", new QFilter[]{filter})).length > 0;
    }

    public Long queryPreRoleLastTask(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return null;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Long lastTaskIdOfFinish = this.queryPreNodeLastTaskByTaskId(taskId);
            return lastTaskIdOfFinish;
        }
        List<Long> maxOverSortRoleList = this.getMaxOverSortRoleList(roles);
        Long lastTaskIdOfFinish = this.queryLastTaskIdByRoleIds(maxOverSortRoleList);
        return lastTaskIdOfFinish;
    }

    public Long queryPreRoleOfNoCrossLastTask(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return null;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortNotCrossRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            return this.queryPreNotCrossNodeLastTaskByTaskId(taskId);
        }
        List<Long> maxOverSortRoleList = this.getMaxOverSortRoleList(roles);
        return this.queryLastTaskIdByRoleIds(maxOverSortRoleList);
    }

    public Long queryExecuteSchemeByActivityID(Long activityId) {
        DynamicObject executeSchemeDy = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("executescheme.id", new QFilter[]{new QFilter("id", "=", (Object)activityId)});
        return executeSchemeDy.getLong("executescheme.id");
    }

    public Long queryPreRoleLastTaskOfNextGrade(Long taskId) {
        if (taskId == null) {
            return null;
        }
        boolean isFirstNodeAndRole = this.queryIsFirstNodeAndRole(taskId);
        if (isFirstNodeAndRole) {
            return null;
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Map<Long, Long> roleMap = this.queryPreNodeLastRoleMap(taskId);
            return this.getNextGradleLastTaskId(roleMap);
        }
        Map<Long, Long> sortRoleDefMap = this.getMaxOverSortRoleMap(roles);
        return this.getNextGradleLastTaskId(sortRoleDefMap);
    }

    private Long getNextGradleLastTaskId(Map<Long, Long> sortRoleDefMap) {
        Set<Long> defRoleIdSet = sortRoleDefMap.keySet();
        ArrayList<Long> nextRuRoleIdList = new ArrayList<Long>(10);
        Map roleConfigBoMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(defRoleIdSet);
        if (roleConfigBoMap != null) {
            for (Map.Entry next : roleConfigBoMap.entrySet()) {
                Long ruRoleId;
                Boolean isScoreNext;
                NodeRoleConfigBo roleConfigBo;
                if (next == null || (roleConfigBo = (NodeRoleConfigBo)next.getValue()) == null || (isScoreNext = roleConfigBo.getIsgradenext()) == null || !isScoreNext.booleanValue() || (ruRoleId = sortRoleDefMap.get(next.getKey())) == null) continue;
                nextRuRoleIdList.add(ruRoleId);
            }
        }
        Long lastTaskIdOfFinish = this.queryLastTaskIdByRoleIds(nextRuRoleIdList);
        return lastTaskIdOfFinish;
    }

    public Long queryPreRoleLastTaskOfNextEval(Long taskId) {
        if (taskId == null) {
            return null;
        }
        boolean isFirstNodeAndRole = this.queryIsFirstNodeAndRole(taskId);
        if (isFirstNodeAndRole) {
            return null;
        }
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Map<Long, Long> roleMap = this.queryPreNodeLastRoleMap(taskId);
            return this.getNextEvalLastTaskId(roleMap);
        }
        Map<Long, Long> sortRoleDefMap = this.getMaxOverSortRoleMap(roles);
        return this.getNextEvalLastTaskId(sortRoleDefMap);
    }

    private Long getNextEvalLastTaskId(Map<Long, Long> sortRoleDefMap) {
        Set<Long> defRoleIdSet = sortRoleDefMap.keySet();
        ArrayList<Long> nextRuRoleIdList = new ArrayList<Long>(10);
        Map roleConfigBoMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(defRoleIdSet);
        if (roleConfigBoMap != null) {
            for (Map.Entry next : roleConfigBoMap.entrySet()) {
                Long ruRoleId;
                Boolean isNext;
                NodeRoleConfigBo roleConfigBo;
                if (next == null || (roleConfigBo = (NodeRoleConfigBo)next.getValue()) == null || (isNext = roleConfigBo.getIsevaluatenext()) == null || !isNext.booleanValue() || (ruRoleId = sortRoleDefMap.get(next.getKey())) == null) continue;
                nextRuRoleIdList.add(ruRoleId);
            }
        }
        Long lastTaskIdOfFinish = this.queryLastTaskIdByRoleIds(nextRuRoleIdList);
        return lastTaskIdOfFinish;
    }

    public DynamicObject queryIndicatorById(Long indicatorId, AreaRegEnum areaReg) {
        OpmcEntityService indicatorEntity = AREA_INDICATOR_ENTITY_MAP.get(areaReg);
        return indicatorEntity.queryOne((Object)indicatorId);
    }

    public DynamicObject[] queryEvalRecordByIndicator(Long indicatorId, AreaRegEnum areaReg) {
        OpmcEntityService recordEntity = IND_RECORD_ENTITY_MAP.get(areaReg);
        QFilter indicatorFilter = new QFilter("indicator", "=", (Object)indicatorId);
        DynamicObject[] recordDys = recordEntity.query("flowrutask.handler, flowrutask.taskstatus, flowrunode, flowrurole", new QFilter[]{indicatorFilter}, "flowrunode.index asc, flowrurole.turnoversort asc");
        return (DynamicObject[])Arrays.stream(recordDys).filter(recordDy -> HRStringUtils.equals((String)recordDy.getString("flowrutask.taskstatus"), (String)FlowRuTaskStatusEnum.PROCESSED.getCode())).toArray(DynamicObject[]::new);
    }

    public void deleteAreaIndicator(List<DynamicObject> areaEntry) {
        List areaList = areaEntry.stream().filter(areaInfo -> !AreaRegEnum.CUSTOM_AREA.getAreaPkId().equals(areaInfo.getLong("areareg.id"))).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(areaList)) {
            return;
        }
        for (DynamicObject areaInfo2 : areaList) {
            Long areaRegId = areaInfo2.getLong("areareg.id");
            long areaInstId = areaInfo2.getLong("areains");
            AreaRegEnum areaRegEnum = AreaRegEnum.get((Long)areaRegId);
            OpmcEntityService indicatorEntity = AREA_INDICATOR_ENTITY_MAP.get(areaRegEnum);
            indicatorEntity.deleteByFilter(new QFilter[]{new QFilter("instanceid", "=", (Object)areaInstId)});
        }
    }

    public List<ContentAreaEntryEvaDto> queryProcessPermSettingByKeyField(Long permSettingId, Long defNodeId, List<Long> areaConfigIds) {
        return PROCESS_PERM_SETTING_ENTITY_SERVICE.queryProcessPermSettingByKeyField(permSettingId, defNodeId, areaConfigIds);
    }

    public List<ContentAreaEntryEvaDto> queryProcessPermSettingByKeyFieldNew(Long permSettingId, Long defNodeId) {
        return PROCESS_PERM_SETTING_ENTITY_SERVICE.queryProcessPermSettingByKeyFieldNew(permSettingId, defNodeId);
    }

    public Map<String, Object> queryProcessPermSettingScope(Long permSettingId, Long defNodeId) {
        return PROCESS_PERM_SETTING_ENTITY_SERVICE.queryProcessPermSettingScope(permSettingId, defNodeId);
    }

    public Map<String, Object> queryProcessPermSettingScopeNew(Long permSettingId, Long defNodeId) {
        return PROCESS_PERM_SETTING_ENTITY_SERVICE.queryProcessPermSettingScopeNew(permSettingId, defNodeId);
    }

    public List<ContentAreaEntryEvaDto> queryProcessPermSettingByKeyField(Long permSettingId, Long defNodeId) {
        return PROCESS_PERM_SETTING_ENTITY_SERVICE.queryProcessPermSettingByKeyField(permSettingId, defNodeId);
    }

    public DynamicObject queryFlowDefNodeIdByruNodeId(Long FlowRuNodeId) {
        QFilter filter = new QFilter("id", "=", (Object)FlowRuNodeId);
        return FLOW_RU_NODE_ENTITY_SERVICE.queryOne("id,flownodedef.id", filter);
    }

    public boolean isCrossNodeOfPreRole(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return false;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles != null && roles.length > 0) {
            for (DynamicObject role : roles) {
                if (role == null) continue;
                return role.getBoolean("iscrossrole");
            }
        } else {
            long procId = taskObj.getLong("flowruproc.id");
            int index = taskObj.getInt("flowrunode.index");
            if (index == 1) {
                long ruNodeId = taskObj.getLong("flowrunode.id");
                DynamicObject ruNodeDy = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByPk(Long.valueOf(ruNodeId));
                if (ruNodeDy != null) {
                    return ruNodeDy.getBoolean("iscrossnode");
                }
            } else {
                DynamicObject ruNodeDy = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByIndex(Long.valueOf(procId), index - 1);
                if (ruNodeDy != null) {
                    return ruNodeDy.getBoolean("iscrossnode");
                }
            }
        }
        return false;
    }

    public Map<String, Object> queryCustomAreaPerm(Long taskId, Long confId) {
        List contentAreaEntries;
        Map contentAreaEntriesMap;
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowrunode", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("executescheme, dynamicpermission", new QFilter[]{activityFilter});
        QFilter flowrunodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
        DynamicObject flowrunodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{flowrunodeFilter});
        HashMap<String, Object> custPermMapNew = new HashMap<String, Object>(16);
        ArrayList<Long> defNodeIdList = new ArrayList<Long>(10);
        DynPermissionConfigService dynPermissionConfigService = new DynPermissionConfigService();
        long defNodeId = flowrunodeObj.getLong("flownodedef.id");
        defNodeIdList.add(defNodeId);
        Long procPermIdNew = activityObj.getLong("dynamicpermission.id");
        DynamicPermissionConfigVO dynamicPermissions = dynPermissionConfigService.getDynamicPermissions(procPermIdNew, defNodeIdList);
        List<Long> areaFileIdList = this.extrectAreaFieldIds(confId, defNodeId, dynamicPermissions);
        HashMap<Long, String> fieldNumMap = new HashMap<Long, String>(16);
        QFilter filter = new QFilter("id", "in", areaFileIdList);
        DynamicObject[] fieldArr = AREA_FIELD_ENTITY_SERVICE.queryOriginalArray("id,number", new QFilter[]{filter});
        if (fieldArr != null) {
            for (DynamicObject fieldDy : fieldArr) {
                if (fieldDy == null) continue;
                fieldNumMap.put(fieldDy.getLong("id"), fieldDy.getString("number"));
            }
        }
        if (dynamicPermissions != null && (contentAreaEntriesMap = dynamicPermissions.getContentAreaEntriesMap()) != null && (contentAreaEntries = (List)contentAreaEntriesMap.get(defNodeId)) != null) {
            for (ContentAreaEntry areaEntry : contentAreaEntries) {
                Boolean areadisplayitem;
                if (areaEntry == null) continue;
                Long areaPageInsId = areaEntry.getAreapageInsId();
                if (confId == null || !confId.equals(areaPageInsId)) continue;
                Boolean bl = areadisplayitem = areaEntry.getAreaDisplay() == null ? Boolean.FALSE : areaEntry.getAreaDisplay();
                if (!areadisplayitem.booleanValue()) {
                    custPermMapNew.put("areadisplayitem", areadisplayitem);
                    break;
                }
                List fieldEntries = areaEntry.getFieldEntries();
                if (fieldEntries == null) continue;
                for (ContentFieldEntry fieldEntry : fieldEntries) {
                    if (fieldEntry == null) continue;
                    Boolean display = fieldEntry.getFieldDisplay();
                    Boolean mustInput = fieldEntry.getFieldMustInput();
                    Boolean fieldModify = fieldEntry.getFieldModify();
                    String areaFieldNumber = (String)fieldNumMap.get(fieldEntry.getAreaFieldId());
                    HashMap<String, Boolean> fieldMap = new HashMap<String, Boolean>(16);
                    fieldMap.put("fielddisplayitem", display);
                    fieldMap.put("fieldmustinputitem", mustInput);
                    fieldMap.put("fieldmodifyitem", fieldModify);
                    custPermMapNew.put(areaFieldNumber, fieldMap);
                }
            }
        }
        return custPermMapNew;
    }

    private List<Long> extrectAreaFieldIds(Long confId, long defNodeId, DynamicPermissionConfigVO dynamicPermissions) {
        List contentAreaEntries;
        Map contentAreaEntriesMap;
        ArrayList<Long> areaFileIdList = new ArrayList<Long>(10);
        if (dynamicPermissions != null && (contentAreaEntriesMap = dynamicPermissions.getContentAreaEntriesMap()) != null && (contentAreaEntries = (List)contentAreaEntriesMap.get(defNodeId)) != null) {
            for (ContentAreaEntry areaEntry : contentAreaEntries) {
                List fieldEntries;
                if (areaEntry == null) continue;
                Long areapageInsId = areaEntry.getAreapageInsId();
                if (confId == null || !confId.equals(areapageInsId) || (fieldEntries = areaEntry.getFieldEntries()) == null) continue;
                for (ContentFieldEntry fieldEntry : fieldEntries) {
                    if (fieldEntry == null) continue;
                    areaFileIdList.add(fieldEntry.getAreaFieldId());
                }
            }
        }
        return areaFileIdList;
    }

    public void updateSumAreaRecord(DynamicObject customAreaObj) {
        SUM_AREA_RECORD_ENTITY.saveOne(customAreaObj);
    }

    public boolean isUpdateSoe() {
        IsUpdateSoeServiceImpl isUpdateSoeService = new IsUpdateSoeServiceImpl();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)isUpdateSoeService, IIsUpdateSoeService.class, (String)"kd.opmc.epa.business.domain.evaluating.extpoint.IIsUpdateSoeService#isUpdateSoe", (PluginFilter)null);
        List booleans = proxy.callReplaceIfPresent(updateSoe -> updateSoe.isUpdateSoe());
        if (booleans != null && booleans.size() > 0) {
            return (Boolean)booleans.get(0);
        }
        return true;
    }

    public void updateEvalRecordEvaluation(List<Long> taskIds) {
        QFilter taskFilter = new QFilter("flowrutask", "in", taskIds);
        DynamicObject[] updateEvalRecord = GEN_AREA_RECORD_ENTITY.query("flowrutask ,area, ssr, ssrec, actevalobj, entryentity.soe, entryentity.adjustval, entryentity.indicator", new QFilter[]{taskFilter});
        if (updateEvalRecord.length != 0) {
            List areaInsIds = Arrays.stream(updateEvalRecord).map(item -> item.getLong("area.id")).collect(Collectors.toList());
            QFilter instanceId = new QFilter("id", "in", areaInsIds);
            QFilter evalModeFilter = instanceId.and(new QFilter("entryentity.evalmode", "=", (Object)EvalModeEnum.SYS_INPUT.getCode()));
            DynamicObject[] genAreaIndicator = OBJ_GEN_AREA_INS_ENTITY_SERVICE.query("areaconf, areaactivity,scoresystem, entryentity.iecs,entryentity.weight, entryentity.evalmode", new QFilter[]{evalModeFilter});
            if (genAreaIndicator.length == 0) {
                return;
            }
            Map<Long, DynamicObject> areaAssessFormMap = this.queryAreaAssessFormMap(genAreaIndicator);
            Map<Long, BigDecimal> importAreaSsr = this.calculateGenSsr(updateEvalRecord, genAreaIndicator, areaAssessFormMap);
            Long objId = updateEvalRecord[0].getLong("actevalobj");
            Map<Long, BigDecimal> taskOseMap = this.queryGenNAddSubSsr(importAreaSsr, objId);
            DynamicObject[] updateSumAreaIn = OBJ_SUM_AREA_INS_ENTITY_SERVICE.query("ole,ose,actevalobj,activity, flowrutask", taskFilter.toArray());
            if (updateSumAreaIn.length != 0) {
                this.calculateSumArea(updateSumAreaIn, taskOseMap, taskIds);
                GEN_AREA_RECORD_ENTITY.save(updateEvalRecord);
                if (this.isUpdateSoe()) {
                    OBJ_SUM_AREA_INS_ENTITY_SERVICE.save(updateSumAreaIn);
                }
            } else {
                GEN_AREA_RECORD_ENTITY.save(updateEvalRecord);
            }
        }
    }

    public void updateEvalRecordBatchAdjust(List<Long> taskIds) {
        if (this.isUpdateSoe()) {
            ACT_EVAL_OBJ_ADJ_DOMAIN_SERVICE.adjActEvalObjScoreByImportInd(taskIds);
        }
    }

    private BigDecimal calculateIECS(Map<Long, DynamicObject> areaAssessFormMap, DynamicObject[] genAreaIndicator) {
        BigDecimal ret = BigDecimal.ZERO;
        for (DynamicObject genAreaIns : genAreaIndicator) {
            if (!genAreaIns.getBoolean("areaconf.ispartin")) continue;
            BigDecimal ssr = BigDecimal.ZERO;
            long areaId = genAreaIns.getLong("id");
            DynamicObject areaScoreSystem = genAreaIns.getDynamicObject("scoresystem");
            DynamicObject assessForm = areaAssessFormMap.get(areaId);
            DynamicObjectCollection areaInd = genAreaIns.getDynamicObjectCollection("entryentity");
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(assessForm.getString("scorecalcway"))) {
                for (DynamicObject ind : areaInd) {
                    if (!EvalModeEnum.SYS_INPUT.getCode().equals(ind.get("evalmode"))) continue;
                    BigDecimal weight = ind.getBigDecimal("weight");
                    BigDecimal hundred = new BigDecimal("100");
                    BigDecimal percent = weight.divide(hundred, 10, RoundingMode.HALF_UP);
                    BigDecimal ies = ind.getBigDecimal(AssessScoreAbbrEnum.IECS.getCode());
                    BigDecimal iesRes = ies.multiply(percent);
                    ssr = ssr.add(iesRes);
                }
                ssr = this.scoreSystemExchangeNScale(ssr, assessForm, areaScoreSystem);
            } else if (ScoreCalcWayEnum.SUM.getValue().equals(assessForm.getString("scorecalcway"))) {
                for (DynamicObject ind : areaInd) {
                    BigDecimal ies = ind.getBigDecimal(AssessScoreAbbrEnum.IECS.getCode());
                    ssr = ssr.add(ies);
                }
            }
            ret = ret.add(ssr);
        }
        return ret;
    }

    private Map<Long, BigDecimal> queryGenNAddSubSsr(Map<Long, BigDecimal> importAreaSsr, Long evalObjId) {
        DynamicObject[] genRecord;
        HashMap ret = Maps.newHashMapWithExpectedSize((int)16);
        QFilter actEvalObjFilter = new QFilter("actevalobj", "=", (Object)evalObjId);
        DynamicObject[] addSubRecord = OBJ_ADD_SUB_AREA_RECORD_ENTITY_SERVICE.query("flowrutask, area, ssr, ssrec", actEvalObjFilter.toArray());
        if (addSubRecord.length != 0) {
            Set areaIds = Arrays.stream(addSubRecord).map(item -> item.getLong("area.id")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("id", "in", areaIds);
            DynamicObject[] addSubAreaInsConf = OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.query("areaconf.ispartin", qFilter.toArray());
            Map<Long, Boolean> addSubIsPartIn = Arrays.stream(addSubAreaInsConf).collect(Collectors.toMap(item -> item.getLong("id"), item2 -> item2.getBoolean("areaconf.ispartin")));
            for (DynamicObject record : addSubRecord) {
                long area = record.getLong("area.id");
                long task = record.getLong("flowrutask");
                if (!addSubIsPartIn.get(area).booleanValue()) continue;
                BigDecimal ssr = record.getBigDecimal("ssr") == null ? BigDecimal.ZERO : record.getBigDecimal("ssr");
                ret.put(task, ret.getOrDefault(task, BigDecimal.ZERO).add(ssr));
            }
        }
        if ((genRecord = GEN_AREA_RECORD_ENTITY.query("flowrutask, area, ssr, ssrec", actEvalObjFilter.toArray())).length != 0) {
            Set areaIds = Arrays.stream(genRecord).filter(item1 -> !importAreaSsr.containsKey(item1.getLong("id"))).map(item -> item.getLong("area.id")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("id", "in", areaIds);
            DynamicObject[] genAreaInsConf = OBJ_GEN_AREA_INS_ENTITY_SERVICE.query("areaconf.ispartin", qFilter.toArray());
            Map<Long, Boolean> genAreaIsPartIn = Arrays.stream(genAreaInsConf).collect(Collectors.toMap(item -> item.getLong("id"), item2 -> item2.getBoolean("areaconf.ispartin")));
            for (DynamicObject record : genRecord) {
                long area = record.getLong("area.id");
                long task = record.getLong("flowrutask");
                long areaRecordEntryId = record.getLong("id");
                if (importAreaSsr.containsKey(areaRecordEntryId)) {
                    ret.put(task, ret.getOrDefault(task, BigDecimal.ZERO).add(importAreaSsr.get(areaRecordEntryId)));
                    continue;
                }
                if (!genAreaIsPartIn.get(area).booleanValue()) continue;
                BigDecimal ssr = record.getBigDecimal("ssr") == null ? BigDecimal.ZERO : record.getBigDecimal("ssr");
                ret.put(task, ret.getOrDefault(task, BigDecimal.ZERO).add(ssr));
            }
        }
        return ret;
    }

    private void calculateSumArea(DynamicObject[] sumAreaIns, Map<Long, BigDecimal> taskOseMap, List<Long> taskIds) {
        long activityId = sumAreaIns[0].getLong("activity");
        long actEvalObjId = sumAreaIns[0].getLong("actevalobj");
        DynamicObject assessActivity = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform", new QFilter("id", "=", (Object)activityId).toArray());
        DynamicObject assessForm = ASSESS_FORM_ENTITY.queryOne("scorecalcway, scoresystem, evalway, numaccuracy, scaletype, allowexceedupper, limitmaxscore, allowexceedlower, limitminscore,sumperflevel ", new QFilter("id", "=", (Object)assessActivity.getLong("assessform.id")).toArray());
        Map<Long, BigDecimal> oseMap = this.getFormScoreInLimit(taskOseMap, assessForm, actEvalObjId);
        Map<Long, String> oleMap = this.calculateLevel(assessForm, oseMap);
        for (DynamicObject sumAreaIn : sumAreaIns) {
            String ole;
            long taskId = sumAreaIn.getLong("flowrutask.id");
            NodeRoleConfigBo roleConfig = ACT_EVAL_OBJ_OVERALL_DOMAIN_SERVICE.queryNodeRoleConfigByTask(taskIds.get(0));
            if (roleConfig.getIsgradecompute().booleanValue() && StringUtils.isNotEmpty((CharSequence)(ole = oleMap.get(taskId)))) {
                sumAreaIn.set("ole", (Object)ole);
            }
            sumAreaIn.set("ose", (Object)oseMap.get(taskId));
        }
    }

    public Map<Long, String> calculateLevel(DynamicObject assessFormDy, Map<Long, BigDecimal> oseMap) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)oseMap.size());
        if (assessFormDy.getDynamicObject("scoresystem") == null || assessFormDy.getDynamicObject("sumperflevel") == null) {
            return ret;
        }
        Long scoreSystemId = (Long)assessFormDy.getDynamicObject("scoresystem").getPkValue();
        Long sumPerfLevelId = (Long)assessFormDy.getDynamicObject("sumperflevel").getPkValue();
        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelId);
        DynamicObjectCollection scoreMapEntry = sumPerfLevel.getDynamicObjectCollection("scoremapentryentity");
        DynamicObject scoreMapDy = scoreMapEntry.stream().filter(scoreMap -> scoreMap.getLong("scoresystem.id") == scoreSystemId.longValue()).findFirst().orElse(null);
        if (scoreMapDy == null) {
            LOG.error("Unable to find score system mapping for performance level, scoreSystemId[{}], sumPerfLevelId[{}]", (Object)scoreSystemId, (Object)sumPerfLevelId);
            return ret;
        }
        String levelScoreMap = scoreMapDy.getString("levelscoremap");
        if (HRStringUtils.equals((String)levelScoreMap, (String)"20")) {
            LOG.error("Mapping by default is not supported");
            return ret;
        }
        for (Map.Entry<Long, BigDecimal> soeEntry : oseMap.entrySet()) {
            BigDecimal ose = soeEntry.getValue();
            DynamicObjectCollection scoreLevelMapEntry = scoreMapDy.getDynamicObjectCollection("scoresubentryentity");
            for (DynamicObject scoreLevelMap : scoreLevelMapEntry) {
                BigDecimal maxScore = scoreLevelMap.getBigDecimal("maxscore");
                String scoreMaxOperation = scoreLevelMap.getString("scoremaxoperation");
                String scoreMinOperation = scoreLevelMap.getString("scoreminoperation");
                BigDecimal minScore = scoreLevelMap.getBigDecimal("minscore");
                boolean maxCompare = true;
                if (maxScore != null && maxScore.compareTo(BigDecimal.ZERO) != 0) {
                    if (HRStringUtils.equals((String)scoreMaxOperation, (String)"10")) {
                        maxCompare = maxScore.compareTo(ose) > 0;
                    } else if (HRStringUtils.equals((String)scoreMaxOperation, (String)"20")) {
                        maxCompare = maxScore.compareTo(ose) >= 0;
                    }
                }
                boolean minCompare = true;
                if (minScore != null && minScore.compareTo(BigDecimal.ZERO) != 0) {
                    if (HRStringUtils.equals((String)scoreMinOperation, (String)"10")) {
                        minCompare = ose.compareTo(minScore) > 0;
                    } else if (HRStringUtils.equals((String)scoreMinOperation, (String)"20")) {
                        boolean bl = minCompare = ose.compareTo(minScore) >= 0;
                    }
                }
                if (!maxCompare || !minCompare) continue;
                ret.put(soeEntry.getKey(), scoreLevelMap.getString("seq"));
            }
        }
        return ret;
    }

    private Map<Long, BigDecimal> getFormScoreInLimit(Map<Long, BigDecimal> formScore, DynamicObject assessForm, Long actEvalObjId) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)formScore.size());
        Long assessFormId = assessForm.getLong("id");
        Map<String, BigDecimal> scoreRangeMap = this.getScoreRangeMap(actEvalObjId);
        BigDecimal maxScore = scoreRangeMap.get("maxscore");
        BigDecimal minScore = scoreRangeMap.get("minscore");
        for (Map.Entry<Long, BigDecimal> formScoreEntry : formScore.entrySet()) {
            BigDecimal ose = formScoreEntry.getValue();
            ose = ose.compareTo(minScore) > 0 ? ose : minScore;
            ose = ose.compareTo(maxScore) < 0 ? ose : maxScore;
            ret.put(formScoreEntry.getKey(), ose);
        }
        return ret;
    }

    private Map<Long, BigDecimal> calculateGenSsr(DynamicObject[] updateEvalRecord, DynamicObject[] genAreaIndicator, Map<Long, DynamicObject> areaAssessFormMap) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)genAreaIndicator.length);
        Map<Long, DynamicObject> idAreaIndMap = Arrays.stream(genAreaIndicator).collect(Collectors.toMap(item -> item.getLong("id"), item2 -> item2));
        List<Long> taskIds = Arrays.stream(updateEvalRecord).map(obj -> obj.getLong("flowrutask")).collect(Collectors.toList());
        DynamicObject[] taskObjs = this.queryTaskInfos(taskIds);
        Map taskMap = Arrays.stream(taskObjs).collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
        for (DynamicObject areaRecord : updateEvalRecord) {
            long areaId = areaRecord.getLong("area.id");
            if (!idAreaIndMap.containsKey(areaId)) continue;
            BigDecimal ssr = BigDecimal.ZERO;
            DynamicObject assessForm = areaAssessFormMap.get(areaId);
            DynamicObject areaIns = idAreaIndMap.get(areaId);
            DynamicObjectCollection areaInd = areaIns.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection indEvalRecordEntry = areaRecord.getDynamicObjectCollection("entryentity");
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(assessForm.getString("scorecalcway"))) {
                for (DynamicObject indEvalRecord : indEvalRecordEntry) {
                    DynamicObject indicator = indEvalRecord.getDynamicObject("indicator");
                    BigDecimal weight = indicator.getBigDecimal("weight");
                    BigDecimal hundred = new BigDecimal("100");
                    BigDecimal percent = weight.divide(hundred, 10, RoundingMode.HALF_UP);
                    BigDecimal soe = indEvalRecord.getBigDecimal(AssessScoreAbbrEnum.SOE.getCode());
                    BigDecimal soeRes = soe.multiply(percent);
                    ssr = ssr.add(soeRes);
                }
                for (DynamicObject ind : areaInd) {
                    if (!EvalModeEnum.SYS_INPUT.getCode().equals(ind.get("evalmode"))) continue;
                    BigDecimal weight = ind.getBigDecimal("weight");
                    BigDecimal hundred = new BigDecimal("100");
                    BigDecimal percent = weight.divide(hundred, 10, RoundingMode.HALF_UP);
                    BigDecimal ies = ind.getBigDecimal(AssessScoreAbbrEnum.IECS.getCode());
                    BigDecimal iesRes = ies.multiply(percent);
                    ssr = ssr.add(iesRes);
                }
                ssr = this.scoreSystemExchangeScale(ssr, assessForm, areaIns.getDynamicObject("scoresystem"));
            } else if (ScoreCalcWayEnum.SUM.getValue().equals(assessForm.getString("scorecalcway"))) {
                BigDecimal ies;
                for (DynamicObject indEvalRecord : indEvalRecordEntry) {
                    ies = indEvalRecord.getBigDecimal(AssessScoreAbbrEnum.SOE.getCode());
                    ssr = ssr.add(ies);
                }
                for (DynamicObject ind : areaInd) {
                    if (!EvalModeEnum.SYS_INPUT.getCode().equals(ind.get("evalmode"))) continue;
                    ies = ind.getBigDecimal(AssessScoreAbbrEnum.IECS.getCode());
                    ssr = ssr.add(ies);
                }
            }
            long areaRecordId = areaRecord.getLong("id");
            if (areaIns.getBoolean("areaconf.ispartin")) {
                ret.put(areaRecordId, ssr);
            } else {
                ret.put(areaRecordId, BigDecimal.ZERO);
            }
            Long taskId = areaRecord.getLong("flowrutask");
            DynamicObject task = (DynamicObject)taskMap.get(taskId);
            Boolean isCrossEvaluate = task.getBoolean("iscrossevaluate");
            if (isCrossEvaluate.booleanValue()) continue;
            areaRecord.set("ssr", (Object)ssr);
        }
        return ret;
    }

    private List<DynamicObject> calculateGenSsrForAdjust(DynamicObject[] updateEvalRecord, Map<Long, DynamicObject> areaAssessFormMap, Map<Long, List<Long>> excludeTaskIndicatorMap) {
        QFilter filter;
        DynamicObject[] normalConfigs;
        ArrayList<DynamicObject> updateSSREvalRecordList = new ArrayList<DynamicObject>(10);
        Date date = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        ArrayList<Long> areaObjIDList = new ArrayList<Long>(10);
        for (DynamicObject areaRecord : updateEvalRecord) {
            long areaId;
            DynamicObject assessForm;
            if (areaRecord == null || (assessForm = areaAssessFormMap.get(areaId = areaRecord.getLong("area.id"))) == null || !ScoreCalcWayEnum.WEIGHT.getValue().equals(assessForm.getString("scorecalcway"))) continue;
            long actevalobjID = areaRecord.getLong("actevalobj");
            areaObjIDList.add(actevalobjID);
        }
        QFilter qFilter = new QFilter("id", "in", areaObjIDList);
        DynamicObject[] actEvalObjs = ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.queryOriginalArray("id,areaentry.areains,areaentry.areaconf,areaentry.areareg.id", new QFilter[]{qFilter});
        HashMap actEvalObjAreaMap = new HashMap(16);
        ArrayList<Long> genConfigIdList = new ArrayList<Long>(10);
        if (actEvalObjs != null) {
            for (DynamicObject actEvalObj : actEvalObjs) {
                if (actEvalObj == null) continue;
                long id = actEvalObj.getLong("id");
                long regId = actEvalObj.getLong("areaentry.areareg.id");
                long confId = actEvalObj.getLong("areaentry.areaconf");
                long insId = actEvalObj.getLong("areaentry.areains");
                if (AssessRuleConstants.NORM_INDCTR_AREA_PK != regId) continue;
                Map<Long, Long> insConfMap = actEvalObjAreaMap.get(id) == null ? new HashMap(16) : (Map)actEvalObjAreaMap.get(id);
                insConfMap.put(insId, confId);
                actEvalObjAreaMap.put(id, insConfMap);
                genConfigIdList.add(confId);
            }
        }
        HashMap<Long, DynamicObject> configScoreSystemMap = new HashMap<Long, DynamicObject>(16);
        if (genConfigIdList != null && !genConfigIdList.isEmpty() && (normalConfigs = NORMAL_CONFIG_ENTITY_SERVICE.query("id,scoresystem.id,scoresystem.maxscore", new QFilter[]{filter = new QFilter("id", "in", genConfigIdList)})) != null) {
            for (DynamicObject normalConfig : normalConfigs) {
                if (normalConfig == null) continue;
                long id = normalConfig.getLong("id");
                DynamicObject scoreSystem = normalConfig.getDynamicObject("scoresystem");
                configScoreSystemMap.put(id, scoreSystem);
            }
        }
        for (DynamicObject areaRecord : updateEvalRecord) {
            BigDecimal compareNewSsr;
            BigDecimal compareOldSsr;
            if (areaRecord == null) continue;
            BigDecimal oldSSR = areaRecord.getBigDecimal("ssr");
            long areaId = areaRecord.getLong("area.id");
            BigDecimal ssr = BigDecimal.ZERO;
            DynamicObject assessForm = areaAssessFormMap.get(areaId);
            if (assessForm == null) continue;
            DynamicObjectCollection indEvalRecordEntry = areaRecord.getDynamicObjectCollection("entryentity");
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(assessForm.getString("scorecalcway"))) {
                for (DynamicObject indEvalRecord : indEvalRecordEntry) {
                    DynamicObject indicator = indEvalRecord.getDynamicObject("indicator");
                    BigDecimal weight = indicator.getBigDecimal("weight");
                    BigDecimal hundred = new BigDecimal("100");
                    boolean exculudeCalSsr = this.isExculudeCalSsr(excludeTaskIndicatorMap, indEvalRecord);
                    if (exculudeCalSsr) continue;
                    BigDecimal percent = weight.divide(hundred, 10, RoundingMode.HALF_UP);
                    BigDecimal soe = indEvalRecord.getBigDecimal(AssessScoreAbbrEnum.SOE.getCode());
                    BigDecimal soeRes = soe.multiply(percent);
                    ssr = ssr.add(soeRes);
                }
                Iterator areaScoreSys = null;
                long actevalobjID = areaRecord.getLong("actevalobj");
                Map insConfMap = (Map)actEvalObjAreaMap.get(actevalobjID);
                if (insConfMap != null) {
                    Long configID = (Long)insConfMap.get(areaId);
                    areaScoreSys = (DynamicObject)configScoreSystemMap.get(configID);
                }
                ssr = this.scoreSystemExchangeScale(ssr, assessForm, (DynamicObject)areaScoreSys);
            } else if (ScoreCalcWayEnum.SUM.getValue().equals(assessForm.getString("scorecalcway"))) {
                for (DynamicObject indEvalRecord : indEvalRecordEntry) {
                    BigDecimal ies = indEvalRecord.getBigDecimal(AssessScoreAbbrEnum.SOE.getCode());
                    boolean exculudeCalSsr = this.isExculudeCalSsr(excludeTaskIndicatorMap, indEvalRecord);
                    if (exculudeCalSsr) continue;
                    ssr = ssr.add(ies);
                }
            }
            Tuple<Integer, Integer> scale = this.getScale(assessForm);
            if (ssr != null) {
                ssr = ssr.setScale((int)((Integer)scale.item1), (Integer)scale.item2);
            }
            if ((compareOldSsr = oldSSR) == null) {
                compareOldSsr = BigDecimal.ZERO;
            }
            if ((compareNewSsr = ssr) == null) {
                compareNewSsr = BigDecimal.ZERO;
            }
            if (compareOldSsr == null || compareOldSsr.compareTo(compareNewSsr) == 0) continue;
            areaRecord.set("modifytime", (Object)date);
            areaRecord.set("modifier", (Object)currUserId);
            areaRecord.set("ssr", (Object)ssr);
            updateSSREvalRecordList.add(areaRecord);
        }
        return updateSSREvalRecordList;
    }

    private boolean isExculudeCalSsr(Map<Long, List<Long>> excludeTaskIndicatorMap, DynamicObject indEvalRecord) {
        long indFlowruTaskID = indEvalRecord.getLong("indflowrutask");
        DynamicObject indicator = indEvalRecord.getDynamicObject("indicator");
        if (excludeTaskIndicatorMap != null) {
            List<Long> exculudeInds = excludeTaskIndicatorMap.get(indFlowruTaskID);
            if (indicator != null) {
                long indId = indicator.getLong("id");
                if (exculudeInds != null && exculudeInds.contains(indId)) {
                    return true;
                }
            }
        }
        return false;
    }

    private BigDecimal scoreSystemExchangeNScale(BigDecimal ssr, DynamicObject assessForm, DynamicObject areaScoreSystem) {
        DynamicObject scoreSystem = assessForm.getDynamicObject("scoresystem");
        Tuple<Integer, Integer> scale = this.getScale(assessForm);
        if (HRStringUtils.equals((String)"1", (String)assessForm.getString("consistentwitharea"))) {
            if (scoreSystem.getLong("id") != areaScoreSystem.getLong("id")) {
                BigDecimal areaMaxScore = areaScoreSystem.getBigDecimal("maxscore");
                BigDecimal formMaxScore = scoreSystem.getBigDecimal("maxscore");
                ssr = ssr.multiply(formMaxScore).divide(areaMaxScore, (int)((Integer)scale.item1), (Integer)scale.item2);
            }
        } else {
            ssr = ssr.setScale((int)((Integer)scale.item1), (Integer)scale.item2);
        }
        return ssr;
    }

    private boolean isConsistentWithArea(DynamicObject assessForm, long areaScoreSystemId) {
        DynamicObject scoreSystem = assessForm.getDynamicObject("scoresystem");
        long formScoreSystemId = scoreSystem.getLong("id");
        String consistentWithArea = assessForm.getString("consistentwitharea");
        return !"0".equals(consistentWithArea) || areaScoreSystemId == formScoreSystemId;
    }

    private BigDecimal scoreSystemExchangeScale(BigDecimal ssr, DynamicObject assessForm, DynamicObject areaScoreSystem) {
        DynamicObject scoreSystem = assessForm.getDynamicObject("scoresystem");
        Tuple<Integer, Integer> scale = this.getScale(assessForm);
        long areaScoreSysId = 0L;
        if (areaScoreSystem != null) {
            areaScoreSysId = areaScoreSystem.getLong("id");
        }
        if (!this.isConsistentWithArea(assessForm, areaScoreSysId)) {
            BigDecimal areaMaxScore = scoreSystem.getBigDecimal("maxscore");
            if (areaScoreSystem != null) {
                areaMaxScore = areaScoreSystem.getBigDecimal("maxscore");
            }
            BigDecimal formMaxScore = scoreSystem.getBigDecimal("maxscore");
            ssr = ssr.multiply(formMaxScore).divide(areaMaxScore, (int)((Integer)scale.item1), (Integer)scale.item2);
        } else {
            ssr = ssr.setScale((int)((Integer)scale.item1), (Integer)scale.item2);
        }
        return ssr;
    }

    private Tuple<Integer, Integer> getScale(DynamicObject assessForm) {
        String scaleTypeStr = assessForm.getString("scaletype");
        String numAccuracy = assessForm.getString("numaccuracy");
        int scaleType = ScalaTypeEnum.get(scaleTypeStr).getType();
        if (HRStringUtils.isBlank((CharSequence)numAccuracy)) {
            numAccuracy = "2";
        }
        int scale = Integer.parseInt(numAccuracy);
        return Tuple.create((Object)scale, (Object)scaleType);
    }

    private Map<Long, DynamicObject> queryAreaAssessFormMap(DynamicObject[] areaIns) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)areaIns.length);
        Map<Long, Long> insActivityMap = Arrays.stream(areaIns).collect(Collectors.toMap(item -> item.getLong("id"), item2 -> item2.getLong("areaactivity")));
        Set activityIds = Arrays.stream(areaIns).map(item -> item.getLong("areaactivity")).collect(Collectors.toSet());
        DynamicObject[] activity = ASSESS_ACTIVITY_ENTITY_SERVICE.query("assessform", new QFilter("id", "in", activityIds).toArray());
        Map<Long, Long> actFormMap = Arrays.stream(activity).collect(Collectors.toMap(item -> item.getLong("id"), item2 -> item2.getLong("assessform.id")));
        Set assessFormIds = Arrays.stream(activity).map(item -> item.getLong("assessform.id")).collect(Collectors.toSet());
        DynamicObject[] assessForm = ASSESS_FORM_ENTITY.query("scorecalcway, scoresystem, evalway, numaccuracy, scaletype, allowexceedupper, limitmaxscore, allowexceedlower, limitminscore, consistentwitharea", new QFilter("id", "in", assessFormIds).toArray());
        Map<Long, DynamicObject> idAssessFormMap = Arrays.stream(assessForm).collect(Collectors.toMap(item -> item.getLong("id"), item2 -> item2));
        for (Map.Entry<Long, Long> entry : insActivityMap.entrySet()) {
            ret.put(entry.getKey(), idAssessFormMap.get(actFormMap.get(entry.getValue())));
        }
        return ret;
    }

    public DynamicObject queryCustomAreaEvalRecordByConfId(Long taskId, Long confId) {
        QFilter objCustFilter = new QFilter("flowrutask", "=", (Object)taskId);
        objCustFilter.and(new QFilter("areaconf", "=", (Object)confId));
        return CUSTOM_AREA_RECORD_ENTITY.queryOne("id, customfield1, customfield2, customfield3, customfield4, customfield5, customfield6, customfield7, customfield8, customfield9, customfield10,iscanedit,modifytime", new QFilter[]{objCustFilter});
    }

    public DynamicObject[] queryBatchAdjScoreRecord(long objId) {
        QFilter objFilter = new QFilter("actevalobj", "=", (Object)objId);
        return EVAL_ADJUSTMENT_ENTITY.query("flowrunode, flowrurole, flowrutask.hadder, flowrutask.taskstatus, batcs, atcs, batcl, batcl, atcl, ins", new QFilter[]{objFilter});
    }

    public DynamicObject[] queryAdjRecordByActEvalObjId(Long actEvalObjId) {
        QFilter adjFilter = new QFilter("actevalobj", "=", (Object)actEvalObjId);
        adjFilter.and(new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode()));
        return EVAL_ADJUSTMENT_ENTITY.queryOriginalArray("atcs, ins, atcl, actevalobj, flowrutask.id, flowrutask.taskstatus", new QFilter[]{adjFilter}, "modifytime desc");
    }

    public DynamicObject[] querySumRecordByActEvalObjId(Long actEvalObjId) {
        QFilter sumRecordFilter = new QFilter("actevalobj", "=", (Object)actEvalObjId);
        QFilter taskStatus = new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        return OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.query("actevalobj, ose, ole, eval, flowrutask, flowrutask.taskstatus, flowrutask.handler, flowrunode.iscrossnode", new QFilter[]{sumRecordFilter, taskStatus}, "modifytime desc");
    }

    public DynamicObject queryAssessFormByTaskId(Long taskId) {
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity", new QFilter[]{taskFilter});
        QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        return ASSESS_FORM_ENTITY_SERVICE.queryOne("allowexceedupper, allowexceedlower, limitmaxscore, limitminscore, scoresystem, evalway, scaletype, numaccuracy, sumconf, sumperflevel ", new QFilter[]{assessFormFilter});
    }

    public DynamicObject[] queryTaskById(List<Long> taskIdList) {
        QFilter taskFilter = new QFilter("id", "in", taskIdList);
        return FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalArray("id, activity,flowruproc.id, flowrunode.id, flowrunode.index, flowrunode.iscrossnode, flowrunode.name, flowrunode.nodeweight, flowrunode.flownodedef.id, flowrurole.name,flowrurole.id,  taskstatus, handler.id, handler.picturefield, handler.name,flowrurole.turnoversort", new QFilter[]{taskFilter}, "flowrunode.index desc");
    }

    public List<ComboItem> queryPerfLevelItemByLevel(Long perfLevelId) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        if (perfLevelId == 0L) {
            return comboItems;
        }
        DynamicObject perfLevelDy = PERF_LEVEL_ENTITY.queryOne((Object)perfLevelId);
        DynamicObjectCollection levelConf = perfLevelDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject level : levelConf) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(level.getString("levelname")));
            comboItem.setValue(level.getString("seq"));
            comboItems.add(comboItem);
        }
        return comboItems;
    }

    public WorkflowRuProcBo getRuProcInstance(Long evalflowinsId) {
        return FLOW_RUN_SUP_DOMAIN_SERVICE.getRuProcInstance(evalflowinsId);
    }

    public DynamicObject[] queryNdrRecordByActEvalObjId(Long actEvalObjId) {
        QFilter activityFilter = new QFilter("actevalobj", "=", (Object)actEvalObjId);
        return OBJ_NODE_RES_ENTITY_SERVICE.queryOriginalArray("flowruproc, flowrunode, sont, activity, actevalobj", new QFilter[]{activityFilter});
    }

    public DynamicObject queryAdjRecordByTask(Long taskId) {
        QFilter adjFilter = new QFilter("flowrutask.id", "=", (Object)taskId);
        return EVAL_ADJUSTMENT_ENTITY.queryOne("atcs, ins, atcl, actevalobj, flowrutask.id, flowrutask.taskstatus", new QFilter[]{adjFilter});
    }

    public IndicatorEvalRecordBo queryPreTaskCrossEvalRecord(Map<Long, List<Long>> taskMap, AreaRegEnum areaRegEnum) {
        IndicatorEvalRecordBo indicatorEvalRecordBo = new IndicatorEvalRecordBo();
        HashMap<Long, List<Long>> taskMapTmp = null;
        for (Map.Entry<Long, List<Long>> taskEntry : taskMap.entrySet()) {
            taskMapTmp = new HashMap<Long, List<Long>>(16);
            Long taskId = taskEntry.getKey();
            List<Long> indIdList = taskEntry.getValue();
            taskMapTmp.put(taskId, indIdList);
            FlowPreTaskResultBo flowPreTaskResultBo = FLOW_RUN_SUP_DOMAIN_SERVICE.getPreTask(taskMapTmp, false);
            FlowPreTaskResultBo flowPreTaskScoreResultBo = FLOW_RUN_SUP_DOMAIN_SERVICE.getPreTask(taskMapTmp, true);
            Map<Long, DynamicObject> finishIndicatorMap = this.getIndicatorEvalRecordMap(flowPreTaskResultBo, areaRegEnum);
            finishIndicatorMap = finishIndicatorMap.entrySet().stream().filter(entry -> indIdList.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<Long, DynamicObject> scoreIndicatorMap = this.getIndicatorEvalRecordMap(flowPreTaskScoreResultBo, areaRegEnum);
            scoreIndicatorMap = scoreIndicatorMap.entrySet().stream().filter(entry -> indIdList.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<Long, DynamicObject> finishEvalRecordMap = indicatorEvalRecordBo.getFinishEvalRecordMap();
            if (finishEvalRecordMap == null) {
                finishEvalRecordMap = finishIndicatorMap;
            } else {
                finishEvalRecordMap.putAll(finishIndicatorMap);
            }
            indicatorEvalRecordBo.setFinishEvalRecordMap(finishEvalRecordMap);
            Map<Long, DynamicObject> scoreEvalRecordMap = indicatorEvalRecordBo.getScoreEvalRecordMap();
            if (scoreEvalRecordMap == null) {
                scoreEvalRecordMap = scoreIndicatorMap;
            } else {
                scoreEvalRecordMap.putAll(scoreIndicatorMap);
            }
            indicatorEvalRecordBo.setScoreEvalRecordMap(scoreEvalRecordMap);
        }
        return indicatorEvalRecordBo;
    }

    private Map<Long, DynamicObject> getIndicatorEvalRecordMap(FlowPreTaskResultBo flowPreTaskResultBo, AreaRegEnum areaRegEnum) {
        if (flowPreTaskResultBo != null) {
            Boolean cross = flowPreTaskResultBo.getCross();
            if (cross == null) {
                return new HashMap<Long, DynamicObject>(16);
            }
            if (cross.booleanValue()) {
                Map<Long, DynamicObject> finishIndicatorEvalRecord = this.getIndEvalRecordMap(flowPreTaskResultBo, areaRegEnum);
                return finishIndicatorEvalRecord;
            }
            Long preTaskId = flowPreTaskResultBo.getPreTask();
            if (preTaskId != null) {
                Map<Long, DynamicObject> finishIndicatorEvalRecord = this.queryIndicatorEvalRecord(preTaskId, areaRegEnum);
                return finishIndicatorEvalRecord;
            }
        }
        return new HashMap<Long, DynamicObject>(16);
    }

    private Map<Long, DynamicObject> getIndEvalRecordMap(FlowPreTaskResultBo flowPreTaskResultBo, AreaRegEnum areaRegEnum) {
        Map indicatorTaskMap = flowPreTaskResultBo.getIndicatorTaskMap();
        HashMap taskIndicatorMap = new HashMap(16);
        HashMap<Long, DynamicObject> finishIndicatorEvalRecord = new HashMap<Long, DynamicObject>(16);
        if (indicatorTaskMap != null) {
            Long taskId;
            for (Map.Entry entry : indicatorTaskMap.entrySet()) {
                if (entry == null) continue;
                Long indicatorId = (Long)entry.getKey();
                taskId = (Long)entry.getValue();
                if (taskId == null) continue;
                List<Long> indicatorIds = taskIndicatorMap.get(taskId) == null ? new ArrayList(10) : (List)taskIndicatorMap.get(taskId);
                indicatorIds.add(indicatorId);
                taskIndicatorMap.put(taskId, indicatorIds);
            }
            if (taskIndicatorMap != null) {
                for (Map.Entry next : taskIndicatorMap.entrySet()) {
                    if (next == null) continue;
                    taskId = (Long)next.getKey();
                    List indicatorIDs = (List)next.getValue();
                    if (taskId == null || indicatorIDs == null) continue;
                    Map<Long, DynamicObject> indicatorEvalRecord = this.queryIndicatorEvalRecord(taskId, indicatorIDs, areaRegEnum);
                    finishIndicatorEvalRecord.putAll(indicatorEvalRecord);
                }
            }
        }
        return finishIndicatorEvalRecord;
    }

    public void saveUpdateCustomArea(DynamicObject custObj) {
        Long flowrutaskId = custObj.getLong("flowrutask");
        Long confId = custObj.getLong("areaconf");
        QFilter custFilter = new QFilter("flowrutask", "=", (Object)flowrutaskId);
        custFilter.and(new QFilter("areaconf", "=", (Object)confId));
        Long userId = UserServiceHelper.getCurrentUserId();
        DynamicObject customArea = CUSTOM_AREA_RECORD_ENTITY.queryOne("customfield1, customfield2, customfield3, customfield4, customfield5, customfield6, customfield7, customfield8, customfield9, customfield10,flowruproc, flowrunode, flowrurole, flowrutask, assessyear, assessperiod, activity, perforg, actevalobj, areaconf, creator, createtime, modifier, modifytime", new QFilter[]{custFilter});
        if (HRObjectUtils.isEmpty((Object)customArea)) {
            Long areainsId = DBServiceHelper.genLongIds((String)"epa_objcustomareains", (int)1)[0];
            DynamicObject customAreaObj = CUSTOM_AREA_RECORD_ENTITY.generateEmptyDynamicObject();
            customAreaObj.set("id", (Object)areainsId);
            customAreaObj.set("customfield1", (Object)custObj.getString("customfield1"));
            customAreaObj.set("customfield2", (Object)custObj.getString("customfield2"));
            customAreaObj.set("customfield3", (Object)custObj.getString("customfield3"));
            customAreaObj.set("customfield4", (Object)custObj.getDynamicObjectCollection("customfield4"));
            customAreaObj.set("customfield5", (Object)custObj.getString("customfield5"));
            customAreaObj.set("customfield6", (Object)custObj.getString("customfield6"));
            customAreaObj.set("customfield7", (Object)custObj.getString("customfield7"));
            customAreaObj.set("customfield8", (Object)custObj.getString("customfield8"));
            customAreaObj.set("customfield9", (Object)custObj.getDynamicObjectCollection("customfield9"));
            customAreaObj.set("customfield10", (Object)custObj.getDynamicObjectCollection("customfield10"));
            customAreaObj.set("flowruproc", (Object)custObj.getLong("flowruproc"));
            customAreaObj.set("flowrunode", (Object)custObj.getLong("flowrunode"));
            customAreaObj.set("flowrurole", (Object)custObj.getLong("flowrurole"));
            customAreaObj.set("flowrutask", (Object)custObj.getLong("flowrutask"));
            customAreaObj.set("assessyear", (Object)custObj.getLong("assessyear"));
            customAreaObj.set("assessperiod", (Object)custObj.getString("assessperiod"));
            customAreaObj.set("activity", (Object)custObj.getLong("activity"));
            customAreaObj.set("perforg", (Object)custObj.getLong("perforg"));
            customAreaObj.set("actevalobj", (Object)custObj.getLong("actevalobj"));
            customAreaObj.set("areaconf", (Object)custObj.getLong("areaconf"));
            customAreaObj.set("creator", (Object)userId);
            customAreaObj.set("createtime", (Object)new Date());
            customAreaObj.set("modifier", (Object)userId);
            customAreaObj.set("modifytime", (Object)new Date());
            CUSTOM_AREA_RECORD_ENTITY.saveOne(customArea);
        } else {
            customArea.set("customfield1", (Object)custObj.getString("customfield1"));
            customArea.set("customfield2", (Object)custObj.getString("customfield2"));
            customArea.set("customfield3", (Object)custObj.getString("customfield3"));
            customArea.set("customfield4", (Object)custObj.getDynamicObjectCollection("customfield4"));
            customArea.set("customfield5", (Object)custObj.getString("customfield5"));
            customArea.set("customfield6", (Object)custObj.getString("customfield6"));
            customArea.set("customfield7", (Object)custObj.getString("customfield7"));
            customArea.set("customfield8", (Object)custObj.getString("customfield8"));
            customArea.set("customfield9", (Object)custObj.getDynamicObjectCollection("customfield9"));
            customArea.set("customfield10", (Object)custObj.getDynamicObjectCollection("customfield10"));
            customArea.set("modifier", (Object)userId);
            customArea.set("modifytime", (Object)new Date());
            CUSTOM_AREA_RECORD_ENTITY.updateOne(customArea);
        }
    }

    public DynamicObject[] querySumAreaEvalRecordByTaskIds(List<Long> taskIds) {
        QFilter taskIdsFilter = new QFilter("flowrutask", "in", taskIds);
        return SUM_AREA_RECORD_ENTITY.queryOriginalArray("flowrutask.id,flowrutask.taskstatus,ose,ole,activity", new QFilter[]{taskIdsFilter});
    }

    public Map<String, BigDecimal> getScoreRangeMap(Long actEvalObjId) {
        String evasumlimitStr;
        HashMap<String, BigDecimal> scoreRangeMap = new HashMap<String, BigDecimal>(16);
        BigDecimal maxScore = BigDecimal.ZERO;
        BigDecimal minScore = BigDecimal.ZERO;
        QFilter actEvalObjFilter = new QFilter("id", "=", (Object)actEvalObjId);
        DynamicObject actEvalObj = ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.queryOne("activity, areaentry.areareg, areaentry.areains, areaentry.areaconf", new QFilter[]{actEvalObjFilter});
        Long activityId = actEvalObj.getLong("activity.id");
        QFilter activityFilter = new QFilter("id", "=", (Object)activityId);
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform", new QFilter[]{activityFilter});
        Long assessFormId = activityObj.getLong("assessform.id");
        QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
        DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryOne("scaletype, evasumlimit, limitmaxscore, limitminscore, scoresystem, evalway, scorecalcway, numaccuracy, sumconf, sumperflevel", new QFilter[]{assessFormFilter});
        String evalWayStr = assessForm.getString("evalway");
        EvalWayEnum evalWay = EvalWayEnum.getEvalWay((String)evalWayStr);
        String scoreCalcWayStr = assessForm.getString("scorecalcway");
        ScoreCalcWayEnum scoreCalcWay = ScoreCalcWayEnum.getScoreCalcWay((String)scoreCalcWayStr);
        Long scoreSystemId = assessForm.getLong("scoresystem.id");
        DynamicObject scoreSystemDy = SCORE_SYSTEM_ENTITY.queryOne((Object)scoreSystemId);
        BigDecimal maxSysScore = BigDecimal.ZERO;
        if (scoreSystemDy != null) {
            maxSysScore = scoreSystemDy.getBigDecimal("maxscore") == null ? BigDecimal.ZERO : scoreSystemDy.getBigDecimal("maxscore");
            BigDecimal bigDecimal = minScore = scoreSystemDy.getBigDecimal("minscore") == null ? BigDecimal.ZERO : scoreSystemDy.getBigDecimal("minscore");
        }
        if (HRStringUtils.isNotEmpty((String)(evasumlimitStr = assessForm.getString("evasumlimit")))) {
            EvaSumLimit evaSumLimit = EvaSumLimit.getEvaSumLimit((String)evasumlimitStr);
            switch (evaSumLimit) {
                case NOT_LIMIT: {
                    DynamicObject[] addSubAreaInsObjs;
                    List partinASAreaConfIdList;
                    QFilter addSubAreaConfFilter;
                    DynamicObject[] addSubAreaConfObjs;
                    DynamicObjectCollection areaEntry = actEvalObj.getDynamicObjectCollection("areaentry");
                    ArrayList<Long> genAreaConfIdList = new ArrayList<Long>(10);
                    List<Object> genAreaInsIdList = new ArrayList(10);
                    ArrayList<Long> addSubAreaConfIdList = new ArrayList<Long>(10);
                    List<Object> addSubAreaInsIdList = new ArrayList(10);
                    for (DynamicObject area : areaEntry) {
                        Long areaRegId = area.getLong("areareg.id");
                        Long areaConfId = area.getLong("areaconf");
                        if (AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaRegId)) {
                            genAreaConfIdList.add(areaConfId);
                            continue;
                        }
                        if (!AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaRegId)) continue;
                        addSubAreaConfIdList.add(areaConfId);
                    }
                    QFilter genAreaConfFilter = new QFilter("id", "in", genAreaConfIdList);
                    DynamicObject[] genAreaConfObjs = NORMAL_CONFIG_ENTITY_SERVICE.queryOriginalArray("id, isalloweval, ispartin, areascore, weight", new QFilter[]{genAreaConfFilter});
                    List partinGenAreaConfIdList = Arrays.asList(genAreaConfObjs).stream().filter(obj -> obj.getBoolean("isalloweval") && obj.getBoolean("ispartin")).map(obj -> obj.getLong("id")).collect(Collectors.toList());
                    if (partinGenAreaConfIdList != null && !partinGenAreaConfIdList.isEmpty()) {
                        DynamicObject[] genAreaInsObjs;
                        genAreaInsIdList = areaEntry.stream().filter(obj -> partinGenAreaConfIdList.contains(obj.getLong("areaconf"))).map(obj -> obj.getLong("areains")).collect(Collectors.toList());
                        QFilter genAreaFilter = new QFilter("id", "in", genAreaInsIdList);
                        for (DynamicObject dynamicObject : genAreaInsObjs = OBJ_GEN_AREA_INS_ENTITY_SERVICE.queryOriginalArray("areaweight, areascore", new QFilter[]{genAreaFilter})) {
                            if (scoreCalcWay == ScoreCalcWayEnum.SUM) {
                                BigDecimal areaScore = dynamicObject.getBigDecimal("areascore");
                                maxScore = maxScore.add(areaScore);
                                continue;
                            }
                            if (scoreCalcWay != ScoreCalcWayEnum.WEIGHT) continue;
                            BigDecimal weight = dynamicObject.getBigDecimal("areaweight");
                            BigDecimal weightPercent = weight.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP);
                            BigDecimal areaScore = maxSysScore.multiply(weightPercent);
                            maxScore = maxScore.add(areaScore);
                        }
                    }
                    if ((addSubAreaConfObjs = PLUS_MINUS_CONFIG_ENTITY_SERVICE.queryOriginalArray("id, ispartin", new QFilter[]{addSubAreaConfFilter = new QFilter("id", "in", addSubAreaConfIdList)})) == null || addSubAreaConfObjs.length <= 0 || (partinASAreaConfIdList = Arrays.asList(addSubAreaConfObjs).stream().filter(obj -> obj.getBoolean("ispartin")).map(obj -> obj.getLong("id")).collect(Collectors.toList())) == null || partinASAreaConfIdList.isEmpty()) break;
                    addSubAreaInsIdList = areaEntry.stream().filter(obj -> partinASAreaConfIdList.contains(obj.getLong("areaconf"))).map(obj -> obj.getLong("areains")).collect(Collectors.toList());
                    QFilter addSubAreaFilter = new QFilter("id", "in", addSubAreaInsIdList);
                    for (DynamicObject addSubAreaIns : addSubAreaInsObjs = OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.queryOriginalArray("minareascore, maxareascore, ispartin", new QFilter[]{addSubAreaFilter})) {
                        BigDecimal maxAreaScore = addSubAreaIns.getBigDecimal("maxareascore");
                        maxScore = maxScore.add(maxAreaScore);
                        BigDecimal minAreaScore = addSubAreaIns.getBigDecimal("minareascore");
                        minScore = minScore.add(minAreaScore);
                    }
                    break;
                }
                case SUM_LIMIT: {
                    DynamicObject[] genAreaInsObjs;
                    DynamicObjectCollection areaEntry = actEvalObj.getDynamicObjectCollection("areaentry");
                    ArrayList<Long> genAreaConfIdList = new ArrayList<Long>(10);
                    for (DynamicObject area : areaEntry) {
                        Long areaRegId = area.getLong("areareg.id");
                        Long l = area.getLong("areaconf");
                        if (!AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaRegId)) continue;
                        genAreaConfIdList.add(l);
                    }
                    QFilter genAreaConfFilter = new QFilter("id", "in", genAreaConfIdList);
                    DynamicObject[] genAreaConfObjs = NORMAL_CONFIG_ENTITY_SERVICE.queryOriginalArray("id, isalloweval, ispartin, areascore, weight", new QFilter[]{genAreaConfFilter});
                    List partinGenAreaConfIdList = Arrays.asList(genAreaConfObjs).stream().filter(obj -> obj.getBoolean("isalloweval") && obj.getBoolean("ispartin")).map(obj -> obj.getLong("id")).collect(Collectors.toList());
                    if (partinGenAreaConfIdList == null || partinGenAreaConfIdList.isEmpty()) break;
                    List genAreaInsIdList = areaEntry.stream().filter(obj -> partinGenAreaConfIdList.contains(obj.getLong("areaconf"))).map(obj -> obj.getLong("areains")).collect(Collectors.toList());
                    QFilter genAreaFilter = new QFilter("id", "in", genAreaInsIdList);
                    for (DynamicObject genAreaInsObj : genAreaInsObjs = OBJ_GEN_AREA_INS_ENTITY_SERVICE.queryOriginalArray("areaweight, areascore", new QFilter[]{genAreaFilter})) {
                        if (scoreCalcWay == ScoreCalcWayEnum.SUM) {
                            BigDecimal areaScore = genAreaInsObj.getBigDecimal("areascore");
                            maxScore = maxScore.add(areaScore);
                            continue;
                        }
                        if (scoreCalcWay != ScoreCalcWayEnum.WEIGHT) continue;
                        BigDecimal weight = genAreaInsObj.getBigDecimal("areaweight");
                        BigDecimal weightPercent = weight.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP);
                        BigDecimal areaScore = maxSysScore.multiply(weightPercent);
                        maxScore = maxScore.add(areaScore);
                    }
                    break;
                }
                case APPOINT_SUM_LIMIT: {
                    maxScore = assessForm.getBigDecimal("limitmaxscore") == null ? BigDecimal.ZERO : assessForm.getBigDecimal("limitmaxscore");
                    minScore = assessForm.getBigDecimal("limitminscore") == null ? BigDecimal.ZERO : assessForm.getBigDecimal("limitminscore");
                    break;
                }
            }
        }
        scoreRangeMap.put("maxscore", maxScore);
        scoreRangeMap.put("minscore", minScore);
        return scoreRangeMap;
    }

    private Map<Long, List<Long>> queryEvalObjAreaEntry2Map(Long actEvalObjId) {
        QFilter filter = new QFilter("id", "=", (Object)actEvalObjId);
        DynamicObject[] actObjAreaEntryArr = ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.queryOriginalArray("id,areaentry.areareg.id,areaentry.areains", new QFilter[]{filter});
        HashMap<Long, List<Long>> listMap = new HashMap<Long, List<Long>>(16);
        if (actObjAreaEntryArr != null) {
            for (DynamicObject actObjAreaEntry : actObjAreaEntryArr) {
                if (actObjAreaEntry == null) continue;
                long areaRegId = actObjAreaEntry.getLong("areaentry.areareg.id");
                long areaIns = actObjAreaEntry.getLong("areaentry.areains");
                List<Long> areaInsList = listMap.get(areaRegId) == null ? new ArrayList(10) : (List)listMap.get(areaRegId);
                areaInsList.add(areaIns);
                listMap.put(areaRegId, areaInsList);
            }
        }
        return listMap;
    }

    private void judgeObjNotNull(Object obj, String paramName) {
        if (obj == null) {
            String msg = String.format("%s param can not be null", paramName);
            throw new KDBizException(msg);
        }
    }

    private void genNewSumAreaRecord(Map<Long, DynamicObject[]> taskAreaRecordMap, RuTaskEvalBo taskEvalBo) {
        if (taskAreaRecordMap == null) {
            return;
        }
        OpmcEntityService entityService = AREA_RECORD_ENTITYSERVICE_MAP.get(AssessRuleConstants.SUM_AREA_PK);
        ArrayList<DynamicObject> saveDyList = new ArrayList<DynamicObject>(10);
        DynamicObject[] dynamicObjectArray = taskAreaRecordMap.get(AssessRuleConstants.SUM_AREA_PK);
        if (dynamicObjectArray != null && dynamicObjectArray.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjectArray) {
                if (dynamicObject == null) continue;
                DynamicObject newDynamicObj = entityService.generateEmptyDynamicObject();
                newDynamicObj.set("flowrutask", (Object)taskEvalBo.getTaskId());
                newDynamicObj.set("flowruproc", (Object)taskEvalBo.getFlowruProcId());
                newDynamicObj.set("flowrunode", (Object)taskEvalBo.getFlowruNodeId());
                newDynamicObj.set("flowrurole", (Object)taskEvalBo.getFlowruroleId());
                Date date = new Date();
                newDynamicObj.set("createtime", (Object)date);
                newDynamicObj.set("modifytime", (Object)date);
                for (String field : SYNC_FIELDS) {
                    newDynamicObj.set(field, dynamicObject.get(field));
                }
                saveDyList.add(newDynamicObj);
            }
        }
        if (!saveDyList.isEmpty()) {
            DynamicObject[] saveArr = new DynamicObject[saveDyList.size()];
            DynamicObject[] saveDyListArray = saveDyList.toArray(saveArr);
            QFilter filter = new QFilter("flowrutask", "=", (Object)taskEvalBo.getTaskId());
            entityService.deleteByFilter(new QFilter[]{filter});
            entityService.save(saveDyListArray);
        }
    }

    private void genNewCustomAreaRecord(Map<Long, DynamicObject[]> taskAreaRecordMap, RuTaskEvalBo taskEvalBo) {
        if (taskAreaRecordMap == null) {
            return;
        }
        OpmcEntityService entityService = AREA_RECORD_ENTITYSERVICE_MAP.get(AssessRuleConstants.CUSTOM_AREA_PK);
        ArrayList<DynamicObject> saveDyList = new ArrayList<DynamicObject>(10);
        DynamicObject[] dynamicObjectArray = taskAreaRecordMap.get(AssessRuleConstants.CUSTOM_AREA_PK);
        if (dynamicObjectArray != null && dynamicObjectArray.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjectArray) {
                long confId;
                DynamicObject indicatorDy;
                if (dynamicObject == null) continue;
                DynamicObject newDynamicObj = entityService.generateEmptyDynamicObject();
                newDynamicObj.set("flowrutask", (Object)taskEvalBo.getTaskId());
                newDynamicObj.set("flowruproc", (Object)taskEvalBo.getFlowruProcId());
                newDynamicObj.set("flowrunode", (Object)taskEvalBo.getFlowruNodeId());
                newDynamicObj.set("flowrurole", (Object)taskEvalBo.getFlowruroleId());
                Date date = new Date();
                newDynamicObj.set("createtime", (Object)date);
                newDynamicObj.set("modifytime", (Object)date);
                for (String field : CUSTOM_SYNC_FIELDS) {
                    newDynamicObj.set(field, dynamicObject.get(field));
                }
                Long preRoleTaskId = this.queryPreRoleOfNoCrossLastTask(taskEvalBo.getTaskId());
                if (preRoleTaskId != null && !ObjectUtils.isEmpty((Object)(indicatorDy = this.queryCustomAreaEvalRecordByConfId(preRoleTaskId, confId = dynamicObject.getLong("areaconf"))))) {
                    String fieldKey;
                    int i;
                    for (i = 0; i < CUSTOM_LANG_FIELDS.length; ++i) {
                        fieldKey = CUSTOM_LANG_FIELDS[i];
                        newDynamicObj.set(fieldKey, indicatorDy.get(fieldKey));
                    }
                    for (i = 0; i < CUSTOM_ATTACH_FIELDS.length; ++i) {
                        fieldKey = CUSTOM_ATTACH_FIELDS[i];
                        DynamicObjectCollection attachColl = indicatorDy.getDynamicObjectCollection(fieldKey);
                        DynamicObjectType objectType = attachColl.getDynamicObjectType();
                        MulBasedataDynamicObjectCollection newAttachColl = new MulBasedataDynamicObjectCollection(objectType, (Object)newDynamicObj);
                        if (attachColl != null) {
                            for (DynamicObject attach : attachColl) {
                                if (attach == null) continue;
                                DynamicObject copedDy = new DynamicObject(attach.getDynamicObjectType());
                                DynamicObjectUtils.copy((DynamicObject)attach, (DynamicObject)copedDy);
                                newAttachColl.add((Object)copedDy);
                            }
                        }
                        if (newAttachColl.size() <= 0) continue;
                        newDynamicObj.set(fieldKey, (Object)newAttachColl);
                    }
                }
                saveDyList.add(newDynamicObj);
            }
        }
        if (!saveDyList.isEmpty()) {
            DynamicObject[] saveArr = new DynamicObject[saveDyList.size()];
            DynamicObject[] saveDyListArray = saveDyList.toArray(saveArr);
            ArrayList<Long> areaInsIdList = new ArrayList<Long>(10);
            for (DynamicObject dynamicObject : saveDyListArray) {
                long areaId = dynamicObject.getLong("areaconf");
                areaInsIdList.add(areaId);
            }
            if (areaInsIdList.size() > 0) {
                QFilter qFilter = new QFilter("flowrutask", "=", (Object)taskEvalBo.getTaskId());
                qFilter.and(new QFilter("areaconf", "in", areaInsIdList));
                entityService.deleteByFilter(new QFilter[]{qFilter});
            }
            entityService.save(saveDyListArray);
        }
    }

    private void genNewAttachAreaRecord(Map<Long, DynamicObject[]> taskAreaRecordMap, RuTaskEvalBo taskEvalBo) {
        if (taskAreaRecordMap == null) {
            return;
        }
        OpmcEntityService entityService = AREA_RECORD_ENTITYSERVICE_MAP.get(AssessRuleConstants.ATTACH_AREA_PK);
        ArrayList<DynamicObject> saveDyList = new ArrayList<DynamicObject>(10);
        DynamicObject[] dynamicObjectArray = taskAreaRecordMap.get(AssessRuleConstants.ATTACH_AREA_PK);
        if (dynamicObjectArray != null) {
            for (DynamicObject dynamicObject : dynamicObjectArray) {
                if (dynamicObject == null) continue;
                DynamicObject newDynamicObj = entityService.generateEmptyDynamicObject();
                newDynamicObj.set("flowrutask", (Object)taskEvalBo.getTaskId());
                newDynamicObj.set("flowruproc", (Object)taskEvalBo.getFlowruProcId());
                newDynamicObj.set("flowrunode", (Object)taskEvalBo.getFlowruNodeId());
                newDynamicObj.set("flowrurole", (Object)taskEvalBo.getFlowruroleId());
                Date date = new Date();
                newDynamicObj.set("createtime", (Object)date);
                newDynamicObj.set("modifytime", (Object)date);
                for (String field : ATTACH_FIELDS) {
                    newDynamicObj.set(field, dynamicObject.get(field));
                }
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                if (entryentity != null && entryentity.size() > 0) {
                    DynamicObjectCollection newEntryColl = entityService.generateEmptyEntryCollection(newDynamicObj, "entryentity");
                    for (DynamicObject entry : entryentity) {
                        DynamicObject newEntryDy = entityService.generateEmptyEntryDynamicObject("entryentity");
                        newEntryDy.set("indflowrutask", (Object)taskEvalBo.getTaskId());
                        newEntryDy.set("indflowruproc", (Object)taskEvalBo.getFlowruProcId());
                        newEntryDy.set("indflowrunode", (Object)taskEvalBo.getFlowruNodeId());
                        newEntryDy.set("indflowrurole", (Object)taskEvalBo.getFlowruroleId());
                        newEntryDy.set("indcreatetime", (Object)date);
                        newEntryDy.set("indmodifytime", (Object)date);
                        for (String syncEntryField : ATTACH_SYNC_ENTRYFIELDS) {
                            newEntryDy.set(syncEntryField, entry.get(syncEntryField));
                        }
                        long aLong = newEntryDy.getLong("indicator.id");
                        newEntryColl.add((Object)newEntryDy);
                    }
                    Map<Long, DynamicObject> indEvalRecordMap = this.queryIndicatorEvalRecordOfPreRoleLastTaskNotCross(taskEvalBo.getTaskId(), AreaRegEnum.ATTACH_AREA);
                    if (indEvalRecordMap != null) {
                        for (DynamicObject newEntryObj : newEntryColl) {
                            long indicatorId = newEntryObj.getLong("indicator.id");
                            DynamicObject finishRecord = indEvalRecordMap.get(indicatorId);
                            if (finishRecord == null) continue;
                            newEntryObj.set("realfinishdate", finishRecord.get("realfinishdate"));
                            newEntryObj.set("customfield", finishRecord.get("customfield"));
                        }
                    }
                    if (newEntryColl != null && !newEntryColl.isEmpty()) {
                        newDynamicObj.set("entryentity", (Object)newEntryColl);
                    }
                }
                saveDyList.add(newDynamicObj);
            }
        }
        if (!saveDyList.isEmpty()) {
            DynamicObject[] saveArr = new DynamicObject[saveDyList.size()];
            DynamicObject[] saveDyListArray = saveDyList.toArray(saveArr);
            ArrayList<Long> areaInsIdList = new ArrayList<Long>(10);
            for (DynamicObject dynamicObject : saveDyListArray) {
                long areaId = dynamicObject.getLong("area.id");
                areaInsIdList.add(areaId);
            }
            if (areaInsIdList.size() > 0) {
                QFilter qFilter = new QFilter("flowrutask", "=", (Object)taskEvalBo.getTaskId());
                qFilter.and(new QFilter("area", "in", areaInsIdList));
                entityService.deleteByFilter(new QFilter[]{qFilter});
            }
            entityService.save(saveDyListArray);
        }
    }

    private void genNewAddSubAreaRecord(Map<Long, DynamicObject[]> taskAreaRecordMap, RuTaskEvalBo taskEvalBo) {
        if (taskAreaRecordMap == null) {
            return;
        }
        OpmcEntityService entityService = AREA_RECORD_ENTITYSERVICE_MAP.get(AssessRuleConstants.PLUS_MINUS_AREA_PK);
        ArrayList<DynamicObject> saveDyList = new ArrayList<DynamicObject>(10);
        DynamicObject[] dynamicObjectArray = taskAreaRecordMap.get(AssessRuleConstants.PLUS_MINUS_AREA_PK);
        if (dynamicObjectArray != null) {
            for (DynamicObject dynamicObject : dynamicObjectArray) {
                if (dynamicObject == null) continue;
                DynamicObject newDynamicObj = entityService.generateEmptyDynamicObject();
                newDynamicObj.set("flowrutask", (Object)taskEvalBo.getTaskId());
                newDynamicObj.set("flowruproc", (Object)taskEvalBo.getFlowruProcId());
                newDynamicObj.set("flowrunode", (Object)taskEvalBo.getFlowruNodeId());
                newDynamicObj.set("flowrurole", (Object)taskEvalBo.getFlowruroleId());
                newDynamicObj.set("nodeweight", (Object)taskEvalBo.getNodeWeight());
                newDynamicObj.set("roleweight", (Object)taskEvalBo.getRoleWeight());
                Date date = new Date();
                newDynamicObj.set("createtime", (Object)date);
                newDynamicObj.set("modifytime", (Object)date);
                for (String field : ADDSUB_FIELDS) {
                    newDynamicObj.set(field, dynamicObject.get(field));
                }
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                if (entryentity != null && entryentity.size() > 0) {
                    DynamicObjectCollection newEntryColl = entityService.generateEmptyEntryCollection(newDynamicObj, "entryentity");
                    for (DynamicObject entry : entryentity) {
                        DynamicObject newEntryDy = entityService.generateEmptyEntryDynamicObject("entryentity");
                        newEntryDy.set("indflowrutask", (Object)taskEvalBo.getTaskId());
                        newEntryDy.set("indflowruproc", (Object)taskEvalBo.getFlowruProcId());
                        newEntryDy.set("indflowrunode", (Object)taskEvalBo.getFlowruNodeId());
                        newEntryDy.set("indflowrurole", (Object)taskEvalBo.getFlowruroleId());
                        newEntryDy.set("indcreatetime", (Object)date);
                        newEntryDy.set("indmodifytime", (Object)date);
                        for (String syncEntryField : ADDSUB_SYNC_ENTRYFIELDS) {
                            newEntryDy.set(syncEntryField, entry.get(syncEntryField));
                        }
                        long aLong = newEntryDy.getLong("indicator.id");
                        newEntryColl.add((Object)newEntryDy);
                    }
                    Map<Long, DynamicObject> indEvalRecordMap = this.queryIndicatorEvalRecordOfPreRoleLastTaskNotCross(taskEvalBo.getTaskId(), AreaRegEnum.PLUS_MINUS_AREA);
                    if (indEvalRecordMap != null) {
                        for (DynamicObject newEntryObj : newEntryColl) {
                            long indicatorId = newEntryObj.getLong("indicator.id");
                            DynamicObject finishRecord = indEvalRecordMap.get(indicatorId);
                            if (finishRecord == null) continue;
                            newEntryObj.set("realfinishdate", finishRecord.get("realfinishdate"));
                            newEntryObj.set("qualityres", finishRecord.get("qualityres"));
                            newEntryObj.set("finishdesc", finishRecord.get("finishdesc"));
                        }
                    }
                    if (newEntryColl != null && !newEntryColl.isEmpty()) {
                        newDynamicObj.set("entryentity", (Object)newEntryColl);
                    }
                }
                saveDyList.add(newDynamicObj);
            }
        }
        if (!saveDyList.isEmpty()) {
            DynamicObject[] saveArr = new DynamicObject[saveDyList.size()];
            DynamicObject[] saveDyListArray = saveDyList.toArray(saveArr);
            ArrayList<Long> areaInsIdList = new ArrayList<Long>(10);
            for (DynamicObject dynamicObject : saveDyListArray) {
                long areaId = dynamicObject.getLong("area.id");
                areaInsIdList.add(areaId);
            }
            if (areaInsIdList.size() > 0) {
                QFilter qFilter = new QFilter("flowrutask", "=", (Object)taskEvalBo.getTaskId());
                qFilter.and(new QFilter("area", "in", areaInsIdList));
                entityService.deleteByFilter(new QFilter[]{qFilter});
            }
            entityService.save(saveDyListArray);
        }
    }

    private void genNewGenAreaRecordObject(Map<Long, DynamicObject[]> taskAreaRecordMap, RuTaskEvalBo taskEvalBo) {
        if (taskAreaRecordMap == null) {
            return;
        }
        OpmcEntityService entityService = AREA_RECORD_ENTITYSERVICE_MAP.get(AssessRuleConstants.NORM_INDCTR_AREA_PK);
        ArrayList<DynamicObject> saveDyList = new ArrayList<DynamicObject>(10);
        DynamicObject[] dynamicObjectArray = taskAreaRecordMap.get(AssessRuleConstants.NORM_INDCTR_AREA_PK);
        if (dynamicObjectArray != null) {
            for (DynamicObject dynamicObject : dynamicObjectArray) {
                if (dynamicObject == null) continue;
                DynamicObject newDynamicObj = entityService.generateEmptyDynamicObject();
                newDynamicObj.set("flowrutask", (Object)taskEvalBo.getTaskId());
                newDynamicObj.set("flowrunode", (Object)taskEvalBo.getFlowruNodeId());
                newDynamicObj.set("flowrurole", (Object)taskEvalBo.getFlowruroleId());
                newDynamicObj.set("nodeweight", (Object)taskEvalBo.getNodeWeight());
                newDynamicObj.set("roleweight", (Object)taskEvalBo.getRoleWeight());
                Date date = new Date();
                newDynamicObj.set("createtime", (Object)date);
                newDynamicObj.set("modifytime", (Object)date);
                for (String string : GEN_FIELDS) {
                    newDynamicObj.set(string, dynamicObject.get(string));
                }
                ArrayList<Long> indicatorIdList = new ArrayList<Long>(10);
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                if (entryentity != null && entryentity.size() > 0) {
                    DynamicObjectCollection newEntryColl = entityService.generateEmptyEntryCollection(newDynamicObj, "entryentity");
                    for (DynamicObject entry : entryentity) {
                        DynamicObject newEntryDy = entityService.generateEmptyEntryDynamicObject("entryentity");
                        newEntryDy.set("indflowrutask", (Object)taskEvalBo.getTaskId());
                        newEntryDy.set("indflowruproc", (Object)taskEvalBo.getFlowruProcId());
                        newEntryDy.set("indflowrunode", (Object)taskEvalBo.getFlowruNodeId());
                        newEntryDy.set("indflowrurole", (Object)taskEvalBo.getFlowruroleId());
                        newEntryDy.set("indcreatetime", (Object)date);
                        newEntryDy.set("indmodifytime", (Object)date);
                        for (String syncEntryField : GEN_SYNC_ENTRYFIELDS) {
                            newEntryDy.set(syncEntryField, entry.get(syncEntryField));
                        }
                        long aLong = newEntryDy.getLong("indicator.id");
                        indicatorIdList.add(aLong);
                        newEntryColl.add((Object)newEntryDy);
                    }
                    boolean bl = this.isCrossNodeOfPreRole(taskEvalBo.getTaskId());
                    Map<Object, Object> indEvalRecordMap = new HashMap(16);
                    if (!bl) {
                        indEvalRecordMap = this.queryIndicatorEvalRecordOfPreRoleLastTask(taskEvalBo.getTaskId(), AreaRegEnum.NORM_INDCTR_AREA);
                    } else {
                        HashMap<Long, List<Long>> taskMap = new HashMap<Long, List<Long>>(16);
                        taskMap.put(taskEvalBo.getTaskId(), indicatorIdList);
                        IndicatorEvalRecordBo evalRecordBo = this.queryPreTaskCrossEvalRecord(taskMap, AreaRegEnum.NORM_INDCTR_AREA);
                        if (evalRecordBo != null) {
                            indEvalRecordMap = evalRecordBo.getFinishEvalRecordMap();
                        }
                    }
                    if (indEvalRecordMap != null) {
                        for (DynamicObject newEntryObj : newEntryColl) {
                            long indicatorId = newEntryObj.getLong("indicator.id");
                            DynamicObject finishRecord = (DynamicObject)indEvalRecordMap.get(indicatorId);
                            if (finishRecord == null) continue;
                            newEntryObj.set("realfinishdate", finishRecord.get("realfinishdate"));
                            newEntryObj.set("qualityres", finishRecord.get("qualityres"));
                            newEntryObj.set("finishdesc", finishRecord.get("finishdesc"));
                            newEntryObj.set("customfiled1", finishRecord.get("customfiled1"));
                            newEntryObj.set("customfiled2", finishRecord.get("customfiled2"));
                            newEntryObj.set("customfiled3", finishRecord.get("customfiled3"));
                            newEntryObj.set("customfiled4", finishRecord.get("customfiled4"));
                            newEntryObj.set("customfiled5", finishRecord.get("customfiled5"));
                        }
                    }
                    if (newEntryColl != null && !newEntryColl.isEmpty()) {
                        newDynamicObj.set("entryentity", (Object)newEntryColl);
                    }
                }
                saveDyList.add(newDynamicObj);
            }
        }
        if (!saveDyList.isEmpty()) {
            DynamicObject[] saveArr = new DynamicObject[saveDyList.size()];
            DynamicObject[] saveDyListArray = saveDyList.toArray(saveArr);
            ArrayList<Long> areaInsIdList = new ArrayList<Long>(10);
            for (DynamicObject dynamicObject : saveDyListArray) {
                long areaId = dynamicObject.getLong("area.id");
                areaInsIdList.add(areaId);
            }
            if (areaInsIdList.size() > 0) {
                QFilter qFilter = new QFilter("flowrutask", "=", (Object)taskEvalBo.getTaskId());
                qFilter.and(new QFilter("area", "in", areaInsIdList));
                entityService.deleteByFilter(new QFilter[]{qFilter});
            }
            entityService.save(saveDyListArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean genEvalRecordForJump(Long taskId, Long actEvalObjId, List<Long> jumpTaskIds) {
        boolean isSuccess = true;
        this.judgeObjNotNull(taskId, "taskId");
        this.judgeObjNotNull(actEvalObjId, "actEvalObjId");
        this.judgeObjNotNull(jumpTaskIds, "jumpTaskIds");
        Map<Long, RuTaskEvalBo> taskEvalBoMap = this.getLongRuTaskEvalBoMap(taskId, jumpTaskIds);
        try (TXHandle txHandle = TX.required();){
            RuTaskEvalBo ruTaskEvalBo = taskEvalBoMap.get(taskId);
            if (ruTaskEvalBo == null) {
                LOG.error("taskId:{}, ruTaskEvalBo is null", (Object)taskId);
                boolean bl = false;
                return bl;
            }
            Long nodeTypeId = ruTaskEvalBo.getFlowNodedefNodeTypeId();
            Map<Long, DynamicObject[]> taskAreaRecordMap = this.getAreaEvalRecord(taskId, actEvalObjId, nodeTypeId);
            for (Long jumpTaskId : jumpTaskIds) {
                RuTaskEvalBo taskEvalBo;
                if (jumpTaskId == null || (taskEvalBo = taskEvalBoMap.get(jumpTaskId)) == null) continue;
                Long nodeDefNodeTypeId = taskEvalBo.getFlowNodedefNodeTypeId();
                if (NodeTypeEnum.EVALUATION.getValue().equals(nodeTypeId)) {
                    if (NodeTypeEnum.EVALUATION.getValue().equals(nodeDefNodeTypeId)) {
                        this.genNewGenAreaRecordObject(taskAreaRecordMap, taskEvalBo);
                        this.genNewAddSubAreaRecord(taskAreaRecordMap, taskEvalBo);
                        this.genNewAttachAreaRecord(taskAreaRecordMap, taskEvalBo);
                        this.genNewCustomAreaRecord(taskAreaRecordMap, taskEvalBo);
                        this.genNewSumAreaRecord(taskAreaRecordMap, taskEvalBo);
                        continue;
                    }
                    if (!NodeTypeEnum.BATCH_EVALUATION.getValue().equals(nodeDefNodeTypeId)) continue;
                    this.genNewSumAreaRecord(taskAreaRecordMap, taskEvalBo);
                    continue;
                }
                if (!NodeTypeEnum.BATCH_EVALUATION.getValue().equals(nodeTypeId)) continue;
                this.genNewSumAreaRecord(taskAreaRecordMap, taskEvalBo);
            }
        }
        return isSuccess;
    }

    private Map<Long, DynamicObject[]> getAreaEvalRecord(Long taskId, Long actEvalObjId, Long nodeTypeId) {
        HashMap<Long, DynamicObject[]> taskAreaRecordMap = new HashMap<Long, DynamicObject[]>(16);
        if (NodeTypeEnum.EVALUATION.getValue().equals(nodeTypeId)) {
            Map<Long, List<Long>> areaEntryMap = this.queryEvalObjAreaEntry2Map(actEvalObjId);
            if (areaEntryMap != null) {
                for (Map.Entry<Long, List<Long>> next : areaEntryMap.entrySet()) {
                    List<Long> areaInsList;
                    Long areaReg;
                    if (next == null || !AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaReg = next.getKey()) && !AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaReg) && !AssessRuleConstants.ATTACH_AREA_PK.equals(areaReg) || (areaInsList = next.getValue()) == null || areaInsList.isEmpty()) continue;
                    OpmcEntityService entityService = AREA_RECORD_ENTITYSERVICE_MAP.get(areaReg);
                    QFilter filter = new QFilter("flowrutask", "=", (Object)taskId);
                    filter.and(new QFilter("area", "in", areaInsList));
                    DynamicObject[] dynamicObjectArray = entityService.loadDynamicObjectArray(new QFilter[]{filter});
                    taskAreaRecordMap.put(areaReg, dynamicObjectArray);
                }
            }
            OpmcEntityService entityService = AREA_RECORD_ENTITYSERVICE_MAP.get(AssessRuleConstants.SUM_AREA_PK);
            QFilter filter = new QFilter("flowrutask", "=", (Object)taskId);
            DynamicObject[] dynamicObjectArray = entityService.loadDynamicObjectArray(new QFilter[]{filter});
            taskAreaRecordMap.put(AssessRuleConstants.SUM_AREA_PK, dynamicObjectArray);
            DynamicObject actEvalObj = ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.queryOriginalOne("id,activity.id", actEvalObjId);
            long activityId = actEvalObj.getLong("activity.id");
            QFilter activityFilter = new QFilter("id", "=", (Object)activityId);
            DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform", new QFilter[]{activityFilter});
            long assessFormId = activityObj.getLong("assessform.id");
            DynamicObject assessFormDy = this.queryExecuteAssessForm(assessFormId);
            DynamicObjectCollection areaConfEntry = assessFormDy.getDynamicObjectCollection("areaconfentry");
            ArrayList<Long> configIdList = new ArrayList<Long>(10);
            for (DynamicObject areaDy : areaConfEntry) {
                Long areaRegId = areaDy.getLong("areareg.id");
                if (!AssessRuleConstants.CUSTOM_AREA_PK.equals(areaRegId)) continue;
                configIdList.add(areaDy.getLong("areaconf"));
            }
            if (!configIdList.isEmpty()) {
                entityService = AREA_RECORD_ENTITYSERVICE_MAP.get(AssessRuleConstants.CUSTOM_AREA_PK);
                QFilter customFilter = new QFilter("flowrutask", "=", (Object)taskId);
                customFilter.and(new QFilter("areaconf", "in", configIdList));
                DynamicObject[] customDyArr = entityService.loadDynamicObjectArray(new QFilter[]{customFilter});
                taskAreaRecordMap.put(AssessRuleConstants.CUSTOM_AREA_PK, customDyArr);
            }
        } else if (NodeTypeEnum.BATCH_EVALUATION.getValue().equals(nodeTypeId)) {
            OpmcEntityService entityService = AREA_RECORD_ENTITYSERVICE_MAP.get(AssessRuleConstants.SUM_AREA_PK);
            QFilter filter = new QFilter("flowrutask", "=", (Object)taskId);
            DynamicObject[] dynamicObjectArray = entityService.loadDynamicObjectArray(new QFilter[]{filter});
            taskAreaRecordMap.put(AssessRuleConstants.SUM_AREA_PK, dynamicObjectArray);
        }
        return taskAreaRecordMap;
    }

    private Map<Long, RuTaskEvalBo> getLongRuTaskEvalBoMap(Long taskId, List<Long> jumpTaskIds) {
        ArrayList<Long> taskIdList = new ArrayList<Long>(10);
        taskIdList.add(taskId);
        taskIdList.addAll(jumpTaskIds);
        String selectFields = "id,flowruproc.id,flowrunode.id,flowrurole.id,flowrunode.flownodedef.nodetype,flowrunode.nodeweight,flowrurole.roleweight";
        QFilter filter = new QFilter("id", "in", taskIdList);
        DynamicObject[] taskDynamicArr = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalArray(selectFields, new QFilter[]{filter});
        HashMap<Long, RuTaskEvalBo> taskEvalBoMap = new HashMap<Long, RuTaskEvalBo>(16);
        if (taskDynamicArr != null) {
            for (DynamicObject taskDy : taskDynamicArr) {
                if (taskDy == null) continue;
                long taskID = taskDy.getLong("id");
                RuTaskEvalBo ruTaskEvalBo = new RuTaskEvalBo();
                ruTaskEvalBo.setTaskId(taskID);
                ruTaskEvalBo.setFlowruProcId(taskDy.getLong("flowruproc.id"));
                ruTaskEvalBo.setFlowruNodeId(taskDy.getLong("flowrunode.id"));
                ruTaskEvalBo.setFlowruroleId(taskDy.getLong("flowrurole.id"));
                ruTaskEvalBo.setFlowNodedefNodeTypeId(taskDy.getLong("flowrunode.flownodedef.nodetype"));
                ruTaskEvalBo.setNodeWeight(taskDy.getBigDecimal("flowrunode.nodeweight"));
                ruTaskEvalBo.setRoleWeight(taskDy.getBigDecimal("flowrurole.roleweight"));
                taskEvalBoMap.put(taskID, ruTaskEvalBo);
            }
        }
        return taskEvalBoMap;
    }

    public Map<Long, DynamicObject> queryIndEvalRecordByTaskIds(AreaRegEnum areaReg, List<Long> taskId, List<Long> indIdList) {
        OpmcEntityService indRecordEntity = IND_RECORD_ENTITY_MAP.get(areaReg);
        QFilter taskFilter = new QFilter("flowrutask", "in", taskId);
        taskFilter.and(new QFilter("indicator", "in", indIdList));
        DynamicObject[] indRecordDys = indRecordEntity.loadDynamicObjectArray(new QFilter[]{taskFilter});
        return Arrays.stream(indRecordDys).collect(Collectors.toMap(indRecord -> indRecord.getLong("indicator"), Function.identity(), (v1, v2) -> v2));
    }

    public Map<Long, List<Long>> queryEvalRecord(AreaRegEnum areaReg, Long areaId, Map<Long, List<Long>> taskIndicatorMap) {
        HashMap<Long, List<Long>> taskIndRecordMap = new HashMap<Long, List<Long>>(16);
        if (taskIndicatorMap != null) {
            OpmcEntityService indRecordEntity = IND_RECORD_ENTITY_MAP.get(areaReg);
            for (Map.Entry<Long, List<Long>> entry : taskIndicatorMap.entrySet()) {
                if (entry == null) continue;
                Long taskId = entry.getKey();
                List<Long> indicators = entry.getValue();
                if (taskId == null || indicators == null || indicators.isEmpty()) continue;
                QFilter taskFilter = new QFilter("flowrutask", "in", (Object)taskId);
                taskFilter.and(new QFilter("indicator", "in", indicators));
                taskFilter.and(new QFilter("area", "=", (Object)areaId));
                DynamicObject[] valRecords = indRecordEntity.queryOriginalArray("id,flowrutask.id,indicator", new QFilter[]{taskFilter});
                if (valRecords == null) continue;
                for (DynamicObject record : valRecords) {
                    if (record == null) continue;
                    long taskIdTmp = record.getLong("flowrutask.id");
                    long indicatorIdTmp = record.getLong("indicator");
                    List<Long> indList = taskIndRecordMap.get(taskIdTmp) == null ? new ArrayList(10) : (List)taskIndRecordMap.get(taskIdTmp);
                    indList.add(indicatorIdTmp);
                    taskIndRecordMap.put(taskIdTmp, indList);
                }
            }
        }
        return taskIndRecordMap;
    }

    public Map<Long, DynamicObject> queryIndEvalRecordByTaskId(AreaRegEnum areaReg, Long taskId, List<Long> indIdList) {
        OpmcEntityService indRecordEntity = IND_RECORD_ENTITY_MAP.get(areaReg);
        QFilter taskFilter = new QFilter("flowrutask", "=", (Object)taskId);
        taskFilter.and(new QFilter("indicator", "in", indIdList));
        DynamicObject[] indRecordDys = indRecordEntity.query("soe,realfinishdate,qualityres,finishdesc,customfiled1,customfiled2,customfiled3,customfiled4,customfiled5,evaldesc,indicator", new QFilter[]{taskFilter});
        return Arrays.stream(indRecordDys).collect(Collectors.toMap(indRecord -> indRecord.getLong("indicator"), Function.identity(), (v1, v2) -> v2));
    }

    public Map<String, Object> submitEvalTask(String taskId, List<Long> mergeTaskIds) {
        boolean submitSuccess = true;
        ArrayList<Long> successTaskIds = new ArrayList<Long>(10);
        ArrayList<Long> taskIds = new ArrayList<Long>(10);
        if (!HRStringUtils.isBlank((CharSequence)taskId)) {
            taskIds.add(Long.parseLong(taskId));
        }
        if (mergeTaskIds != null) {
            taskIds.addAll(mergeTaskIds);
        }
        this.checkEvalTaskAndProcStatus(taskIds);
        Map resultMap = FLOW_RU_PROC_DOMAIN_SERVICE.submitTask(mergeTaskIds);
        if (resultMap != null) {
            for (Map.Entry next : resultMap.entrySet()) {
                Boolean success;
                if (next == null) continue;
                Long taskIdTemp = (Long)next.getKey();
                Boolean bl = success = next.getValue() == null ? Boolean.FALSE : (Boolean)next.getValue();
                if (success != null && success.booleanValue()) {
                    successTaskIds.add(taskIdTemp);
                }
                if (success == null || success.booleanValue()) continue;
                submitSuccess = false;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("submitSuccess", submitSuccess);
        map.put("successTaskIds", successTaskIds);
        return map;
    }

    public void updateGenIndRecordCanEditByTask(List<Long> taskIds, boolean isCanEdit) {
        this.updateIndRecordCanEditByTask(AreaRegEnum.NORM_INDCTR_AREA, taskIds, isCanEdit);
    }

    public void updateAddSubIndRecordCanEditByTask(List<Long> taskIds, boolean isCanEdit) {
        this.updateIndRecordCanEditByTask(AreaRegEnum.PLUS_MINUS_AREA, taskIds, isCanEdit);
    }

    public void updateAttachIndRecordCanEditByTask(List<Long> taskIds, boolean isCanEdit) {
        this.updateIndRecordCanEditByTask(AreaRegEnum.ATTACH_AREA, taskIds, isCanEdit);
    }

    public void updateCustomRecordCanEditByTask(List<Long> taskIds, boolean isCanEdit) {
        if (taskIds == null || taskIds.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("flowrutask", "in", taskIds);
        DynamicObject[] dynamicObjects = CUSTOM_AREA_RECORD_ENTITY.query("id,iscanedit", new QFilter[]{filter});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (dynamicObject == null) continue;
                dynamicObject.set("iscanedit", (Object)isCanEdit);
            }
            CUSTOM_AREA_RECORD_ENTITY.update(dynamicObjects);
        }
    }

    public void updateIndRecordCanEditByTask(AreaRegEnum areaReg, List<Long> taskIds, boolean isCanEdit) {
        if (taskIds == null || taskIds.isEmpty()) {
            return;
        }
        OpmcEntityService opmcEntityService = IND_RECORD_ENTITY_MAP.get(areaReg);
        if (opmcEntityService == null) {
            return;
        }
        QFilter filter = new QFilter("flowrutask", "in", taskIds);
        DynamicObject[] dynamicObjects = opmcEntityService.query("id,iscanedit", new QFilter[]{filter});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (dynamicObject == null) continue;
                dynamicObject.set("iscanedit", (Object)isCanEdit);
            }
            opmcEntityService.update(dynamicObjects);
        }
    }

    public void updateGenIndRecordCanEditByTask(List<Map<String, Object>> paramList) {
        if (paramList == null || paramList.isEmpty()) {
            return;
        }
        ArrayList<Long> wholeTaskIdList = new ArrayList<Long>(10);
        HashMap<Long, List<Long>> updateTaskIndicatorMap = new HashMap<Long, List<Long>>(16);
        for (Map<String, Object> map : paramList) {
            List oldIndList;
            List indicatorIds;
            Long taskId;
            if (map == null || (taskId = (Long)map.get("taskId")) == null) continue;
            String type = (String)map.get("type");
            if (EvalTypeEnum.WHOLE.getCode().equals(type)) {
                indicatorIds = (List)map.get("indicatorIds");
                if (indicatorIds != null && !indicatorIds.isEmpty()) {
                    oldIndList = updateTaskIndicatorMap.get(taskId) == null ? new ArrayList(10) : (List)updateTaskIndicatorMap.get(taskId);
                    oldIndList.addAll(indicatorIds);
                    updateTaskIndicatorMap.put(taskId, oldIndList);
                    continue;
                }
                wholeTaskIdList.add(taskId);
                continue;
            }
            if (!EvalTypeEnum.CROSS.getCode().equals(type) || (indicatorIds = (List)map.get("indicatorIds")) == null || indicatorIds.isEmpty()) continue;
            oldIndList = updateTaskIndicatorMap.get(taskId) == null ? new ArrayList(10) : (List)updateTaskIndicatorMap.get(taskId);
            oldIndList.addAll(indicatorIds);
            updateTaskIndicatorMap.put(taskId, oldIndList);
        }
        if (wholeTaskIdList != null && !wholeTaskIdList.isEmpty()) {
            this.updateGenIndRecordCanEditByTask(wholeTaskIdList, true);
            this.updateAddSubIndRecordCanEditByTask(wholeTaskIdList, true);
            this.updateAttachIndRecordCanEditByTask(wholeTaskIdList, true);
            this.updateCustomRecordCanEditByTask(wholeTaskIdList, true);
        }
        this.updateGenIndRecordCanEditOfCross(updateTaskIndicatorMap);
        this.updateAddSubIndRecordCanEditOfCross(updateTaskIndicatorMap);
    }

    private void updateAddSubIndRecordCanEditOfCross(Map<Long, List<Long>> crossIndMap) {
        for (Map.Entry<Long, List<Long>> next : crossIndMap.entrySet()) {
            if (next == null) continue;
            Long taskId = next.getKey();
            List<Long> indicatorIds = next.getValue();
            if (taskId == null || indicatorIds == null || indicatorIds.isEmpty()) continue;
            QFilter filter = new QFilter("flowrutask", "=", (Object)taskId);
            filter.and(new QFilter("indicator", "in", indicatorIds));
            DynamicObject[] dynamicObjects = ADD_SUB_EVAL_RECORD_ENTITY.query("id,iscanedit", new QFilter[]{filter});
            if (dynamicObjects == null || dynamicObjects.length <= 0) continue;
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (dynamicObject == null) continue;
                dynamicObject.set("iscanedit", (Object)true);
            }
            ADD_SUB_EVAL_RECORD_ENTITY.update(dynamicObjects);
        }
    }

    private void updateGenIndRecordCanEditOfCross(Map<Long, List<Long>> crossIndMap) {
        for (Map.Entry<Long, List<Long>> next : crossIndMap.entrySet()) {
            if (next == null) continue;
            Long taskId = next.getKey();
            List<Long> indicatorIds = next.getValue();
            if (taskId == null || indicatorIds == null || indicatorIds.isEmpty()) continue;
            QFilter filter = new QFilter("flowrutask", "=", (Object)taskId);
            filter.and(new QFilter("indicator", "in", indicatorIds));
            DynamicObject[] dynamicObjects = GEN_EVAL_RECORD_ENTITY.query("id,iscanedit", new QFilter[]{filter});
            if (dynamicObjects == null || dynamicObjects.length <= 0) continue;
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (dynamicObject == null) continue;
                dynamicObject.set("iscanedit", (Object)true);
            }
            GEN_EVAL_RECORD_ENTITY.update(dynamicObjects);
        }
    }

    public Map<Long, List<Long>> queryTaskIndicators(List<Long> taskIdList, Long areaInsId) {
        HashMap<Long, List<Long>> taskIndMap = new HashMap<Long, List<Long>>(16);
        DynamicObject[] taskIndicators = FLOW_RU_SEC_PROC_DOMAIN_SERVICE.queryTaskIndicators(taskIdList, areaInsId);
        if (taskIndicators != null) {
            for (DynamicObject taskIndicator : taskIndicators) {
                if (taskIndicator == null) continue;
                long taskID = taskIndicator.getLong("id");
                List<Long> indList = taskIndMap.get(taskID) == null ? new ArrayList(10) : (List)taskIndMap.get(taskID);
                long indicatorId = taskIndicator.getLong("entryentity.indicatorid");
                indList.add(indicatorId);
                taskIndMap.put(taskID, indList);
            }
        }
        return taskIndMap;
    }

    public Map<Long, List<Long>> queryTaskIndicators(List<Long> taskIdList) {
        HashMap<Long, List<Long>> taskIndMap = new HashMap<Long, List<Long>>(16);
        DynamicObject[] taskIndicators = FLOW_RU_SEC_PROC_DOMAIN_SERVICE.queryTaskIndicators(taskIdList);
        if (taskIndicators != null) {
            for (DynamicObject taskIndicator : taskIndicators) {
                if (taskIndicator == null) continue;
                long taskID = taskIndicator.getLong("id");
                List<Long> indList = taskIndMap.get(taskID) == null ? new ArrayList(10) : (List)taskIndMap.get(taskID);
                long indicatorId = taskIndicator.getLong("entryentity.indicatorid");
                indList.add(indicatorId);
                taskIndMap.put(taskID, indList);
            }
        }
        return taskIndMap;
    }

    public List<Map<String, Object>> getBatchTaskList(Long taskId, QFilter cusFilter) {
        DynamicObject[] taskDyns;
        DynamicObject taskDyo;
        ArrayList<Map<String, Object>> taskListMap = new ArrayList<Map<String, Object>>(10);
        DynamicObject[] batchTaskDyns = BATCH_TASKMAP_ENTITY_SERVICE.queryTaskByBatchTaskIds(Collections.singletonList(taskId));
        if (batchTaskDyns.length > 0) {
            taskId = batchTaskDyns[0].getLong("rutask.id");
        }
        if (null == (taskDyo = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(taskId))) {
            return taskListMap;
        }
        QFilter taskFilter = new QFilter("handler", "=", (Object)taskDyo.getDynamicObject("handler").getLong("id"));
        taskFilter.and("activity", "=", (Object)taskDyo.getLong("activity"));
        taskFilter.and("flowrurole.flowdefrole.id", "=", (Object)taskDyo.getLong("flowrurole.flowdefrole.id"));
        if (null != cusFilter) {
            taskFilter.and(cusFilter);
        }
        for (DynamicObject task : taskDyns = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByCusFilter(taskFilter)) {
            HashMap<String, Object> taskMap = new HashMap<String, Object>(16);
            taskMap.put("taskId", task.getLong("id"));
            taskMap.put("actEvaObjId", task.getLong("flowruproc.actevalobj"));
            taskMap.put("taskStatus", task.getString("taskstatus"));
            taskMap.put("indicatorColl", task.getDynamicObjectCollection("entryentity"));
            taskMap.put("iscrossevaluate", task.getBoolean("iscrossevaluate"));
            taskMap.put("activity", task.getLong("activity"));
            taskMap.put("flowrunode", task.getLong("flowrunode.id"));
            taskMap.put("flowrurole", task.getLong("flowrurole.id"));
            taskMap.put("handler", task.getLong("handler.id"));
            taskListMap.add(taskMap);
        }
        return taskListMap;
    }

    public DynamicObject queryActEvalObjByFlowInsId(Long evalflowinsId) {
        QFilter filter = new QFilter("evalflowins", "=", (Object)evalflowinsId);
        filter.or(new QFilter("formulateflowins", "=", (Object)evalflowinsId));
        return ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.queryOne("id, person.id", new QFilter[]{filter});
    }

    public Map<Long, Long> getUserIdsByPersonIds(List<Long> personIds) {
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(16);
        HashMap<String, List<Long>> personIdMap = new HashMap<String, List<Long>>(16);
        personIdMap.put("person", personIds);
        Map userIdByPersonInfo = new HashMap(16);
        try {
            userIdByPersonInfo = PERSON_SERVICE.getUserIdByPersonInfo(personIdMap);
        }
        catch (Exception e) {
            LOG.error("\u3010OPMC\u3011-getUserIdsByPersonIds error,personIds:{}", personIds);
            LOG.error((Throwable)e);
        }
        if (userIdByPersonInfo.isEmpty()) {
            return retMap;
        }
        Boolean success = (Boolean)userIdByPersonInfo.get("success");
        if (success.booleanValue()) {
            Map userInfo = (Map)userIdByPersonInfo.get("data");
            ArrayList<Long> userIds = new ArrayList<Long>(personIds.size());
            for (Long personId : personIds) {
                Map user = (Map)userInfo.get(personId);
                if (user == null) continue;
                Long userId = (Long)user.get("user");
                userIds.add(userId);
            }
            Map<Long, Boolean> userIsEnableMap = this.batchQueryUserIsEnable(userIds);
            for (Long personId : personIds) {
                Long userId;
                Map user = (Map)userInfo.get(personId);
                if (user == null || !userIsEnableMap.getOrDefault(userId = (Long)user.get("user"), false).booleanValue()) continue;
                retMap.put(personId, userId);
            }
        }
        return retMap;
    }

    private Map<Long, Boolean> batchQueryUserIsEnable(List<Long> userIds) {
        List userInfo = UserServiceHelper.get(userIds, (String[])new String[]{"id", "isforbidden", "enable"}, null);
        HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>(16);
        if (CollectionUtils.isEmpty((Collection)userInfo)) {
            return ret;
        }
        for (Map user : userInfo) {
            ret.put((Long)user.get("id"), (Boolean)user.get("isforbidden") == false && "1".equals(user.get("enable")));
        }
        return ret;
    }

    public void delGenIndEvaRecordByIds(List<Long> idList) {
        GEN_EVAL_RECORD_ENTITY.delete(idList.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEvalRecordForAdjustEvalPer(Map<Long, List<Long>> taskIndicatorMap) {
        if (taskIndicatorMap == null || taskIndicatorMap.isEmpty()) {
            return;
        }
        Set<Long> taskIdSet = taskIndicatorMap.keySet();
        QFilter taskFilter = new QFilter("flowrutask", "in", taskIdSet);
        DynamicObject[] updateEvalRecord = GEN_AREA_RECORD_ENTITY.query("id,activity,flowrutask ,area, ssr, ssrec, modifytime, actevalobj, modifier, entryentity.soe, entryentity.adjustval, entryentity.indicator,entryentity.indflowrutask", new QFilter[]{taskFilter});
        if (updateEvalRecord != null && updateEvalRecord.length > 0) {
            Map<Long, DynamicObject> instanceIdFormMap = this.getInstanceIdFormMap(updateEvalRecord);
            List<DynamicObject> genAreaRecordList = this.calculateGenSsrForAdjust(updateEvalRecord, instanceIdFormMap, taskIndicatorMap);
            try (TXHandle txHandle = TX.required();){
                if (genAreaRecordList != null && !genAreaRecordList.isEmpty()) {
                    DynamicObject[] updates = new DynamicObject[genAreaRecordList.size()];
                    updates = genAreaRecordList.toArray(updates);
                    GEN_AREA_RECORD_ENTITY.save(updates);
                }
                Set<Map.Entry<Long, List<Long>>> entrySet = taskIndicatorMap.entrySet();
                for (Map.Entry<Long, List<Long>> entry : entrySet) {
                    if (entry == null) continue;
                    Long taskID = entry.getKey();
                    List<Long> inds = entry.getValue();
                    if (taskID == null || inds == null || inds.isEmpty()) continue;
                    QFilter filter = new QFilter("flowrutask", "=", (Object)taskID);
                    filter.and(new QFilter("indicator", "in", inds));
                    LOG.info("adjust person indicator delete filter\uff1a{}", (Object)filter.toString());
                    GEN_EVAL_RECORD_ENTITY.deleteByFilter(new QFilter[]{filter});
                }
            }
        }
    }

    private Map<Long, DynamicObject> getInstanceIdFormMap(DynamicObject[] updateEvalRecord) {
        HashMap<Long, Long> areaActivityMap = new HashMap<Long, Long>(16);
        for (DynamicObject genAreaRecord : updateEvalRecord) {
            if (genAreaRecord == null) continue;
            long areaID = genAreaRecord.getLong("area.id");
            long activityID = genAreaRecord.getLong("activity");
            areaActivityMap.put(areaID, activityID);
        }
        Set<Long> activityIdSet = this.getActivityIdSet(updateEvalRecord);
        DynamicObject[] activitys = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOriginalArray("id,assessform.id", new QFilter("id", "in", activityIdSet).toArray());
        Map<Long, Long> actvityFormMap = ActEvalObjDetailDomainService.getActvityFormMap(activitys);
        DynamicObject[] accessForms = this.getAccessForm(activitys);
        Map<Long, DynamicObject> formMap = this.getFormMap(accessForms);
        HashMap<Long, DynamicObject> instanceIdFormMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry entry : areaActivityMap.entrySet()) {
            if (entry == null) continue;
            Long activityID = (Long)entry.getValue();
            if (actvityFormMap == null) continue;
            Long formId = actvityFormMap.get(activityID);
            if (formMap == null) continue;
            instanceIdFormMap.put((Long)entry.getKey(), formMap.get(formId));
        }
        return instanceIdFormMap;
    }

    private Map<Long, DynamicObject> getFormMap(DynamicObject[] accessForms) {
        HashMap<Long, DynamicObject> accessFormMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject accessForm : accessForms) {
            if (accessForm == null) continue;
            accessFormMap.put(accessForm.getLong("id"), accessForm);
        }
        return accessFormMap;
    }

    private static Map<Long, Long> getActvityFormMap(DynamicObject[] activitys) {
        HashMap<Long, Long> actvityFormMap = new HashMap<Long, Long>(16);
        if (activitys != null) {
            for (DynamicObject activity : activitys) {
                if (activity == null) continue;
                long actvityId = activity.getLong("id");
                long assessFormId = activity.getLong("assessform.id");
                actvityFormMap.put(actvityId, assessFormId);
            }
        }
        return actvityFormMap;
    }

    private DynamicObject[] getAccessForm(DynamicObject[] activitys) {
        HashSet<Long> assessFormIds = new HashSet<Long>(16);
        if (activitys != null) {
            for (DynamicObject activity : activitys) {
                if (activity == null) continue;
                assessFormIds.add(activity.getLong("assessform.id"));
            }
        }
        DynamicObject[] assessForms = ASSESS_FORM_ENTITY.query("scorecalcway, scoresystem, evalway, numaccuracy, scaletype, allowexceedupper, limitmaxscore, allowexceedlower, limitminscore, consistentwitharea", new QFilter("id", "in", assessFormIds).toArray());
        return assessForms;
    }

    private Set<Long> getActivityIdSet(DynamicObject[] updateEvalRecord) {
        HashSet<Long> actitviIds = new HashSet<Long>(16);
        for (DynamicObject evalRecord : updateEvalRecord) {
            if (evalRecord == null) continue;
            actitviIds.add(evalRecord.getLong("activity"));
        }
        return actitviIds;
    }

    public Map<Long, Map<String, Object>> queryTaskMap(List<Long> taskIdList) {
        DynamicObject[] taskObjs;
        HashMap<Long, Map<String, Object>> taskMap = new HashMap<Long, Map<String, Object>>(16);
        for (DynamicObject taskItem : taskObjs = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPks(taskIdList)) {
            HashMap<String, Long> taskItemMap = new HashMap<String, Long>(16);
            Long taskId = taskItem.getLong("id");
            taskItemMap.put("flowrutask", taskId);
            Long flowrunodeId = taskItem.getLong("flowrunode.id");
            taskItemMap.put("flowrunode", flowrunodeId);
            Long flowruprocId = taskItem.getLong("flowruproc.id");
            taskItemMap.put("flowruproc", flowruprocId);
            Long flowruroleId = taskItem.getLong("flowrurole.id");
            taskItemMap.put("flowrurole", flowruroleId);
            taskMap.put(taskId, taskItemMap);
        }
        return taskMap;
    }

    public void saveMergeGenAreaRecord(DynamicObject genAreaRecordObj, String scoreCalcWay) {
        if (genAreaRecordObj != null) {
            DynamicObjectCollection genAreaObjColls = new DynamicObjectCollection();
            BigDecimal ssr = genAreaRecordObj.getBigDecimal("ssr");
            BigDecimal ssrec = genAreaRecordObj.getBigDecimal("ssrec");
            Long areaInsId = genAreaRecordObj.getLong("area.id");
            CloneUtils cloneUtils = new CloneUtils(false, true);
            DynamicObjectCollection evalRecords = genAreaRecordObj.getDynamicObjectCollection("entryentity");
            Set taskIds = evalRecords.stream().map(obj -> obj.getLong("indflowrutask")).collect(Collectors.toSet());
            List<Long> taskIdList = taskIds.stream().collect(Collectors.toList());
            Map<Long, Map<String, Object>> taskFlowMap = this.queryTaskMap(taskIdList);
            QFilter genAreaRecordFilter = new QFilter("flowrutask", "in", taskIds);
            genAreaRecordFilter.and(new QFilter("area", "=", (Object)areaInsId));
            GEN_AREA_RECORD_ENTITY.deleteByFilter(new QFilter[]{genAreaRecordFilter});
            QFilter genEvalRecordFilter = new QFilter("flowrutask", "in", taskIds);
            genEvalRecordFilter.and(new QFilter("area", "=", (Object)areaInsId));
            GEN_EVAL_RECORD_ENTITY.deleteByFilter(new QFilter[]{genEvalRecordFilter});
            Map<Long, List<DynamicObject>> genEvalGroupRecords = evalRecords.stream().collect(Collectors.groupingBy(obj -> obj.getLong("indflowrutask")));
            List indicatorIdList = evalRecords.stream().map(obj -> obj.getLong("indicator.id")).collect(Collectors.toList());
            QFilter indicatorFilter = new QFilter("id", "in", indicatorIdList);
            DynamicObject[] indicatorObjs = GEN_AREA_INDICATOR_ENTITY.queryOriginalArray("id, weight", new QFilter[]{indicatorFilter});
            Map indicatorMap = Arrays.stream(indicatorObjs).collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
            Long userId = RequestContext.get().getCurrUserId();
            for (Map.Entry<Long, List<DynamicObject>> genEvalGroupRecord : genEvalGroupRecords.entrySet()) {
                Long taskId = genEvalGroupRecord.getKey();
                List<DynamicObject> evalRecordList = genEvalGroupRecord.getValue();
                BigDecimal item_ssr = BigDecimal.ZERO;
                BigDecimal item_weight = BigDecimal.ZERO;
                DynamicObjectCollection entrys = new DynamicObjectCollection();
                Map<String, Object> taskFlowObj = taskFlowMap.get(taskId);
                for (DynamicObject evalObj : evalRecordList) {
                    if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                        Long indicatorId = evalObj.getLong("indicator.id");
                        DynamicObject indObj = (DynamicObject)indicatorMap.get(indicatorId);
                        BigDecimal weight = indObj.getBigDecimal("weight");
                        item_weight = item_weight.add(weight == null ? BigDecimal.ZERO : weight);
                    } else {
                        item_ssr = item_ssr.add(evalObj.getBigDecimal("soe") == null ? BigDecimal.ZERO : evalObj.getBigDecimal("soe"));
                    }
                    DynamicObject genEvalRecord = GEN_AREA_RECORD_ENTITY.generateEmptyEntryDynamicObject("entryentity");
                    genEvalRecord.set("indactevalobj", (Object)evalObj.getLong("indactevalobj"));
                    genEvalRecord.set("indassessyear", (Object)evalObj.getInt("indassessyear"));
                    genEvalRecord.set("indassessperiod", (Object)evalObj.getString("indassessperiod"));
                    genEvalRecord.set("indactivity", (Object)evalObj.getLong("indactivity"));
                    genEvalRecord.set("indperforg", (Object)evalObj.getLong("indperforg"));
                    genEvalRecord.set("indflowrutask", (Object)evalObj.getLong("indflowrutask"));
                    genEvalRecord.set("indflowrunode", (Object)evalObj.getLong("indflowrunode"));
                    genEvalRecord.set("indflowrurole", (Object)evalObj.getLong("indflowrurole"));
                    genEvalRecord.set("indflowruproc", (Object)evalObj.getLong("indflowruproc"));
                    genEvalRecord.set("indarea", (Object)evalObj.getLong("indarea"));
                    genEvalRecord.set("indicator", (Object)evalObj.getLong("indicator.id"));
                    genEvalRecord.set("adjustval", (Object)evalObj.getBigDecimal("adjustval"));
                    genEvalRecord.set(AssessScoreAbbrEnum.SOE.getCode(), (Object)evalObj.getBigDecimal(AssessScoreAbbrEnum.SOE.getCode()));
                    genEvalRecord.set("realfinishdate", (Object)evalObj.getDate("realfinishdate"));
                    genEvalRecord.set("qualityres", (Object)evalObj.getString("qualityres"));
                    genEvalRecord.set("finishdesc", (Object)evalObj.getLocaleString("finishdesc"));
                    genEvalRecord.set("evaldesc", (Object)evalObj.getLocaleString("evaldesc"));
                    genEvalRecord.set("customfiled1", (Object)evalObj.getLocaleString("customfiled1"));
                    genEvalRecord.set("customfiled2", (Object)evalObj.getLocaleString("customfiled2"));
                    genEvalRecord.set("customfiled3", (Object)evalObj.getLocaleString("customfiled3"));
                    genEvalRecord.set("customfiled4", (Object)evalObj.getLocaleString("customfiled4"));
                    genEvalRecord.set("customfiled5", (Object)evalObj.getLocaleString("customfiled5"));
                    genEvalRecord.set("iscanedit", (Object)evalObj.getBoolean("iscanedit"));
                    genEvalRecord.set("indcreator", (Object)userId);
                    genEvalRecord.set("indcreatetime", (Object)new Date());
                    genEvalRecord.set("indmodifier", (Object)userId);
                    genEvalRecord.set("indmodifytime", (Object)new Date());
                    entrys.add((Object)genEvalRecord);
                }
                DynamicObject genAreaRecord = GEN_AREA_RECORD_ENTITY.generateEmptyDynamicObject();
                genAreaRecord.set("actevalobj", (Object)genAreaRecordObj.getLong("actevalobj"));
                genAreaRecord.set("assessyear", (Object)genAreaRecordObj.getInt("assessyear"));
                genAreaRecord.set("assessperiod", (Object)genAreaRecordObj.getString("assessperiod"));
                genAreaRecord.set("activity", (Object)genAreaRecordObj.getLong("activity"));
                genAreaRecord.set("perforg", (Object)genAreaRecordObj.getLong("perforg"));
                genAreaRecord.set("flowrutask", (Object)taskId);
                genAreaRecord.set("flowrunode", taskFlowObj.get("flowrunode"));
                genAreaRecord.set("flowrurole", taskFlowObj.get("flowrurole"));
                genAreaRecord.set("flowruproc", taskFlowObj.get("flowruproc"));
                genAreaRecord.set("area", (Object)areaInsId);
                genAreaRecord.set("ssr", (Object)(ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay) ? ssr.multiply(item_weight).divide(new BigDecimal("100"), 10, 4) : item_ssr));
                genAreaRecord.set("ssrec", (Object)item_ssr);
                genAreaRecord.set("creator", (Object)userId);
                genAreaRecord.set("createtime", (Object)new Date());
                genAreaRecord.set("modifier", (Object)userId);
                genAreaRecord.set("modifytime", (Object)new Date());
                genAreaRecord.set("entryentity", (Object)entrys);
                genAreaObjColls.add((Object)genAreaRecord);
            }
            GEN_AREA_RECORD_ENTITY.save(genAreaObjColls);
        }
    }

    public Map<Long, Object> queryBatchProcessPermSettingScope(List<Long> taskIdList) {
        DynamicObject[] taskObjs;
        Map<Long, Object> permCfgMap = new HashMap<Long, Object>(16);
        if (taskIdList != null && !taskIdList.isEmpty() && (taskObjs = this.queryTaskById(taskIdList)) != null && taskObjs.length > 0) {
            Long activityId = taskObjs[0].getLong("activity");
            DynamicObject activityObj = ActEvalObjDetailDomainService.queryActivityById(activityId);
            Long procPermId = activityObj.getLong("dynamicpermission.id");
            Set nodeDefIdSet = Arrays.stream(taskObjs).map(obj -> obj.getLong("flowrunode.flownodedef.id")).collect(Collectors.toSet());
            ArrayList<Long> nodeDefIdList = new ArrayList<Long>(nodeDefIdSet);
            permCfgMap = PROCESS_PERM_SETTING_ENTITY_SERVICE.queryBatchProcessPermSettingScope(procPermId, nodeDefIdList);
            for (int i = 0; i < taskObjs.length; ++i) {
                DynamicObject flowruTaskObj = taskObjs[i];
                Long flowNodeDefId = flowruTaskObj.getLong("flowrunode.flownodedef.id");
                Map permItemMap = (Map)permCfgMap.get(flowNodeDefId);
                if (permItemMap == null) continue;
                permItemMap.put("flowrunodeId", flowruTaskObj.getLong("flowrunode.id"));
                permItemMap.put("flowrunodeIndex", flowruTaskObj.getInt("flowrunode.index"));
                permItemMap.put("flowruroleId", flowruTaskObj.getLong("flowrurole.id"));
                permItemMap.put("turnoversort", flowruTaskObj.getInt("flowrurole.turnoversort"));
            }
        }
        return permCfgMap;
    }

    public Map<Long, Object> queryNodeAnonymity(Long procPermId, List<Long> flowDefNodeList) {
        return PROCESS_PERM_SETTING_ENTITY_SERVICE.queryBatchProcessPermSettingScope(procPermId, flowDefNodeList);
    }

    public DynamicObject querySumAreaEvalRecordOfPreRoleLastTask(Long taskId) {
        DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(taskId);
        if (taskObj == null) {
            return null;
        }
        long flowRuRoleId = taskObj.getLong("flowrurole.id");
        DynamicObject[] roles = this.queryLessThanRoleSortRoles(flowRuRoleId);
        if (roles == null || roles.length == 0) {
            Map<Long, Long> roleMap = this.queryPreNodeLastRoleMap(taskId);
            return this.queryLastTaskSumAreaEvalRecord(roleMap);
        }
        HashMap<Long, Long> sortRoleMap = new HashMap<Long, Long>(16);
        DynamicObject maxSortRole = null;
        for (DynamicObject role : roles) {
            if (role == null) continue;
            if (maxSortRole == null) {
                maxSortRole = role;
            }
            int turnOverSort = role.getInt("turnoversort");
            int maxTurnOverSort = maxSortRole.getInt("turnoversort");
            if (maxTurnOverSort != turnOverSort) continue;
            sortRoleMap.put(role.getLong("flowdefrole.id"), role.getLong("id"));
        }
        return this.queryLastTaskSumAreaEvalRecord(sortRoleMap);
    }

    private DynamicObject queryLastTaskSumAreaEvalRecord(Map<Long, Long> sortRoleMap) {
        DynamicObject dynamicObject;
        Long lastTaskIdOfFinish;
        Set<Long> defRoleIdSet = sortRoleMap.keySet();
        ArrayList<Long> scoreNextRoleIdList = new ArrayList<Long>(10);
        Map roleConfigBoMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeRoleConfigByTask(defRoleIdSet);
        HashMap<Long, Boolean> isCarryLevelMap = new HashMap<Long, Boolean>(16);
        HashMap<Long, Boolean> isCarryEvaluMap = new HashMap<Long, Boolean>(16);
        if (roleConfigBoMap != null) {
            for (Map.Entry next : roleConfigBoMap.entrySet()) {
                Boolean isevaluatenext;
                NodeRoleConfigBo roleConfigBo;
                if (next == null || (roleConfigBo = (NodeRoleConfigBo)next.getValue()) == null) continue;
                Long runRoleId = sortRoleMap.get(next.getKey());
                Boolean isgradenext = roleConfigBo.getIsgradenext();
                if (isgradenext != null && isgradenext.booleanValue()) {
                    isCarryLevelMap.put(runRoleId, true);
                    scoreNextRoleIdList.add(runRoleId);
                }
                if ((isevaluatenext = roleConfigBo.getIsevaluatenext()) == null || !isevaluatenext.booleanValue()) continue;
                isCarryEvaluMap.put(runRoleId, true);
                if (scoreNextRoleIdList.contains(runRoleId)) continue;
                scoreNextRoleIdList.add(runRoleId);
            }
        }
        if ((lastTaskIdOfFinish = this.queryLastTaskIdByRoleIds(scoreNextRoleIdList)) != null && (dynamicObject = ACT_EVAL_OBJ_OVERALL_APPLICATION_SERVICE.querySumAreaEvalRecord(lastTaskIdOfFinish)) != null) {
            DynamicObject taskObj = FLOW_RUN_SUP_DOMAIN_SERVICE.queryTaskByPk(lastTaskIdOfFinish);
            long flowRuRoleId = taskObj.getLong("flowrurole.id");
            if (isCarryEvaluMap.get(flowRuRoleId) == null || !((Boolean)isCarryEvaluMap.get(flowRuRoleId)).booleanValue()) {
                dynamicObject.set("eval", (Object)"$$NOTNEEDCARRY$$");
            } else if (isCarryLevelMap.get(flowRuRoleId) == null || !((Boolean)isCarryLevelMap.get(flowRuRoleId)).booleanValue()) {
                dynamicObject.set("ole", (Object)"$$NOTNEEDCARRY$$");
            }
            return dynamicObject;
        }
        return null;
    }

    public boolean resetRollBackedMark(List<Long> taskIdList) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.resetRollBackedMark(taskIdList);
    }

    public void saveMergeAddSubAreaRecord(DynamicObject addSubAreaRecordObj) {
        if (addSubAreaRecordObj != null) {
            DynamicObjectCollection addSubAreaObjColls = new DynamicObjectCollection();
            CloneUtils cloneUtils = new CloneUtils(false, true);
            Long areaInsId = addSubAreaRecordObj.getLong("area.id");
            DynamicObjectCollection evalRecords = addSubAreaRecordObj.getDynamicObjectCollection("entryentity");
            Set taskIds = evalRecords.stream().map(obj -> obj.getLong("indflowrutask")).collect(Collectors.toSet());
            List<Long> taskIdList = taskIds.stream().collect(Collectors.toList());
            Map<Long, Map<String, Object>> taskFlowMap = this.queryTaskMap(taskIdList);
            Long userId = RequestContext.get().getCurrUserId();
            Date now = new Date();
            TXHandle txHandle = TX.required();
            Object object = null;
            try {
                try {
                    QFilter qFilter = new QFilter("flowrutask", "in", taskIds);
                    qFilter.and(new QFilter("area", "=", (Object)areaInsId));
                    OBJ_ADD_SUB_AREA_RECORD_ENTITY_SERVICE.deleteByFilter(new QFilter[]{qFilter});
                    QFilter genEvalRecordFilter = new QFilter("flowrutask", "in", taskIds);
                    genEvalRecordFilter.and(new QFilter("area", "=", (Object)areaInsId));
                    ADD_SUB_EVAL_RECORD_ENTITY.deleteByFilter(new QFilter[]{genEvalRecordFilter});
                }
                catch (Exception exception) {
                    txHandle.markRollback();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (txHandle != null) {
                    if (object != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
            }
            Map<Long, List<DynamicObject>> addSubEvalGroupRecords = evalRecords.stream().collect(Collectors.groupingBy(obj -> obj.getLong("indflowrutask")));
            for (Map.Entry entry : addSubEvalGroupRecords.entrySet()) {
                Long taskId = (Long)entry.getKey();
                List evalRecordList = (List)entry.getValue();
                Map<String, Object> taskFlowObj = taskFlowMap.get(taskId);
                BigDecimal item_ssr = BigDecimal.ZERO;
                DynamicObjectCollection entrys = new DynamicObjectCollection();
                for (DynamicObject evalObj : evalRecordList) {
                    item_ssr = item_ssr.add(evalObj.getBigDecimal("soe") == null ? BigDecimal.ZERO : evalObj.getBigDecimal("soe"));
                    DynamicObject newEvalObj = (DynamicObject)cloneUtils.clone((IDataEntityBase)evalObj);
                    entrys.add((Object)newEvalObj);
                }
                DynamicObject newAreaRecordObj = (DynamicObject)cloneUtils.clone((IDataEntityBase)addSubAreaRecordObj);
                newAreaRecordObj.set("flowrutask", (Object)taskId);
                newAreaRecordObj.set("flowrunode", taskFlowObj.get("flowrunode"));
                newAreaRecordObj.set("flowrurole", taskFlowObj.get("flowrurole"));
                newAreaRecordObj.set("flowruproc", taskFlowObj.get("flowruproc"));
                newAreaRecordObj.set("ssr", (Object)item_ssr);
                newAreaRecordObj.set("ssrec", (Object)item_ssr);
                newAreaRecordObj.set("creator", (Object)userId);
                newAreaRecordObj.set("createtime", (Object)now);
                newAreaRecordObj.set("modifier", (Object)userId);
                newAreaRecordObj.set("modifytime", (Object)now);
                newAreaRecordObj.set("entryentity", (Object)entrys);
                addSubAreaObjColls.add((Object)newAreaRecordObj);
            }
            OBJ_ADD_SUB_AREA_RECORD_ENTITY_SERVICE.save(addSubAreaObjColls);
        }
    }

    public DynamicObject[] queryGenRecordByActEvalObjId(Long actEvalObjId) {
        QFilter taskFilter = new QFilter("actevalobj", "in", (Object)actEvalObjId);
        QFilter taskStatus = new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        return GEN_AREA_RECORD_ENTITY.query("id, flowrutask, flowrutask.taskstatu, flowrutask.handler, flowrunode, flowrurole", new QFilter[]{taskFilter, taskStatus}, "modifytime desc");
    }

    public DynamicObject[] queryGenRecordByActEvalObjId(Long actEvalObjId, Long flowRuProcId) {
        QFilter taskFilter = new QFilter("actevalobj", "in", (Object)actEvalObjId);
        QFilter taskStatus = new QFilter("flowrutask.taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        QFilter flowRuProc = new QFilter("flowruproc", "=", (Object)flowRuProcId);
        return GEN_AREA_RECORD_ENTITY.query("id, flowrutask, flowrutask.taskstatu, flowrutask.handler, flowrunode, flowrurole", new QFilter[]{taskFilter, taskStatus, flowRuProc}, "modifytime desc");
    }

    static {
        AREA_INDICATOR_ENTITY_MAP.put(AreaRegEnum.NORM_INDCTR_AREA, GEN_AREA_INDICATOR_ENTITY);
        AREA_INDICATOR_ENTITY_MAP.put(AreaRegEnum.PLUS_MINUS_AREA, ADD_SUB_AREA_INDICATOR_ENTITY);
        AREA_INDICATOR_ENTITY_MAP.put(AreaRegEnum.ATTACH_AREA, ATTACH_AREA_INDICATOR_ENTITY);
        GEN_EVAL_RECORD_ENTITY = ObjGenEvalRecordEntityService.getInstance();
        ADD_SUB_EVAL_RECORD_ENTITY = ObjAddSubEvalRecordEntityService.getInstance();
        ATTACH_EVAL_RECORD_ENTITY = ObjAttachEvalRecordEntityService.getInstance();
        IND_RECORD_ENTITY_MAP = new HashMap<AreaRegEnum, OpmcEntityService>(16);
        IND_RECORD_ENTITY_MAP.put(AreaRegEnum.NORM_INDCTR_AREA, GEN_EVAL_RECORD_ENTITY);
        IND_RECORD_ENTITY_MAP.put(AreaRegEnum.PLUS_MINUS_AREA, ADD_SUB_EVAL_RECORD_ENTITY);
        IND_RECORD_ENTITY_MAP.put(AreaRegEnum.ATTACH_AREA, ATTACH_EVAL_RECORD_ENTITY);
        ACT_EVAL_OBJ_OVERALL_APPLICATION_SERVICE = ActEvalObjOverallApplicationService.getInstance();
        AREA_RECORD_ENTITYSERVICE_MAP = new HashMap<Long, OpmcEntityService>(16);
        AREA_RECORD_ENTITYSERVICE_MAP.put(AssessRuleConstants.NORM_INDCTR_AREA_PK, GEN_AREA_RECORD_ENTITY);
        AREA_RECORD_ENTITYSERVICE_MAP.put(AssessRuleConstants.PLUS_MINUS_AREA_PK, ADD_SUBAREA_RECORD_ENTITY);
        AREA_RECORD_ENTITYSERVICE_MAP.put(AssessRuleConstants.ATTACH_AREA_PK, ATTACH_AREA_RECORD_ENTITY);
        AREA_RECORD_ENTITYSERVICE_MAP.put(AssessRuleConstants.CUSTOM_AREA_PK, CUSTOM_AREA_RECORD_ENTITY);
        AREA_RECORD_ENTITYSERVICE_MAP.put(AssessRuleConstants.SUM_AREA_PK, SUM_AREA_RECORD_ENTITY);
        ACTEVAL_OBJ_AREAENTITY_SERVICE = ActevalObjAreaEntityService.getInstance();
        SYNC_FIELDS = new String[]{"initdatasource", "initstatus", "initbatch", "ole", "ose", "eval", "actevalobj", "assessyear", "assessperiod", "activity", "perforg", "creator", "modifier"};
        CUSTOM_SYNC_FIELDS = new String[]{"initdatasource", "initstatus", "initbatch", "assessyear", "assessperiod", "activity", "perforg", "actevalobj", "areaconf", "creator", "modifier"};
        CUSTOM_LANG_FIELDS = new String[]{"customfield1", "customfield2", "customfield3", "customfield5", "customfield6", "customfield7", "customfield8"};
        CUSTOM_ATTACH_FIELDS = new String[]{"customfield4", "customfield9", "customfield10"};
        ATTACH_FIELDS = new String[]{"initdatasource", "initstatus", "initbatch", "assessyear", "assessperiod", "activity", "perforg", "actevalobj", "area", "creator", "modifier"};
        ATTACH_SYNC_ENTRYFIELDS = new String[]{"indicator", "indarea", "indassessyear", "indassessperiod", "indactivity", "indperforg", "indactevalobj", "seq", "indcreator", "indmodifier"};
        ADDSUB_FIELDS = new String[]{"initdatasource", "initstatus", "initbatch", "ssrec", "assessyear", "assessperiod", "activity", "ssr", "perforg", "actevalobj", "minareascore", "maxareascore", "area", "creator", "modifier"};
        ADDSUB_SYNC_ENTRYFIELDS = new String[]{"indicator", "evaldesc", "indarea", "indassessyear", "indassessperiod", "indactivity", "indperforg", "indactevalobj", "soe", "seq", "indcreator", "indmodifier"};
        GEN_FIELDS = new String[]{"initdatasource", "initstatus", "initbatch", "ssrec", "assessyear", "assessperiod", "activity", "ssr", "perforg", "actevalobj", "flowruproc", "minareascore", "maxareascore", "area", "creator", "modifier"};
        GEN_SYNC_ENTRYFIELDS = new String[]{"indicator", "evaldesc", "indarea", "indassessyear", "indassessperiod", "indactivity", "indperforg", "indactevalobj", "soe", "adjustval", "seq", "iscanedit", "indcreator", "indmodifier"};
    }
}

